"""
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

"""
Test the Hines integration method using the Antal/Emri TC model.
"""

import sys
#sys.path = ['C:\Documents and Settings\evan\My Documents\Visual Studio Projects\parplex']+sys.path

from random import choice
from time import clock
from re import match
from math import pi
from p3 import *

from tc import TCneuron, simpleCell
from support import *

#set_message_option('debug')
duration = 500

defM8\09d5
    """Turn on tracing for the a dendrite"""
    cell.soma.emtrace = True
    cell.level6_a[0][-1].emtrace = True
    #try:
        #    cell.level1_abc[0][0].emtrace = True
        #    cell.level1_abc[0][-1].emtrace = True
        #for c in cell.level1_abc[0]: c.emtrace = True
        #    for c in cell.level2_a[0]:   c.emtrace = True
        #    cell.level3_a[0].emtrace = True
        #    for c in cell.level4_a[0]:   c.emtrace = True
        #    for c in cell.level5_a[0]:   c.emtrace = True
        #    for c in cell.level6_a[0]:   c.emtrace = True
        #cell.level6_a[0][0].emtrace = True
        #cell.level6_a[0][-1].emtrace = True
    #except AttributeError:
    #    pass
    #except IndexError:
    #    pass

def makecell():
    cell = TCne"ɓa,#    cell = simpleCell()

    setTrace(cell)
    area = pi * cell.soma.dia * cell.soma.length
    if len(sys.argv)==1:
        Iinject = 1000
    else:
        Iinject = float(sys.argv[1])
    cell.current.Iinject = Iinject * area
    cell.stepTrace = True
    message_print(info, 'Cell with %d compartments and %d state variables.\n' % \
                  (len(cell.compartments), len(cell.Y)))
    return cell

###############
# Run options #
###############
#trfn = 'trace_%g' % Iinject
trfn = 'trace'
setTRfilename(trfn)
gd = GD()
gd.duration  = duration
gd.tolerance = 1e-2
gd.network = [makecell(), makecell()]
gd.ap_handler = None
gd.trace_handler = trace_print
gd.endWindow_handler = TimeTicker
gd.stepTrace_handler = stepTicker

gd.network[0].method = hines
gd.network[0].timeSample = 0
gd.network[1].method = rw23
gd.network[1].timeSample = 0.5


#######
# Run #
#######
try:
    start = clock()
    parplex(gd)
except ParplexRuntimeError:
    (e, v) = sys.exc_info()[:2]
    cell = e.currentCell
    message_print(fatal, 'Caught ParplexRuntimeError: %s\n' % v)
    #dumpcell(cell, fatal)
    message_print(fatal, 'Didn\'t make it\n')
    sys.exit(0)

message_print(info, 'made it in %fs\n' % (clock()-start))

message_print(info, 'Integration stats:\n')
for cell in gd.network:
    dumpSolverStats(cell, info)

try:
    from py2mat import Matwrap
    m = Matwrap()
    m.closeOnDel = False
    m.write('cd \'' + os.getcwd() + '\'')
    m.write('figure(1);traceplot(\'%s.dat\');\n' % trfn)
except:
    pass
