"""
 * Copyright (C) 2004 Evan Thomas
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

"""
Test the C implementation of the Tiesinga, et al network
try to generate fig 3
"""

import sys
from random import choice
from time import clock
from p3 import *

def makecell(t):
    cell = Cell()

    cell.capacitance = 3
    cell.Em = -60
    cell.timeSample = 0
    cell.emtrace = True

    d = hhLeak(cell)
    d.Er   = -60
    d.Gmax = 0.1

    if t=='pr':
        d      = prEPSP_C(cell)
        d.s    = 0
        d.gSyn = 0.1
        d.VSyn = 0
        f      = 1

    if t=='alpha':
        d      = fastEPSP(cell)
        d.Gmax = 0.1
        d.Er   = 0
        d.k    = 5000/80
        f      = 25

    d.enq(5, f)

    return cell

network = [makecell('pr'), makecell('alpha')]

###############
# Run options #
###############
setTRfilename('trace')
gd = GD()
gd.duration  = 200
gd.tolerance = 1e-4
gd.network = network

try:
    parplex(gd)
except ParplexRuntimeError:
    (e, v) = sys.exc_info()[:2]
    cell = e.currentCell
    message_print(fatal, 'Caught ParplexRuntimeError: %s\n' % v)
    dumpcell(cell, fatal)
    message_print(fatal, 'Didn\'t make it\n')
    sys.exit(0)

set_message_option('info')
message_print(info, 'made it\n')


from py2mat import Matwrap
m = Matwrap()
m.closeOnDel = False
m.write('cd \'' + os.getcwd() + '\'')
m.write('figure;traceplot(\'trace.dat\')\n')
print m.read()
