/*
 * Decompiled with CFR 0.152.
 */
package com.bptripp.diff;

import ca.nengo.math.Function;
import ca.nengo.math.PDF;
import ca.nengo.math.impl.AbstractFunction;
import ca.nengo.math.impl.ConstantFunction;
import ca.nengo.math.impl.GaussianPDF;
import ca.nengo.math.impl.LinearCurveFitter;
import ca.nengo.math.impl.PiecewiseConstantFunction;
import ca.nengo.model.Node;
import ca.nengo.model.SimulationException;
import ca.nengo.model.StructuralException;
import ca.nengo.model.Termination;
import ca.nengo.model.Units;
import ca.nengo.model.impl.FunctionInput;
import ca.nengo.model.impl.NetworkImpl;
import ca.nengo.model.nef.NEFEnsemble;
import ca.nengo.util.MU;
import ca.nengo.util.Probe;
import ca.nengo.util.TimeSeries;

public class Util {
    public static Function RAMP = new AbstractFunction(1){
        private static final long serialVersionUID = 1L;
        private PDF myNoisePDF = new GaussianPDF(0.0f, 2.5E-4f);

        public float map(float[] from) {
            return this.myNoisePDF.sample()[0] + 0.75f * Math.max(0.0f, (double)from[0] < 1.5 ? from[0] - 0.5f : 2.5f - from[0]);
        }
    };

    public static Function getBiasCompensation(NEFEnsemble ensemble, String origin, float transientTime) throws StructuralException, SimulationException {
        float simulationTime = transientTime * 2.0f + 0.2f;
        float endTime = simulationTime * 0.95f;
        NetworkImpl network = new NetworkImpl();
        Termination t = ensemble.addDecodedTermination("laskdjhcuwyge19238479DLSKFASDKFJH", MU.I((int)1), 0.001f, false);
        network.addNode((Node)ensemble);
        FunctionInput input = new FunctionInput("testinput", new Function[]{new ConstantFunction(1, 0.0f)}, Units.UNK);
        network.addNode((Node)input);
        network.addProjection(input.getOrigin("origin"), t);
        Probe pOut = network.getSimulator().addProbe(ensemble.getName(), origin, true);
        float[] x = MU.makeVector((float)-1.0f, (float)0.1f, (float)1.0f);
        float[] compensation = new float[x.length];
        int i = 0;
        while (i < x.length) {
            PiecewiseConstantFunction f = new PiecewiseConstantFunction(new float[]{0.1f}, new float[]{0.0f, x[i]});
            input.setFunctions(new Function[]{f});
            network.reset(false);
            network.run(0.0f, simulationTime);
            TimeSeries output = pOut.getData();
            float sum = 0.0f;
            float count = 0.0f;
            int j = 0;
            while (j < output.getTimes().length) {
                if (output.getTimes()[j] >= transientTime && output.getTimes()[j] <= endTime) {
                    count += 1.0f;
                    sum += output.getValues()[j][0];
                }
                ++j;
            }
            compensation[i] = -sum / count;
            pOut.reset();
            network.reset(false);
            ++i;
        }
        ensemble.removeDecodedTermination(t.getName());
        return new LinearCurveFitter().fit(x, compensation);
    }
}

