/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.gui;

import java.awt.image.BufferedImage;
import org.catacomb.dataview.display.ViewConfig;
import org.catacomb.dataview.formats.DataHandler;
import org.catacomb.druid.gui.base.DruDataDisplay;
import org.catacomb.druid.gui.edit.DruListPanel;
import org.catacomb.interlish.annotation.IOPoint;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.report.E;

public class DViewPlotController
implements Controller {
    @IOPoint(xid="dataDisplay")
    public DruDataDisplay dataDisplay;
    @IOPoint(xid="plots")
    public DruListPanel plotsList;
    private DataHandler dataHandler;

    public void setDataHandler(DataHandler dh) {
        this.dataHandler = dh;
        this.dataDisplay.attachGraphicsController(dh);
        this.dataDisplay.setXAxisLabel(dh.getXAxisLabel());
        this.dataDisplay.setYAxisLabel(dh.getYAxisLabel());
        this.plotsList.setItems(dh.getPlotNames());
        this.repaint();
    }

    public void showPlot(String s) {
        this.dataHandler.setPlot(s);
        ViewConfig vc = this.dataHandler.getViewConfig(s);
        if (vc == null) {
            E.warning("no such view " + vc);
        } else {
            this.dataDisplay.setLimits(vc.getLimits());
        }
    }

    @Override
    public void attached() {
        this.repaint();
    }

    public void repaint() {
        this.dataDisplay.repaint();
    }

    public void setViewSize(int w, int h) {
        this.dataDisplay.setSize(w, h);
    }

    public BufferedImage getSnapshot() {
        return this.dataDisplay.getSnapshot();
    }
}

