/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.model;

import java.io.File;
import java.util.ArrayList;
import org.catacomb.dataview.display.Displayable;
import org.catacomb.dataview.display.PolyLine;
import org.catacomb.dataview.model.Plottable;
import org.catacomb.numeric.data.AsciiIO;
import org.catacomb.numeric.data.DataTable;
import org.catacomb.report.E;

public class LineSet
extends Plottable {
    @Override
    public ArrayList<Displayable> getDisplayables(File fdir) {
        ArrayList<Displayable> ret = new ArrayList<Displayable>();
        File f = new File(fdir, this.file);
        if (!f.exists()) {
            E.warning("no such file " + f);
            return ret;
        }
        DataTable tbl = AsciiIO.readTable(f);
        int ncol = tbl.getNColumn();
        double[] sf = this.getScaleFactors(ncol);
        double[] xpts = this.scaleColumn(tbl.getColumn(0), sf[0]);
        if (this.function == null || this.function.length() == 0) {
            int i = 1;
            while (i < ncol) {
                PolyLine pline = new PolyLine("tbl", this.getColor(), xpts, this.scaleColumn(tbl.getColumn(i), sf[i]), this.width);
                ret.add(pline);
                ++i;
            }
        } else if (this.function.equals("mean")) {
            double[] ypts = new double[xpts.length];
            int i = 1;
            while (i < ncol) {
                double[] c = this.scaleColumn(tbl.getColumn(i), sf[i]);
                int j = 0;
                while (j < xpts.length) {
                    int n = j;
                    ypts[n] = ypts[n] + c[j];
                    ++j;
                }
                ++i;
            }
            int j = 0;
            while (j < xpts.length) {
                int n = j++;
                ypts[n] = ypts[n] / (double)(ncol - 1);
            }
            PolyLine pline = new PolyLine("tbl", this.getColor(), xpts, ypts, this.width);
            ret.add(pline);
        } else {
            E.error("unrecognized function: " + this.function + " (only 'mean' is allowed so far)");
        }
        return ret;
    }
}

