/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.read;

import org.catacomb.dataview.read.ContentReader;
import org.catacomb.dataview.read.ContentType;
import org.catacomb.dataview.read.CustomJarContentType;
import org.catacomb.dataview.read.FUImportContext;
import org.catacomb.dataview.read.NumericContentType;
import org.catacomb.dataview.read.XMLContentType;
import org.catacomb.report.E;

public class ResourceImporter {
    ContentType[] types = new ContentType[3];

    public ResourceImporter() {
        int i = 0;
        this.types[i++] = new XMLContentType();
        this.types[i++] = new NumericContentType();
        this.types[i++] = new CustomJarContentType();
    }

    public ContentReader getReader(byte[] ba, FUImportContext ctxt) {
        byte[] hdr = new byte[256];
        if (ba.length < hdr.length) {
            System.arraycopy(ba, 0, hdr, 0, ba.length);
        } else {
            System.arraycopy(ba, 0, hdr, 0, hdr.length);
        }
        ContentType ctype = this.getContentType(hdr);
        return ctype.makeReader(ba, ctxt);
    }

    public ContentType getContentType(byte[] ba) {
        ContentType ret = null;
        int i = 0;
        while (i < this.types.length) {
            if (this.types[i].claims(ba)) {
                ret = this.types[i];
                break;
            }
            ++i;
        }
        if (ret == null) {
            E.error("no type claimed - assuming jar ");
            ret = new CustomJarContentType();
        }
        return ret;
    }
}

