/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.blocks;

import java.util.ArrayList;
import org.catacomb.druid.blocks.Dialog;
import org.catacomb.druid.blocks.Frame;
import org.catacomb.druid.blocks.HTMLContent;
import org.catacomb.druid.blocks.Requisite;
import org.catacomb.druid.blocks.SplashScreen;
import org.catacomb.druid.blocks.TableTree;
import org.catacomb.druid.blocks.Wizard;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.build.GUIPath;
import org.catacomb.druid.build.Realizer;
import org.catacomb.druid.gui.base.DruApplication;
import org.catacomb.druid.gui.base.DruFrame;
import org.catacomb.druid.gui.base.DruTooltips;
import org.catacomb.druid.guimodel.Log;
import org.catacomb.interlish.structure.AddableTo;
import org.catacomb.interlish.version.BuildInfo;
import org.catacomb.report.E;

public class Application
implements AddableTo,
Realizer {
    public String name;
    public String versionNumber;
    public String id;
    public String controllerClass;
    public int background;
    public SplashScreen splashScreen;
    public boolean logging;
    public boolean stateExposure;
    public HTMLContent doc;
    public Frame frame;
    public ArrayList<Requisite> requisites = new ArrayList();
    public ArrayList<Dialog> dialogs;
    public ArrayList<Wizard> wizards = new ArrayList();

    public Application() {
        this.dialogs = new ArrayList();
    }

    @Override
    public Object realize(Context ctx, GUIPath gpathin) {
        GUIPath gpath = gpathin;
        DruTooltips.init();
        gpath = gpath.extend(this.id);
        DruFrame druFrame = (DruFrame)this.frame.realize(ctx, gpath);
        druFrame.setTitle(String.valueOf(this.name) + " " + BuildInfo.getInfo().getTitleDate());
        DruApplication druapp = new DruApplication();
        druapp.setControllerPath(this.controllerClass);
        druapp.setName(this.name);
        druapp.setMainFrame(druFrame);
        if (this.doc != null) {
            druapp.setDoc(this.doc.getContent());
        }
        if (this.dialogs != null) {
            for (Dialog dlg : this.dialogs) {
                dlg.realize(druFrame, ctx, gpath);
            }
        }
        ctx.addComponent(druapp, gpath);
        BuildInfo bi = BuildInfo.getInfo();
        bi.setName(this.name);
        bi.setNum(this.versionNumber);
        bi.printIntro();
        Log log = new Log("default");
        Log.setSystemLog(log);
        ctx.getMarketplace().global().addReceiver("LogMessage", log, "default");
        if (this.logging) {
            ctx.getMarketplace().global().addProducer("Log", log, "default");
        }
        if (this.stateExposure) {
            E.missing("cant do state exposure");
        }
        if (this.requisites != null) {
            for (Requisite requ : this.requisites) {
                requ.realize(ctx, gpath);
            }
        }
        ctx.getMarketplace().logUnresolved();
        ctx.getMarketplace().global().logUnresolved();
        Log.infoMsg("startup", BuildInfo.getInfo().getIntro());
        return druapp;
    }

    @Override
    public void add(Object obj) {
        if (obj instanceof TableTree) {
            E.missing();
        } else if (obj instanceof Requisite) {
            this.requisites.add((Requisite)obj);
        } else if (obj instanceof Dialog) {
            this.dialogs.add((Dialog)obj);
        } else if (obj instanceof Wizard) {
            this.wizards.add((Wizard)obj);
        } else if (obj instanceof Frame) {
            this.frame = (Frame)obj;
        } else {
            E.error("cant add " + obj);
        }
    }
}

