/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.blocks;

import java.util.ArrayList;
import org.catacomb.druid.blocks.Panel;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.build.GUIPath;
import org.catacomb.druid.build.Realizer;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.druid.gui.base.DruSplitterBar;
import org.catacomb.druid.gui.base.PanelWrapper;
import org.catacomb.druid.gui.edit.DruMenu;
import org.catacomb.interlish.structure.AddableTo;
import org.catacomb.report.E;

public abstract class MultiPanel
extends Panel
implements AddableTo {
    public ArrayList<Realizer> realizers;
    public int xspace = 0;
    public int yspace = 0;

    @Override
    public void add(Object obj) {
        if (this.realizers == null) {
            this.realizers = new ArrayList();
        }
        if (obj instanceof Realizer) {
            this.realizers.add((Realizer)obj);
        } else {
            E.error("cant add non-realizer " + obj + " to " + this);
        }
    }

    public void checkPanelCount(int np) {
        if (this.getPanelCount() != np) {
            E.warning("wrong number of panels - got " + this.getPanelCount() + " but need " + np);
        }
    }

    public int getPanelCount() {
        int npan = 0;
        if (this.realizers != null) {
            npan = this.realizers.size();
        }
        return npan;
    }

    @Override
    public void populatePanel(DruPanel dp, Context ctx, GUIPath gpath) {
        if (this.realizers != null) {
            for (Realizer rlz : this.realizers) {
                Object panobj = rlz.realize(ctx, gpath);
                if (panobj instanceof DruPanel) {
                    dp.addPanel((DruPanel)panobj);
                    continue;
                }
                if (panobj instanceof PanelWrapper) {
                    DruPanel dpw = ((PanelWrapper)panobj).getPanel();
                    dp.addPanel(dpw);
                    continue;
                }
                if (panobj instanceof DruMenu) {
                    dp.addMenu((DruMenu)panobj);
                    continue;
                }
                if (panobj instanceof DruSplitterBar) {
                    dp.addDComponent(((DruSplitterBar)panobj).getGUIPeer());
                    continue;
                }
                E.error(" (Druid build) - non-panel object in MultiPanel " + panobj + " " + panobj.getClass().getName());
            }
        }
    }
}

