/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.chunk;

import java.io.File;
import org.catacomb.druid.dialog.Dialoguer;
import org.catacomb.druid.gui.edit.DruSlider;
import org.catacomb.interlish.annotation.IOPoint;
import org.catacomb.interlish.report.Logger;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.interlish.structure.MovieController;
import org.catacomb.interlish.structure.MovieOperator;
import org.catacomb.report.E;

public class MoviePlayController
implements Controller,
MovieController {
    @IOPoint(xid="slider")
    public DruSlider slider;
    MovieOperator moperator;

    @Override
    public void setMovieOperator(MovieOperator mop) {
        this.moperator = mop;
        this.moperator.setMovieStateDisplay(this);
        if (this.slider != null) {
            this.slider.setNFrame(this.moperator.getNFrame());
        }
    }

    @Override
    public void syncFromOperator() {
        this.slider.setNFrame(this.moperator.getNFrame());
    }

    @Override
    public void attached() {
        if (this.slider != null && this.moperator != null) {
            E.info("slider setting nframe " + this.moperator.getNFrame());
            this.slider.setNFrame(this.moperator.getNFrame());
        }
    }

    public void play() {
        this.moperator.start();
    }

    public void rewind() {
        this.moperator.reset();
    }

    public void pause() {
        this.moperator.pauseDePause();
    }

    public void faster() {
        this.moperator.faster();
    }

    public void slower() {
        this.moperator.slower();
    }

    public void stop() {
        this.moperator.stop();
    }

    public void record() {
        File f = Dialoguer.getFileToWrite("output");
        if (f != null) {
            Logger pl = Dialoguer.getProgressLogger();
            this.moperator.record(f, pl);
        }
    }

    public void jumpToFrame(int ifr) {
        E.info("mop jtf " + ifr);
        this.moperator.showFrame(ifr);
    }

    @Override
    public void frameChangedTo(int ifr, String desc) {
        this.slider.pointShown(ifr, desc);
    }

    public void sliderMoved() {
        int ifr = this.slider.getValue();
        this.moperator.showFrame(ifr);
    }

    public void sliderMoved(String s) {
        this.sliderMoved();
    }

    @Override
    public void setIsPaused() {
    }
}

