/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.market;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.catacomb.druid.market.ConsumerAgent;
import org.catacomb.interlish.structure.Consumer;
import org.catacomb.interlish.structure.Producer;
import org.catacomb.interlish.structure.Provider;
import org.catacomb.interlish.structure.Receiver;
import org.catacomb.interlish.structure.Supplier;
import org.catacomb.interlish.structure.Viewer;
import org.catacomb.interlish.structure.Visible;
import org.catacomb.report.E;

public abstract class ProducerConsumerBoard {
    HashMap<String, ArrayList<Producer>> producers = new HashMap();
    HashMap<String, Consumer> consumers = new HashMap();
    HashMap<String, Receiver> receivers = new HashMap();
    HashMap<String, Provider> providers = new HashMap();
    HashMap<String, Visible> visibles;
    HashMap<String, ArrayList<Viewer>> viewers;
    ArrayList<Supplier> suppliers = new ArrayList();
    String modality;

    public ProducerConsumerBoard() {
        this.visibles = new HashMap();
        this.viewers = new HashMap();
    }

    public void setModality(String s) {
        this.modality = s;
    }

    public void addProducer(Producer producer, String flavor) {
        if (this.consumers.containsKey(flavor)) {
            this.connect(producer, this.consumers.get(flavor));
            this.consumers.remove(flavor);
        } else if (this.receivers.containsKey(flavor)) {
            this.connect(producer, this.receivers.get(flavor));
        } else if (this.producers.containsKey(flavor)) {
            this.producers.get(flavor).add(producer);
        } else {
            ArrayList<Producer> alp = new ArrayList<Producer>();
            alp.add(producer);
            this.producers.put(flavor, alp);
        }
    }

    public void addConsumer(Consumer consumer, String flavor) {
        if (this.producers.containsKey(flavor)) {
            ArrayList<Producer> alp = this.producers.get(flavor);
            if (alp.size() > 1) {
                E.error("muptiple producdrs of " + flavor + " in " + this.modality + ": need a receiver " + "but got a consumer: " + consumer);
            }
            this.connect(alp.get(0), consumer);
            this.producers.remove(flavor);
        } else if (this.providers.containsKey(flavor)) {
            this.connect(this.providers.get(flavor), consumer);
        } else if (!this.checkSuppliersFor(consumer, flavor)) {
            this.consumers.put(flavor, consumer);
        }
    }

    public void addReceiver(Receiver rec, String flavor) {
        if (this.receivers.containsKey(flavor)) {
            E.error("multiple receivers of " + flavor + " only last one used " + rec);
        }
        this.receivers.put(flavor, rec);
        this.checkReceiverProducers(rec, flavor);
    }

    public void addSupplier(Supplier sup) {
        if (this.suppliers == null) {
            this.suppliers = new ArrayList();
        }
        this.suppliers.add(sup);
        this.checkConsumerSuppliers();
    }

    private void checkReceiverProducers(Receiver rec, String flav) {
        if (this.producers.containsKey(flav)) {
            for (Producer p : this.producers.get(flav)) {
                this.connect(p, rec);
            }
            this.producers.remove(flav);
        }
    }

    private void checkConsumerSuppliers() {
        if (this.consumers != null) {
            for (Map.Entry<String, Consumer> me : this.consumers.entrySet()) {
                this.checkSuppliersFor(me.getValue(), me.getKey());
            }
        }
    }

    private boolean checkSuppliersFor(Consumer c, String item) {
        boolean ret = false;
        if (this.suppliers != null) {
            for (Supplier sup : this.suppliers) {
                if (!sup.canSupply(this.modality, item)) continue;
                sup.addDependent(new ConsumerAgent(c, this.modality, item));
                ret = true;
                break;
            }
        }
        return ret;
    }

    public void connect(Producer producer, Consumer consumer) {
        E.override();
    }

    public void logUnresolved(String boardID) {
        this.logUnresolved(this.producers, "Producer", boardID);
        this.logUnresolved(this.consumers, "Consumer", boardID);
        this.logUnresolved(this.viewers, "Viewer", boardID);
    }

    private void logUnresolved(HashMap<?, ?> hm, String s, String boardID) {
    }

    public void addVisible(Visible vbl, String flavor) {
        if (this.visibles.containsKey(flavor)) {
            E.warning("visible item being overridden: modality=" + this.modality + " flavor=" + flavor + " item=" + this.visibles.get(flavor));
        }
        this.visibles.put(flavor, vbl);
        this.checkViewers(flavor, vbl);
    }

    public void addViewer(Viewer vwr, String flavor) {
        if (this.visibles.containsKey(flavor)) {
            this.connectVisibleViewer(this.visibles.get(flavor), vwr);
        } else if (this.viewers.containsKey(flavor)) {
            this.viewers.get(flavor).add(vwr);
        } else {
            ArrayList<Viewer> arv = new ArrayList<Viewer>();
            arv.add(vwr);
            this.viewers.put(flavor, arv);
        }
    }

    private void checkViewers(String flv, Visible vbl) {
        if (this.viewers.containsKey(flv)) {
            for (Viewer vwr : this.viewers.get(flv)) {
                this.connectVisibleViewer(vbl, vwr);
            }
            this.viewers.remove(flv);
        }
    }

    public void connectVisibleViewer(Visible vbl, Viewer vwr) {
        E.override();
    }

    public void addProvider(Provider provider, String flavor) {
        if (this.consumers.containsKey(flavor)) {
            this.connect(provider, this.consumers.get(flavor));
            this.consumers.remove(flavor);
        }
        if (this.providers.containsKey(flavor)) {
            E.warning("multiple providers of " + flavor + " " + this.modality);
        } else {
            this.providers.put(flavor, provider);
        }
    }
}

