/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import org.catacomb.druid.event.LabelActor;
import org.catacomb.druid.swing.DMenuItem;
import org.catacomb.druid.swing.RolloverEffect;
import org.catacomb.interlish.interact.DComponent;

public class DValueHistory
extends JButton
implements DComponent,
ActionListener,
LabelActor,
Icon,
MouseListener {
    static final long serialVersionUID = 1001L;
    LabelActor lact;
    JPopupMenu menu;
    ArrayList<String> values = new ArrayList();
    RolloverEffect rollover;

    public DValueHistory() {
        this(new String[0]);
    }

    public DValueHistory(String[] vals) {
        super("");
        this.setIcon(this);
        this.rollover = new RolloverEffect(this);
        this.addMouseListener(this.rollover);
        this.addActionListener(this);
        this.addMouseListener(this);
        this.setFocusPainted(false);
        this.setOptions(vals);
    }

    public void setBg(Color c) {
        this.setBackground(c);
        this.menu.setBackground(c);
        this.rollover.setBg(c);
    }

    public void checkContains(String s) {
        if (!this.values.contains(s)) {
            this.values.add(0, s);
            this.checkSize();
            this.updateOptions();
        }
    }

    public void setOptions(String[] vals) {
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!this.values.contains(s)) {
                this.values.add(0, s);
            }
            ++n2;
        }
        this.checkSize();
        this.updateOptions();
    }

    private void checkSize() {
        if (this.values.size() > 12) {
            int i = this.values.size() - 1;
            while (i >= 12) {
                this.values.remove(i);
                --i;
            }
        }
    }

    public void updateOptions() {
        this.menu = new JPopupMenu();
        DMenuItem dminone = new DMenuItem("none");
        dminone.setLabelActor(this);
        this.menu.add(dminone);
        this.menu.addSeparator();
        for (String s : this.values) {
            DMenuItem dmi = new DMenuItem(s);
            dmi.setLabelActor(this);
            this.menu.add(dmi);
        }
    }

    @Override
    public void labelAction(String s, boolean b) {
        this.deliverAction(s, true);
    }

    @Override
    public void actionPerformed(ActionEvent aev) {
    }

    public void stateChanged(ChangeEvent cev) {
    }

    public void showMenu() {
        this.menu.show(this, 0, 18);
    }

    public void setLabelActor(LabelActor bl) {
        this.lact = bl;
    }

    public void deliverAction(String s, boolean b) {
        if (this.lact != null) {
            this.lact.labelAction(s, b);
        }
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        JComponent component = (JComponent)c;
        int iconWidth = this.getIconWidth();
        g.translate(x, y);
        g.setColor(component.isEnabled() ? Color.gray : Color.blue);
        g.drawLine(2, 0, iconWidth - 1, 0);
        g.drawLine(3, 1, 1 + (iconWidth - 3), 1);
        g.drawLine(5, 3, 3 + (iconWidth - 7), 3);
        g.drawLine(6, 4, 4 + (iconWidth - 9), 4);
        g.translate(-x, -y);
    }

    @Override
    public int getIconWidth() {
        return 12;
    }

    @Override
    public int getIconHeight() {
        return 5;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showMenu();
    }

    @Override
    public void setTooltip(String s) {
    }
}

