/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.drawing;

import org.catacomb.graph.drawing.FixedDrawingComponent;
import org.catacomb.graph.drawing.Shape;
import org.catacomb.graph.gui.Painter;

public class Oval
extends FixedDrawingComponent {
    public double x;
    public double y;
    public double rx;
    public double ry;

    public void setSize(double sx, double sy) {
        this.rx = sx;
        this.ry = sy;
    }

    @Override
    public void instruct(Painter p, double offx, double offy, double scale) {
        double w = this.getWidth();
        if (this.isFilled()) {
            p.drawFilledOval(offx + scale * this.x, offy + scale * this.y, scale * this.rx, scale * this.ry, this.getFillColor(), this.getColor(), w, this.widthIsPixels());
        } else if (w > 0.5) {
            p.drawOval(offx + scale * this.x, offy + scale * this.y, scale * this.rx, scale * this.ry, this.getColor(), w, this.widthIsPixels());
        }
    }

    @Override
    public void applyToShape(Shape shp) {
        shp.setCurviness(1.0);
        this.applySymmetryToShape(shp);
        double[] xpts = new double[]{this.x - this.rx, this.x - this.rx, this.x + this.rx, this.x + this.rx};
        double[] ypts = new double[]{this.y - this.ry, this.y + this.ry, this.y + this.ry, this.y - this.ry};
        shp.setXpts(xpts);
        shp.setYpts(ypts);
    }

    public void applySymmetryToShape(Shape shp) {
        shp.setSymmetry(1);
    }
}

