/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.catacomb.graph.gui.AboveBelowSplitPanel;
import org.catacomb.graph.gui.BasePanel;
import org.catacomb.graph.gui.BuildPaintInstructor;
import org.catacomb.graph.gui.CornerPanel;
import org.catacomb.graph.gui.Demo1;
import org.catacomb.graph.gui.GraphColors;
import org.catacomb.graph.gui.LeftRightSplitPanel;
import org.catacomb.graph.gui.PaintInstructor;
import org.catacomb.graph.gui.PickListener;
import org.catacomb.graph.gui.PickWorldCanvas;
import org.catacomb.graph.gui.RangeListener;
import org.catacomb.graph.gui.XAxisCanvas;
import org.catacomb.graph.gui.YAxisCanvas;
import org.catacomb.interlish.structure.ModeSettable;
import org.catacomb.interlish.structure.RangeWatcher;
import org.catacomb.report.E;

public class DataDisplay
extends BasePanel
implements ModeSettable,
RangeListener {
    static final long serialVersionUID = 1001L;
    XAxisCanvas xAxisCanvas;
    YAxisCanvas yAxisCanvas;
    PickWorldCanvas pwCanvas;
    CornerPanel cornerPanel;
    BasePanel controlPanel;
    AboveBelowSplitPanel ab1;
    AboveBelowSplitPanel ab2;
    LeftRightSplitPanel lr;
    GraphColors gcols = new GraphColors();
    Dimension prefDim;
    RangeWatcher rangeWatcher;
    static boolean interactive = true;

    public static void setBatch() {
        interactive = false;
    }

    public DataDisplay(int w, int h) {
        int leftmargin = 64;
        int bottommargin = 22;
        this.xAxisCanvas = new XAxisCanvas(w - leftmargin, bottommargin);
        this.yAxisCanvas = new YAxisCanvas(leftmargin, h - bottommargin);
        this.pwCanvas = new PickWorldCanvas(w - leftmargin, h - bottommargin, interactive);
        this.cornerPanel = new CornerPanel(leftmargin, bottommargin, this.pwCanvas);
        this.ab1 = new AboveBelowSplitPanel(this.yAxisCanvas, this.cornerPanel, this.gcols);
        this.ab2 = new AboveBelowSplitPanel(this.pwCanvas, this.xAxisCanvas, this.gcols);
        this.ab1.setResizeWeight(1.0);
        this.ab2.setResizeWeight(1.0);
        this.setPrefSize(w, h);
        this.ab1.setSplitPanelFollower(this.ab2);
        this.ab2.setSplitPanelFollower(this.ab1);
        this.lr = new LeftRightSplitPanel(this.ab1, this.ab2, this.gcols);
        this.lr.setResizeWeight(0.1);
        this.setLayout(new BorderLayout(0, 0));
        this.add("Center", this.lr);
        this.pwCanvas.addRangeListener(this.xAxisCanvas);
        this.pwCanvas.addRangeListener(this.yAxisCanvas);
    }

    public void repaintAll() {
        this.xAxisCanvas.invalidate();
        this.yAxisCanvas.invalidate();
        this.validateTree();
        this.xAxisCanvas.repaint();
        this.yAxisCanvas.repaint();
        this.repaint();
    }

    public void addRangeWatcher(RangeWatcher rw) {
        if (this.rangeWatcher == null) {
            this.pwCanvas.addRangeListener(this);
            this.rangeWatcher = rw;
        } else {
            E.error("cant add another range watcher - already watching");
        }
    }

    @Override
    public void rangeChanged(int mode, double[] newLimits) {
        if (this.rangeWatcher != null) {
            this.rangeWatcher.rangeChanged();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefDim;
    }

    @Override
    public void setBg(Color c) {
        this.setDataBg(c);
        this.setBorderBg(c.brighter());
    }

    public void setDataBg(Color c) {
        this.gcols.setGraphBg(c);
        this.pwCanvas.setBg(c);
    }

    public void setBorderBg(Color c) {
        this.gcols.setBorderBg(c);
        this.xAxisCanvas.setBg(c);
        this.yAxisCanvas.setBg(c);
        this.cornerPanel.setBg(c);
    }

    @Override
    public void setMode(String dom, String mod) {
        this.pwCanvas.setMode(dom, mod);
    }

    @Override
    public void setMode(String dom, boolean b) {
        this.pwCanvas.setMode(dom, b);
    }

    public void setPaintInstructor(PaintInstructor pi) {
        this.pwCanvas.setPaintInstructor(pi);
    }

    public void setBuildPaintInstructor(BuildPaintInstructor bpi) {
        this.pwCanvas.setBuildPaintInstructor(bpi);
    }

    public void setPickListener(PickListener pl) {
        this.pwCanvas.setPickListener(pl);
    }

    public void attach(Object obj) {
        boolean done = false;
        if (obj instanceof BuildPaintInstructor) {
            this.setBuildPaintInstructor((BuildPaintInstructor)obj);
            done = true;
        } else if (obj instanceof PaintInstructor) {
            this.setPaintInstructor((PaintInstructor)obj);
            done = true;
        }
        if (obj instanceof PickListener) {
            this.setPickListener((PickListener)obj);
            done = true;
        }
        if (!done) {
            E.error("cant attach " + obj + " to a data Display");
        }
    }

    public void setXAxisLabel(String lab) {
        this.xAxisCanvas.setLabel(lab);
    }

    public void setYAxisLabel(String lab) {
        this.yAxisCanvas.setLabel(lab);
    }

    public void setXAxis(String lab, double min, double max) {
        this.setXAxisLabel(lab);
        this.setXRange(min, max);
    }

    public void setYAxis(String lab, double min, double max) {
        this.setYAxisLabel(lab);
        this.setYRange(min, max);
    }

    public void setYRange(double min, double max) {
        this.pwCanvas.setYRange(min, max);
    }

    public void setLimits(double[] xyxy) {
        this.pwCanvas.setXRange(xyxy[0], xyxy[2]);
        this.pwCanvas.setYRange(xyxy[1], xyxy[3]);
        this.pwCanvas.requestRepaint();
    }

    public void setXRange(double low, double high) {
        this.pwCanvas.setXRange(low, high);
    }

    public double[] getXRange() {
        return this.pwCanvas.getXRange();
    }

    public double[] getYRange() {
        return this.pwCanvas.getYRange();
    }

    public void setFixedAspectRatio(double ar) {
        this.pwCanvas.setFixedAspectRatio(ar);
    }

    public void viewChanged() {
        if (this.pwCanvas != null) {
            this.pwCanvas.repaint();
        }
    }

    public void reframe() {
        this.pwCanvas.reframe();
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame();
        DataDisplay wc = new DataDisplay(500, 300);
        wc.setPaintInstructor(new Demo1());
        f.getContentPane().add(wc);
        f.pack();
        f.setVisible(true);
    }

    public void setColorRange(double cmin, double cmax) {
        this.pwCanvas.setColorRange(cmin, cmax);
    }

    public void setColorTable(Color[] ac) {
        this.pwCanvas.setColorTable(ac);
    }

    public void syncSizes() {
        this.pwCanvas.syncSize();
    }

    public void setPrefSize(int w, int h) {
        this.prefDim = new Dimension(w, h);
        this.setPreferredSize(this.prefDim);
        int leftmargin = 64;
        int bottommargin = 22;
        this.xAxisCanvas.setPreferredSize(w - leftmargin, bottommargin);
        this.yAxisCanvas.setPreferredSize(leftmargin, h - bottommargin);
        this.pwCanvas.setPreferredSize(w - leftmargin, h - bottommargin);
        this.xAxisCanvas.setMinimumSize(new Dimension(100, bottommargin - 20));
        this.yAxisCanvas.setMinimumSize(new Dimension(leftmargin - 20, 100));
        this.cornerPanel.setMinimumSize(new Dimension(leftmargin - 20, bottommargin - 20));
        this.ab1.setDividerLocation(h - leftmargin);
        this.ab2.setDividerLocation(h - bottommargin);
    }
}

