/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.graph.gui;

import java.awt.Color;
import org.catacomb.be.Position;
import org.catacomb.graph.gui.HoverTimer;
import org.catacomb.graph.gui.Mouse;
import org.catacomb.graph.gui.MouseHandler;
import org.catacomb.graph.gui.Painter;
import org.catacomb.graph.gui.PickListener;
import org.catacomb.graph.gui.PickStore;
import org.catacomb.graph.gui.Pickable;
import org.catacomb.graph.gui.PickablePoint;
import org.catacomb.graph.gui.PickableRegion;
import org.catacomb.graph.gui.WorldTransform;
import org.catacomb.interlish.interact.ClickListener;
import org.catacomb.report.E;

public class PickHandler
extends MouseHandler {
    int xoff = 0;
    int yoff = 0;
    WorldTransform worldTransform;
    PickStore pickStore;
    Pickable activePick;
    PickListener pickListener;
    ClickListener clickListener;
    Pickable echoItem;
    HoverTimer hTimer;
    Pickable hoverItem;
    boolean inTrash;

    public PickHandler(PickStore ps, WorldTransform wt) {
        this.pickStore = ps;
        this.worldTransform = wt;
        this.hTimer = new HoverTimer(this);
    }

    public void setPickListener(PickListener pl) {
        this.pickListener = pl;
    }

    @Override
    boolean motionAware() {
        return true;
    }

    @Override
    boolean motionChange(Mouse m) {
        int xc = m.getX();
        int yc = m.getY();
        double wx = this.worldTransform.pubWopx(xc);
        double wy = this.worldTransform.pubWopy(yc);
        boolean changed = false;
        if (this.echoItem == null) {
            this.echoItem = this.pickStore.getClaimant(xc, yc, wx, wy);
            if (this.echoItem != null) {
                changed = true;
            }
        } else if (!this.pickStore.itemClaims(this.echoItem, xc, yc, wx, wy)) {
            Pickable pei = this.echoItem;
            this.echoItem = this.pickStore.getClaimant(xc, yc, wx, wy);
            changed = true;
            if (pei == this.echoItem) {
                E.error(" - same claimant but failed to claim");
            }
        }
        if (changed) {
            this.hoverItem = null;
            if (this.echoItem == null) {
                this.hTimer.clear();
            } else {
                this.hTimer.start();
            }
        }
        return changed;
    }

    public void echoPaint(Painter p, boolean tips) {
        if (this.echoItem != null) {
            if (this.echoItem instanceof PickablePoint) {
                p.setColor(Color.white);
                p.drawRectangle(this.pickStore.getEchoBox((PickablePoint)this.echoItem));
            } else if (this.echoItem instanceof PickableRegion) {
                String s;
                PickableRegion pr = (PickableRegion)this.echoItem;
                p.setColor(Color.white);
                p.drawPolygon(pr.getXPts(), pr.getYPts());
                if ((tips || this.hoverItem == this.echoItem) && (s = pr.getRegionTag()) != null) {
                    p.drawOffsetCenteredLabel(s, pr.getXReference(), pr.getYReference());
                }
            }
        }
    }

    @Override
    public void init(Mouse m) {
        int xm = m.getX();
        int ym = m.getY();
        double wx = this.worldTransform.pubWopx(xm);
        double wy = this.worldTransform.pubWopy(ym);
        this.activePick = this.pickStore.getClaimant(xm, ym, wx, wy);
        if (this.activePick != null) {
            this.xoff = this.pickStore.getClaimantRefX() - xm;
            this.yoff = this.pickStore.getClaimantRefY() - ym;
        }
        if (this.activePick == null) {
            this.setClaimOut();
        } else {
            this.setClaimIn();
        }
        this.inTrash = false;
    }

    @Override
    public void advance(Mouse m) {
        E.warning("advance called in PickHandler? ");
    }

    @Override
    public void missedPress(Mouse m) {
        if (this.pickListener != null) {
            if (m.getX() > this.worldTransform.getCanvasWidth() - 20 && m.getY() > this.worldTransform.getCanvasHeight() - 20) {
                this.pickListener.trashPressed();
            } else {
                this.pickListener.backgroundPressed(m.getButton(), m.getX(), m.getY());
            }
        }
    }

    public void hovered() {
        this.hoverItem = this.echoItem;
        if (this.hoverItem != null) {
            this.pickListener.pickHovered(this.hoverItem);
        }
    }

    @Override
    public void applyOnDown(Mouse m) {
        if (this.pickListener != null) {
            this.pickListener.pickPressed(this.activePick, m.getButton(), m.getX(), m.getY());
        }
    }

    @Override
    public void applyOnDrag(Mouse m) {
        if (this.pickListener != null) {
            int ix = m.getX() + this.xoff;
            int iy = m.getY() + this.yoff;
            Position pos = this.worldTransform.getWorldPosition(ix, iy);
            this.pickListener.pickDragged(this.activePick, pos, m.getButton(), ix, iy);
            if (this.inTrash(ix, iy)) {
                if (!this.inTrash) {
                    this.inTrash = true;
                    this.pickListener.pickEnteredTrash(this.activePick);
                }
            } else if (this.inTrash) {
                this.inTrash = false;
                this.pickListener.pickLeftTrash(this.activePick);
            }
            this.setFullRepaint();
        }
    }

    public boolean inTrash(int ix, int iy) {
        return ix > this.worldTransform.getCanvasWidth() - 28 && iy > this.worldTransform.getCanvasHeight() - 28;
    }

    @Override
    public void applyOnRelease(Mouse m) {
        if (this.pickListener != null) {
            this.pickListener.pickReleased(this.activePick, m.getButton());
            if (this.inTrash) {
                this.pickListener.pickTrashed(this.activePick);
            }
        }
    }

    public void setClickListener(ClickListener cl) {
        this.clickListener = cl;
    }
}

