/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.interlish.content;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.catacomb.interlish.structure.Element;
import org.catacomb.interlish.structure.ElementFactory;
import org.catacomb.interlish.structure.ElementWriter;
import org.catacomb.interlish.structure.Elementizer;
import org.catacomb.interlish.structure.IDable;
import org.catacomb.interlish.structure.IDd;
import org.catacomb.interlish.structure.ListWatcher;
import org.catacomb.interlish.structure.Supercedable;
import org.catacomb.report.E;

public class KeyedList<V>
implements ElementWriter {
    ArrayList<V> items = new ArrayList();
    HashMap<String, V> itemHM = new HashMap();
    Class itemClass;
    ArrayList<String> keyCache;
    HashMap<String, String> shortToFullHM = new HashMap();
    HashSet<String> duplicateShorts;
    int inewid = 0;
    ArrayList<ListWatcher> listWatchers;

    public KeyedList() {
    }

    public KeyedList(String s) {
        this();
        try {
            this.itemClass = Class.forName(s);
        }
        catch (Exception ex) {
            E.error("cant find class " + s + " " + ex);
        }
    }

    public KeyedList(Class c) {
        this();
        this.itemClass = c;
    }

    public KeyedList(ArrayList<V> elts) {
        this();
        this.addAll(elts);
    }

    public void add(V v) {
        this.addItem(v);
    }

    public void addAll(ArrayList<V> elts) {
        for (V v : elts) {
            this.addItem(v);
        }
    }

    public ArrayList<V> getItems(String[] ks) {
        ArrayList<V> ret = new ArrayList<V>();
        if (ks != null) {
            String[] stringArray = ks;
            int n = ks.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (this.hasItem(s)) {
                    ret.add(this.get(s));
                }
                ++n2;
            }
        }
        return ret;
    }

    public ArrayList<V> getItems(ArrayList<String> ks) {
        ArrayList<V> ret = new ArrayList<V>();
        for (String s : ks) {
            ret.add(this.get(s));
        }
        return ret;
    }

    public ArrayList<V> getItems() {
        return this.items;
    }

    public void silentAddItem(V obj) {
        this.items.add(obj);
        String sid = this.addToHM(obj);
        this.addKey(sid);
        this.reportChange();
    }

    public void addItem(V obj) {
        this.silentAddItem(obj);
        this.reportChange();
    }

    private String addToHM(V obj) {
        String sid = "";
        sid = obj instanceof IDd ? ((IDd)obj).getID() : obj.toString();
        this.itemHM.put(sid, obj);
        this.keyCache = null;
        return sid;
    }

    public void remove(V obj) {
        String sid = "";
        sid = obj instanceof IDd ? ((IDd)obj).getID() : obj.toString();
        this.items.remove(obj);
        this.itemHM.remove(sid);
        this.removeKey(sid);
        this.reportChange();
    }

    public void put(String s, V v) {
        this.items.add(v);
        this.itemHM.put(s, v);
        this.keyCache = null;
        this.addKey(s);
    }

    public void putNew(String sid, V psc) {
        if (this.itemHM.containsKey(sid)) {
            E.warning("put new tried to override existing item " + sid);
        } else {
            this.put(sid, psc);
        }
    }

    public boolean hasItem(String s) {
        return this.shortToFullHM.containsKey(s) || this.itemHM.containsKey(s);
    }

    public V get(String s) {
        V ret = null;
        if (this.itemHM.containsKey(s)) {
            ret = this.itemHM.get(s);
        } else {
            String sf = this.getFullID(s);
            if (this.itemHM.containsKey(sf)) {
                ret = this.itemHM.get(sf);
            } else {
                E.error("cant get " + s + " from keyed list");
            }
        }
        return ret;
    }

    public V getOrMake(String s) {
        V ret = null;
        if (this.hasItem(s)) {
            ret = this.get(s);
        } else if (this.itemClass != null) {
            try {
                Object obj = this.itemClass.newInstance();
                ret = (V)obj;
                if (ret instanceof IDable) {
                    ((IDable)ret).setID(s);
                } else {
                    E.warning("autogenerated items should be IDable " + this.itemClass);
                }
                this.addItem(ret);
            }
            catch (Exception ex) {
                E.error("cant make item of type " + this.itemClass + " " + ex);
            }
        } else {
            E.error("cant make new item - null classs");
        }
        return ret;
    }

    public void superceded(V old) {
        if (old instanceof Supercedable) {
            Object repl = ((Supercedable)old).getSupercessor();
            if (this.items.contains(old)) {
                this.items.remove(old);
                this.items.add(repl);
            } else {
                E.error("supercedee isnt in list " + old + " " + old.hashCode());
                for (V obj : this.items) {
                    E.info("is in: " + obj + " " + obj.hashCode());
                }
            }
            this.addToHM(repl);
        } else {
            E.error(" cant supercede non supercedable: " + old);
        }
    }

    public void quietSuperceded(V old) {
        if (this.items.contains(old)) {
            this.superceded(old);
        }
    }

    public V getFirst() {
        return this.items.get(0);
    }

    @Override
    public Element makeElement(ElementFactory ef, Elementizer eltz) {
        Element elt = ef.makeElement("KeyedList");
        for (V obj : this.getItems()) {
            Element chld = eltz.elementize(obj);
            ef.addElement(elt, chld);
        }
        return elt;
    }

    public ArrayList<String> getKeys() {
        if (this.keyCache == null) {
            this.keyCache = new ArrayList();
            this.keyCache.addAll(this.itemHM.keySet());
        }
        return this.keyCache;
    }

    public ArrayList<String> getShortKeys() {
        ArrayList<String> al = new ArrayList<String>();
        al.addAll(this.shortToFullHM.keySet());
        return al;
    }

    public void remove(String s) {
        if (this.hasItem(s)) {
            V val = this.get(s);
            this.items.remove(val);
            this.itemHM.remove(s);
            this.removeKey(s);
            this.reportChange();
        }
    }

    private void removeKey(String s) {
        String ss = s.substring(s.lastIndexOf(".") + 1, s.length());
        this.shortToFullHM.remove(ss);
        this.keyCache = null;
    }

    private void addKey(String s) {
        String ss = s.substring(s.lastIndexOf(".") + 1, s.length());
        if (this.shortToFullHM.containsKey(ss)) {
            E.shortWarning("duplicate items - deleted " + this.shortToFullHM.get(ss) + " and " + s);
            this.shortToFullHM.remove(ss);
            if (this.duplicateShorts == null) {
                this.duplicateShorts = new HashSet();
            }
            this.duplicateShorts.add(ss);
        } else {
            this.shortToFullHM.put(ss, s);
        }
    }

    public boolean hasFullID(String sid) {
        boolean ret = false;
        ret = sid.indexOf(".") > 0 ? this.itemHM.containsKey(sid) : this.shortToFullHM.containsKey(sid);
        return ret;
    }

    public String getFullID(String sid) {
        String ret = null;
        if (sid != null) {
            if (sid.indexOf(".") > 0) {
                ret = sid;
            } else if (this.shortToFullHM.containsKey(sid)) {
                String s = this.shortToFullHM.get(sid);
                if (s.equals("_duplicate_")) {
                    E.shortError("Duplicate short ID - must use full ID " + sid);
                } else {
                    ret = s;
                }
            } else {
                E.error("no such key " + sid);
            }
        }
        return ret;
    }

    public String printIDs() {
        StringBuffer sb = new StringBuffer();
        int iel = 0;
        for (String s : this.itemHM.keySet()) {
            sb.append(s);
            sb.append(", ");
            if (++iel % 4 != 0) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public void dump() {
        for (String s : this.itemHM.keySet()) {
            E.info("kl item " + s + " " + this.itemHM.get(s));
        }
        for (String s : this.shortToFullHM.keySet()) {
            E.info("short key " + s + " " + this.shortToFullHM.get(s));
        }
    }

    public String[] getKeysArray() {
        return this.getKeys().toArray(new String[0]);
    }

    public String[] getShortKeysArray() {
        return this.getShortKeys().toArray(new String[0]);
    }

    public ArrayList<V> getDescendants(String rtid) {
        ArrayList<V> ret = new ArrayList<V>();
        String fr = String.valueOf(rtid) + ".";
        for (String sk : this.itemHM.keySet()) {
            if (!sk.startsWith(fr)) continue;
            ret.add(this.itemHM.get(sk));
        }
        return ret;
    }

    public String newName(String root) {
        while (this.itemHM.containsKey(String.valueOf(root) + "_" + this.inewid)) {
            ++this.inewid;
        }
        return String.valueOf(root) + "_" + this.inewid;
    }

    public void removeListWatcher(ListWatcher lw) {
        this.listWatchers.remove(lw);
    }

    public void reportChange() {
        if (this.listWatchers != null) {
            for (ListWatcher lw : this.listWatchers) {
                lw.listChanged(this);
            }
        }
    }

    public void addListWatcher(ListWatcher lw) {
        if (this.listWatchers == null) {
            this.listWatchers = new ArrayList();
        }
        this.listWatchers.add(lw);
    }

    public int size() {
        return this.items.size();
    }
}

