/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.catacomb.interlish.content.BasicTouchTime;
import org.catacomb.numeric.data.BlockStack;
import org.catacomb.numeric.data.DDSubSlice;
import org.catacomb.numeric.data.NumVector;
import org.catacomb.numeric.data.NumVectorSet;
import org.catacomb.numeric.data.StackMultipleSlice;
import org.catacomb.report.E;

public class DDSlice
extends StackMultipleSlice
implements NumVectorSet {
    String[] elementNames;
    double[][] data;
    int npcache;

    public DDSlice(BlockStack bs, String fnm, Field f, String u, String t, String[] sa) {
        super(bs, fnm, f, u, t);
        this.elementNames = sa;
        this.npcache = 0;
        this.data = new double[10][];
    }

    public BasicTouchTime getTouchTime() {
        return this.blockStack.getChangeTime();
    }

    public String[] getNames() {
        return this.elementNames;
    }

    public double[] getData() {
        E.warning("shouldn't be calling ...");
        return null;
    }

    public double[][] getDData() {
        if (!this.upToDate()) {
            int np = this.blockStack.getSize();
            if (np > this.data.length) {
                double[][] dn = new double[np + np / 2 + 10][];
                int i = 0;
                while (i < this.npcache) {
                    dn[i] = this.data[i];
                    ++i;
                }
                this.data = dn;
            }
            try {
                int i = this.npcache;
                while (i < np) {
                    this.data[i] = (double[])this.field.get(this.blockStack.getBlock(i));
                    ++i;
                }
                this.npcache = np;
            }
            catch (Exception ex) {
                E.error("exception reading slice from block stack " + this + " " + ex);
            }
        }
        this.cacheTime.now();
        return this.data;
    }

    @Override
    void clearCache() {
        this.npcache = 0;
    }

    @Override
    public ArrayList<NumVector> getVectors() {
        ArrayList<NumVector> ret = new ArrayList<NumVector>();
        double[][] dd = this.getDData();
        if (this.npcache > 0) {
            if (dd[0] == null) {
                E.error("no data in slcice? " + this.getName() + " " + this.getLabel());
            } else {
                int nvec = dd[0].length;
                int i = 0;
                while (i < nvec) {
                    String snm = null;
                    if (this.elementNames != null && this.elementNames.length > i) {
                        snm = this.elementNames[i];
                    }
                    if (snm == null) {
                        snm = String.valueOf(this.getName()) + " " + i;
                    }
                    ret.add(new DDSubSlice(this, i, snm));
                    ++i;
                }
            }
        }
        return ret;
    }

    @Override
    public ArrayList<NumVector> getByIndex(int[] ia) {
        ArrayList<NumVector> ret = new ArrayList<NumVector>();
        ArrayList<NumVector> av = this.getVectors();
        if (ia == null) {
            ret.addAll(av);
        } else {
            int[] nArray = ia;
            int n = ia.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                ret.add(av.get(i));
                ++n2;
            }
        }
        return ret;
    }
}

