/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.numeric.data;

import org.catacomb.interlish.content.BasicTouchTime;
import org.catacomb.numeric.data.DDSlice;
import org.catacomb.numeric.data.NumVector;
import org.catacomb.report.E;

public class DDSubSlice
implements NumVector {
    DDSlice srcSlice;
    int index;
    String label;
    int npcache;
    double[] data;
    BasicTouchTime touchTime;

    public DDSubSlice(DDSlice slice, int i, String lab) {
        this.srcSlice = slice;
        this.index = i;
        this.label = lab;
        this.touchTime = new BasicTouchTime();
        this.touchTime.never();
        this.data = new double[10];
    }

    public String toString() {
        E.warning("using toString ? ");
        return this.label;
    }

    @Override
    public String getName() {
        return this.label;
    }

    @Override
    public int getNPoint() {
        return this.srcSlice.getNPoint();
    }

    public void clear() {
        this.npcache = 0;
        this.touchTime.never();
    }

    @Override
    public double[] getData() {
        if (this.touchTime.isBefore(this.srcSlice.getTouchTime())) {
            int i;
            int npn = this.srcSlice.getNPoint();
            if (npn > this.data.length) {
                double[] dn = new double[3 * npn / 2 + 10];
                i = 0;
                while (i < this.npcache) {
                    dn[i] = this.data[i];
                    ++i;
                }
                this.data = dn;
            }
            double[][] dd = this.srcSlice.getDData();
            i = this.npcache;
            while (i < npn) {
                this.data[i] = dd[i][this.index];
                ++i;
            }
            this.npcache = npn;
            this.touchTime.now();
        }
        return this.data;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getUnit() {
        return this.srcSlice.getUnit();
    }
}

