/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff;

import java.lang.reflect.Constructor;
import org.textensor.report.E;
import org.textensor.stochdiff.model.SDRun;
import org.textensor.stochdiff.numeric.BaseCalc;
import org.textensor.stochdiff.numeric.grid.DeterministicGridCalc;
import org.textensor.stochdiff.numeric.grid.SteppedStochaticGridCalc;
import org.textensor.stochdiff.numeric.pool.ForwardEulerPoolCalc;
import org.textensor.stochdiff.numeric.pool.ForwardExponentialPoolCalc;
import org.textensor.stochdiff.numeric.pool.ImplicitEulerPoolCalc;
import org.textensor.stochdiff.numeric.pool.RungeKutta4PoolCalc;
import org.textensor.stochdiff.numeric.pool.SemiImplicitEulerPoolCalc;

public enum SDCalcType {
    SMP_EULER(ForwardEulerPoolCalc.class),
    SMP_SEMI_IMPLICIT_EULER(SemiImplicitEulerPoolCalc.class),
    SMP_IMPLICIT_EULER(ImplicitEulerPoolCalc.class),
    SMP_FORWARD_EXPONENTIAL(ForwardExponentialPoolCalc.class),
    SMP_RK4(RungeKutta4PoolCalc.class),
    GRID_STEPPED_STOCHASTIC(SteppedStochaticGridCalc.class),
    GRID_STEPPED_CONTINUOUS(DeterministicGridCalc.class);

    private Class calcClass;

    private SDCalcType(Class cls) {
        this.calcClass = cls;
    }

    public boolean hasLabel(String s) {
        String sn = this.name();
        return sn.equals(s) || sn.toLowerCase().equals(s);
    }

    public BaseCalc getCalc(SDRun sdr) {
        BaseCalc ret = null;
        try {
            Class[] argTyp = new Class[]{SDRun.class};
            Constructor constructor = this.calcClass.getConstructor(argTyp);
            Object[] args = new Object[]{sdr};
            ret = (BaseCalc)constructor.newInstance(args);
        }
        catch (Exception ex) {
            E.error("ex " + ex + " cant instantiate " + this.name() + " " + this.calcClass);
            ex.printStackTrace();
        }
        return ret;
    }
}

