/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.disc;

import java.util.ArrayList;
import org.textensor.stochdiff.numeric.morph.TreePoint;

public class SegmentMerger {
    private TreePoint[] merge(TreePoint[] pt, double maxdr, double maxlen, double tol) {
        int i = 0;
        while (i < pt.length) {
            pt[i].setWork(2);
            ++i;
        }
        TreePoint p0 = pt[0];
        this.recMerge(p0, maxdr, maxlen, tol);
        int nl = 0;
        int i2 = 0;
        while (i2 < pt.length) {
            if (pt[i2].getWork() > 0) {
                ++nl;
            }
            ++i2;
        }
        TreePoint[] pr = new TreePoint[nl];
        nl = 0;
        int i3 = 0;
        while (i3 < pt.length) {
            if (pt[i3].getWork() > 0) {
                pr[nl++] = pt[i3];
            }
            ++i3;
        }
        return pr;
    }

    private void recMerge(TreePoint cp, double maxdr, double maxlen, double tol) {
        cp.setWork(1);
        int j = 0;
        while (j < cp.nnbr) {
            TreePoint cq = cp.nbr[j];
            if (cq.getWork() == 2 && cq.nnbr == 2 && Math.abs((cq.r - cp.r) / (cq.r + cp.r)) < 0.5 * maxdr && cp.distanceTo(cq) < maxlen) {
                boolean cor;
                double dl;
                TreePoint cprev = cp;
                ArrayList<TreePoint> vpt = new ArrayList<TreePoint>();
                double ltot = 0.0;
                double ldtot = 0.0;
                while (cq.nnbr == 2 && cprev.distanceTo(cq) < maxlen && Math.abs((cq.r - cp.r) / (cq.r + cp.r)) < 0.5 * maxdr) {
                    vpt.add(cq);
                    dl = cprev.distanceTo(cq);
                    ltot += dl;
                    ldtot += dl * (cprev.r + cq.r);
                    TreePoint cnxt = cq.nbr[0] == cprev ? cq.nbr[1] : cq.nbr[0];
                    cprev = cq;
                    cq = cnxt;
                }
                dl = cprev.distanceTo(cq);
                ldtot += dl * (cprev.r + cq.r);
                double lab = cp.distanceTo(cq);
                double ldab = lab * (cp.r + cq.r);
                int nadd = (int)((ltot += dl) / maxlen);
                if (nadd > vpt.size()) {
                    nadd = vpt.size();
                }
                boolean bl = cor = Math.abs((lab - ltot) / (lab + ltot)) > 0.5 * tol || Math.abs((ldab - ldtot) / (ldab + ldtot)) > 0.5 * tol;
                if (cor && nadd == 0) {
                    nadd = 1;
                }
                if (nadd == 0) {
                    cp.replaceNeighbor((TreePoint)vpt.get(0), cq);
                    cq.replaceNeighbor((TreePoint)vpt.get(vpt.size() - 1), cp);
                } else {
                    int i = 0;
                    while (i < nadd) {
                        TreePoint cm = (TreePoint)vpt.get(i);
                        cm.setWork(1);
                        cm.locateBetween(cp, cq, (1.0 + (double)i) / (1.0 + (double)nadd));
                        if (i == nadd - 1 && nadd < vpt.size()) {
                            cm.replaceNeighbor((TreePoint)vpt.get(nadd), cq);
                            cq.replaceNeighbor((TreePoint)vpt.get(vpt.size() - 1), cm);
                        }
                        ++i;
                    }
                }
                int jd = nadd;
                while (jd < vpt.size()) {
                    TreePoint cd = (TreePoint)vpt.get(jd);
                    cd.nnbr = 0;
                    cd.setWork(0);
                    ++jd;
                }
                if (cor) {
                    double dpar = lab / (double)(nadd + 1);
                    double fl = ltot / lab;
                    double dperp = Math.sqrt((fl * fl - 1.0) * dpar * dpar);
                    double fr = ldtot / (fl * ldab);
                    int i = 0;
                    while (i < nadd) {
                        TreePoint cm = (TreePoint)vpt.get(i);
                        cm.r *= fr;
                        if (i % 2 == 0) {
                            cm.movePerp(cp, cq, i / 2 % 2 == 0 ? dperp : -dperp);
                        }
                        ++i;
                    }
                }
            }
            if (cq.getWork() == 2) {
                this.recMerge(cq, maxdr, maxlen, tol);
            }
            ++j;
        }
    }
}

