/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.disc;

import java.io.File;
import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.disc.DiscBoxer;
import org.textensor.stochdiff.disc.LineBoxer;
import org.textensor.stochdiff.disc.SegmentSlicer;
import org.textensor.stochdiff.disc.TreeUtil;
import org.textensor.stochdiff.numeric.morph.TreePoint;
import org.textensor.stochdiff.numeric.morph.TreeWriter;
import org.textensor.stochdiff.numeric.morph.VolumeGrid;

public class TreeBoxDiscretizer {
    TreePoint[] srcPoints;

    public TreeBoxDiscretizer(TreePoint[] points) {
        this.srcPoints = points;
    }

    public VolumeGrid buildGrid(double d, HashMap<String, Double> resHM, int geom, double d2d) {
        TreePoint base = this.srcPoints[0];
        TreeUtil.parentizeFrom(base, this.srcPoints);
        TreeUtil.orientAC(base, this.srcPoints);
        SegmentSlicer ss = new SegmentSlicer(this.srcPoints);
        TreePoint[] slicedPoints = ss.getFixedWidthSlices(d, resHM);
        TreeWriter tw = new TreeWriter(slicedPoints);
        tw.writeSWC(new File("discretized-tree.swc"));
        VolumeGrid vgrid = null;
        if (geom == 0) {
            LineBoxer lb = new LineBoxer(slicedPoints, d2d);
            vgrid = lb.buildGrid(d, resHM);
        } else if (geom == 1) {
            DiscBoxer db = new DiscBoxer(slicedPoints);
            vgrid = db.buildGrid(d, resHM);
        } else {
            E.error("unrecognized geometry");
        }
        return vgrid;
    }
}

