/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.model;

import org.textensor.report.E;
import org.textensor.stochdiff.model.Discretization;
import org.textensor.stochdiff.model.InitialConditions;
import org.textensor.stochdiff.model.Morphology;
import org.textensor.stochdiff.model.OutputScheme;
import org.textensor.stochdiff.model.ReactionScheme;
import org.textensor.stochdiff.model.StimulationSet;

public class SDRun {
    public String reactionSchemeFile;
    public String morphologyFile;
    public String stimulationFile;
    public String initialConditionsFile;
    public String outputSchemeFile;
    public String initialStateFile;
    public double stateSaveInterval;
    public String stateSavePrefix;
    public String geometry;
    public double depth2D;
    public double runtime;
    public int spineSeed;
    public int simulationSeed;
    public double poolVolume;
    public double fixedStepDt;
    public double outputInterval;
    public String outputSpecies;
    public String outputQuantity;
    public double tolerance;
    public String calculation;
    public String distribution;
    public String algorithm;
    private int distributionID;
    private int algorithmID;
    public ReactionScheme reactionScheme;
    public StimulationSet stimulationSet;
    public Morphology morphology;
    public InitialConditions initialConditions;
    public OutputScheme outputScheme;
    public Discretization discretization;

    public void resolve() {
        this.resolveCalcTypes();
        this.reactionScheme.resolve();
        this.morphology.resolve();
    }

    private void resolveCalcTypes() {
        if (this.distribution != null && this.distribution.length() > 0) {
            if (this.distribution.toLowerCase().equals("binomial")) {
                this.distributionID = 0;
            } else if (this.distribution.toLowerCase().equals("poisson")) {
                this.distributionID = 1;
            } else {
                E.shortWarning("Unrecognized distribution (" + this.distribution + ") expecting binomial or poisson");
            }
        }
        if (this.algorithm != null && this.algorithm.length() > 0) {
            if (this.algorithm.toLowerCase().equals("independent")) {
                this.algorithmID = 0;
            } else if (this.algorithm.toLowerCase().equals("shared")) {
                this.algorithmID = 1;
            } else if (this.algorithm.toLowerCase().equals("particle")) {
                this.algorithmID = 2;
            } else {
                E.shortWarning("Unrecognized algorithm (" + this.algorithm + ") expecting independent or shared");
            }
        }
    }

    public int getDistributionID() {
        return this.distributionID;
    }

    public int getAlgorithmID() {
        return this.algorithmID;
    }

    public double getStateSaveInterval() {
        return this.stateSaveInterval;
    }

    public void setOutputScheme(OutputScheme outputScheme) {
        this.outputScheme = outputScheme;
    }

    public OutputScheme getOutputScheme() {
        return this.outputScheme;
    }

    public void setReactionScheme(ReactionScheme reactionScheme) {
        this.reactionScheme = reactionScheme;
    }

    public ReactionScheme getReactionScheme() {
        return this.reactionScheme;
    }

    public void setStimulationSet(StimulationSet stimulationSet) {
        this.stimulationSet = stimulationSet;
    }

    public StimulationSet getStimulationSet() {
        return this.stimulationSet;
    }

    public void setMorphology(Morphology morphology) {
        this.morphology = morphology;
    }

    public Morphology getMorphology() {
        return this.morphology;
    }

    public Discretization getDiscretization() {
        return this.discretization;
    }

    public void setInitialConditions(InitialConditions initialConditions) {
        this.initialConditions = initialConditions;
    }

    public InitialConditions getInitialConditions() {
        return this.initialConditions;
    }
}

