/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric;

import org.textensor.report.E;
import org.textensor.stochdiff.model.SDRun;
import org.textensor.stochdiff.numeric.BaseCalc;
import org.textensor.stochdiff.numeric.chem.ReactionTable;
import org.textensor.stochdiff.numeric.morph.VolumeGrid;

public class StaticCalc
extends BaseCalc {
    public SDRun sdRun;
    ReactionTable rtab;
    VolumeGrid vgrid;
    int nel;
    int nspec;
    String[] specieIDs;
    double[] volumes;
    boolean[] submembranes;
    String[] regionLabels;
    int[] eltregions;
    double[] surfaceAreas;
    double[][] wkA;

    public StaticCalc(SDRun sdr) {
        super(sdr);
    }

    @Override
    public long getParticleCount() {
        return 0L;
    }

    @Override
    public void run() {
    }

    public void init() {
        this.rtab = this.getReactionTable();
        this.vgrid = this.getVolumeGrid();
        this.nel = this.vgrid.getNElements();
        this.nspec = this.rtab.getNSpecies();
        this.specieIDs = this.rtab.getSpecieIDs();
        this.volumes = this.vgrid.getElementVolumes();
        this.submembranes = this.vgrid.getSubmembranes();
        this.regionLabels = this.vgrid.getRegionLabels();
        this.eltregions = this.vgrid.getRegionIndexes();
        this.surfaceAreas = this.vgrid.getExposedAreas();
        this.wkA = new double[this.nel][this.nspec];
    }

    public void reinit() {
        double[][] regcon = this.getRevisedRegionConcentrations();
        double[][] regsd = this.getRevisedRegionSurfaceDensities();
        int i = 0;
        while (i < this.nel) {
            double[] rcs = regcon[this.eltregions[i]];
            int j = 0;
            while (j < this.nspec) {
                this.wkA[i][j] = rcs[j];
                ++j;
            }
            double a = this.surfaceAreas[i];
            double[] scs = regsd[this.eltregions[i]];
            if (a > 0.0 && scs != null) {
                double concfac = a / this.volumes[i];
                int j2 = 0;
                while (j2 < this.nspec) {
                    if (!Double.isNaN(scs[j2])) {
                        this.wkA[i][j2] = concfac * scs[j2];
                    }
                    ++j2;
                }
            }
            ++i;
        }
    }

    public int getNel() {
        return this.nel;
    }

    public int getNSpec() {
        return this.nspec;
    }

    public double[][] getElementConcentrations() {
        this.reinit();
        double[][] ret = new double[this.nel][this.nspec];
        int i = 0;
        while (i < this.nel) {
            int j = 0;
            while (j < this.nspec) {
                ret[i][j] = this.wkA[i][j];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[] getConcentrations() {
        this.reinit();
        double[] ret = new double[this.nel * this.nspec];
        int i = 0;
        while (i < this.nel) {
            int j = 0;
            while (j < this.nspec) {
                ret[this.nspec * i + j] = this.wkA[i][j];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[] getVolumes() {
        return this.volumes;
    }

    public int[] getSpecieIndexes(String[] sid) {
        int[] ret = new int[sid.length];
        int i = 0;
        while (i < sid.length) {
            boolean got = false;
            int j = 0;
            while (j < this.specieIDs.length) {
                if (sid[i].equals(this.specieIDs[j])) {
                    ret[i] = j;
                    got = true;
                }
                ++j;
            }
            if (!got) {
                E.error("Can't find species: " + sid[i]);
            }
            ++i;
        }
        return ret;
    }
}

