/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.math;

import org.textensor.report.E;
import org.textensor.stochdiff.numeric.math.Column;

public final class Matrix
implements Cloneable {
    public double[][] a;
    double[] ws;
    int n;
    int[] perm;
    int sign;
    int n1 = 0;
    int n2 = 0;
    public static int ROW = 1;
    public static int COLUMN = 2;

    public Matrix(int nnn) {
        this.n2 = this.n = nnn;
        this.n1 = this.n;
        this.a = new double[this.n][this.n];
        this.perm = new int[this.n];
        this.ws = new double[this.n];
    }

    public Matrix(int nr, int nc) {
        this.n1 = nr;
        this.n2 = nc;
        this.a = new double[this.n1][this.n2];
        if (this.n1 == this.n2) {
            this.n = this.n1;
            this.perm = new int[this.n];
            this.ws = new double[this.n];
        } else {
            this.n = -1;
        }
    }

    public Matrix(double[][] a) {
        this.a = a;
        this.n1 = a.length;
        this.n2 = a[0].length;
        if (this.n1 == this.n2) {
            this.n = a.length;
            this.perm = new int[this.n];
            this.ws = new double[this.n];
        } else {
            this.n = -1;
        }
    }

    public Matrix(int rowcol, double[] x) {
        if (rowcol == ROW) {
            this.n1 = 1;
            this.n2 = x.length;
            this.a = new double[this.n1][this.n2];
            int i = 0;
            while (i < this.n2) {
                this.a[0][i] = x[i];
                ++i;
            }
        } else if (rowcol == COLUMN) {
            this.n1 = x.length;
            this.n2 = 1;
            this.a = new double[this.n1][this.n2];
            int i = 0;
            while (i < this.n1) {
                this.a[i][0] = x[i];
                ++i;
            }
        } else {
            System.out.println("ERROR - matrix constructor must specify Matrix.ROW, or Matrix.COLUMN");
        }
    }

    public double[] flatten() {
        double[] d = new double[this.n1 * this.n2];
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                d[this.n * i + j] = this.a[i][j];
                ++j;
            }
            ++i;
        }
        return d;
    }

    public void Sp(String s) {
        System.out.println(s);
    }

    public final int dim() {
        return this.n;
    }

    public Matrix copy() {
        Matrix m = new Matrix(this.n1, this.n2);
        int i = 0;
        while (i < this.n1) {
            int j = 0;
            while (j < this.n2) {
                m.a[i][j] = this.a[i][j];
                ++j;
            }
            m.perm[i] = this.perm[i];
            ++i;
        }
        m.sign = this.sign;
        return m;
    }

    public void setDims(int d1, int d2) {
        this.n1 = d1;
        this.n2 = d2;
    }

    public void identise() {
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                this.a[i][j] = 0.0;
                ++j;
            }
            this.a[i][i] = 1.0;
            ++i;
        }
    }

    public void randomise() {
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                this.a[i][j] = Math.random();
                ++j;
            }
            ++i;
        }
    }

    public void zero() {
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                this.a[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    public Matrix identity() {
        Matrix m = this.copy();
        m.identise();
        return m;
    }

    public Matrix random() {
        Matrix m = this.copy();
        m.randomise();
        return m;
    }

    public void add(double d) {
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                double[] dArray = this.a[i];
                int n = j++;
                dArray[n] = dArray[n] + d;
            }
            ++i;
        }
    }

    public static Matrix[] average(Matrix[] ma, Matrix[] mb, double f) {
        int n = ma.length;
        Matrix[] res = new Matrix[n];
        int i = 0;
        while (i < n) {
            res[i] = Matrix.average(ma[i], mb[i], f);
            ++i;
        }
        return res;
    }

    public static Matrix average(Matrix ma, Matrix mb, double f) {
        double g = 1.0 - f;
        int n = ma.n;
        Matrix res = new Matrix(n);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                res.a[i][j] = f * mb.a[i][j] + g * ma.a[i][j];
                ++j;
            }
            ++i;
        }
        return res;
    }

    public void add(Matrix m) {
        if (m.n != this.n) {
            this.Sp("incompativle dims in Matrix.mplyBy " + this.n + " " + m.n);
        } else {
            int i = 0;
            while (i < this.n) {
                int j = 0;
                while (j < this.n) {
                    double[] dArray = this.a[i];
                    int n = j;
                    dArray[n] = dArray[n] + m.a[i][j];
                    ++j;
                }
                ++i;
            }
        }
    }

    public Matrix sum(Matrix m) {
        Matrix mr = this.copy();
        mr.zero();
        if (m.n != this.n) {
            this.Sp("incompativle dims in Matrix.mplyBy " + this.n + " " + m.n);
        } else {
            int i = 0;
            while (i < this.n) {
                int j = 0;
                while (j < this.n) {
                    mr.a[i][j] = this.a[i][j] + m.a[i][j];
                    ++j;
                }
                ++i;
            }
        }
        return mr;
    }

    public void mpyBy(double d) {
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                double[] dArray = this.a[i];
                int n = j++;
                dArray[n] = dArray[n] * d;
            }
            ++i;
        }
    }

    public void mpyBy(Matrix m) {
        this.a = this.prod((Matrix)m).a;
    }

    public Matrix times(Matrix m) {
        return this.prod(m);
    }

    public String stringDims() {
        return " " + this.n1 + "x" + this.n2;
    }

    public Matrix prod(Matrix m) {
        Matrix mr = new Matrix(this.n1, m.n2);
        mr.zero();
        if (this.n2 != m.n1) {
            E.error("incompatible dims in Matrix.prod: A: " + this.n1 + " " + this.n2 + "   B: " + m.n1 + " " + m.n2);
        } else {
            int i = 0;
            while (i < this.n1) {
                int j = 0;
                while (j < m.n2) {
                    int k = 0;
                    while (k < this.n2) {
                        double[] dArray = mr.a[i];
                        int n = j;
                        dArray[n] = dArray[n] + this.a[i][k] * m.a[k][j];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return mr;
    }

    public Matrix subtract(Matrix m) {
        Matrix mr = new Matrix(this.n1, this.n2);
        mr.zero();
        if (this.n1 != m.n1 || this.n2 != m.n2) {
            this.Sp("incompatible dims in Matrix.subtract " + this.n1 + " " + this.n2 + " " + m.n1 + " " + m.n2);
        } else {
            int i = 0;
            while (i < this.n1) {
                int j = 0;
                while (j < this.n2) {
                    mr.a[i][j] = this.a[i][j] - m.a[i][j];
                    ++j;
                }
                ++i;
            }
        }
        return mr;
    }

    public double[] getColumnData() {
        double[] ret = new double[this.n1];
        if (this.n2 == 1) {
            int i = 0;
            while (i < this.n1) {
                ret[i] = this.a[i][0];
                ++i;
            }
        } else {
            this.Sp("ERROR - getColumnData called on matrix with n2 != 1 " + this.n2);
        }
        return ret;
    }

    public double[] lvprod(double[] v) {
        double[] r = new double[this.n];
        if (v.length != this.n) {
            this.Sp("incompatible dimensions in lvprod");
        } else {
            int i = 0;
            while (i < this.n) {
                int j = 0;
                while (j < this.n) {
                    int n = j;
                    r[n] = r[n] + v[i] * this.a[i][j];
                    ++j;
                }
                ++i;
            }
        }
        return r;
    }

    public Column times(Column v) {
        return new Column(this.rvprod(v.getData()));
    }

    public double[] rvprod(double[] v) {
        double[] r = new double[this.n];
        if (v.length != this.n) {
            this.Sp("incompatible dimensions in lvprod");
        } else {
            int i = 0;
            while (i < this.n) {
                int j = 0;
                while (j < this.n) {
                    int n = i;
                    r[n] = r[n] + this.a[i][j] * v[j];
                    ++j;
                }
                ++i;
            }
        }
        return r;
    }

    public void multiplyInto(double[] v) {
        int i = 0;
        while (i < this.n) {
            this.ws[i] = 0.0;
            int j = 0;
            while (j < this.n) {
                int n = i;
                this.ws[n] = this.ws[n] + this.a[i][j] * v[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.n) {
            v[i] = this.ws[i];
            ++i;
        }
    }

    public void rect2rvprod(double[] v, double[] r1, double[] r2) {
        int j;
        int i = 0;
        while (i < this.n1) {
            this.ws[i] = 0.0;
            j = 0;
            while (j < this.n1) {
                int n = i;
                this.ws[n] = this.ws[n] + this.a[i][j] * v[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.n2 - this.n1) {
            r2[i] = 0.0;
            j = 0;
            while (j < this.n1) {
                int n = i;
                r2[n] = r2[n] + this.a[i + this.n1][j] * v[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.n1) {
            r1[i] = this.ws[i];
            ++i;
        }
    }

    public double rvprodOneElt(double[] v, int elt) {
        double r = 0.0;
        int j = 0;
        while (j < this.n) {
            r += this.a[elt][j] * v[j];
            ++j;
        }
        return r;
    }

    public Matrix transpose() {
        Matrix m = new Matrix(this.n2, this.n1);
        int i = 0;
        while (i < this.n1) {
            int j = 0;
            while (j < this.n2) {
                m.a[j][i] = this.a[i][j];
                ++j;
            }
            ++i;
        }
        return m;
    }

    public double det() {
        Matrix t = this.copy();
        t.LU();
        double d = 1.0 * (double)t.sign;
        int i = 0;
        while (i < this.n) {
            d *= t.a[i][i];
            ++i;
        }
        return d;
    }

    public double[][] copyMat() {
        double[][] ar = new double[this.n][this.n];
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                ar[i][j] = this.a[i][j];
                ++j;
            }
            ++i;
        }
        return ar;
    }

    public void LU() {
        int j;
        double big;
        double[] vv = new double[this.n];
        double TINY = 1.0E-20;
        this.sign = 1;
        int imax = -1;
        int i = 0;
        while (i < this.n) {
            big = 0.0;
            j = 0;
            while (j < this.n) {
                double d;
                double temp = Math.abs(this.a[i][j]);
                if (d > big) {
                    big = temp;
                }
                ++j;
            }
            if (big == 0.0) {
                this.Sp("Singular Matrix in routine LUDCMP");
            }
            vv[i] = 1.0 / big;
            ++i;
        }
        j = 0;
        while (j < this.n) {
            double dum;
            int k;
            double sum;
            i = 0;
            while (i < j) {
                sum = this.a[i][j];
                k = 0;
                while (k < i) {
                    sum -= this.a[i][k] * this.a[k][j];
                    ++k;
                }
                this.a[i][j] = sum;
                ++i;
            }
            big = 0.0;
            i = j;
            while (i < this.n) {
                double d;
                sum = this.a[i][j];
                k = 0;
                while (k < j) {
                    sum -= this.a[i][k] * this.a[k][j];
                    ++k;
                }
                this.a[i][j] = sum;
                dum = vv[i] * Math.abs(sum);
                if (d >= big) {
                    big = dum;
                    imax = i;
                }
                ++i;
            }
            if (j != imax) {
                k = 0;
                while (k < this.n) {
                    dum = this.a[imax][k];
                    this.a[imax][k] = this.a[j][k];
                    this.a[j][k] = dum;
                    ++k;
                }
                this.sign = -this.sign;
                vv[imax] = vv[j];
            }
            this.perm[j] = imax;
            if (this.a[j][j] == 0.0) {
                this.a[j][j] = TINY;
            }
            if (j != this.n) {
                dum = 1.0 / this.a[j][j];
                i = j + 1;
                while (i < this.n) {
                    double[] dArray = this.a[i];
                    int n = j;
                    dArray[n] = dArray[n] * dum;
                    ++i;
                }
            }
            ++j;
        }
    }

    public Matrix inverse() {
        Matrix t = this.copy();
        Matrix r = this.copy();
        t.LU();
        double[] c = new double[this.n];
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.n) {
                c[i] = 0.0;
                ++i;
            }
            c[j] = 1.0;
            t.lubksb(c);
            i = 0;
            while (i < this.n) {
                r.a[i][j] = c[i];
                ++i;
            }
            ++j;
        }
        return r;
    }

    public static double[] LUSolve(double[][] m, double[] R) {
        Matrix M = new Matrix(m);
        M.LU();
        double[] W = M.lubksb(R);
        return W;
    }

    public Column LUSolve(Column r) {
        Matrix m = this.copy();
        m.LU();
        double[] w = m.lubksb(r.getData());
        return new Column(w);
    }

    public void invert() {
        this.a = this.inverse().a;
    }

    public Column lubksb(Column v) {
        double[] d = this.lubksb(v.getData());
        return new Column(d);
    }

    public double[] lubksb(double[] b) {
        int j;
        double sum;
        int ii = -1;
        int i = 0;
        while (i < this.n) {
            int ip = this.perm[i];
            sum = b[ip];
            b[ip] = b[i];
            if (ii >= 0) {
                j = ii;
                while (j < i) {
                    sum -= this.a[i][j] * b[j];
                    ++j;
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i] = sum;
            ++i;
        }
        i = this.n - 1;
        while (i >= 0) {
            sum = b[i];
            j = i + 1;
            while (j < this.n) {
                sum -= this.a[i][j] * b[j];
                ++j;
            }
            b[i] = sum / this.a[i][i];
            --i;
        }
        return b;
    }

    public void round(double d) {
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                if (Math.abs(this.a[i][j]) < d) {
                    this.a[i][j] = 0.0;
                }
                ++j;
            }
            ++i;
        }
    }

    public void round() {
        this.round(1.0E-15);
    }

    public void print() {
        String[] sa = new String[this.n1];
        int i = 0;
        while (i < this.n1) {
            sa[i] = " ";
            int j = 0;
            while (j < this.n2) {
                int n = i;
                sa[n] = String.valueOf(sa[n]) + " " + this.a[i][j];
                ++j;
            }
            ++i;
        }
        this.Sp(" n1: " + this.n1 + " n2: " + this.n2);
        i = 0;
        while (i < sa.length) {
            this.Sp(i + " " + sa[i]);
            ++i;
        }
    }

    public double maxAbsElt() {
        double d = 0.0;
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                if (Math.abs(this.a[i][j]) > d) {
                    d = Math.abs(this.a[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return d;
    }

    public Matrix power(int p) {
        Matrix mr = this.identity();
        int pg = 0;
        int pl = 1;
        Matrix mp = this.copy();
        while (pg < p) {
            if ((p & pl) > 0) {
                pg += pl;
                mr = mr.prod(mp);
            }
            pl *= 2;
            mp = mp.prod(mp);
        }
        if (pg != p) {
            this.Sp("got Matrix power wrong: " + p + " " + pg + " " + pl);
        }
        return mr;
    }

    public Matrix crudeExpOf(double t) {
        Matrix m = this.copy();
        m.mpyBy(t);
        double eps = 1.0E-8;
        double d = m.maxAbsElt();
        int p = 0;
        double f = 1.0;
        p = 0;
        while (d * f > eps) {
            f *= 0.5;
            ++p;
        }
        m.mpyBy(f);
        m.add(m.identity());
        while (p > 0) {
            m.mpyBy(m);
            --p;
        }
        return m;
    }

    public Matrix expOf(double t) {
        Matrix m = this.copy();
        m.mpyBy(t);
        double eps = 1.0E-12;
        double d = m.maxAbsElt();
        int p = 0;
        double f = 1.0;
        p = 0;
        while (d * f > eps) {
            f *= 0.5;
            ++p;
        }
        m.mpyBy(f);
        while (p > 0) {
            Matrix u = m.copy();
            u.mpyBy(u);
            m.add(m);
            m.add(u);
            --p;
        }
        m.add(m.identity());
        return m;
    }

    public int randomIndexFromColumn(int c) {
        return this.randomIndexFromColumn(c, Math.random());
    }

    public final int randomIndexFromColumn(int c, double r) {
        int ir = 0;
        while ((r -= this.a[ir][c]) > 0.0) {
            ++ir;
        }
        return ir;
    }

    public final double[] getRow(int ic) {
        double[] c = new double[this.n2];
        int i = 0;
        while (i < this.n2) {
            c[i] = this.a[ic][i];
            ++i;
        }
        return c;
    }

    public final double[] getColumn(int ic) {
        double[] c = new double[this.n1];
        int i = 0;
        while (i < this.n1) {
            c[i] = this.a[i][ic];
            ++i;
        }
        return c;
    }

    public int randomIndexFromOffsetColumn(int c, int off) {
        double r = Math.random();
        int ir = off;
        while ((r -= this.a[ir][c]) > 0.0) {
            ++ir;
        }
        return ir;
    }

    public double[] ev1vec(int np) {
        Matrix q = this.copy();
        int i = 0;
        while (i < np) {
            q = q.prod(q);
            ++i;
        }
        double[] s = new double[this.n];
        int i2 = 0;
        while (i2 < this.n) {
            s[i2] = 1.0 / (double)this.n;
            ++i2;
        }
        s = q.rvprod(s);
        double t = 0.0;
        int i3 = 0;
        while (i3 < this.n) {
            t += s[i3];
            ++i3;
        }
        i3 = 0;
        while (i3 < this.n) {
            int n = i3++;
            s[n] = s[n] / t;
        }
        if (Math.abs(t - 1.0) > 0.01) {
            this.Sp("WARNING - ev1vec in class Matrix chnaged size " + t);
        }
        return s;
    }

    public void multiplyBy(double dt) {
        int i = 0;
        while (i < this.n1) {
            int j = 0;
            while (j < this.n2) {
                double[] dArray = this.a[i];
                int n = j++;
                dArray[n] = dArray[n] * dt;
            }
            ++i;
        }
    }

    public void subtractIdentity() {
        int i = 0;
        while (i < this.n1) {
            double[] dArray = this.a[i];
            int n = i++;
            dArray[n] = dArray[n] - 1.0;
        }
    }

    public void negate() {
        int i = 0;
        while (i < this.n1) {
            int j = 0;
            while (j < this.n2) {
                this.a[i][j] = -this.a[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void set(int i, int j, double d) {
        this.a[i][j] = d;
    }

    public void dump() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.n1) {
            int j = 0;
            while (j < this.n2) {
                sb.append(this.a[i][j]);
                sb.append("   ");
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        System.out.println(sb.toString());
    }
}

