/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.math;

import org.textensor.report.E;

public class MersenneTwister {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;
    private boolean haveGaussian;
    private double spareGaussian;
    private static double[] cof = new double[]{76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.00120858003, -5.36382E-6};

    public MersenneTwister() {
        this(System.currentTimeMillis());
    }

    public MersenneTwister(long seed) {
        this.setSeed(seed);
    }

    public void setSeed(long seed) {
        this.mt = new int[624];
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
        this.mt[0] = (int)(seed & 0xFFFFFFFFFFFFFFFFL);
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            int n = this.mti++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFF;
        }
    }

    public final float random() {
        int y;
        if (this.mti >= 624) {
            int[] mtl = this.mt;
            int[] mag01l = this.mag01;
            int kk = 0;
            while (kk < 227) {
                y = mtl[kk] & Integer.MIN_VALUE | mtl[kk + 1] & Integer.MAX_VALUE;
                mtl[kk] = mtl[kk + 397] ^ y >>> 1 ^ mag01l[y & 1];
                ++kk;
            }
            while (kk < 623) {
                y = mtl[kk] & Integer.MIN_VALUE | mtl[kk + 1] & Integer.MAX_VALUE;
                mtl[kk] = mtl[kk + -227] ^ y >>> 1 ^ mag01l[y & 1];
                ++kk;
            }
            y = mtl[623] & Integer.MIN_VALUE | mtl[0] & Integer.MAX_VALUE;
            mtl[623] = mtl[396] ^ y >>> 1 ^ mag01l[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return (float)(y >>> 8) / 1.6777216E7f;
    }

    public final double gaussian() {
        double ret = 0.0;
        if (this.haveGaussian) {
            ret = this.spareGaussian;
            this.haveGaussian = false;
        } else {
            double r = -1.0;
            double ran1 = 0.0;
            double ran2 = 0.0;
            while (r <= 0.0 || r >= 1.0) {
                ran1 = 2.0f * this.random() - 1.0f;
                ran2 = 2.0f * this.random() - 1.0f;
                r = ran1 * ran1 + ran2 * ran2;
            }
            double fac = Math.sqrt(-2.0 * Math.log(r) / r);
            ret = ran1 * fac;
            this.spareGaussian = ran2 * fac;
            this.haveGaussian = true;
        }
        return ret;
    }

    public final double gammln(double xx) {
        double x = xx - 1.0;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.0;
        int j = 0;
        while (j <= 5) {
            ser += cof[j] / (x += 1.0);
            ++j;
        }
        return -tmp + Math.log(2.50662827465 * ser);
    }

    public final int poisson(double mean) {
        double em = 0.0;
        if (mean < 12.0) {
            double g = Math.exp(-mean);
            em = -1.0;
            double t = 1.0;
            do {
                em += 1.0;
            } while ((t *= (double)this.random()) > g);
        } else {
            double sq = Math.sqrt(2.0 * mean);
            double alxm = Math.log(mean);
            double g = mean * alxm - this.gammln(mean + 1.0);
            double t = 0.0;
            double y = 0.0;
            while (true) {
                if ((em = sq * (y = Math.tan(Math.PI * (double)this.random())) + mean) < 0.0) {
                    continue;
                }
                em = Math.floor(em);
                t = 0.9 * (1.0 + y * y) * Math.exp(em * alxm - this.gammln(em + 1.0) - g);
                if (!((double)this.random() > t)) break;
            }
        }
        int ret = (int)Math.round(em);
        return ret;
    }

    public static void main(String[] argv) {
        MersenneTwister mt = new MersenneTwister();
        long t1 = System.currentTimeMillis();
        int nran = 100000;
        double pavg = 1300.0;
        double dg = 0.0;
        int i = 0;
        while (i < nran) {
            dg += mt.gaussian();
            ++i;
        }
        long t2 = System.currentTimeMillis();
        double dp = 0.0;
        int i2 = 0;
        while (i2 < nran) {
            dp += (double)mt.poisson(pavg);
            ++i2;
        }
        long t3 = System.currentTimeMillis();
        E.info("times: " + (t2 - t1) + " " + (t3 - t2) + " " + dg / (double)nran + " " + dp / (double)nran);
    }
}

