/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.morph;

import java.util.ArrayList;
import java.util.HashMap;
import org.textensor.report.E;
import org.textensor.stochdiff.geom.Position;

public class TreePoint
implements Position {
    public double x;
    public double y;
    public double z;
    public double r;
    public TreePoint[] nbr = new TreePoint[6];
    public int nnbr = 0;
    public TreePoint parent;
    public TreePoint subAreaPeer = null;
    public String label;
    public int iwork;
    public boolean dead = false;
    public double dgx;
    public double dgy;
    private ArrayList<TreePoint> offsetChildren;
    private HashMap<TreePoint, String> segidHM;
    private HashMap<TreePoint, String> regionHM;
    private String firstRegion = null;
    public String name;
    public double partBranchOffset = 0.0;

    public TreePoint() {
    }

    public TreePoint(double x, double y, double z, double r) {
        this();
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
    }

    public double getRadius() {
        return this.r;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    public String getLabel() {
        return this.label;
    }

    public TreePoint getParent() {
        return this.parent;
    }

    public TreePoint makeCopy() {
        return new TreePoint(this.x, this.y, this.z, this.r);
    }

    public void setWork(int iw) {
        this.iwork = iw;
    }

    public int getWork() {
        return this.iwork;
    }

    public String toString() {
        return "(point x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",r=" + this.r + ",nnbr=" + this.nnbr + ")";
    }

    public void setPosition(double[] a) {
        this.x = a[0];
        this.y = a[1];
        this.z = a[2];
        if (a.length >= 3) {
            this.r = a[3];
        }
    }

    public void locateBetween(TreePoint cpa, TreePoint cpb, double f) {
        double wf = 1.0 - f;
        this.x = f * cpb.x + wf * cpa.x;
        this.y = f * cpb.y + wf * cpa.y;
        this.z = f * cpb.z + wf * cpa.z;
        this.r = f * cpb.r + wf * cpa.r;
    }

    public void addNeighbor(TreePoint cpn) {
        boolean has = false;
        int i = 0;
        while (i < this.nnbr) {
            if (this.nbr[i] == cpn) {
                E.error("adding a neighbor we already have ");
                has = true;
            }
            ++i;
        }
        if (!has) {
            if (this.nnbr >= this.nbr.length) {
                TreePoint[] pn = new TreePoint[2 * this.nnbr];
                int i2 = 0;
                while (i2 < this.nnbr) {
                    pn[i2] = this.nbr[i2];
                    ++i2;
                }
                this.nbr = pn;
            }
            this.nbr[this.nnbr++] = cpn;
        }
    }

    public void removeNeighbor(TreePoint cp) {
        int ii = -1;
        int i = 0;
        while (i < this.nnbr) {
            if (this.nbr[i] == cp) {
                ii = i;
            }
            ++i;
        }
        if (ii >= 0) {
            i = ii;
            while (i < this.nnbr - 1) {
                this.nbr[i] = this.nbr[i + 1];
                ++i;
            }
            --this.nnbr;
        }
    }

    public void replaceNeighbor(TreePoint cp, TreePoint cr) {
        int ii = -1;
        int i = 0;
        while (i < this.nnbr) {
            if (this.nbr[i] == cp) {
                ii = i;
            }
            ++i;
        }
        if (ii >= 0) {
            this.nbr[ii] = cr;
        } else {
            E.error(" (replaceNeighbor) couldnt find nbr " + cp + " in nbrs list of " + this);
        }
        if (this.segidHM != null && this.segidHM.containsKey(cp)) {
            this.segidHM.put(cr, this.segidHM.get(cp));
        }
        if (this.regionHM != null && this.regionHM.containsKey(cp)) {
            this.regionHM.put(cr, this.regionHM.get(cp));
        }
    }

    public boolean hasNeighbor(TreePoint cp) {
        boolean hn = false;
        int i = 0;
        while (i < this.nnbr) {
            if (this.nbr[i] == cp) {
                hn = true;
            }
            ++i;
        }
        return hn;
    }

    public void removeDeadNeighbors() {
        int i = this.nnbr - 1;
        while (i >= 0) {
            if (this.nbr[i].dead) {
                this.removeNeighbor(this.nbr[i]);
            }
            --i;
        }
    }

    public void addOffsetChild(TreePoint p) {
        if (this.offsetChildren == null) {
            this.offsetChildren = new ArrayList();
        }
        this.offsetChildren.add(p);
    }

    public boolean hasOffsetChildren() {
        return this.offsetChildren != null;
    }

    public ArrayList<TreePoint> getOffsetChildren() {
        return this.offsetChildren;
    }

    public double distanceTo(TreePoint cp) {
        double dx = this.x - cp.x;
        double dy = this.y - cp.y;
        double dz = this.z - cp.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public void movePerp(TreePoint ca, TreePoint cb, double dperp) {
        double dx = cb.x - ca.x;
        double dy = cb.y - ca.y;
        double f = Math.sqrt(dx * dx + dy * dy);
        this.x += dperp * (dy /= f);
        this.y -= dperp * (dx /= f);
    }

    public static void neighborize(TreePoint tp, TreePoint tpn) {
        tp.addNeighbor(tpn);
        tpn.addNeighbor(tp);
    }

    public ArrayList<TreePoint> getNeighbors() {
        ArrayList<TreePoint> ret = new ArrayList<TreePoint>();
        int i = 0;
        while (i < this.nnbr) {
            ret.add(this.nbr[i]);
            ++i;
        }
        return ret;
    }

    public boolean isEndPoint() {
        boolean ret = false;
        if (this.nnbr == 1) {
            ret = true;
        }
        return ret;
    }

    public TreePoint oppositeNeighbor(TreePoint tpp) {
        TreePoint ret = null;
        if (this.nnbr == 2) {
            ret = this.nbr[0] == tpp ? this.nbr[1] : this.nbr[0];
        }
        return ret;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public void setIDWith(TreePoint point, String s) {
        if (this.segidHM == null) {
            this.segidHM = new HashMap();
        }
        this.segidHM.put(point, s);
    }

    public void setRegionWith(TreePoint point, String s) {
        if (this.regionHM == null) {
            this.regionHM = new HashMap();
            this.firstRegion = s;
        }
        this.regionHM.put(point, s);
    }

    public String regionClassWith(TreePoint tp) {
        String ret = null;
        if (this.regionHM != null && this.regionHM.containsKey(tp)) {
            ret = this.regionHM.get(tp);
        }
        if (ret == null) {
            ret = this.soleRegion();
        }
        return ret;
    }

    public String soleRegion() {
        String ret = null;
        if (this.regionHM != null && this.regionHM.size() == 1) {
            ret = this.firstRegion;
        }
        return ret;
    }

    public String segmentIDWith(TreePoint tp) {
        String ret = null;
        if (this.segidHM != null && this.segidHM.containsKey(tp)) {
            ret = this.segidHM.get(tp);
        }
        return ret;
    }

    public void setSubAreaOf(TreePoint cpa) {
        this.subAreaPeer = cpa;
    }

    public void alignTop(TreePoint tpon, TreePoint tpdir, double offset) {
        double dx = tpon.getX() - tpdir.getX();
        double dy = tpon.getY() - tpdir.getY();
        double l = Math.sqrt(dx * dx + dy * dy);
        double vx = -dy / l;
        double vy = dx / l;
        double dist = offset - (tpon.getRadius() - this.getRadius());
        this.x = tpon.getX() + dist * vx;
        this.y = tpon.getY() + dist * vy;
        this.z = tpon.getZ();
    }

    public TreePoint largestNeighborNot(TreePoint cpb) {
        TreePoint ret = null;
        int i = 0;
        while (i < this.nnbr) {
            if (ret == null && this.nbr[i] != cpb || ret != null && this.nbr[i].r > ret.r) {
                ret = this.nbr[i];
            }
            ++i;
        }
        return ret;
    }
}

