/*
 * Decompiled with CFR 0.152.
 */
package org.textensor.stochdiff.numeric.stochastic;

import org.textensor.stochdiff.numeric.stochastic.NGoTable;

public class FixedPStepGenerator {
    double lnp;
    double p;
    NGoTable[] tables;
    int mode;

    public FixedPStepGenerator(double lnp0, int mod) {
        this.lnp = lnp0;
        this.mode = mod;
        this.tables = new NGoTable[121];
        this.p = Math.exp(this.lnp);
    }

    public int nGo(int n, double r) {
        int ngo = 0;
        if (n == 0) {
            ngo = 0;
        } else if (n == 1) {
            ngo = r < this.p ? 1 : 0;
        } else if (n > 120) {
            ngo = (int)(this.p * (double)n + 0.5);
        } else {
            if (this.tables[n] == null) {
                this.tables[n] = new NGoTable(n, this.lnp, this.mode);
            }
            ngo = this.tables[n].nGo(r);
        }
        return ngo;
    }
}

