numGroups = 15;
numLayers = 5;
popProportion = [NP.modelProportion];
ConnectivityData = struct();

% Calculate the number of connections from each individual presynaptic
% neuron to all postsynaptic neurons based on the connectivity data in
% Binzegger et al. 2004 (adjusted to remove thalamic connections and
% connections to/from unmodelled neuron groups)

ConnectivityData(1).incomingSynapses = [87; 5773; 0; 0; 0];
ConnectivityData(2).incomingSynapses = [0; 3702; 0; 0; 0];
ConnectivityData(3).incomingSynapses = [0; 3144; 0; 0; 0];
ConnectivityData(4).incomingSynapses = [0; 0; 4113; 0; 0];
ConnectivityData(5).incomingSynapses = [0; 0; 3610; 0; 0];
ConnectivityData(6).incomingSynapses = [53; 867; 3619; 0; 0];
ConnectivityData(7).incomingSynapses = [0; 0; 2359; 0; 0];
ConnectivityData(8).incomingSynapses = [0; 0; 2636; 0; 0];
ConnectivityData(9).incomingSynapses = [12; 413; 198; 3971; 0];
ConnectivityData(10).incomingSynapses = [375; 1368; 666; 4588; 0];
ConnectivityData(11).incomingSynapses = [0; 0; 0; 2744; 0];
ConnectivityData(12).incomingSynapses = [0; 0; 0; 2744; 0];
ConnectivityData(13).incomingSynapses = [0; 121; 1344; 979; 1326];
ConnectivityData(14).incomingSynapses = [4; 286; 171; 236; 2264];
ConnectivityData(15).incomingSynapses = [0; 0; 0; 0; 1310];

ConnectivityData(1).preConnectionProportionArr = ...
    [[0.951089499850019, 0.0164854645615656, 0, 0, 0.00257637969806608, 0.0149158824624878, 0.000569714842633352, 0, 0.0106646026868125, 0, 0, 0, 0, 0, 0]; ...
    [0.601358387111714, 0.0918939149264026, 0.0485417362344243, 0.00577695902696367, 0.0689383636987168, 0.0776678650182968, 0.00778181721556254, 0, 0.0745107311036309,3.28882435183184e-07, 0, 0, 0.0235807403331392,1.74396076572548e-07, 0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
ConnectivityData(2).preConnectionProportionArr = ...
    [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    [0.536935526368858, 0.110087138118432, 0.122872127520056, 0.00533340075109786, 0.0607031436848912, 0.0684928628981852, 0.00854885801439632, 0, 0.0656095345721378,1.42870443841530e-06, 0, 0, 0.0214320382587506,7.57597311339034e-07, 0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
ConnectivityData(3).preConnectionProportionArr = ...
    [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    [0.577939154000044, 0.125825187905112, 0.0464468630872572, 0.00548140407544197, 0.0662336325782572, 0.0746209253167836, 0.00945253723967204, 0, 0.0716063913038029, 0, 0, 0, 0.0224681198973457, 0, 0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 1 0 0 0];
ConnectivityData(4).preConnectionProportionArr = ...
    [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    [0.0382613208981650, 0.00266160943840835, 0, 0.167215061549882, 0.0516744304681723, 0.0575438594557492, 0.128785938091937, 0.0810522179695405, 0.0108926420039043, 0.000747229014559382, 0, 0, 0.460818040135487, 0.000396232192721829, 0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
ConnectivityData(5).preConnectionProportionArr = ...
    [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    [0.0768892916302398, 0.00610233940102278, 0, 0.155732250768876, 0.0527430010475375, 0.0587956244518134, 0.127954448848950, 0.0758498409958109, 0.0152417332827380, 0.000694163800479200, 0, 0, 0.429699931982310, 0.000368093368181346, 0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
ConnectivityData(6).preConnectionProportionArr = ...
    [[0.963101405440988, 0.0166936698292802, 0, 0, 0.00260891841256618, 0.0151042644938042, 0.000576910128570759, 0, 0.0107992926404493, 0, 0, 0, 0, 0, 0]; ...
    [0.630289598428802, 0.0513927776029738, 0.0506540774767142, 0.00597791644609020, 0.0722331570569233, 0.0813801811605545, 0.00570452897176920, 0, 0.0780925869227510, 0, 0, 0, 0.0245033100275936, 0, 0]; ...
    [0.0601636325583665,0.00316120727872598,0,0.159840903626754,0.0499254507745383,0.0583373255577493,0.129274676013140,0.0826267101644098,0.0164066142974463,0.00123211756212730,0.000730626086429092,0,0.436938644681652,0.00144671774175813,0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
ConnectivityData(7).preConnectionProportionArr = ...
    [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    [0.0798254299589653,0.00713687112761092,0,0.150565185133835,0.0516071394339683,0.0575369177089753,0.147964209134409,0.0733815618864838,0.0154139754536817,0.000670898956619243,0,0,0.415512901245621,0.000355756748595720,0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
ConnectivityData(8).preConnectionProportionArr = ...
    [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    [0.0373944026439595, 0.00331781106052284, 0, 0.163426332205657, 0.0505036003452980, 0.0562400408470712, 0.147873671380712, 0.0792157511238543, 0.0106458384443815, 0.000730298431464311, 0, 0, 0.450376906335534, 0.000387254433650502, 0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
ConnectivityData(9).preConnectionProportionArr = ...
    [[0.977067493106896, 0.0169357474080110, 0, 0, 0.00264675075613587, 0.0153232938513129, 0.000585275994704325, 0, 0.0109558949119175, 0, 0, 0, 0, 0, 0]; ...
    [0.629495970563454, 0.0513280664916290, 0.0505902964981303, 0.00597038936476097, 0.0721422048241951, 0.0812777114710386, 0.00569734612572197, 0, 0.0779942568008300, 0, 0, 0, 0.0244724567346317, 0, 0]; ...
    [0.0398763783397410, 0.00149302838007927, 0, 0.174273415081861, 0.0538556717716011, 0.0599728565799825, 0.0948815733707477, 0.0844735318373067, 0.0113524338279674, 0.000778770470844638, 0, 0, 0.480269736717373, 0.000412957641201524, 0]; ...
    [0.499253330362575, 0.0200141956732839, 0, 0.0359201891669486, 0.0221296919709657, 0.0817012242545915, 0.00998044447329145, 0, 0.127116093546383, 0.0109397342135266, 0.0209808101735804, 0.124588676252340, 0.0249407622110888, 0.0223154188204479, 0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
ConnectivityData(10).preConnectionProportionArr = ...
    [[0.955670701944716, 0.0165648716465912, 0, 0, 0.00258878958806211, 0.0149877291940438, 0.000572459041608174, 0, 0.0107159718799070, 0, 0, 0, 0, 0, 0]; ...
    [0.630208977371440, 0.0513862038945047, 0.0506475982562161, 0.00597715180401788, 0.0722239176318827, 0.0813697717292870, 0.00570379929899877, 0, 0.0780825980113910, 0, 0, 0, 0.0245001757814181, 0, 0]; ...
    [0.0398195055188899,0.00149089898069244,0,0.174024861398509,0.0537788612862961,0.0598873215923479,0.0947462505819426,0.0843530532922916,0.0113362426651235,0.000777659766329421,0,0,0.479584762408427,0.000412368669310771,0]; ...
    [0.492712639145920, 0.0183658485380435, 0, 0.0356943421846094, 0.0221705505469502, 0.0810102362014516, 0.00938399170269580, 0, 0.125203838124089, 0.0129269695799989, 0.0200921703621242, 0.129534747600388, 0.0250809058864310, 0.0277960998106273, 0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
ConnectivityData(11).preConnectionProportionArr = ...
    [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    [0.494516186518294, 0.0250684804732124, 0, 0.0355793619903446, 0.0219197153364183, 0.0809260056871624, 0.0116822259543773, 0, 0.125909957936602, 0.0108359330139432, 0.0234176451546522, 0.123406521933314, 0.0247041128569540, 0.0221036799246431, 0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
ConnectivityData(12).preConnectionProportionArr = ...
    [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    [0.494516186518294, 0.0250684804732124, 0, 0.0355793619903446, 0.0219197153364183, 0.0809260056871624, 0.0116822259543773, 0, 0.125909957936602, 0.0108359330139432, 0.0234176451546522, 0.123406521933314, 0.0247041128569540, 0.0221036799246431, 0]; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
ConnectivityData(13).preConnectionProportionArr = ...
    [0.0  0.0  0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0; ...
    [0.628926032482020, 0.0512815946774985, 0.0505444926520795, 0.00596498384602998, 0.0720768881395290, 0.0812041236085180, 0.00569218781705600, 0, 0.0779236417386810, 0, 0, 0, 0.0244502996666097, 0, 0]; ...
    [0.0398153162262826,0.00149074212761260,0,0.174006552756655,0.0537732033710839,0.0598810210240624,0.0947362826086600,0.0843441787566097,0.0113350500125033,0.000777577951041470,0,0,0.479534306711562,0.000412325285220604,0]; ...
    [0.510293174784634, 0.00871867096384176, 0, 0.0367144819155339, 0.0226190394457038, 0.0835078597841080, 0.00618006814807664, 0, 0.129926974938547, 0.0111816413904869, 0.0155447815201481, 0.127343669597256, 0.0254922700685888, 0.0228088732192636, 0]; ...
    [0.0607866020125030, 0.00297354671755305, 0, 0.0179901970705064, 0.0210979926714942, 0.0310549182367047, 0.00208006821809355, 0, 0.00173940271651571, 0.119870167587223, 0.00860529775881708, 0, 0.0290131896312356, 0.323912511469851, 0.381167593013344];];
ConnectivityData(14).preConnectionProportionArr = ...
    [[0.977067493106896, 0.0169357474080110, 0, 0, 0.00264675075613587, 0.0153232938513129, 0.000585275994704325, 0, 0.0109558949119175, 0, 0, 0, 0, 0, 0]; ...
    [0.631082536313394, 0.0514574324544221, 0.0507178030040599, 0.00598543698336838, 0.0723240302157012, 0.0814825617628333, 0.00571170557304383, 0, 0.0781908315563785, 0, 0, 0, 0.0245341364966757, 0, 0]; ...
    [0.0397157874534957,0.00148701562865276,0,0.173571577970713,0.0536387832170425,0.0597313327859512,0.0944994645486742,0.0841333384720405,0.0113067150970951,0.000775634192042459,0,0,0.478335585576586,0.000411294570573161,0]; ...
    [0.510377579851588, 0.00872011307602904, 0, 0.0367205546761691, 0.0226227807490039, 0.0835216724056450, 0.00618109036254392, 0, 0.129948465516044, 0.0111834908904153, 0.0155473527054780, 0.127364732883009, 0.0254964866187373, 0.0228126459220281, 0]; ...
    [0.0608792402240060, 0.00235407447329153, 0, 0.0180176139621573, 0.0211301458145007, 0.0311022456409117, 0.00179786898301782, 0, 0.00174205354994621, 0.120052848598667, 0.00781998300861071, 0, 0.0290574054601921, 0.324406151100173, 0.381748488851088;]];
ConnectivityData(15).preConnectionProportionArr = ...
    [0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    0 0 0 0 0 0 0 0 0 0 0 0 0 0 0; ...
    [0.0607559349977177, 0.00299113161131485, 0, 0.0179811209645672, 0.0210873486737747, 0.0310392509415246, 0.00208774678893001, 0, 0.00173852518286423, 0.119809692744412, 0.00862537618535276, 0, 0.0289985523939838, 0.323749096680251, 0.380975292871148;]];


invertingRatioArr = ...
    {ConnectivityData.preConnectionProportionArr};
for iPost=1:numGroups
  for iPre=1:numGroups
    invertingRatioArr{iPost}(:,iPre) = ...
        ones(numLayers,1) ...
        .* (popProportion(iPost)...
            / popProportion(iPre));
  end
end

% Calculate the absolute number of synapses (all:one) from the
% preConnectionProportionArr and the total number of synapses received in
% each layer
for iPost = 1:numGroups
  ConnectivityData(iPost).numConnectionsToOneFromAll = ...
  round(ConnectivityData(iPost).preConnectionProportionArr ...
   .* repmat(ConnectivityData(iPost).incomingSynapses, ...
                                        1,numGroups));
end

% Calculate the absolute number of synapses (one:all) from the already
% established number of all:one connections and the invertingRatioArr
CP = struct();
for iPost = 1:numGroups
  CP(iPost).numConnectionsToAllFromOne = cell(1,numLayers);
  for iPre = 1:numGroups
    CP(iPost).numConnectionsToAllFromOne{iPre} = ...
         (round(ConnectivityData(iPre).numConnectionsToOneFromAll(:,iPost) ...
         .* invertingRatioArr{iPre}(:,iPost)))';
  end
end

clear ConnectivityData popProportion numLayers;
%%
% Patterns of connectivity for each cell type. Rows: post, cols: pre.
% Based on Traub et al. 2005 J. Neurophysiol.

for iPre = 1:numGroups
  CP(iPre).targetCompartments = cell(1,numGroups);
end

CP(1).targetCompartments{1} = [NP(1).obliqueID NP(1).basalID];
CP(1).targetCompartments{2} = NP(2).distalID;
CP(1).targetCompartments{3} = NP(3).distalID;
CP(1).targetCompartments{4} = NP(4).distalID;
CP(1).targetCompartments{5} = NP(5).distalID;
CP(1).targetCompartments{6} = [NP(6).obliqueID NP(6).basalID];
CP(1).targetCompartments{7} = NP(7).distalID;
CP(1).targetCompartments{8} = NP(8).distalID;
CP(1).targetCompartments{9} = ...
              unique([NP(9).basalID NP(9).apicalID ...
                      NP(9).proximalID NP(9).obliqueID]);
CP(1).targetCompartments{10} = ...
            unique([NP(10).basalID NP(10).apicalID ...
                    NP(10).proximalID NP(10).obliqueID]);
CP(1).targetCompartments{11} = NP(11).distalID;
CP(1).targetCompartments{12} = NP(12).distalID;
CP(1).targetCompartments{13} = ...
            unique([NP(13).basalID NP(13).apicalID ...
                    NP(13).tuftID ...
                    NP(13).proximalID NP(13).obliqueID]);
CP(1).targetCompartments{14} = ...
            unique([NP(14).basalID NP(14).apicalID ...
                    NP(14).tuftID ...
                    NP(14).proximalID NP(14).obliqueID]);
CP(1).targetCompartments{15} = NP(15).distalID;
                                                
CP(2).targetCompartments{1} = unique([NP(1).somaID NP(1).proximalID]);
CP(2).targetCompartments{2} = NP(2).distalID;
CP(2).targetCompartments{3} = NP(3).distalID;
CP(2).targetCompartments{4} = unique([NP(4).somaID NP(4).proximalID]);
CP(2).targetCompartments{5} = unique([NP(5).somaID NP(5).proximalID]);
CP(2).targetCompartments{6} = unique([NP(6).somaID NP(6).proximalID]);
CP(2).targetCompartments{7} = NP(7).distalID;
CP(2).targetCompartments{8} = NP(8).distalID;
CP(2).targetCompartments{9} = unique([NP(9).somaID NP(9).proximalID]);
CP(2).targetCompartments{10} = unique([NP(10).somaID NP(10).proximalID]);
CP(2).targetCompartments{11} = NP(11).distalID;
CP(2).targetCompartments{12} = NP(12).distalID;
CP(2).targetCompartments{13} = unique([NP(13).somaID NP(13).proximalID]);
CP(2).targetCompartments{14} = unique([NP(14).somaID NP(14).proximalID]);
CP(2).targetCompartments{15} = NP(15).distalID;
                                                
                                                
CP(3).targetCompartments{1} = ...
                 unique([NP(1).obliqueID NP(1).tuftID ...
                         NP(1).apicalID NP(1).distalID]);
CP(3).targetCompartments{2} = NP(2).distalID;
CP(3).targetCompartments{3} = NP(3).distalID;
CP(3).targetCompartments{4} = NP(4).distalID;
CP(3).targetCompartments{5} = NP(5).distalID;
CP(3).targetCompartments{6} = ...
                 unique([NP(6).obliqueID NP(6).tuftID ...
                         NP(6).apicalID NP(6).distalID]);
CP(3).targetCompartments{7} = NP(7).distalID;
CP(3).targetCompartments{8} = NP(8).distalID;
CP(3).targetCompartments{9} = ...
               unique([NP(9).obliqueID NP(9).distalID ...
                           NP(9).tuftID NP(9).apicalID]);
CP(3).targetCompartments{10} = ...
             unique([NP(10).obliqueID NP(10).distalID ...
                         NP(10).tuftID NP(10).apicalID]);
CP(3).targetCompartments{11} = NP(11).distalID;
CP(3).targetCompartments{12} = NP(12).distalID;
CP(3).targetCompartments{13} = ...
             unique([NP(13).obliqueID NP(13).distalID ...
                         NP(13).tuftID NP(13).apicalID]);
CP(3).targetCompartments{14} = ...
             unique([NP(14).obliqueID NP(14).distalID ...
                         NP(14).tuftID NP(14).apicalID]);
CP(3).targetCompartments{15} = NP(15).distalID;

                                                
CP(4).targetCompartments{1} = NP(1).basalID;
CP(4).targetCompartments{2} = NP(2).distalID;
CP(4).targetCompartments{3} = NP(3).distalID;
CP(4).targetCompartments{4} = NP(4).distalID;
CP(4).targetCompartments{5} = NP(5).distalID;
CP(4).targetCompartments{6} = NP(6).basalID;
CP(4).targetCompartments{7} = NP(7).distalID;
CP(4).targetCompartments{8} = NP(8).distalID;
CP(4).targetCompartments{9} = ...
                unique([NP(9).obliqueID NP(9).trunkID NP(9).apicalID]);
CP(4).targetCompartments{10} = ...
                unique([NP(10).obliqueID NP(10).trunkID NP(10).apicalID]);
CP(4).targetCompartments{11} = NP(11).distalID;
CP(4).targetCompartments{12} = NP(12).distalID;
CP(4).targetCompartments{13} = ...
                unique([NP(13).apicalID NP(13).trunkID]);
CP(4).targetCompartments{14} = ...
                unique([NP(14).apicalID NP(14).trunkID]);
CP(4).targetCompartments{15} = NP(15).distalID;
                          
CP(5).targetCompartments = CP(4).targetCompartments;
CP(6).targetCompartments = CP(1).targetCompartments;

CP(7).targetCompartments = CP(2).targetCompartments;
CP(8).targetCompartments = CP(3).targetCompartments;

CP(9).targetCompartments{1} = [NP(1).apicalID, NP(1).tuftID];
CP(9).targetCompartments{2} = NP(2).distalID;
CP(9).targetCompartments{3} = NP(3).distalID;
CP(9).targetCompartments{4} = NP(4).distalID;
CP(9).targetCompartments{5} = NP(5).distalID;
CP(9).targetCompartments{6} = [NP(6).apicalID, NP(6).tuftID];
CP(9).targetCompartments{7} = NP(7).distalID;
CP(9).targetCompartments{8} = NP(8).distalID;
CP(9).targetCompartments{9} = ...
               unique([NP(9).obliqueID NP(9).apicalID ...
                           NP(9).trunkID NP(9).basalID]);
CP(9).targetCompartments{10} = ...
             unique([NP(10).obliqueID NP(10).apicalID ...
                         NP(10).trunkID NP(10).basalID]);
CP(9).targetCompartments{11} = NP(11).distalID;
CP(9).targetCompartments{12} = NP(12).distalID;
CP(9).targetCompartments{13} = ...
             unique([NP(13).obliqueID NP(13).apicalID ...
                     NP(13).trunkID NP(13).basalID ...
                     NP(13).tuftID]);
CP(9).targetCompartments{14} = ...
             unique([NP(14).obliqueID NP(14).apicalID ...
                     NP(14).trunkID NP(14).basalID ...
                     NP(14).tuftID]);
CP(9).targetCompartments{15} = NP(15).distalID;
                         
CP(10).targetCompartments = CP(9).targetCompartments;
CP(11).targetCompartments = CP(2).targetCompartments;
CP(12).targetCompartments = CP(3).targetCompartments;
                                                
CP(13).targetCompartments{1} = NP(1).apicalID;
CP(13).targetCompartments{2} = NP(2).distalID;
CP(13).targetCompartments{3} = NP(3).distalID;
CP(13).targetCompartments{4} = NP(4).distalID;
CP(13).targetCompartments{5} = NP(5).distalID;
CP(13).targetCompartments{6} = NP(6).apicalID;
CP(13).targetCompartments{7} = NP(7).distalID;
CP(13).targetCompartments{8} = NP(8).distalID;
CP(13).targetCompartments{9} = ...
               unique([NP(9).obliqueID NP(9).apicalID ...
                           NP(9).trunkID NP(9).basalID]);
CP(13).targetCompartments{10} = ...
             unique([NP(10).obliqueID NP(10).apicalID ...
                         NP(10).trunkID NP(10).basalID]);
CP(13).targetCompartments{11} = NP(11).distalID;
CP(13).targetCompartments{12} = NP(12).distalID;
CP(13).targetCompartments{13} = ...
             unique([NP(13).obliqueID NP(13).apicalID ...
                     NP(13).trunkID NP(13).basalID ...
                     NP(13).tuftID]);
CP(13).targetCompartments{14} = ...
             unique([NP(14).obliqueID NP(14).apicalID ...
                     NP(14).trunkID NP(14).basalID ...
                     NP(14).tuftID]);
CP(13).targetCompartments{15} = NP(15).distalID;

CP(14).targetCompartments = CP(13).targetCompartments;
CP(15).targetCompartments = CP(2).targetCompartments;

groupWeightMat =  [ ...
0.020 0.101 0.001 0.889/2.5 0.090/2.5 0.182/2.5 0.864 0.000 0.004 0.000 0.000 0.000 0.047 0.000 0.000;...
0.560 0.021 0.001 1.401/2 0.156/2 0.321/2 0.182 0.000 0.074 0.000 0.000 0.000 0.159 0.000 0.000;...
0.408 0.055 0.011 1.743/2 0.169/2 0.346/2 0.465 0.000 0.159 0.000 0.000 0.000 0.178 0.000 0.000;...
0.001 0.034 0.000 0.067 0.092 0.061 0.008 0.002 0.069 0.069 0.000 0.000 0.004 0.000 0.000;...
0.001 0.034 0.000 0.067 0.092 0.061 0.009 0.002 0.069 0.069 0.000 0.000 0.004 0.000 0.000;...
0.001 0.034 0.006 0.067 0.092 0.061 0.011 0.001 0.069 0.069 0.000 0.000 0.004 0.004 0.000;...
0.507/5 0.078 0.000 0.358*1.75 0.358*1.75 0.358*1.75 0.020 0.002 0.841 0.841 0.000 0.000 0.062 0.062 0.000;...
0.696/5 0.195 0.000 0.318 0.318 0.318 0.054 0.010 1.058 1.058 0.000 0.000 0.052 0.000 0.000;...
0.037 0.150 0.003 0.091 0.082 0.050 0.273 0.004 0.079 0.471 0.367 0.002 0.032 0.093 0.000;...
0.037 0.150 0.003 0.091 0.082 0.050 0.231 0.004 0.062 0.335 0.333 0.002 0.032 0.093 0.000;...
0.208/2.5 0.078 0.000 0.274 0.273 0.151 0.153 0.000 0.364*2.5 3.966 0.133 0.002 0.342 0.207 0.000;...
0.160/2.5 0.195 0.000 0.331 0.422 0.196 0.417 0.000 0.241*2.5 2.596 0.133 0.011 0.359 0.657 0.000;...
0.003 0.836 0.012 0.137 0.145 0.095 0.181 0.001 0.253/3 0.164/3 0.704/3 0.003 0.064 0.062 0.060;...
0.003 0.836 0.012 0.137 0.145 0.095 0.782 0.013 0.604/3 0.164/3 0.704/3 0.003 0.064 0.062 0.038;...
0.493/4 0.112 0.000 0.274 0.273 0.151 0.154 0.000 0.362/4 0.362/4 0.017 0.000 0.442*2.5 0.307*2.5 0.012];

ex = [1 4 5 6 9 10 13 14];
in = [2 3 7 8 11 12 15];

for iGroup = 1:numGroups
  CP(iGroup).weights = cell(1,numGroups);
end

arborRadii = [ ...
  0.55	1.12	0.15	1.00	0.15;
  0.05	0.50	0.15	0.15	0.05;
  0.20	0.20	0.20	0.20	0.20;
  0.05	0.30	1.12	0.40	0.15;
  0.15	0.40	0.50	0.15	0.15;
  0.15	1.12	0.15	0.55	0.15;
  0.05	0.05	0.50	0.05	0.05;
  0.20	0.20	0.20	0.20	0.20;
  0.15	0.40	0.30	0.50	0.25;
  0.05	0.05	0.15	0.50	1.00;
  0.05	0.05	0.05	0.50	0.05;
  0.20	0.20	0.20	0.20	0.20;
  0.05	0.15	1.00	0.15	0.15;
  0.05	0.05	0.15	0.50	1.00;
  0.05	0.05	0.05	0.05	0.50].*0.5.*1000;

for iPre = 1:numGroups
  CP(iPre).axonArborSpatialModel = 'gaussian';
  CP(iPre).sliceSynapses = true;
  CP(iPre).axonArborRadius = arborRadii(iPre, :);
  CP(iPre).axonConductionSpeed = 0.3;
  CP(iPre).synapseReleaseDelay = 1.0;
  for iPost = 1:numGroups
    CP(iPre).synapseType{iPost} = 'g_exp';
    if ismember(iPre,ex) && ismember(iPost,ex)
      CP(iPre).tau{iPost} = 2;
      CP(iPre).E_reversal{iPost} = 0;
      CP(iPre).weights{iPost} = groupWeightMat(iPost, iPre);
    elseif ismember(iPre,ex) && ismember(iPost,in)
      CP(iPre).tau{iPost} = 0.8;
      CP(iPre).E_reversal{iPost} = 0;
      CP(iPre).weights{iPost} = groupWeightMat(iPost, iPre);
    elseif ismember(iPre,in) && ismember(iPost,ex)
      CP(iPre).tau{iPost} = 6;
      CP(iPre).E_reversal{iPost} = -75;
      CP(iPre).weights{iPost} = groupWeightMat(iPost, iPre).*1.25;
    elseif ismember(iPre,in) && ismember(iPost,in)
      CP(iPre).tau{iPost} = 3;
      CP(iPre).E_reversal{iPost} = -75;
      CP(iPre).weights{iPost} = groupWeightMat(iPost, iPre).*1.25;
    else
      disp('WTF?!')
    end
  end
end

clear numGroups arborRadii ex in groupWeightMat iPre iPost;
