#Python program to read in the output of NRDPostAB, and calculate FRET
#NRDPostAB  creates a file with region averages and stdev:
#  soma, soma submemb, soma cyt
#  dend, dend submemb, dend cyt
#1. read in the two molecule files
#2. extract the appropriate columes
import os
from numpy import *
from pylab import *
from string import *
from pprint import pprint as pp
import glob
#######################################################
#Edit this part to indicate which files 
prefix='Model_092*'
suffix='_avg.txt'
FRETmolecule=['Epac1', 'Epac1cAMP']

#specify which regions to process, and output column name
regionList=['_AVG_SM_dend', '_AVG_CT_dend', '_AVG_SM_soma', '_AVG_CT_soma']
regionAbbrev=['_dsm', '_dcyt', '_ssm','_scyt']

prninfo=1

########## Parameters related to FRET  calibration
Epac1=0
Epac1cAMP=1
beta=0.35
gamma=0.12
delta=0.67
#measure basal during 10 sec prior to stim
basal_start=900
basal_end=1000

##############End of parameters###################
#determine what files are available for processing
fnamelist=[]
for mol in FRETmolecule:
    fnamelist.append([])

for molnum,mol in enumerate(FRETmolecule):
    pattern=prefix+'*'+mol+suffix
    fnamelist[molnum]=sorted(glob.glob(pattern))

if prninfo:
    pp(fnamelist)

#open the files
for fnum in range(size(fnamelist[0])):
    for molnum,mol in enumerate(FRETmolecule):
        f = open(fnamelist[molnum][fnum], 'r+')
        dataheader=f.readline()
        if (prninfo==1):
            print "HEADER: for", fnamelist[molnum][fnum],dataheader
        else:
            print "header not printed"
        alldata=loadtxt(fnamelist[molnum][fnum],skiprows=1)
        if prninfo:
            print "DATA for", FRETmolecule[molnum], alldata[0]
        f.close()
    
        ##Initialize epac data array once per filename
        if molnum==0:
            allepac=zeros((len(FRETmolecule),shape(alldata)[0],len(regionList)))
        else:
            shapedif=shape(alldata)[0]-shape(allepac)[1]
            if shapedif>0:
                alldata=alldata[0:shape(allepac)[1],:]
            if shapedif<0:
                allepac=allepac[:,0:shape(alldata)[0],:]
            
        #find the columns in the regionList and copy conc into epac array
        columns=dataheader.split(' ')
        for regnum,region in enumerate(regionList):
            colname=FRETmolecule[molnum]+region
            colnum=-1
            for kk in range(len(columns)):
                if columns[kk]==(mol+region):
                    colnum=kk
            if prninfo==1 and colnum>-1:
                print regnum,region,"col=",colnum
            else:
                print mol+region, columns, "NOT FOUND"
            allepac[molnum,:,regnum]=alldata[:,colnum]
            print allepac[molnum,0,regnum]
    
    #calculate FRET
    NormFRET=zeros((shape(alldata)[0],len(regionList)))
    header="Time   "
    for regnum in range(len(regionList)):
        #cyan=(1-beta)*epac+epaccAMP
        #yellow=beta*epac+gamma*(epac+epaccamp)+delta*(1-beta)*epac+epaccAMP
        cyan=(1-beta)*allepac[Epac1,:,regnum]+allepac[Epac1cAMP,:,regnum]
        yellow=beta*allepac[Epac1,:,regnum]+gamma*(allepac[Epac1,:,regnum]+allepac[Epac1cAMP,:,regnum])+delta*cyan
        FRET=cyan/yellow
        #
        #Delta FRET - baseline from 400-1000, then normalize
        basal=FRET[basal_start:basal_end].mean()
        NormFRET[:,regnum]=1+(FRET-basal)/basal
        out_colname="Fret"+fnamelist[0][fnum].split("-")[0][7:]+regionAbbrev[regnum]
        if len(out_colname)>31:
            print "Truncating column name for igor", out_colname[0:31]
        header=header+out_colname[0:31]+" "
    #output file for each input file
    outfname=fnamelist[0][fnum].split("-")[0]+'-fret.txt'
    print "\nOUTPUT: ", outfname, "; OUT HEADER: ", header,"\n"
    f=open(outfname,'w')
    savetxt(outfname, column_stack((alldata[:,0],NormFRET)), fmt='%.4f', delimiter=' ', header=str(header))
    f.close()

        
