#Python program to read in the output of NRDPostAB, and sum over molecule species
#NRDPostAB  creates a file with region averages and stdev:
#  soma, soma submemb, soma cyt
#  dend, dend submemb, dend cyt
#1. read in the molecule files
#2. extract the appropriate colums
import os
import numpy as np
import glob as glob
from pylab import *
from string import *

#######################################################
#Edit this part to indicate which regions to process
prefix='Model_'
suffix='_avg.txt'
regionList=['_AVG_SM_dend', '_AVG_CT_dend', '_AVG_SM_soma', '_AVG_CT_soma', '_AVG_dend', '_AVG_soma','_AVG_TOTAL']
regionAbbrev=['_dsm', '_dcy', '_ssm','_scy', '_dnd', '_som','_all']
allformslen=0

#######Change this as needed to indicate which files and molecules
moleculeSpecies=['PKAc', 'PKAcPDE4', 'PKAcPDE4cAMP']#,'I1PKAc']# ['pPDE4', 'pPDE4cAMP']
#['AC1GasGTPGaiGTP','AC1GasGTPGaiGTPCaMCa4','AC1GsGiCaMCa4ATP']#'GaiGTP','AC1GaiGTPCaMCa4','AC1GaiGTPCaMCa4ATP']#,
allformslen=len(moleculeSpecies)
molecule_name='PKAc'#'pPDE4' #'AcGsGi' #
fnamelist=['0783_pPDE2x_LCa','0782_pPDE2x_Ca','0893_DR_pPDE10x_LCa']#, '0903_DR_PKA3d_LCa','0901_DR_10xPKA_LCa', '0893_DR_pPDE10x_LCa'] #['0843_SW_Gibind1x_LCa']# 
#molecule_name='PKAc'
#fnamelist=['0846_SW_Iso10u_LCa', '0847_SW_Isop1_LCa', '0843_SW_Gibind1x_LCa', '0849_SW_Isop4_LCa', '0859_SW_Isop04_LCa']
#molecule_name='PDE4D5'
#fnamelist=['0893_DR_pPDE10x_LCa']#['0918_DR_Gbg_Ep10x_LCa']#

#to make filenames a parameter
#try:
    #fnameset=ARGS.split(" ")
    #do_exit = False
#except NameError:
    #fnameset=sys.argv[1:]
#fnamelist=fnameset.split(' ')
print fnamelist
prninfo=1
###################################################

def readdata(fullname,prninfo):
    f = open(fullname, 'r+')
    dataheader=f.readline()
    if (prninfo==1):
        print "FILE: ", fullname, "\n", 'HEADER: ', dataheader
    else:
        print "header not printed"
    alldata=np.loadtxt(fullname,skiprows=1)
    print "dataline:", alldata[-1]
    f.close()
    return alldata,dataheader

def findcolumns(alldata,allforms,molnum,regionList,prninfo):
    if molnum>0:
        ##re-dimension data array if different sizes for different molecules
        shapedif=shape(alldata)[0]-shape(allforms)[1]
        if shapedif>0:
            alldata=alldata[0:shape(allforms)[1],:]
        if shapedif<0:
            allforms=allforms[:,0:shape(alldata)[0],:]
    #find the columns in the regionList and copy conc into epac array
    columns=dataheader.split(' ')[1:]
    for regnum,listregion in enumerate(regionList):
        colnum=-1
        for col,colname in enumerate(columns):
            colregion=colname[find(colname,'_'):]
            #if colname==(mol+region):
            if colregion==listregion:
                colnum=col+1
        if prninfo==2:
            if colnum>-1:
                print regnum,listregion,"col=",colnum,columns[colnum-1]
            else:
                print "NOT FOUND:", colname, "NOT IN ", columns
        allforms[molnum,:,regnum]=alldata[:,colnum]
    if prninfo==1:
        print "FINDCOLLUMNS:", allforms[molnum,-1,regnum]
    return allforms

#FIRST PART = open the files
for fname in fnamelist:
    if allformslen==0:
        #use glob if moleculeSpecies not defined
        pattern=prefix+fname+'*'+molecule_name+'*'
        allfiles=sorted(glob.glob(pattern))
        allformslen=len(allfiles)
        print allfiles
        for molnum,fullname in enumerate(allfiles):
            alldata,dataheader=readdata(fullname,prninfo)
            if molnum==0:
                ##Initialize data array once per filename
                allforms=np.zeros((allformslen,np.shape(alldata)[0],len(regionList)))
            allforms=findcolumns(alldata,allforms,molnum,regionList,prninfo)
    else:
        #loop over moleculeSpecies
        for molnum,mol in enumerate(moleculeSpecies):
            fullname=prefix+fname+'-'+mol+suffix
            alldata,dataheader=readdata(fullname,prninfo)
            if molnum==0:
                ##Initialize data array once per filename
                allforms=np.zeros((allformslen,np.shape(alldata)[0],len(regionList)))
                print np.shape(alldata)
            allforms=findcolumns(alldata,allforms,molnum,regionList,prninfo)
    #
    #SUM COLUMNS
    mol_total=zeros((shape(allforms)[0],len(regionList)))
    header="Time"
    mol_total=sum(allforms,axis=0)
    for region in regionAbbrev:
        header=header+" "+molecule_name+"tot"+fname[1:]+region
    #output file for each input file
    outfname=fname+'-'+molecule_name+'tot.txt'
    print "\nOUTPUT: ", outfname, "\n"
    f=open(outfname,'w')
    savetxt(outfname, column_stack((alldata[:,0],mol_total)), fmt='%.4f', delimiter=' ', header=str(header))
    f.close()

        
