################################################################################
#                                                                              #
#              STEPS model of Cerebellar Long-Term Depression                  #
#                                                                              #
#              Project supervision: Erik De Schutter (2009-2018)               #
#                                                                              #
#                           Scripts Authors:                                   #
#                                                                              #
#  Original development (2008-2012): Gabriela Antunes                          #
#  Modified for STEPS 1.3 (2013):    Iain Hepburn and Cory Simon               #
#  Addition of RKIP, improved calcium dynamics, and other                      #
#      modifications (2014-2016):    Anant Jain, Iain Hepburn, Himanshu Gangal #
#  Addition of CaMKII activity and its regulatory pathway                      #
#  for STEPS 3.3.0(2016-2018)          Criseida Zamora                         #
#                                                                              #
#                                                                              #
#                                                                              #
################################################################################


import datetime
import steps.model as smodel
import math
import sys
import numpy 
import numpy as np
from numpy import mean
import steps.solver as swmdirect
import steps.geom as swm
import steps.rng as srng

DT = 0.1   #time step
INT = 3000 #final time (s) simulated
NITER = 1   # Number of runs used to calculate the mean

##CaMKII initial concentration
Kin=20
##CAMKII kinetic constants
kon_cam=400e6
koff_cam=8
k_t286=11e6
k_t350=0.5e6
kon_cam_t286=400e6
koff_cam_t286=0.0008
# Avogadro constant
Na = 6.02214129e23
########################################################################

# Ca2+ input signal.
# This signal generated is a train of calcium pulses and could be varied by the frequency, amplitude and width.
# The duration and amplitude of the pulse should be checked directly in the Ca2+ concentration
# The changes in [Ca2+] generated by the pulses are sensitive to stochasticity
# altering max_molar alters the maximum molar concentration per second injection (M/s)

# Ca pulse peak (uM)
ca_peak = 1500
# Ca pulse width (s)
ca_width = 0.2
#dpulse is the pulse duration to set the stimulation frequency. Example: dpulse=1, frequency=1/dpulse=1.
dpulse=1
#num_p is the number of pulses
num_p=100
#start is the starting point of calcium stimulus

def square_pulse_ica(t,max_molar=float(ca_peak)*1e-6, duration=float(ca_width), start=1000, dp=dpulse):
    np=1
    while np<=num_p:
        
        if t>start and t<start+duration : return max_molar
        start=start+dpulse
        np+=1;
    else: return 0
          
######################################################################## 

def gen_model(): 
    mdl=smodel.Model() 
    
    Ca = smodel.Spec('Ca', mdl)
    PMCA = smodel.Spec('PMCA', mdl)
    Ca1PMCA = smodel.Spec('Ca1PMCA', mdl) 
    NCX = smodel.Spec('NCX', mdl) 
    Ca1NCX = smodel.Spec('Ca1NCX', mdl)  
    Ca2NCX = smodel.Spec('Ca2NCX', mdl)
    SERCA = smodel.Spec('SERCA', mdl) 
    Ca1SERCA = smodel.Spec('Ca1SERCA', mdl)  
    Ca2SERCA = smodel.Spec('Ca2SERCA', mdl)            
    PV = smodel.Spec('PV', mdl)
    MgPV = smodel.Spec('MgPV', mdl)  
    CaPV = smodel.Spec('CaPV', mdl)
    Mg2PV = smodel.Spec('Mg2PV', mdl)  
    Ca2PV = smodel.Spec('Ca2PV', mdl)
    CBf = smodel.Spec('CBf', mdl)              
    CaCBf = smodel.Spec('CaCBf', mdl) 
    Ca2CBf = smodel.Spec('Ca2CBf', mdl) 
    CBs = smodel.Spec('CBs', mdl)              
    CaCBs = smodel.Spec('CaCBs', mdl)  
    Ca2CBs = smodel.Spec('Ca2CBs', mdl) 
    PKC = smodel.Spec('PKC', mdl)
    Ca1PKC = smodel.Spec('Ca1PKC', mdl)
    Ca3PKC = smodel.Spec('Ca3PKC', mdl)
    AAPKC = smodel.Spec('AAPKC', mdl)    
    AACa1PKC = smodel.Spec('AACa1PKC', mdl)  
    AACa3PKC = smodel.Spec('AACa3PKC', mdl)                      
    PKCstar = smodel.Spec('PKCstar', mdl) 
    PKCstar2 = smodel.Spec('PKCstar2', mdl)       
    PKCstar4 = smodel.Spec('PKCstar4', mdl)
    PKCstar3 = smodel.Spec('PKCstar3', mdl) 
    Raf = smodel.Spec('Raf', mdl)  
    Rafstar = smodel.Spec('Rafstar', mdl)           
    PP5 = smodel.Spec('PP5', mdl)       
    PP5Rafstar = smodel.Spec('PP5Rafstar', mdl)        
    MEK = smodel.Spec('MEK', mdl)                    
    RafstarMEK = smodel.Spec('RafstarMEK', mdl)        
    MEKp = smodel.Spec('MEKp', mdl)
    PP1 = smodel.Spec('PP1', mdl)
    PP2A = smodel.Spec('PP2A', mdl)
    PP2AMEKp = smodel.Spec('PP2AMEKp', mdl)
    RafstarMEKp = smodel.Spec('RafstarMEKp', mdl)        
    MEKstar = smodel.Spec('MEKstar', mdl)                
    PP2AMEKstar = smodel.Spec('PP2AMEKstar', mdl)
    ERK = smodel.Spec('ERK', mdl)                         
    MEKstarERK = smodel.Spec('MEKstarERK', mdl)           
    ERKp = smodel.Spec('ERKp', mdl)                       
    MKP = smodel.Spec('MKP', mdl)                       
    MKPERKp = smodel.Spec('MKPERKp', mdl)             
    MEKstarERKp = smodel.Spec('MEKstarERKp', mdl)        
    ERKstar = smodel.Spec('ERKstar', mdl)             
    MKPERKstar = smodel.Spec('MKPERKstar', mdl) 
    PLA2 = smodel.Spec('PLA2', mdl)            
    Ca1PLA2 = smodel.Spec('Ca1PLA2', mdl)
    Ca2PLA2 = smodel.Spec('Ca2PLA2', mdl)
    PLA2memb = smodel.Spec('PLA2memb', mdl)
    Ca1PLA2memb = smodel.Spec('Ca1PLA2memb', mdl) 
    PLA2star1 = smodel.Spec('PLA2star1', mdl)                     
    ERKstarPLA2 = smodel.Spec('ERKstarPLA2', mdl)         
    PLA2star2 = smodel.Spec('PLA2star2', mdl)                              
    Ca1PLA2star2 = smodel.Spec('Ca1PLA2star2', mdl)
    Ca2PLA2star2 = smodel.Spec('Ca2PLA2star2', mdl)
    PLA2star2memb = smodel.Spec('PLA2star2memb', mdl)
    Ca1PLA2star2memb = smodel.Spec('Ca1PLA2star2memb', mdl)
    Ca2PLA2star2memb = smodel.Spec('Ca2PLA2star2memb', mdl)
    PLA2star1APC = smodel.Spec('PLA2star1APC', mdl)
    ERKstarCa1PLA2 = smodel.Spec('ERKstarCa1PLA2', mdl)
    ERKstarCa2PLA2 = smodel.Spec('ERKstarCa2PLA2', mdl)
    PP2ACa1PLA2star2 = smodel.Spec('PP2ACa1PLA2star2', mdl)
    PP2ACa2PLA2star2 = smodel.Spec('PP2ACa2PLA2star2', mdl)
    PP1Ca1PLA2star2 = smodel.Spec('PP1Ca1PLA2star2', mdl)
    PP1Ca2PLA2star2 = smodel.Spec('PP1Ca2PLA2star2', mdl)
    PLA2star2membAPC = smodel.Spec('PLA2star2membAPC', mdl)
    Ca1PLA2star2membAPC = smodel.Spec('Ca1PLA2star2membAPC', mdl)
    Ca2PLA2star2membAPC = smodel.Spec('Ca2PLA2star2membAPC', mdl)
    PP1PLA2star2 = smodel.Spec('PP1PLA2star2', mdl) 
    PP2APLA2star2 = smodel.Spec('PP2APLA2star2', mdl)
    AA = smodel.Spec('AA', mdl)              
    AMPAR = smodel.Spec('AMPAR', mdl)    
    PKCstarAMPAR = smodel.Spec('PKCstarAMPAR', mdl) 
    PKCstar2AMPAR = smodel.Spec('PKCstar2AMPAR', mdl)       
    PKCstar4AMPAR = smodel.Spec('PKCstar4AMPAR', mdl)
    PKCstar3AMPAR = smodel.Spec('PKCstar3AMPAR', mdl)
    PKCstarGRIPAMPAR = smodel.Spec('PKCstarGRIPAMPAR', mdl)
    PKCstar2GRIPAMPAR = smodel.Spec('PKCstar2GRIPAMPAR', mdl)
    PKCstar4GRIPAMPAR = smodel.Spec('PKCstar4GRIPAMPAR', mdl)
    PKCstar3GRIPAMPAR = smodel.Spec('PKCstar3GRIPAMPAR', mdl)
    PP2AGRIPAMPAR_P = smodel.Spec('PP2AGRIPAMPAR_P', mdl)
    AMPAR_P = smodel.Spec('AMPAR_P', mdl)                  
    PP2AAMPAR_P = smodel.Spec('PP2AAMPAR_P', mdl)
    AMPARextra = smodel.Spec('AMPARextra', mdl)  
    AMPARextra_P = smodel.Spec('AMPARextra_P', mdl)
    PP2AAMPARextra_P = smodel.Spec('PP2AAMPARextra_P', mdl)
    GRIP = smodel.Spec('GRIP', mdl)
    GRIPAMPAR = smodel.Spec('GRIPAMPAR', mdl)
    GRIPAMPAR_P = smodel.Spec('GRIPAMPAR_P', mdl)   
    AMPARdend = smodel.Spec('AMPARdend', mdl)  
    AMPARdend_P = smodel.Spec('AMPARdend_P', mdl)  
    PP2AAMPARdend_P = smodel.Spec('PP2AAMPARdend_P', mdl)
    AMPARcyt = smodel.Spec('AMPARcyt', mdl)  
    AMPARcyt_P = smodel.Spec('AMPARcyt_P', mdl)  
    PP2AAMPARcyt_P = smodel.Spec('PP2AAMPARcyt_P', mdl)
    RKIP = smodel.Spec('RKIP', mdl)
    RafRKIP = smodel.Spec('RafRKIP', mdl)
    RafRKIPPKCstar = smodel.Spec('RafRKIPPKCstar', mdl)
    RKIPstar = smodel.Spec('RKIPstar', mdl)
    RP = smodel.Spec('RP', mdl)
    RKIPstarRP = smodel.Spec ('RKIPstarRP', mdl)
    RafRKIPPKCstar2= smodel.Spec ('RafRKIPPKCstar2', mdl)
    RafRKIPPKCstar3= smodel.Spec ('RafRKIPPKCstar3', mdl)
    RafRKIPPKCstar4= smodel.Spec ('RafRKIPPKCstar4', mdl)
    MEKRKIP= smodel.Spec('MEKRKIP', mdl)
    MEKRKIPPKCstar = smodel.Spec('MEKRKIPPKCstar', mdl)
    MEKRKIPPKCstar2= smodel.Spec ('MEKRKIPPKCstar2', mdl)
    MEKRKIPPKCstar3= smodel.Spec ('MEKRKIPPKCstar3', mdl)
    MEKRKIPPKCstar4= smodel.Spec ('MEKRKIPPKCstar4', mdl)
    GC = smodel.Spec('GC',mdl)
    NO = smodel.Spec('NO',mdl)
    GC_NO = smodel.Spec('GC_NO',mdl)
    GTP = smodel.Spec('GTP',mdl)
    GTP_GC_NO = smodel.Spec('GTP_GC_NO',mdl)
    cGMP = smodel.Spec('cGMP',mdl)
    GMP = smodel.Spec('GMP',mdl)
    PDE1 = smodel.Spec('PDE1',mdl)
    pPDE1 = smodel.Spec('pPDE1',mdl)
    PDE5 = smodel.Spec('PDE5',mdl)
    PDE5_cGMP = smodel.Spec('PDE5_cGMP',mdl)
    PKG = smodel.Spec('PKG',mdl)
    PKG_cGMP = smodel.Spec('PKG_cGMP',mdl)
    PP2A_pGsub = smodel.Spec('PP2A_pGsub',mdl)
    pG = smodel.Spec('pG',mdl)
    G_sub = smodel.Spec('G_sub',mdl)
    cGMP_CaM3Ca_pPDE1 = smodel.Spec('cGMP_CaM3Ca_pPDE1',mdl)
    cGMP_CaM3Ca_PDE1 = smodel.Spec('cGMP_CaM3Ca_PDE1',mdl)
    cGMP_PDE1 = smodel.Spec('cGMP_PDE1',mdl)
    cGMP_PDE5 = smodel.Spec('cGMP_PDE5',mdl)
    cGMP_pPDE1 = smodel.Spec('cGMP_pPDE1',mdl)
    PDE1_CaMKII = smodel.Spec('PDE1_CaMKII',mdl)
    pPDE1_CaN = smodel.Spec('pPDE1_CaN',mdl)
    CaM3Ca_PDE1_CaMKII = smodel.Spec('CaM3Ca_PDE1_CaMKII',mdl)
    CaM3Ca_pPDE1_CaN = smodel.Spec('CaM3Ca_pPDE1_CaN',mdl)
    pG_PP2A = smodel.Spec('pG_PP2A',mdl)
    pG_CaN = smodel.Spec('pG_CaN',mdl)
    G_sub_PKG = smodel.Spec('G_sub_PKG',mdl)
    CaM3Ca_PDE1 = smodel.Spec('CaM3Ca_PDE1',mdl)
    CaM3Ca_pPDE1 = smodel.Spec('CaM3Ca_pPDE1',mdl)
    PP1_pDARPP32 = smodel.Spec('PP1_pDARPP32',mdl)
    PP1_DARPP32 = smodel.Spec('PP1_DARPP32',mdl)
    DARPP32 = smodel.Spec('DARPP32',mdl)
    pDARPP32 = smodel.Spec('pDARPP32',mdl)
    R2C2_PKA = smodel.Spec('R2C2_PKA',mdl)
    cAMP_R2C2 = smodel.Spec('cAMP_R2C2',mdl)
    cAMP2_bb_R2C2 = smodel.Spec('cAMP2_bb_R2C2',mdl)
    cAMP2_ab_R2C2 = smodel.Spec('cAMP2_ab_R2C2',mdl)
    cAMP2_ab_R2C = smodel.Spec('cAMP2_ab_R2C',mdl)
    cAMP3_R2C2 = smodel.Spec('cAMP3_R2C2',mdl)
    cAMP3_R2C = smodel.Spec('cAMP3_R2C',mdl)
    cAMP4_R2C2 = smodel.Spec('cAMP4_R2C2',mdl)
    cAMP4_R2C = smodel.Spec('cAMP4_R2C',mdl)
    cAMP4_R2 = smodel.Spec('cAMP4_R2',mdl)
    C_actPKA = smodel.Spec('C_actPKA',mdl)
    cAMP = smodel.Spec('cAMP',mdl)
    AMP = smodel.Spec('AMP',mdl)
    PDE4 = smodel.Spec('PDE4',mdl)
    cAMP_pPDE1 = smodel.Spec('cAMP_pPDE1',mdl)
    cAMP_PDE1 = smodel.Spec('cAMP_PDE1',mdl)
    cAMP_CaM3Ca_PDE1 = smodel.Spec('cAMP_CaM3Ca_PDE1',mdl)
    cAMP_CaM3Ca_pPDE1 = smodel.Spec('cAMP_CaM3Ca_pPDE1',mdl)
    cAMP_PDE4 = smodel.Spec('cAMP_PDE4',mdl)
    PP1_pDARPP32_PP2A = smodel.Spec('PP1_pDARPP32_PP2A',mdl)
    PP1_pDARPP32_CaN = smodel.Spec('PP1_pDARPP32_CaN',mdl)
    PP1_DARPP32_C_actPKA = smodel.Spec('PP1_DARPP32_C_actPKA',mdl)
    pDARPP32_PP2A = smodel.Spec('pDARPP32_PP2A',mdl)
    pDARPP32_CaN = smodel.Spec('pDARPP32_CaN',mdl)
    DARPP32_C_actPKA = smodel.Spec('DARPP32_C_actPKA',mdl)
    pG_CaM3CaCaN = smodel.Spec('pG_CaM3CaCaN',mdl)
    act_PDE5 = smodel.Spec('act_PDE5',mdl)
    CaM = smodel.Spec('CaM',mdl)
    CaM1Ca = smodel.Spec('CaM1Ca',mdl)
    CaM2Ca = smodel.Spec('CaM2Ca',mdl)
    CaM3Ca = smodel.Spec('CaM3Ca',mdl)
    CaN = smodel.Spec('CaN',mdl)
    CaM3CaCaN = smodel.Spec('CaM3CaCaN',mdl)
    actCaMK = smodel.Spec('actCaMK',mdl)
    
    #CaMKII states as chemical species
    #states for 2 activated subunits
    CaMKII_s1_s2_s3_s4=smodel.Spec('CaMKII_s1_s2_s3_s4',mdl)
    CaMKII_s1CaM3Ca_s2_s3_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2_s3_s4',mdl)
    CaMKII_s1_s2CaM3Ca_s3_s4=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3_s4',mdl)
    CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4',mdl)
    CaMKII_s1p_s2CaM3Ca_s3_s4=smodel.Spec('CaMKII_s1p_s2CaM3Ca_s3_s4',mdl)
    CaMKII_s1CaM3Ca_s2p_s3_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2p_s3_s4',mdl)
    CaMKII_s1p_s2_s3_s4=smodel.Spec('CaMKII_s1p_s2_s3_s4',mdl)
    CaMKII_s1_s2p_s3_s4=smodel.Spec('CaMKII_s1_s2p_s3_s4',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3_s4=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3_s4',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3_s4',mdl)
    CaMKII_s1p_s2p_s3_s4=smodel.Spec('CaMKII_s1p_s2p_s3_s4',mdl)
    CaMKII_s1_s2pCaM3Ca_s3_s4=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3_s4',mdl)
    CaMKII_s1pCaM3Ca_s2_s3_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3_s4',mdl)
    CaMKII_s1pp_s2_s3_s4=smodel.Spec('CaMKII_s1pp_s2_s3_s4',mdl)
    CaMKII_s1_s2pp_s3_s4=smodel.Spec('CaMKII_s1_s2pp_s3_s4',mdl)
    CaMKII_s1pp_s2p_s3_s4=smodel.Spec('CaMKII_s1pp_s2p_s3_s4',mdl)
    CaMKII_s1p_s2pp_s3_s4=smodel.Spec('CaMKII_s1p_s2pp_s3_s4',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3_s4',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3_s4',mdl)
    CaMKII_s1pp_s2CaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pp_s2CaM3Ca_s3_s4',mdl)
    CaMKII_s1CaM3Ca_s2pp_s3_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2pp_s3_s4',mdl)
    CaMKII_s1pp_s2pp_s3_s4=smodel.Spec('CaMKII_s1pp_s2pp_s3_s4',mdl)
    CaMKII_s1_s2_s3CaM3Ca_s4=smodel.Spec('CaMKII_s1_s2_s3CaM3Ca_s4',mdl)
    CaMKII_s1_s2_s3_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2_s3_s4CaM3Ca',mdl)
    CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4',mdl)
    CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4',mdl)
    CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4',mdl)
    CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca',mdl)
    CaMKII_s1_s2p_s3_s4pp=smodel.Spec('CaMKII_s1_s2p_s3_s4pp',mdl)
    CaMKII_s1_s2pp_s3_s4pp=smodel.Spec('CaMKII_s1_s2pp_s3_s4pp',mdl)
    CaMKII_s1_s2pCaM3Ca_s3_s4p=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3_s4p',mdl)
    CaMKII_s1_s2p_s3_s4p=smodel.Spec('CaMKII_s1_s2p_s3_s4p',mdl)
    CaMKII_s1_s2pCaM3Ca_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pp_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pp_s3_s4pCaM3Ca',mdl)
    CaMKII_s1_s2_s3pp_s4pp=smodel.Spec('CaMKII_s1_s2_s3pp_s4pp',mdl)
    CaMKII_s1_s2_s3p_s4pp=smodel.Spec('CaMKII_s1_s2_s3p_s4pp',mdl)
    CaMKII_s1_s2_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1_s2pCaM3Ca_s3p_s4=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3p_s4',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4smodel',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4',mdl)
    CaMKII_s1_s2p_s3pp_s4=smodel.Spec('CaMKII_s1_s2p_s3pp_s4',mdl)
    CaMKII_s1_s2_s3pp_s4p=smodel.Spec('CaMKII_s1_s2_s3pp_s4p',mdl)
    CaMKII_s1_s2p_s3p_s4=smodel.Spec('CaMKII_s1_s2p_s3p_s4',mdl)
    CaMKII_s1_s2_s3p_s4p=smodel.Spec('CaMKII_s1_s2_s3p_s4p',mdl)
    CaMKII_s1_s2pp_s3p_s4=smodel.Spec('CaMKII_s1_s2pp_s3p_s4',mdl)
    CaMKII_s1_s2pp_s3pp_s4=smodel.Spec('CaMKII_s1_s2pp_s3pp_s4',mdl)
    CaMKII_s1_s2p_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1_s2p_s3pCaM3Ca_s4',mdl)
    CaMKII_s1_s2_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1_s2pp_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3Ca_s4',mdl)
    CaMKII_s1_s2_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2_s3pp_s4pCaM3Ca',mdl)
    #states for 3 subunits activated
    CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4p',mdl)
    CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1_s2CaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1_s2p_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2p_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1_s2pp_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2pp_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1_s2CaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3p_s4p',mdl)
    CaMKII_s1_s2CaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1_s2pp_s3_s4p=smodel.Spec('CaMKII_s1_s2pp_s3_s4p',mdl)
    CaMKII_s1_s2p_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2p_s3CaM3Ca_s4p',mdl)
    CaMKII_s1_s2pp_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2pp_s3CaM3Ca_s4p',mdl)
    CaMKII_s1_s2pCaM3Ca_s3p_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3p_s4CaM3Ca',mdl)
    CaMKII_s1_s2CaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4CaM3Ca',mdl)
    CaMKII_s1_s2CaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1_s2p_s3pp_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3pp_s4CaM3Ca',mdl)
    CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pp_s3p_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2pp_s3p_s4CaM3Ca',mdl)
    CaMKII_s1_s2pp_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1_s2pp_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pp_s3CaM3Ca_s4pCaM3Ca',mdl)                              
    #states for 3 subunits activation by CaM
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4',mdl)
    CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca',mdl)                                                       
    #states for phosphorylation of 3 subunits
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pp_s4',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pp_s4',mdl)
    CaMKII_s1p_s2pp_s3pp_s4=smodel.Spec('CaMKII_s1p_s2pp_s3pp_s4',mdl)
    CaMKII_s1pp_s2pp_s3pp_s4=smodel.Spec('CaMKII_s1pp_s2pp_s3pp_s4',mdl)
    CaMKII_s1p_s2p_s3pp_s4=smodel.Spec('CaMKII_s1p_s2p_s3pp_s4',mdl)
    CaMKII_s1pp_s2p_s3pp_s4=smodel.Spec('CaMKII_s1pp_s2p_s3pp_s4',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pp_s4',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pp_s4',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3p_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3p_s4',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3p_s4',mdl)
    CaMKII_s1p_s2pp_s3p_s4=smodel.Spec('CaMKII_s1p_s2pp_s3p_s4',mdl)
    CaMKII_s1p_s2p_s3p_s4=smodel.Spec('CaMKII_s1p_s2p_s3p_s4',mdl)
    CaMKII_s1pp_s2p_s3p_s4=smodel.Spec('CaMKII_s1pp_s2p_s3p_s4',mdl)
    CaMKII_s1pp_s2pp_s3p_s4=smodel.Spec('CaMKII_s1pp_s2pp_s3p_s4',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3p_s4=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3p_s4',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3p_s4',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4',mdl)
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3Ca_s4',mdl)
    CaMKII_s1p_s2p_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3Ca_s4',mdl)
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3Ca_s4',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1_s2pCaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1_s2p_s3pp_s4pp=smodel.Spec('CaMKII_s1_s2p_s3pp_s4pp',mdl)
    CaMKII_s1_s2pp_s3pp_s4pp=smodel.Spec('CaMKII_s1_s2pp_s3pp_s4pp',mdl)
    CaMKII_s1_s2p_s3p_s4pp=smodel.Spec('CaMKII_s1_s2p_s3p_s4pp',mdl)
    CaMKII_s1_s2pp_s3p_s4pp=smodel.Spec('CaMKII_s1_s2pp_s3p_s4pp',mdl)
    CaMKII_s1_s2p_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2p_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1_s2pp_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1_s2pCaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3p_s4p',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1_s2p_s3pp_s4p=smodel.Spec('CaMKII_s1_s2p_s3pp_s4p',mdl)
    CaMKII_s1_s2p_s3p_s4p=smodel.Spec('CaMKII_s1_s2p_s3p_s4p',mdl)
    CaMKII_s1_s2pp_s3p_s4p=smodel.Spec('CaMKII_s1_s2pp_s3p_s4p',mdl)
    CaMKII_s1_s2pp_s3pp_s4p=smodel.Spec('CaMKII_s1_s2pp_s3pp_s4p',mdl)
    CaMKII_s1_s2p_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2p_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1_s2pp_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1_s2p_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1_s2p_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pp_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pp_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2_s3p_s4pp=smodel.Spec('CaMKII_s1pp_s2_s3p_s4pp',mdl)
    CaMKII_s1pp_s2_s3p_s4p=smodel.Spec('CaMKII_s1pp_s2_s3p_s4p',mdl)
    CaMKII_s1pp_s2_s3pp_s4p=smodel.Spec('CaMKII_s1pp_s2_s3pp_s4p',mdl)
    CaMKII_s1pp_s2_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2_s3p_s4pp=smodel.Spec('CaMKII_s1p_s2_s3p_s4pp',mdl)
    CaMKII_s1p_s2_s3p_s4p=smodel.Spec('CaMKII_s1p_s2_s3p_s4p',mdl)
    CaMKII_s1p_s2_s3pp_s4p=smodel.Spec('CaMKII_s1p_s2_s3pp_s4p',mdl)
    CaMKII_s1p_s2_s3pp_s4pp=smodel.Spec('CaMKII_s1p_s2_s3pp_s4pp',mdl)
    CaMKII_s1p_s2_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3_s4p=smodel.Spec('CaMKII_s1pp_s2pp_s3_s4p',mdl)
    CaMKII_s1pp_s2pp_s3_s4pp=smodel.Spec('CaMKII_s1pp_s2pp_s3_s4pp',mdl)
    CaMKII_s1p_s2pp_s3_s4p=smodel.Spec('CaMKII_s1p_s2pp_s3_s4p',mdl)
    CaMKII_s1p_s2pp_s3_s4pp=smodel.Spec('CaMKII_s1p_s2pp_s3_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3_s4pp',mdl)
    CaMKII_s1p_s2p_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3_s4p=smodel.Spec('CaMKII_s1pp_s2p_s3_s4p',mdl)
    CaMKII_s1p_s2p_s3_s4p=smodel.Spec('CaMKII_s1p_s2p_s3_s4p',mdl)
    CaMKII_s1p_s2p_s3_s4pp=smodel.Spec('CaMKII_s1p_s2p_s3_s4pp',mdl)
    CaMKII_s1pp_s2p_s3_s4pp=smodel.Spec('CaMKII_s1pp_s2p_s3_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pp',mdl)
    #States for 4 activated subunits
    #4 subunits activated by CaM
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca',mdl)                               
    #Dissociation of CaM of phosphorylated states at Thr2856 and second phos at Thr305
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp',mdl)
    CaMKII_s1p_s2p_s3pp_s4pp=smodel.Spec('CaMKII_s1p_s2p_s3pp_s4pp',mdl)
    CaMKII_s1p_s2pp_s3pp_s4pp=smodel.Spec('CaMKII_s1p_s2pp_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3pp_s4pp=smodel.Spec('CaMKII_s1pp_s2pp_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2p_s3pp_s4pp=smodel.Spec('CaMKII_s1pp_s2p_s3pp_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp',mdl)
    CaMKII_s1p_s2pp_s3p_s4pp=smodel.Spec('CaMKII_s1p_s2pp_s3p_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3p_s4pp=smodel.Spec('CaMKII_s1pp_s2pp_s3p_s4pp',mdl)
    CaMKII_s1p_s2p_s3p_s4pp=smodel.Spec('CaMKII_s1p_s2p_s3p_s4pp',mdl)
    CaMKII_s1pp_s2p_s3p_s4pp=smodel.Spec('CaMKII_s1pp_s2p_s3p_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2p_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pp_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1p_s2p_s3pp_s4p=smodel.Spec('CaMKII_s1p_s2p_s3pp_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1p_s2pp_s3pp_s4p=smodel.Spec('CaMKII_s1p_s2pp_s3pp_s4p',mdl)
    CaMKII_s1pp_s2p_s3pp_s4p=smodel.Spec('CaMKII_s1pp_s2p_s3pp_s4p',mdl)
    CaMKII_s1pp_s2pp_s3pp_s4p=smodel.Spec('CaMKII_s1pp_s2pp_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p',mdl)
    CaMKII_s1p_s2pp_s3p_s4p=smodel.Spec('CaMKII_s1p_s2pp_s3p_s4p',mdl)
    CaMKII_s1pp_s2pp_s3p_s4p=smodel.Spec('CaMKII_s1pp_s2pp_s3p_s4p',mdl)
    CaMKII_s1p_s2p_s3p_s4p=smodel.Spec('CaMKII_s1p_s2p_s3p_s4p',mdl)
    CaMKII_s1pp_s2p_s3p_s4p=smodel.Spec('CaMKII_s1pp_s2p_s3p_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3p_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2p_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1CaM3Ca_s2p_s3pp_s4pp=smodel.Spec('CaMKII_s1CaM3Ca_s2p_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3pp_s4pp',mdl)
    CaMKII_s1CaM3Ca_s2pp_s3pp_s4pp=smodel.Spec('CaMKII_s1CaM3Ca_s2pp_s3pp_s4pp',mdl)
    CaMKII_s1p_s2CaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1p_s2CaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2CaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1pp_s2CaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1CaM3Ca_s2p_s3p_s4pp=smodel.Spec('CaMKII_s1CaM3Ca_s2p_s3p_s4pp',mdl)
    CaMKII_s1CaM3Ca_s2pp_s3p_s4pp=smodel.Spec('CaMKII_s1CaM3Ca_s2pp_s3p_s4pp',mdl)
    CaMKII_s1p_s2CaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1p_s2CaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1pp_s2CaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1pp_s2CaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3_s4pp',mdl)
    CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pp_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2pp_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2p_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2p_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2p_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2p_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2pp_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pp',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4p',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1CaM3Ca_s2p_s3pp_s4p=smodel.Spec('CaMKII_s1CaM3Ca_s2p_s3pp_s4p',mdl)
    CaMKII_s1p_s2CaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1p_s2CaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1pp_s2CaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1pp_s2CaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1CaM3Ca_s2p_s3p_s4p=smodel.Spec('CaMKII_s1CaM3Ca_s2p_s3p_s4p',mdl)
    CaMKII_s1CaM3Ca_s2pp_s3p_s4p=smodel.Spec('CaMKII_s1CaM3Ca_s2pp_s3p_s4p',mdl)
    CaMKII_s1CaM3Ca_s2pp_s3pp_s4p=smodel.Spec('CaMKII_s1CaM3Ca_s2pp_s3pp_s4p',mdl)
    CaMKII_s1p_s2CaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1p_s2CaM3Ca_s3p_s4p',mdl)
    CaMKII_s1pp_s2CaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1pp_s2CaM3Ca_s3p_s4p',mdl)
    CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4p',mdl)
    CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4p',mdl)
    CaMKII_s1p_s2p_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2p_s3CaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pp_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2pp_s3CaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pp_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2pp_s3CaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3Ca_s4',mdl)
    CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2p_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2p_s3CaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4p',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2p_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2p_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pp_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2pp_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2pp_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pp_s4CaM3Ca',mdl)
    CaMKII_s1_s2pp_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pp_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pp_s4CaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3pp_s4CaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pp_s4CaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3pp_s4CaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pp_s4CaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3pp_s4CaM3Ca',mdl)
    CaMKII_s1p_s2CaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2CaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4CaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pp_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2p_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2p_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3p_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3p_s4CaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3p_s4CaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3p_s4CaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3p_s4CaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3p_s4CaM3Ca',mdl)
    CaMKII_s1p_s2p_s3p_s4CaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3p_s4CaM3Ca',mdl)
    CaMKII_s1p_s2CaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2CaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3p_s4CaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3p_s4CaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3p_s4CaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3p_s4CaM3Ca',mdl)
    CaMKII_s1pp_s2CaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2CaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4CaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3p_s4CaM3Ca',mdl)
    CaMKII_s1pp_s2CaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2CaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4CaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pp_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1p_s2p_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4CaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pp_s4CaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3pp_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2pp_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2pp_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3p_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca',mdl)
    #states for 2 subunits dephosphorylation
    #dephosphorylation by PP1
    CaMKII_s1pCaM3CaPP1_s2CaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2CaM3Ca_s3_s4',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3CaPP1_s3_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3CaPP1_s3_s4',mdl)
    CaMKII_s1pPP1_s2CaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pPP1_s2CaM3Ca_s3_s4',mdl)
    CaMKII_s1CaM3Ca_s2pPP1_s3_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2pPP1_s3_s4',mdl)
    CaMKII_s1pPP1_s2_s3_s4=smodel.Spec('CaMKII_s1pPP1_s2_s3_s4',mdl)
    CaMKII_s1_s2pPP1_s3_s4=smodel.Spec('CaMKII_s1_s2pPP1_s3_s4',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3_s4',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3_s4',mdl)
    CaMKII_s1pPP1_s2pCaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pPP1_s2pCaM3Ca_s3_s4',mdl)
    CaMKII_s1p_s2pCaM3CaPP1_s3_s4=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP1_s3_s4',mdl)
    CaMKII_s1pCaM3CaPP1_s2p_s3_s4=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2p_s3_s4',mdl)
    CaMKII_s1pCaM3Ca_s2pPP1_s3_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP1_s3_s4',mdl)
    CaMKII_s1pPP1_s2p_s3_s4=smodel.Spec('CaMKII_s1pPP1_s2p_s3_s4',mdl)
    CaMKII_s1p_s2pPP1_s3_s4=smodel.Spec('CaMKII_s1p_s2pPP1_s3_s4',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3_s4=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3_s4',mdl)
    CaMKII_s1pCaM3CaPP1_s2_s3_s4=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2_s3_s4',mdl)
    CaMKII_s1ppPP1_s2_s3_s4=smodel.Spec('CaMKII_s1ppPP1_s2_s3_s4',mdl)
    CaMKII_s1_s2ppPP1_s3_s4=smodel.Spec('CaMKII_s1_s2ppPP1_s3_s4',mdl)
    CaMKII_s1ppPP1_s2p_s3_s4=smodel.Spec('CaMKII_s1ppPP1_s2p_s3_s4',mdl)
    CaMKII_s1pp_s2pPP1_s3_s4=smodel.Spec('CaMKII_s1pp_s2pPP1_s3_s4',mdl)
    CaMKII_s1pPP1_s2pp_s3_s4=smodel.Spec('CaMKII_s1pPP1_s2pp_s3_s4',mdl)
    CaMKII_s1p_s2ppPP1_s3_s4=smodel.Spec('CaMKII_s1p_s2ppPP1_s3_s4',mdl)
    CaMKII_s1ppPP1_s2pCaM3Ca_s3_s4=smodel.Spec('CaMKII_s1ppPP1_s2pCaM3Ca_s3_s4',mdl)
    CaMKII_s1pp_s2pCaM3CaPP1_s3_s4=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP1_s3_s4',mdl)
    CaMKII_s1pCaM3CaPP1_s2pp_s3_s4=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pp_s3_s4',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP1_s3_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP1_s3_s4',mdl)
    CaMKII_s1ppPP1_s2CaM3Ca_s3_s4=smodel.Spec('CaMKII_s1ppPP1_s2CaM3Ca_s3_s4',mdl)
    CaMKII_s1CaM3Ca_s2ppPP1_s3_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2ppPP1_s3_s4',mdl)
    CaMKII_s1ppPP1_s2pp_s3_s4=smodel.Spec('CaMKII_s1ppPP1_s2pp_s3_s4',mdl)
    CaMKII_s1pp_s2ppPP1_s3_s4=smodel.Spec('CaMKII_s1pp_s2ppPP1_s3_s4',mdl)
    CaMKII_s1_s2_s3pCaM3CaPP1_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2_s3pCaM3CaPP1_s4CaM3Ca',mdl)
    CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1_s2_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3CaM3Ca_s4=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3CaM3Ca_s4',mdl)
    CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP1_s4=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP1_s4',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4',mdl)
    CaMKII_s1pCaM3CaPP1_s2_s3_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2_s3_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP1',mdl)                             
    #dephosphorylation by PP2A
    CaMKII_s1pCaM3CaPP2A_s2CaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2CaM3Ca_s3_s4',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3CaPP2A_s3_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3CaPP2A_s3_s4',mdl)
    CaMKII_s1pPP2A_s2CaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pPP2A_s2CaM3Ca_s3_s4',mdl)
    CaMKII_s1CaM3Ca_s2pPP2A_s3_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2pPP2A_s3_s4',mdl)
    CaMKII_s1pPP2A_s2_s3_s4=smodel.Spec('CaMKII_s1pPP2A_s2_s3_s4',mdl)
    CaMKII_s1_s2pPP2A_s3_s4=smodel.Spec('CaMKII_s1_s2pPP2A_s3_s4',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3_s4',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3_s4',mdl)
    CaMKII_s1pPP2A_s2pCaM3Ca_s3_s4=smodel.Spec('CaMKII_s1pPP2A_s2pCaM3Ca_s3_s4',mdl)
    CaMKII_s1p_s2pCaM3CaPP2A_s3_s4=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP2A_s3_s4',mdl)
    CaMKII_s1pCaM3CaPP2A_s2p_s3_s4=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2p_s3_s4',mdl)
    CaMKII_s1pCaM3Ca_s2pPP2A_s3_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP2A_s3_s4',mdl)
    CaMKII_s1pPP2A_s2p_s3_s4=smodel.Spec('CaMKII_s1pPP2A_s2p_s3_s4',mdl)
    CaMKII_s1p_s2pPP2A_s3_s4=smodel.Spec('CaMKII_s1p_s2pPP2A_s3_s4',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3_s4=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3_s4',mdl)
    CaMKII_s1pCaM3CaPP2A_s2_s3_s4=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2_s3_s4',mdl)
    CaMKII_s1ppPP2A_s2_s3_s4=smodel.Spec('CaMKII_s1ppPP2A_s2_s3_s4',mdl)
    CaMKII_s1_s2ppPP2A_s3_s4=smodel.Spec('CaMKII_s1_s2ppPP2A_s3_s4',mdl)
    CaMKII_s1ppPP2A_s2p_s3_s4=smodel.Spec('CaMKII_s1ppPP2A_s2p_s3_s4',mdl)
    CaMKII_s1pp_s2pPP2A_s3_s4=smodel.Spec('CaMKII_s1pp_s2pPP2A_s3_s4',mdl)
    CaMKII_s1pPP2A_s2pp_s3_s4=smodel.Spec('CaMKII_s1pPP2A_s2pp_s3_s4',mdl)
    CaMKII_s1p_s2ppPP2A_s3_s4=smodel.Spec('CaMKII_s1p_s2ppPP2A_s3_s4',mdl)
    CaMKII_s1ppPP2A_s2pCaM3Ca_s3_s4=smodel.Spec('CaMKII_s1ppPP2A_s2pCaM3Ca_s3_s4',mdl)
    CaMKII_s1pp_s2pCaM3CaPP2A_s3_s4=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP2A_s3_s4',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pp_s3_s4=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pp_s3_s4',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP2A_s3_s4=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP2A_s3_s4',mdl)
    CaMKII_s1ppPP2A_s2CaM3Ca_s3_s4=smodel.Spec('CaMKII_s1ppPP2A_s2CaM3Ca_s3_s4',mdl)
    CaMKII_s1CaM3Ca_s2ppPP2A_s3_s4=smodel.Spec('CaMKII_s1CaM3Ca_s2ppPP2A_s3_s4',mdl)
    CaMKII_s1ppPP2A_s2pp_s3_s4=smodel.Spec('CaMKII_s1ppPP2A_s2pp_s3_s4',mdl)
    CaMKII_s1pp_s2ppPP2A_s3_s4=smodel.Spec('CaMKII_s1pp_s2ppPP2A_s3_s4',mdl)
    CaMKII_s1_s2_s3pCaM3CaPP2A_s4CaM3Ca=smodel.Spec('CaMKII_s1_s2_s3pCaM3CaPP2A_s4CaM3Ca',mdl)
    CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1_s2_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3CaM3Ca_s4=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3CaM3Ca_s4',mdl)
    CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP2A_s4=smodel.Spec('CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP2A_s4',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4',mdl) 
    CaMKII_s1pCaM3CaPP2A_s2_s3_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2_s3_s4CaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2_s3_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2_s3_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP2A',mdl)
    #states for 3 subunits dephosphorylation by PP1 and PP2
    #dephopshorylation by PP1
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4p',mdl)   
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1_s2pCaM3Ca_s3p_s4ppPP1=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3p_s4ppPP1',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pPP1_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pPP1_s4pp',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3p_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3p_s4pp',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP1=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP1',mdl)
    CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pp',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3pp_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3pp_s4pp',mdl)
    CaMKII_s1_s2p_s3pp_s4ppPP1=smodel.Spec('CaMKII_s1_s2p_s3pp_s4ppPP1',mdl)
    CaMKII_s1_s2p_s3ppPP1_s4pp=smodel.Spec('CaMKII_s1_s2p_s3ppPP1_s4pp',mdl)
    CaMKII_s1_s2pPP1_s3pp_s4pp=smodel.Spec('CaMKII_s1_s2pPP1_s3pp_s4pp',mdl)
    CaMKII_s1_s2pp_s3pp_s4ppPP1=smodel.Spec('CaMKII_s1_s2pp_s3pp_s4ppPP1',mdl)
    CaMKII_s1_s2pp_s3ppPP1_s4pp=smodel.Spec('CaMKII_s1_s2pp_s3ppPP1_s4pp',mdl)
    CaMKII_s1_s2ppPP1_s3pp_s4pp=smodel.Spec('CaMKII_s1_s2ppPP1_s3pp_s4pp',mdl)
    CaMKII_s1_s2p_s3p_s4ppPP1=smodel.Spec('CaMKII_s1_s2p_s3p_s4ppPP1',mdl)
    CaMKII_s1_s2p_s3pPP1_s4pp=smodel.Spec('CaMKII_s1_s2p_s3pPP1_s4pp',mdl)
    CaMKII_s1_s2pPP1_s3p_s4pp=smodel.Spec('CaMKII_s1_s2pPP1_s3p_s4pp',mdl)
    CaMKII_s1_s2pp_s3p_s4ppPP1=smodel.Spec('CaMKII_s1_s2pp_s3p_s4ppPP1',mdl)
    CaMKII_s1_s2pp_s3pPP1_s4pp=smodel.Spec('CaMKII_s1_s2pp_s3pPP1_s4pp',mdl)
    CaMKII_s1_s2ppPP1_s3p_s4pp=smodel.Spec('CaMKII_s1_s2ppPP1_s3p_s4pp',mdl)
    CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1_s2p_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1_s2p_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1_s2pCaM3Ca_s3p_s4pPP1=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3p_s4pPP1',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pPP1_s4p=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pPP1_s4p',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3p_s4p=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3p_s4p',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP1=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP1',mdl)
    CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4p=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4p',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3pp_s4p=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3pp_s4p',mdl)
    CaMKII_s1_s2p_s3pp_s4pPP1=smodel.Spec('CaMKII_s1_s2p_s3pp_s4pPP1',mdl)
    CaMKII_s1_s2p_s3ppPP1_s4p=smodel.Spec('CaMKII_s1_s2p_s3ppPP1_s4p',mdl)
    CaMKII_s1_s2pPP1_s3pp_s4p=smodel.Spec('CaMKII_s1_s2pPP1_s3pp_s4p',mdl)
    CaMKII_s1_s2p_s3p_s4pPP1=smodel.Spec('CaMKII_s1_s2p_s3p_s4pPP1',mdl)
    CaMKII_s1_s2p_s3pPP1_s4p=smodel.Spec('CaMKII_s1_s2p_s3pPP1_s4p',mdl)
    CaMKII_s1_s2pPP1_s3p_s4p=smodel.Spec('CaMKII_s1_s2pPP1_s3p_s4p',mdl)
    CaMKII_s1_s2pp_s3p_s4pPP1=smodel.Spec('CaMKII_s1_s2pp_s3p_s4pPP1',mdl)
    CaMKII_s1_s2pp_s3pPP1_s4p=smodel.Spec('CaMKII_s1_s2pp_s3pPP1_s4p',mdl)
    CaMKII_s1_s2ppPP1_s3p_s4p=smodel.Spec('CaMKII_s1_s2ppPP1_s3p_s4p',mdl)
    CaMKII_s1_s2pp_s3pp_s4pPP1=smodel.Spec('CaMKII_s1_s2pp_s3pp_s4pPP1',mdl)
    CaMKII_s1_s2pp_s3ppPP1_s4p=smodel.Spec('CaMKII_s1_s2pp_s3ppPP1_s4p',mdl)
    CaMKII_s1_s2ppPP1_s3pp_s4p=smodel.Spec('CaMKII_s1_s2ppPP1_s3pp_s4p',mdl)
    CaMKII_s1_s2p_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1_s2p_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1_s2p_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1_s2p_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1_s2pPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2pPP1_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1_s2pp_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP1',mdl)
    CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3CaPP1_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3CaPP1_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1_s2p_s3pp_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1_s2p_s3pp_s4pCaM3CaPP1',mdl)
    CaMKII_s1_s2p_s3ppPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3ppPP1_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pPP1_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pPP1_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1_s2p_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1_s2p_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1_s2p_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pp_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1_s2pp_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1_s2pp_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pp_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1_s2ppPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2ppPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1_s2p_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    #dephosphorylation by PP2A
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1_s2pCaM3Ca_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3p_s4ppPP2A',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4pp',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3p_s4pp',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP2A=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP2A',mdl)
    CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pp',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4pp=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4pp',mdl)
    CaMKII_s1_s2p_s3pp_s4ppPP2A=smodel.Spec('CaMKII_s1_s2p_s3pp_s4ppPP2A',mdl)
    CaMKII_s1_s2p_s3ppPP2A_s4pp=smodel.Spec('CaMKII_s1_s2p_s3ppPP2A_s4pp',mdl)
    CaMKII_s1_s2pPP2A_s3pp_s4pp=smodel.Spec('CaMKII_s1_s2pPP2A_s3pp_s4pp',mdl)
    CaMKII_s1_s2pp_s3pp_s4ppPP2A=smodel.Spec('CaMKII_s1_s2pp_s3pp_s4ppPP2A',mdl)
    CaMKII_s1_s2pp_s3ppPP2A_s4pp=smodel.Spec('CaMKII_s1_s2pp_s3ppPP2A_s4pp',mdl)
    CaMKII_s1_s2ppPP2A_s3pp_s4pp=smodel.Spec('CaMKII_s1_s2ppPP2A_s3pp_s4pp',mdl)
    CaMKII_s1_s2p_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1_s2p_s3p_s4ppPP2A',mdl)
    CaMKII_s1_s2p_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1_s2p_s3pPP2A_s4pp',mdl)
    CaMKII_s1_s2pPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1_s2pPP2A_s3p_s4pp',mdl)
    CaMKII_s1_s2pp_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1_s2pp_s3p_s4ppPP2A',mdl)
    CaMKII_s1_s2pp_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1_s2pp_s3pPP2A_s4pp',mdl)
    CaMKII_s1_s2ppPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1_s2ppPP2A_s3p_s4pp',mdl)
    CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1_s2pCaM3Ca_s3p_s4pPP2A=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3p_s4pPP2A',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4p=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4p',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3p_s4p=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3p_s4p',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP2A',mdl)
    CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4p',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4p',mdl)
    CaMKII_s1_s2p_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1_s2p_s3pp_s4pPP2A',mdl)
    CaMKII_s1_s2p_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1_s2p_s3ppPP2A_s4p',mdl)
    CaMKII_s1_s2pPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1_s2pPP2A_s3pp_s4p',mdl)
    CaMKII_s1_s2p_s3p_s4pPP2A=smodel.Spec('CaMKII_s1_s2p_s3p_s4pPP2A',mdl)
    CaMKII_s1_s2p_s3pPP2A_s4p=smodel.Spec('CaMKII_s1_s2p_s3pPP2A_s4p',mdl)
    CaMKII_s1_s2pPP2A_s3p_s4p=smodel.Spec('CaMKII_s1_s2pPP2A_s3p_s4p',mdl)
    CaMKII_s1_s2pp_s3p_s4pPP2A=smodel.Spec('CaMKII_s1_s2pp_s3p_s4pPP2A',mdl)
    CaMKII_s1_s2pp_s3pPP2A_s4p=smodel.Spec('CaMKII_s1_s2pp_s3pPP2A_s4p',mdl)
    CaMKII_s1_s2ppPP2A_s3p_s4p=smodel.Spec('CaMKII_s1_s2ppPP2A_s3p_s4p',mdl)
    CaMKII_s1_s2pp_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1_s2pp_s3pp_s4pPP2A',mdl)
    CaMKII_s1_s2pp_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1_s2pp_s3ppPP2A_s4p',mdl)
    CaMKII_s1_s2ppPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1_s2ppPP2A_s3pp_s4p',mdl)
    CaMKII_s1_s2p_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1_s2p_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1_s2p_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1_s2p_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A',mdl)
    CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1_s2p_s3pp_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1_s2p_s3pp_s4pCaM3CaPP2A',mdl)
    CaMKII_s1_s2p_s3ppPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3ppPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pPP2A_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pPP2A_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1_s2p_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1_s2p_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1_s2p_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pp_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1_s2pp_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1_s2pp_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pp_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1_s2ppPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2ppPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    #states for 4 subunits dephosphorylation by PP1 and PP2
    #dephosphorylation by PP1
    CaMKII_s1CaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4CaM3Ca',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP1',mdl)
    CaMKII_s1pPP1_s2p_s3pp_s4pp=smodel.Spec('CaMKII_s1pPP1_s2p_s3pp_s4pp',mdl)
    CaMKII_s1p_s2pPP1_s3pp_s4pp=smodel.Spec('CaMKII_s1p_s2pPP1_s3pp_s4pp',mdl)
    CaMKII_s1p_s2p_s3ppPP1_s4pp=smodel.Spec('CaMKII_s1p_s2p_s3ppPP1_s4pp',mdl)
    CaMKII_s1p_s2p_s3pp_s4ppPP1=smodel.Spec('CaMKII_s1p_s2p_s3pp_s4ppPP1',mdl)
    CaMKII_s1pPP1_s2pp_s3pp_s4pp=smodel.Spec('CaMKII_s1pPP1_s2pp_s3pp_s4pp',mdl)
    CaMKII_s1p_s2ppPP1_s3pp_s4pp=smodel.Spec('CaMKII_s1p_s2ppPP1_s3pp_s4pp',mdl)
    CaMKII_s1p_s2pp_s3ppPP1_s4pp=smodel.Spec('CaMKII_s1p_s2pp_s3ppPP1_s4pp',mdl)
    CaMKII_s1p_s2pp_s3pp_s4ppPP1=smodel.Spec('CaMKII_s1p_s2pp_s3pp_s4ppPP1',mdl)
    CaMKII_s1ppPP1_s2pp_s3pp_s4pp=smodel.Spec('CaMKII_s1ppPP1_s2pp_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2ppPP1_s3pp_s4pp=smodel.Spec('CaMKII_s1pp_s2ppPP1_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3ppPP1_s4pp=smodel.Spec('CaMKII_s1pp_s2pp_s3ppPP1_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3pp_s4ppPP1=smodel.Spec('CaMKII_s1pp_s2pp_s3pp_s4ppPP1',mdl)
    CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP1=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP1',mdl)
    CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP1=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP1',mdl)
    CaMKII_s1pPP1_s2pp_s3p_s4pp=smodel.Spec('CaMKII_s1pPP1_s2pp_s3p_s4pp',mdl)
    CaMKII_s1p_s2ppPP1_s3p_s4pp=smodel.Spec('CaMKII_s1p_s2ppPP1_s3p_s4pp',mdl)
    CaMKII_s1p_s2pp_s3pPP1_s4pp=smodel.Spec('CaMKII_s1p_s2pp_s3pPP1_s4pp',mdl)
    CaMKII_s1p_s2pp_s3p_s4ppPP1=smodel.Spec('CaMKII_s1p_s2pp_s3p_s4ppPP1',mdl)
    CaMKII_s1ppPP1_s2pp_s3p_s4pp=smodel.Spec('CaMKII_s1ppPP1_s2pp_s3p_s4pp',mdl)
    CaMKII_s1pp_s2ppPP1_s3p_s4pp=smodel.Spec('CaMKII_s1pp_s2ppPP1_s3p_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3pPP1_s4pp=smodel.Spec('CaMKII_s1pp_s2pp_s3pPP1_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3p_s4ppPP1=smodel.Spec('CaMKII_s1pp_s2pp_s3p_s4ppPP1',mdl)
    CaMKII_s1pPP1_s2p_s3p_s4pp=smodel.Spec('CaMKII_s1pPP1_s2p_s3p_s4pp',mdl)
    CaMKII_s1p_s2pPP1_s3p_s4pp=smodel.Spec('CaMKII_s1p_s2pPP1_s3p_s4pp',mdl)
    CaMKII_s1p_s2p_s3pPP1_s4pp=smodel.Spec('CaMKII_s1p_s2p_s3pPP1_s4pp',mdl)
    CaMKII_s1p_s2p_s3p_s4ppPP1=smodel.Spec('CaMKII_s1p_s2p_s3p_s4ppPP1',mdl)
    CaMKII_s1ppPP1_s2p_s3p_s4pp=smodel.Spec('CaMKII_s1ppPP1_s2p_s3p_s4pp',mdl)
    CaMKII_s1pp_s2pPP1_s3p_s4pp=smodel.Spec('CaMKII_s1pp_s2pPP1_s3p_s4pp',mdl)
    CaMKII_s1pp_s2p_s3pPP1_s4pp=smodel.Spec('CaMKII_s1pp_s2p_s3pPP1_s4pp',mdl)
    CaMKII_s1pp_s2p_s3p_s4ppPP1=smodel.Spec('CaMKII_s1pp_s2p_s3p_s4ppPP1',mdl)
    CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP1=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP1',mdl)
    CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP1=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP1',mdl)
    CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP1=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP1',mdl)
    CaMKII_s1pPP1_s2p_s3pp_s4p=smodel.Spec('CaMKII_s1pPP1_s2p_s3pp_s4p',mdl)
    CaMKII_s1p_s2pPP1_s3pp_s4p=smodel.Spec('CaMKII_s1p_s2pPP1_s3pp_s4p',mdl)
    CaMKII_s1p_s2p_s3ppPP1_s4p=smodel.Spec('CaMKII_s1p_s2p_s3ppPP1_s4p',mdl)
    CaMKII_s1p_s2p_s3pp_s4pPP1=smodel.Spec('CaMKII_s1p_s2p_s3pp_s4pPP1',mdl)
    CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP1=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP1',mdl)
    CaMKII_s1pPP1_s2pp_s3pp_s4p=smodel.Spec('CaMKII_s1pPP1_s2pp_s3pp_s4p',mdl)
    CaMKII_s1p_s2ppPP1_s3pp_s4p=smodel.Spec('CaMKII_s1p_s2ppPP1_s3pp_s4p',mdl)
    CaMKII_s1p_s2pp_s3ppPP1_s4p=smodel.Spec('CaMKII_s1p_s2pp_s3ppPP1_s4p',mdl)
    CaMKII_s1p_s2pp_s3pp_s4pPP1=smodel.Spec('CaMKII_s1p_s2pp_s3pp_s4pPP1',mdl)
    CaMKII_s1ppPP1_s2p_s3pp_s4p=smodel.Spec('CaMKII_s1ppPP1_s2p_s3pp_s4p',mdl)
    CaMKII_s1pp_s2pPP1_s3pp_s4p=smodel.Spec('CaMKII_s1pp_s2pPP1_s3pp_s4p',mdl)
    CaMKII_s1pp_s2p_s3ppPP1_s4p=smodel.Spec('CaMKII_s1pp_s2p_s3ppPP1_s4p',mdl)
    CaMKII_s1pp_s2p_s3pp_s4pPP1=smodel.Spec('CaMKII_s1pp_s2p_s3pp_s4pPP1',mdl)
    CaMKII_s1ppPP1_s2pp_s3pp_s4p=smodel.Spec('CaMKII_s1ppPP1_s2pp_s3pp_s4p',mdl)
    CaMKII_s1pp_s2ppPP1_s3pp_s4p=smodel.Spec('CaMKII_s1pp_s2ppPP1_s3pp_s4p',mdl)
    CaMKII_s1pp_s2pp_s3ppPP1_s4p=smodel.Spec('CaMKII_s1pp_s2pp_s3ppPP1_s4p',mdl)
    CaMKII_s1pp_s2pp_s3pp_s4pPP1=smodel.Spec('CaMKII_s1pp_s2pp_s3pp_s4pPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2p_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2p_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP1',mdl)
    CaMKII_s1pPP1_s2pp_s3p_s4p=smodel.Spec('CaMKII_s1pPP1_s2pp_s3p_s4p',mdl)
    CaMKII_s1p_s2ppPP1_s3p_s4p=smodel.Spec('CaMKII_s1p_s2ppPP1_s3p_s4p',mdl)
    CaMKII_s1p_s2pp_s3pPP1_s4p=smodel.Spec('CaMKII_s1p_s2pp_s3pPP1_s4p',mdl)
    CaMKII_s1p_s2pp_s3p_s4pPP1=smodel.Spec('CaMKII_s1p_s2pp_s3p_s4pPP1',mdl)
    CaMKII_s1ppPP1_s2pp_s3p_s4p=smodel.Spec('CaMKII_s1ppPP1_s2pp_s3p_s4p',mdl)
    CaMKII_s1pp_s2ppPP1_s3p_s4p=smodel.Spec('CaMKII_s1pp_s2ppPP1_s3p_s4p',mdl)
    CaMKII_s1pp_s2pp_s3pPP1_s4p=smodel.Spec('CaMKII_s1pp_s2pp_s3pPP1_s4p',mdl)
    CaMKII_s1pp_s2pp_s3p_s4pPP1=smodel.Spec('CaMKII_s1pp_s2pp_s3p_s4pPP1',mdl)
    CaMKII_s1pPP1_s2p_s3p_s4p=smodel.Spec('CaMKII_s1pPP1_s2p_s3p_s4p',mdl)
    CaMKII_s1p_s2pPP1_s3p_s4p=smodel.Spec('CaMKII_s1p_s2pPP1_s3p_s4p',mdl)
    CaMKII_s1p_s2p_s3pPP1_s4p=smodel.Spec('CaMKII_s1p_s2p_s3pPP1_s4p',mdl)
    CaMKII_s1p_s2p_s3p_s4pPP1=smodel.Spec('CaMKII_s1p_s2p_s3p_s4pPP1',mdl)
    CaMKII_s1ppPP1_s2p_s3p_s4p=smodel.Spec('CaMKII_s1ppPP1_s2p_s3p_s4p',mdl)
    CaMKII_s1pp_s2pPP1_s3p_s4p=smodel.Spec('CaMKII_s1pp_s2pPP1_s3p_s4p',mdl)
    CaMKII_s1pp_s2p_s3pPP1_s4p=smodel.Spec('CaMKII_s1pp_s2p_s3pPP1_s4p',mdl)
    CaMKII_s1pp_s2p_s3p_s4pPP1=smodel.Spec('CaMKII_s1pp_s2p_s3p_s4pPP1',mdl)
    CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4p',mdl)
    CaMKII_s1p_s2pCaM3CaPP1_s3p_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP1_s3p_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP1=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP1',mdl)
    CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4p',mdl)
    CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP1=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2p_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP1=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP1',mdl)
    CaMKII_s1pPP1_s2pp_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP1_s2pp_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2ppPP1_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2ppPP1_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3ppPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3ppPP1_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP1',mdl)
    CaMKII_s1ppPP1_s2pp_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP1_s2pp_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2ppPP1_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2ppPP1_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3ppPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3ppPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP1',mdl)
    CaMKII_s1pPP1_s2p_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP1_s2p_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pPP1_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pPP1_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3ppPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3ppPP1_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP1',mdl)
    CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1pPP1_s2pp_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP1_s2pp_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2ppPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2ppPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1ppPP1_s2pp_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP1_s2pp_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2ppPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2ppPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1pPP1_s2p_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP1_s2p_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1p_s2p_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1ppPP1_s2p_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP1_s2p_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1ppPP1_s2p_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP1_s2p_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pPP1_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pPP1_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3ppPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3ppPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP1',mdl)
    CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1',mdl)
    #dephosphorylation by PP2A
    CaMKII_s1CaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3CaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3CaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4CaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4CaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4CaM3Ca',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)                              
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP2A',mdl)
    CaMKII_s1pPP2A_s2p_s3pp_s4pp=smodel.Spec('CaMKII_s1pPP2A_s2p_s3pp_s4pp',mdl)
    CaMKII_s1p_s2pPP2A_s3pp_s4pp=smodel.Spec('CaMKII_s1p_s2pPP2A_s3pp_s4pp',mdl)
    CaMKII_s1p_s2p_s3ppPP2A_s4pp=smodel.Spec('CaMKII_s1p_s2p_s3ppPP2A_s4pp',mdl)
    CaMKII_s1p_s2p_s3pp_s4ppPP2A=smodel.Spec('CaMKII_s1p_s2p_s3pp_s4ppPP2A',mdl)
    CaMKII_s1pPP2A_s2pp_s3pp_s4pp=smodel.Spec('CaMKII_s1pPP2A_s2pp_s3pp_s4pp',mdl)
    CaMKII_s1p_s2ppPP2A_s3pp_s4pp=smodel.Spec('CaMKII_s1p_s2ppPP2A_s3pp_s4pp',mdl)
    CaMKII_s1p_s2pp_s3ppPP2A_s4pp=smodel.Spec('CaMKII_s1p_s2pp_s3ppPP2A_s4pp',mdl)
    CaMKII_s1p_s2pp_s3pp_s4ppPP2A=smodel.Spec('CaMKII_s1p_s2pp_s3pp_s4ppPP2A',mdl)
    CaMKII_s1ppPP2A_s2pp_s3pp_s4pp=smodel.Spec('CaMKII_s1ppPP2A_s2pp_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2ppPP2A_s3pp_s4pp=smodel.Spec('CaMKII_s1pp_s2ppPP2A_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3ppPP2A_s4pp=smodel.Spec('CaMKII_s1pp_s2pp_s3ppPP2A_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3pp_s4ppPP2A=smodel.Spec('CaMKII_s1pp_s2pp_s3pp_s4ppPP2A',mdl)
    CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP2A=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP2A',mdl)
    CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pp=smodel.Spec('CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP2A=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP2A',mdl)
    CaMKII_s1pPP2A_s2pp_s3p_s4pp=smodel.Spec('CaMKII_s1pPP2A_s2pp_s3p_s4pp',mdl)
    CaMKII_s1p_s2ppPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1p_s2ppPP2A_s3p_s4pp',mdl)
    CaMKII_s1p_s2pp_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1p_s2pp_s3pPP2A_s4pp',mdl)
    CaMKII_s1p_s2pp_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1p_s2pp_s3p_s4ppPP2A',mdl)
    CaMKII_s1ppPP2A_s2pp_s3p_s4pp=smodel.Spec('CaMKII_s1ppPP2A_s2pp_s3p_s4pp',mdl)
    CaMKII_s1pp_s2ppPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1pp_s2ppPP2A_s3p_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1pp_s2pp_s3pPP2A_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1pp_s2pp_s3p_s4ppPP2A',mdl)
    CaMKII_s1pPP2A_s2p_s3p_s4pp=smodel.Spec('CaMKII_s1pPP2A_s2p_s3p_s4pp',mdl)
    CaMKII_s1p_s2pPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1p_s2pPP2A_s3p_s4pp',mdl)
    CaMKII_s1p_s2p_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1p_s2p_s3pPP2A_s4pp',mdl)
    CaMKII_s1p_s2p_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1p_s2p_s3p_s4ppPP2A',mdl)
    CaMKII_s1ppPP2A_s2p_s3p_s4pp=smodel.Spec('CaMKII_s1ppPP2A_s2p_s3p_s4pp',mdl)
    CaMKII_s1pp_s2pPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1pp_s2pPP2A_s3p_s4pp',mdl)
    CaMKII_s1pp_s2p_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1pp_s2p_s3pPP2A_s4pp',mdl)
    CaMKII_s1pp_s2p_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1pp_s2p_s3p_s4ppPP2A',mdl)
    CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP2A',mdl)
    CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pp=smodel.Spec('CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP2A=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP2A',mdl)
    CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP2A',mdl)
    CaMKII_s1pPP2A_s2p_s3pp_s4p=smodel.Spec('CaMKII_s1pPP2A_s2p_s3pp_s4p',mdl)
    CaMKII_s1p_s2pPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1p_s2pPP2A_s3pp_s4p',mdl)
    CaMKII_s1p_s2p_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1p_s2p_s3ppPP2A_s4p',mdl)
    CaMKII_s1p_s2p_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1p_s2p_s3pp_s4pPP2A',mdl)
    CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4p=smodel.Spec('CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4p',mdl)
    CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP2A',mdl)
    CaMKII_s1pPP2A_s2pp_s3pp_s4p=smodel.Spec('CaMKII_s1pPP2A_s2pp_s3pp_s4p',mdl)
    CaMKII_s1p_s2ppPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1p_s2ppPP2A_s3pp_s4p',mdl)
    CaMKII_s1p_s2pp_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1p_s2pp_s3ppPP2A_s4p',mdl)
    CaMKII_s1p_s2pp_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1p_s2pp_s3pp_s4pPP2A',mdl)
    CaMKII_s1ppPP2A_s2p_s3pp_s4p=smodel.Spec('CaMKII_s1ppPP2A_s2p_s3pp_s4p',mdl)
    CaMKII_s1pp_s2pPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1pp_s2pPP2A_s3pp_s4p',mdl)
    CaMKII_s1pp_s2p_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1pp_s2p_s3ppPP2A_s4p',mdl)
    CaMKII_s1pp_s2p_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1pp_s2p_s3pp_s4pPP2A',mdl)
    CaMKII_s1ppPP2A_s2pp_s3pp_s4p=smodel.Spec('CaMKII_s1ppPP2A_s2pp_s3pp_s4p',mdl)
    CaMKII_s1pp_s2ppPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1pp_s2ppPP2A_s3pp_s4p',mdl)
    CaMKII_s1pp_s2pp_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1pp_s2pp_s3ppPP2A_s4p',mdl)
    CaMKII_s1pp_s2pp_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1pp_s2pp_s3pp_s4pPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP2A',mdl)
    CaMKII_s1pPP2A_s2pp_s3p_s4p=smodel.Spec('CaMKII_s1pPP2A_s2pp_s3p_s4p',mdl)
    CaMKII_s1p_s2ppPP2A_s3p_s4p=smodel.Spec('CaMKII_s1p_s2ppPP2A_s3p_s4p',mdl)
    CaMKII_s1p_s2pp_s3pPP2A_s4p=smodel.Spec('CaMKII_s1p_s2pp_s3pPP2A_s4p',mdl)
    CaMKII_s1p_s2pp_s3p_s4pPP2A=smodel.Spec('CaMKII_s1p_s2pp_s3p_s4pPP2A',mdl)
    CaMKII_s1ppPP2A_s2pp_s3p_s4p=smodel.Spec('CaMKII_s1ppPP2A_s2pp_s3p_s4p',mdl)
    CaMKII_s1pp_s2ppPP2A_s3p_s4p=smodel.Spec('CaMKII_s1pp_s2ppPP2A_s3p_s4p',mdl)
    CaMKII_s1pp_s2pp_s3pPP2A_s4p=smodel.Spec('CaMKII_s1pp_s2pp_s3pPP2A_s4p',mdl)
    CaMKII_s1pp_s2pp_s3p_s4pPP2A=smodel.Spec('CaMKII_s1pp_s2pp_s3p_s4pPP2A',mdl)
    CaMKII_s1pPP2A_s2p_s3p_s4p=smodel.Spec('CaMKII_s1pPP2A_s2p_s3p_s4p',mdl)
    CaMKII_s1p_s2pPP2A_s3p_s4p=smodel.Spec('CaMKII_s1p_s2pPP2A_s3p_s4p',mdl)
    CaMKII_s1p_s2p_s3pPP2A_s4p=smodel.Spec('CaMKII_s1p_s2p_s3pPP2A_s4p',mdl)
    CaMKII_s1p_s2p_s3p_s4pPP2A=smodel.Spec('CaMKII_s1p_s2p_s3p_s4pPP2A',mdl)
    CaMKII_s1ppPP2A_s2p_s3p_s4p=smodel.Spec('CaMKII_s1ppPP2A_s2p_s3p_s4p',mdl)
    CaMKII_s1pp_s2pPP2A_s3p_s4p=smodel.Spec('CaMKII_s1pp_s2pPP2A_s3p_s4p',mdl)
    CaMKII_s1pp_s2p_s3pPP2A_s4p=smodel.Spec('CaMKII_s1pp_s2p_s3pPP2A_s4p',mdl)
    CaMKII_s1pp_s2p_s3p_s4pPP2A=smodel.Spec('CaMKII_s1pp_s2p_s3p_s4pPP2A',mdl)
    CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4p',mdl)
    CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP2A=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP2A',mdl)
    CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4p=smodel.Spec('CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4p',mdl)
    CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP2A=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4p=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4p',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pPP2A_s2pp_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP2A_s2pp_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2ppPP2A_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2ppPP2A_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3ppPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3ppPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP2A',mdl)
    CaMKII_s1ppPP2A_s2pp_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP2A_s2pp_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2ppPP2A_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2ppPP2A_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3ppPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3ppPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pPP2A_s2p_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP2A_s2p_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pPP2A_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pPP2A_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3ppPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3ppPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pPP2A_s2pp_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP2A_s2pp_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2ppPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2ppPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1ppPP2A_s2pp_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP2A_s2pp_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2ppPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2ppPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pPP2A_s2p_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP2A_s2p_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1p_s2p_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1ppPP2A_s2p_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP2A_s2p_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1ppPP2A_s2p_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1ppPP2A_s2p_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2pPP2A_s3pp_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2pPP2A_s3pp_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3ppPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pp_s2p_s3ppPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
    CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca',mdl)
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A=smodel.Spec('CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A',mdl)
  
    totbasGTP = smodel.Spec('totbasGTP',mdl)

    extra = smodel.Volsys('extra', mdl)
    vsys = smodel.Volsys('vsys', mdl)
    s = smodel.Surfsys('memb', mdl)
    ERs = smodel.Surfsys('ERmemb', mdl)
    cytER = smodel.Volsys('cytER', mdl)

    ########################################################################
    ########################################################################

    # Reactions
    
    # Ca influx (Ca = calcium)
    CainfluxR = smodel.Reac('Cainflux', vsys, rhs=[Ca])
    # reaction constant for zero-order reaction units M/s in STEPS 1.2 and above
    CainfluxR.kcst = 0.0 
    
    # Ca + PMCA <->  Ca1PMCA -> PMCA
    Reac1 = smodel.SReac('pump2_f', s, ilhs = [Ca], slhs =  [PMCA], srhs = [Ca1PMCA])
    Reac1.kcst = 25000e6
    Reac2 = smodel.SReac('Reac2', s, slhs = [Ca1PMCA], irhs = [Ca], srhs = [PMCA])
    Reac2.kcst = 2000 
    Reac3 = smodel.SReac('Reac3', s, slhs = [Ca1PMCA], srhs = [PMCA])   
    Reac3.kcst = 500
    
    # Ca + NCX <->  Ca1NCX + Ca <->  Ca2NCX -> NCX 
    Reac4 = smodel.SReac('Reac4', s, ilhs = [Ca], slhs = [NCX], srhs = [Ca1NCX])
    Reac4.kcst = 93.827e6  
    Reac5 = smodel.SReac('Reac5', s, slhs = [Ca1NCX], irhs = [Ca], srhs = [NCX])
    Reac5.kcst = 612.6
    Reac6 = smodel.SReac('Reac6', s, ilhs = [Ca], slhs = [Ca1NCX], srhs = [Ca2NCX])
    Reac6.kcst = 93.827e6 
    Reac7 = smodel.SReac('Reac7', s, slhs = [Ca2NCX], irhs = [Ca], srhs = [Ca1NCX])
    Reac7.kcst = 612.6
    Reac8 = smodel.SReac('Reac8', s, slhs = [Ca2NCX], srhs = [NCX])
    Reac8.kcst = 1000
    
    # Ca + SERCA <->  Ca1SERCA +Ca <->  Ca2SERCA  ->  SERCA
    Reac9 = smodel.SReac('Reac9', ERs, olhs = [Ca], slhs = [SERCA], srhs = [Ca1SERCA])
    Reac9.kcst = 17147e6 
    Reac10 = smodel.SReac('Reac10', ERs, slhs = [Ca1SERCA], orhs = [Ca], srhs = [SERCA])
    Reac10.kcst = 8426.3
    Reac11 = smodel.SReac('Reac11', ERs, olhs = [Ca], slhs = [Ca1SERCA], srhs = [Ca2SERCA])
    Reac11.kcst = 17147e6 
    Reac12 = smodel.SReac('Reac12', ERs, slhs = [Ca2SERCA], orhs = [Ca], srhs = [Ca1SERCA])
    Reac12.kcst = 8426.3
    Reac13 = smodel.SReac('Reac13', ERs, slhs = [Ca2SERCA], srhs = [SERCA], irhs = [Ca,Ca])
    Reac13.kcst = 250
    
    # Leak
    Reac14 = smodel.Reac('Reac14', vsys, rhs = [Ca])    
    # reaction constant for zero-order reaction units M/s in STEPS 1.2 and above
    Reac14.kcst = 1900/(Na*0.08e-15)
    
    # PV + Ca <-> CaPV + Ca <-> Ca2PV
    Reac15 = smodel.Reac('Reac15', vsys, lhs = [PV, Ca], rhs = [CaPV])
    Reac15.kcst = 107e6 
    Reac16 = smodel.Reac('Reac16', vsys, lhs = [CaPV], rhs = [PV, Ca])
    Reac16.kcst = 0.95
    Reac17 = smodel.Reac('Reac17', vsys, lhs = [CaPV, Ca], rhs = [Ca2PV])
    Reac17.kcst = 107e6 
    Reac18 = smodel.Reac('Reac18', vsys, lhs = [Ca2PV], rhs = [Ca, CaPV])
    Reac18.kcst = 0.95
    
    # PV + Mg <-> MgPV <-> Mg2PV, apparent rate constants, [Mg] = 590uM 
    Reac19 = smodel.Reac('Reac19', vsys, lhs = [PV], rhs = [MgPV])
    Reac19.kcst = 472
    Reac20 = smodel.Reac('Reac20', vsys, lhs = [MgPV], rhs = [PV])
    Reac20.kcst = 25
    Reac21 = smodel.Reac('Reac21', vsys, lhs = [MgPV], rhs = [Mg2PV])
    Reac21.kcst = 472
    Reac22 = smodel.Reac('Reac22', vsys, lhs = [Mg2PV], rhs = [MgPV])
    Reac22.kcst = 25
    
    # CBs + Ca <-> CaCBs + Ca <-> Ca2CBs, CBs - high affinity site
    Reac23 = smodel.Reac('Reac23', vsys, lhs = [CBs, Ca], rhs = [CaCBs])
    Reac23.kcst = 5.5e6
    Reac24 = smodel.Reac('Reac24', vsys, lhs = [CaCBs], rhs = [CBs, Ca])
    Reac24.kcst = 2.6
    Reac25 = smodel.Reac('Reac25', vsys, lhs = [CaCBs, Ca], rhs = [Ca2CBs])
    Reac25.kcst = 5.5e6 
    Reac26 = smodel.Reac('Reac26', vsys, lhs = [Ca2CBs], rhs = [CaCBs, Ca])
    Reac26.kcst = 2.6
    
    # CBf + Ca <-> CaCBf + Ca <-> Ca2CBf, CBf - medium affinity site
    Reac27 = smodel.Reac('Reac27', vsys, lhs = [CBf, Ca], rhs = [CaCBf])
    Reac27.kcst = 43.5e6 
    Reac28 = smodel.Reac('Reac28', vsys, lhs = [CaCBf], rhs = [CBf, Ca])
    Reac28.kcst = 35.8
    Reac29 = smodel.Reac('Reac29', vsys, lhs = [CaCBf, Ca], rhs = [Ca2CBf])
    Reac29.kcst = 43.5e6 
    Reac30 = smodel.Reac('Reac30', vsys, lhs = [Ca2CBf], rhs = [CaCBf, Ca])
    Reac30.kcst = 35.8
    
    # PKC + Ca <-> CaPKC + 2Ca <-> Ca3PKC <-> Ca3PKC* (PKCstar)
    Reac31 = smodel.Reac('Reac31', vsys, lhs = [PKC, Ca], rhs = [Ca1PKC])
    Reac31.kcst = 13.3e6
    Reac32 = smodel.Reac('Reac32', vsys, lhs = [Ca1PKC], rhs = [PKC, Ca])
    Reac32.kcst = 12
    Reac33 = smodel.Reac('Reac33', vsys, lhs = [Ca1PKC, Ca, Ca], rhs = [Ca3PKC])
    Reac33.kcst = 1.e12 
    Reac34 = smodel.Reac('Reac34', vsys, lhs = [Ca3PKC], rhs = [Ca1PKC, Ca, Ca])
    Reac34.kcst = 12
    Reac35 = smodel.SReac('Reac35', s, ilhs = [Ca3PKC], srhs = [PKCstar])
    Reac35.kcst = 11.3  
    Reac36 = smodel.SReac('Reac36', s, slhs = [PKCstar], irhs = [Ca3PKC])
    Reac36.kcst = 0.23 
    
    # PKC + AA <-> AAPKC <-> AAPKC* (PKCstar2)
    Reac37 = smodel.Reac('Reac37', vsys, lhs = [PKC, AA], rhs = [AAPKC])
    Reac37.kcst = 1e6
    Reac38 = smodel.Reac('Reac38', vsys, lhs = [AAPKC], rhs = [PKC, AA])
    Reac38.kcst = 10
    Reac39 = smodel.SReac('Reac39', s, ilhs = [AAPKC], srhs = [PKCstar2])
    Reac39.kcst = 0.017
    Reac40 = smodel.SReac('Reac40', s, slhs = [PKCstar2], irhs = [AAPKC])
    Reac40.kcst = 0.0055
    
    # Ca1PKC + AA <-> AACa1PKC <-> AACa1PKC* (PKCstar3) + 2Ca <-> AACa3PKC* (PKCstar4)
    Reac41 = smodel.Reac('Reac41', vsys, lhs = [Ca1PKC, AA], rhs = [AACa1PKC])
    Reac41.kcst = 1e6
    Reac42 = smodel.Reac('Reac42', vsys, lhs = [AACa1PKC], rhs = [Ca1PKC, AA])
    Reac42.kcst = 10
    Reac43 = smodel.SReac('Reac43', s, ilhs = [AACa1PKC], srhs = [PKCstar3])
    Reac43.kcst = 0.017
    Reac44 = smodel.SReac('Reac44', s, slhs = [PKCstar3], irhs = [AACa1PKC])
    Reac44.kcst = 0.0055
    Reac45 = smodel.SReac('Reac45', s, slhs = [PKCstar3], ilhs = [Ca, Ca], srhs = [PKCstar4])
    Reac45.kcst =  1.0e12
    Reac46 = smodel.SReac('Reac46', s, slhs = [PKCstar4], srhs = [PKCstar3], irhs = [Ca, Ca])
    Reac46.kcst = 12
    
    # AAPKC + Ca <-> AACa1PKC <-> AACa1PKC + 2Ca <-> AACa3PKC  <-> AACa3PKC* (PKCstar4)
    Reac47 = smodel.Reac('Reac47', vsys, lhs = [AAPKC, Ca], rhs = [AACa1PKC])
    Reac47.kcst = 13.3e6
    Reac48 = smodel.Reac('Reac48', vsys, lhs = [AACa1PKC], rhs = [AAPKC, Ca])
    Reac48.kcst = 12
    Reac49 = smodel.Reac('Reac49', vsys, lhs = [AACa1PKC, Ca, Ca], rhs = [AACa3PKC])
    Reac49.kcst = 1.0e12
    Reac50 = smodel.Reac('Reac50', vsys, lhs = [AACa3PKC], rhs = [AACa1PKC, Ca, Ca])
    Reac50.kcst = 12
    Reac51 = smodel.SReac('Reac51', s, ilhs = [AACa3PKC], srhs = [PKCstar4])
    Reac51.kcst = 11.3
    Reac52 = smodel.SReac('Reac52', s, slhs = [PKCstar4], irhs = [AACa3PKC])
    Reac52.kcst = 0.23
    
     # Ca3PKC + AA <-> AACa3PKC
    Reac53 = smodel.Reac('Reac53', vsys, lhs = [Ca3PKC, AA], rhs = [AACa3PKC])
    Reac53.kcst = 1e6
    Reac54 = smodel.Reac('Reac54', vsys, lhs = [AACa3PKC], rhs = [Ca3PKC, AA])
    Reac54.kcst = 10
    
    # AAPKC* + Ca <-> AACa1PKC*
    Reac55 = smodel.SReac('Reac55', s, slhs = [PKCstar2], ilhs = [Ca], srhs = [PKCstar3])
    Reac55.kcst =  13.3e6
    Reac56 = smodel.SReac('Reac56', s, slhs = [PKCstar3], srhs = [PKCstar2], irhs = [Ca])
    Reac56.kcst = 12
    
    # Ca3PKC* + AA <-> AACa3PKC*
    Reac57 = smodel.SReac('Reac57', s, ilhs = [AA], slhs = [PKCstar], srhs = [PKCstar4])
    Reac57.kcst = 1e6
    Reac58 = smodel.SReac('Reac58', s, slhs = [PKCstar4], irhs = [AA], srhs = [PKCstar])
    Reac58.kcst = 10
    
    # Ca3PKC* + RafRKIP <-> Ca3PKC*.RafRKIP -> Ca3PKC* + RafRKIP
    Reac59 = smodel.SReac('Reac59', s, ilhs = [RafRKIP], slhs = [PKCstar], srhs = [RafRKIPPKCstar])
    Reac59.kcst = 0.625e6
    Reac60 = smodel.SReac('Reac60', s, slhs = [RafRKIPPKCstar], irhs = [RafRKIP], srhs = [PKCstar])
    Reac60.kcst = 0.00245
    Reac61 = smodel.SReac('Reac61', s, slhs = [RafRKIPPKCstar], srhs = [PKCstar], irhs = [RKIPstar, Rafstar])
    Reac61.kcst = 0.0315
    
    # AAPKC* + RafRKIP <-> AAPKC*.RafRKIP -> AAPKC* + RafRKIP
    Reac62 = smodel.SReac('Reac62', s, ilhs = [RafRKIP], slhs = [PKCstar2], srhs = [RafRKIPPKCstar2])
    Reac62.kcst =  0.625e6
    Reac63 = smodel.SReac('Reac63', s, slhs = [RafRKIPPKCstar2], irhs = [RafRKIP], srhs = [PKCstar2])
    Reac63.kcst = 0.00245
    Reac64 = smodel.SReac('Reac64', s, slhs = [RafRKIPPKCstar2], srhs = [PKCstar2], irhs = [RKIPstar, Rafstar])
    Reac64.kcst =  0.0315
    
    # AACa1PKC* + RafRKIP -> AACa1PKC*.RafRKIP -> AACa1PKC* + RafRKIP
    Reac65 = smodel.SReac('Reac65', s, ilhs = [RafRKIP], slhs = [PKCstar3], srhs = [RafRKIPPKCstar3])
    Reac65.kcst =  0.625e6
    Reac66 = smodel.SReac('Reac66', s, slhs = [RafRKIPPKCstar3], irhs = [RafRKIP], srhs = [PKCstar3])
    Reac66.kcst = 0.00245
    Reac67 = smodel.SReac('Reac67', s, slhs = [RafRKIPPKCstar3], srhs = [PKCstar3], irhs = [RKIPstar, Rafstar])
    Reac67.kcst =  0.0315
    
    # AACa3PKC* + RafRKIP <-> AACa3PKC*.RafRKIP -> AACa3PKC* + RafRKIP
    Reac68 = smodel.SReac('Reac68', s, ilhs = [RafRKIP], slhs = [PKCstar4], srhs = [RafRKIPPKCstar4])
    Reac68.kcst =  0.625e6
    Reac69 = smodel.SReac('Reac69', s, slhs = [RafRKIPPKCstar4], irhs = [RafRKIP], srhs = [PKCstar4])
    Reac69.kcst = 0.00245
    Reac70 = smodel.SReac('Reac70', s, slhs = [RafRKIPPKCstar4], srhs = [PKCstar4], irhs = [RKIPstar, Rafstar])
    Reac70.kcst = 0.0315
    
    # Raf + RKIP --k1-> RafRKIP --k2-> Raf + RKIP
    Reac71 = smodel.Reac('Reac71',vsys, lhs = [Raf , RKIP], rhs = [RafRKIP])
    Reac71.kcst = 0.53e6
    Reac72 = smodel.Reac('Reac72', vsys, lhs = [RafRKIP], rhs =[Raf , RKIP])
    Reac72.kcst = 0.072
    
    # Ca3PKC* + MEKRKIP <-> Ca3PKC*.MEKRKIP -> Ca3PKC* + MEKRKIP
    Reac73 = smodel.SReac('Reac73', s, ilhs = [MEKRKIP], slhs = [PKCstar], srhs = [MEKRKIPPKCstar])
    Reac73.kcst = 0.625e6
    Reac74 = smodel.SReac('Reac74', s, slhs = [MEKRKIPPKCstar], irhs = [MEKRKIP], srhs = [PKCstar])
    Reac74.kcst = 0.00245
    Reac75 = smodel.SReac('Reac75', s, slhs = [MEKRKIPPKCstar], srhs = [PKCstar], irhs = [RKIPstar, MEKp])
    Reac75.kcst = 0.0315
    
    # AAPKC* + MEKRKIP <-> AAPKC*.MEKRKIP -> AAPKC* + MEKRKIP
    Reac76 = smodel.SReac('Reac76', s, ilhs = [MEKRKIP], slhs = [PKCstar2], srhs = [MEKRKIPPKCstar2])
    Reac76.kcst =  0.625e6
    Reac77 = smodel.SReac('Reac77', s, slhs = [MEKRKIPPKCstar2], irhs = [MEKRKIP], srhs = [PKCstar2])
    Reac77.kcst = 0.00245
    Reac78 = smodel.SReac('Reac78', s, slhs = [MEKRKIPPKCstar2], srhs = [PKCstar2], irhs = [MEKp, RKIPstar])
    Reac78.kcst =  0.0315
    
    # AACa1PKC* + MEKRKIP -> AACa1PKC*.MEKRKIP -> AACa1PKC* + MEKRKIP
    Reac79 = smodel.SReac('Reac79', s, ilhs = [MEKRKIP], slhs = [PKCstar3], srhs = [MEKRKIPPKCstar3])
    Reac79.kcst =  0.625e6
    Reac80 = smodel.SReac('Reac80', s, slhs = [MEKRKIPPKCstar3], irhs = [MEKRKIP], srhs = [PKCstar3])
    Reac80.kcst = 0.00245
    Reac81 = smodel.SReac('Reac81', s, slhs = [MEKRKIPPKCstar3], srhs = [PKCstar3], irhs = [MEKp, RKIPstar])
    Reac81.kcst =  0.0315
    
    # AACa3PKC* + MEKRKIP <-> AACa3PKC*.MEKRKIP -> AACa3PKC* + MEKRKIP
    Reac82 = smodel.SReac('Reac82', s, ilhs = [MEKRKIP], slhs = [PKCstar4], srhs = [MEKRKIPPKCstar4])
    Reac82.kcst =  0.625e6
    Reac83 = smodel.SReac('Reac83', s, slhs = [MEKRKIPPKCstar4], irhs = [MEKRKIP], srhs = [PKCstar4])
    Reac83.kcst = 0.00245
    Reac84 = smodel.SReac('Reac84', s, slhs = [MEKRKIPPKCstar4], srhs = [PKCstar4], irhs = [RKIPstar, MEKp])
    Reac84.kcst = 0.0315
    
    # MEK + RKIP --k1-> MEKRKIP --k2-> MEK + RKIP
    Reac85 = smodel.Reac('Reac85',vsys, lhs = [MEK , RKIP], rhs = [MEKRKIP])
    Reac85.kcst = 0.53e6
    Reac86 = smodel.Reac('Reac86', vsys, lhs = [MEKRKIP], rhs =[MEK , RKIP])
    Reac86.kcst = 0.072
    
    # RKIPstar + RP --k9-> RKIPstarRP --k10-> RKIPstar + RP
    Reac87 = smodel.Reac('Reac87' , vsys, lhs =[RKIPstar, RP], rhs =[RKIPstarRP])
    Reac87.kcst = 0.92e6
    Reac88 = smodel.Reac('Reac88', vsys, lhs =[RKIPstarRP], rhs=[RKIPstar, RP])
    Reac88.kcst = 0.00122
    # RKIPstarRP --k11-> RKIP + RP
    Reac89 = smodel.Reac('Reac89' , vsys, lhs =[RKIPstarRP], rhs = [RKIP, RP])
    Reac89.kcst = 0.87
    
    
    # PP5 (PP) + Raf* <-> PP5.Raf* -> PP5 + Raf
    Reac90 = smodel.Reac('Reac90', vsys, lhs = [PP5, Rafstar], rhs = [PP5Rafstar])
    Reac90.kcst = .55e6
    Reac91 = smodel.Reac('Reac91', vsys, lhs = [PP5Rafstar], rhs = [PP5, Rafstar])
    Reac91.kcst = 2
    Reac92 = smodel.Reac('Reac92', vsys, lhs = [PP5Rafstar], rhs = [PP5, Raf])
    Reac92.kcst = 0.5
    
    
    # Raf* + MEK <-> Raf*.MEK -> Raf* + MEKp <->Raf*.MEKp -> Raf* + MEK* (MEKstar)
    Reac93 = smodel.Reac('Reac93', vsys, lhs = [Rafstar, MEK], rhs = [RafstarMEK])
    Reac93.kcst = 0.65e6
    Reac94 = smodel.Reac('Reac94', vsys, lhs = [RafstarMEK], rhs = [Rafstar, MEK])
    Reac94.kcst = 0.065
    Reac95 = smodel.Reac('Reac95', vsys, lhs = [RafstarMEK], rhs = [Rafstar, MEKp])
    Reac95.kcst = 1.0
    Reac96 = smodel.Reac('Reac96', vsys, lhs = [Rafstar, MEKp], rhs = [RafstarMEKp])
    Reac96.kcst = 0.65e6
    Reac97 = smodel.Reac('Reac97', vsys, lhs = [RafstarMEKp], rhs = [Rafstar, MEKp])
    Reac97.kcst = 0.065
    Reac98 = smodel.Reac('Reac98', vsys, lhs = [RafstarMEKp], rhs = [Rafstar, MEKstar])
    Reac98.kcst = 1.0
    
    # PP2A + MEK* <-> PP2A.MEK* -> PP2A + MEKp <-> PP2A.MEKp -> PP2A + MEK
    Reac99 = smodel.Reac('Reac99', vsys, lhs = [PP2A, MEKstar], rhs = [PP2AMEKstar])
    Reac99.kcst = 0.75e6
    Reac100 = smodel.Reac('Reac100', vsys, lhs = [PP2AMEKstar], rhs = [PP2A, MEKstar])
    Reac100.kcst = 2
    Reac101 = smodel.Reac('Reac101', vsys, lhs = [PP2AMEKstar], rhs = [PP2A, MEKp])
    Reac101.kcst = 0.5
    Reac102 = smodel.Reac('Reac102', vsys, lhs = [PP2A, MEKp], rhs = [PP2AMEKp])
    Reac102.kcst = 0.75e6
    Reac103 = smodel.Reac('Reac103', vsys, lhs = [PP2AMEKp], rhs = [PP2A, MEKp])
    Reac103.kcst = 2
    Reac104= smodel.Reac('Reac104', vsys, lhs = [PP2AMEKp], rhs = [PP2A, MEK])
    Reac104.kcst = 0.5
    
    # MEK* + ERK <-> MEK*.ERK -> MEK* + ERKp <-> MEK*.ERKp -> MEK* + ERK* (ERKstar)
    Reac105 = smodel.Reac('Reac105', vsys, lhs = [MEKstar, ERK], rhs = [MEKstarERK])
    Reac105.kcst = 16.2e6
    Reac106 = smodel.Reac('Reac106', vsys, lhs = [MEKstarERK], rhs = [MEKstar, ERK])
    Reac106.kcst = 0.6
    Reac107 = smodel.Reac('Reac107', vsys, lhs = [MEKstarERK], rhs = [MEKstar, ERKp])
    Reac107.kcst = 0.15
    Reac108 = smodel.Reac('Reac108', vsys, lhs = [MEKstar, ERKp], rhs = [MEKstarERKp])
    Reac108.kcst = 16.2e6
    Reac109 = smodel.Reac('Reac109', vsys, lhs = [MEKstarERKp], rhs = [MEKstar, ERKp])
    Reac109.kcst = 0.6
    Reac110 = smodel.Reac('Reac110', vsys, lhs = [MEKstarERKp], rhs = [MEKstar, ERKstar])
    Reac110.kcst = 0.3
    
    # MKP + ERK* <-> MKP.ERK* -> MKP + ERKp <-> MKP.ERKp -> MKP + ERK
    Reac111 = smodel.Reac('Reac111', vsys, lhs = [MKP, ERKstar], rhs = [MKPERKstar])
    Reac111.kcst = 13e6
    Reac112 = smodel.Reac('Reac112', vsys, lhs = [MKPERKstar], rhs = [MKP, ERKstar])
    Reac112.kcst = 0.396
    Reac113 = smodel.Reac('Reac113', vsys, lhs = [MKPERKstar], rhs = [MKP, ERKp])
    Reac113.kcst = 0.099
    Reac114 = smodel.Reac('Reac114', vsys, lhs = [MKP, ERKp], rhs = [MKPERKp])
    Reac114.kcst = 28e6
    Reac115 = smodel.Reac('Reac115', vsys, lhs = [MKPERKp], rhs = [MKP, ERKp])
    Reac115.kcst = 0.56
    Reac116 = smodel.Reac('Reac116', vsys, lhs = [MKPERKp], rhs = [MKP, ERK])
    Reac116.kcst = 0.14
    
    # Ca + PLA2 <-> Ca1PLA2 + Ca <-> Ca2PLA2 <-> Ca2PLA2* (PLA2star1)
    Reac117 = smodel.Reac('Reac117', vsys, lhs = [PLA2, Ca], rhs = [Ca1PLA2])
    Reac117.kcst = 1.93e6
    Reac118 = smodel.Reac('Reac118', vsys, lhs = [Ca1PLA2], rhs = [PLA2, Ca])
    Reac118.kcst = 108
    Reac119 = smodel.Reac('Reac119', vsys, lhs = [Ca, Ca1PLA2], rhs = [Ca2PLA2])
    Reac119.kcst = 10.8e6
    Reac120 = smodel.Reac('Reac120', vsys, lhs = [Ca2PLA2], rhs = [Ca1PLA2, Ca])
    Reac120.kcst = 108
    Reac121 = smodel.SReac('Reac121', s, ilhs = [Ca2PLA2], srhs = [PLA2star1])
    Reac121.kcst = 300
    Reac122 = smodel.SReac('Reac122', s, slhs = [PLA2star1], irhs = [Ca2PLA2])
    Reac122.kcst = 15
    
    # Ca1PLA2 <-> Ca1PLA2memb
    Reac123 = smodel.SReac('Reac123', s, ilhs = [Ca1PLA2],  srhs = [Ca1PLA2memb])
    Reac123.kcst = 30
    Reac124 = smodel.SReac('Reac124', s, slhs = [Ca1PLA2memb], irhs = [Ca1PLA2])
    Reac124.kcst = 15
    
    # PLA2 <-> PLA2memb
    Reac125 = smodel.SReac('Reac125', s, ilhs = [PLA2], srhs = [PLA2memb])
    Reac125.kcst = 3
    Reac126 = smodel.SReac('Reac126', s, slhs = [PLA2memb], irhs = [PLA2])
    Reac126.kcst = 15
    
    # PLA2memb + Ca <-> Ca1PLA2memb + Ca <-> Ca2PLA2* (PLA2star1)
    Reac127 = smodel.SReac('Reac127', s, slhs = [PLA2memb], ilhs = [Ca], srhs = [Ca1PLA2memb])
    Reac127.kcst = 1.93e6
    Reac128 = smodel.SReac('Reac128', s, ilhs = [Ca1PLA2memb], srhs = [PLA2memb], irhs = [Ca])
    Reac128.kcst = 0.41
    Reac129 = smodel.SReac('Reac129', s, slhs = [Ca1PLA2memb], ilhs = [Ca], srhs = [PLA2star1])
    Reac129.kcst = 10.8e6
    Reac130 = smodel.SReac('Reac130', s, ilhs = [PLA2star1], srhs = [Ca1PLA2memb], irhs = [Ca])
    Reac130.kcst = 2.5
    
    
    # PLA2star1 <-> PLA2star1APC -> PLA2star1 + AA
    Reac131 = smodel.SReac('Reac131', s, slhs = [PLA2star1],  srhs = [PLA2star1APC])
    Reac131.kcst = 43
    Reac132 = smodel.SReac('Reac132', s, slhs = [PLA2star1APC],  srhs = [PLA2star1])
    Reac132.kcst = 600
    Reac133 = smodel.SReac('Reac133', s, slhs = [PLA2star1APC], irhs = [AA], srhs = [PLA2star1])
    Reac133.kcst = 450
    
    # ERK* + PLA2 <-> ERK*.PLA2 -> ERK* + PLA2p (PLA2star2)
    Reac134 = smodel.Reac('Reac134', vsys, lhs = [ERKstar, PLA2], rhs = [ERKstarPLA2])
    Reac134.kcst = 4e6
    Reac135 = smodel.Reac('Reac135', vsys, lhs = [ERKstarPLA2], rhs = [ERKstar, PLA2])
    Reac135.kcst = 1
    Reac136 = smodel.Reac('Reac136', vsys, lhs = [ERKstarPLA2], rhs = [ERKstar, PLA2star2])
    Reac136.kcst = 14
    
     # ERK* + Ca1PLA2 <-> ERK*.Ca1PLA2 -> ERK* + Ca1PLA2p (Ca1PLA2star2)
    Reac137 = smodel.Reac('Reac137', vsys, lhs = [ERKstar, Ca1PLA2], rhs = [ERKstarCa1PLA2])
    Reac137.kcst = 4e6
    Reac138 = smodel.Reac('Reac138', vsys, lhs = [ERKstarCa1PLA2], rhs = [ERKstar, Ca1PLA2])
    Reac138.kcst = 1
    Reac139 = smodel.Reac('Reac139', vsys, lhs = [ERKstarCa1PLA2], rhs = [ERKstar, Ca1PLA2star2])
    Reac139.kcst = 14
    
    # ERK* + Ca2PLA2 <-> ERK*.Ca2PLA2 -> ERK* + Ca2PLA2p (Ca2PLA2star2)
    Reac140 = smodel.Reac('Reac140', vsys, lhs = [ERKstar, Ca2PLA2], rhs = [ERKstarCa2PLA2])
    Reac140.kcst = 4e6
    Reac141 = smodel.Reac('Reac141', vsys, lhs = [ERKstarCa2PLA2], rhs = [ERKstar, Ca2PLA2])
    Reac141.kcst = 1
    Reac142 = smodel.Reac('Reac142', vsys, lhs = [ERKstarCa2PLA2], rhs = [ERKstar, Ca2PLA2star2])
    Reac142.kcst = 14
    
    # PP2A + PLA2p <-> PP2A.PLA2p -> PP2A + PLA2
    Reac143 = smodel.Reac('Reac143', vsys, lhs = [PP2A, PLA2star2], rhs = [PP2APLA2star2])
    Reac143.kcst = 1.4e6
    Reac144 = smodel.Reac('Reac144', vsys, lhs = [PP2APLA2star2], rhs = [PP2A, PLA2star2])
    Reac144.kcst = 1.5
    Reac145 = smodel.Reac('Reac145', vsys, lhs = [PP2APLA2star2], rhs = [PLA2, PP2A])
    Reac145.kcst = 2.5
    
    # PP2A + Ca1PLA2p <-> PP2A.Ca1PLA2p -> PP2A + Ca1PLA2
    Reac146 = smodel.Reac('Reac146', vsys, lhs = [PP2A, Ca1PLA2star2], rhs = [PP2ACa1PLA2star2])
    Reac146.kcst = 1.4e6
    Reac147 = smodel.Reac('Reac147', vsys, lhs = [PP2ACa1PLA2star2], rhs = [PP2A, Ca1PLA2star2])
    Reac147.kcst = 1.5
    Reac148 = smodel.Reac('Reac148', vsys, lhs = [PP2ACa1PLA2star2], rhs = [PP2A, Ca1PLA2])
    Reac148.kcst = 2.5
    
    # PP2A + Ca2PLA2p <-> PP2A.Ca2PLA2p -> PP2A + Ca2PLA2
    Reac149 = smodel.Reac('Reac149', vsys, lhs = [PP2A, Ca2PLA2star2], rhs = [PP2ACa2PLA2star2])
    Reac149.kcst = 1.4e6
    Reac150 = smodel.Reac('Reac150', vsys, lhs = [PP2ACa2PLA2star2], rhs = [PP2A, Ca2PLA2star2])
    Reac150.kcst = 1.5
    Reac151 = smodel.Reac('Reac151', vsys, lhs = [PP2ACa2PLA2star2], rhs = [PP2A, Ca2PLA2])
    Reac151.kcst = 2.5
    
    # PP1 + PLA2p <-> PP1.PLA2p -> PP1 + PLA2
    Reac152 = smodel.Reac('Reac152', vsys, lhs = [PP1, PLA2star2], rhs = [PP1PLA2star2])
    Reac152.kcst = 1.4e6
    Reac153 = smodel.Reac('Reac153', vsys, lhs = [PP1PLA2star2], rhs = [PP1, PLA2star2])
    Reac153.kcst = 1.5
    Reac154 = smodel.Reac('Reac154', vsys, lhs = [PP1PLA2star2], rhs = [PLA2, PP1])
    Reac154.kcst = 2.5
    
    # PP1 + Ca1PLA2p <-> PP1.Ca1PLA2p -> PP1 + Ca1PLA2
    Reac155 = smodel.Reac('Reac155', vsys, lhs = [PP1, Ca1PLA2star2], rhs = [PP1Ca1PLA2star2])
    Reac155.kcst = 1.4e6
    Reac156 = smodel.Reac('Reac156', vsys, lhs = [PP1Ca1PLA2star2], rhs = [PP1, Ca1PLA2star2])
    Reac156.kcst = 1.5
    Reac157 = smodel.Reac('Reac157', vsys, lhs = [PP1Ca1PLA2star2], rhs = [PP1, Ca1PLA2])
    Reac157.kcst = 2.5
    
    # PP1 + Ca2PLA2p <-> PP1.Ca2PLA2p -> PP1 + Ca2PLA2
    Reac158 = smodel.Reac('Reac158', vsys, lhs = [PP1, Ca2PLA2star2], rhs = [PP1Ca2PLA2star2])
    Reac158.kcst = 1.4e6
    Reac159 = smodel.Reac('Reac159', vsys, lhs = [PP1Ca2PLA2star2], rhs = [PP1, Ca2PLA2star2])
    Reac159.kcst = 1.5
    Reac160 = smodel.Reac('Reac160', vsys, lhs = [PP1Ca2PLA2star2], rhs = [PP1, Ca2PLA2])
    Reac160.kcst = 2.5
    
    # PLA2p <-> PLA2** (PLA2star2memb) <-> PLA2**APC -> PLA2** + AA
    Reac161 = smodel.SReac('Reac161', s, ilhs = [PLA2star2],  srhs = [PLA2star2memb])
    Reac161.kcst = 50
    Reac162 = smodel.SReac('Reac162', s, slhs = [PLA2star2memb], irhs = [PLA2star2])
    Reac162.kcst = 15
    Reac163 = smodel.SReac('Reac163', s, slhs = [PLA2star2memb],  srhs = [PLA2star2membAPC])
    Reac163.kcst = 43
    Reac164 = smodel.SReac('Reac164', s, slhs = [PLA2star2membAPC],  srhs = [PLA2star2memb])
    Reac164.kcst = 600
    Reac165 = smodel.SReac('Reac165', s, slhs = [PLA2star2membAPC], srhs = [PLA2star2memb], irhs = [AA])
    Reac165.kcst = 3600
    
    # Ca1PLA2p <-> Ca1PLA2** (Ca1PLA2star2memb) <-> Ca1PLA2**APC -> Ca1PLA2** + AA
    Reac166 = smodel.SReac('Reac166', s, ilhs = [Ca1PLA2star2], srhs = [Ca1PLA2star2memb])
    Reac166.kcst = 30
    Reac167 = smodel.SReac('Reac167', s, slhs = [Ca1PLA2star2memb], irhs = [Ca1PLA2star2])
    Reac167.kcst = 15
    Reac168 = smodel.SReac('Reac168', s, slhs = [Ca1PLA2star2memb],  srhs = [Ca1PLA2star2membAPC])
    Reac168.kcst = 43
    Reac169 = smodel.SReac('Reac169', s, slhs = [Ca1PLA2star2membAPC],  srhs = [Ca1PLA2star2memb])
    Reac169.kcst = 600
    Reac170 = smodel.SReac('Reac170', s, slhs = [Ca1PLA2star2membAPC], srhs = [Ca1PLA2star2memb], irhs = [AA])
    Reac170.kcst = 3600
    
    # Ca2PLA2p <-> Ca2PLA2** (Ca2PLA2star2memb) <-> Ca2PLA2**APC -> Ca2PLA2** + AA
    Reac171 = smodel.SReac('Reac171', s, ilhs = [Ca2PLA2star2], srhs = [Ca2PLA2star2memb])
    Reac171.kcst = 300
    Reac172 = smodel.SReac('Reac172', s, slhs = [Ca2PLA2star2memb], irhs = [Ca2PLA2star2])
    Reac172.kcst = 15
    Reac173 = smodel.SReac('Reac173', s, slhs = [Ca2PLA2star2memb],  srhs = [Ca2PLA2star2membAPC])
    Reac173.kcst = 43
    Reac174 = smodel.SReac('Reac174', s, slhs = [Ca2PLA2star2membAPC],  srhs = [Ca2PLA2star2memb])
    Reac174.kcst = 600
    Reac175 = smodel.SReac('Reac175', s, slhs = [Ca2PLA2star2membAPC], srhs = [Ca2PLA2star2memb], irhs = [AA])
    Reac175.kcst = 3600
    
    # Ca + PLA2p <-> Ca1PLA2p
    Reac176 = smodel.Reac('Reac176', vsys, lhs = [PLA2star2, Ca], rhs = [Ca1PLA2star2])
    Reac176.kcst = 1.93e6
    Reac177 = smodel.Reac('Reac177', vsys, lhs = [Ca1PLA2star2], rhs = [PLA2star2, Ca])
    Reac177.kcst = 108
    
    # Ca + PLA2** <-> Ca1PLA2**
    Reac178 = smodel.SReac('Reac178', s, slhs = [PLA2star2memb], ilhs = [Ca], srhs = [Ca1PLA2star2memb])
    Reac178.kcst = 1.93e6
    Reac179 = smodel.SReac('Reac179', s, ilhs = [Ca1PLA2star2memb], srhs = [PLA2star2memb], irhs = [Ca])
    Reac179.kcst = 0.41
    
    # Ca + Ca1PLA2p <-> Ca2PLA2p
    Reac180 = smodel.Reac('Reac180', vsys, lhs = [Ca, Ca1PLA2star2], rhs = [Ca2PLA2star2])
    Reac180.kcst = 10.8e6
    Reac181 = smodel.Reac('Reac181', vsys, lhs = [Ca2PLA2star2], rhs = [Ca1PLA2star2, Ca])
    Reac181.kcst = 108
    
    # Ca + Ca1PLA2** <-> Ca2PLA2**
    Reac182 = smodel.SReac('Reac182', s, slhs = [Ca1PLA2star2memb], ilhs = [Ca], srhs = [Ca2PLA2star2memb])
    Reac182.kcst = 10.8e6
    Reac183 = smodel.SReac('Reac183', s, ilhs = [Ca2PLA2star2memb], srhs = [Ca1PLA2star2memb], irhs = [Ca])
    Reac183.kcst = 2.5
    
    # AA -> 0 ,degradation
    Reac184 = smodel.SReac('Reac184', s, ilhs = [AA])
    Reac184.kcst = .4
    
    # Ca3PKC* + AMPAR <-> Ca3PKC*.AMPAR -> Ca3PKC* + AMPARp
    Reac185 = smodel.SReac('Reac185', s, slhs = [PKCstar, AMPAR], srhs = [PKCstarAMPAR])
    # units for 2D Reaction based on square meters in STEPS 1.2 and above
    # units for 2nd-order Reaction are m^2/mol.s
    Reac185.kcst = 0.4e6*(1.02e-12/1.87e-19)
    Reac186 = smodel.SReac('Reac186', s, slhs = [PKCstarAMPAR], srhs = [PKCstar, AMPAR])
    Reac186.kcst = 0.8
    Reac187 = smodel.SReac('Reac187', s, slhs = [PKCstarAMPAR], srhs = [PKCstar, AMPAR_P])
    Reac187.kcst = 0.3
    
    # AAPKC* + AMPAR <-> AAPKC*.AMPAR -> AAPKC* + AMPARp
    Reac188 = smodel.SReac('Reac188', s, slhs = [PKCstar2, AMPAR], srhs = [PKCstar2AMPAR])
    # units for 2D Reaction based on square meters in STEPS 1.2 and above
    # units for 2nd-order Reaction are m^2/mol.s
    Reac188.kcst = 0.4e6*(1.02e-12/1.87e-19)*1
    Reac189 = smodel.SReac('Reac189', s, slhs = [PKCstar2AMPAR], srhs = [PKCstar2, AMPAR])
    Reac189.kcst = 0.8
    Reac190 = smodel.SReac('Reac190', s, slhs = [PKCstar2AMPAR], srhs = [PKCstar2, AMPAR_P])
    Reac190.kcst = 0.3
    
    # AACa1PKC* + AMPAR <-> AACa1PKC*.AMPAR -> AACa1PKC* + AMPARp
    Reac191 = smodel.SReac('Reac191', s, slhs = [PKCstar3, AMPAR], srhs = [PKCstar3AMPAR])
    # units for 2D Reaction based on square meters in STEPS 1.2 and above
    # units for 2nd-order Reaction are m^2/mol.s
    Reac191.kcst = 0.4e6*(1.02e-12/1.87e-19)
    Reac192 = smodel.SReac('Reac192', s, slhs = [PKCstar3AMPAR], srhs = [PKCstar3, AMPAR])
    Reac192.kcst = 0.8
    Reac193 = smodel.SReac('Reac193', s, slhs = [PKCstar3AMPAR], srhs = [PKCstar3, AMPAR_P])
    Reac193.kcst =  0.3
    
    # AACa3PKC* + AMPAR <-> AACa3PKC*.AMPAR -> AACa3PKC* + AMPARp
    Reac194 = smodel.SReac('Reac194', s, slhs = [PKCstar4, AMPAR], srhs = [PKCstar4AMPAR])
    # units for 2D Reaction based on square meters in STEPS 1.2 and above
    # units for 2nd-order Reaction are m^2/mol.s
    Reac194.kcst = 0.4e6*(1.02e-12/1.87e-19)
    Reac195 = smodel.SReac('Reac195', s, slhs = [PKCstar4AMPAR], srhs = [PKCstar4, AMPAR])
    Reac195.kcst = 0.8
    Reac196 = smodel.SReac('Reac196', s, slhs = [PKCstar4AMPAR], srhs = [PKCstar4, AMPAR_P])
    Reac196.kcst = 0.3
    
    # PP2A + AMPARp <-> PP2A.AMPARp -> PP2A + AMPAR
    Reac197 = smodel.SReac('Reac197', s, ilhs = [PP2A], slhs = [AMPAR_P], srhs = [PP2AAMPAR_P])
    Reac197.kcst = 1.2e6
    Reac198 = smodel.SReac('Reac198', s, slhs = [PP2AAMPAR_P], irhs = [PP2A], srhs = [AMPAR_P])
    Reac198.kcst = 0.17
    Reac199 = smodel.SReac('Reac199', s, slhs = [PP2AAMPAR_P], srhs = [AMPAR], irhs = [PP2A])
    Reac199.kcst = 0.25
  
    
    # Ca3PKC* + GRIP.AMPA <-> Ca3PKC*.GRIP.AMPA -> Ca3PKC* + GRIP.AMPAp
    Reac200 = smodel.SReac('Reac200', s, slhs = [PKCstar, GRIPAMPAR], srhs = [PKCstarGRIPAMPAR])
    # units for 2D Reaction based on square meters in STEPS 1.2 and above
    # units for 2nd-order Reaction are m^2/mol.s
    Reac200.kcst = 0.4e6*(1.02e-12/1.87e-19)
    Reac201 = smodel.SReac('Reac201', s, slhs = [PKCstarGRIPAMPAR], srhs = [PKCstar, GRIPAMPAR])
    Reac201.kcst = 0.8
    Reac202 = smodel.SReac('Reac202', s, slhs = [PKCstarGRIPAMPAR], srhs = [PKCstar, GRIPAMPAR_P])
    Reac202.kcst = 0.3
    
    
    # AAPKC* + GRIP.AMPA <-> AAPKC*.GRIP.AMPA -> AAPKC* + GRIP.AMPAp
    Reac203 = smodel.SReac('Reac203', s, slhs = [PKCstar2, GRIPAMPAR], srhs = [PKCstar2GRIPAMPAR])
    # units for 2D Reaction based on square meters in STEPS 1.2 and above
    # units for 2nd-order Reaction are m^2/mol.s
    Reac203.kcst = 0.4e6*(1.02e-12/1.87e-19)*1
    Reac204 = smodel.SReac('Reac204', s, slhs = [PKCstar2GRIPAMPAR], srhs = [PKCstar2, GRIPAMPAR])
    Reac204.kcst = 0.8
    Reac205 = smodel.SReac('Reac205', s, slhs = [PKCstar2GRIPAMPAR], srhs = [PKCstar2, GRIPAMPAR_P])
    Reac205.kcst = 0.3
    
    # AACa1PKC* + GRIP.AMPA <-> AACa1PKC*.GRIP.AMPA -> AACa1PKC* + GRIP.AMPAp
    Reac206 = smodel.SReac('Reac206', s, slhs = [PKCstar3, GRIPAMPAR], srhs = [PKCstar3GRIPAMPAR])
    # units for 2D Reaction based on square meters in STEPS 1.2 and above
    # units for 2nd-order Reaction are m^2/mol.s
    Reac206.kcst = 0.4e6*(1.02e-12/1.87e-19)
    Reac207 = smodel.SReac('Reac207', s, slhs = [PKCstar3GRIPAMPAR], srhs = [PKCstar3, GRIPAMPAR])
    Reac207.kcst = 0.8
    Reac208 = smodel.SReac('Reac208', s, slhs = [PKCstar3GRIPAMPAR], srhs = [PKCstar3, GRIPAMPAR_P])
    Reac208.kcst =  0.3
    
    # AACa3PKC* + GRIP.AMPA <-> AACa3PKC*.GRIP.AMPA -> AACa3PKC* + GRIP.AMPAp
    Reac209 = smodel.SReac('Reac209', s, slhs = [PKCstar4, GRIPAMPAR], srhs = [PKCstar4GRIPAMPAR])
    # units for 2D Reaction based on square meters in STEPS 1.2 and above
    # units for 2nd-order Reaction are m^2/mol.s
    Reac209.kcst = 0.4e6*(1.02e-12/1.87e-19)
    Reac210 = smodel.SReac('Reac210', s, slhs = [PKCstar4GRIPAMPAR], srhs = [PKCstar4, GRIPAMPAR])
    Reac210.kcst = 0.8
    Reac211 = smodel.SReac('Reac211', s, slhs = [PKCstar4GRIPAMPAR], srhs = [PKCstar4, GRIPAMPAR_P])
    Reac211.kcst = 0.3
    
    # PP2A + GRIP.AMPAp <-> PP2A.GRIP.AMPAp -> PP2A + GRIP.AMPA
    Reac212 = smodel.SReac('Reac212', s, ilhs = [PP2A], slhs = [GRIPAMPAR_P], srhs = [PP2AGRIPAMPAR_P])
    Reac212.kcst = 0.6e6
    Reac213 = smodel.SReac('Reac213', s, slhs = [PP2AGRIPAMPAR_P], irhs = [PP2A], srhs = [GRIPAMPAR_P])
    Reac213.kcst = 0.17
    Reac214 = smodel.SReac('Reac214', s, slhs = [PP2AGRIPAMPAR_P], srhs = [GRIPAMPAR], irhs = [PP2A])
    Reac214.kcst = 0.25
    
    # AMPAR + GRIP <-> GRIP.AMPA
    Reac215 = smodel.SReac('Reac215', s, slhs = [AMPAR, GRIP], srhs = [GRIPAMPAR])
    # units for 2D Reaction based on square meters in STEPS 1.2 and above
    # units for 2nd-order Reaction are m^2/mol.s
    Reac215.kcst = 1e6*(1.02e-12/1.87e-19)
    Reac216 = smodel.SReac('Reac216', s, slhs = [GRIPAMPAR], srhs = [GRIP, AMPAR])
    Reac216.kcst = 7
    
    # AMPARp + GRIP <-> GRIP.AMPAp (AMPAR = synaptic AMPAR)
    Reac217 = smodel.SReac('Reac217', s, slhs = [AMPAR_P, GRIP], srhs = [GRIPAMPAR_P])
    # units for 2D Reaction based on square meters in STEPS 1.2 and above
    # units for 2nd-order Reaction are m^2/mol.s
    Reac217.kcst = 1e6*(1.02e-12/1.87e-19)
    Reac218 = smodel.SReac('Reac218', s, slhs = [GRIPAMPAR_P], srhs = [GRIP, AMPAR_P])
    Reac218.kcst = 70
    
    # AMPAR <-> AMPARextra (AMPARextra = extra-synaptic AMPAR)
    Reac219 = smodel.SReac('Reac219', s, slhs = [AMPAR], srhs = [AMPARextra])
    Reac219.kcst = 0.1
    Reac220 = smodel.SReac('Reac220', s, slhs = [AMPARextra], srhs = [AMPAR])
    Reac220.kcst = 0.02
    
    
    # AMPARp <-> AMPARextra_P
    Reac221 = smodel.SReac('Reac221', s, slhs = [AMPAR_P], srhs = [AMPARextra_P])
    Reac221.kcst =  0.1
    Reac222 = smodel.SReac('Reac222', s, slhs = [AMPARextra_P], srhs = [AMPAR_P])
    Reac222.kcst = 0.02
    
    
    # PP2A + AMPARextra_P  <-> PP2A.AMPARextra_P  -> PP2A + AMPARextra
    Reac223 = smodel.SReac('Reac223', s, ilhs = [PP2A], slhs = [AMPARextra_P], srhs = [PP2AAMPARextra_P])
    Reac223.kcst = 1.2e6
    Reac224 = smodel.SReac('Reac224', s, slhs = [PP2AAMPARextra_P], irhs = [PP2A], srhs = [AMPARextra_P])
    Reac224.kcst = 0.17
    Reac225 = smodel.SReac('Reac225', s, slhs = [PP2AAMPARextra_P], srhs = [AMPARextra], irhs = [PP2A])
    Reac225.kcst = 0.25
    
    # AMPARextra <-> AMPARdend (AMPARdend = dendritic AMPAR)
    Reac226 = smodel.SReac('Reac226', s, slhs = [AMPARextra], srhs = [AMPARdend])
    Reac226.kcst = 0.02
    Reac227 = smodel.SReac('Reac227', s, slhs = [AMPARdend], srhs = [AMPARextra])
    Reac227.kcst = 0.00025
    
    # AMPARextra_P <-> AMPARdend_P
    Reac228 = smodel.SReac('Reac228', s, slhs = [AMPARextra_P], srhs = [AMPARdend_P])
    Reac228.kcst =  0.02
    Reac229 = smodel.SReac('Reac229', s, slhs = [AMPARdend_P], srhs = [AMPARextra_P])
    Reac229.kcst = 0.00025
    
    # PP2A + AMPARp_dend  <-> PP2A.AMPARp_dend  -> PP2A + AMPAR_dend
    Reac230 = smodel.SReac('Reac230', s, ilhs = [PP2A], slhs = [AMPARdend_P], srhs = [PP2AAMPARdend_P])
    Reac230.kcst = 1.2e6
    Reac231 = smodel.SReac('Reac231', s, slhs = [PP2AAMPARdend_P], irhs = [PP2A], srhs = [AMPARdend_P])
    Reac231.kcst = 0.17
    Reac232 = smodel.SReac('Reac232', s, slhs = [PP2AAMPARdend_P], srhs = [AMPARdend], irhs = [PP2A])
    Reac232.kcst = 0.25
    
    # AMPARdend_P <-> AMPARcyt_P (AMPARcyt = cytosolic AMPAR)
    Reac233 = smodel.SReac('Reac233', s, slhs = [AMPARdend_P], irhs = [AMPARcyt_P])
    Reac233.kcst =  0.003
    Reac234 = smodel.SReac('Reac234', s, ilhs = [AMPARcyt_P], srhs = [AMPARdend_P])
    Reac234.kcst =  0.002
    
    # PP2A + AMPARcyt_P  <-> PP2A.AMPARcyt_P  -> PP2A + AMPARcyt
    Reac235 = smodel.Reac('Reac235', vsys, lhs = [PP2A, AMPARcyt_P], rhs = [PP2AAMPARcyt_P])
    Reac235.kcst = 1.2e6
    Reac236 = smodel.Reac('Reac236', vsys, lhs = [PP2AAMPARcyt_P], rhs = [PP2A, AMPARcyt_P])
    Reac236.kcst = 0.1
    Reac237 = smodel.Reac('Reac237', vsys, lhs = [PP2AAMPARcyt_P], rhs = [AMPARcyt, PP2A])
    Reac237.kcst = 0.25
    
    ##CaM enzyme activation
    
    # CaM + Ca <-> CaM1Ca <-> CaM2Ca <-> CaM3Ca
    Reac238 = smodel.Reac('Reac238', vsys, lhs = [CaM, Ca], rhs = [CaM1Ca])
    Reac238.kcst = 4e6
    Reac239 = smodel.Reac('Reac239', vsys, lhs = [CaM1Ca], rhs = [CaM, Ca])
    Reac239.kcst = 100
    Reac240 = smodel.Reac('Reac240', vsys, lhs = [CaM1Ca,Ca], rhs = [CaM2Ca])
    Reac240.kcst = 40e6
    Reac241 = smodel.Reac('Reac241', vsys, lhs = [CaM2Ca], rhs = [CaM1Ca, Ca])
    Reac241.kcst = 640
    Reac242 = smodel.Reac('Reac242', vsys, lhs = [CaM2Ca, Ca], rhs = [CaM3Ca])
    Reac242.kcst = 40e6
    Reac243 = smodel.Reac('Reac243', vsys, lhs = [CaM3Ca], rhs = [CaM2Ca, Ca])
    Reac243.kcst = 700
    
    # CaN + CaM3Ca <-> CaM3CaCaN
    Reac244 = smodel.Reac('Reac244', vsys, lhs = [CaN, CaM3Ca] , rhs = [CaM3CaCaN])
    Reac244.kcst = 400e6
    Reac245 = smodel.Reac('Reac245', vsys, lhs = [CaM3CaCaN], rhs = [CaN,CaM3Ca])
    Reac245.kcst = 3
    
    
    # GC + NO <-> GC_NO
    Reac246 = smodel.Reac('Reac246', vsys, lhs = [GC,NO], rhs = [GC_NO])
    Reac246.kcst = 1e6
    Reac247 = smodel.Reac('Reac247', vsys, lhs = [GC_NO], rhs = [GC,NO])
    Reac247.kcst = 0.01
    
    #GC_NO + GTP <-> GTP_GC_NO
    Reac248 = smodel.Reac('Reac248', vsys, lhs =[GC_NO, GTP], rhs = [GTP_GC_NO])
    Reac248.kcst = 0.735e6
    Reac249 = smodel.Reac('Reac249', vsys, lhs =[GTP_GC_NO], rhs = [GC_NO, GTP])
    Reac249.kcst = 29.4
    
    #GTP_GC_NO -> cGMP + GC_NO
    Reac250 = smodel.Reac('Reac250', vsys, lhs = [GTP_GC_NO], rhs = [cGMP,GC_NO])
    Reac250.kcst = 7.35
    
    #GC_NO -> GC
    Reac251 = smodel.Reac('Reac251', vsys, lhs = [GC_NO], rhs = [GC])
    Reac251.kcst = 0.673
    
    #cGMP + CaM3Ca_pPDE1 <-> cGMP_CaM3Ca_pPDE1 -> GMP + CaM3Ca_pPDE1
    Reac252 = smodel.Reac('Reac252', vsys, lhs = [cGMP,CaM3Ca_pPDE1], rhs = [cGMP_CaM3Ca_pPDE1])
    Reac252.kcst = 37.5e6
    Reac253 = smodel.Reac('Reac253', vsys, lhs = [cGMP_CaM3Ca_pPDE1], rhs = [cGMP,CaM3Ca_pPDE1])
    Reac253.kcst = 60
    Reac254 = smodel.Reac('Reac254', vsys, lhs = [cGMP_CaM3Ca_pPDE1], rhs = [GMP, CaM3Ca_pPDE1])
    Reac254.kcst = 15
    
    #cGMP + CaM3Ca_PDE1 <-> cGMP_CaM3Ca_PDE1 -> GMP + CaM3Ca_PDE1
    Reac255 = smodel.Reac('Reac255', vsys, lhs = [cGMP,CaM3Ca_PDE1], rhs = [cGMP_CaM3Ca_PDE1])
    Reac255.kcst = 37.5e6
    Reac256 = smodel.Reac('Reac256', vsys, lhs = [cGMP_CaM3Ca_PDE1], rhs = [cGMP,CaM3Ca_PDE1])
    Reac256.kcst = 60
    Reac257 = smodel.Reac('Reac257', vsys, lhs = [cGMP_CaM3Ca_PDE1], rhs = [GMP, CaM3Ca_PDE1])
    Reac257.kcst = 15
    
    #cGMP + pPDE1 <-> cGMP_pPDE1 -> GMP + pPDE1
    Reac258 = smodel.Reac('Reac258', vsys, lhs = [cGMP,pPDE1], rhs = [cGMP_pPDE1])
    Reac258.kcst = 0.25e6
    Reac259 = smodel.Reac('Reac259', vsys, lhs = [cGMP_pPDE1], rhs = [cGMP,pPDE1])
    Reac259.kcst = 0.4
    Reac260 = smodel.Reac('Reac260', vsys, lhs = [cGMP_pPDE1], rhs = [GMP, pPDE1])
    Reac260.kcst = 0.1
    
    #cGMP + PDE1 <-> cGMP_PDE1 -> GMP + PDE1
    Reac261 = smodel.Reac('Reac261', vsys, lhs = [cGMP,PDE1], rhs = [cGMP_PDE1])
    Reac261.kcst = 0.25e6
    Reac262 = smodel.Reac('Reac262', vsys, lhs = [cGMP_PDE1], rhs = [cGMP,PDE1])
    Reac262.kcst = 0.4
    Reac263 = smodel.Reac('Reac263', vsys, lhs = [cGMP_PDE1], rhs = [GMP, PDE1])
    Reac263.kcst = 0.1
    
    #cGMP + PDE5 <-> cGMP_PDE5 -> GMP + PDE5
    Reac264 = smodel.Reac('Reac264', vsys, lhs = [cGMP,act_PDE5], rhs = [cGMP_PDE5])
    Reac264.kcst = 7.5e6
    Reac265 = smodel.Reac('Reac265', vsys, lhs = [cGMP_PDE5], rhs = [cGMP,act_PDE5])
    Reac265.kcst = 12
    Reac266 = smodel.Reac('Reac266', vsys, lhs = [cGMP_PDE5], rhs = [GMP, act_PDE5])
    Reac266.kcst = 3
    
    #pPDE1 -> PDE1
    Reac267 = smodel.Reac('Reac267', vsys, lhs = [pPDE1], rhs = [PDE1])
    Reac267.kcst = 0.2
    
    #CaM3Ca_pPDE1 -> CaM3Ca_PDE1
    Reac268 = smodel.Reac('Reac268', vsys, lhs = [CaM3Ca_pPDE1], rhs = [CaM3Ca_PDE1])
    Reac268.kcst = 0.2
    
    #PDE1  <-> PDE1_CaMKII -> pPDE1
    Reac269 = smodel.Reac('Reac269', vsys, lhs = [PDE1,actCaMK], rhs = [PDE1_CaMKII])
    Reac269.kcst = 0.90909090e6
    Reac270 = smodel.Reac('Reac270', vsys, lhs = [PDE1_CaMKII], rhs = [PDE1,actCaMK])
    Reac270.kcst = 8
    Reac271 = smodel.Reac('Reac271', vsys, lhs = [PDE1_CaMKII], rhs = [pPDE1, actCaMK])
    Reac271.kcst = 2
    
    #pPDE1 + CaN <-> pPDE1_CaN -> PDE1 + CaN
    Reac272 = smodel.Reac('Reac272', vsys, lhs = [pPDE1, CaM3CaCaN], rhs = [pPDE1_CaN])
    Reac272.kcst = 1.25e6
    Reac273 = smodel.Reac('Reac273', vsys, lhs = [pPDE1_CaN], rhs = [pPDE1, CaM3CaCaN])
    Reac273.kcst = 2
    Reac274 = smodel.Reac('Reac274', vsys, lhs = [pPDE1_CaN], rhs = [PDE1, CaM3CaCaN])
    Reac274.kcst = 0.5
    
    #CaM3Ca_PDE1 <-> CaM3Ca_PDE1_CaMKII -> CaM3Ca_pPDE1
    Reac275 = smodel.Reac('Reac275', vsys, lhs = [CaM3Ca_PDE1,actCaMK], rhs = [CaM3Ca_PDE1_CaMKII])
    Reac275.kcst = 0.90909090e6
    Reac276 = smodel.Reac('Reac276', vsys, lhs = [CaM3Ca_PDE1_CaMKII], rhs = [CaM3Ca_PDE1, actCaMK])
    Reac276.kcst = 8
    Reac277 = smodel.Reac('Reac277', vsys, lhs = [CaM3Ca_PDE1_CaMKII], rhs = [CaM3Ca_pPDE1, actCaMK])
    Reac277.kcst = 2
    
    #CaM3Ca_pPDE1 + CaN <-> CaM3Ca_pPDE1_CaN -> CaM3Ca_PDE1 + CaN
    Reac278 = smodel.Reac('Reac278', vsys, lhs = [CaM3Ca_pPDE1, CaM3CaCaN], rhs = [CaM3Ca_pPDE1_CaN])
    Reac278.kcst = 1.25e6
    Reac279 = smodel.Reac('Reac279', vsys, lhs = [CaM3Ca_pPDE1_CaN], rhs = [CaM3Ca_pPDE1, CaM3CaCaN])
    Reac279.kcst = 2
    Reac280 = smodel.Reac('Reac280', vsys, lhs = [CaM3Ca_pPDE1_CaN], rhs = [CaM3Ca_PDE1, CaM3CaCaN])
    Reac280.kcst = 0.5
    
    #PDE1 + CaM3Ca <-> CaM3Ca_PDE1
    Reac281 = smodel.Reac('Reac281', vsys, lhs = [PDE1,CaM3Ca], rhs = [CaM3Ca_PDE1])
    Reac281.kcst = 600e6
    Reac282 = smodel.Reac('Reac282', vsys, lhs = [CaM3Ca_PDE1], rhs = [PDE1,CaM3Ca])
    Reac282.kcst = 0.06
    
    #pPDE1 + CaM3Ca <-> CaM3Ca_pPDE1
    Reac283 = smodel.Reac('Reac283', vsys, lhs = [pPDE1,CaM3Ca], rhs = [CaM3Ca_pPDE1])
    Reac283.kcst = 600e6
    Reac284 = smodel.Reac('Reac284', vsys, lhs = [CaM3Ca_pPDE1], rhs = [pPDE1,CaM3Ca])
    Reac284.kcst = 0.36
    
    #PP2A + pG <-> PP2A_pGsub
    Reac285 = smodel.Reac('Reac285', vsys, lhs = [PP2A,pG], rhs = [PP2A_pGsub])
    Reac285.kcst = 10e6
    Reac286 = smodel.Reac('Reac286', vsys, lhs = [PP2A_pGsub], rhs = [PP2A,pG])
    Reac286.kcst = 0.06
    
    #pG -> G_sub
    Reac287 = smodel.Reac('Reac287', vsys, lhs = [pG], rhs = [G_sub])
    Reac287.kcst = 0.2
    
    #pG + PP2A <-> pG_PP2A -> G_sub + PP2A
    Reac288 = smodel.Reac('Reac288', vsys, lhs = [pG,PP2A], rhs = [pG_PP2A])
    Reac288.kcst = 2e6
    Reac289 = smodel.Reac('Reac289', vsys, lhs = [pG_PP2A], rhs = [pG,PP2A])
    Reac289.kcst = 8
    Reac290 = smodel.Reac('Reac290', vsys, lhs = [pG_PP2A], rhs = [G_sub, PP2A])
    Reac290.kcst = 2
    
    #pG + CaM3CaCaN <-> pG_CaM3CaCaN -> G_sub + CaM3CaCaN
    Reac291 = smodel.Reac('Reac291', vsys, lhs = [pG,CaM3CaCaN], rhs = [pG_CaM3CaCaN])
    Reac291.kcst = 1.5625e6
    Reac292 = smodel.Reac('Reac292', vsys, lhs = [pG_CaM3CaCaN], rhs = [pG,CaM3CaCaN])
    Reac292.kcst = 2
    Reac293 = smodel.Reac('Reac293', vsys, lhs = [pG_CaM3CaCaN], rhs = [G_sub, CaM3CaCaN])
    Reac293.kcst = 0.5
    
    #G_sub + PKG_cGMP <-> G_sub_PKG -> pG + PKG
    Reac294 = smodel.Reac('Reac294', vsys, lhs = [G_sub,PKG_cGMP], rhs = [G_sub_PKG])
    Reac294.kcst = 50e6
    Reac295 = smodel.Reac('Reac295', vsys, lhs = [G_sub_PKG], rhs = [G_sub, PKG_cGMP])
    Reac295.kcst = 8
    Reac296 = smodel.Reac('Reac296', vsys, lhs = [G_sub_PKG], rhs = [pG, PKG_cGMP])
    Reac296.kcst = 2
    
    #PDE5 + cGMP + cGMP <-> act_PDE5
    Reac297 = smodel.Reac('Reac297', vsys, lhs= [PDE5,cGMP,cGMP], rhs = [act_PDE5])
    Reac297.kcst = 1e12
    Reac298 = smodel.Reac('Reac298', vsys, lhs = [act_PDE5], rhs = [PDE5, cGMP, cGMP])
    Reac298.kcst = 0.25
    
    #PKG + cGMP + cGMP <-> PKG_cGMP
    Reac299 = smodel.Reac('Reac299', vsys, lhs= [PKG,cGMP,cGMP], rhs = [PKG_cGMP])
    Reac299.kcst = 2e12
    Reac300 = smodel.Reac('Reac300', vsys, lhs = [PKG_cGMP], rhs = [PKG, cGMP, cGMP])
    Reac300.kcst = 0.1
    
    #PP1_DARPP32 + C_actPKA <-> PP1_DARPP32_C_actPKA -> PP1_pDARPP32 + C_actPKA
    Reac301 = smodel.Reac('Reac301', vsys, lhs = [PP1_DARPP32,C_actPKA], rhs = [PP1_DARPP32_C_actPKA])
    Reac301.kcst = 5.625e6
    Reac302 = smodel.Reac('Reac302', vsys, lhs = [PP1_DARPP32_C_actPKA], rhs = [PP1_DARPP32, C_actPKA])
    Reac302.kcst = 10.8
    Reac303 = smodel.Reac('Reac303', vsys, lhs = [PP1_DARPP32_C_actPKA], rhs = [PP1_pDARPP32,C_actPKA])
    Reac303.kcst = 2.7
    
    #PP1_pDARPP32 + CaM3CaCaN <-> PP1_pDARPP32_CaN -> PP1_DARPP32 + CaM3CaCaN
    Reac304 = smodel.Reac('Reac304', vsys, lhs = [PP1_pDARPP32,CaM3CaCaN], rhs = [PP1_pDARPP32_CaN])
    Reac304.kcst = 1.5625e6
    Reac305 = smodel.Reac('Reac305', vsys, lhs = [PP1_pDARPP32_CaN], rhs = [PP1_pDARPP32, CaM3CaCaN])
    Reac305.kcst = 2.0
    Reac306 = smodel.Reac('Reac306', vsys, lhs = [PP1_pDARPP32_CaN], rhs = [PP1_DARPP32,CaM3CaCaN])
    Reac306.kcst = 0.5
    
    #PP1_pDARPP32 + PP2A <-> PP1_pDARPP32_PP2A -> PP1_DARPP32 + PP2A
    Reac307 = smodel.Reac('Reac307', vsys, lhs = [PP1_pDARPP32,PP2A], rhs = [PP1_pDARPP32_PP2A])
    Reac307.kcst = 2e6
    Reac308 = smodel.Reac('Reac308', vsys, lhs = [PP1_pDARPP32_PP2A], rhs = [PP1_pDARPP32, PP2A])
    Reac308.kcst = 8.0
    Reac309 = smodel.Reac('Reac309', vsys, lhs = [PP1_pDARPP32_PP2A], rhs = [PP1_DARPP32,PP2A])
    Reac309.kcst = 2.0
    
    #DARPP32 + C_actPKA <-> DARPP32_C_actPKA -> pDARPP32 + C_actPKA
    Reac310 = smodel.Reac('Reac310', vsys, lhs = [DARPP32,C_actPKA], rhs = [DARPP32_C_actPKA])
    Reac310.kcst = 5.625e6
    Reac311 = smodel.Reac('Reac311', vsys, lhs = [DARPP32_C_actPKA], rhs = [DARPP32, C_actPKA])
    Reac311.kcst = 10.8
    Reac312 = smodel.Reac('Reac312', vsys, lhs = [DARPP32_C_actPKA], rhs = [pDARPP32,C_actPKA])
    Reac312.kcst = 2.7
    
    #pDARPP32 + CaM3CaCaN <-> pDARPP32_CaN -> DARPP32 + CaM3CaCaN
    Reac313 = smodel.Reac('Reac313', vsys, lhs = [pDARPP32,CaM3CaCaN], rhs = [pDARPP32_CaN])
    Reac313.kcst = 1.5625e6
    Reac314 = smodel.Reac('Reac314', vsys, lhs = [pDARPP32_CaN], rhs = [pDARPP32, CaM3CaCaN])
    Reac314.kcst = 2.0
    Reac315 = smodel.Reac('Reac315', vsys, lhs = [pDARPP32_CaN], rhs = [DARPP32,CaM3CaCaN])
    Reac315.kcst = 0.5
    
    #pDARPP32 + PP2A <-> pDARPP32_PP2A -> DARPP32 + PP2A
    Reac316 = smodel.Reac('Reac316', vsys, lhs = [pDARPP32,PP2A], rhs = [pDARPP32_PP2A])
    Reac316.kcst = 2.0e6
    Reac317 = smodel.Reac('Reac317', vsys, lhs = [pDARPP32_PP2A], rhs = [pDARPP32, PP2A])
    Reac317.kcst = 8.0
    Reac318 = smodel.Reac('Reac318', vsys, lhs = [pDARPP32_PP2A], rhs = [DARPP32,PP2A])
    Reac318.kcst = 2.0
    
    #PP1 + DARPP32 <-> PP1_DARPP32
    Reac319 = smodel.Reac('Reac319', vsys, lhs = [PP1, DARPP32], rhs = [ PP1_DARPP32])
    Reac319.kcst = 0.5e6
    Reac320 = smodel.Reac('Reac320', vsys, lhs = [PP1_DARPP32], rhs = [PP1, DARPP32])
    Reac320.kcst = 0.5
    
    #PP1 + pDARPP32 <-> PP1_pDARPP32
    Reac321 = smodel.Reac('Reac321', vsys, lhs = [PP1, pDARPP32], rhs = [ PP1_pDARPP32])
    Reac321.kcst = 500e6
    Reac322 = smodel.Reac('Reac322', vsys, lhs = [PP1_pDARPP32], rhs = [PP1, pDARPP32])
    Reac322.kcst = 0.5
    
    #R2C2_PKA + cAMP <-> cAMP_R2C2
    Reac323 = smodel.Reac('Reac323', vsys, lhs = [R2C2_PKA,cAMP], rhs = [cAMP_R2C2])
    Reac323.kcst = 2e6
    Reac324 = smodel.Reac('Reac324', vsys, lhs = [cAMP_R2C2], rhs = [R2C2_PKA,cAMP])
    Reac324.kcst = 0.75
    
    #cAMP_R2C2 + cAMP <-> cAMP2_bb_R2C2
    Reac325 = smodel.Reac('Reac325', vsys, lhs = [cAMP_R2C2,cAMP], rhs = [cAMP2_bb_R2C2])
    Reac325.kcst = 1e6
    Reac326 = smodel.Reac('Reac326', vsys, lhs = [cAMP2_bb_R2C2], rhs = [cAMP_R2C2,cAMP])
    Reac326.kcst = 1.5
    
    #cAMP_R2C2 + cAMP <-> cAMP2_ab_R2C2
    Reac327 = smodel.Reac('Reac327', vsys, lhs = [cAMP_R2C2,cAMP], rhs = [cAMP2_ab_R2C2])
    Reac327.kcst = 10e6
    Reac328 = smodel.Reac('Reac328', vsys, lhs = [cAMP2_ab_R2C2], rhs = [cAMP_R2C2,cAMP])
    Reac328.kcst = 7.5
    
    #cAMP2_bb_R2C2 + cAMP <-> cAMP3_R2C2
    Reac329 = smodel.Reac('Reac329', vsys, lhs = [cAMP2_bb_R2C2, cAMP], rhs = [cAMP3_R2C2])
    Reac329.kcst = 20e6
    Reac330 = smodel.Reac('Reac330', vsys, lhs = [cAMP3_R2C2], rhs = [cAMP2_bb_R2C2, cAMP])
    Reac330.kcst = 7.5
    
    
    #cAMP2_ab_R2C2 + cAMP <-> cAMP3_R2C2
    Reac331 = smodel.Reac('Reac331', vsys, lhs = [cAMP2_ab_R2C2, cAMP], rhs = [cAMP3_R2C2])
    Reac331.kcst = 1.0e6
    Reac332 = smodel.Reac('Reac332', vsys, lhs = [cAMP3_R2C2], rhs = [cAMP2_ab_R2C2, cAMP])
    Reac332.kcst = 0.75
    
    #cAMP3_R2C2 + cAMP <-> cAMP4_R2C2
    Reac333 = smodel.Reac('Reac333', vsys, lhs = [cAMP3_R2C2, cAMP], rhs = [cAMP4_R2C2])
    Reac333.kcst = 10e6
    Reac334 = smodel.Reac('Reac334', vsys, lhs = [cAMP4_R2C2], rhs = [cAMP3_R2C2,cAMP])
    Reac324.kcst = 15
    
    #cAMP2_ab_R2C2  <-> cAMP2_ab_R2C + C_actPKA
    Reac335 = smodel.Reac('Reac335', vsys, lhs = [cAMP2_ab_R2C2], rhs = [cAMP2_ab_R2C, C_actPKA])
    Reac335.kcst = 0.005
    Reac336 = smodel.Reac('Reac336', vsys, lhs = [cAMP2_ab_R2C, C_actPKA], rhs = [cAMP2_ab_R2C2])
    Reac336.kcst = 5e6
    
    #cAMP3_R2C2  <-> cAMP3_R2C + C_actPKA
    Reac337 = smodel.Reac('Reac337', vsys, lhs = [cAMP3_R2C2], rhs = [cAMP3_R2C, C_actPKA])
    Reac337.kcst = 0.005
    Reac338 = smodel.Reac('Reac338', vsys, lhs = [cAMP3_R2C, C_actPKA], rhs = [cAMP3_R2C2])
    Reac338.kcst = 5e6
    
    #cAMP4_R2C2  <-> cAMP4_R2C + C_actPKA
    Reac339 = smodel.Reac('Reac339', vsys, lhs = [cAMP4_R2C2], rhs = [cAMP4_R2C, C_actPKA])
    Reac339.kcst = 6
    Reac340 = smodel.Reac('Reac340', vsys, lhs = [cAMP4_R2C, C_actPKA], rhs = [cAMP4_R2C2])
    Reac340.kcst = 5e6
    
    #cAMP4_R2C  <-> cAMP4_R2 + C_actPKA
    Reac341 = smodel.Reac('Reac341', vsys, lhs = [cAMP4_R2C], rhs = [cAMP4_R2, C_actPKA])
    Reac341.kcst = 3
    Reac342 = smodel.Reac('Reac342', vsys, lhs = [cAMP4_R2, C_actPKA], rhs = [cAMP4_R2C])
    Reac342.kcst = 10e6
    
    #cAMP2_ab_R2C + cAMP <-> cAMP3_R2C
    Reac343 = smodel.Reac('Reac343', vsys, lhs = [cAMP2_ab_R2C, cAMP], rhs = [cAMP3_R2C])
    Reac343.kcst = 1.0e6
    Reac344 = smodel.Reac('Reac344', vsys, lhs = [cAMP3_R2C], rhs = [cAMP2_ab_R2C, cAMP])
    Reac344.kcst =  0.75
    
    #cAMP3_R2C + cAMP <-> cAMP4_R2C
    Reac345 = smodel.Reac('Reac345', vsys, lhs = [cAMP3_R2C, cAMP], rhs = [cAMP4_R2C])
    Reac345.kcst = 10e6
    Reac346 = smodel.Reac('Reac346', vsys, lhs = [cAMP4_R2C], rhs = [cAMP3_R2C,cAMP])
    Reac346.kcst = 7.5
    
    #cAMP + PDE4 <-> cAMP_PDE4 <-> AMP + PDE4
    Reac347 = smodel.Reac('Reac347',vsys, lhs = [cAMP,PDE4], rhs = [cAMP_PDE4])
    Reac347.kcst = 0.125e6
    Reac348 = smodel.Reac('Reac348',vsys, lhs = [cAMP_PDE4], rhs = [cAMP,PDE4])
    Reac348.kcst = 0.2
    Reac349 = smodel.Reac('Reac349',vsys, lhs = [cAMP_PDE4], rhs = [AMP,PDE4])
    Reac349.kcst = 0.05
    
    #cAMP + CaM3Ca_pPDE1 <-> cAMP_CaM3Ca_pPDE1 <-> AMP + CaM3Ca_pPDE1
    Reac350 = smodel.Reac('Reac350',vsys, lhs = [cAMP,CaM3Ca_pPDE1], rhs = [cAMP_CaM3Ca_pPDE1])
    Reac350.kcst = 2.0833e6
    Reac351 = smodel.Reac('Reac351',vsys, lhs = [cAMP_CaM3Ca_pPDE1], rhs = [cAMP,CaM3Ca_pPDE1])
    Reac351.kcst = 20
    Reac352 = smodel.Reac('Reac352',vsys, lhs = [cAMP_CaM3Ca_pPDE1], rhs = [AMP,CaM3Ca_pPDE1])
    Reac352.kcst = 5
    
    #cAMP + CaM3Ca_PDE1 <-> cAMP_CaM3Ca_PDE1 <-> AMP + CaM3Ca_PDE1
    Reac353 = smodel.Reac('Reac353',vsys, lhs = [cAMP,CaM3Ca_PDE1], rhs = [cAMP_CaM3Ca_PDE1])
    Reac353.kcst = 2.0833e6
    Reac354 = smodel.Reac('Reac354',vsys, lhs = [cAMP_CaM3Ca_PDE1], rhs = [cAMP,CaM3Ca_PDE1])
    Reac354.kcst = 20
    Reac355 = smodel.Reac('Reac355',vsys, lhs = [cAMP_CaM3Ca_PDE1], rhs = [AMP,CaM3Ca_PDE1])
    Reac355.kcst = 5
    
    #cAMP + pPDE1 <-> cAMP_pPDE1 <-> AMP + pPDE1
    Reac356 = smodel.Reac('Reac356',vsys, lhs = [cAMP,pPDE1], rhs = [cAMP_pPDE1])
    Reac356.kcst = 0.0416e6
    Reac357 = smodel.Reac('Reac357',vsys, lhs = [cAMP_pPDE1], rhs = [cAMP,pPDE1])
    Reac357.kcst = 0.4
    Reac358 = smodel.Reac('Reac358',vsys, lhs = [cAMP_pPDE1], rhs = [AMP,pPDE1])
    Reac358.kcst = 0.1
    
    #cAMP + PDE1 <-> cAMP_PDE1 <-> AMP + PDE1
    Reac359 = smodel.Reac('Reac359',vsys, lhs = [cAMP,PDE1], rhs = [cAMP_PDE1])
    Reac359.kcst = 0.0416e6
    Reac360 = smodel.Reac('Reac360',vsys, lhs = [cAMP_PDE1], rhs = [cAMP,PDE1])
    Reac360.kcst = 0.4
    Reac361 = smodel.Reac('Reac361',vsys, lhs = [cAMP_PDE1], rhs = [AMP,PDE1])
    Reac361.kcst = 0.1
    
    ####CaMKII activation reactions
    
    # CaMKII_s1_s2_s3_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2_s3_s4   #activation of CaMKII by CaM of s1
    Reac362 = smodel.Reac('Reac362', vsys, lhs = [CaMKII_s1_s2_s3_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4])
    Reac362.kcst = kon_cam
    Reac363 = smodel.Reac('Reac363', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4], rhs = [CaMKII_s1_s2_s3_s4, CaM3Ca])
    Reac363.kcst = koff_cam
    
    # CaMKII_s1_s2_s3_s4 + CaM3Ca <-> CaMKII_s1_s2CaM3Ca_s3_s4   #activation of CaMKII by CaM of s2
    Reac364 = smodel.Reac('Reac364', vsys, lhs = [CaMKII_s1_s2_s3_s4, CaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3_s4])
    Reac364.kcst = kon_cam
    Reac365 = smodel.Reac('Reac365', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1_s2_s3_s4, CaM3Ca])
    Reac365.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2_s3_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4   #activation of CaMKII by CaM of s1 and s2
    Reac366 = smodel.Reac('Reac366', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4])
    Reac366.kcst = kon_cam
    Reac367 = smodel.Reac('Reac367', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4, CaM3Ca])
    Reac367.kcst = koff_cam
    
    # CaMKII_s1_s2CaM3Ca_s3_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4   #activation of CaMKII by CaM of s1 and s2
    Reac368 = smodel.Reac('Reac368', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4])
    Reac368.kcst = kon_cam
    Reac369 = smodel.Reac('Reac369', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3_s4, CaM3Ca])
    Reac369.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4 -> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4   #phosphorylation of CaMKII s1 at T286
    Reac370 = smodel.Reac('Reac370', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4])
    Reac370.kcst = k_t286
    
    # CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4 -> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4   #phosphorylation of CaMKII s2 at T286
    Reac371 = smodel.Reac('Reac371', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4])
    Reac371.kcst = k_t286
    
    # CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4 -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4 #autophosphorylation at Thr286 of s1 and s2
    Reac372 = smodel.Reac('Reac372', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4])
    Reac372.kcst = k_t286
    
    # CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4 -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4 #autophosphorylation at Thr286 of s1 and s2
    Reac373 = smodel.Reac('Reac373', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4])
    Reac373.kcst = k_t286
    
    # CaMKII_s1p_s2CaM3Ca_s3_s4 + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4   #dissociation of CaM, autophosphorylation withouth CaM
    Reac374 = smodel.Reac('Reac374', vsys, lhs = [CaMKII_s1p_s2CaM3Ca_s3_s4, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4])
    Reac374.kcst = kon_cam_t286
    Reac375 = smodel.Reac('Reac375', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1p_s2CaM3Ca_s3_s4, CaM3Ca])
    Reac375.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2_s3_s4 + CaM3Ca <-> CaMKII_s1p_s2CaM3Ca_s3_s4   #dissociation of CaM
    Reac376 = smodel.Reac('Reac376', vsys, lhs = [CaMKII_s1p_s2_s3_s4, CaM3Ca], rhs = [CaMKII_s1p_s2CaM3Ca_s3_s4])
    Reac376.kcst = kon_cam
    Reac377 = smodel.Reac('Reac377', vsys, lhs = [CaMKII_s1p_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1p_s2_s3_s4, CaM3Ca])
    Reac377.kcst = koff_cam
    
    # CaMKII_s1_s2p_s3_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2p_s3_s4   #dissociation of CaM
    Reac378 = smodel.Reac('Reac378', vsys, lhs = [CaMKII_s1_s2p_s3_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2p_s3_s4])
    Reac378.kcst = kon_cam
    Reac379 = smodel.Reac('Reac379', vsys, lhs = [CaMKII_s1CaM3Ca_s2p_s3_s4], rhs = [CaMKII_s1_s2p_s3_s4, CaM3Ca])
    Reac379.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2p_s3_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4  #dissociation of CaM, autophosphorylation withouth CaM
    Reac380 = smodel.Reac('Reac380', vsys, lhs = [CaMKII_s1CaM3Ca_s2p_s3_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4])
    Reac380.kcst = kon_cam_t286
    Reac381 = smodel.Reac('Reac381', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2p_s3_s4, CaM3Ca])
    Reac381.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3_s4 + CaM3Ca <-> CaMKII_s1p_s2pCaM3Ca_s3_s4   #dissociation of CaM, autophosphorylation withouth CaM
    Reac382 = smodel.Reac('Reac382', vsys, lhs = [CaMKII_s1p_s2p_s3_s4, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4])
    Reac382.kcst = kon_cam_t286
    Reac383 = smodel.Reac('Reac383', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1p_s2p_s3_s4, CaM3Ca])
    Reac383.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3_s4 + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca  #dissociation of CaM, autophosphorylation withouth CaM
    Reac384 = smodel.Reac('Reac384', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4])
    Reac384.kcst = kon_cam_t286
    Reac385 = smodel.Reac('Reac385', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4, CaM3Ca])
    Reac385.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3_s4 + CaM3Ca <-> CaMKII_s1pCaM3Ca _s2p_s3_s4  #dissociation of CaM, autophosphorylation withouth CaM
    Reac386 = smodel.Reac('Reac386', vsys, lhs = [CaMKII_s1p_s2p_s3_s4, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4])
    Reac386.kcst = kon_cam_t286
    Reac387 = smodel.Reac('Reac387', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4], rhs = [CaMKII_s1p_s2p_s3_s4, CaM3Ca])
    Reac387.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3_s4 + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4  #dissociation of CaM, autophosphorylation withouth CaM
    Reac388 = smodel.Reac('Reac388', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4])
    Reac388.kcst = kon_cam_t286
    Reac389 = smodel.Reac('Reac389', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4, CaM3Ca])
    Reac389.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2CaM3Ca_s3_s4 -> CaMKII_s1pp_s2CaM3Ca_s3_s4 #autophosphorylation at Thr305 of s1 and s2
    Reac390 = smodel.Reac('Reac390', vsys, lhs = [CaMKII_s1p_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1pp_s2CaM3Ca_s3_s4])
    Reac390.kcst = k_t350
    
    # CaMKII_s1pp_s2_s3_s4 + CaM3Ca <-> CaMKII_s1pp_s2CaM3Ca_s3_s4  #dissociation of CaM to autophosphorylation at s1_T305
    Reac391 = smodel.Reac('Reac391', vsys, lhs = [CaMKII_s1pp_s2_s3_s4, CaM3Ca], rhs = [CaMKII_s1pp_s2CaM3Ca_s3_s4])
    Reac391.kcst = kon_cam
    Reac392 = smodel.Reac('Reac392', vsys, lhs = [CaMKII_s1pp_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1pp_s2_s3_s4, CaM3Ca])
    Reac392.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2p_s3_s4 -> CaMKII_s1CaM3Ca_s2pp_s3_s4 #autophosphorylation at Thr305 of s1 and s2
    Reac393 = smodel.Reac('Reac393', vsys, lhs = [CaMKII_s1CaM3Ca_s2p_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2pp_s3_s4])
    Reac393.kcst = k_t350
    
    # CaMKII_s1_s2pp_s3_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2pp_s3_s4  #dissociation of CaM to autophosphorylation at s1_T305
    Reac394 = smodel.Reac('Reac394', vsys, lhs = [CaMKII_s1_s2pp_s3_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pp_s3_s4])
    Reac394.kcst = kon_cam
    Reac395 = smodel.Reac('Reac395', vsys, lhs = [CaMKII_s1CaM3Ca_s2pp_s3_s4], rhs = [CaMKII_s1_s2pp_s3_s4, CaM3Ca])
    Reac395.kcst = koff_cam
    
    
    # CaMKII_s1p_s2p_s3_s4 -> CaMKII_s1pp_s2p_s3_s4 #autophosphorylation at Thr305
    Reac396 = smodel.Reac('Reac396', vsys, lhs = [CaMKII_s1p_s2p_s3_s4], rhs = [CaMKII_s1pp_s2p_s3_s4])
    Reac396.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3_s4 -> CaMKII_s1pp_s2pp #autophosphorylation at Thr305
    Reac397 = smodel.Reac('Reac397', vsys, lhs = [CaMKII_s1pp_s2p_s3_s4], rhs = [CaMKII_s1pp_s2pp_s3_s4])
    Reac397.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3_s4 -> CaMKII_s1p_s2pp #autophosphorylation at Thr305
    Reac398 = smodel.Reac('Reac398', vsys, lhs = [CaMKII_s1p_s2p_s3_s4], rhs = [CaMKII_s1p_s2pp_s3_s4])
    Reac398.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3_s4 -> CaMKII_s1pp_s2pp #autophosphorylation at Thr305
    Reac399 = smodel.Reac('Reac399', vsys, lhs = [CaMKII_s1p_s2pp_s3_s4], rhs = [CaMKII_s1pp_s2pp_s3_s4])
    Reac399.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3_s4 + CaM3Ca <-> CaMKII_s1pp_s2pCaM3Ca_s3_s4   #dissociation of CaM, autophosphorylation withouth CaM
    Reac400 = smodel.Reac('Reac400', vsys, lhs = [CaMKII_s1pp_s2p_s3_s4, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4])
    Reac400.kcst = kon_cam_t286
    Reac401 = smodel.Reac('Reac401', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1pp_s2p_s3_s4, CaM3Ca])
    Reac401.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3_s4 + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pp_s3_s4   #dissociation of CaM, autophosphorylation withouth CaM
    Reac402 = smodel.Reac('Reac402', vsys, lhs = [CaMKII_s1p_s2pp_s3_s4, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4])
    Reac402.kcst = kon_cam_t286
    Reac403 = smodel.Reac('Reac403', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4], rhs = [CaMKII_s1p_s2pp_s3_s4, CaM3Ca])
    Reac403.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2_s3_s4 <-> CaMKII_s1pCaM3Ca_s2_s3_s4   #dissociation of CaM, autophosphorylation withouth CaM
    Reac404 = smodel.Reac('Reac404', vsys, lhs = [CaMKII_s1p_s2_s3_s4, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4])
    Reac404.kcst = kon_cam_t286
    Reac405 = smodel.Reac('Reac405', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4], rhs = [CaMKII_s1p_s2_s3_s4, CaM3Ca])
    Reac405.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3_s4 + CaM3Ca <-> CaMKII_s1_s2pCaM3Ca_s3_s4   #dissociation of CaM, autophosphorylation withouth CaM
    Reac406 = smodel.Reac('Reac406', vsys, lhs = [CaMKII_s1_s2p_s3_s4, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3_s4])
    Reac406.kcst = kon_cam_t286
    Reac407 = smodel.Reac('Reac407', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1_s2p_s3_s4, CaM3Ca])
    Reac407.kcst = koff_cam_t286
    
    ###dephosphorylation of CaMKII by PP1
    
    # CaMK_s1pCaM3Ca_s2CaM3Ca_s3_s4 + PP1 <-> CaMK_s1pCaM3CaPP1_s2CaM3Ca_s3_s4-> CaMK_s1CaM3Ca_s2CaM3Ca_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac408 = smodel.Reac('Reac408', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2CaM3Ca_s3_s4])
    Reac408.kcst = 3.3333e6
    Reac409 = smodel.Reac('Reac409', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2CaM3Ca_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4, PP1])
    Reac409.kcst = 8
    Reac410 = smodel.Reac('Reac410', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4, PP1])
    Reac410.kcst = 2
    
    # CaMK_s1CaM3Ca_s2pCaM3Ca_s3_s4 + PP1 <-> CaMK_s1CaM3Ca_s2pCaM3CaPP1_s3_s4-> CaMK_s1CaM3Ca_s2CaM3Ca_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac411 = smodel.Reac('Reac411', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4, PP1], rhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP1_s3_s4])
    Reac411.kcst = 3.3333e6
    Reac412 = smodel.Reac('Reac412', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP1_s3_s4], rhs =[CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4, PP1])
    Reac412.kcst = 8
    Reac413 = smodel.Reac('Reac413', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP1_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4, PP1])
    Reac413.kcst = 2
    
    # CaMK_s1p_s2CaM3Ca_s3_s4 + PP1 <-> CaMK_s1pPP1_s2CaM3Ca_s3_s4-> CaMK_s1_s2CaM3Ca_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac414 = smodel.Reac('Reac414', vsys, lhs = [CaMKII_s1p_s2CaM3Ca_s3_s4, PP1], rhs = [CaMKII_s1pPP1_s2CaM3Ca_s3_s4])
    Reac414.kcst = 3.3333e6
    Reac415 = smodel.Reac('Reac415', vsys, lhs = [CaMKII_s1pPP1_s2CaM3Ca_s3_s4], rhs =[CaMKII_s1p_s2CaM3Ca_s3_s4, PP1])
    Reac415.kcst = 8
    Reac416 = smodel.Reac('Reac416', vsys, lhs = [CaMKII_s1pPP1_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3_s4, PP1])
    Reac416.kcst = 2
    
    # CaMK_s1CaM3Ca_s2p_s3_s4 + PP1 <-> CaMK_s1CaM3Ca_s2pPP1_s3_s4-> CaMK_s1CaM3Ca_s2_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac417 = smodel.Reac('Reac417', vsys, lhs = [CaMKII_s1CaM3Ca_s2p_s3_s4, PP1], rhs = [CaMKII_s1CaM3Ca_s2pPP1_s3_s4])
    Reac417.kcst = 3.3333e6
    Reac418 = smodel.Reac('Reac418', vsys, lhs = [CaMKII_s1CaM3Ca_s2pPP1_s3_s4], rhs =[CaMKII_s1CaM3Ca_s2p_s3_s4, PP1])
    Reac418.kcst = 8
    Reac419 = smodel.Reac('Reac419', vsys, lhs = [CaMKII_s1CaM3Ca_s2pPP1_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4, PP1])
    Reac419.kcst = 2
    
    # CaMK_s1p_s2_s3_s4 + PP1 <-> CaMK_s1pPP1_s2_s3_s4-> CaMK_s1_s2_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac420 = smodel.Reac('Reac420', vsys, lhs = [CaMKII_s1p_s2_s3_s4, PP1], rhs = [CaMKII_s1pPP1_s2_s3_s4])
    Reac420.kcst = 3.3333e6
    Reac421 = smodel.Reac('Reac421', vsys, lhs = [CaMKII_s1pPP1_s2_s3_s4], rhs =[CaMKII_s1p_s2_s3_s4, PP1])
    Reac421.kcst = 8
    Reac422 = smodel.Reac('Reac422', vsys, lhs = [CaMKII_s1pPP1_s2_s3_s4], rhs = [CaMKII_s1_s2_s3_s4, PP1])
    Reac422.kcst = 2
    
    # CaMK_s1pCaM3Ca_s2pCaM3Ca_s3_s4 + PP1 <-> CaMK_s1pCaM3CaPP1_s2pCaM3Ca_s3_s4-> CaMK_s1CaM3Ca_s2pCaM3Ca_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac423 = smodel.Reac('Reac423', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3_s4])
    Reac423.kcst = 3.3333e6
    Reac424 = smodel.Reac('Reac424', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, PP1])
    Reac424.kcst = 8
    Reac425 = smodel.Reac('Reac425', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4, PP1])
    Reac425.kcst = 2
    
    # CaMK_s1pCaM3Ca_s2pCaM3Ca_s3_s4 + PP1 <-> CaMK_s1pCaM3Ca_s2pCaM3CaPP1_s3_s4-> CaMK_s1pCaM3Ca_s2CaM3Ca_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac426 = smodel.Reac('Reac426', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3_s4])
    Reac426.kcst = 3.3333e6
    Reac427 = smodel.Reac('Reac427', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, PP1])
    Reac427.kcst = 8
    Reac428 = smodel.Reac('Reac428', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3_s4], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4, PP1])
    Reac428.kcst = 2
    
    # CaMK_s1_s2p_s3_s4 + PP1 <-> CaMK_s1_s2pPP1_s3_s4 -> CaMK_s1_s2_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac429 = smodel.Reac('Reac429', vsys, lhs = [CaMKII_s1_s2p_s3_s4, PP1], rhs = [CaMKII_s1_s2pPP1_s3_s4])
    Reac429.kcst = 3.3333e6
    Reac430 = smodel.Reac('Reac430', vsys, lhs = [CaMKII_s1_s2pPP1_s3_s4], rhs =[CaMKII_s1_s2p_s3_s4, PP1])
    Reac430.kcst = 8
    Reac431 = smodel.Reac('Reac431', vsys, lhs = [CaMKII_s1_s2pPP1_s3_s4], rhs = [CaMKII_s1_s2_s3_s4, PP1])
    Reac431.kcst = 2
    
    # CaMK_s1p_s2pCaM3Ca_s3_s4 + PP1 <-> CaMK_s1pPP1_s2pCaM3Ca_s3_s4-> CaMK_s1_s2CaM3Ca_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac432 = smodel.Reac('Reac432', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4, PP1], rhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3_s4])
    Reac432.kcst = 3.3333e6
    Reac433 = smodel.Reac('Reac433', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3_s4], rhs =[CaMKII_s1p_s2pCaM3Ca_s3_s4, PP1])
    Reac433.kcst = 8
    Reac434 = smodel.Reac('Reac434', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1_s2pCaM3Ca_s3_s4, PP1])
    Reac434.kcst = 2
    
    # CaMK_s1p_s2pCaM3Ca_s3_s4 + PP1 <-> CaMK_s1p_s2pCaM3CaPP1_s3_s4-> CaMK_s1p_s2CaM3Ca_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac435 = smodel.Reac('Reac435', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4, PP1], rhs = [CaMKII_s1p_s2pCaM3CaPP1_s3_s4])
    Reac435.kcst = 3.3333e6
    Reac436 = smodel.Reac('Reac436', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3_s4], rhs =[CaMKII_s1p_s2pCaM3Ca_s3_s4, PP1])
    Reac436.kcst = 8
    Reac437 = smodel.Reac('Reac437', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3_s4], rhs = [CaMKII_s1p_s2CaM3Ca_s3_s4, PP1])
    Reac437.kcst = 2
    
    # CaMK_s1pCaM3Ca_s2p + PP1 <-> CaMK_s1pCaM3CaPP1_s2p-> CaMK_s1CaM3Ca_s2p + PP1 #dephosphorylation at T286/CaM
    Reac438 = smodel.Reac('Reac438', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2p_s3_s4])
    Reac438.kcst = 3.3333e6
    Reac439 = smodel.Reac('Reac439', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2p_s3_s4, PP1])
    Reac439.kcst = 8
    Reac440 = smodel.Reac('Reac440', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2p_s3_s4, PP1])
    Reac440.kcst = 2
    
    # CaMK_s1pCaM3Ca_s2p_s3_s4 + PP1 <-> CaMK_s1pCaM3Ca_s2pPP1_s3_s4-> CaMK_s1pCaM3Ca_s2_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac441 = smodel.Reac('Reac441', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3_s4])
    Reac441.kcst = 3.3333e6
    Reac442 = smodel.Reac('Reac442', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2p_s3_s4, PP1])
    Reac442.kcst = 8
    Reac443 = smodel.Reac('Reac443', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3_s4], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4, PP1])
    Reac443.kcst = 2
    
    # CaMK_s1p_s2p_s3_s4 + PP1 <-> CaMK_s1pPP1_s2p_s3_s4 -> CaMK_s1_s2p_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac444 = smodel.Reac('Reac444', vsys, lhs = [CaMKII_s1p_s2p_s3_s4, PP1], rhs = [CaMKII_s1pPP1_s2p_s3_s4])
    Reac444.kcst = 3.3333e6
    Reac445 = smodel.Reac('Reac445', vsys, lhs = [CaMKII_s1pPP1_s2p_s3_s4], rhs =[CaMKII_s1p_s2p_s3_s4, PP1])
    Reac445.kcst = 8
    Reac446 = smodel.Reac('Reac446', vsys, lhs = [CaMKII_s1pPP1_s2p_s3_s4], rhs = [CaMKII_s1_s2p_s3_s4, PP1])
    Reac446.kcst = 2
    
    # CaMK_s1p_s2p_s3_s4 + PP1 <-> CaMK_s1p_s2pPP1_s3_s4 -> CaMK_s1p_s2_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac447 = smodel.Reac('Reac447', vsys, lhs = [CaMKII_s1p_s2p_s3_s4, PP1], rhs = [CaMKII_s1p_s2pPP1_s3_s4])
    Reac447.kcst = 3.3333e6
    Reac448 = smodel.Reac('Reac448', vsys, lhs = [CaMKII_s1p_s2pPP1_s3_s4], rhs =[CaMKII_s1p_s2p_s3_s4, PP1])
    Reac448.kcst = 8
    Reac449 = smodel.Reac('Reac449', vsys, lhs = [CaMKII_s1p_s2pPP1_s3_s4], rhs = [CaMKII_s1p_s2_s3_s4, PP1])
    Reac449.kcst = 2
    
    # CaMK_s1_s2pCaM3Ca_s3_s4 + PP1 <-> CaMK_s1_s2pCaM3CaPP1_s3_s4-> CaMK_s1_s2CaM3Ca_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac450 = smodel.Reac('Reac450', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3_s4, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3_s4])
    Reac450.kcst = 3.3333e6
    Reac451 = smodel.Reac('Reac451', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3_s4], rhs =[CaMKII_s1_s2pCaM3Ca_s3_s4, PP1])
    Reac451.kcst = 8
    Reac452 = smodel.Reac('Reac452', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3_s4, PP1])
    Reac452.kcst = 2
    
    # CaMK_s1pCaM3Ca_s2_s3_s4 + PP1 <-> CaMK_s1pCaM3CaPP1_s2_s3_s4-> CaMK_s1CaM3Ca_s2_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac453 = smodel.Reac('Reac453', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2_s3_s4])
    Reac453.kcst = 3.3333e6
    Reac454 = smodel.Reac('Reac454', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2_s3_s4, PP1])
    Reac454.kcst = 8
    Reac455 = smodel.Reac('Reac455', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4, PP1])
    Reac455.kcst = 2
    
    # CaMK_s1pp_s2_s3_s4 + PP1 <-> CaMK_s1ppPP1_s2_s3_s4 -> CaMK_s1p_s2_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac456 = smodel.Reac('Reac456', vsys, lhs = [CaMKII_s1pp_s2_s3_s4, PP1], rhs = [CaMKII_s1ppPP1_s2_s3_s4])
    Reac456.kcst = 3.3333e6
    Reac457 = smodel.Reac('Reac457', vsys, lhs = [CaMKII_s1ppPP1_s2_s3_s4], rhs =[CaMKII_s1pp_s2_s3_s4, PP1])
    Reac457.kcst = 8
    Reac458 = smodel.Reac('Reac458', vsys, lhs = [CaMKII_s1ppPP1_s2_s3_s4], rhs = [CaMKII_s1p_s2_s3_s4, PP1])
    Reac458.kcst = 2
    
    # CaMK_s1_s2pp_s3_s4 + PP1 <-> CaMK_s1_s2ppPP1_s3_s4 -> CaMK_s1_s2p_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac459 = smodel.Reac('Reac459', vsys, lhs = [CaMKII_s1_s2pp_s3_s4, PP1], rhs = [CaMKII_s1_s2ppPP1_s3_s4])
    Reac459.kcst = 3.3333e6
    Reac460 = smodel.Reac('Reac460', vsys, lhs = [CaMKII_s1_s2ppPP1_s3_s4], rhs =[CaMKII_s1_s2pp_s3_s4, PP1])
    Reac460.kcst = 8
    Reac461 = smodel.Reac('Reac461', vsys, lhs = [CaMKII_s1_s2ppPP1_s3_s4], rhs = [CaMKII_s1_s2p_s3_s4, PP1])
    Reac461.kcst = 2
    
    # CaMK_s1pp_s2p_s3_s4 + PP1 <-> CaMK_s1ppPP1_s2p_s3_s4 -> CaMK_s1p_s2p_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac462 = smodel.Reac('Reac462', vsys, lhs = [CaMKII_s1pp_s2p_s3_s4, PP1], rhs = [CaMKII_s1ppPP1_s2p_s3_s4])
    Reac462.kcst = 3.3333e6
    Reac463 = smodel.Reac('Reac463', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3_s4], rhs =[CaMKII_s1pp_s2p_s3_s4, PP1])
    Reac463.kcst = 8
    Reac464 = smodel.Reac('Reac464', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3_s4], rhs = [CaMKII_s1p_s2p_s3_s4, PP1])
    Reac464.kcst = 2
    
    
    # CaMK_s1pp_s2p_s3_s4 + PP1 <-> CaMK_s1pp_s2pPP1_s3_s4 -> CaMK_s1pp_s2_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac465 = smodel.Reac('Reac465', vsys, lhs = [CaMKII_s1pp_s2p_s3_s4, PP1], rhs = [CaMKII_s1pp_s2pPP1_s3_s4])
    Reac465.kcst = 3.3333e6
    Reac466 = smodel.Reac('Reac466', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3_s4], rhs =[CaMKII_s1pp_s2p_s3_s4, PP1])
    Reac466.kcst = 8
    Reac467 = smodel.Reac('Reac467', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3_s4], rhs = [CaMKII_s1pp_s2_s3_s4, PP1])
    Reac467.kcst = 2
    
    
    # CaMK_s1p_s2pp_s3_s4 + PP1 <-> CaMK_s1pPP1_s2pp_s3_s4 -> CaMK_s1pPP1_s2pp_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac468 = smodel.Reac('Reac468', vsys, lhs = [CaMKII_s1p_s2pp_s3_s4, PP1], rhs = [CaMKII_s1pPP1_s2pp_s3_s4])
    Reac468.kcst = 3.3333e6
    Reac469 = smodel.Reac('Reac469', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3_s4], rhs =[CaMKII_s1p_s2pp_s3_s4, PP1])
    Reac469.kcst = 8
    Reac470 = smodel.Reac('Reac470', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3_s4], rhs = [CaMKII_s1_s2pp_s3_s4, PP1])
    Reac470.kcst = 2
    
    # CaMK_s1p_s2pp_s3_s4 + PP1 <-> CaMK_s1p_s2ppPP1_s3_s4 -> CaMK_s1p_s2p_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac471 = smodel.Reac('Reac471', vsys, lhs = [CaMKII_s1p_s2pp_s3_s4, PP1], rhs = [CaMKII_s1p_s2ppPP1_s3_s4])
    Reac471.kcst = 3.3333e6
    Reac472 = smodel.Reac('Reac472', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3_s4], rhs =[CaMKII_s1p_s2pp_s3_s4, PP1])
    Reac472.kcst = 8
    Reac473 = smodel.Reac('Reac473', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3_s4], rhs = [CaMKII_s1p_s2p_s3_s4, PP1])
    Reac473.kcst = 2
    
    # CaMK_s1pp_s2pCaM3Ca_s3_s4 + PP1 <-> CaMK_s1ppPP1_s2pCaM3Ca_s3_s4 -> CaMK_s1p_s2pCaM3Ca_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac474 = smodel.Reac('Reac474', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4, PP1], rhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3_s4])
    Reac474.kcst = 3.3333e6
    Reac475 = smodel.Reac('Reac475', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3_s4], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3_s4, PP1])
    Reac475.kcst = 8
    Reac476 = smodel.Reac('Reac476', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4, PP1])
    Reac476.kcst = 2
    
    # CaMK_s1pp_s2pCaM3Ca_s3_s4 + PP1 <-> CaMK_s1pp_s2pCaM3CaPP1_s3_s4 -> CaMK_s1pp_s2CaM3Ca_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac477 = smodel.Reac('Reac477', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4, PP1], rhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3_s4])
    Reac477.kcst = 3.3333e6
    Reac478 = smodel.Reac('Reac478', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3_s4], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3_s4, PP1])
    Reac478.kcst = 8
    Reac479 = smodel.Reac('Reac479', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3_s4], rhs = [CaMKII_s1pp_s2CaM3Ca_s3_s4, PP1])
    Reac479.kcst = 2
    
    
    # CaMK_s1pCaM3Ca_s2pp_s3_s4 + PP1 <-> CaMK_s1pCaM3Ca_s2ppPP1_s3_s4 -> CaMK_s1pCaM3Ca_s2p_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac480 = smodel.Reac('Reac480', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4, PP1], rhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3_s4])
    Reac480.kcst = 3.3333e6
    Reac481 = smodel.Reac('Reac481', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3_s4, PP1])
    Reac481.kcst = 8
    Reac482 = smodel.Reac('Reac482', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3_s4], rhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4, PP1])
    Reac482.kcst = 2
    
    # CaMK_s1pCaM3Ca_s2pp_s3_s4 + PP1 <-> CaMK_s1pCaM3CaPP1_s2pp_s3_s4 -> CaMK_s1CaM3Ca_s2pp_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac483 = smodel.Reac('Reac483', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3_s4])
    Reac483.kcst = 3.3333e6
    Reac484 = smodel.Reac('Reac484', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3_s4, PP1])
    Reac484.kcst = 8
    Reac485 = smodel.Reac('Reac485', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2pp_s3_s4, PP1])
    Reac485.kcst = 2
    
    
    # CaMK_s1pp_s2CaM3Ca_s3_s4 + PP1 <-> CaMK_s1ppPP1_s2CaM3Ca_s3_s4 -> CaMK_s1p_s2CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac486 = smodel.Reac('Reac486', vsys, lhs = [CaMKII_s1pp_s2CaM3Ca_s3_s4, PP1], rhs = [CaMKII_s1ppPP1_s2CaM3Ca_s3_s4])
    Reac486.kcst = 3.3333e6
    Reac487 = smodel.Reac('Reac487', vsys, lhs = [CaMKII_s1ppPP1_s2CaM3Ca_s3_s4], rhs =[CaMKII_s1pp_s2CaM3Ca_s3_s4, PP1])
    Reac487.kcst = 8
    Reac488 = smodel.Reac('Reac488', vsys, lhs = [CaMKII_s1ppPP1_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1p_s2CaM3Ca_s3_s4, PP1])
    Reac488.kcst = 2
    
    
    # CaMK_s1CaM3Ca_s2pp_s3_s4 + PP1 <-> CaMK_s1CaM3Ca_s2ppPP1_s3_s4 -> CaMK_s1CaM3Ca_s2p_s3_s4+ PP1 #dephosphorylation at T286/CaM
    Reac489 = smodel.Reac('Reac489', vsys, lhs = [CaMKII_s1CaM3Ca_s2pp_s3_s4, PP1], rhs = [CaMKII_s1CaM3Ca_s2ppPP1_s3_s4])
    Reac489.kcst = 3.3333e6
    Reac490 = smodel.Reac('Reac490', vsys, lhs = [CaMKII_s1CaM3Ca_s2ppPP1_s3_s4], rhs =[CaMKII_s1CaM3Ca_s2pp_s3_s4, PP1])
    Reac490.kcst = 8
    Reac491 = smodel.Reac('Reac491', vsys, lhs = [CaMKII_s1CaM3Ca_s2ppPP1_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2p_s3_s4, PP1])
    Reac491.kcst = 2
    
    # CaMK_s1pp_s2pp_s3_s4 + PP1 <-> CaMK_s1ppPP1_s2pp_s3_s4 -> CaMK_s1p_s2pp_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac492 = smodel.Reac('Reac492', vsys, lhs = [CaMKII_s1pp_s2pp_s3_s4, PP1], rhs = [CaMKII_s1ppPP1_s2pp_s3_s4])
    Reac492.kcst = 3.3333e6
    Reac493 = smodel.Reac('Reac493', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3_s4], rhs =[CaMKII_s1pp_s2pp_s3_s4, PP1])
    Reac493.kcst = 8
    Reac494 = smodel.Reac('Reac494', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3_s4], rhs = [CaMKII_s1p_s2pp_s3_s4, PP1])
    Reac494.kcst = 2
    
    # CaMK_s1pp_s2pp_s3_s4 + PP1 <-> CaMK_s1pp_s2ppPP1_s3_s4 -> CaMK_s1pp_s2p_s3_s4 + PP1 #dephosphorylation at T286/CaM
    Reac495 = smodel.Reac('Reac495', vsys, lhs = [CaMKII_s1pp_s2pp_s3_s4, PP1], rhs = [CaMKII_s1pp_s2ppPP1_s3_s4])
    Reac495.kcst = 3.3333e6
    Reac496 = smodel.Reac('Reac496', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3_s4], rhs =[CaMKII_s1pp_s2pp_s3_s4, PP1])
    Reac496.kcst = 8
    Reac497 = smodel.Reac('Reac497', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3_s4], rhs = [CaMKII_s1pp_s2p_s3_s4, PP1])
    Reac497.kcst = 2
    
    ###dephosphorylation of CaMKII by PP2A
    
    # CaMK_s1pCaM3Ca_s2CaM3Ca_s3_s4 + PP2A <-> CaMK_s1pCaM3CaPP2A_s2CaM3Ca_s3_s4-> CaMK_s1CaM3Ca_s2CaM3Ca_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac498 = smodel.Reac('Reac498', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2CaM3Ca_s3_s4])
    Reac498.kcst = 0.2e6
    Reac499 = smodel.Reac('Reac499', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2CaM3Ca_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4, PP2A])
    Reac499.kcst = 0.8
    Reac500 = smodel.Reac('Reac500', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4, PP2A])
    Reac500.kcst = 0.2
    
    # CaMK_s1CaM3Ca_s2pCaM3Ca_s3_s4 + PP2A <-> CaMK_s1CaM3Ca_s2pCaM3CaPP2A_s3_s4-> CaMK_s1CaM3Ca_s2CaM3Ca_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac501 = smodel.Reac('Reac501', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4, PP2A], rhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP2A_s3_s4])
    Reac501.kcst = 0.2e6
    Reac502 = smodel.Reac('Reac502', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP2A_s3_s4], rhs =[CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4, PP2A])
    Reac502.kcst = 0.8
    Reac503 = smodel.Reac('Reac503', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP2A_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4, PP2A])
    Reac503.kcst = 0.2
    
    # CaMK_s1p_s2CaM3Ca_s3_s4 + PP2A <-> CaMK_s1pPP2A_s2CaM3Ca_s3_s4-> CaMK_s1_s2CaM3Ca_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac504 = smodel.Reac('Reac504', vsys, lhs = [CaMKII_s1p_s2CaM3Ca_s3_s4, PP2A], rhs = [CaMKII_s1pPP2A_s2CaM3Ca_s3_s4])
    Reac504.kcst = 0.2e6
    Reac505 = smodel.Reac('Reac505', vsys, lhs = [CaMKII_s1pPP2A_s2CaM3Ca_s3_s4], rhs =[CaMKII_s1p_s2CaM3Ca_s3_s4, PP2A])
    Reac505.kcst = 0.8
    Reac506 = smodel.Reac('Reac506', vsys, lhs = [CaMKII_s1pPP2A_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3_s4, PP2A])
    Reac506.kcst = 0.2
    
    # CaMK_s1CaM3Ca_s2p_s3_s4 + PP2A <-> CaMK_s1CaM3Ca_s2pPP2A_s3_s4-> CaMK_s1CaM3Ca_s2_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac507 = smodel.Reac('Reac507', vsys, lhs = [CaMKII_s1CaM3Ca_s2p_s3_s4, PP2A], rhs = [CaMKII_s1CaM3Ca_s2pPP2A_s3_s4])
    Reac507.kcst = 0.2e6
    Reac508 = smodel.Reac('Reac508', vsys, lhs = [CaMKII_s1CaM3Ca_s2pPP2A_s3_s4], rhs =[CaMKII_s1CaM3Ca_s2p_s3_s4, PP2A])
    Reac508.kcst = 0.8
    Reac509 = smodel.Reac('Reac509', vsys, lhs = [CaMKII_s1CaM3Ca_s2pPP2A_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4, PP2A])
    Reac509.kcst = 0.2
    
    # CaMK_s1p_s2_s3_s4 + PP2A <-> CaMK_s1pPP2A_s2_s3_s4-> CaMK_s1_s2_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac510 = smodel.Reac('Reac510', vsys, lhs = [CaMKII_s1p_s2_s3_s4, PP2A], rhs = [CaMKII_s1pPP2A_s2_s3_s4])
    Reac510.kcst = 0.2e6
    Reac511 = smodel.Reac('Reac511', vsys, lhs = [CaMKII_s1pPP2A_s2_s3_s4], rhs =[CaMKII_s1p_s2_s3_s4, PP2A])
    Reac511.kcst = 0.8
    Reac512 = smodel.Reac('Reac512', vsys, lhs = [CaMKII_s1pPP2A_s2_s3_s4], rhs = [CaMKII_s1_s2_s3_s4, PP2A])
    Reac512.kcst = 0.2
    
    # CaMK_s1pCaM3Ca_s2pCaM3Ca_s3_s4 + PP2A <-> CaMK_s1pCaM3CaPP2A_s2pCaM3Ca_s3_s4-> CaMK_s1CaM3Ca_s2pCaM3Ca_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac513 = smodel.Reac('Reac513', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3_s4])
    Reac513.kcst = 0.2e6
    Reac514 = smodel.Reac('Reac514', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, PP2A])
    Reac514.kcst = 0.8
    Reac515 = smodel.Reac('Reac515', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4, PP2A])
    Reac515.kcst = 0.2
    
    # CaMK_s1pCaM3Ca_s2pCaM3Ca_s3_s4 + PP2A <-> CaMK_s1pCaM3Ca_s2pCaM3CaPP2A_s3_s4-> CaMK_s1pCaM3Ca_s2CaM3Ca_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac516 = smodel.Reac('Reac516', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3_s4])
    Reac516.kcst = 0.2e6
    Reac517 = smodel.Reac('Reac517', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, PP2A])
    Reac517.kcst = 0.8
    Reac518 = smodel.Reac('Reac518', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3_s4], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4, PP2A])
    Reac518.kcst = 0.2
    
    # CaMK_s1_s2p_s3_s4 + PP2A <-> CaMK_s1_s2pPP2A_s3_s4 -> CaMK_s1_s2 + PP2A #dephosphorylation at T286/CaM
    Reac519 = smodel.Reac('Reac519', vsys, lhs = [CaMKII_s1_s2p_s3_s4, PP2A], rhs = [CaMKII_s1_s2pPP2A_s3_s4])
    Reac519.kcst = 0.2e6
    Reac520 = smodel.Reac('Reac520', vsys, lhs = [CaMKII_s1_s2pPP2A_s3_s4], rhs =[CaMKII_s1_s2p_s3_s4, PP2A])
    Reac520.kcst = 0.8
    Reac521 = smodel.Reac('Reac521', vsys, lhs = [CaMKII_s1_s2pPP2A_s3_s4], rhs = [CaMKII_s1_s2_s3_s4, PP2A])
    Reac521.kcst = 0.2
    
    # CaMK_s1p_s2pCaM3Ca_s3_s4 + PP2A <-> CaMK_s1pPP2A_s2pCaM3Ca_s3_s4-> CaMK_s1_s2pCaM3Ca_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac522 = smodel.Reac('Reac522', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4, PP2A], rhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3_s4])
    Reac522.kcst = 0.2e6
    Reac523 = smodel.Reac('Reac523', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3_s4], rhs =[CaMKII_s1p_s2pCaM3Ca_s3_s4, PP2A])
    Reac523.kcst = 0.8
    Reac524 = smodel.Reac('Reac524', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1_s2pCaM3Ca_s3_s4, PP2A])
    Reac524.kcst = 0.2
    
    # CaMK_s1p_s2pCaM3Ca_s3_s4 + PP2A <-> CaMK_s1p_s2pCaM3CaPP2A_s3_s4-> CaMK_s1p_s2CaM3Ca_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac525 = smodel.Reac('Reac525', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4, PP2A], rhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3_s4])
    Reac525.kcst = 0.2e6
    Reac526 = smodel.Reac('Reac526', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3_s4], rhs =[CaMKII_s1p_s2pCaM3Ca_s3_s4, PP2A])
    Reac526.kcst = 0.8
    Reac527 = smodel.Reac('Reac527', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3_s4], rhs = [CaMKII_s1p_s2CaM3Ca_s3_s4, PP2A])
    Reac527.kcst = 0.2
    
    # CaMK_s1pCaM3Ca_s2p_s3_s4 + PP2A <-> CaMK_s1pCaM3CaPP2A_s2p_s3_s4-> CaMK_s1CaM3Ca_s2p_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac528 = smodel.Reac('Reac528', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3_s4])
    Reac528.kcst = 0.2e6
    Reac529 = smodel.Reac('Reac529', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2p_s3_s4, PP2A])
    Reac529.kcst = 0.8
    Reac530 = smodel.Reac('Reac530', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2p_s3_s4, PP2A])
    Reac530.kcst = 0.2
    
    # CaMK_s1pCaM3Ca_s2p_s3_s4 + PP2A <-> CaMK_s1pCaM3Ca_s2pPP2A_s3_s4-> CaMK_s1pCaM3Ca_s2_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac531 = smodel.Reac('Reac531', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3_s4])
    Reac531.kcst = 0.2e6
    Reac532 = smodel.Reac('Reac532', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2p_s3_s4, PP2A])
    Reac532.kcst = 0.8
    Reac533 = smodel.Reac('Reac533', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3_s4], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4, PP2A])
    Reac533.kcst = 0.2
    
    # CaMK_s1p_s2p_s3_s4 + PP2A <-> CaMK_s1pPP2A_s2p_s3_s4 -> CaMK_s1_s2p_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac544 = smodel.Reac('Reac544', vsys, lhs = [CaMKII_s1p_s2p_s3_s4, PP2A], rhs = [CaMKII_s1pPP2A_s2p_s3_s4])
    Reac544.kcst = 0.2e6
    Reac545 = smodel.Reac('Reac545', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3_s4], rhs =[CaMKII_s1p_s2p_s3_s4, PP2A])
    Reac545.kcst = 0.8
    Reac546 = smodel.Reac('Reac546', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3_s4], rhs = [CaMKII_s1_s2p_s3_s4, PP2A])
    Reac546.kcst = 0.2
    
    # CaMK_s1p_s2p_s3_s4 + PP2A <-> CaMK_s1p_s2pPP2A_s3_s4 -> CaMK_s1p_s2_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac547 = smodel.Reac('Reac547', vsys, lhs = [CaMKII_s1p_s2p_s3_s4, PP2A], rhs = [CaMKII_s1p_s2pPP2A_s3_s4])
    Reac547.kcst = 0.2e6
    Reac548 = smodel.Reac('Reac548', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3_s4], rhs =[CaMKII_s1p_s2p_s3_s4, PP2A])
    Reac548.kcst = 0.8
    Reac549 = smodel.Reac('Reac549', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3_s4], rhs = [CaMKII_s1p_s2_s3_s4, PP2A])
    Reac549.kcst = 0.2
    
    # CaMK_s1_s2pCaM3Ca_s3_s4 + PP2A <-> CaMK_s1_s2pCaM3CaPP2A_s3_s4-> CaMK_s1_s2CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac550 = smodel.Reac('Reac550', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3_s4, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3_s4])
    Reac550.kcst = 0.2e6
    Reac551 = smodel.Reac('Reac551', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3_s4], rhs =[CaMKII_s1_s2pCaM3Ca_s3_s4, PP2A])
    Reac551.kcst = 0.8
    Reac552 = smodel.Reac('Reac552', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3_s4, PP2A])
    Reac552.kcst = 0.2
    
    # CaMK_s1pCaM3Ca_s2_s3_s4 + PP2A <-> CaMK_s1pCaM3CaPP2A_s2_s3_s4-> CaMK_s1CaM3Ca_s2_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac553 = smodel.Reac('Reac553', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2_s3_s4])
    Reac553.kcst = 0.2e6
    Reac554 = smodel.Reac('Reac554', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2_s3_s4, PP2A])
    Reac554.kcst = 0.8
    Reac555 = smodel.Reac('Reac555', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4, PP2A])
    Reac555.kcst = 0.2
    
    # CaMK_s1pp_s2_s3_s4 + PP2A <-> CaMK_s1ppPP2A_s2_s3_s4 -> CaMK_s1p_s2_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac556 = smodel.Reac('Reac556', vsys, lhs = [CaMKII_s1pp_s2_s3_s4, PP2A], rhs = [CaMKII_s1ppPP2A_s2_s3_s4])
    Reac556.kcst = 0.2e6
    Reac557 = smodel.Reac('Reac557', vsys, lhs = [CaMKII_s1ppPP2A_s2_s3_s4], rhs =[CaMKII_s1pp_s2_s3_s4, PP2A])
    Reac557.kcst = 0.8
    Reac558 = smodel.Reac('Reac558', vsys, lhs = [CaMKII_s1ppPP2A_s2_s3_s4], rhs = [CaMKII_s1p_s2_s3_s4, PP2A])
    Reac558.kcst = 0.2
    
    # CaMK_s1_s2pp_s3_s4 + PP2A <-> CaMK_s1_s2ppPP2A_s3_s4 -> CaMK_s1_s2p_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac559 = smodel.Reac('Reac559', vsys, lhs = [CaMKII_s1_s2pp_s3_s4, PP2A], rhs = [CaMKII_s1_s2ppPP2A_s3_s4])
    Reac559.kcst = 0.2e6
    Reac560 = smodel.Reac('Reac560', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3_s4], rhs =[CaMKII_s1_s2pp_s3_s4, PP2A])
    Reac560.kcst = 0.8
    Reac561 = smodel.Reac('Reac561', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3_s4], rhs = [CaMKII_s1_s2p_s3_s4, PP2A])
    Reac561.kcst = 0.2
    
    # CaMK_s1pp_s2p_s3_s4 + PP2A <-> CaMK_s1ppPP2A_s2p_s3_s4 -> CaMK_s1p_s2p_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac562 = smodel.Reac('Reac562', vsys, lhs = [CaMKII_s1pp_s2p_s3_s4, PP2A], rhs = [CaMKII_s1ppPP2A_s2p_s3_s4])
    Reac562.kcst = 0.2e6
    Reac563 = smodel.Reac('Reac563', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3_s4], rhs =[CaMKII_s1pp_s2p_s3_s4, PP2A])
    Reac563.kcst = 0.8
    Reac564 = smodel.Reac('Reac564', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3_s4], rhs = [CaMKII_s1p_s2p_s3_s4, PP2A])
    Reac564.kcst = 0.2
    
    # CaMK_s1pp_s2p_s3_s4 + PP2A <-> CaMK_s1pp_s2pPP2A_s3_s4 -> CaMK_s1pp_s2_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac565 = smodel.Reac('Reac565', vsys, lhs = [CaMKII_s1pp_s2p_s3_s4, PP2A], rhs = [CaMKII_s1pp_s2pPP2A_s3_s4])
    Reac565.kcst = 0.2e6
    Reac566 = smodel.Reac('Reac566', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3_s4], rhs =[CaMKII_s1pp_s2p_s3_s4, PP2A])
    Reac566.kcst = 0.8
    Reac567 = smodel.Reac('Reac567', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3_s4], rhs = [CaMKII_s1pp_s2_s3_s4, PP2A])
    Reac567.kcst = 0.2
    
    # CaMK_s1p_s2pp_s3_s4 + PP2A <-> CaMK_s1pPP2A_s2pp_s3_s4 -> CaMK_s1pPP2A_s2pp_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac568 = smodel.Reac('Reac568', vsys, lhs = [CaMKII_s1p_s2pp_s3_s4, PP2A], rhs = [CaMKII_s1pPP1_s2pp_s3_s4])
    Reac568.kcst = 0.2e6
    Reac569 = smodel.Reac('Reac569', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3_s4], rhs =[CaMKII_s1p_s2pp_s3_s4, PP2A])
    Reac569.kcst = 0.8
    Reac570 = smodel.Reac('Reac570', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3_s4], rhs = [CaMKII_s1_s2pp_s3_s4, PP2A])
    Reac570.kcst = 0.2
    
    # CaMK_s1p_s2pp_s3_s4 + PP2A <-> CaMK_s1p_s2ppPP2A_s3_s4 -> CaMK_s1p_s2p_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac571 = smodel.Reac('Reac571', vsys, lhs = [CaMKII_s1p_s2pp_s3_s4, PP2A], rhs = [CaMKII_s1p_s2ppPP2A_s3_s4])
    Reac571.kcst = 0.2e6
    Reac572 = smodel.Reac('Reac572', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3_s4], rhs =[CaMKII_s1p_s2pp_s3_s4, PP2A])
    Reac572.kcst = 0.8
    Reac573 = smodel.Reac('Reac573', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3_s4], rhs = [CaMKII_s1p_s2p_s3_s4, PP2A])
    Reac573.kcst = 0.2
    
    # CaMK_s1pp_s2pCaM3Ca_s3_s4 + PP2A <-> CaMK_s1ppPP2A_s2pCaM3Ca_s3_s4 -> CaMK_s1p_s2pCaM3Ca_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac574 = smodel.Reac('Reac574', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4, PP2A], rhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3_s4])
    Reac574.kcst = 0.2e6
    Reac575 = smodel.Reac('Reac575', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3_s4], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3_s4, PP2A])
    Reac575.kcst = 0.8
    Reac576 = smodel.Reac('Reac576', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3_s4], rhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4, PP2A])
    Reac576.kcst = 0.2
    
    # CaMK_s1pp_s2pCaM3Ca_s3_s4 + PP2A <-> CaMK_s1pp_s2pCaM3CaPP2A_s3_s4 -> CaMK_s1pp_s2CaM3Ca_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac577 = smodel.Reac('Reac577', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4, PP2A], rhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3_s4])
    Reac577.kcst = 0.2e6
    Reac578 = smodel.Reac('Reac578', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3_s4], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3_s4, PP2A])
    Reac578.kcst = 0.8
    Reac579 = smodel.Reac('Reac579', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3_s4], rhs = [CaMKII_s1pp_s2CaM3Ca_s3_s4, PP2A])
    Reac579.kcst = 0.2
    
    # CaMK_s1pCaM3Ca_s2pp_s3_s4 + PP2A <-> CaMK_s1pCaM3Ca_s2ppPP2A_s3_s4 -> CaMK_s1pCaM3Ca_s2p_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac580 = smodel.Reac('Reac580', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3_s4])
    Reac580.kcst = 0.2e6
    Reac581 = smodel.Reac('Reac581', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3_s4, PP2A])
    Reac581.kcst = 0.8
    Reac582 = smodel.Reac('Reac582', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3_s4], rhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4, PP2A])
    Reac582.kcst = 0.2
    
    # CaMK_s1pCaM3Ca_s2pp_s3_s4 + PP2A <-> CaMK_s1pCaM3CaPP2A_s2pp_s3_s4 -> CaMK_s1CaM3Ca_s2pp_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac583 = smodel.Reac('Reac583', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3_s4])
    Reac583.kcst = 0.2e6
    Reac584 = smodel.Reac('Reac584', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3_s4], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3_s4, PP2A])
    Reac584.kcst = 0.8
    Reac585 = smodel.Reac('Reac585', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2pp_s3_s4, PP2A])
    Reac585.kcst = 0.2
    
    # CaMK_s1pp_s2CaM3Ca_s3_s4 + PP2A <-> CaMK_s1ppPP2A_s2CaM3Ca_s3_s4 -> CaMK_s1p_s2CaM3Ca_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac586 = smodel.Reac('Reac586', vsys, lhs = [CaMKII_s1pp_s2CaM3Ca_s3_s4, PP2A], rhs = [CaMKII_s1ppPP2A_s2CaM3Ca_s3_s4])
    Reac586.kcst = 0.2e6
    Reac587 = smodel.Reac('Reac587', vsys, lhs = [CaMKII_s1ppPP2A_s2CaM3Ca_s3_s4], rhs =[CaMKII_s1pp_s2CaM3Ca_s3_s4, PP2A])
    Reac587.kcst = 0.8
    Reac588 = smodel.Reac('Reac588', vsys, lhs = [CaMKII_s1ppPP2A_s2CaM3Ca_s3_s4], rhs = [CaMKII_s1p_s2CaM3Ca_s3_s4, PP2A])
    Reac588.kcst = 0.2
    
    # CaMK_s1CaM3Ca_s2pp_s3_s4 + PP2A <-> CaMK_s1CaM3Ca_s2ppPP2A_s3_s4 -> CaMK_s1CaM3Ca_s2p_s3_s4+ PP2A #dephosphorylation at T286/CaM
    Reac589 = smodel.Reac('Reac589', vsys, lhs = [CaMKII_s1CaM3Ca_s2pp_s3_s4, PP2A], rhs = [CaMKII_s1CaM3Ca_s2ppPP2A_s3_s4])
    Reac589.kcst = 0.2e6
    Reac590 = smodel.Reac('Reac590', vsys, lhs = [CaMKII_s1CaM3Ca_s2ppPP2A_s3_s4], rhs =[CaMKII_s1CaM3Ca_s2pp_s3_s4, PP2A])
    Reac590.kcst = 0.8
    Reac591 = smodel.Reac('Reac591', vsys, lhs = [CaMKII_s1CaM3Ca_s2ppPP2A_s3_s4], rhs = [CaMKII_s1CaM3Ca_s2p_s3_s4, PP2A])
    Reac591.kcst = 0.2
    
    # CaMK_s1pp_s2pp_s3_s4 + PP2A <-> CaMK_s1ppPP2A_s2pp_s3_s4 -> CaMK_s1p_s2pp_s3_s4 + PP2A #dephosphorylation at T286/CaM
    Reac592 = smodel.Reac('Reac592', vsys, lhs = [CaMKII_s1pp_s2pp_s3_s4, PP2A], rhs = [CaMKII_s1ppPP2A_s2pp_s3_s4])
    Reac592.kcst = 0.2e6
    Reac593 = smodel.Reac('Reac593', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3_s4], rhs =[CaMKII_s1pp_s2pp_s3_s4, PP2A])
    Reac593.kcst = 0.8
    Reac594 = smodel.Reac('Reac594', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3_s4], rhs = [CaMKII_s1p_s2pp_s3_s4, PP2A])
    Reac594.kcst = 0.2
    
    # CaMK_s1pp_s2pp_s3_s4 + PP2A <-> CaMK_s1pp_s2ppPP2A_s3_s4 -> CaMK_s1pp_s2p + PP2A #dephosphorylation at T286/CaM
    Reac595 = smodel.Reac('Reac595', vsys, lhs = [CaMKII_s1pp_s2pp_s3_s4, PP2A], rhs = [CaMKII_s1pp_s2ppPP2A_s3_s4])
    Reac595.kcst = 0.2e6
    Reac596 = smodel.Reac('Reac596', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3_s4], rhs =[CaMKII_s1pp_s2pp_s3_s4, PP2A])
    Reac596.kcst = 0.8
    Reac598 = smodel.Reac('Reac598', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3_s4], rhs = [CaMKII_s1pp_s2p_s3_s4, PP2A])
    Reac598.kcst = 0.2
    
    #reaction of CaMKII s3_s4
    # CaMKII_s1_s2_s3_s4 + CaM3Ca <-> CaMKII_s1_s2_s3CaM3Ca_s4   #activation of CaMKII by CaM of s3
    Reac599 = smodel.Reac('Reac599', vsys, lhs = [CaMKII_s1_s2_s3_s4, CaM3Ca], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4])
    Reac599.kcst = kon_cam
    Reac600 = smodel.Reac('Reac600', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4], rhs = [CaMKII_s1_s2_s3_s4, CaM3Ca])
    Reac600.kcst = koff_cam
    
    # CaMKII_s1_s2_s3_s4 + CaM3Ca <-> CaMKII_s1_s2_s3_s4CaM3Ca   #activation of CaMKII by CaM of s4
    Reac601 = smodel.Reac('Reac601', vsys, lhs = [CaMKII_s1_s2_s3_s4, CaM3Ca], rhs = [CaMKII_s1_s2_s3_s4CaM3Ca])
    Reac601.kcst = kon_cam
    Reac602 = smodel.Reac('Reac602', vsys, lhs = [CaMKII_s1_s2_s3_s4CaM3Ca], rhs = [CaMKII_s1_s2_s3_s4, CaM3Ca])
    Reac602.kcst = koff_cam
    
    # CaMKII_s1_s2_s3CaM3Ca_s4 + CaM3Ca <-> CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM of s3 and s4
    Reac603 = smodel.Reac('Reac603', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4, CaM3Ca], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca])
    Reac603.kcst = kon_cam
    Reac604 = smodel.Reac('Reac604', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4, CaM3Ca])
    Reac604.kcst = koff_cam
    
    # CaMKII_s1_s2_s3_s4CaM3Ca + CaM3Ca <-> CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM of s3 and s4
    Reac605 = smodel.Reac('Reac605', vsys, lhs = [CaMKII_s1_s2_s3_s4CaM3Ca, CaM3Ca], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca])
    Reac605.kcst = kon_cam
    Reac606 = smodel.Reac('Reac606', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2_s3_s4CaM3Ca, CaM3Ca])
    Reac606.kcst = koff_cam
    
    # CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca -> CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca   #phosphorylation of CaMKII s3 at T286
    Reac607 = smodel.Reac('Reac607', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca])
    Reac607.kcst = k_t286
    
    # CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca -> CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca   #phosphorylation of CaMKII s4 at T286
    Reac608 = smodel.Reac('Reac608', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca])
    Reac608.kcst = k_t286
    
    # CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca -> CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca #autophosphorylation at Thr286 of s3 and s4
    Reac609 = smodel.Reac('Reac609', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca])
    Reac609.kcst = k_t286
    
    # CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca -> CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca #autophosphorylation at Thr286 of s3 and s4
    Reac610 = smodel.Reac('Reac610', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca])
    Reac610.kcst = k_t286
    
    ###dephosphorylation of CaMKII by PP1
    # CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca + PP1 <-> CaMKII_s1_s2_s3pCaM3CaPP1_s4CaM3Ca-> CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac611 = smodel.Reac('Reac611', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca, PP1], rhs = [CaMKII_s1_s2_s3pCaM3CaPP1_s4CaM3Ca])
    Reac611.kcst = 3.3333e6
    Reac612 = smodel.Reac('Reac612', vsys, lhs = [CaMKII_s1_s2_s3pCaM3CaPP1_s4CaM3Ca], rhs =[CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac612.kcst = 8
    Reac613 = smodel.Reac('Reac613', vsys, lhs = [CaMKII_s1_s2_s3pCaM3CaPP1_s4CaM3Ca], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca, PP1])
    Reac613.kcst = 2
    
    # CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP1-> CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac614 = smodel.Reac('Reac614', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP1])
    Reac614.kcst = 3.3333e6
    Reac615 = smodel.Reac('Reac615', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac615.kcst = 8
    Reac616 = smodel.Reac('Reac616', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca, PP1])
    Reac616.kcst = 2
    
    # CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1_s2_s3pCaM3CaPP1_s4pCaM3Ca-> CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac617 = smodel.Reac('Reac617', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac617.kcst = 3.3333e6
    Reac618 = smodel.Reac('Reac618', vsys, lhs = [CaMKII_s1_s2_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac618.kcst = 8
    Reac619 = smodel.Reac('Reac619', vsys, lhs = [CaMKII_s1_s2_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac619.kcst = 2
    
    # CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP1-> CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac620 = smodel.Reac('Reac620', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac620.kcst = 3.3333e6
    Reac621 = smodel.Reac('Reac621', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac621.kcst = 8
    Reac622 = smodel.Reac('Reac622', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac622.kcst = 2
    
   ###dephosphorylation of CaMKII by PP2A
    # CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca + PP2A <-> CaMKII_s1_s2_s3pCaM3CaPP2A_s4CaM3Ca-> CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac623 = smodel.Reac('Reac623', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca, PP2A], rhs = [CaMKII_s1_s2_s3pCaM3CaPP2A_s4CaM3Ca])
    Reac623.kcst = 0.2e6
    Reac624 = smodel.Reac('Reac624', vsys, lhs = [CaMKII_s1_s2_s3pCaM3CaPP2A_s4CaM3Ca], rhs =[CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac624.kcst = 0.8
    Reac625 = smodel.Reac('Reac625', vsys, lhs = [CaMKII_s1_s2_s3pCaM3CaPP2A_s4CaM3Ca], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca, PP2A])
    Reac625.kcst = 0.2
    
    # CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac626 = smodel.Reac('Reac626', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP2A])
    Reac626.kcst = 0.2e6
    Reac627 = smodel.Reac('Reac627', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac627.kcst = 0.8
    Reac628 = smodel.Reac('Reac628', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca, PP2A])
    Reac628.kcst = 0.2
    
    
    # CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1_s2_s3pCaM3CaPP2A_s4pCaM3Ca-> CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac629 = smodel.Reac('Reac629', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac629.kcst = 0.2e6
    Reac630 = smodel.Reac('Reac630', vsys, lhs = [CaMKII_s1_s2_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac630.kcst = 0.8
    Reac631 = smodel.Reac('Reac631', vsys, lhs = [CaMKII_s1_s2_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac631.kcst = 0.2
    
    # CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac632 = smodel.Reac('Reac632', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac632.kcst = 0.2e6
    Reac633 = smodel.Reac('Reac633', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac633.kcst = 0.8
    Reac634 = smodel.Reac('Reac634', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac634.kcst = 0.2
    
    #Reaction of CaMKII s2 and s3
    # CaMKII_s1_s2CaM3Ca_s3_s4 + CaM3Ca <-> CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4   #activation of CaMKII_s1 by CaM of s2 and s3
    Reac635 = smodel.Reac('Reac635', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3_s4, CaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4])
    Reac635.kcst = kon_cam
    Reac636 = smodel.Reac('Reac636', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3_s4, CaM3Ca])
    Reac636.kcst = koff_cam
    
    # CaMKII_s1_s2_s3CaM3Ca_s4 + CaM3Ca <-> CaMKII_s1_s2CaM3Ca_s3CaM3Ca   #activation of CaMKII_s1 by CaM of s2 and s3
    Reac637 = smodel.Reac('Reac637', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4, CaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4])
    Reac637.kcst = kon_cam
    Reac638 = smodel.Reac('Reac638', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4, CaM3Ca])
    Reac638.kcst = koff_cam
    
    # CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4 -> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca   #phosphorylation of CaMKII s2 at T286
    Reac639 = smodel.Reac('Reac639', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4])
    Reac639.kcst = k_t286
    
    # CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4 -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4   #phosphorylation of CaMKII s3 at T286
    Reac640 = smodel.Reac('Reac640', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4])
    Reac640.kcst = k_t286
    
    # CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4 -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4 #autophosphorylation at Thr286 of s2
    Reac641 = smodel.Reac('Reac641', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4])
    Reac641.kcst = k_t286
    
    # CaMKII_s1_s2CaM3Ca_s3pCaM3Ca -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca #autophosphorylation at Thr286 of s2 and s3
    Reac642 = smodel.Reac('Reac642', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4])
    Reac642.kcst = k_t286
    
     ###dephosphorylation of CaMKII by PP1
    
    # CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4 + PP1 <-> CaMKII_s1_s2pCaM3CaPP1_s3CaM3Ca_s4-> CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4 + PP1 #dephosphorylation at T286/CaM
    Reac643 = smodel.Reac('Reac643', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3CaM3Ca_s4])
    Reac643.kcst = 3.3333e6
    Reac644 = smodel.Reac('Reac644', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3CaM3Ca_s4], rhs =[CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4, PP1])
    Reac644.kcst = 8
    Reac645 = smodel.Reac('Reac645', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3CaM3Ca_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4, PP1])
    Reac645.kcst = 2
    
    # CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4 + PP1 <-> CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP1_s4-> CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4 + PP1 #dephosphorylation at T286/CaM
    Reac646 = smodel.Reac('Reac646', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4, PP1], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP1_s4])
    Reac646.kcst = 3.3333e6
    Reac647 = smodel.Reac('Reac647', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP1_s4], rhs =[CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4, PP1])
    Reac647.kcst = 8
    Reac648 = smodel.Reac('Reac648', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP1_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4, PP1])
    Reac648.kcst = 2
    
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4 + PP1 <-> CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4-> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4 + PP1 #dephosphorylation at T286/CaM
    Reac649 = smodel.Reac('Reac649', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4])
    Reac649.kcst = 3.3333e6
    Reac650 = smodel.Reac('Reac650', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, PP1])
    Reac650.kcst = 8
    Reac651 = smodel.Reac('Reac651', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4, PP1])
    Reac651.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4 + PP1 <-> CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4-> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4 + PP1 #dephosphorylation at T286/CaM
    Reac652 = smodel.Reac('Reac652', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4])
    Reac652.kcst = 3.3333e6
    Reac653 = smodel.Reac('Reac653', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, PP1])
    Reac653.kcst = 8
    Reac654 = smodel.Reac('Reac654', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4, PP1])
    Reac654.kcst = 2
    
    ###dephosphorylation of CaMKII by PP2A
    
    # CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4 + PP2A <-> CaMKII_s1_s2pCaM3CaPP2A_s3CaM3Ca_s4-> CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4 + PP2A #dephosphorylation at T286/CaM
    Reac655 = smodel.Reac('Reac655', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3CaM3Ca_s4])
    Reac655.kcst = 0.2e6
    Reac656 = smodel.Reac('Reac656', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3CaM3Ca_s4], rhs =[CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4, PP2A])
    Reac656.kcst = 0.8
    Reac657 = smodel.Reac('Reac657', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3CaM3Ca_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4, PP2A])
    Reac657.kcst = 0.2
    
    # CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4 + PP2A <-> CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP2A_s4-> CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4 + PP2A #dephosphorylation at T286/CaM
    Reac658 = smodel.Reac('Reac658', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4, PP2A], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP2A_s4])
    Reac658.kcst = 0.2e6
    Reac659 = smodel.Reac('Reac659', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP2A_s4], rhs =[CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4, PP2A])
    Reac659.kcst = 0.8
    Reac660 = smodel.Reac('Reac660', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3CaPP2A_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4, PP2A])
    Reac660.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4 + PP2A <-> CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4-> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4 + PP2A #dephosphorylation at T286/CaM
    Reac661 = smodel.Reac('Reac661', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4])
    Reac661.kcst = 0.2e6
    Reac662 = smodel.Reac('Reac662', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, PP2A])
    Reac662.kcst = 0.8
    Reac663 = smodel.Reac('Reac663', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4, PP2A])
    Reac663.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4 + PP2A <-> CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4-> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4 + PP2A #dephosphorylation at T286/CaM
    Reac664 = smodel.Reac('Reac664', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4])
    Reac664.kcst = 0.2e6
    Reac665 = smodel.Reac('Reac665', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, PP2A])
    Reac665.kcst = 0.8
    Reac666 = smodel.Reac('Reac666', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4, PP2A])
    Reac666.kcst = 0.2
    
    ###### sub s1 and s4
    # CaMKII_s1CaM3Ca_s2_s3_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca   #activation of CaMKII by CaM of s1 and s4
    Reac667 = smodel.Reac('Reac667', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca])
    Reac667.kcst = kon_cam
    Reac668 = smodel.Reac('Reac668', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4, CaM3Ca])
    Reac668.kcst = koff_cam
    
    # CaMKII_s1_s2_s3_s4CaM3Ca + CaM3Ca <-> CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca   #activation of CaMKII by CaM of s1 and s4
    Reac669 = smodel.Reac('Reac669', vsys, lhs = [CaMKII_s1_s2_s3_s4CaM3Ca, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca])
    Reac669.kcst = kon_cam
    Reac670 = smodel.Reac('Reac670', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca], rhs = [CaMKII_s1_s2_s3_s4CaM3Ca, CaM3Ca])
    Reac670.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca -> CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca   #phosphorylation of CaMKII s1 at T286
    Reac671 = smodel.Reac('Reac671', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca])
    Reac671.kcst = k_t286
    
    # CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca -> CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca   #phosphorylation of CaMKII s4 at T286
    Reac672 = smodel.Reac('Reac672', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca])
    Reac672.kcst = k_t286
    
    # CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca -> CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca #autophosphorylation at Thr286 of s1 and s4
    Reac673 = smodel.Reac('Reac673', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca])
    Reac673.kcst = k_t286
    
    # CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca #autophosphorylation at Thr286 of s1 and s4
    Reac674 = smodel.Reac('Reac674', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca])
    Reac674.kcst = k_t286
    
    
    ###dephosphorylation of CaMKII by PP1
    # CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2_s3_s4CaM3Ca-> CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac675 = smodel.Reac('Reac675', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2_s3_s4CaM3Ca])
    Reac675.kcst = 3.3333e6
    Reac676 = smodel.Reac('Reac676', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2_s3_s4CaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca, PP1])
    Reac676.kcst = 8
    Reac677 = smodel.Reac('Reac677', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2_s3_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca, PP1])
    Reac677.kcst = 2
    
    # CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca + PP1 <-> CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP1-> CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac678 = smodel.Reac('Reac678', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca, PP1], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP1])
    Reac678.kcst = 3.3333e6
    Reac679 = smodel.Reac('Reac679', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP1], rhs =[CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca, PP1])
    Reac679.kcst = 8
    Reac680 = smodel.Reac('Reac680', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP1], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca, PP1])
    Reac680.kcst = 2
    
    
    # CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2_s3_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac681 = smodel.Reac('Reac681', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2_s3_s4pCaM3Ca])
    Reac681.kcst = 3.3333e6
    Reac682 = smodel.Reac('Reac682', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2_s3_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, PP1])
    Reac682.kcst = 8
    Reac683 = smodel.Reac('Reac683', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2_s3_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca, PP1])
    Reac683.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP1-> CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac684 = smodel.Reac('Reac684', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP1])
    Reac684.kcst = 3.3333e6
    Reac685 = smodel.Reac('Reac685', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP1], rhs =[CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, PP1])
    Reac685.kcst = 8
    Reac686 = smodel.Reac('Reac686', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP1], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca, PP1])
    Reac686.kcst = 2
    
    
    ###dephosphorylation of CaMKII by PP2A
    # CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2_s3_s4CaM3Ca-> CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac687 = smodel.Reac('Reac687', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2_s3_s4CaM3Ca])
    Reac687.kcst = 0.2e6
    Reac688 = smodel.Reac('Reac688', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2_s3_s4CaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca, PP2A])
    Reac688.kcst = 0.8
    Reac689 = smodel.Reac('Reac689', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2_s3_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca, PP2A])
    Reac689.kcst = 0.2
    
    # CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca + PP2A <-> CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP2A-> CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac690 = smodel.Reac('Reac690', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP2A])
    Reac690.kcst = 0.2e6
    Reac691 = smodel.Reac('Reac691', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP2A], rhs =[CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca, PP2A])
    Reac691.kcst = 0.8
    Reac692 = smodel.Reac('Reac692', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3CaPP2A], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca, PP2A])
    Reac692.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2_s3_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac693 = smodel.Reac('Reac693', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2_s3_s4pCaM3Ca])
    Reac693.kcst = 0.2e6
    Reac694 = smodel.Reac('Reac694', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2_s3_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, PP2A])
    Reac694.kcst = 0.8
    Reac695 = smodel.Reac('Reac695', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2_s3_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca, PP2A])
    Reac695.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP2A-> CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac696 = smodel.Reac('Reac696', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP2A])
    Reac696.kcst = 0.2e6
    Reac697 = smodel.Reac('Reac697', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP2A], rhs =[CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, PP2A])
    Reac697.kcst = 0.8
    Reac698 = smodel.Reac('Reac698', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3CaPP2A], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca, PP2A])
    Reac698.kcst = 0.2
    
    #####activation of 4 subunits
    ####CAMK activation by CaM
    
    # CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4   #activation of CaMKII by CaM
    Reac699 = smodel.Reac('Reac699', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4])
    Reac699.kcst = kon_cam
    Reac700 = smodel.Reac('Reac700', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4, CaM3Ca])
    Reac700.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca   #activation of CaMKII by CaM
    Reac701 = smodel.Reac('Reac701', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca])
    Reac701.kcst = kon_cam
    Reac702 = smodel.Reac('Reac702', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4, CaM3Ca])
    Reac702.kcst = koff_cam
    
    # CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4   #activation of CaMKII by CaM
    Reac703 = smodel.Reac('Reac703', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4])
    Reac703.kcst = kon_cam
    Reac704 = smodel.Reac('Reac704', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4, CaM3Ca])
    Reac704.kcst = koff_cam
    
    # CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4 + CaM3Ca <-> CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac705 = smodel.Reac('Reac705', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4, CaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca])
    Reac705.kcst = kon_cam
    Reac706 = smodel.Reac('Reac706', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4, CaM3Ca])
    Reac706.kcst = koff_cam
    
    # CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca + CaM3Ca <-> CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac707 = smodel.Reac('Reac707', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca, CaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca])
    Reac707.kcst = kon_cam
    Reac708 = smodel.Reac('Reac708', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca, CaM3Ca])
    Reac708.kcst = koff_cam
    
    # CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca + CaM3Ca <-> CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac709 = smodel.Reac('Reac709', vsys, lhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca])
    Reac709.kcst = kon_cam
    Reac710 = smodel.Reac('Reac710', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca, CaM3Ca])
    Reac710.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca + CaM3Ca <-> CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac711 = smodel.Reac('Reac711', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca])
    Reac711.kcst = kon_cam
    Reac712 = smodel.Reac('Reac712', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca, CaM3Ca])
    Reac712.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca   #activation of CaMKII by CaM
    Reac713 = smodel.Reac('Reac713', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca])
    Reac713.kcst = kon_cam
    Reac714 = smodel.Reac('Reac714', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca, CaM3Ca])
    Reac714.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac715 = smodel.Reac('Reac715', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca])
    Reac715.kcst = kon_cam
    Reac716 = smodel.Reac('Reac716', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4, CaM3Ca])
    Reac716.kcst = koff_cam
    
    # CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac717 = smodel.Reac('Reac717', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca])
    Reac717.kcst = kon_cam
    Reac718 = smodel.Reac('Reac718', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca, CaM3Ca])
    Reac718.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac719 = smodel.Reac('Reac719', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca])
    Reac719.kcst = kon_cam
    Reac720 = smodel.Reac('Reac720', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca, CaM3Ca])
    Reac720.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac721 = smodel.Reac('Reac721', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca])
    Reac721.kcst = kon_cam
    Reac722 = smodel.Reac('Reac722', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca, CaM3Ca])
    Reac722.kcst = koff_cam
   
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4 + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4   #activation of CaMKII by CaM
    Reac723 = smodel.Reac('Reac723', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4])
    Reac723.kcst = kon_cam
    Reac724 = smodel.Reac('Reac724', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, CaM3Ca])
    Reac724.kcst = koff_cam
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4 + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca   #activation of CaMKII by CaM
    Reac725 = smodel.Reac('Reac725', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca])
    Reac725.kcst = kon_cam
    Reac726 = smodel.Reac('Reac726', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4, CaM3Ca])
    Reac726.kcst = koff_cam
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4 + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac727 = smodel.Reac('Reac727', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca])
    Reac727.kcst = kon_cam
    Reac728 = smodel.Reac('Reac728', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4, CaM3Ca])
    Reac728.kcst = koff_cam
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac729 = smodel.Reac('Reac729', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca])
    Reac729.kcst = kon_cam
    Reac730 = smodel.Reac('Reac730', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca, CaM3Ca])
    Reac730.kcst = koff_cam
    
    # CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca + CaM3Ca <-> CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca   #activation of CaMKII by CaM
    Reac731 = smodel.Reac('Reac731', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca])
    Reac731.kcst = kon_cam
    Reac732 = smodel.Reac('Reac732', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca])
    Reac732.kcst = koff_cam
    
    # CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca + CaM3Ca <-> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca   #activation of CaMKII by CaM
    Reac733 = smodel.Reac('Reac733', vsys, lhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac733.kcst = kon_cam
    Reac734 = smodel.Reac('Reac734', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca])
    Reac734.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca   #activation of CaMKII by CaM
    Reac735 = smodel.Reac('Reac735', vsys, lhs = [CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac735.kcst = kon_cam
    Reac736 = smodel.Reac('Reac736', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca])
    Reac736.kcst = koff_cam
    
    # CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + CaM3Ca <-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca   #activation of CaMKII by CaM
    Reac737 = smodel.Reac('Reac737', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac737.kcst = kon_cam
    Reac738 = smodel.Reac('Reac738', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca])
    Reac738.kcst = koff_cam
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4   #activation of CaMKII by CaM
    Reac739 = smodel.Reac('Reac739', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4])
    Reac739.kcst = kon_cam
    Reac740 = smodel.Reac('Reac740', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, CaM3Ca])
    Reac740.kcst = koff_cam
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4 + CaM3Ca <-> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac741 = smodel.Reac('Reac741', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca])
    Reac741.kcst = kon_cam
    Reac742 = smodel.Reac('Reac742', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, CaM3Ca])
    Reac742.kcst = koff_cam
    
    # CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4 + CaM3Ca <-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac743 = smodel.Reac('Reac743', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca])
    Reac743.kcst = kon_cam
    Reac744 = smodel.Reac('Reac744', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4, CaM3Ca])
    Reac744.kcst = koff_cam
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + CaM3Ca <-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca   #activation of CaMKII by CaM
    Reac745 = smodel.Reac('Reac745', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca])
    Reac745.kcst = kon_cam
    Reac746 = smodel.Reac('Reac746', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, CaM3Ca])
    Reac746.kcst = koff_cam
    
    # CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca   #activation of CaMKII by CaM
    Reac747 = smodel.Reac('Reac747', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca])
    Reac747.kcst = kon_cam
    Reac748 = smodel.Reac('Reac748', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, CaM3Ca])
    Reac748.kcst = koff_cam
    
    # CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca   #activation of CaMKII by CaM
    Reac749 = smodel.Reac('Reac749', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca])
    Reac749.kcst = kon_cam
    Reac750 = smodel.Reac('Reac750', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca, CaM3Ca])
    Reac750.kcst = koff_cam
    
    # CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca   #activation of CaMKII by CaM
    Reac751 = smodel.Reac('Reac751', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca])
    Reac751.kcst = kon_cam
    Reac752 = smodel.Reac('Reac752', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca, CaM3Ca])
    Reac752.kcst = koff_cam
    
    # CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca   #activation of CaMKII by CaM
    Reac753 = smodel.Reac('Reac753', vsys, lhs = [CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca])
    Reac753.kcst = kon_cam
    Reac754 = smodel.Reac('Reac754', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca, CaM3Ca])
    Reac754.kcst = koff_cam
    
    
    #phosphorylation reactions at thr 286 from 2 sub  to 4 sub
    # CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca   #phosphorylation at T286
    Reac755 = smodel.Reac('Reac755', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac755.kcst = k_t286
    
    # CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca   #phosphorylation  at T286
    Reac756 = smodel.Reac('Reac756', vsys, lhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac756.kcst = k_t286
    
    # CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca   #phosphorylation  at T286
    Reac757 = smodel.Reac('Reac757', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca])
    Reac757.kcst = k_t286
    
    # CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca   #phosphorylation  at T286
    Reac758 = smodel.Reac('Reac758', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac758.kcst = k_t286
    
    # CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca   #phosphorylation  at T286
    Reac759 = smodel.Reac('Reac759', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca])
    Reac759.kcst = k_t286
    # CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca -> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca   #phosphorylation at T286
    Reac760 = smodel.Reac('Reac760', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac760.kcst = k_t286
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca   #phosphorylation  at T286
    Reac761 = smodel.Reac('Reac761', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca])
    Reac761.kcst = k_t286
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca   #phosphorylation  at T286
    Reac762 = smodel.Reac('Reac762', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca])
    Reac762.kcst = k_t286
    
    # CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca   #phosphorylation at T286
    Reac763 = smodel.Reac('Reac763', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac763.kcst = k_t286
    # CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca   #phosphorylation  at T286
    Reac764 = smodel.Reac('Reac764', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac764.kcst = k_t286
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca   #phosphorylation  at T286
    Reac765 = smodel.Reac('Reac765', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac765.kcst = k_t286
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca   #phosphorylation  at T286
    Reac766 = smodel.Reac('Reac766', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac766.kcst = k_t286
    
    #dephoshorylation by PP1
    # CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1CaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac767 = smodel.Reac('Reac767', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac767.kcst = 3.3333e6
    Reac768 = smodel.Reac('Reac768', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac768.kcst = 8
    Reac769 = smodel.Reac('Reac769', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac769.kcst = 2
    
    # CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP1 <-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac770 = smodel.Reac('Reac770', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac770.kcst = 3.3333e6
    Reac771 = smodel.Reac('Reac771', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac771.kcst = 8
    Reac772 = smodel.Reac('Reac772', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac772.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac773 = smodel.Reac('Reac773', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac773.kcst = 3.3333e6
    Reac774 = smodel.Reac('Reac774', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac774.kcst = 8
    Reac775 = smodel.Reac('Reac775', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac775.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac776 = smodel.Reac('Reac776', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac776.kcst = 3.3333e6
    Reac777 = smodel.Reac('Reac777', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac777.kcst = 8
    Reac778 = smodel.Reac('Reac778', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac778.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3CaM3Ca_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac779 = smodel.Reac('Reac779', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3CaM3Ca_s4pCaM3Ca])
    Reac779.kcst = 3.3333e6
    Reac780 = smodel.Reac('Reac780', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3CaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac780.kcst = 8
    Reac781 = smodel.Reac('Reac781', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3CaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac781.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP1-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac782 = smodel.Reac('Reac782', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP1])
    Reac782.kcst = 3.3333e6
    Reac783 = smodel.Reac('Reac783', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac783.kcst = 8
    Reac784 = smodel.Reac('Reac784', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca, PP1])
    Reac784.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac785 = smodel.Reac('Reac785', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca])
    Reac785.kcst = 3.3333e6
    Reac786 = smodel.Reac('Reac786', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac786.kcst = 8
    Reac787 = smodel.Reac('Reac787', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac787.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4CaM3Ca-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac788 = smodel.Reac('Reac788', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4CaM3Ca])
    Reac788.kcst = 3.3333e6
    Reac789 = smodel.Reac('Reac789', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4CaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac789.kcst = 8
    Reac790 = smodel.Reac('Reac790', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca, PP1])
    Reac790.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac791 = smodel.Reac('Reac791', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac791.kcst = 3.3333e6
    Reac792 = smodel.Reac('Reac792', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac792.kcst = 8
    Reac793 = smodel.Reac('Reac793', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac793.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac794 = smodel.Reac('Reac794', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac794.kcst = 3.3333e6
    Reac795 = smodel.Reac('Reac795', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac795.kcst = 8
    Reac796 = smodel.Reac('Reac796', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac796.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac798 = smodel.Reac('Reac798', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac798.kcst = 3.3333e6
    Reac799 = smodel.Reac('Reac799', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac799.kcst = 8
    Reac800 = smodel.Reac('Reac800', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac800.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP1 #dephosphorylation at T286/CaM
    Reac801 = smodel.Reac('Reac801', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac801.kcst = 3.3333e6
    Reac802 = smodel.Reac('Reac802', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac802.kcst = 8
    Reac803 = smodel.Reac('Reac803', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac803.kcst = 2
    
    ###dephosphorylation by PP2A
    # CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1CaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac804 = smodel.Reac('Reac804', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac804.kcst = 0.2e6
    Reac805 = smodel.Reac('Reac805', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac805.kcst = 0.8
    Reac806 = smodel.Reac('Reac806', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac806.kcst = 0.2
    
    # CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP2A <-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac807 = smodel.Reac('Reac807', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac807.kcst = 0.2e6
    Reac808 = smodel.Reac('Reac808', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac808.kcst = 0.8
    Reac809 = smodel.Reac('Reac809', vsys, lhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac809.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac810 = smodel.Reac('Reac810', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac810.kcst = 0.2e6
    Reac811 = smodel.Reac('Reac811', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac811.kcst = 0.8
    Reac812 = smodel.Reac('Reac812', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac812.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac813 = smodel.Reac('Reac813', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac813.kcst = 0.2e6
    Reac814 = smodel.Reac('Reac814', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac814.kcst = 0.8
    Reac815= smodel.Reac('Reac815', vsys, lhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac815.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3CaM3Ca_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac816 = smodel.Reac('Reac816', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3CaM3Ca_s4pCaM3Ca])
    Reac816.kcst = 0.2e6
    Reac817 = smodel.Reac('Reac817', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3CaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac817.kcst = 0.8
    Reac818 = smodel.Reac('Reac818', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3CaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac818.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac819 = smodel.Reac('Reac819', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP2A])
    Reac819.kcst = 0.2e6
    Reac820 = smodel.Reac('Reac820', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac820.kcst = 0.8
    Reac821 = smodel.Reac('Reac821', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca, PP2A])
    Reac821.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac822 = smodel.Reac('Reac822', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca])
    Reac822.kcst = 0.2e6
    Reac823 = smodel.Reac('Reac823', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac823.kcst = 0.8
    Reac824 = smodel.Reac('Reac824', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac824.kcst = 0.2
  
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4CaM3Ca-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac825 = smodel.Reac('Reac825', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4CaM3Ca])
    Reac825.kcst = 0.2e6
    Reac826 = smodel.Reac('Reac826', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4CaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac826.kcst = 0.8
    Reac827 = smodel.Reac('Reac827', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca, PP2A])
    Reac827.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac828 = smodel.Reac('Reac828', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac828.kcst = 0.2e6
    Reac829 = smodel.Reac('Reac829', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac829.kcst = 0.8
    Reac830 = smodel.Reac('Reac830', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac830.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac831 = smodel.Reac('Reac831', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac831.kcst = 0.2e6
    Reac832 = smodel.Reac('Reac832', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac832.kcst = 0.8
    Reac833 = smodel.Reac('Reac833', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac833.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac834 = smodel.Reac('Reac834', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac834.kcst = 0.2e6
    Reac835 = smodel.Reac('Reac835', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac835.kcst = 0.8
    Reac836 = smodel.Reac('Reac836', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac836.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP2A #dephosphorylation at T286/CaM
    Reac837 = smodel.Reac('Reac837', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac837.kcst = 0.2e6
    Reac838 = smodel.Reac('Reac838', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac838.kcst = 0.8
    Reac839 = smodel.Reac('Reac839', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac839.kcst = 0.2
    
    #phosphorylation at thr305
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca  #dissociation of CaM, autophosphorylation withouth CaM
    Reac840 = smodel.Reac('Reac840', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac840.kcst = kon_cam_t286
    Reac841 = smodel.Reac('Reac841', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, CaM3Ca])
    Reac841.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac842 = smodel.Reac('Reac842', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac842.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac843 = smodel.Reac('Reac843', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac843.kcst = kon_cam_t286
    Reac844 = smodel.Reac('Reac844', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, CaM3Ca])
    Reac844.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp #autophosphorylation at Thr305
    Reac845 = smodel.Reac('Reac845', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp])
    Reac845.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac846 = smodel.Reac('Reac846', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp])
    Reac846.kcst = kon_cam_t286
    Reac847 = smodel.Reac('Reac847', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, CaM3Ca])
    Reac847.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp -> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac848 = smodel.Reac('Reac848', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp])
    Reac848.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3pp_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac849 = smodel.Reac('Reac849', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp])
    Reac849.kcst = kon_cam_t286
    Reac850 = smodel.Reac('Reac850', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp], rhs = [CaMKII_s1p_s2pp_s3pp_s4pp, CaM3Ca])
    Reac850.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3pp_s4pp -> CaMKII_s1pp_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac851 = smodel.Reac('Reac851', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp])
    Reac851.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3pp_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac852 = smodel.Reac('Reac852', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp])
    Reac852.kcst = kon_cam_t286
    Reac853 = smodel.Reac('Reac853', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp], rhs = [CaMKII_s1p_s2p_s3pp_s4pp, CaM3Ca])
    Reac853.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pp_s4pp -> CaMKII_s1p_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac854 = smodel.Reac('Reac854', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp], rhs = [CaMKII_s1p_s2pp_s3pp_s4pp])
    Reac854.kcst = k_t350
    
    # CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac855 = smodel.Reac('Reac855', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp])
    Reac855.kcst = kon_cam_t286
    Reac856 = smodel.Reac('Reac856', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, CaM3Ca])
    Reac856.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pp_s4pp + CaM3Ca <-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac857 = smodel.Reac('Reac857', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp])
    Reac857.kcst = kon_cam_t286
    Reac858 = smodel.Reac('Reac858', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1p_s2p_s3pp_s4pp, CaM3Ca])
    Reac858.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pp_s4pp -> CaMKII_s1pp_s2p_s3pp_s4pp #autophosphorylation at Thr305
    Reac859 = smodel.Reac('Reac859', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp], rhs = [CaMKII_s1pp_s2p_s3pp_s4pp])
    Reac859.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3pp_s4pp -> CaMKII_s1pp_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac860 = smodel.Reac('Reac860', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pp], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pp])
    Reac860.kcst = k_t350
    
    # CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp -> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp #autophosphorylation at Thr305
    Reac861 = smodel.Reac('Reac861', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp])
    Reac861.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3pp_s4pp + CaM3Ca <-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac862 = smodel.Reac('Reac862', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pp, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp])
    Reac862.kcst = kon_cam_t286
    Reac863 = smodel.Reac('Reac863', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1pp_s2p_s3pp_s4pp, CaM3Ca])
    Reac863.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4p-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac864 = smodel.Reac('Reac864', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac864.kcst = 3.3333e6
    Reac865 = smodel.Reac('Reac865', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac865.kcst = 8
    Reac866 = smodel.Reac('Reac866', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac866.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4p-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac867 = smodel.Reac('Reac867', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac867.kcst = 3.3333e6
    Reac868 = smodel.Reac('Reac868', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac868.kcst = 8
    Reac869 = smodel.Reac('Reac869', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac869.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4p-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac870 = smodel.Reac('Reac870', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4p])
    Reac870.kcst = 3.3333e6
    Reac871 = smodel.Reac('Reac871', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac871.kcst = 8
    Reac872 = smodel.Reac('Reac872', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4p, PP1])
    Reac872.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP1-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4 + PP1 #dephosphorylation at T286/CaM
    Reac873 = smodel.Reac('Reac873', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP1])
    Reac873.kcst = 3.3333e6
    Reac874 = smodel.Reac('Reac874', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac874.kcst = 8
    Reac875 = smodel.Reac('Reac875', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4, PP1])
    Reac875.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac876 = smodel.Reac('Reac876', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac876.kcst = 3.3333e6
    Reac877 = smodel.Reac('Reac877', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac877.kcst = 8
    Reac878 = smodel.Reac('Reac878', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac878.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pp-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac879 = smodel.Reac('Reac879', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pp])
    Reac879.kcst = 3.3333e6
    Reac880 = smodel.Reac('Reac880', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac880.kcst = 8
    Reac881 = smodel.Reac('Reac881', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac881.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pp-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac882 = smodel.Reac('Reac882', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pp])
    Reac882.kcst = 3.3333e6
    Reac883 = smodel.Reac('Reac883', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac883.kcst = 8
    Reac884 = smodel.Reac('Reac884', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pp, PP1])
    Reac884.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac885 = smodel.Reac('Reac885', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1])
    Reac885.kcst = 3.3333e6
    Reac886 = smodel.Reac('Reac886', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac886.kcst = 8
    Reac887 = smodel.Reac('Reac887', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac887.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pp-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac888 = smodel.Reac('Reac888', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pp])
    Reac888.kcst = 3.3333e6
    Reac889 = smodel.Reac('Reac889', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac889.kcst = 8
    Reac890 = smodel.Reac('Reac890', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac890.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pp-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac891 = smodel.Reac('Reac891', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pp])
    Reac891.kcst = 3.3333e6
    Reac892 = smodel.Reac('Reac892', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac892.kcst = 8
    Reac893 = smodel.Reac('Reac893', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pp, PP1])
    Reac893.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pp-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac894 = smodel.Reac('Reac894', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pp])
    Reac894.kcst = 3.3333e6
    Reac895 = smodel.Reac('Reac895', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac895.kcst = 8
    Reac896 = smodel.Reac('Reac896', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pp, PP1])
    Reac896.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP1-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac897 = smodel.Reac('Reac897', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP1])
    Reac897.kcst = 3.3333e6
    Reac898 = smodel.Reac('Reac898', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP1], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac898.kcst = 8
    Reac899 = smodel.Reac('Reac899', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP1])
    Reac899.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pp-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac900 = smodel.Reac('Reac900', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pp])
    Reac900.kcst = 3.3333e6
    Reac901 = smodel.Reac('Reac901', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac901.kcst = 8
    Reac902 = smodel.Reac('Reac902', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac902.kcst = 2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pp-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac903 = smodel.Reac('Reac903', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pp])
    Reac903.kcst = 3.3333e6
    Reac904 = smodel.Reac('Reac904', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac904.kcst = 8
    Reac905 = smodel.Reac('Reac905', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pp, PP1])
    Reac905.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pp-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac906 = smodel.Reac('Reac906', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pp])
    Reac906.kcst = 3.3333e6
    Reac907 = smodel.Reac('Reac907', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac907.kcst = 8
    Reac908 = smodel.Reac('Reac908', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac908.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP1-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac909 = smodel.Reac('Reac909', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP1])
    Reac909.kcst = 3.3333e6
    Reac910 = smodel.Reac('Reac910', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP1], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac910.kcst = 8
    Reac911 = smodel.Reac('Reac911', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac911.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pp-> CaMKII_s1CaM3Ca_s2p_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac912 = smodel.Reac('Reac912', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pp])
    Reac912.kcst = 3.3333e6
    Reac913 = smodel.Reac('Reac913', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP1])
    Reac913.kcst = 8
    Reac914 = smodel.Reac('Reac914', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pp], rhs = [CaMKII_s1CaM3Ca_s2p_s3pp_s4pp, PP1])
    Reac914.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pp-> CaMKII_s1pCaM3Ca_s2_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac915 = smodel.Reac('Reac915', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pp])
    Reac915.kcst = 3.3333e6
    Reac916 = smodel.Reac('Reac916', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP1])
    Reac916.kcst = 8
    Reac917 = smodel.Reac('Reac917', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2_s3pp_s4pp, PP1])
    Reac917.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac918 = smodel.Reac('Reac918', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pp])
    Reac918.kcst = 3.3333e6
    Reac919 = smodel.Reac('Reac919', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP1])
    Reac919.kcst = 8
    Reac920 = smodel.Reac('Reac920', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2_s3pp_s4pp, PP1])
    Reac920.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP1-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac921 = smodel.Reac('Reac921', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP1])
    Reac921.kcst = 3.3333e6
    Reac922 = smodel.Reac('Reac922', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP1], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP1])
    Reac922.kcst = 8
    Reac923 = smodel.Reac('Reac923', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP1])
    Reac923.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pp-> CaMKII_s1CaM3Ca_s2pp_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac924 = smodel.Reac('Reac924', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pp])
    Reac924.kcst = 3.3333e6
    Reac925 = smodel.Reac('Reac925', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP1])
    Reac925.kcst = 8
    Reac926 = smodel.Reac('Reac926', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pp_s4pp, PP1])
    Reac926.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac927 = smodel.Reac('Reac927', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pp])
    Reac927.kcst = 3.3333e6
    Reac928 = smodel.Reac('Reac928', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP1])
    Reac928.kcst = 8
    Reac929 = smodel.Reac('Reac929', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP1])
    Reac929.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pp-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac930 = smodel.Reac('Reac930', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pp])
    Reac930.kcst = 3.3333e6
    Reac931 = smodel.Reac('Reac931', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP1])
    Reac931.kcst = 8
    Reac932 = smodel.Reac('Reac932', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP1])
    Reac932.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP1-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac933 = smodel.Reac('Reac933', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP1])
    Reac933.kcst = 3.3333e6
    Reac934 = smodel.Reac('Reac934', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP1], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP1])
    Reac934.kcst = 8
    Reac935 = smodel.Reac('Reac935', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP1])
    Reac935.kcst = 2
    
    #CaMKII_s1p_s2p_s3pp_s4pp + PP1 <-> CaMKII_s1pPP1_s2p_s3pp_s4pp-> CaMKII_s1_s2p_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac937 = smodel.Reac('Reac937', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp, PP1], rhs = [CaMKII_s1pPP1_s2p_s3pp_s4pp])
    Reac937.kcst = 3.3333e6
    Reac938 = smodel.Reac('Reac938', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pp_s4pp], rhs =[CaMKII_s1p_s2p_s3pp_s4pp, PP1])
    Reac938.kcst = 8
    Reac939 = smodel.Reac('Reac939', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pp_s4pp], rhs = [CaMKII_s1_s2p_s3pp_s4pp, PP1])
    Reac939.kcst = 2
    
    #CaMKII_s1p_s2p_s3pp_s4pp + PP1 <-> CaMKII_s1p_s2pPP1_s3pp_s4pp-> CaMKII_s1p_s2_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac940 = smodel.Reac('Reac940', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp, PP1], rhs = [CaMKII_s1p_s2pPP1_s3pp_s4pp])
    Reac940.kcst = 3.3333e6
    Reac941 = smodel.Reac('Reac941', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pp_s4pp], rhs =[CaMKII_s1p_s2p_s3pp_s4pp, PP1])
    Reac941.kcst = 8
    Reac942 = smodel.Reac('Reac942', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pp_s4pp], rhs = [CaMKII_s1p_s2_s3pp_s4pp, PP1])
    Reac942.kcst = 2
    
    #CaMKII_s1p_s2p_s3pp_s4pp + PP1 <-> CaMKII_s1p_s2p_s3ppPP1_s4pp-> CaMKII_s1p_s2p_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac943 = smodel.Reac('Reac943', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp, PP1], rhs = [CaMKII_s1p_s2p_s3ppPP1_s4pp])
    Reac943.kcst = 3.3333e6
    Reac944 = smodel.Reac('Reac944', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP1_s4pp], rhs =[CaMKII_s1p_s2p_s3pp_s4pp, PP1])
    Reac944.kcst = 8
    Reac945 = smodel.Reac('Reac945', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP1_s4pp], rhs = [CaMKII_s1p_s2p_s3p_s4pp, PP1])
    Reac945.kcst = 2
    
    #CaMKII_s1p_s2p_s3pp_s4pp + PP1 <-> CaMKII_s1p_s2p_s3pp_s4ppPP1-> CaMKII_s1p_s2p_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac946 = smodel.Reac('Reac946', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp, PP1], rhs = [CaMKII_s1p_s2p_s3pp_s4ppPP1])
    Reac946.kcst = 3.3333e6
    Reac947 = smodel.Reac('Reac947', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4ppPP1], rhs =[CaMKII_s1p_s2p_s3pp_s4pp, PP1])
    Reac947.kcst = 8
    Reac948 = smodel.Reac('Reac948', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4ppPP1], rhs = [CaMKII_s1p_s2p_s3pp_s4p, PP1])
    Reac948.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1pPP1_s2pp_s3pp_s4pp-> CaMKII_s1_s2pp_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac949 = smodel.Reac('Reac949', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1pPP1_s2pp_s3pp_s4pp])
    Reac949.kcst = 3.3333e6
    Reac950 = smodel.Reac('Reac950', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pp_s4pp], rhs =[CaMKII_s1p_s2pp_s3pp_s4pp, PP1])
    Reac950.kcst = 8
    Reac951 = smodel.Reac('Reac951', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pp_s4pp], rhs = [CaMKII_s1_s2pp_s3pp_s4pp, PP1])
    Reac951.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1p_s2ppPP1_s3pp_s4pp-> CaMKII_s1p_s2p_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac952 = smodel.Reac('Reac952', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1p_s2ppPP1_s3pp_s4pp])
    Reac952.kcst = 3.3333e6
    Reac953 = smodel.Reac('Reac953', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pp_s4pp], rhs =[CaMKII_s1p_s2pp_s3pp_s4pp, PP1])
    Reac953.kcst = 8
    Reac954 = smodel.Reac('Reac954', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pp_s4pp], rhs = [CaMKII_s1p_s2p_s3pp_s4pp, PP1])
    Reac954.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1p_s2pp_s3ppPP1_s4pp-> CaMKII_s1p_s2pp_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac955 = smodel.Reac('Reac955', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1p_s2pp_s3ppPP1_s4pp])
    Reac955.kcst = 3.3333e6
    Reac956 = smodel.Reac('Reac956', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP1_s4pp], rhs =[CaMKII_s1p_s2pp_s3pp_s4pp, PP1])
    Reac956.kcst = 8
    Reac957 = smodel.Reac('Reac957', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP1_s4pp], rhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP1])
    Reac957.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1p_s2pp_s3pp_s4ppPP1-> CaMKII_s1p_s2pp_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac958 = smodel.Reac('Reac958', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP1])
    Reac958.kcst = 3.3333e6
    Reac959 = smodel.Reac('Reac959', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP1], rhs =[CaMKII_s1p_s2pp_s3pp_s4pp, PP1])
    Reac959.kcst = 8
    Reac960 = smodel.Reac('Reac960', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP1], rhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP1])
    Reac960.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1ppPP1_s2pp_s3pp_s4pp-> CaMKII_s1p_s2pp_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac961 = smodel.Reac('Reac961', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1ppPP1_s2pp_s3pp_s4pp])
    Reac961.kcst = 3.3333e6
    Reac962 = smodel.Reac('Reac962', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pp_s4pp], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pp, PP1])
    Reac962.kcst = 8
    Reac963 = smodel.Reac('Reac963', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pp_s4pp], rhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP1])
    Reac963.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1p_s2pp_s3pp_s4ppPP1-> CaMKII_s1p_s2pp_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac964 = smodel.Reac('Reac964', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP1])
    Reac964.kcst = 3.3333e6
    Reac965 = smodel.Reac('Reac965', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP1], rhs =[CaMKII_s1p_s2pp_s3pp_s4pp, PP1])
    Reac965.kcst = 8
    Reac966 = smodel.Reac('Reac966', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP1], rhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP1])
    Reac966.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1pp_s2pp_s3ppPP1_s4pp-> CaMKII_s1pp_s2pp_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac967 = smodel.Reac('Reac967', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1pp_s2pp_s3ppPP1_s4pp])
    Reac967.kcst = 3.3333e6
    Reac968 = smodel.Reac('Reac968', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP1_s4pp], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pp, PP1])
    Reac968.kcst = 8
    Reac969 = smodel.Reac('Reac969', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP1_s4pp], rhs = [CaMKII_s1pp_s2pp_s3p_s4pp, PP1])
    Reac969.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pp_s4pp + PP1 <-> CaMKII_s1pp_s2pp_s3pp_s4ppPP1-> CaMKII_s1pp_s2pp_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac970 = smodel.Reac('Reac970', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1pp_s2pp_s3pp_s4ppPP1])
    Reac970.kcst = 3.3333e6
    Reac971 = smodel.Reac('Reac971', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4ppPP1], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pp, PP1])
    Reac971.kcst = 8
    Reac972 = smodel.Reac('Reac972', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4ppPP1], rhs = [CaMKII_s1pp_s2pp_s3pp_s4p, PP1])
    Reac972.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pp-> CaMKII_s1_s2pCaM3Ca_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac973 = smodel.Reac('Reac973', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pp])
    Reac973.kcst = 3.3333e6
    Reac974 = smodel.Reac('Reac974', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac974.kcst = 8
    Reac975 = smodel.Reac('Reac975', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac975.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pp-> CaMKII_s1p_s2CaM3Ca_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac976 = smodel.Reac('Reac976', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pp])
    Reac976.kcst = 3.3333e6
    Reac977 = smodel.Reac('Reac977', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac977.kcst = 8
    Reac978 = smodel.Reac('Reac978', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pp], rhs = [CaMKII_s1p_s2CaM3Ca_s3pp_s4pp, PP1])
    Reac978.kcst = 2

    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac979 = smodel.Reac('Reac979', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pp])
    Reac979.kcst = 3.3333e6
    Reac980 = smodel.Reac('Reac980', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac980.kcst = 8
    Reac981 = smodel.Reac('Reac981', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac981.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP1-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac982 = smodel.Reac('Reac982', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP1])
    Reac982.kcst = 3.3333e6
    Reac983 = smodel.Reac('Reac983', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP1], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac983.kcst = 8
    Reac984 = smodel.Reac('Reac984', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac984.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac985 = smodel.Reac('Reac985', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pp])
    Reac985.kcst = 3.3333e6
    Reac986 = smodel.Reac('Reac986', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac986.kcst = 8
    Reac987 = smodel.Reac('Reac987', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac987.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pp-> CaMKII_s1pp_s2CaM3Ca_s3pp_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac988 = smodel.Reac('Reac988', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pp])
    Reac988.kcst = 3.3333e6
    Reac989 = smodel.Reac('Reac989', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac989.kcst = 8
    Reac990 = smodel.Reac('Reac990', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pp], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pp_s4pp, PP1])
    Reac990.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pp-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac991 = smodel.Reac('Reac991', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pp])
    Reac991.kcst = 3.3333e6
    Reac992 = smodel.Reac('Reac992', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac992.kcst = 8
    Reac993 = smodel.Reac('Reac993', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pp], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac993.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP1-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac994 = smodel.Reac('Reac994', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP1])
    Reac994.kcst = 3.3333e6
    Reac995 = smodel.Reac('Reac995', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP1], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac995.kcst = 8
    Reac996 = smodel.Reac('Reac996', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac996.kcst = 2
    
    ####dephosphorylation by PP2A
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac997 = smodel.Reac('Reac997', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac997.kcst = 0.2e6
    Reac998 = smodel.Reac('Reac998', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac998.kcst = 0.8
    Reac999 = smodel.Reac('Reac999', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac999.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4p-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1000 = smodel.Reac('Reac1000', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac1000.kcst = 0.2e6
    Reac1001 = smodel.Reac('Reac1001', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac1001.kcst = 0.8
    Reac1002 = smodel.Reac('Reac1002', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac1002.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4p-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1003 = smodel.Reac('Reac1003', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4p])
    Reac1003.kcst = 0.2e6
    Reac1004 = smodel.Reac('Reac1004', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac1004.kcst = 0.8
    Reac1005 = smodel.Reac('Reac1005', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4p, PP2A])
    Reac1005.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4 + PP2A #dephosphorylation at T286/CaM
    Reac1006 = smodel.Reac('Reac1006', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A])
    Reac1006.kcst = 0.2e6
    Reac1007 = smodel.Reac('Reac1007', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac1007.kcst = 0.8
    Reac1008 = smodel.Reac('Reac1008', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4, PP2A])
    Reac1008.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1009 = smodel.Reac('Reac1009', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1009.kcst = 0.2e6
    Reac1010 = smodel.Reac('Reac1010', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1010.kcst = 0.8
    Reac1011 = smodel.Reac('Reac1011', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1011.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1012 = smodel.Reac('Reac1012', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp])
    Reac1012.kcst = 0.2e6
    Reac1013 = smodel.Reac('Reac1013', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1013.kcst = 0.8
    Reac1014 = smodel.Reac('Reac1014', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1014.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1015 = smodel.Reac('Reac1015', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp])
    Reac1015.kcst = 0.2e6
    Reac1016 = smodel.Reac('Reac1016', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1016.kcst = 0.8
    Reac1017 = smodel.Reac('Reac1017', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pp, PP2A])
    Reac1017.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1018 = smodel.Reac('Reac1018', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A])
    Reac1018.kcst = 0.2e6
    Reac1019 = smodel.Reac('Reac1019', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1019.kcst = 0.8
    Reac1020 = smodel.Reac('Reac1020', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac1020.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pp-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1021 = smodel.Reac('Reac1021', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pp])
    Reac1021.kcst = 0.2e6
    Reac1022 = smodel.Reac('Reac1022', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1022.kcst = 0.8
    Reac1023 = smodel.Reac('Reac1023', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1023.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pp-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1024 = smodel.Reac('Reac1024', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pp])
    Reac1024.kcst = 0.2e6
    Reac1025 = smodel.Reac('Reac1025', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1025.kcst = 0.8
    Reac1026 = smodel.Reac('Reac1026', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pp, PP2A])
    Reac1026.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pp-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1027 = smodel.Reac('Reac1027', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pp])
    Reac1027.kcst = 0.2e6
    Reac1028 = smodel.Reac('Reac1028', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1028.kcst = 0.8
    Reac1029 = smodel.Reac('Reac1029', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pp, PP2A])
    Reac1029.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP2A-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1030 = smodel.Reac('Reac1030', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP2A])
    Reac1030.kcst = 0.2e6
    Reac1031 = smodel.Reac('Reac1031', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1031.kcst = 0.8
    Reac1032 = smodel.Reac('Reac1032', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4ppPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac1032.kcst = 0.2
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pp-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1033 = smodel.Reac('Reac1033', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pp])
    Reac1033.kcst = 0.2e6
    Reac1034 = smodel.Reac('Reac1034', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1034.kcst = 0.8
    Reac1035 = smodel.Reac('Reac1035', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1035.kcst = 0.2

    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pp-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1036 = smodel.Reac('Reac1036', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pp])
    Reac1036.kcst = 0.2e6
    Reac1037 = smodel.Reac('Reac1037', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1037.kcst = 0.8
    Reac1038 = smodel.Reac('Reac1038', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pp, PP2A])
    Reac1038.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pp-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1039 = smodel.Reac('Reac1039', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pp])
    Reac1039.kcst = 0.2e6
    Reac1040 = smodel.Reac('Reac1040', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1040.kcst = 0.8
    Reac1041 = smodel.Reac('Reac1041', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1041.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP2A-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1042 = smodel.Reac('Reac1042', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP2A])
    Reac1042.kcst = 0.2e6
    Reac1043 = smodel.Reac('Reac1043', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1043.kcst = 0.8
    Reac1044 = smodel.Reac('Reac1044', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4ppPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1044.kcst = 0.2

    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pp-> CaMKII_s1CaM3Ca_s2p_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1045 = smodel.Reac('Reac1045', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pp])
    Reac1045.kcst = 0.2e6
    Reac1046 = smodel.Reac('Reac1046', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP2A])
    Reac1046.kcst = 0.8
    Reac1047 = smodel.Reac('Reac1047', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pp], rhs = [CaMKII_s1CaM3Ca_s2p_s3pp_s4pp, PP2A])
    Reac1047.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pp-> CaMKII_s1pCaM3Ca_s2_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1048 = smodel.Reac('Reac1048', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pp])
    Reac1048.kcst = 0.2e6
    Reac1049 = smodel.Reac('Reac1049', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP2A])
    Reac1049.kcst = 0.8
    Reac1050 = smodel.Reac('Reac1050', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2_s3pp_s4pp, PP2A])
    Reac1050.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1051 = smodel.Reac('Reac1051', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pp])
    Reac1051.kcst = 0.2e6
    Reac1052 = smodel.Reac('Reac1052', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP2A])
    Reac1052.kcst = 0.8
    Reac1053 = smodel.Reac('Reac1053', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2_s3pp_s4pp, PP2A])
    Reac1053.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP2A-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1054 = smodel.Reac('Reac1054', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP2A])
    Reac1054.kcst = 0.2e6
    Reac1055 = smodel.Reac('Reac1055', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP2A], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP2A])
    Reac1055.kcst = 0.8
    Reac1056 = smodel.Reac('Reac1056', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4ppPP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP2A])
    Reac1056.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pp-> CaMKII_s1CaM3Ca_s2pp_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1057 = smodel.Reac('Reac1057', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pp])
    Reac1057.kcst = 0.2e6
    Reac1058 = smodel.Reac('Reac1058', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP2A])
    Reac1058kcst = 0.8
    Reac1059 = smodel.Reac('Reac1059', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pp_s4pp, PP2A])
    Reac1059.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1060 = smodel.Reac('Reac1060', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pp])
    Reac1060.kcst = 0.2e6
    Reac1061 = smodel.Reac('Reac10601', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP2A])
    Reac1061.kcst = 0.8
    Reac1062 = smodel.Reac('Reac1062', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, PP2A])
    Reac1062.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pp-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1063 = smodel.Reac('Reac1063', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pp])
    Reac1063.kcst = 0.2e6
    Reac1064 = smodel.Reac('Reac1064', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP2A])
    Reac1064.kcst = 0.8
    Reac1065 = smodel.Reac('Reac1065', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP2A])
    Reac1065.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP2A-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1066 = smodel.Reac('Reac1066', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP2A])
    Reac1066.kcst = 0.2e6
    Reac1067 = smodel.Reac('Reac1067', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp, PP2A])
    Reac1067.kcst = 0.8
    Reac1068 = smodel.Reac('Reac1068', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4ppPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP2A])
    Reac1068.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pp_s4pp + PP2A <-> CaMKII_s1pPP2A_s2p_s3pp_s4pp-> CaMKII_s1_s2p_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1069 = smodel.Reac('Reac1069', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pPP2A_s2p_s3pp_s4pp])
    Reac1069.kcst = 0.2e6
    Reac1070 = smodel.Reac('Reac1070', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pp_s4pp], rhs =[CaMKII_s1p_s2p_s3pp_s4pp, PP2A])
    Reac1070.kcst = 0.8
    Reac1071 = smodel.Reac('Reac1071', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pp_s4pp], rhs = [CaMKII_s1_s2p_s3pp_s4pp, PP2A])
    Reac1071.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pp_s4pp + PP2A <-> CaMKII_s1p_s2pPP2A_s3pp_s4pp-> CaMKII_s1p_s2_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1072 = smodel.Reac('Reac1072', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp, PP2A], rhs = [CaMKII_s1p_s2pPP2A_s3pp_s4pp])
    Reac1072.kcst = 0.2e6
    Reac1073 = smodel.Reac('Reac1073', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pp_s4pp], rhs =[CaMKII_s1p_s2p_s3pp_s4pp, PP2A])
    Reac1073.kcst = 0.8
    Reac1074 = smodel.Reac('Reac1074', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pp_s4pp], rhs = [CaMKII_s1p_s2_s3pp_s4pp, PP2A])
    Reac1074.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pp_s4pp + PP2A <-> CaMKII_s1p_s2p_s3ppPP2A_s4pp-> CaMKII_s1p_s2p_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1075 = smodel.Reac('Reac1075', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp, PP2A], rhs = [CaMKII_s1p_s2p_s3ppPP2A_s4pp])
    Reac1075.kcst = 0.2e6
    Reac1076 = smodel.Reac('Reac1076', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP2A_s4pp], rhs =[CaMKII_s1p_s2p_s3pp_s4pp, PP2A])
    Reac1076.kcst = 0.8
    Reac1077 = smodel.Reac('Reac1077', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP2A_s4pp], rhs = [CaMKII_s1p_s2p_s3p_s4pp, PP2A])
    Reac1077.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pp_s4pp + PP2A <-> CaMKII_s1p_s2p_s3pp_s4ppPP2A-> CaMKII_s1p_s2p_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1078 = smodel.Reac('Reac1078', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pp, PP2A], rhs = [CaMKII_s1p_s2p_s3pp_s4ppPP2A])
    Reac1078.kcst = 0.2e6
    Reac1079 = smodel.Reac('Reac1079', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4ppPP2A], rhs =[CaMKII_s1p_s2p_s3pp_s4pp, PP2A])
    Reac1079.kcst = 0.8
    Reac1080 = smodel.Reac('Reac1080', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4ppPP2A], rhs = [CaMKII_s1p_s2p_s3pp_s4p, PP2A])
    Reac1080.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1pPP2A_s2pp_s3pp_s4pp-> CaMKII_s1_s2pp_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1081 = smodel.Reac('Reac1081', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pPP2A_s2pp_s3pp_s4pp])
    Reac1081.kcst = 0.2e6
    Reac1082 = smodel.Reac('Reac1082', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pp_s4pp], rhs =[CaMKII_s1p_s2pp_s3pp_s4pp, PP2A])
    Reac1082.kcst = 0.8
    Reac1083 = smodel.Reac('Reac1083', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pp_s4pp], rhs = [CaMKII_s1_s2pp_s3pp_s4pp, PP2A])
    Reac1083.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1p_s2ppPP2A_s3pp_s4pp-> CaMKII_s1p_s2p_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1084 = smodel.Reac('Reac1084', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1p_s2ppPP2A_s3pp_s4pp])
    Reac1084.kcst = 0.2e6
    Reac1085 = smodel.Reac('Reac1085', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pp_s4pp], rhs =[CaMKII_s1p_s2pp_s3pp_s4pp, PP2A])
    Reac1085.kcst = 0.8
    Reac1086 = smodel.Reac('Reac1086', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pp_s4pp], rhs = [CaMKII_s1p_s2p_s3pp_s4pp, PP2A])
    Reac1086.kcst = 0.2

    #CaMKII_s1p_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1p_s2pp_s3ppPP2A_s4pp-> CaMKII_s1p_s2pp_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1087 = smodel.Reac('Reac1087', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1p_s2pp_s3ppPP2A_s4pp])
    Reac1087.kcst = 0.2e6
    Reac1088 = smodel.Reac('Reac1088', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP2A_s4pp], rhs =[CaMKII_s1p_s2pp_s3pp_s4pp, PP2A])
    Reac1088.kcst = 0.8
    Reac1089 = smodel.Reac('Reac1089', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP2A_s4pp], rhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP2A])
    Reac1089.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1p_s2pp_s3pp_s4ppPP2A-> CaMKII_s1p_s2pp_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1090 = smodel.Reac('Reac1090', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP2A])
    Reac1090.kcst = 0.2e6
    Reac1091 = smodel.Reac('Reac1091', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP2A], rhs =[CaMKII_s1p_s2pp_s3pp_s4pp, PP2A])
    Reac1091.kcst = 0.8
    Reac1092 = smodel.Reac('Reac1092', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP2A], rhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP2A])
    Reac1092.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1ppPP2A_s2pp_s3pp_s4pp-> CaMKII_s1p_s2pp_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1093 = smodel.Reac('Reac1093', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1ppPP2A_s2pp_s3pp_s4pp])
    Reac1093.kcst = 0.2e6
    Reac1094 = smodel.Reac('Reac1094', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pp_s4pp], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pp, PP2A])
    Reac1094.kcst = 0.8
    Reac1095 = smodel.Reac('Reac1095', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pp_s4pp], rhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP2A])
    Reac1095.kcst = 0.2

    #CaMKII_s1p_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1p_s2pp_s3pp_s4ppPP2A-> CaMKII_s1p_s2pp_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1096 = smodel.Reac('Reac1096', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP2A])
    Reac1096.kcst = 0.2e6
    Reac1097 = smodel.Reac('Reac1097', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP2A], rhs =[CaMKII_s1p_s2pp_s3pp_s4pp, PP2A])
    Reac1097.kcst = 0.8
    Reac1098 = smodel.Reac('Reac1098', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4ppPP2A], rhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP2A])
    Reac1098.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1pp_s2pp_s3ppPP2A_s4pp-> CaMKII_s1pp_s2pp_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1099 = smodel.Reac('Reac1099', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pp_s3ppPP2A_s4pp])
    Reac1099.kcst = 0.2e6
    Reac1100 = smodel.Reac('Reac1100', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP2A_s4pp], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pp, PP2A])
    Reac1100.kcst = 0.8
    Reac1101 = smodel.Reac('Reac1101', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP2A_s4pp], rhs = [CaMKII_s1pp_s2pp_s3p_s4pp, PP2A])
    Reac1101.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pp_s4pp + PP2A <-> CaMKII_s1pp_s2pp_s3pp_s4ppPP2A-> CaMKII_s1pp_s2pp_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1102 = smodel.Reac('Reac1102', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pp_s4ppPP2A])
    Reac1102.kcst = 0.2e6
    Reac1103 = smodel.Reac('Reac1103', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4ppPP2A], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pp, PP2A])
    Reac1103.kcst = 0.8
    Reac1104= smodel.Reac('Reac1104', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4ppPP2A], rhs = [CaMKII_s1pp_s2pp_s3pp_s4p, PP2A])
    Reac1104.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pp-> CaMKII_s1_s2pCaM3Ca_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1105 = smodel.Reac('Reac1105', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pp])
    Reac1105.kcst = 0.2e6
    Reac1106 = smodel.Reac('Reac1106', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1106.kcst = 0.8
    Reac1107 = smodel.Reac('Reac1107', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1107.kcst = 0.2

    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pp-> CaMKII_s1p_s2CaM3Ca_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1108 = smodel.Reac('Reac1108', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pp])
    Reac1108.kcst = 0.2e6
    Reac1109 = smodel.Reac('Reac1109', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1109.kcst = 0.8
    Reac1110 = smodel.Reac('Reac1110', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pp], rhs = [CaMKII_s1p_s2CaM3Ca_s3pp_s4pp, PP2A])
    Reac1110.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1111 = smodel.Reac('Reac1111', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pp])
    Reac1111.kcst = 0.2e6
    Reac1112 = smodel.Reac('Reac1112', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1112.kcst = 0.8
    Reac1113 = smodel.Reac('Reac1113', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1113.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP2A-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1114 = smodel.Reac('Reac1114', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP2A])
    Reac1114.kcst = 0.2e6
    Reac1115 = smodel.Reac('Reac1115', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP2A], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1115.kcst = 0.8
    Reac1116 = smodel.Reac('Reac1116', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4ppPP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1116.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1117 = smodel.Reac('Reac1117', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pp])
    Reac1117.kcst = 0.2e6
    Reac1118 = smodel.Reac('Reac1118', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1118.kcst = 0.8
    Reac1119 = smodel.Reac('Reac1119', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1119.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pp-> CaMKII_s1pp_s2CaM3Ca_s3pp_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1120 = smodel.Reac('Reac1120', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pp])
    Reac1120.kcst = 0.2e6
    Reac1121 = smodel.Reac('Reac1121', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1121.kcst = 0.8
    Reac1122 = smodel.Reac('Reac1122', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pp], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pp_s4pp, PP2A])
    Reac1122.kcst = 0.2

    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pp-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1123 = smodel.Reac('Reac1123', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pp])
    Reac1123.kcst = 0.2e6
    Reac1124 = smodel.Reac('Reac1124', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1124.kcst = 0.8
    Reac1125 = smodel.Reac('Reac1125', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pp], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1125.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP2A-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1126 = smodel.Reac('Reac1126', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP2A])
    Reac1126.kcst = 0.2e6
    Reac1127 = smodel.Reac('Reac1127', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP2A], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac1127.kcst = 0.8
    Reac1128 = smodel.Reac('Reac1128', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4ppPP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1128.kcst = 0.2

    #4 subunits phosphorylation at Thr305
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1129 = smodel.Reac('Reac1129', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp])
    Reac1129.kcst = kon_cam_t286
    Reac1130 = smodel.Reac('Reac1130', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, CaM3Ca])
    Reac1130.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4pp -> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp #autophosphorylation at Thr305
    Reac1131 = smodel.Reac('Reac1131', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp])
    Reac1131.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4pp -> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp #autophosphorylation at Thr305
    Reac1132 = smodel.Reac('Reac1132', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp])
    Reac1132.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp -> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac1133 = smodel.Reac('Reac1133', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp])
    Reac1133.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3p_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1134 = smodel.Reac('Reac1134', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp])
    Reac1134.kcst = kon_cam_t286
    Reac1135 = smodel.Reac('Reac1135', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp], rhs = [CaMKII_s1p_s2pp_s3p_s4pp, CaM3Ca])
    Reac1135.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3p_s4pp -> CaMKII_s1p_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac1136 = smodel.Reac('Reac1136', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp], rhs = [CaMKII_s1p_s2pp_s3pp_s4pp])
    Reac1136.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3p_s4pp -> CaMKII_s1pp_s2pp_s3p_s4pp #autophosphorylation at Thr305
    Reac1137 = smodel.Reac('Reac1137', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp], rhs = [CaMKII_s1pp_s2pp_s3p_s4pp])
    Reac1137.kcst = k_t350

    # CaMKII_s1pp_s2pp_s3p_s4pp -> CaMKII_s1pp_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac1138 = smodel.Reac('Reac1138', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pp], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pp])
    Reac1138.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1139 = smodel.Reac('Reac1139', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp])
    Reac1139.kcst = kon_cam_t286
    Reac1140 = smodel.Reac('Reac1140', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp], rhs = [CaMKII_s1p_s2p_s3p_s4pp, CaM3Ca])
    Reac1140.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3p_s4pp -> CaMKII_s1p_s2p_s3pp_s4pp #autophosphorylation at Thr305
    Reac1141 = smodel.Reac('Reac1141', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp], rhs = [CaMKII_s1p_s2p_s3pp_s4pp])
    Reac1141.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4pp -> CaMKII_s1p_s2pp_s3p_s4pp #autophosphorylation at Thr305
    Reac1142 = smodel.Reac('Reac1142', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp], rhs = [CaMKII_s1p_s2pp_s3p_s4pp])
    Reac1142.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4pp -> CaMKII_s1pp_s2p_s3p_s4pp #autophosphorylation at Thr305
    Reac1143 = smodel.Reac('Reac1143', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp], rhs = [CaMKII_s1pp_s2p_s3p_s4pp])
    Reac1143.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3p_s4pp -> CaMKII_s1pp_s2p_s3pp_s4pp #autophosphorylation at Thr305
    Reac1144 = smodel.Reac('Reac1144', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp], rhs = [CaMKII_s1pp_s2p_s3pp_s4pp])
    Reac1144.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3p_s4pp -> CaMKII_s1pp_s2pp_s3p_s4pp #autophosphorylation at Thr305
    Reac1145 = smodel.Reac('Reac1145', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp], rhs = [CaMKII_s1pp_s2pp_s3p_s4pp])
    Reac1145.kcst = k_t350
    
    # CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1146 = smodel.Reac('Reac1146', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp])
    Reac1146.kcst = kon_cam_t286
    Reac1147 = smodel.Reac('Reac1147', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, CaM3Ca])
    Reac1147.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3p_s4pp -> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp #autophosphorylation at Thr305
    Reac1148 = smodel.Reac('Reac1148', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp])
    Reac1148.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4pp + CaM3Ca <-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1149 = smodel.Reac('Reac1149', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp])
    Reac1149.kcst = kon_cam_t286
    Reac1150 = smodel.Reac('Reac1150', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1p_s2p_s3p_s4pp, CaM3Ca])
    Reac1150.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3p_s4pp -> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp #autophosphorylation at Thr305
    Reac1151 = smodel.Reac('Reac1151', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp])
    Reac1151.kcst = k_t350
    
    # CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp -> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp #autophosphorylation at Thr305
    Reac1152 = smodel.Reac('Reac1152', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp])
    Reac1152.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3p_s4pp + CaM3Ca <-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1153 = smodel.Reac('Reac1153', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp])
    Reac1153.kcst = kon_cam_t286
    Reac1154 = smodel.Reac('Reac1154', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1pp_s2p_s3p_s4pp, CaM3Ca])
    Reac1154.kcst = koff_cam_t286
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pp-> CaMKII_s1CaM3Ca_s2p_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1155 = smodel.Reac('Reac1155', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pp])
    Reac1155.kcst = 3.3333e6
    Reac1156 = smodel.Reac('Reac1156', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP1])
    Reac1156.kcst = 8
    Reac1157 = smodel.Reac('Reac1157', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pp], rhs = [CaMKII_s1CaM3Ca_s2p_s3p_s4pp, PP1])
    Reac1157.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pp-> CaMKII_s1pCaM3Ca_s2_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1158 = smodel.Reac('Reac1158', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pp])
    Reac1158.kcst = 3.3333e6
    Reac1159 = smodel.Reac('Reac1159', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP1])
    Reac1159.kcst = 8
    Reac1160 = smodel.Reac('Reac1160', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2_s3p_s4pp, PP1])
    Reac1160.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1161 = smodel.Reac('Reac1161', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pp])
    Reac1161.kcst = 3.3333e6
    Reac1162 = smodel.Reac('Reac1162', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP1])
    Reac1162.kcst = 8
    Reac1163 = smodel.Reac('Reac1163', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4pp, PP1])
    Reac1163.kcst = 2

    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP1-> CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1164 = smodel.Reac('Reac1164', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP1])
    Reac1164.kcst = 3.3333e6
    Reac1165 = smodel.Reac('Reac1165', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP1], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP1])
    Reac1165.kcst = 8
    Reac1166 = smodel.Reac('Reac1166', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP1])
    Reac1166.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pp-> CaMKII_s1CaM3Ca_s2pp_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1167 = smodel.Reac('Reac1167', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pp])
    Reac1167.kcst = 3.3333e6
    Reac1168 = smodel.Reac('Reac1168', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP1])
    Reac1168.kcst = 8
    Reac1169 = smodel.Reac('Reac1169', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pp_s3p_s4pp, PP1])
    Reac1169.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1170 = smodel.Reac('Reac1170', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pp])
    Reac1170.kcst = 3.3333e6
    Reac1171 = smodel.Reac('Reac1171', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP1])
    Reac1171.kcst = 8
    Reac1172 = smodel.Reac('Reac1172', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP1])
    Reac1172.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pp-> CaMKII_s1pCaM3Ca_s2pp_s3_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1173 = smodel.Reac('Reac1173', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pp])
    Reac1173.kcst = 3.3333e6
    Reac1174 = smodel.Reac('Reac1174', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP1])
    Reac1174.kcst = 8
    Reac1175 = smodel.Reac('Reac1175', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4pp, PP1])
    Reac1175.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP1-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1176 = smodel.Reac('Reac1176', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP1])
    Reac1176.kcst = 3.3333e6
    Reac1177 = smodel.Reac('Reac1177', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP1], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP1])
    Reac1177.kcst = 8
    Reac1178 = smodel.Reac('Reac1178', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP1])
    Reac1178.kcst = 2
    
    #CaMKII_s1p_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1pPP1_s2pp_s3p_s4pp-> CaMKII_s1_s2pp_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1179 = smodel.Reac('Reac1179', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1pPP1_s2pp_s3p_s4pp])
    Reac1179.kcst = 3.3333e6
    Reac1180 = smodel.Reac('Reac1180', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3p_s4pp], rhs =[CaMKII_s1p_s2pp_s3p_s4pp, PP1])
    Reac1180.kcst = 8
    Reac1181 = smodel.Reac('Reac1181', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3p_s4pp], rhs = [CaMKII_s1_s2pp_s3p_s4pp, PP1])
    Reac1181.kcst = 2
    
    #CaMKII_s1p_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1p_s2ppPP1_s3p_s4pp-> CaMKII_s1p_s2p_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1182 = smodel.Reac('Reac1182', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1p_s2ppPP1_s3p_s4pp])
    Reac1182.kcst = 3.3333e6
    Reac1183 = smodel.Reac('Reac1183', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3p_s4pp], rhs =[CaMKII_s1p_s2pp_s3p_s4pp, PP1])
    Reac1183.kcst = 8
    Reac1184 = smodel.Reac('Reac1184', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3p_s4pp], rhs = [CaMKII_s1p_s2p_s3p_s4pp, PP1])
    Reac1184.kcst = 2

    #CaMKII_s1p_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1p_s2pp_s3pPP1_s4pp-> CaMKII_s1p_s2pp_s3_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1185 = smodel.Reac('Reac1185', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1p_s2pp_s3pPP1_s4pp])
    Reac1185.kcst = 3.3333e6
    Reac1186 = smodel.Reac('Reac1186', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP1_s4pp], rhs =[CaMKII_s1p_s2pp_s3p_s4pp, PP1])
    Reac1186.kcst = 8
    Reac1187 = smodel.Reac('Reac1187', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP1_s4pp], rhs = [CaMKII_s1p_s2pp_s3_s4pp, PP1])
    Reac1187.kcst = 2
    
    #CaMKIIs1p_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1p_s2pp_s3p_s4ppPP1-> CaMKII_s1p_s2pp_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1188 = smodel.Reac('Reac1188', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1p_s2pp_s3p_s4ppPP1])
    Reac1188.kcst = 3.3333e6
    Reac1189 = smodel.Reac('Reac1189', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4ppPP1], rhs =[CaMKII_s1p_s2pp_s3p_s4pp, PP1])
    Reac1189.kcst = 8
    Reac1190 = smodel.Reac('Reac1190', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4ppPP1], rhs = [CaMKII_s1p_s2pp_s3p_s4p, PP1])
    Reac1190.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1ppPP1_s2pp_s3p_s4pp-> CaMKII_s1p_s2pp_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1191 = smodel.Reac('Reac1191', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1ppPP1_s2pp_s3p_s4pp])
    Reac1191.kcst = 3.3333e6
    Reac1192 = smodel.Reac('Reac1192', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3p_s4pp], rhs =[CaMKII_s1pp_s2pp_s3p_s4pp, PP1])
    Reac1192.kcst = 8
    Reac1193 = smodel.Reac('Reac1193', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3p_s4pp], rhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP1])
    Reac1193.kcst = 2

    #CaMKII_s1pp_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1pp_s2ppPP1_s3p_s4pp-> CaMKII_s1pp_s2p_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1194 = smodel.Reac('Reac1194', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1pp_s2ppPP1_s3p_s4pp])
    Reac1194.kcst = 3.3333e6
    Reac1195 = smodel.Reac('Reac1195', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3p_s4pp], rhs =[CaMKII_s1pp_s2pp_s3p_s4pp, PP1])
    Reac1195.kcst = 8
    Reac1196 = smodel.Reac('Reac1196', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3p_s4pp], rhs = [CaMKII_s1pp_s2p_s3p_s4pp, PP1])
    Reac1196.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1pp_s2pp_s3pPP1_s4pp-> CaMKII_s1pp_s2pp_s3_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1197 = smodel.Reac('Reac1197', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1pp_s2pp_s3pPP1_s4pp])
    Reac1197.kcst = 3.3333e6
    Reac1198 = smodel.Reac('Reac1198', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP1_s4pp], rhs =[CaMKII_s1pp_s2pp_s3p_s4pp, PP1])
    Reac1198.kcst = 8
    Reac1199 = smodel.Reac('Reac1199', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP1_s4pp], rhs = [CaMKII_s1pp_s2pp_s3_s4pp, PP1])
    Reac1199.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3p_s4pp + PP1 <-> CaMKII_s1pp_s2pp_s3p_s4ppPP1-> CaMKII_s1pp_s2pp_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1200 = smodel.Reac('Reac1200', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1pp_s2pp_s3p_s4ppPP1])
    Reac1200.kcst = 3.3333e6
    Reac1201 = smodel.Reac('Reac1201', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4ppPP1], rhs =[CaMKII_s1pp_s2pp_s3p_s4pp, PP1])
    Reac1201.kcst = 8
    Reac1202 = smodel.Reac('Reac1202', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4ppPP1], rhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP1])
    Reac1202.kcst = 2
    
    #CaMKII_s1p_s2p_s3p_s4pp + PP1 <-> CaMKII_s1pPP1_s2p_s3p_s4pp-> CaMKII_s1_s2p_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1203 = smodel.Reac('Reac1203', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1pPP1_s2p_s3p_s4pp])
    Reac1203.kcst = 3.3333e6
    Reac1204 = smodel.Reac('Reac1204', vsys, lhs = [CaMKII_s1pPP1_s2p_s3p_s4pp], rhs =[CaMKII_s1p_s2p_s3p_s4pp, PP1])
    Reac1204.kcst = 8
    Reac1205 = smodel.Reac('Reac1205', vsys, lhs = [CaMKII_s1pPP1_s2p_s3p_s4pp], rhs = [CaMKII_s1_s2p_s3p_s4pp, PP1])
    Reac1205.kcst = 2
    
    #CaMKII_s1p_s2p_s3p_s4pp + PP1 <-> CaMKII_s1p_s2pPP1_s3p_s4pp-> CaMKII_s1p_s2_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1206 = smodel.Reac('Reac1206', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1p_s2pPP1_s3p_s4pp])
    Reac1206.kcst = 3.3333e6
    Reac1207 = smodel.Reac('Reac1207', vsys, lhs = [CaMKII_s1p_s2pPP1_s3p_s4pp], rhs =[CaMKII_s1p_s2p_s3p_s4pp, PP1])
    Reac1207.kcst = 8
    Reac1208 = smodel.Reac('Reac1208', vsys, lhs = [CaMKII_s1p_s2pPP1_s3p_s4pp], rhs = [CaMKII_s1p_s2_s3p_s4pp, PP1])
    Reac1208.kcst = 2
    
    #CaMKII_s1p_s2p_s3p_s4pp + PP1 <-> CaMKII_s1p_s2p_s3pPP1_s4pp-> CaMKII_s1p_s2p_s3_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1209 = smodel.Reac('Reac1209', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1p_s2p_s3pPP1_s4pp])
    Reac1209.kcst = 3.3333e6
    Reac1210 = smodel.Reac('Reac1210', vsys, lhs = [CaMKII_s1p_s2p_s3pPP1_s4pp], rhs =[CaMKII_s1p_s2p_s3p_s4pp, PP1])
    Reac1210.kcst = 8
    Reac1211 = smodel.Reac('Reac1211', vsys, lhs = [CaMKII_s1p_s2p_s3pPP1_s4pp], rhs = [CaMKII_s1p_s2p_s3_s4pp, PP1])
    Reac1211.kcst = 2
    
    #CaMKII_s1p_s2p_s3p_s4pp + PP1 <-> CaMKII_s1p_s2p_s3p_s4ppPP1-> CaMKII_s1p_s2p_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1212 = smodel.Reac('Reac1212', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1p_s2p_s3p_s4ppPP1])
    Reac1212.kcst = 3.3333e6
    Reac1213 = smodel.Reac('Reac1213', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4ppPP1], rhs =[CaMKII_s1p_s2p_s3p_s4pp, PP1])
    Reac1213.kcst = 8
    Reac1214 = smodel.Reac('Reac1214', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4ppPP1], rhs = [CaMKII_s1p_s2p_s3p_s4p, PP1])
    Reac1214.kcst = 2

    #CaMKII_s1pp_s2p_s3p_s4pp + PP1 <-> CaMKII_s1ppPP1_s2p_s3p_s4pp-> CaMKII_s1p_s2p_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1215 = smodel.Reac('Reac1215', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1ppPP1_s2p_s3p_s4pp])
    Reac1215.kcst = 3.3333e6
    Reac1216 = smodel.Reac('Reac1216', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3p_s4pp], rhs =[CaMKII_s1pp_s2p_s3p_s4pp, PP1])
    Reac1216.kcst = 8
    Reac1217 = smodel.Reac('Reac1217', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3p_s4pp], rhs = [CaMKII_s1p_s2p_s3p_s4pp, PP1])
    Reac1217.kcst = 2
    
    #CaMKII_s1pp_s2p_s3p_s4pp + PP1 <-> CaMKII_s1pp_s2pPP1_s3p_s4pp-> CaMKII_s1pp_s2_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1218 = smodel.Reac('Reac1218', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1pp_s2pPP1_s3p_s4pp])
    Reac1218.kcst = 3.3333e6
    Reac1219 = smodel.Reac('Reac1219', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3p_s4pp], rhs =[CaMKII_s1pp_s2p_s3p_s4pp, PP1])
    Reac1219.kcst = 8
    Reac1220 = smodel.Reac('Reac1220', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3p_s4pp], rhs = [CaMKII_s1pp_s2_s3p_s4pp, PP1])
    Reac1220.kcst = 2
    
    #CaMKII_s1pp_s2p_s3p_s4pp + PP1 <-> CaMKII_s1pp_s2p_s3pPP1_s4pp-> CaMKII_s1pp_s2p_s3_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1221 = smodel.Reac('Reac1221', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1pp_s2p_s3pPP1_s4pp])
    Reac1221.kcst = 3.3333e6
    Reac1222 = smodel.Reac('Reac1222', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP1_s4pp], rhs =[CaMKII_s1pp_s2p_s3p_s4pp, PP1])
    Reac1222.kcst = 8
    Reac1223 = smodel.Reac('Reac1223', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP1_s4pp], rhs = [CaMKII_s1pp_s2p_s3_s4pp, PP1])
    Reac1223.kcst = 2
    
    #CaMKII_s1pp_s2p_s3p_s4pp + PP1 <-> CaMKII_s1pp_s2p_s3p_s4ppPP1-> CaMKII_s1pp_s2p_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1224 = smodel.Reac('Reac1224', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1pp_s2p_s3p_s4ppPP1])
    Reac1224.kcst = 3.3333e6
    Reac1225 = smodel.Reac('Reac1225', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4ppPP1], rhs =[CaMKII_s1pp_s2p_s3p_s4pp, PP1])
    Reac1225.kcst = 8
    Reac1226 = smodel.Reac('Reac1226', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4ppPP1], rhs = [CaMKII_s1pp_s2p_s3p_s4p, PP1])
    Reac1226.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pp-> CaMKII_s1_s2pCaM3Ca_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1227 = smodel.Reac('Reac1227', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pp])
    Reac1227.kcst = 3.3333e6
    Reac1228 = smodel.Reac('Reac1228', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac1228.kcst = 8
    Reac1229 = smodel.Reac('Reac1229', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac1229.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pp-> CaMKII_s1p_s2CaM3Ca_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1230 = smodel.Reac('Reac1230', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pp])
    Reac1230.kcst = 3.3333e6
    Reac1231 = smodel.Reac('Reac1231', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac1231.kcst = 8
    Reac1232 = smodel.Reac('Reac1232', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pp], rhs = [CaMKII_s1p_s2CaM3Ca_s3p_s4pp, PP1])
    Reac1232.kcst = 2

    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1233 = smodel.Reac('Reac1233', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pp])
    Reac1233.kcst = 3.3333e6
    Reac1234 = smodel.Reac('Reac1234', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac1234.kcst = 8
    Reac1235 = smodel.Reac('Reac1235', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4pp, PP1])
    Reac1235.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP1-> CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1236 = smodel.Reac('Reac1236', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP1])
    Reac1236.kcst = 3.3333e6
    Reac1237 = smodel.Reac('Reac1237', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP1], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac1237.kcst = 8
    Reac1238 = smodel.Reac('Reac1238', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1238.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1239 = smodel.Reac('Reac1239', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pp])
    Reac1239.kcst = 3.3333e6
    Reac1240 = smodel.Reac('Reac1240', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac1240.kcst = 8
    Reac1241 = smodel.Reac('Reac1241', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac1241.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pp-> CaMKII_s1pp_s2CaM3Ca_s3p_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1242 = smodel.Reac('Reac1242', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pp])
    Reac1242.kcst = 3.3333e6
    Reac1243 = smodel.Reac('Reac1243', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac1243.kcst = 8
    Reac1244 = smodel.Reac('Reac1244', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pp], rhs = [CaMKII_s1pp_s2CaM3Ca_s3p_s4pp, PP1])
    Reac1244.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pp-> CaMKII_s1pp_s2pCaM3Ca_s3_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1245 = smodel.Reac('Reac1245', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pp])
    Reac1245.kcst = 3.3333e6
    Reac1246 = smodel.Reac('Reac1246', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac1246.kcst = 8
    Reac1247 = smodel.Reac('Reac1247', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pp], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4pp, PP1])
    Reac1247.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP1-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1248 = smodel.Reac('Reac1248', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP1])
    Reac1248.kcst = 3.3333e6
    Reac1249 = smodel.Reac('Reac1249', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP1], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac1249.kcst = 8
    Reac1250 = smodel.Reac('Reac1250', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1250.kcst = 2
    
    ###dephosphorylation by PP2A
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pp-> CaMKII_s1CaM3Ca_s2p_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1251 = smodel.Reac('Reac1251', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pp])
    Reac1251.kcst = 0.2e6
    Reac1252 = smodel.Reac('Reac1252', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP2A])
    Reac1252.kcst = 0.8
    Reac1253 = smodel.Reac('Reac1253', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pp], rhs = [CaMKII_s1CaM3Ca_s2p_s3p_s4pp, PP2A])
    Reac1253.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pp-> CaMKII_s1pCaM3Ca_s2_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1254 = smodel.Reac('Reac1254', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pp])
    Reac1254.kcst = 0.2e6
    Reac1255 = smodel.Reac('Reac1255', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP2A])
    Reac1255.kcst = 0.8
    Reac1256 = smodel.Reac('Reac1256', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2_s3p_s4pp, PP2A])
    Reac1256.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1257 = smodel.Reac('Reac1257', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pp])
    Reac1257.kcst = 0.2e6
    Reac1258 = smodel.Reac('Reac1258', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP2A])
    Reac1258.kcst = 0.8
    Reac1259 = smodel.Reac('Reac1259', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4pp, PP2A])
    Reac1259.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP2A-> CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1260 = smodel.Reac('Reac1260', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP2A])
    Reac1260.kcst = 0.2e6
    Reac1261 = smodel.Reac('Reac1261', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP2A], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP2A])
    Reac1261.kcst = 0.8
    Reac1262 = smodel.Reac('Reac1262', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4ppPP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP2A])
    Reac1262.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pp-> CaMKII_s1CaM3Ca_s2pp_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1263 = smodel.Reac('Reac1263', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pp])
    Reac1263.kcst = 0.2e6
    Reac1264 = smodel.Reac('Reac1264', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP2A])
    Reac1264.kcst = 0.8
    Reac1265 = smodel.Reac('Reac1265', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pp_s3p_s4pp, PP2A])
    Reac1265.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1266 = smodel.Reac('Reac1266', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pp])
    Reac1266.kcst = 0.2e6
    Reac1267 = smodel.Reac('Reac1267', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP2A])
    Reac1267.kcst = 0.8
    Reac1268 = smodel.Reac('Reac1268', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, PP2A])
    Reac1268.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pp-> CaMKII_s1pCaM3Ca_s2pp_s3_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1269 = smodel.Reac('Reac1269', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pp])
    Reac1269.kcst = 0.2e6
    Reac1270 = smodel.Reac('Reac1270', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP2A])
    Reac1270.kcst = 0.8
    Reac1271 = smodel.Reac('Reac1271', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4pp, PP2A])
    Reac1271.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP2A-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1272 = smodel.Reac('Reac1272', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP2A])
    Reac1272.kcst = 0.2e6
    Reac1273 = smodel.Reac('Reac1273', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, PP2A])
    Reac1273.kcst = 0.8
    Reac1274 = smodel.Reac('Reac1274', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4ppPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP2A])
    Reac1274.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1pPP2A_s2pp_s3p_s4pp-> CaMKII_s1_s2pp_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1275 = smodel.Reac('Reac1275', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1pPP2A_s2pp_s3p_s4pp])
    Reac1275.kcst = 0.2e6
    Reac1276 = smodel.Reac('Reac1276', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3p_s4pp], rhs =[CaMKII_s1p_s2pp_s3p_s4pp, PP2A])
    Reac1276.kcst = 0.8
    Reac1277 = smodel.Reac('Reac1277', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3p_s4pp], rhs = [CaMKII_s1_s2pp_s3p_s4pp, PP2A])
    Reac1277.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1p_s2ppPP2A_s3p_s4pp-> CaMKII_s1p_s2p_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1278 = smodel.Reac('Reac1278', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1p_s2ppPP2A_s3p_s4pp])
    Reac1278.kcst = 0.2e6
    Reac1279 = smodel.Reac('Reac1279', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3p_s4pp], rhs =[CaMKII_s1p_s2pp_s3p_s4pp, PP2A])
    Reac1279.kcst = 0.8
    Reac1280 = smodel.Reac('Reac1280', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3p_s4pp], rhs = [CaMKII_s1p_s2p_s3p_s4pp, PP2A])
    Reac1280.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1p_s2pp_s3pPP2A_s4pp-> CaMKII_s1p_s2pp_s3_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1281 = smodel.Reac('Reac1281', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1p_s2pp_s3pPP2A_s4pp])
    Reac1281.kcst = 0.2e6
    Reac1282 = smodel.Reac('Reac1282', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP2A_s4pp], rhs =[CaMKII_s1p_s2pp_s3p_s4pp, PP2A])
    Reac1282.kcst = 0.8
    Reac1283 = smodel.Reac('Reac1283', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP2A_s4pp], rhs = [CaMKII_s1p_s2pp_s3_s4pp, PP2A])
    Reac1283.kcst = 0.2

    #CaMKII_s1p_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1p_s2pp_s3p_s4ppPP2A-> CaMKII_s1p_s2pp_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1284 = smodel.Reac('Reac1284', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1p_s2pp_s3p_s4ppPP2A])
    Reac1284.kcst = 0.2e6
    Reac1285 = smodel.Reac('Reac1285', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4ppPP2A], rhs =[CaMKII_s1p_s2pp_s3p_s4pp, PP2A])
    Reac1285.kcst = 0.8
    Reac1286 = smodel.Reac('Reac1286', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4ppPP2A], rhs = [CaMKII_s1p_s2pp_s3p_s4p, PP2A])
    Reac1286.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1ppPP2A_s2pp_s3p_s4pp-> CaMKII_s1p_s2pp_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1287 = smodel.Reac('Reac1287', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1ppPP2A_s2pp_s3p_s4pp])
    Reac1287.kcst = 0.2e6
    Reac1288 = smodel.Reac('Reac1288', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3p_s4pp], rhs =[CaMKII_s1pp_s2pp_s3p_s4pp, PP2A])
    Reac1288.kcst = 0.8
    Reac1289 = smodel.Reac('Reac1289', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3p_s4pp], rhs = [CaMKII_s1p_s2pp_s3p_s4pp, PP2A])
    Reac1289.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1pp_s2ppPP2A_s3p_s4pp-> CaMKII_s1pp_s2p_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1290 = smodel.Reac('Reac1290', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1pp_s2ppPP2A_s3p_s4pp])
    Reac1290.kcst = 0.2e6
    Reac1291 = smodel.Reac('Reac1291', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3p_s4pp], rhs =[CaMKII_s1pp_s2pp_s3p_s4pp, PP2A])
    Reac1291.kcst = 0.8
    Reac1292 = smodel.Reac('Reac1292', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3p_s4pp], rhs = [CaMKII_s1pp_s2p_s3p_s4pp, PP2A])
    Reac1292.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1pp_s2pp_s3pPP2A_s4pp-> CaMKII_s1pp_s2pp_s3_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1293 = smodel.Reac('Reac1293', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pPP2A_s4pp])
    Reac1293.kcst = 0.2e6
    Reac1294 = smodel.Reac('Reac1294', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP2A_s4pp], rhs =[CaMKII_s1pp_s2pp_s3p_s4pp, PP2A])
    Reac1294.kcst = 0.8
    Reac1295 = smodel.Reac('Reac1295', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP2A_s4pp], rhs = [CaMKII_s1pp_s2pp_s3_s4pp, PP2A])
    Reac1295.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3p_s4pp + PP2A <-> CaMKII_s1pp_s2pp_s3p_s4ppPP2A-> CaMKII_s1pp_s2pp_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1296 = smodel.Reac('Reac1296', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pp_s3p_s4ppPP2A])
    Reac1296.kcst = 0.2e6
    Reac1297 = smodel.Reac('Reac1297', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4ppPP2A], rhs =[CaMKII_s1pp_s2pp_s3p_s4pp, PP2A])
    Reac1297.kcst = 0.8
    Reac1298 = smodel.Reac('Reac1298', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4ppPP2A], rhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP2A])
    Reac1298.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3p_s4pp + PP2A <-> CaMKII_s1pPP2A_s2p_s3p_s4pp-> CaMKII_s1_s2p_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1299 = smodel.Reac('Reac1299', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1pPP2A_s2p_s3p_s4pp])
    Reac1299.kcst = 0.2e6
    Reac1300 = smodel.Reac('Reac1300', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3p_s4pp], rhs =[CaMKII_s1p_s2p_s3p_s4pp, PP2A])
    Reac1300.kcst = 0.8
    Reac1301 = smodel.Reac('Reac1301', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3p_s4pp], rhs = [CaMKII_s1_s2p_s3p_s4pp, PP2A])
    Reac1301.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3p_s4pp + PP2A <-> CaMKII_s1p_s2pPP2A_s3p_s4pp-> CaMKII_s1p_s2_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1302 = smodel.Reac('Reac1302', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1p_s2pPP2A_s3p_s4pp])
    Reac1302.kcst = 0.2e6
    Reac1303 = smodel.Reac('Reac1303', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3p_s4pp], rhs =[CaMKII_s1p_s2p_s3p_s4pp, PP2A])
    Reac1303.kcst = 0.8
    Reac1304 = smodel.Reac('Reac1304', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3p_s4pp], rhs = [CaMKII_s1p_s2_s3p_s4pp, PP2A])
    Reac1304.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3p_s4pp + PP2A <-> CaMKII_s1p_s2p_s3pPP2A_s4pp-> CaMKII_s1p_s2p_s3_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1305 = smodel.Reac('Reac1305', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1p_s2p_s3pPP2A_s4pp])
    Reac1305.kcst = 0.2e6
    Reac1306 = smodel.Reac('Reac1306', vsys, lhs = [CaMKII_s1p_s2p_s3pPP2A_s4pp], rhs =[CaMKII_s1p_s2p_s3p_s4pp, PP2A])
    Reac1306.kcst = 0.8
    Reac1307 = smodel.Reac('Reac1307', vsys, lhs = [CaMKII_s1p_s2p_s3pPP2A_s4pp], rhs = [CaMKII_s1p_s2p_s3_s4pp, PP2A])
    Reac1307.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3p_s4pp + PP2A <-> CaMKII_s1p_s2p_s3p_s4ppPP2A-> CaMKII_s1p_s2p_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1308 = smodel.Reac('Reac1308', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1p_s2p_s3p_s4ppPP2A])
    Reac1308.kcst = 0.2e6
    Reac1309 = smodel.Reac('Reac1309', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4ppPP2A], rhs =[CaMKII_s1p_s2p_s3p_s4pp, PP2A])
    Reac1309.kcst = 0.8
    Reac1310 = smodel.Reac('Reac1310', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4ppPP2A], rhs = [CaMKII_s1p_s2p_s3p_s4p, PP2A])
    Reac1310.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3p_s4pp + PP2A <-> CaMKII_s1ppPP2A_s2p_s3p_s4pp-> CaMKII_s1p_s2p_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1311 = smodel.Reac('Reac1311', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1ppPP2A_s2p_s3p_s4pp])
    Reac1311.kcst = 0.2e6
    Reac1312 = smodel.Reac('Reac1312', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3p_s4pp], rhs =[CaMKII_s1pp_s2p_s3p_s4pp, PP2A])
    Reac1312.kcst = 0.8
    Reac1313 = smodel.Reac('Reac1313', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3p_s4pp], rhs = [CaMKII_s1p_s2p_s3p_s4pp, PP2A])
    Reac1313.kcst = 0.2

    #CaMKII_s1pp_s2p_s3p_s4pp + PP2A <-> CaMKII_s1pp_s2pPP2A_s3p_s4pp-> CaMKII_s1pp_s2_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1314 = smodel.Reac('Reac1314', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pPP2A_s3p_s4pp])
    Reac1314.kcst = 0.2e6
    Reac1315 = smodel.Reac('Reac1315', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3p_s4pp], rhs =[CaMKII_s1pp_s2p_s3p_s4pp, PP2A])
    Reac1315.kcst = 0.8
    Reac1316 = smodel.Reac('Reac1316', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3p_s4pp], rhs = [CaMKII_s1pp_s2_s3p_s4pp, PP2A])
    Reac1316.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3p_s4pp + PP2A <-> CaMKII_s1pp_s2p_s3pPP2A_s4pp-> CaMKII_s1pp_s2p_s3_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1317 = smodel.Reac('Reac1317', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1pp_s2p_s3pPP2A_s4pp])
    Reac1317.kcst = 0.2e6
    Reac1318 = smodel.Reac('Reac1318', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP2A_s4pp], rhs =[CaMKII_s1pp_s2p_s3p_s4pp, PP2A])
    Reac1318.kcst = 0.8
    Reac1319 = smodel.Reac('Reac1319', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP2A_s4pp], rhs = [CaMKII_s1pp_s2p_s3_s4pp, PP2A])
    Reac1319.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3p_s4pp + PP2A <-> CaMKII_s1pp_s2p_s3p_s4ppPP2A-> CaMKII_s1pp_s2p_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1320 = smodel.Reac('Reac1320', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1pp_s2p_s3p_s4ppPP2A])
    Reac1320.kcst = 0.2e6
    Reac1321 = smodel.Reac('Reac1321', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4ppPP2A], rhs =[CaMKII_s1pp_s2p_s3p_s4pp, PP2A])
    Reac1321.kcst = 0.8
    Reac1322 = smodel.Reac('Reac1322', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4ppPP2A], rhs = [CaMKII_s1pp_s2p_s3p_s4p, PP2A])
    Reac1322.kcst = 0.2

    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pp-> CaMKII_s1_s2pCaM3Ca_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1322a = smodel.Reac('Reac1322a', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pp])
    Reac1322a.kcst = 0.2e6
    Reac1323 = smodel.Reac('Reac1323', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1323.kcst = 0.8
    Reac1324 = smodel.Reac('Reac1324', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1324.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pp-> CaMKII_s1p_s2CaM3Ca_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1325 = smodel.Reac('Reac1325', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pp])
    Reac1325.kcst = 0.2e6
    Reac1326 = smodel.Reac('Reac1326', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1326.kcst = 0.8
    Reac1327 = smodel.Reac('Reac1327', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pp], rhs = [CaMKII_s1p_s2CaM3Ca_s3p_s4pp, PP2A])
    Reac1327.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1328 = smodel.Reac('Reac1328', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pp])
    Reac1328.kcst = 0.2e6
    Reac1329 = smodel.Reac('Reac1329', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1329.kcst = 0.8
    Reac1330 = smodel.Reac('Reac1330', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4pp, PP2A])
    Reac1330.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP2A-> CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1331 = smodel.Reac('Reac1331', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP2A])
    Reac1331.kcst = 0.2e6
    Reac1332 = smodel.Reac('Reac1332', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP2A], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1332.kcst = 0.8
    Reac1333 = smodel.Reac('Reac1333', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4ppPP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac1333.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1334 = smodel.Reac('Reac1334', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pp])
    Reac1334.kcst = 0.2e6
    Reac1335 = smodel.Reac('Reac1335', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1335.kcst = 0.8
    Reac1336 = smodel.Reac('Reac1336', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1336.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pp-> CaMKII_s1pp_s2CaM3Ca_s3p_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1337 = smodel.Reac('Reac1337', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pp])
    Reac1337.kcst = 0.2e6
    Reac1338 = smodel.Reac('Reac1338', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1338.kcst = 0.8
    Reac1339 = smodel.Reac('Reac1339', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pp], rhs = [CaMKII_s1pp_s2CaM3Ca_s3p_s4pp, PP2A])
    Reac1339.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pp-> CaMKII_s1pp_s2pCaM3Ca_s3_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1340 = smodel.Reac('Reac1340', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pp])
    Reac1340.kcst = 0.2e6
    Reac1341 = smodel.Reac('Reac1341', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1341.kcst = 0.8
    Reac1342 = smodel.Reac('Reac1342', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pp], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4pp, PP2A])
    Reac1342.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP2A-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1343 = smodel.Reac('Reac1343', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP2A])
    Reac1343.kcst = 0.2e6
    Reac1344 = smodel.Reac('Reac1344', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP2A], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac1344.kcst = 0.8
    Reac1345 = smodel.Reac('Reac1345', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4ppPP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac1345.kcst = 0.2
    
    #phosphorylation at thr305
    # CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1346 = smodel.Reac('Reac1346', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1346.kcst = kon_cam_t286
    Reac1347 = smodel.Reac('Reac1347', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, CaM3Ca])
    Reac1347.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1348 = smodel.Reac('Reac1348', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp])
    Reac1348.kcst = kon_cam_t286
    Reac1349 = smodel.Reac('Reac1349', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp, CaM3Ca])
    Reac1349.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp -> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1350 = smodel.Reac('Reac1350', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp])
    Reac1350.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1351 = smodel.Reac('Reac1351', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp])
    Reac1351.kcst = kon_cam_t286
    Reac1352 = smodel.Reac('Reac1352', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp, CaM3Ca])
    Reac1352.kcst = koff_cam_t286

    # CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1353 = smodel.Reac('Reac1353', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp])
    Reac1353.kcst = kon_cam_t286
    Reac1354 = smodel.Reac('Reac1354', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, CaM3Ca])
    Reac1354.kcst = koff_cam_t286
    
    #CaMKII_s1p_s2pp_s3p_s4pp + CaM3Ca <-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1355 = smodel.Reac('Reac1355', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp])
    Reac1355.kcst = kon_cam_t286
    Reac1356 = smodel.Reac('Reac1356', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2pp_s3p_s4pp, CaM3Ca])
    Reac1356.kcst = koff_cam_t286
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1357 = smodel.Reac('Reac1357', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp])
    Reac1357.kcst = kon_cam_t286
    Reac1358 = smodel.Reac('Reac1358', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, CaM3Ca])
    Reac1358.kcst = koff_cam_t286
    
    #CaMKII_s1p_s2p_s3p_s4pp + CaM3Ca <-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1359 = smodel.Reac('Reac1359', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp])
    Reac1359.kcst = kon_cam_t286
    Reac1360 = smodel.Reac('Reac1360', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2p_s3p_s4pp, CaM3Ca])
    Reac1360.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pCaM3Ca_s4pp -> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1361 = smodel.Reac('Reac1361', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp])
    Reac1361.kcst = k_t350
    
    #CaMKII_s1pp_s2p_s3p_s4pp + CaM3Ca <-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1362 = smodel.Reac('Reac1362', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp])
    Reac1362.kcst = kon_cam_t286
    Reac1363 = smodel.Reac('Reac1363', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2p_s3p_s4pp, CaM3Ca])
    Reac1363.kcst = koff_cam_t286

    # CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp -> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1364 = smodel.Reac('Reac1364', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp])
    Reac1364.kcst = k_t350
    
    #CaMKII_s1pp_s2pp_s3p_s4pp + CaM3Ca <-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1365 = smodel.Reac('Reac1365', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp])
    Reac1365.kcst = kon_cam_t286
    Reac1366 = smodel.Reac('Reac1366', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2pp_s3p_s4pp, CaM3Ca])
    Reac1366.kcst = koff_cam_t286
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1367 = smodel.Reac('Reac1367', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1367.kcst = kon_cam_t286
    Reac1368 = smodel.Reac('Reac1368', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, CaM3Ca])
    Reac1368.kcst = koff_cam_t286
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1369 = smodel.Reac('Reac1369', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1369.kcst = kon_cam_t286
    Reac1370 = smodel.Reac('Reac1370', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, CaM3Ca])
    Reac1370.kcst = koff_cam_t286
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pp + CaM3Ca <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1371 = smodel.Reac('Reac1371', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1371.kcst = kon_cam_t286
    Reac1372 = smodel.Reac('Reac1372', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp, CaM3Ca])
    Reac1372.kcst = koff_cam_t286

    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + CaM3Ca <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1373 = smodel.Reac('Reac1373', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1373.kcst = kon_cam_t286
    Reac1374 = smodel.Reac('Reac1374', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, CaM3Ca])
    Reac1374.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp -> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1375 = smodel.Reac('Reac1375', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1375.kcst = k_t350
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp + CaM3Ca <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1376 = smodel.Reac('Reac1376', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1376.kcst = kon_cam_t286
    Reac1377 = smodel.Reac('Reac1377', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp, CaM3Ca])
    Reac1377.kcst = koff_cam_t286

    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp + CaM3Ca <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1378 = smodel.Reac('Reac1378', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1378.kcst = kon_cam_t286
    Reac1379 = smodel.Reac('Reac1379', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, CaM3Ca])
    Reac1379.kcst = koff_cam_t286
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1380 = smodel.Reac('Reac1380', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac1380.kcst = kon_cam_t286
    Reac1381 = smodel.Reac('Reac1381', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, CaM3Ca])
    Reac1381.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp #autophosphorylation at Thr305
    Reac1382 = smodel.Reac('Reac1382', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp])
    Reac1382.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p #autophosphorylation at Thr305
    Reac1383 = smodel.Reac('Reac1383', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p])
    Reac1383.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp #autophosphorylation at Thr305
    Reac1384 = smodel.Reac('Reac1384', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp])
    Reac1384.kcst = k_t350
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1385= smodel.Reac('Reac1385', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p])
    Reac1385.kcst = kon_cam_t286
    Reac1386 = smodel.Reac('Reac1386', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, CaM3Ca])
    Reac1386.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3pp_s4p -> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp #autophosphorylation at Thr305
    Reac1387 = smodel.Reac('Reac1387', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp])
    Reac1387.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2p_s3pp_s4p -> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p #autophosphorylation at Thr305
    Reac1388 = smodel.Reac('Reac1388', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p])
    Reac1388.kcst = k_t350
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1389 = smodel.Reac('Reac1389', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p])
    Reac1389.kcst = kon_cam_t286
    Reac1390 = smodel.Reac('Reac1390', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, CaM3Ca])
    Reac1390.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3pp_s4p -> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp #autophosphorylation at Thr305
    Reac1391 = smodel.Reac('Reac1391', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp])
    Reac1391.kcst = k_t350
    
    #CaMKII_s1p_s2p_s3pp_s4p + CaM3Ca <-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4p  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1392 = smodel.Reac('Reac1392', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p])
    Reac1392.kcst = kon_cam_t286
    Reac1393 = smodel.Reac('Reac1393', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1p_s2p_s3pp_s4p, CaM3Ca])
    Reac1393.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pp_s4p -> CaMKII_s1p_s2p_s3pp_s4pp #autophosphorylation at Thr305
    Reac1394 = smodel.Reac('Reac1394', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p], rhs = [CaMKII_s1p_s2p_s3pp_s4pp])
    Reac1394.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3pp_s4p -> CaMKII_s1p_s2pp_s3pp_s4p #autophosphorylation at Thr305
    Reac1395 = smodel.Reac('Reac1395', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p], rhs = [CaMKII_s1p_s2pp_s3pp_s4p])
    Reac1395.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3pp_s4p -> CaMKII_s1p_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac1396 = smodel.Reac('Reac1396', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p], rhs = [CaMKII_s1p_s2pp_s3pp_s4pp])
    Reac1396.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3pp_s4p -> CaMKII_s1pp_s2pp_s3pp_s4p #autophosphorylation at Thr305
    Reac1397 = smodel.Reac('Reac1397', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p], rhs = [CaMKII_s1p_s2pp_s3pp_s4pp])
    Reac1397.kcst = k_t350
    
    # CaMKII_s1pp_s2pp_s3pp_s4p -> CaMKII_s1pp_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac1398 = smodel.Reac('Reac1398', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p], rhs = [CaMKII_s1p_s2pp_s3pp_s4pp])
    Reac1398.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3pp_s4p -> CaMKII_s1pp_s2p_s3pp_s4p #autophosphorylation at Thr305
    Reac1399 = smodel.Reac('Reac1399', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p], rhs = [CaMKII_s1pp_s2p_s3pp_s4p])
    Reac1399.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3pp_s4p -> CaMKII_s1pp_s2p_s3pp_s4pp #autophosphorylation at Thr305
    Reac1400 = smodel.Reac('Reac1400', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p], rhs = [CaMKII_s1pp_s2p_s3pp_s4pp])
    Reac1400.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3pp_s4p -> CaMKII_s1pp_s2pp_s3pp_s4p #autophosphorylation at Thr305
    Reac1401 = smodel.Reac('Reac1401', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p], rhs = [CaMKII_s1pp_s2pp_s3pp_s4p])
    Reac1401.kcst = k_t350
    
    # CaMKII_s1p_s2pCaM3Ca_s3pp_s4p -> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p #autophosphorylation at Thr305
    Reac1402 = smodel.Reac('Reac1402', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p])
    Reac1402.kcst = k_t350
    
    # CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p -> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp #autophosphorylation at Thr305 of s4
    Reac1403 = smodel.Reac('Reac1403', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp])
    Reac1403.kcst = k_t350
    
    #CaMKII_s1pp_s2p_s3pp_s4p + CaM3Ca <-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p  #dissociation of CaM, autophosphorylation withouth CaM
    Reac1404 = smodel.Reac('Reac1404', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p])
    Reac1404.kcst = kon_cam_t286
    Reac1405 = smodel.Reac('Reac1405', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1pp_s2p_s3pp_s4p, CaM3Ca])
    Reac1405.kcst = koff_cam_t286
    
    ####dephosphorylation by PP1
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pp-> CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1406 = smodel.Reac('Reac1406', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pp])
    Reac1406.kcst = 3.3333e6
    Reac1407 = smodel.Reac('Reac1407', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1407.kcst = 8
    Reac1408 = smodel.Reac('Reac1408', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1408.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pp-> CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1409 = smodel.Reac('Reac1409', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pp])
    Reac1409.kcst = 3.3333e6
    Reac1410 = smodel.Reac('Reac1410', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1410.kcst = 8
    Reac1411 = smodel.Reac('Reac1411', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pp, PP1])
    Reac1411.kcst = 2

    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1412 = smodel.Reac('Reac1412', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pp])
    Reac1412.kcst = 3.3333e6
    Reac1413 = smodel.Reac('Reac1413', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1413.kcst = 8
    Reac1414 = smodel.Reac('Reac1414', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pp, PP1])
    Reac1414.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP1-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1415 = smodel.Reac('Reac1415', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP1])
    Reac1415.kcst = 3.3333e6
    Reac1416 = smodel.Reac('Reac1416', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1416.kcst = 8
    Reac1417 = smodel.Reac('Reac1417', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP1])
    Reac1417.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pp-> CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1418 = smodel.Reac('Reac1418', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pp])
    Reac1418.kcst = 3.3333e6
    Reac1419 = smodel.Reac('Reac1419', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1419.kcst = 8
    Reac1420 = smodel.Reac('Reac1420', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1420.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1421 = smodel.Reac('Reac1421', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pp])
    Reac1421.kcst = 3.3333e6
    Reac1422 = smodel.Reac('Reac1422', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1422.kcst = 8
    Reac1423 = smodel.Reac('Reac1423', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1423.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pp-> CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1424 = smodel.Reac('Reac1424', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pp])
    Reac1424.kcst = 3.3333e6
    Reac1425 = smodel.Reac('Reac1425', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1425.kcst = 8
    Reac1426 = smodel.Reac('Reac1426', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pp, PP1])
    Reac1426.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP1-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1427 = smodel.Reac('Reac1427', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP1])
    Reac1427.kcst = 3.3333e6
    Reac1428 = smodel.Reac('Reac1428', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1428.kcst = 8
    Reac1429 = smodel.Reac('Reac1429', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac1429.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pp-> CaMKII_s1_s2pp_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at Thr305
    Reac1430 = smodel.Reac('Reac1430', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pp])
    Reac1430.kcst = 3.3333e6
    Reac1431 = smodel.Reac('Reac1431', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1431.kcst = 8
    Reac1432 = smodel.Reac('Reac1432', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1432.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1433 = smodel.Reac('Reac1433', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pp])
    Reac1433.kcst = 3.3333e6
    Reac1434 = smodel.Reac('Reac1434', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1434.kcst = 8
    Reac1435 = smodel.Reac('Reac1435', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1435.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pp-> CaMKII_s1p_s2pp_s3CaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1436 = smodel.Reac('Reac1436', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pp])
    Reac1436.kcst = 3.3333e6
    Reac1437 = smodel.Reac('Reac1437', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1437.kcst = 8
    Reac1438 = smodel.Reac('Reac1438', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1p_s2pp_s3CaM3Ca_s4pp, PP1])
    Reac1438.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP1-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1439 = smodel.Reac('Reac1439', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP1])
    Reac1439.kcst = 3.3333e6
    Reac1440 = smodel.Reac('Reac1440', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1440.kcst = 8
    Reac1441 = smodel.Reac('Reac1441', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac1441.kcst = 2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pp-> CaMKII_s1_s2p_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at Thr305
    Reac1442 = smodel.Reac('Reac1442', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pp])
    Reac1442.kcst = 3.3333e6
    Reac1443 = smodel.Reac('Reac1443', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1443.kcst = 8
    Reac1444 = smodel.Reac('Reac1444', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1444.kcst = 2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at Thr305
    Reac1445 = smodel.Reac('Reac1445', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pp])
    Reac1445.kcst = 3.3333e6
    Reac1446 = smodel.Reac('Reac1446', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1446.kcst = 8
    Reac1447 = smodel.Reac('Reac1447', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2_s3pCaM3Ca_s4pp, PP1])
    Reac1447.kcst = 2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pp-> CaMKII_s1p_s2p_s3CaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1448 = smodel.Reac('Reac1448', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pp])
    Reac1448.kcst = 3.3333e6
    Reac1449 = smodel.Reac('Reac1449', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1449.kcst = 8
    Reac1450 = smodel.Reac('Reac1450', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1p_s2p_s3CaM3Ca_s4pp, PP1])
    Reac1450.kcst = 2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP1-> CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1451 = smodel.Reac('Reac1451', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP1])
    Reac1451.kcst = 3.3333e6
    Reac1452 = smodel.Reac('Reac1452', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1452.kcst = 8
    Reac1453 = smodel.Reac('Reac1453', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP1])
    Reac1453.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1454 = smodel.Reac('Reac1454', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pp])
    Reac1454.kcst = 3.3333e6
    Reac1455 = smodel.Reac('Reac1455', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1455.kcst = 8
    Reac1456 = smodel.Reac('Reac1456', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1456.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pp-> CaMKII_s1pp_s2_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1457 = smodel.Reac('Reac1457', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pp])
    Reac1457.kcst = 3.3333e6
    Reac1458 = smodel.Reac('Reac1458', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1458.kcst = 8
    Reac1459 = smodel.Reac('Reac1459', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2_s3pCaM3Ca_s4pp, PP1])
    Reac1459.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pp-> CaMKII_s1pp_s2p_s3CaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1460 = smodel.Reac('Reac1460', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pp])
    Reac1460.kcst = 3.3333e6
    Reac1461 = smodel.Reac('Reac1461', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1461.kcst = 8
    Reac1462 = smodel.Reac('Reac1462', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1pp_s2p_s3CaM3Ca_s4pp, PP1])
    Reac1462.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP1-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1463 = smodel.Reac('Reac1463', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP1])
    Reac1463.kcst = 3.3333e6
    Reac1464 = smodel.Reac('Reac1464', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1464.kcst = 8
    Reac1465 = smodel.Reac('Reac1465', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP1])
    Reac1465.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1466 = smodel.Reac('Reac1466', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pp])
    Reac1466.kcst = 3.3333e6
    Reac1467 = smodel.Reac('Reac1467', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1467.kcst = 8
    Reac1468 = smodel.Reac('Reac1468', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1468.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pp-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1469 = smodel.Reac('Reac1469', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pp])
    Reac1469.kcst = 3.3333e6
    Reac1470 = smodel.Reac('Reac1470', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1470.kcst = 8
    Reac1471 = smodel.Reac('Reac1471', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac1471.kcst = 2

    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pp-> CaMKII_s1pp_s2pp_s3CaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1472 = smodel.Reac('Reac1472', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pp])
    Reac1472.kcst = 3.3333e6
    Reac1473 = smodel.Reac('Reac1473', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1473.kcst = 8
    Reac1474 = smodel.Reac('Reac1474', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1pp_s2pp_s3CaM3Ca_s4pp, PP1])
    Reac1474.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP1-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1475 = smodel.Reac('Reac1475', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP1])
    Reac1475.kcst = 3.3333e6
    Reac1476 = smodel.Reac('Reac1476', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac1476.kcst = 8
    Reac1477 = smodel.Reac('Reac1477', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac1477.kcst = 2

    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp-> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1478 = smodel.Reac('Reac1478', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1478.kcst = 3.3333e6
    Reac1479 = smodel.Reac('Reac1479', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1479.kcst = 8
    Reac1480 = smodel.Reac('Reac1480', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1480.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1481 = smodel.Reac('Reac1481', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pp])
    Reac1481.kcst = 3.3333e6
    Reac1482 = smodel.Reac('Reac1482', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1482.kcst = 8
    Reac1483 = smodel.Reac('Reac1483', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1483.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1484 = smodel.Reac('Reac1484', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pp])
    Reac1484.kcst = 3.3333e6
    Reac1485 = smodel.Reac('Reac1485', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1485.kcst = 8
    Reac1486 = smodel.Reac('Reac1486', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pp, PP1])
    Reac1486.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1487 = smodel.Reac('Reac1487', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1])
    Reac1487.kcst = 3.3333e6
    Reac1488 = smodel.Reac('Reac1488', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1488.kcst = 8
    Reac1489 = smodel.Reac('Reac1489', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac1489.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1490 = smodel.Reac('Reac1490', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1490.kcst = 3.3333e6
    Reac1491 = smodel.Reac('Reac1491', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1491.kcst = 8
    Reac1492 = smodel.Reac('Reac1492', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1492.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pp-> CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1493 = smodel.Reac('Reac1493', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pp])
    Reac1493.kcst = 3.3333e6
    Reac1494 = smodel.Reac('Reac1494', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1494.kcst = 8
    Reac1495 = smodel.Reac('Reac1495', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1495.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pp-> CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pp + PP1 #dephosphorylation at T286/CaM
    Reac1496 = smodel.Reac('Reac1496', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pp])
    Reac1496.kcst = 3.3333e6
    Reac1497 = smodel.Reac('Reac1497', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1497.kcst = 8
    Reac1498 = smodel.Reac('Reac1498', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pp, PP1])
    Reac1498.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1499 = smodel.Reac('Reac1499', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1])
    Reac1499.kcst = 3.3333e6
    Reac1500 = smodel.Reac('Reac1500', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac1500.kcst = 8
    Reac1501 = smodel.Reac('Reac1501', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac1501.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4p-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1502 = smodel.Reac('Reac1502', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4p])
    Reac1502.kcst = 3.3333e6
    Reac1503 = smodel.Reac('Reac1503', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1503.kcst = 8
    Reac1504 = smodel.Reac('Reac1504', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1504.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4p-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1505 = smodel.Reac('Reac1505', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4p])
    Reac1505.kcst = 3.3333e6
    Reac1506 = smodel.Reac('Reac1506', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1506.kcst = 8
    Reac1507 = smodel.Reac('Reac1507', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4p, PP1])
    Reac1507.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4p-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1508 = smodel.Reac('Reac1508', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4p])
    Reac1508.kcst = 3.3333e6
    Reac1509 = smodel.Reac('Reac1509', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1509.kcst = 8
    Reac1510 = smodel.Reac('Reac1510', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4p, PP1])
    Reac1510.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP1-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4 + PP1 #dephosphorylation at Thr305
    Reac1511 = smodel.Reac('Reac1511', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP1])
    Reac1511.kcst = 3.3333e6
    Reac1512 = smodel.Reac('Reac1512', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP1], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1512.kcst = 8
    Reac1513 = smodel.Reac('Reac1513', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4, PP1])
    Reac1513.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4p-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1514 = smodel.Reac('Reac1514', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4p])
    Reac1514.kcst = 3.3333e6
    Reac1515 = smodel.Reac('Reac1515', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1515.kcst = 8
    Reac1516 = smodel.Reac('Reac1516', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1516.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4p-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1517 = smodel.Reac('Reac1517', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4p])
    Reac1517.kcst = 3.3333e6
    Reac1518 = smodel.Reac('Reac1518', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1518.kcst = 8
    Reac1519 = smodel.Reac('Reac1519', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4p], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4p, PP1])
    Reac1519.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4p-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1520 = smodel.Reac('Reac1520', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4p])
    Reac1520.kcst = 3.3333e6
    Reac1521 = smodel.Reac('Reac1521', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1521.kcst = 8
    Reac1522 = smodel.Reac('Reac1522', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1522.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP1-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4 + PP1 #dephosphorylation at Thr305
    Reac1523 = smodel.Reac('Reac1523', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP1, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP1])
    Reac1523.kcst = 3.3333e6
    Reac1524 = smodel.Reac('Reac1524', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP1], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP1, PP1])
    Reac1524.kcst = 8
    Reac1525 = smodel.Reac('Reac1525', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4, PP1])
    Reac1525.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4p-> CaMKII_s1CaM3Ca_s2p_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1526 = smodel.Reac('Reac1526', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4p])
    Reac1526.kcst = 3.3333e6
    Reac1527 = smodel.Reac('Reac1527', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4p], rhs =[CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4p, PP1])
    Reac1527.kcst = 8
    Reac1528 = smodel.Reac('Reac1528', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4p], rhs = [CaMKII_s1CaM3Ca_s2p_s3pp_s4p, PP1])
    Reac1528.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4p-> CaMKII_s1pCaM3Ca_s2_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1529 = smodel.Reac('Reac1529', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4p])
    Reac1529.kcst = 3.3333e6
    Reac1530 = smodel.Reac('Reac1530', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP1])
    Reac1530.kcst = 8
    Reac1531 = smodel.Reac('Reac1531', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4p], rhs = [CaMKII_s1pCaM3Ca_s2_s3pp_s4p, PP1])
    Reac1531.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4p-> CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1532 = smodel.Reac('Reac1532', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4p])
    Reac1532.kcst = 3.3333e6
    Reac1533 = smodel.Reac('Reac1533', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP1])
    Reac1533.kcst = 8
    Reac1534 = smodel.Reac('Reac1534', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP1])
    Reac1534.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP1-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4 + PP1 #dephosphorylation at T286/CaM
    Reac1535 = smodel.Reac('Reac1535', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP1])
    Reac1535.kcst = 3.3333e6
    Reac1536 = smodel.Reac('Reac1536', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP1], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP1])
    Reac1536.kcst = 8
    Reac1537 = smodel.Reac('Reac1537', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4, PP1])
    Reac1537.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4p-> CaMKII_s1_s2pCaM3Ca_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1538 = smodel.Reac('Reac1538', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4p])
    Reac1538.kcst = 3.3333e6
    Reac1539 = smodel.Reac('Reac1539', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1539.kcst = 8
    Reac1540 = smodel.Reac('Reac1540', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1540.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4p-> CaMKII_s1p_s2CaM3Ca_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1541 = smodel.Reac('Reac1541', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4p])
    Reac1541.kcst = 3.3333e6
    Reac1542 = smodel.Reac('Reac1542', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1542.kcst = 8
    Reac1543 = smodel.Reac('Reac1543', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4p], rhs = [CaMKII_s1p_s2CaM3Ca_s3pp_s4p, PP1])
    Reac1543.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4p-> CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1544 = smodel.Reac('Reac1544', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4p])
    Reac1544.kcst = 3.3333e6
    Reac1545 = smodel.Reac('Reac1545', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1545.kcst = 8
    Reac1546 = smodel.Reac('Reac1546', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1546.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP1-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4 + PP1 #dephosphorylation at T286/CaM
    Reac1547 = smodel.Reac('Reac1547', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP1])
    Reac1547.kcst = 3.3333e6
    Reac1548 = smodel.Reac('Reac1548', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP1], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1548.kcst = 8
    Reac1549 = smodel.Reac('Reac1549', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4, PP1])
    Reac1549.kcst = 2
    
    #CaMKII_s1p_s2p_s3pp_s4p + PP1 <-> CaMKII_s1pPP1_s2p_s3pp_s4p-> CaMKII_s1_s2p_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1550 = smodel.Reac('Reac1550', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1pPP1_s2p_s3pp_s4p])
    Reac1550.kcst = 3.3333e6
    Reac1551 = smodel.Reac('Reac1551', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pp_s4p], rhs =[CaMKII_s1p_s2p_s3pp_s4p, PP1])
    Reac1551.kcst = 8
    Reac1552 = smodel.Reac('Reac1552', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pp_s4p], rhs = [CaMKII_s1_s2p_s3pp_s4p, PP1])
    Reac1552.kcst = 2
    
    #CaMKII_s1p_s2p_s3pp_s4p + PP1 <-> CaMKII_s1p_s2pPP1_s3pp_s4p-> CaMKII_s1p_s2_s3pp_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1553 = smodel.Reac('Reac1553', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1p_s2pPP1_s3pp_s4p])
    Reac1553.kcst = 3.3333e6
    Reac1554 = smodel.Reac('Reac1554', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pp_s4p], rhs =[CaMKII_s1p_s2p_s3pp_s4p, PP1])
    Reac1554.kcst = 8
    Reac1555 = smodel.Reac('Reac1555', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pp_s4p], rhs = [CaMKII_s1p_s2_s3pp_s4p, PP1])
    Reac1555.kcst = 2
    
    #CaMKII_s1p_s2p_s3pp_s4p + PP1 <-> CaMKII_s1p_s2p_s3ppPP1_s4p-> CaMKII_s1p_s2p_s3p_s4p + PP1 #dephosphorylation at T286/CaM
    Reac1556 = smodel.Reac('Reac1556', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1p_s2p_s3ppPP1_s4p])
    Reac1556.kcst = 3.3333e6
    Reac1557 = smodel.Reac('Reac1557', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP1_s4p], rhs =[CaMKII_s1p_s2p_s3pp_s4p, PP1])
    Reac1557.kcst = 8
    Reac1558 = smodel.Reac('Reac1558', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP1_s4p], rhs = [CaMKII_s1p_s2p_s3p_s4p, PP1])
    Reac1558.kcst = 2
    
    #CaMKII_s1p_s2p_s3pp_s4p + PP1 <-> CaMKII_s1p_s2p_s3pp_s4pPP1-> CaMKII_s1p_s2p_s3pp_s4 + PP1 #dephosphorylation 
    Reac1559 = smodel.Reac('Reac1559', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1p_s2p_s3pp_s4pPP1])
    Reac1559.kcst = 3.3333e6
    Reac1560 = smodel.Reac('Reac1560', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pPP1], rhs =[CaMKII_s1p_s2p_s3pp_s4p, PP1])
    Reac1560.kcst = 8
    Reac1561 = smodel.Reac('Reac1561', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pPP1], rhs = [CaMKII_s1p_s2p_s3pp_s4, PP1])
    Reac1561.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4p-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP1 #dephosphorylation 
    Reac1562 = smodel.Reac('Reac1562', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4p])
    Reac1562.kcst = 3.3333e6
    Reac1563 = smodel.Reac('Reac1563', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1563.kcst = 8
    Reac1564 = smodel.Reac('Reac1564', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1564.kcst = 2

    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4p-> CaMKII_s1pp_s2CaM3Ca_s3pp_s4p + PP1 #dephosphorylation
    Reac1565 = smodel.Reac('Reac1565', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4p])
    Reac1565.kcst = 3.3333e6
    Reac1566 = smodel.Reac('Reac1566', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1566.kcst = 8
    Reac1567 = smodel.Reac('Reac1567', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4p], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pp_s4p, PP1])
    Reac1567.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4p-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + PP1 #dephosphorylation 
    Reac1568 = smodel.Reac('Reac1568', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4p])
    Reac1568.kcst = 3.3333e6
    Reac1569 = smodel.Reac('Reac1569', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1569.kcst = 8
    Reac1570 = smodel.Reac('Reac1570', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1570.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP1-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4 + PP1 #dephosphorylation 
    Reac1571 = smodel.Reac('Reac1571', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP1])
    Reac1571.kcst = 3.3333e6
    Reac1572 = smodel.Reac('Reac1572', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP1], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac1572.kcst = 8
    Reac1573 = smodel.Reac('Reac1573', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4, PP1])
    Reac1573.kcst = 2

    #CaMKII_s1p_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1pPP1_s2pp_s3pp_s4p-> CaMKII_s1_s2pp_s3pp_s4p + PP1 #dephosphorylation 
    Reac1574 = smodel.Reac('Reac1574', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1pPP1_s2pp_s3pp_s4p])
    Reac1574.kcst = 3.3333e6
    Reac1575 = smodel.Reac('Reac1575', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pp_s4p], rhs =[CaMKII_s1p_s2pp_s3pp_s4p, PP1])
    Reac1575.kcst = 8
    Reac1576 = smodel.Reac('Reac1576', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pp_s4p], rhs = [CaMKII_s1_s2pp_s3pp_s4p, PP1])
    Reac1576.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1p_s2ppPP1_s3pp_s4p-> CaMKII_s1p_s2p_s3pp_s4p + PP1 #dephosphorylation 
    Reac1577 = smodel.Reac('Reac1577', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1p_s2ppPP1_s3pp_s4p])
    Reac1577.kcst = 3.3333e6
    Reac1578 = smodel.Reac('Reac1578', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pp_s4p], rhs =[CaMKII_s1p_s2pp_s3pp_s4p, PP1])
    Reac1578.kcst = 8
    Reac1579 = smodel.Reac('Reac1579', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pp_s4p], rhs = [CaMKII_s1p_s2p_s3pp_s4p, PP1])
    Reac1579.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1p_s2pp_s3ppPP1_s4p-> CaMKII_s1p_s2pp_s3p_s4p + PP1 #dephosphorylation 
    Reac1580 = smodel.Reac('Reac1580', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1p_s2pp_s3ppPP1_s4p])
    Reac1580.kcst = 3.3333e6
    Reac1581 = smodel.Reac('Reac1581', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP1_s4p], rhs =[CaMKII_s1p_s2pp_s3pp_s4p, PP1])
    Reac1581.kcst = 8
    Reac1582 = smodel.Reac('Reac1582', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP1_s4p], rhs = [CaMKII_s1p_s2pp_s3p_s4p, PP1])
    Reac1582.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1p_s2pp_s3pp_s4pPP1-> CaMKII_s1p_s2pp_s3pp_s4 + PP1 #dephosphorylation 
    Reac1583 = smodel.Reac('Reac1583', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1p_s2pp_s3pp_s4pPP1])
    Reac1583.kcst = 3.3333e6
    Reac1584 = smodel.Reac('Reac1584', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pPP1], rhs =[CaMKII_s1p_s2pp_s3pp_s4p, PP1])
    Reac1584.kcst = 8
    Reac1585 = smodel.Reac('Reac1585', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pPP1], rhs = [CaMKII_s1p_s2pp_s3pp_s4, PP1])
    Reac1585.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pp_s4p + PP1 <-> CaMKII_s1ppPP1_s2p_s3pp_s4p-> CaMKII_s1p_s2p_s3pp_s4p + PP1 #dephosphorylation 
    Reac1586 = smodel.Reac('Reac1586', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1ppPP1_s2p_s3pp_s4p])
    Reac1586.kcst = 3.3333e6
    Reac1587 = smodel.Reac('Reac1587', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3pp_s4p], rhs =[CaMKII_s1pp_s2p_s3pp_s4p, PP1])
    Reac1587.kcst = 8
    Reac1588 = smodel.Reac('Reac1588', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3pp_s4p], rhs = [CaMKII_s1p_s2p_s3pp_s4p, PP1])
    Reac1588.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pp_s4p + PP1 <-> CaMKII_s1pp_s2pPP1_s3pp_s4p-> CaMKII_s1pp_s2_s3pp_s4p + PP1 #dephosphorylation 
    Reac1589 = smodel.Reac('Reac1589', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1pp_s2pPP1_s3pp_s4p])
    Reac1589.kcst = 3.3333e6
    Reac1590 = smodel.Reac('Reac1590', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3pp_s4p], rhs =[CaMKII_s1pp_s2p_s3pp_s4p, PP1])
    Reac1590.kcst = 8
    Reac1591 = smodel.Reac('Reac1591', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3pp_s4p], rhs = [CaMKII_s1pp_s2_s3pp_s4p, PP1])
    Reac1591.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pp_s4p + PP1 <-> CaMKII_s1pp_s2p_s3ppPP1_s4p-> CaMKII_s1pp_s2p_s3p_s4p + PP1 #dephosphorylation 
    Reac1592 = smodel.Reac('Reac1592', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1pp_s2p_s3ppPP1_s4p])
    Reac1592.kcst = 3.3333e6
    Reac1593 = smodel.Reac('Reac1593', vsys, lhs = [CaMKII_s1pp_s2p_s3ppPP1_s4p], rhs =[CaMKII_s1pp_s2p_s3pp_s4p, PP1])
    Reac1593.kcst = 8
    Reac1594 = smodel.Reac('Reac1594', vsys, lhs = [CaMKII_s1pp_s2p_s3ppPP1_s4p], rhs = [CaMKII_s1pp_s2p_s3p_s4p, PP1])
    Reac1594.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pp_s4p + PP1 <-> CaMKII_s1pp_s2p_s3pp_s4pPP1-> CaMKII_s1pp_s2p_s3pp_s4 + PP1 #dephosphorylation 
    Reac1595 = smodel.Reac('Reac1595', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1pp_s2p_s3pp_s4pPP1])
    Reac1595.kcst = 3.3333e6
    Reac1596 = smodel.Reac('Reac1596', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pPP1], rhs =[CaMKII_s1pp_s2p_s3pp_s4p, PP1])
    Reac1596.kcst = 8
    Reac1597 = smodel.Reac('Reac1597', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pPP1], rhs = [CaMKII_s1pp_s2p_s3pp_s4, PP1])
    Reac1597.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1ppPP1_s2pp_s3pp_s4p-> CaMKII_s1p_s2pp_s3pp_s4p + PP1 #dephosphorylation 
    Reac1598 = smodel.Reac('Reac1598', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1ppPP1_s2pp_s3pp_s4p])
    Reac1598.kcst = 3.3333e6
    Reac1599 = smodel.Reac('Reac1599', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pp_s4p], rhs =[CaMKII_s1pp_s2pp_s3pp_s4p, PP1])
    Reac1599.kcst = 8
    Reac1600 = smodel.Reac('Reac1600', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pp_s4p], rhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP1])
    Reac1600.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1pp_s2ppPP1_s3pp_s4p-> CaMKII_s1pp_s2p_s3pp_s4p + PP1 #dephosphorylation 
    Reac1601 = smodel.Reac('Reac1601', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1pp_s2ppPP1_s3pp_s4p])
    Reac1601.kcst = 3.3333e6
    Reac1602 = smodel.Reac('Reac1602', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3pp_s4p], rhs =[CaMKII_s1pp_s2pp_s3pp_s4p, PP1])
    Reac1602.kcst = 8
    Reac1603 = smodel.Reac('Reac1603', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3pp_s4p], rhs = [CaMKII_s1pp_s2p_s3pp_s4p, PP1])
    Reac1603.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1pp_s2pp_s3ppPP1_s4p-> CaMKII_s1pp_s2pp_s3p_s4p + PP1 #dephosphorylation 
    Reac1604 = smodel.Reac('Reac1604', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1pp_s2pp_s3ppPP1_s4p])
    Reac1604.kcst = 3.3333e6
    Reac1605 = smodel.Reac('Reac1605', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP1_s4p], rhs =[CaMKII_s1pp_s2pp_s3pp_s4p, PP1])
    Reac1605.kcst = 8
    Reac1606 = smodel.Reac('Reac1606', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP1_s4p], rhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP1])
    Reac1606.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1pp_s2pp_s3pp_s4pPP1-> CaMKII_s1pp_s2pp_s3pp_s4 + PP1 #dephosphorylation 
    Reac1607 = smodel.Reac('Reac1607', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pPP1])
    Reac1607.kcst = 3.3333e6
    Reac1608 = smodel.Reac('Reac1608', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pPP1], rhs =[CaMKII_s1pp_s2pp_s3pp_s4p, PP1])
    Reac1608.kcst = 8
    Reac1609 = smodel.Reac('Reac1609', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pPP1], rhs = [CaMKII_s1pp_s2pp_s3pp_s4, PP1])
    Reac1609.kcst = 2
    
    ####dephosphorylation by PP2A
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pp-> CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1610 = smodel.Reac('Reac1610', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pp])
    Reac1610.kcst = 0.2e6
    Reac1611 = smodel.Reac('Reac1611', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1611.kcst = 0.8
    Reac1612 = smodel.Reac('Reac1612', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1612.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pp-> CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1613 = smodel.Reac('Reac1613', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pp])
    Reac1613.kcst = 0.2e6
    Reac1614 = smodel.Reac('Reac1614', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1614.kcst = 0.8
    Reac1615 = smodel.Reac('Reac1615', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pp, PP2A])
    Reac1615.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1616 = smodel.Reac('Reac1616', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pp])
    Reac1616.kcst = 0.2e6
    Reac1617 = smodel.Reac('Reac1617', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1617.kcst = 0.8
    Reac1618 = smodel.Reac('Reac1618', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pp, PP2A])
    Reac1618.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP2A-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1619 = smodel.Reac('Reac1619', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP2A])
    Reac1619.kcst = 0.2e6
    Reac1620 = smodel.Reac('Reac1620', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1620.kcst = 0.8
    Reac1621 = smodel.Reac('Reac1621', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac1621.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pp-> CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1622 = smodel.Reac('Reac1622', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pp])
    Reac1622.kcst = 0.2e6
    Reac1623 = smodel.Reac('Reac1623', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1623.kcst = 0.8
    Reac1624 = smodel.Reac('Reac1624', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1624.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pp-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1625 = smodel.Reac('Reac1625', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pp])
    Reac1625.kcst = 0.2e6
    Reac1626 = smodel.Reac('Reac1626', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1626.kcst = 0.8
    Reac1627 = smodel.Reac('Reac1627', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1627.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pp-> CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1628 = smodel.Reac('Reac1628', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pp])
    Reac1628.kcst = 0.2e6
    Reac1629 = smodel.Reac('Reac1629', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1629.kcst = 0.8
    Reac1630 = smodel.Reac('Reac1630', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pp, PP2A])
    Reac1630.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP2A-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1631 = smodel.Reac('Reac1631', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP2A])
    Reac1631.kcst = 0.2e6
    Reac1632 = smodel.Reac('Reac1632', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1632.kcst = 0.8
    Reac1633 = smodel.Reac('Reac1633', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac1633.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pp-> CaMKII_s1_s2pp_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at Thr305
    Reac1634 = smodel.Reac('Reac1634', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pp])
    Reac1634.kcst = 0.2e6
    Reac1635 = smodel.Reac('Reac1635', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1635.kcst = 0.8
    Reac1636 = smodel.Reac('Reac1636', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1636.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1637 = smodel.Reac('Reac1637', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pp])
    Reac1637.kcst = 0.2e6
    Reac1638 = smodel.Reac('Reac1638', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1638.kcst = 0.8
    Reac1639 = smodel.Reac('Reac1639', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1639.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pp-> CaMKII_s1p_s2pp_s3CaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1640 = smodel.Reac('Reac1640', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pp])
    Reac1640.kcst = 0.2e6
    Reac1641 = smodel.Reac('Reac1641', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1641.kcst = 0.8
    Reac1642 = smodel.Reac('Reac1642', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1p_s2pp_s3CaM3Ca_s4pp, PP2A])
    Reac1642.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP2A-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1643 = smodel.Reac('Reac1643', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP2A])
    Reac1643.kcst = 0.2e6
    Reac1644 = smodel.Reac('Reac1644', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1644.kcst = 0.8
    Reac1645 = smodel.Reac('Reac1645', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac1645.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pp-> CaMKII_s1_s2p_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at Thr305
    Reac1646 = smodel.Reac('Reac1646', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pp])
    Reac1646.kcst = 0.2e6
    Reac1647 = smodel.Reac('Reac1647', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1647.kcst = 0.8
    Reac1648 = smodel.Reac('Reac1648', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1648.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1649 = smodel.Reac('Reac1649', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pp])
    Reac1649.kcst = 0.2e6
    Reac1650 = smodel.Reac('Reac1650', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1650.kcst = 0.8
    Reac1651 = smodel.Reac('Reac1651', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2_s3pCaM3Ca_s4pp, PP2A])
    Reac1651.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pp-> CaMKII_s1p_s2p_s3CaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1652 = smodel.Reac('Reac1652', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pp])
    Reac1652.kcst = 0.2e6
    Reac1653 = smodel.Reac('Reac1653', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1653.kcst = 0.8
    Reac1654 = smodel.Reac('Reac1654', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1p_s2p_s3CaM3Ca_s4pp, PP2A])
    Reac1654.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP2A-> CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1655 = smodel.Reac('Reac1655', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP2A])
    Reac1655.kcst = 0.2e6
    Reac1656 = smodel.Reac('Reac1656', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1656.kcst = 0.8
    Reac1657 = smodel.Reac('Reac1657', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac1657.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1658 = smodel.Reac('Reac1658', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pp])
    Reac1658.kcst = 0.2e6
    Reac1659 = smodel.Reac('Reac1659', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1659.kcst = 0.8
    Reac1660 = smodel.Reac('Reac1660', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1660.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pp-> CaMKII_s1pp_s2_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1661 = smodel.Reac('Reac1661', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pp])
    Reac1661.kcst = 0.2e6
    Reac1662 = smodel.Reac('Reac1662', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1662.kcst = 0.8
    Reac1663 = smodel.Reac('Reac1663', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2_s3pCaM3Ca_s4pp, PP2A])
    Reac1663.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pp-> CaMKII_s1pp_s2p_s3CaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1664 = smodel.Reac('Reac1664', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pp])
    Reac1664.kcst = 0.2e6
    Reac1665 = smodel.Reac('Reac1665', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1665.kcst = 0.8
    Reac1666 = smodel.Reac('Reac1666', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1pp_s2p_s3CaM3Ca_s4pp, PP2A])
    Reac1666.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP2A-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1667 = smodel.Reac('Reac1667', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP2A])
    Reac1667.kcst = 0.2e6
    Reac1668 = smodel.Reac('Reac1668', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1668.kcst = 0.8
    Reac1669 = smodel.Reac('Reac1669', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac1669.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1670 = smodel.Reac('Reac1670', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pp])
    Reac1670.kcst = 0.2e6
    Reac1671 = smodel.Reac('Reac1671', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1671.kcst = 0.8
    Reac1672 = smodel.Reac('Reac1672', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1672.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pp-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1673 = smodel.Reac('Reac1673', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pp])
    Reac1673.kcst = 0.2e6
    Reac1674 = smodel.Reac('Reac1674', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1674.kcst = 0.8
    Reac1675 = smodel.Reac('Reac1675', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac1675.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pp-> CaMKII_s1pp_s2pp_s3CaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1676 = smodel.Reac('Reac1676', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pp])
    Reac1676.kcst = 0.2e6
    Reac1677 = smodel.Reac('Reac1677', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1677.kcst = 0.8
    Reac1678 = smodel.Reac('Reac1678', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1pp_s2pp_s3CaM3Ca_s4pp, PP2A])
    Reac1678.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP2A-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1679 = smodel.Reac('Reac1679', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP2A])
    Reac1679.kcst = 0.2e6
    Reac1680 = smodel.Reac('Reac1680', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac1680.kcst = 0.8
    Reac1681 = smodel.Reac('Reac1681', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac1681.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp-> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at Thr305
    Reac1682 = smodel.Reac('Reac1682', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1682.kcst = 0.2e6
    Reac1683 = smodel.Reac('Reac1683', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1683.kcst = 0.8
    Reac1684 = smodel.Reac('Reac1684', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1684.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1685 = smodel.Reac('Reac1685', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp])
    Reac1685.kcst = 0.2e6
    Reac1686 = smodel.Reac('Reac1686', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1686.kcst = 0.8
    Reac1687 = smodel.Reac('Reac1687', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1687.kcst = 0.2

    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1688 = smodel.Reac('Reac1688', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp])
    Reac1688.kcst = 0.2e6
    Reac1689 = smodel.Reac('Reac1689', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1689.kcst = 0.8
    Reac1690 = smodel.Reac('Reac1690', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pp, PP2A])
    Reac1690.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1691 = smodel.Reac('Reac1691', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A])
    Reac1691.kcst = 0.2e6
    Reac1692 = smodel.Reac('Reac1692', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1692.kcst = 0.8
    Reac1693 = smodel.Reac('Reac1693', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac1693.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1694 = smodel.Reac('Reac1694', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1694.kcst = 0.2e6
    Reac1695 = smodel.Reac('Reac1695', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1695.kcst = 0.8
    Reac1696 = smodel.Reac('Reac1696', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1696.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp-> CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pp + PP2A #dephosphorylation at T286/CaM
    Reac1697 = smodel.Reac('Reac1697', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp])
    Reac1697.kcst = 0.2e6
    Reac1698 = smodel.Reac('Reac1698', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1698.kcst = 0.8
    Reac1699 = smodel.Reac('Reac1699', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1699.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp-> CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pp + PP2A #dephosphorylation at Thr305
    Reac1700 = smodel.Reac('Reac1700', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp])
    Reac1700.kcst = 0.2e6
    Reac1701 = smodel.Reac('Reac1701', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1701.kcst = 0.8
    Reac1702 = smodel.Reac('Reac1702', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pp, PP2A])
    Reac1702.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1704 = smodel.Reac('Reac1704', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A])
    Reac1704.kcst = 0.2e6
    Reac1705 = smodel.Reac('Reac1705', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac1705.kcst = 0.8
    Reac1706 = smodel.Reac('Reac1706', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac1706.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4p-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1707 = smodel.Reac('Reac1707', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4p])
    Reac1707.kcst = 0.2e6
    Reac1708 = smodel.Reac('Reac1708', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac1708.kcst = 0.8
    Reac1709 = smodel.Reac('Reac1709', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac1709.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4p-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1710 = smodel.Reac('Reac1710', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4p])
    Reac1710.kcst = 0.2e6
    Reac1711 = smodel.Reac('Reac1711', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac1711.kcst = 0.8
    Reac1712 = smodel.Reac('Reac1712', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4p, PP2A])
    Reac1712.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4p-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4p + PP2A #dephosphorylation at Thr305
    Reac1713 = smodel.Reac('Reac1713', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4p])
    Reac1713.kcst = 0.2e6
    Reac1714 = smodel.Reac('Reac1714', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac1714.kcst = 0.8
    Reac1715 = smodel.Reac('Reac1715', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4p, PP2A])
    Reac1715.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP2A-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4 + PP2A #dephosphorylation at Thr305
    Reac1716 = smodel.Reac('Reac1716', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP2A])
    Reac1716.kcst = 0.2e6
    Reac1717 = smodel.Reac('Reac1717', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac1717.kcst = 0.8
    Reac1718 = smodel.Reac('Reac1718', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4, PP2A])
    Reac1718.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4p-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1719 = smodel.Reac('Reac1719', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4p])
    Reac1719.kcst = 0.2e6
    Reac1720 = smodel.Reac('Reac1720', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1720.kcst = 0.8
    Reac1721 = smodel.Reac('Reac1721', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1721.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4p-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4p + PP2A #dephosphorylation at Thr305
    Reac1722 = smodel.Reac('Reac1722', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4p])
    Reac1722.kcst = 0.2e6
    Reac1723 = smodel.Reac('Reac1723', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1723.kcst = 0.8
    Reac1724 = smodel.Reac('Reac1724', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4p], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4p, PP2A])
    Reac1724.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4p-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1725 = smodel.Reac('Reac1725', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4p])
    Reac1725.kcst = 0.2e6
    Reac1726 = smodel.Reac('Reac1726', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1726.kcst = 0.8
    Reac1727 = smodel.Reac('Reac1727', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac1727.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP2A-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4 + PP2A #dephosphorylation at Thr305
    Reac1728 = smodel.Reac('Reac1728', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP2A, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP2A])
    Reac1728.kcst = 0.2e6
    Reac1729 = smodel.Reac('Reac1729', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP2A, PP2A])
    Reac1729.kcst = 0.8
    Reac1730 = smodel.Reac('Reac1730', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4, PP2A])
    Reac1730.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4p-> CaMKII_s1CaM3Ca_s2p_s3pp_s4p + PP2A #dephosphorylation at Thr305
    Reac1731 = smodel.Reac('Reac1731', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4p])
    Reac1731.kcst = 0.2e6
    Reac1732 = smodel.Reac('Reac1732', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4p], rhs =[CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4p, PP2A])
    Reac1732.kcst = 0.8
    Reac1733 = smodel.Reac('Reac1733', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4p], rhs = [CaMKII_s1CaM3Ca_s2p_s3pp_s4p, PP2A])
    Reac1733.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4p-> CaMKII_s1pCaM3Ca_s2_s3pp_s4p + PP2A #dephosphorylation at Thr305
    Reac1734 = smodel.Reac('Reac1734', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4p])
    Reac1734.kcst = 0.2e6
    Reac1735 = smodel.Reac('Reac1735', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP2A])
    Reac1735.kcst = 0.8
    Reac1736 = smodel.Reac('Reac1736', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4p], rhs = [CaMKII_s1pCaM3Ca_s2_s3pp_s4p, PP2A])
    Reac1736.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4p-> CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1737 = smodel.Reac('Reac1737', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4p])
    Reac1737.kcst = 0.2e6
    Reac1738 = smodel.Reac('Reac1738', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP2A])
    Reac1738.kcst = 0.8
    Reac1739 = smodel.Reac('Reac1739', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP2A])
    Reac1739.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP2A-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4 + PP2A #dephosphorylation at Thr305
    Reac1740 = smodel.Reac('Reac1740', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP2A])
    Reac1740.kcst = 0.2e6
    Reac1741 = smodel.Reac('Reac1741', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP2A], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP2A])
    Reac1741.kcst = 0.8
    Reac1742 = smodel.Reac('Reac1742', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pPP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4, PP2A])
    Reac1742.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4p-> CaMKII_s1_s2pCaM3Ca_s3pp_s4p + PP2A #dephosphorylation at Thr305
    Reac1743 = smodel.Reac('Reac1743', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4p])
    Reac1743.kcst = 0.2e6
    Reac1744 = smodel.Reac('Reac1744', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1744.kcst = 0.8
    Reac1745 = smodel.Reac('Reac1745', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1745.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4p-> CaMKII_s1p_s2CaM3Ca_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1746 = smodel.Reac('Reac1746', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4p])
    Reac1746.kcst = 0.2e6
    Reac1747 = smodel.Reac('Reac1747', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1747.kcst = 0.8
    Reac1748 = smodel.Reac('Reac1748', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4p], rhs = [CaMKII_s1p_s2CaM3Ca_s3pp_s4p, PP2A])
    Reac1748.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4p-> CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1749 = smodel.Reac('Reac1749', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4p])
    Reac1749.kcst = 0.2e6
    Reac1750 = smodel.Reac('Reac1750', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1750.kcst = 0.8
    Reac1751 = smodel.Reac('Reac1751', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac1751.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP2A-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4 + PP2A #dephosphorylation at Thr305
    Reac1752 = smodel.Reac('Reac1752', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP2A])
    Reac1752.kcst = 0.2e6
    Reac1753 = smodel.Reac('Reac1753', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP2A], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1753.kcst = 0.8
    Reac1754 = smodel.Reac('Reac1754', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pPP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4, PP2A])
    Reac1754.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pp_s4p + PP2A <-> CaMKII_s1pPP2A_s2p_s3pp_s4p-> CaMKII_s1_s2p_s3pp_s4p + PP2A #dephosphorylation at Thr305
    Reac1755 = smodel.Reac('Reac1755', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1pPP2A_s2p_s3pp_s4p])
    Reac1755.kcst = 0.2e6
    Reac1756 = smodel.Reac('Reac1756', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pp_s4p], rhs =[CaMKII_s1p_s2p_s3pp_s4p, PP2A])
    Reac1756.kcst = 0.8
    Reac1757 = smodel.Reac('Reac1757', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pp_s4p], rhs = [CaMKII_s1_s2p_s3pp_s4p, PP2A])
    Reac1757.kcst = 0.2

    #CaMKII_s1p_s2p_s3pp_s4p + PP2A <-> CaMKII_s1p_s2pPP2A_s3pp_s4p-> CaMKII_s1p_s2_s3pp_s4p + PP2A #dephosphorylation at Thr305
    Reac1758 = smodel.Reac('Reac1758', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1p_s2pPP2A_s3pp_s4p])
    Reac1758.kcst = 0.2e6
    Reac1759 = smodel.Reac('Reac1759', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pp_s4p], rhs =[CaMKII_s1p_s2p_s3pp_s4p, PP2A])
    Reac1759.kcst = 0.8
    Reac1760 = smodel.Reac('Reac1760', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pp_s4p], rhs = [CaMKII_s1p_s2_s3pp_s4p, PP2A])
    Reac1760.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pp_s4p + PP2A <-> CaMKII_s1p_s2p_s3ppPP2A_s4p-> CaMKII_s1p_s2p_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1761 = smodel.Reac('Reac1761', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1p_s2p_s3ppPP2A_s4p])
    Reac1761.kcst = 0.2e6
    Reac1762 = smodel.Reac('Reac1762', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP2A_s4p], rhs =[CaMKII_s1p_s2p_s3pp_s4p, PP2A])
    Reac1762.kcst = 0.8
    Reac1763 = smodel.Reac('Reac1763', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP2A_s4p], rhs = [CaMKII_s1p_s2p_s3p_s4p, PP2A])
    Reac1763.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pp_s4p + PP2A <-> CaMKII_s1p_s2p_s3pp_s4pPP2A-> CaMKII_s1p_s2p_s3pp_s4 + PP2A #dephosphorylation at Thr305
    Reac1764 = smodel.Reac('Reac1764', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1p_s2p_s3pp_s4pPP2A])
    Reac1764.kcst = 0.2e6
    Reac1765 = smodel.Reac('Reac1765', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pPP2A], rhs =[CaMKII_s1p_s2p_s3pp_s4p, PP2A])
    Reac1765.kcst = 0.8
    Reac1766 = smodel.Reac('Reac1766', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pPP2A], rhs = [CaMKII_s1p_s2p_s3pp_s4, PP2A])
    Reac1766.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4p-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1767 = smodel.Reac('Reac1767', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4p])
    Reac1767.kcst = 0.2e6
    Reac1768 = smodel.Reac('Reac1768', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1768.kcst = 0.8
    Reac1769 = smodel.Reac('Reac1769', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1769.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4p-> CaMKII_s1pp_s2CaM3Ca_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1770 = smodel.Reac('Reac1770', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4p])
    Reac1770.kcst = 0.2e6
    Reac1771 = smodel.Reac('Reac1771', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1771.kcst = 0.8
    Reac1772 = smodel.Reac('Reac1772', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4p], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pp_s4p, PP2A])
    Reac1772.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4p-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1773 = smodel.Reac('Reac1773', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4p])
    Reac1773.kcst = 0.2e6
    Reac1774 = smodel.Reac('Reac1774', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1774.kcst = 0.8
    Reac1775 = smodel.Reac('Reac1775', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac1775.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP2A-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4 + PP2A #dephosphorylation at Thr305
    Reac1776 = smodel.Reac('Reac1776', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP2A])
    Reac1776.kcst = 0.2e6
    Reac1777 = smodel.Reac('Reac1777', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP2A], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac1777.kcst = 0.8
    Reac1778 = smodel.Reac('Reac1778', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pPP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4, PP2A])
    Reac1778.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1pPP2A_s2pp_s3pp_s4p-> CaMKII_s1_s2pp_s3pp_s4p + PP2A #dephosphorylation at Thr305
    Reac1779 = smodel.Reac('Reac1779', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1pPP2A_s2pp_s3pp_s4p])
    Reac1779.kcst = 0.2e6
    Reac1780 = smodel.Reac('Reac1780', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pp_s4p], rhs =[CaMKII_s1p_s2pp_s3pp_s4p, PP2A])
    Reac1780.kcst = 0.8
    Reac1781 = smodel.Reac('Reac1781', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pp_s4p], rhs = [CaMKII_s1_s2pp_s3pp_s4p, PP2A])
    Reac1781.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1p_s2ppPP2A_s3pp_s4p-> CaMKII_s1p_s2p_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1782 = smodel.Reac('Reac1782', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1p_s2ppPP2A_s3pp_s4p])
    Reac1782.kcst = 0.2e6
    Reac1783 = smodel.Reac('Reac1783', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pp_s4p], rhs =[CaMKII_s1p_s2pp_s3pp_s4p, PP2A])
    Reac1783.kcst = 0.8
    Reac1784 = smodel.Reac('Reac1784', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pp_s4p], rhs = [CaMKII_s1p_s2p_s3pp_s4p, PP2A])
    Reac1784.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1p_s2pp_s3ppPP2A_s4p-> CaMKII_s1p_s2pp_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1785 = smodel.Reac('Reac1785', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1p_s2pp_s3ppPP2A_s4p])
    Reac1785.kcst = 0.2e6
    Reac1786 = smodel.Reac('Reac1786', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP2A_s4p], rhs =[CaMKII_s1p_s2pp_s3pp_s4p, PP2A])
    Reac1786.kcst = 0.8
    Reac1787 = smodel.Reac('Reac1787', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP2A_s4p], rhs = [CaMKII_s1p_s2pp_s3p_s4p, PP2A])
    Reac1787.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1p_s2pp_s3pp_s4pPP2A-> CaMKII_s1p_s2pp_s3pp_s4 + PP2A #dephosphorylation at Thr305
    Reac1788 = smodel.Reac('Reac1788', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1p_s2pp_s3pp_s4pPP2A])
    Reac1788.kcst = 0.2e6
    Reac1789 = smodel.Reac('Reac1789', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pPP2A], rhs =[CaMKII_s1p_s2pp_s3pp_s4p, PP2A])
    Reac1789.kcst = 0.8
    Reac1790 = smodel.Reac('Reac1790', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pPP2A], rhs = [CaMKII_s1p_s2pp_s3pp_s4, PP2A])
    Reac1790.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pp_s4p + PP2A <-> CaMKII_s1ppPP2A_s2p_s3pp_s4p-> CaMKII_s1p_s2p_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1791 = smodel.Reac('Reac1791', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1ppPP2A_s2p_s3pp_s4p])
    Reac1791.kcst = 0.2e6
    Reac1792 = smodel.Reac('Reac1792', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3pp_s4p], rhs =[CaMKII_s1pp_s2p_s3pp_s4p, PP2A])
    Reac1792.kcst = 0.8
    Reac1793 = smodel.Reac('Reac1793', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3pp_s4p], rhs = [CaMKII_s1p_s2p_s3pp_s4p, PP2A])
    Reac1793.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pp_s4p + PP2A <-> CaMKII_s1pp_s2pPP2A_s3pp_s4p-> CaMKII_s1pp_s2_s3pp_s4p + PP2A #dephosphorylation at Thr305
    Reac1794 = smodel.Reac('Reac1794', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1pp_s2pPP2A_s3pp_s4p])
    Reac1794.kcst = 0.2e6
    Reac1795 = smodel.Reac('Reac1795', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3pp_s4p], rhs =[CaMKII_s1pp_s2p_s3pp_s4p, PP2A])
    Reac1795.kcst = 0.8
    Reac1796 = smodel.Reac('Reac1796', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3pp_s4p], rhs = [CaMKII_s1pp_s2_s3pp_s4p, PP2A])
    Reac1796.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pp_s4p + PP2A <-> CaMKII_s1pp_s2p_s3ppPP2A_s4p-> CaMKII_s1pp_s2p_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1797 = smodel.Reac('Reac1797', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1pp_s2p_s3ppPP2A_s4p])
    Reac1797.kcst = 0.2e6
    Reac1798 = smodel.Reac('Reac1798', vsys, lhs = [CaMKII_s1pp_s2p_s3ppPP2A_s4p], rhs =[CaMKII_s1pp_s2p_s3pp_s4p, PP2A])
    Reac1798.kcst = 0.8
    Reac1799 = smodel.Reac('Reac1799', vsys, lhs = [CaMKII_s1pp_s2p_s3ppPP2A_s4p], rhs = [CaMKII_s1pp_s2p_s3p_s4p, PP2A])
    Reac1799.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pp_s4p + PP2A <-> CaMKII_s1pp_s2p_s3pp_s4pPP2A-> CaMKII_s1pp_s2p_s3pp_s4 + PP2A #dephosphorylation at Thr305
    Reac1800 = smodel.Reac('Reac1800', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1pp_s2p_s3pp_s4pPP2A])
    Reac1800.kcst = 0.2e6
    Reac1801 = smodel.Reac('Reac1801', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pPP2A], rhs =[CaMKII_s1pp_s2p_s3pp_s4p, PP2A])
    Reac1801.kcst = 0.8
    Reac1802 = smodel.Reac('Reac1802', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pPP2A], rhs = [CaMKII_s1pp_s2p_s3pp_s4, PP2A])
    Reac1802.kcst = 0.2

    #CaMKII_s1pp_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1ppPP2A_s2pp_s3pp_s4p-> CaMKII_s1p_s2pp_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1803 = smodel.Reac('Reac1803', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1ppPP2A_s2pp_s3pp_s4p])
    Reac1803.kcst = 0.2e6
    Reac1804 = smodel.Reac('Reac1804', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pp_s4p], rhs =[CaMKII_s1pp_s2pp_s3pp_s4p, PP2A])
    Reac1804.kcst = 0.8
    Reac1805 = smodel.Reac('Reac1805', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pp_s4p], rhs = [CaMKII_s1p_s2pp_s3pp_s4p, PP2A])
    Reac1805.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1pp_s2ppPP2A_s3pp_s4p-> CaMKII_s1pp_s2p_s3pp_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1806 = smodel.Reac('Reac1806', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1pp_s2ppPP2A_s3pp_s4p])
    Reac1806.kcst = 0.2e6
    Reac1807 = smodel.Reac('Reac1807', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3pp_s4p], rhs =[CaMKII_s1pp_s2pp_s3pp_s4p, PP2A])
    Reac1807.kcst = 0.8
    Reac1808 = smodel.Reac('Reac1808', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3pp_s4p], rhs = [CaMKII_s1pp_s2p_s3pp_s4p, PP2A])
    Reac1808.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1pp_s2pp_s3ppPP2A_s4p-> CaMKII_s1pp_s2pp_s3p_s4p + PP2A #dephosphorylation at T286/CaM
    Reac1809 = smodel.Reac('Reac1809', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1pp_s2pp_s3ppPP2A_s4p])
    Reac1809.kcst = 0.2e6
    Reac1810 = smodel.Reac('Reac1810', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP2A_s4p], rhs =[CaMKII_s1pp_s2pp_s3pp_s4p, PP2A])
    Reac1810.kcst = 0.8
    Reac1811 = smodel.Reac('Reac1811', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP2A_s4p], rhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP2A])
    Reac1811.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1pp_s2pp_s3pp_s4pPP2A-> CaMKII_s1pp_s2pp_s3pp_s4 + PP2A #dephosphorylation at Thr305
    Reac1812 = smodel.Reac('Reac1812', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pPP2A])
    Reac1812.kcst = 0.2e6
    Reac1813 = smodel.Reac('Reac1813', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pPP2A], rhs =[CaMKII_s1pp_s2pp_s3pp_s4p, PP2A])
    Reac1813.kcst = 0.8
    Reac1814 = smodel.Reac('Reac1814', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pPP2A], rhs = [CaMKII_s1pp_s2pp_s3pp_s4, PP2A])
    Reac1814.kcst = 0.2
   
    # CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1815 = smodel.Reac('Reac1815', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p])
    Reac1815.kcst = kon_cam_t286
    Reac1816 = smodel.Reac('Reac1816', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp, CaM3Ca])
    Reac1816.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4p -> CaMKII_s1pCaM3Ca_s2p_s3p_s4pp #autophosphorylation at Thr305
    Reac1817 = smodel.Reac('Reac1817', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pp])
    Reac1817.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4p -> CaMKII_s1pCaM3Ca_s2p_s3pp_s4p #autophosphorylation at Thr305
    Reac1818 = smodel.Reac('Reac1818', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p])
    Reac1818.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4p -> CaMKII_s1pCaM3Ca_s2pp_s3p_s4p #autophosphorylation at Thr305
    Reac1819 = smodel.Reac('Reac1819', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p])
    Reac1819.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pp_s3p_s4p -> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp #autophosphorylation at Thr305
    Reac1820 = smodel.Reac('Reac1820', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp])
    Reac1820.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pp_s3p_s4p -> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p #autophosphorylation at Thr305
    Reac1821 = smodel.Reac('Reac1821', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p])
    Reac1821.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p -> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac1822 = smodel.Reac('Reac1822', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp])
    Reac1822.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3pp_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1823 = smodel.Reac('Reac1823', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p])
    Reac1823.kcst = kon_cam_t286
    Reac1824 = smodel.Reac('Reac1824', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p], rhs = [CaMKII_s1p_s2pp_s3pp_s4p, CaM3Ca])
    Reac1824.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3p_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pp_s3p_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1825 = smodel.Reac('Reac1825', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p])
    Reac1825.kcst = kon_cam_t286
    Reac1826 = smodel.Reac('Reac1826', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p], rhs = [CaMKII_s1p_s2pp_s3p_s4p, CaM3Ca])
    Reac1826.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3p_s4p -> CaMKII_s1p_s2pp_s3p_s4pp #autophosphorylation at Thr305
    Reac1827 = smodel.Reac('Reac1827', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p], rhs = [CaMKII_s1p_s2pp_s3p_s4pp])
    Reac1827.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3p_s4p -> CaMKII_s1p_s2pp_s3pp_s4p #autophosphorylation at Thr305
    Reac1828 = smodel.Reac('Reac1828', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p], rhs = [CaMKII_s1p_s2pp_s3pp_s4p])
    Reac1828.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3p_s4p -> CaMKII_s1pp_s2pp_s3p_s4p #autophosphorylation at Thr305
    Reac1829 = smodel.Reac('Reac1829', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p], rhs = [CaMKII_s1pp_s2pp_s3p_s4p])
    Reac1829.kcst = k_t350
    
    # CaMKII_s1pp_s2pp_s3p_s4p -> CaMKII_s1pp_s2pp_s3p_s4pp #autophosphorylation at Thr305
    Reac1830 = smodel.Reac('Reac1830', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p], rhs = [CaMKII_s1pp_s2pp_s3p_s4pp])
    Reac1830.kcst = k_t350
    
    # CaMKII_s1pp_s2pp_s3p_s4p -> CaMKII_s1pp_s2pp_s3pp_s4p #autophosphorylation at Thr305
    Reac1831 = smodel.Reac('Reac1831', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p], rhs = [CaMKII_s1pp_s2pp_s3pp_s4p])
    Reac1831.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2p_s3p_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1832 = smodel.Reac('Reac1832', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p])
    Reac1832.kcst = kon_cam_t286
    Reac1833 = smodel.Reac('Reac1833', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p], rhs = [CaMKII_s1p_s2p_s3p_s4p, CaM3Ca])
    Reac1833.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3p_s4p -> CaMKII_s1p_s2p_s3p_s4pp #autophosphorylation at Thr305
    Reac1834 = smodel.Reac('Reac1834', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p], rhs = [CaMKII_s1p_s2p_s3p_s4pp])
    Reac1834.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4p -> CaMKII_s1p_s2p_s3pp_s4p #autophosphorylation at Thr305
    Reac1835 = smodel.Reac('Reac1835', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p], rhs = [CaMKII_s1p_s2p_s3pp_s4p])
    Reac1835.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4p -> CaMKII_s1p_s2pp_s3p_s4p #autophosphorylation at Thr305
    Reac1836 = smodel.Reac('Reac1836', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p], rhs = [CaMKII_s1p_s2pp_s3p_s4p])
    Reac1836.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4p -> CaMKII_s1pp_s2p_s3p_s4p #autophosphorylation at Thr305
    Reac1837 = smodel.Reac('Reac1837', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p], rhs = [CaMKII_s1pp_s2p_s3p_s4p])
    Reac1837.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3p_s4p -> CaMKII_s1pp_s2p_s3p_s4pp #autophosphorylation at Thr305
    Reac1838 = smodel.Reac('Reac1838', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p], rhs = [CaMKII_s1pp_s2p_s3p_s4pp])
    Reac1838.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3p_s4p -> CaMKII_s1pp_s2p_s3pp_s4p #autophosphorylation at Thr305
    Reac1839 = smodel.Reac('Reac1839', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p], rhs = [CaMKII_s1pp_s2p_s3p_s4pp])
    Reac1839.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3p_s4p -> CaMKII_s1pp_s2pp_s3p_s4p #autophosphorylation at Thr305
    Reac1840 = smodel.Reac('Reac1840', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p], rhs = [CaMKII_s1pp_s2pp_s3p_s4p])
    Reac1840.kcst = k_t350
    
    # CaMKII_s1p_s2pCaM3Ca_s3p_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1841 = smodel.Reac('Reac1841', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p])
    Reac1841.kcst = kon_cam_t286
    Reac1842 = smodel.Reac('Reac1842', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, CaM3Ca])
    Reac1842.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3p_s4p -> CaMKII_s1p_s2pCaM3Ca_s3p_s4pp #autophosphorylation at Thr305
    Reac1843 = smodel.Reac('Reac1843', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pp])
    Reac1843.kcst = k_t350

    # CaMKII_s1p_s2pCaM3Ca_s3p_s4p -> CaMKII_s1p_s2pCaM3Ca_s3pp_s4p #autophosphorylation at Thr305
    Reac1844 = smodel.Reac('Reac1844', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p])
    Reac1844.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4p + CaM3Ca <->  CaMKII_s1p_s2pCaM3Ca_s3p_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1845 = smodel.Reac('Reac1845', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p])
    Reac1845.kcst = kon_cam_t286
    Reac1846 = smodel.Reac('Reac1846', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, CaM3Ca])
    Reac1846.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3p_s4p -> CaMKII_s1pp_s2pCaM3Ca_s3p_s4p #autophosphorylation at Thr305
    Reac1847 = smodel.Reac('Reac1847', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p])
    Reac1847.kcst = k_t350
    
    # CaMKII_s1pp_s2pCaM3Ca_s3p_s4p -> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp #autophosphorylation at Thr305
    Reac1848 = smodel.Reac('Reac1848', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp])
    Reac1848.kcst = k_t350
    
    # CaMKII_s1pp_s2pCaM3Ca_s3p_s4p -> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p #autophosphorylation at Thr305
    Reac1849 = smodel.Reac('Reac1849', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p])
    Reac1849.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3p_s4p + CaM3Ca <->  CaMKII_s1pp_s2pCaM3Ca_s3p_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1850 = smodel.Reac('Reac1850', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p])
    Reac1850.kcst = kon_cam_t286
    Reac1851 = smodel.Reac('Reac1851', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1pp_s2p_s3p_s4p, CaM3Ca])
    Reac1851.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1852 = smodel.Reac('Reac1852', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac1852.kcst = kon_cam_t286
    Reac1853 = smodel.Reac('Reac1853', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, CaM3Ca])
    Reac1853.kcst = koff_cam_t286

    # CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p -> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1854 = smodel.Reac('Reac1854', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp])
    Reac1854.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1855 = smodel.Reac('Reac1855', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p])
    Reac1855.kcst = kon_cam_t286
    Reac1856 = smodel.Reac('Reac1856', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, CaM3Ca])
    Reac1856.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p -> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p #autophosphorylation at Thr305
    Reac1857 = smodel.Reac('Reac1857', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p])
    Reac1857.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p -> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1858 = smodel.Reac('Reac1858', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp])
    Reac1858.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1859 = smodel.Reac('Reac1859', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p])
    Reac1859.kcst = kon_cam_t286
    Reac1860 = smodel.Reac('Reac1860', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, CaM3Ca])
    Reac1860.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1861 = smodel.Reac('Reac1861', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p])
    Reac1861.kcst = kon_cam_t286
    Reac1862 = smodel.Reac('Reac1862', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, CaM3Ca])
    Reac1862.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3pCaM3Ca_s4p -> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1863 = smodel.Reac('Reac1863', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp])
    Reac1863.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3p_s4p + CaM3Ca <->  CaMKII_s1p_s2pp_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1864 = smodel.Reac('Reac1864', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p])
    Reac1864.kcst = kon_cam_t286
    Reac1865 = smodel.Reac('Reac1865', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2pp_s3p_s4p, CaM3Ca])
    Reac1865.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3pCaM3Ca_s4p -> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p #autophosphorylation at Thr305
    Reac1866 = smodel.Reac('Reac1866', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p])
    Reac1866.kcst = k_t350
    
    # CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p -> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1867 = smodel.Reac('Reac1867', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp])
    Reac1867.kcst = k_t350
    
    # CaMKII_s1pp_s2pp_s3p_s4p + CaM3Ca <->  CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1868 = smodel.Reac('Reac1868', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p])
    Reac1868.kcst = kon_cam_t286
    Reac1869 = smodel.Reac('Reac1869', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2pp_s3p_s4p, CaM3Ca])
    Reac1869.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pCaM3Ca_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1870 = smodel.Reac('Reac1870', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p])
    Reac1870.kcst = kon_cam_t286
    Reac1871 = smodel.Reac('Reac1871', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, CaM3Ca])
    Reac1871.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pCaM3Ca_s4p -> CaMKII_s1p_s2p_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1872 = smodel.Reac('Reac1872', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pp])
    Reac1872.kcst = k_t350

    # CaMKII_s1p_s2p_s3p_s4p + CaM3Ca <->  CaMKII_s1p_s2p_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1873 = smodel.Reac('Reac1873', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p])
    Reac1873.kcst = kon_cam_t286
    Reac1874 = smodel.Reac('Reac1874', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2p_s3p_s4p, CaM3Ca])
    Reac1874.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pCaM3Ca_s4p -> CaMKII_s1p_s2pp_s3pCaM3Ca_s4p #autophosphorylation at Thr305
    Reac1875 = smodel.Reac('Reac1875', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p])
    Reac1875.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3pCaM3Ca_s4p -> CaMKII_s1pp_s2p_s3pCaM3Ca_s4p #autophosphorylation at Thr305
    Reac1876 = smodel.Reac('Reac1876', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p])
    Reac1876.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3pCaM3Ca_s4p -> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1877 = smodel.Reac('Reac1877', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp])
    Reac1877.kcst = k_t350
    
    # CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1878 = smodel.Reac('Reac1878', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac1878.kcst = kon_cam_t286
    Reac1879 = smodel.Reac('Reac1879', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, CaM3Ca])
    Reac1879.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p -> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1880 = smodel.Reac('Reac1880', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1880.kcst = k_t350
    
    # CaMKII_s1p_s2pCaM3Ca_s3p_s4p + CaM3Ca <->  CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1881 = smodel.Reac('Reac1881', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac1881.kcst = kon_cam_t286
    Reac1882 = smodel.Reac('Reac1882', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, CaM3Ca])
    Reac1882.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pCaM3Ca_s4p + CaM3Ca <->  CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac1883 = smodel.Reac('Reac1883', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac1883.kcst = kon_cam_t286
    Reac1884 = smodel.Reac('Reac1884', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, CaM3Ca])
    Reac1884.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p -> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p #autophosphorylation at Thr305
    Reac1885 = smodel.Reac('Reac1885', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac1885.kcst = k_t350
    
    # CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p -> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac1886 = smodel.Reac('Reac1886', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac1886.kcst = k_t350
    
    #dephosphorylation by PP1
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP1 <-> CaMKII_s1pCaM3CaPP1_s2p_s3p_s4p-> CaMKII_s1CaM3Ca_s2p_s3p_s4p + PP1        #dephosphorylation at T286/CaM
    Reac1887 = smodel.Reac('Reac1887', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2p_s3p_s4p])
    Reac1887.kcst = 3.3333e6
    Reac1888 = smodel.Reac('Reac1888', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP1])
    Reac1888.kcst = 8
    Reac1889 = smodel.Reac('Reac1889', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3p_s4p], rhs = [CaMKII_s1CaM3Ca_s2p_s3p_s4p, PP1])
    Reac1889.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4p-> CaMKII_s1pCaM3Ca_s2_s3p_s4p + PP1        #dephosphorylation at Thr305
    Reac1890 = smodel.Reac('Reac1890', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4p])
    Reac1890.kcst = 3.3333e6
    Reac1891 = smodel.Reac('Reac1891', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP1])
    Reac1891.kcst = 8
    Reac1892 = smodel.Reac('Reac1892', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2_s3p_s4p, PP1])
    Reac1892.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4p-> CaMKII_s1pCaM3Ca_s2p_s3_s4p + PP1        #dephosphorylation at Thr305
    Reac1893 = smodel.Reac('Reac1893', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4p])
    Reac1893.kcst = 3.3333e6
    Reac1894 = smodel.Reac('Reac1894', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP1])
    Reac1894.kcst = 8
    Reac1895 = smodel.Reac('Reac1895', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4p, PP1])
    Reac1895.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP1-> CaMKII_s1pCaM3Ca_s2p_s3p_s4 + PP1        #dephosphorylation at Thr305
    Reac1896 = smodel.Reac('Reac1896', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP1])
    Reac1896.kcst = 3.3333e6
    Reac1897 = smodel.Reac('Reac1897', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP1], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP1])
    Reac1897.kcst = 8
    Reac1898 = smodel.Reac('Reac1898', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4, PP1])
    Reac1898.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4p-> CaMKII_s1CaM3Ca_s2pp_s3p_s4p + PP1        #dephosphorylation at T286/CaM
    Reac1899 = smodel.Reac('Reac1899', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4p])
    Reac1899.kcst = 3.3333e6
    Reac1900 = smodel.Reac('Reac1900', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP1])
    Reac1900.kcst = 8
    Reac1901 = smodel.Reac('Reac1901', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4p], rhs = [CaMKII_s1CaM3Ca_s2pp_s3p_s4p, PP1])
    Reac1901.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4p-> CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP1        #dephosphorylation at T286/CaM
    Reac1902 = smodel.Reac('Reac1902', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4p])
    Reac1902.kcst = 3.3333e6
    Reac1903 = smodel.Reac('Reac1903', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP1])
    Reac1903.kcst = 8
    Reac1904 = smodel.Reac('Reac1904', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP1])
    Reac1904.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4p-> CaMKII_s1pCaM3Ca_s2pp_s3_s4p + PP1        #dephosphorylation at Thr305
    Reac1905 = smodel.Reac('Reac1905', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4p])
    Reac1905.kcst = 3.3333e6
    Reac1906 = smodel.Reac('Reac1906', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP1])
    Reac1906.kcst = 8
    Reac1907 = smodel.Reac('Reac1907', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4p, PP1])
    Reac1907.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP1-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4 + PP1        #dephosphorylation at Thr305
    Reac1908 = smodel.Reac('Reac1908', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP1])
    Reac1908.kcst = 3.3333e6
    Reac1909 = smodel.Reac('Reac1909', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP1], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP1])
    Reac1909.kcst = 8
    Reac1910 = smodel.Reac('Reac1910', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4, PP1])
    Reac1910.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4p-> CaMKII_s1CaM3Ca_s2pp_s3pp_s4p + PP1        #dephosphorylation at T286/CaM
    Reac1911 = smodel.Reac('Reac1911', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4p])
    Reac1911.kcst = 3.3333e6
    Reac1912 = smodel.Reac('Reac1912', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP1])
    Reac1912.kcst = 8
    Reac1913 = smodel.Reac('Reac1913', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4p], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pp_s4p, PP1])
    Reac1913.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4p-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP1        #dephosphorylation at T286/CaM
    Reac1914 = smodel.Reac('Reac1914', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4p])
    Reac1914.kcst = 3.3333e6
    Reac1915 = smodel.Reac('Reac1915', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP1])
    Reac1915.kcst = 8
    Reac1916 = smodel.Reac('Reac1916', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP1])
    Reac1916.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4p-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP1        #dephosphorylation at T286/CaM
    Reac1917 = smodel.Reac('Reac1917', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4p])
    Reac1917.kcst = 3.3333e6
    Reac1918 = smodel.Reac('Reac1918', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP1])
    Reac1918.kcst = 8
    Reac1919 = smodel.Reac('Reac1919', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP1])
    Reac1919.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP1-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4 + PP1        #dephosphorylation at Thr305
    Reac1920 = smodel.Reac('Reac1920', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP1])
    Reac1920.kcst = 3.3333e6
    Reac1921 = smodel.Reac('Reac1921', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP1], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP1])
    Reac1921.kcst = 8
    Reac1922 = smodel.Reac('Reac1922', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4, PP1])
    Reac1922.kcst = 2
    
    #CaMKII_s1p_s2pp_s3p_s4p + PP1 <-> CaMKII_s1pPP1_s2pp_s3p_s4p-> CaMKII_s1_s2pp_s3p_s4p + PP1        #dephosphorylation at Thr305
    Reac1923 = smodel.Reac('Reac1923', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1pPP1_s2pp_s3p_s4p])
    Reac1923.kcst = 3.3333e6
    Reac1924 = smodel.Reac('Reac1924', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3p_s4p], rhs =[CaMKII_s1p_s2pp_s3p_s4p, PP1])
    Reac1924.kcst = 8
    Reac1925 = smodel.Reac('Reac1925', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3p_s4p], rhs = [CaMKII_s1_s2pp_s3p_s4p, PP1])
    Reac1925.kcst = 2
    
    #CaMKII_s1p_s2pp_s3p_s4p + PP1 <-> CaMKII_s1p_s2ppPP1_s3p_s4p-> CaMKII_s1p_s2p_s3p_s4p + PP1        #dephosphorylation at T286/CaM
    Reac1926 = smodel.Reac('Reac1926', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1p_s2ppPP1_s3p_s4p])
    Reac1926.kcst = 3.3333e6
    Reac1927 = smodel.Reac('Reac1927', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3p_s4p], rhs =[CaMKII_s1p_s2pp_s3p_s4p, PP1])
    Reac1927 = 8
    Reac1928 = smodel.Reac('Reac1928', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3p_s4p], rhs = [CaMKII_s1p_s2p_s3p_s4p, PP1])
    Reac1928.kcst = 2
    
    #CaMKII_s1p_s2pp_s3p_s4p + PP1 <-> CaMKII_s1p_s2pp_s3pPP1_s4p-> CaMKII_s1p_s2pp_s3_s4p + PP1        #dephosphorylation at Thr305
    Reac1929 = smodel.Reac('Reac1929', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1p_s2pp_s3pPP1_s4p])
    Reac1929.kcst = 3.3333e6
    Reac1930 = smodel.Reac('Reac1930', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP1_s4p], rhs =[CaMKII_s1p_s2pp_s3p_s4p, PP1])
    Reac1930.kcst = 8
    Reac1931 = smodel.Reac('Reac1931', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP1_s4p], rhs = [CaMKII_s1p_s2pp_s3_s4p, PP1])
    Reac1931.kcst = 2
    
    #CaMKII_s1p_s2pp_s3p_s4p + PP1 <-> CaMKII_s1p_s2pp_s3p_s4pPP1-> CaMKII_s1p_s2pp_s3p_s4 + PP1        #dephosphorylation at Thr305
    Reac1932 = smodel.Reac('Reac1932', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1p_s2pp_s3p_s4pPP1])
    Reac1932.kcst = 3.3333e6
    Reac1933 = smodel.Reac('Reac1933', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pPP1], rhs =[CaMKII_s1p_s2pp_s3p_s4p, PP1])
    Reac1933.kcst = 8
    Reac1934 = smodel.Reac('Reac1934', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pPP1], rhs = [CaMKII_s1p_s2pp_s3p_s4, PP1])
    Reac1934.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3p_s4p + PP1 <-> CaMKII_s1ppPP1_s2pp_s3p_s4p-> CaMKII_s1p_s2pp_s3p_s4p + PP1        #dephosphorylation by PP1
    Reac1935 = smodel.Reac('Reac1935', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1ppPP1_s2pp_s3p_s4p])
    Reac1935.kcst = 3.3333e6
    Reac1936 = smodel.Reac('Reac1936', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3p_s4p], rhs =[CaMKII_s1pp_s2pp_s3p_s4p, PP1])
    Reac1936.kcst = 8
    Reac1937 = smodel.Reac('Reac1937', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3p_s4p], rhs = [CaMKII_s1p_s2pp_s3p_s4p, PP1])
    Reac1937.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3p_s4p + PP1 <-> CaMKII_s1pp_s2ppPP1_s3p_s4p-> CaMKII_s1pp_s2p_s3p_s4p + PP1        #dephosphorylation by PP1
    Reac1938 = smodel.Reac('Reac1938', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1pp_s2ppPP1_s3p_s4p])
    Reac1938.kcst = 3.3333e6
    Reac1939 = smodel.Reac('Reac1939', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3p_s4p], rhs =[CaMKII_s1pp_s2pp_s3p_s4p, PP1])
    Reac1939.kcst = 8
    Reac1940 = smodel.Reac('Reac1940', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3p_s4p], rhs = [CaMKII_s1pp_s2p_s3p_s4p, PP1])
    Reac1940.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3p_s4p + PP1 <-> CaMKII_s1pp_s2pp_s3pPP1_s4p-> CaMKII_s1pp_s2pp_s3_s4p + PP1        #dephosphorylation by PP1
    Reac1941 = smodel.Reac('Reac1941', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1pp_s2pp_s3pPP1_s4p])
    Reac1941.kcst = 3.3333e6
    Reac1942 = smodel.Reac('Reac1942', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP1_s4p], rhs =[CaMKII_s1pp_s2pp_s3p_s4p, PP1])
    Reac1942.kcst = 8
    Reac1943 = smodel.Reac('Reac1943', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP1_s4p], rhs = [CaMKII_s1pp_s2pp_s3_s4p, PP1])
    Reac1943.kcst = 2

    #CaMKII_s1pp_s2pp_s3p_s4p + PP1 <-> CaMKII_s1pp_s2pp_s3p_s4pPP1-> CaMKII_s1pp_s2pp_s3p_s4 + PP1        #dephosphorylation by PP1
    Reac1944 = smodel.Reac('Reac1944', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1pp_s2pp_s3p_s4pPP1])
    Reac1944.kcst = 3.3333e6
    Reac1945 = smodel.Reac('Reac1945', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pPP1], rhs =[CaMKII_s1pp_s2pp_s3p_s4p, PP1])
    Reac1945.kcst = 8
    Reac1946 = smodel.Reac('Reac1946', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pPP1], rhs = [CaMKII_s1pp_s2pp_s3p_s4, PP1])
    Reac1946.kcst = 2
    
    #CaMKII_s1p_s2p_s3p_s4p + PP1 <-> CaMKII_s1pPP1_s2p_s3p_s4p-> CaMKII_s1_s2p_s3p_s4p + PP1        #dephosphorylation by PP1
    Reac1947 = smodel.Reac('Reac1947', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1pPP1_s2p_s3p_s4p])
    Reac1947.kcst = 3.3333e6
    Reac1948 = smodel.Reac('Reac1948', vsys, lhs = [CaMKII_s1pPP1_s2p_s3p_s4p], rhs =[CaMKII_s1p_s2p_s3p_s4p, PP1])
    Reac1948.kcst = 8
    Reac1949 = smodel.Reac('Reac1949', vsys, lhs = [CaMKII_s1pPP1_s2p_s3p_s4p], rhs = [CaMKII_s1_s2p_s3p_s4p, PP1])
    Reac1949.kcst = 2
    
    #CaMKII_s1p_s2p_s3p_s4p + PP1 <-> CaMKII_s1p_s2pPP1_s3p_s4p-> CaMKII_s1p_s2_s3p_s4p + PP1        #dephosphorylation by PP1
    Reac1950 = smodel.Reac('Reac1950', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1p_s2pPP1_s3p_s4p])
    Reac1950.kcst = 3.3333e6
    Reac1951 = smodel.Reac('Reac1951', vsys, lhs = [CaMKII_s1p_s2pPP1_s3p_s4p], rhs =[CaMKII_s1p_s2p_s3p_s4p, PP1])
    Reac1951.kcst = 8
    Reac1952 = smodel.Reac('Reac1952', vsys, lhs = [CaMKII_s1p_s2pPP1_s3p_s4p], rhs = [CaMKII_s1p_s2_s3p_s4p, PP1])
    Reac1952.kcst = 2
    
    #CaMKII_s1p_s2p_s3p_s4p + PP1 <-> CaMKII_s1p_s2p_s3pPP1_s4p-> CaMKII_s1p_s2p_s3_s4p + PP1        #dephosphorylation by PP1
    Reac1953 = smodel.Reac('Reac1953', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1p_s2p_s3pPP1_s4p])
    Reac1953.kcst = 3.3333e6
    Reac1954 = smodel.Reac('Reac1954', vsys, lhs = [CaMKII_s1p_s2p_s3pPP1_s4p], rhs =[CaMKII_s1p_s2p_s3p_s4p, PP1])
    Reac1954.kcst = 8
    Reac1955 = smodel.Reac('Reac1955', vsys, lhs = [CaMKII_s1p_s2p_s3pPP1_s4p], rhs = [CaMKII_s1p_s2p_s3_s4p, PP1])
    Reac1955.kcst = 2
    
    #CaMKII_s1p_s2p_s3p_s4p + PP1 <-> CaMKII_s1p_s2p_s3p_s4pPP1-> CaMKII_s1p_s2p_s3p_s4 + PP1        #dephosphorylation by PP1
    Reac1956 = smodel.Reac('Reac1956', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1p_s2p_s3p_s4pPP1])
    Reac1956.kcst = 3.3333e6
    Reac1957 = smodel.Reac('Reac1957', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pPP1], rhs =[CaMKII_s1p_s2p_s3p_s4p, PP1])
    Reac1957.kcst = 8
    Reac1958 = smodel.Reac('Reac1958', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pPP1], rhs = [CaMKII_s1p_s2p_s3p_s4, PP1])
    Reac1958.kcst = 2

    #CaMKII_s1pp_s2p_s3p_s4p + PP1 <-> CaMKII_s1ppPP1_s2p_s3p_s4p-> CaMKII_s1p_s2p_s3p_s4p + PP1        #dephosphorylation by PP1
    Reac1959 = smodel.Reac('Reac1959', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1ppPP1_s2p_s3p_s4p])
    Reac1959.kcst = 3.3333e6
    Reac1960 = smodel.Reac('Reac1960', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3p_s4p], rhs =[CaMKII_s1pp_s2p_s3p_s4p, PP1])
    Reac1960.kcst = 8
    Reac1961 = smodel.Reac('Reac1961', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3p_s4p], rhs = [CaMKII_s1p_s2p_s3p_s4p, PP1])
    Reac1961.kcst = 2
    
    #CaMKII_s1pp_s2p_s3p_s4p + PP1 <-> CaMKII_s1pp_s2pPP1_s3p_s4p-> CaMKII_s1pp_s2_s3p_s4p + PP1        #dephosphorylation by PP1
    Reac1962 = smodel.Reac('Reac1962', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1pp_s2pPP1_s3p_s4p])
    Reac1962.kcst = 3.3333e6
    Reac1963 = smodel.Reac('Reac1963', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3p_s4p], rhs =[CaMKII_s1pp_s2p_s3p_s4p, PP1])
    Reac1963.kcst = 8
    Reac1964 = smodel.Reac('Reac1964', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3p_s4p], rhs = [CaMKII_s1pp_s2_s3p_s4p, PP1])
    Reac1964.kcst = 2
    
    #CaMKII_s1pp_s2p_s3p_s4p + PP1 <-> CaMKII_s1pp_s2p_s3pPP1_s4p-> CaMKII_s1pp_s2p_s3_s4p + PP1        #dephosphorylation by PP1
    Reac1965 = smodel.Reac('Reac1965', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1pp_s2p_s3pPP1_s4p])
    Reac1965.kcst = 3.3333e6
    Reac1966 = smodel.Reac('Reac1966', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP1_s4p], rhs =[CaMKII_s1pp_s2p_s3p_s4p, PP1])
    Reac1966.kcst = 8
    Reac1967 = smodel.Reac('Reac1967', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP1_s4p], rhs = [CaMKII_s1pp_s2p_s3_s4p, PP1])
    Reac1967.kcst = 2
    
    #CaMKII_s1pp_s2p_s3p_s4p + PP1 <-> CaMKII_s1pp_s2p_s3p_s4pPP1-> CaMKII_s1pp_s2p_s3p_s4 + PP1        #dephosphorylation by PP1
    Reac1968 = smodel.Reac('Reac1968', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1pp_s2p_s3p_s4pPP1])
    Reac1968.kcst = 3.3333e6
    Reac1969 = smodel.Reac('Reac1969', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pPP1], rhs =[CaMKII_s1pp_s2p_s3p_s4p, PP1])
    Reac1969.kcst = 8
    Reac1970 = smodel.Reac('Reac1970', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pPP1], rhs = [CaMKII_s1pp_s2p_s3p_s4, PP1])
    Reac1970.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4p-> CaMKII_s1_s2pCaM3Ca_s3p_s4p + PP1        #dephosphorylation by PP1
    Reac1971 = smodel.Reac('Reac1971', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4p])
    Reac1971.kcst = 3.3333e6
    Reac1972 = smodel.Reac('Reac1972', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1972.kcst = 8
    Reac1973 = smodel.Reac('Reac1973', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1973.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1p_s2pCaM3CaPP1_s3p_s4p-> CaMKII_s1p_s2CaM3Ca_s3p_s4p + PP1        #dephosphorylation by PP1
    Reac1974 = smodel.Reac('Reac1974', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1p_s2pCaM3CaPP1_s3p_s4p])
    Reac1974.kcst = 3.3333e6
    Reac1975 = smodel.Reac('Reac1975', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3p_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1975.kcst = 8
    Reac1976 = smodel.Reac('Reac1976', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3p_s4p], rhs = [CaMKII_s1p_s2CaM3Ca_s3p_s4p, PP1])
    Reac1976.kcst = 2

    #CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4p-> CaMKII_s1p_s2pCaM3Ca_s3_s4p + PP1        #dephosphorylation by PP1
    Reac1977 = smodel.Reac('Reac1977', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4p])
    Reac1977.kcst = 3.3333e6
    Reac1978 = smodel.Reac('Reac1978', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1978.kcst = 8
    Reac1979 = smodel.Reac('Reac1979', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4p, PP1])
    Reac1979.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP1-> CaMKII_s1p_s2pCaM3Ca_s3p_s4 + PP1        #dephosphorylation by PP1
    Reac1980 = smodel.Reac('Reac1980', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP1])
    Reac1980.kcst = 3.3333e6
    Reac1981 = smodel.Reac('Reac1981', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP1], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1981.kcst = 8
    Reac1982 = smodel.Reac('Reac1982', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4, PP1])
    Reac1982.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4p-> CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP1        #dephosphorylation by PP1
    Reac1983 = smodel.Reac('Reac1983', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4p])
    Reac1983.kcst = 3.3333e6
    Reac1984 = smodel.Reac('Reac1984', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1984.kcst = 8
    Reac1985 = smodel.Reac('Reac1985', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1985.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4p-> CaMKII_s1pp_s2CaM3Ca_s3p_s4p + PP1        #dephosphorylation by PP1
    Reac1986 = smodel.Reac('Reac1986', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4p])
    Reac1986.kcst = 3.3333e6
    Reac1987 = smodel.Reac('Reac1987', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1987.kcst = 8
    Reac1988 = smodel.Reac('Reac1988', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4p], rhs = [CaMKII_s1pp_s2CaM3Ca_s3p_s4p, PP1])
    Reac1988.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4p-> CaMKII_s1pp_s2pCaM3Ca_s3_s4p + PP1        #dephosphorylation by PP1
    Reac1989 = smodel.Reac('Reac1989', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4p])
    Reac1989.kcst = 3.3333e6
    Reac1990 = smodel.Reac('Reac1990', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1990.kcst = 8
    Reac1991 = smodel.Reac('Reac1991', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4p, PP1])
    Reac1991.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP1-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4 + PP1        #dephosphorylation by PP1
    Reac1992 = smodel.Reac('Reac1992', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP1])
    Reac1992.kcst = 3.3333e6
    Reac1993 = smodel.Reac('Reac1993', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP1], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP1])
    Reac1993.kcst = 8
    Reac1994 = smodel.Reac('Reac1994', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4, PP1])
    Reac1994.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4p-> CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac1995 = smodel.Reac('Reac1995', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4p])
    Reac1995.kcst = 3.3333e6
    Reac1996 = smodel.Reac('Reac1996', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP1])
    Reac1996.kcst = 8
    Reac1997 = smodel.Reac('Reac1997', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4p, PP1])
    Reac1997.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4p-> CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac1998 = smodel.Reac('Reac1998', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4p])
    Reac1998.kcst = 3.3333e6
    Reac1999 = smodel.Reac('Reac1999', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP1])
    Reac1999.kcst = 8
    Reac2000 = smodel.Reac('Reac2000', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4p, PP1])
    Reac2000.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4p-> CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2001 = smodel.Reac('Reac2001', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4p])
    Reac2001.kcst = 3.3333e6
    Reac2002 = smodel.Reac('Reac2002', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2002.kcst = 8
    Reac2003 = smodel.Reac('Reac2003', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4p, PP1])
    Reac2003.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP1-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4 + PP1        #dephosphorylation by PP1
    Reac2004 = smodel.Reac('Reac2004', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP1])
    Reac2004.kcst = 3.3333e6
    Reac2005 = smodel.Reac('Reac2005', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2005.kcst = 8
    Reac2006 = smodel.Reac('Reac2006', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4, PP1])
    Reac2006.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4p-> CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2007 = smodel.Reac('Reac2007', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4p])
    Reac2007.kcst = 3.3333e6
    Reac2008 = smodel.Reac('Reac2008', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2008.kcst = 8
    Reac2009 = smodel.Reac('Reac2009', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2009.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4p-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2010 = smodel.Reac('Reac2010', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4p])
    Reac2010.kcst = 3.3333e6
    Reac2011 = smodel.Reac('Reac2011', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2011.kcst = 8
    Reac2012 = smodel.Reac('Reac2012', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2012.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4p-> CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2013 = smodel.Reac('Reac2013', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4p])
    Reac2013.kcst = 3.3333e6
    Reac2014 = smodel.Reac('Reac2014', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4p, PP1])
    Reac2014.kcst = 8
    Reac2015 = smodel.Reac('Reac2015', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4p, PP1])
    Reac2015.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP1-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4 + PP1        #dephosphorylation by PP1
    Reac2016 = smodel.Reac('Reac2016', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP1])
    Reac2016.kcst = 3.3333e6
    Reac2017 = smodel.Reac('Reac2017', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2017.kcst = 8
    Reac2018 = smodel.Reac('Reac2018', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4, PP1])
    Reac2018.kcst = 2

    #CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4p-> CaMKII_s1_s2p_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2019 = smodel.Reac('Reac2019', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4p])
    Reac2019.kcst = 3.3333e6
    Reac2020 = smodel.Reac('Reac2020', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2020.kcst = 8
    Reac2021 = smodel.Reac('Reac2021', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2021.kcst = 2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4p-> CaMKII_s1p_s2_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2022 = smodel.Reac('Reac2022', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4p])
    Reac2022.kcst = 3.3333e6
    Reac2023 = smodel.Reac('Reac2023', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2023.kcst = 8
    Reac2024 = smodel.Reac('Reac2024', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2_s3pCaM3Ca_s4p, PP1])
    Reac2024.kcst = 2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1p_s2p_s3pCaM3CaPP1_s4p-> CaMKII_s1p_s2p_s3CaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2025 = smodel.Reac('Reac2025', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1p_s2p_s3pCaM3CaPP1_s4p])
    Reac2025.kcst = 3.3333e6
    Reac2026 = smodel.Reac('Reac2026', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2026.kcst = 8
    Reac2027 = smodel.Reac('Reac2027', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1p_s2p_s3CaM3Ca_s4p, PP1])
    Reac2027.kcst = 2

    #CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP1-> CaMKII_s1p_s2p_s3pCaM3Ca_s4 + PP1        #dephosphorylation by PP1
    Reac2028 = smodel.Reac('Reac2028', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP1])
    Reac2028.kcst = 3.3333e6
    Reac2029 = smodel.Reac('Reac2029', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2029.kcst = 8
    Reac2030 = smodel.Reac('Reac2030', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4, PP1])
    Reac2030.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4p-> CaMKII_s1_s2pp_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2031 = smodel.Reac('Reac2031', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4p])
    Reac2031.kcst = 3.3333e6
    Reac2032 = smodel.Reac('Reac2032', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2032.kcst = 8
    Reac2033 = smodel.Reac('Reac2033', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2033.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4p-> CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2034 = smodel.Reac('Reac2034', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4p])
    Reac2034.kcst = 3.3333e6
    Reac2035 = smodel.Reac('Reac2035', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2035.kcst = 8
    Reac2036 = smodel.Reac('Reac2036', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2036.kcst = 2

    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4p-> CaMKII_s1p_s2pp_s3CaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2037 = smodel.Reac('Reac2037', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4p])
    Reac2037.kcst = 3.3333e6
    Reac2038 = smodel.Reac('Reac2038', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2038.kcst = 8
    Reac2039 = smodel.Reac('Reac2039', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1p_s2pp_s3CaM3Ca_s4p, PP1])
    Reac2039.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP1-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4 + PP1        #dephosphorylation by PP1
    Reac2040 = smodel.Reac('Reac2040', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP1])
    Reac2040.kcst = 3.3333e6
    Reac2041 = smodel.Reac('Reac2041', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2041.kcst = 8
    Reac2042 = smodel.Reac('Reac2042', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4, PP1])
    Reac2042.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4p-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2043 = smodel.Reac('Reac2043', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4p])
    Reac2043.kcst = 3.3333e6
    Reac2044 = smodel.Reac('Reac2044', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2044.kcst = 8
    Reac2045 = smodel.Reac('Reac2045', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2045.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4p-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2046 = smodel.Reac('Reac2046', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4p])
    Reac2046.kcst = 3.3333e6
    Reac2047 = smodel.Reac('Reac2047', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2047.kcst = 8
    Reac2048 = smodel.Reac('Reac2048', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2048.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4p-> CaMKII_s1pp_s2pp_s3CaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2049 = smodel.Reac('Reac2049', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4p])
    Reac2049.kcst = 3.3333e6
    Reac2050 = smodel.Reac('Reac2050', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2050.kcst = 8
    Reac2051 = smodel.Reac('Reac2051', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1pp_s2pp_s3CaM3Ca_s4p, PP1])
    Reac2051.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP1-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4 + PP1        #dephosphorylation by PP1
    Reac2052 = smodel.Reac('Reac2052', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP1])
    Reac2052.kcst = 3.3333e6
    Reac2053 = smodel.Reac('Reac2053', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac2053.kcst = 8
    Reac2054 = smodel.Reac('Reac2054', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4, PP1])
    Reac2054.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4p-> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2055 = smodel.Reac('Reac2055', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac2055.kcst = 3.3333e6
    Reac2056 = smodel.Reac('Reac2056', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2056.kcst = 8
    Reac2057 = smodel.Reac('Reac2057', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2057.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4p-> CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2058 = smodel.Reac('Reac2058', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4p])
    Reac2058.kcst = 3.3333e6
    Reac2059 = smodel.Reac('Reac2059', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2059.kcst = 8
    Reac2060 = smodel.Reac('Reac2060', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2060.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4p-> CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2061 = smodel.Reac('Reac2061', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4p])
    Reac2061.kcst = 3.3333e6
    Reac2062 = smodel.Reac('Reac2062', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2062.kcst = 8
    Reac2063 = smodel.Reac('Reac2063', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4p, PP1])
    Reac2063.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP1-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4 + PP1        #dephosphorylation by PP1
    Reac2064 = smodel.Reac('Reac2064', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP1])
    Reac2064.kcst = 3.3333e6
    Reac2065 = smodel.Reac('Reac2065', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2065.kcst = 8
    Reac2066 = smodel.Reac('Reac2066', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4, PP1])
    Reac2066.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4p-> CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2067 = smodel.Reac('Reac2067', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4p])
    Reac2067.kcst = 3.3333e6
    Reac2068 = smodel.Reac('Reac2068', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2068.kcst = 8
    Reac2069 = smodel.Reac('Reac2069', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2069.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4p-> CaMKII_s1pp_s2_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2070 = smodel.Reac('Reac2070', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4p])
    Reac2070.kcst = 3.3333e6
    Reac2071 = smodel.Reac('Reac2071', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2071.kcst = 8
    Reac2072 = smodel.Reac('Reac2072', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2_s3pCaM3Ca_s4p, PP1])
    Reac2072.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4p-> CaMKII_s1pp_s2p_s3CaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2073 = smodel.Reac('Reac2073', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4p])
    Reac2073.kcst = 3.3333e6
    Reac2074 = smodel.Reac('Reac2074', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2074.kcst = 8
    Reac2075 = smodel.Reac('Reac2075', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1pp_s2p_s3CaM3Ca_s4p, PP1])
    Reac2075.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP1-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4 + PP1        #dephosphorylation by PP1
    Reac2076 = smodel.Reac('Reac2076', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP1])
    Reac2076.kcst = 3.3333e6
    Reac2077 = smodel.Reac('Reac2077', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP1])
    Reac2077.kcst = 8
    Reac2078 = smodel.Reac('Reac2078', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4, PP1])
    Reac2078.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4p-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2079 = smodel.Reac('Reac2079', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac2079.kcst = 3.3333e6
    Reac2080 = smodel.Reac('Reac2080', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2080.kcst = 8
    Reac2081 = smodel.Reac('Reac2081', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2081.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4p-> CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2082 = smodel.Reac('Reac2082', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4p])
    Reac2082.kcst = 3.3333e6
    Reac2083 = smodel.Reac('Reac2083', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2083.kcst = 8
    Reac2084 = smodel.Reac('Reac2084', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2084.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4p-> CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4p + PP1        #dephosphorylation by PP1
    Reac2085 = smodel.Reac('Reac2085', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4p])
    Reac2085.kcst = 3.3333e6
    Reac2086 = smodel.Reac('Reac2086', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2086.kcst = 8
    Reac2087 = smodel.Reac('Reac2087', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4p, PP1])
    Reac2087.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP1-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4 + PP1        #dephosphorylation by PP1
    Reac2088 = smodel.Reac('Reac2088', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP1])
    Reac2088.kcst = 3.3333e6
    Reac2089 = smodel.Reac('Reac2089', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac2089.kcst = 8
    Reac2090 = smodel.Reac('Reac2090', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4, PP1])
    Reac2090.kcst = 2
    
    ###dephoshorylation by PP2A
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4p-> CaMKII_s1CaM3Ca_s2p_s3p_s4p + PP2A        #dephosphorylation at T286/CaM
    Reac2091 = smodel.Reac('Reac2091', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4p])
    Reac2091.kcst = 0.2e6
    Reac2092 = smodel.Reac('Reac2092', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP2A])
    Reac2092.kcst = 0.8
    Reac2093 = smodel.Reac('Reac2093', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4p], rhs = [CaMKII_s1CaM3Ca_s2p_s3p_s4p, PP2A])
    Reac2093.kcst = 0.2

    #CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4p-> CaMKII_s1pCaM3Ca_s2_s3p_s4p + PP2A        #dephosphorylation at Thr305
    Reac2094 = smodel.Reac('Reac2094', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4p])
    Reac2094.kcst = 0.2e6
    Reac2095 = smodel.Reac('Reac2095', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP2A])
    Reac2095.kcst = 0.8
    Reac2096 = smodel.Reac('Reac2096', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2_s3p_s4p, PP2A])
    Reac2096.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4p-> CaMKII_s1pCaM3Ca_s2p_s3_s4p + PP2A        #dephosphorylation at Thr305
    Reac2097 = smodel.Reac('Reac2097', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4p])
    Reac2097.kcst = 0.2e6
    Reac2098 = smodel.Reac('Reac2098', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP2A])
    Reac2098.kcst = 0.8
    Reac2099 = smodel.Reac('Reac2099', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4p, PP2A])
    Reac2099.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP2A-> CaMKII_s1pCaM3Ca_s2p_s3p_s4 + PP2A        #dephosphorylation at Thr305
    Reac2100 = smodel.Reac('Reac2100', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP2A])
    Reac2100.kcst = 0.2e6
    Reac2101 = smodel.Reac('Reac2101', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP2A], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP2A])
    Reac2101.kcst = 0.8
    Reac2102 = smodel.Reac('Reac2102', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pPP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4, PP2A])
    Reac2102.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4p-> CaMKII_s1CaM3Ca_s2pp_s3p_s4p + PP2A        #dephosphorylation at T286/CaM
    Reac2103 = smodel.Reac('Reac2103', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4p])
    Reac2103.kcst = 0.2e6
    Reac2104 = smodel.Reac('Reac2104', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP2A])
    Reac2104.kcst = 0.8
    Reac2105 = smodel.Reac('Reac2105', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4p], rhs = [CaMKII_s1CaM3Ca_s2pp_s3p_s4p, PP2A])
    Reac2105.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4p-> CaMKII_s1pCaM3Ca_s2p_s3p_s4p + PP2A        #dephosphorylation at T286/CaM
    Reac2106 = smodel.Reac('Reac2106', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4p])
    Reac2106.kcst = 0.2e6
    Reac2107 = smodel.Reac('Reac2107', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP2A])
    Reac2107.kcst = 0.8
    Reac2108 = smodel.Reac('Reac2108', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, PP2A])
    Reac2108.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4p-> CaMKII_s1pCaM3Ca_s2pp_s3_s4p + PP2A        #dephosphorylation at Thr305
    Reac2109 = smodel.Reac('Reac2109', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4p])
    Reac2109.kcst = 0.2e6
    Reac2110 = smodel.Reac('Reac2110', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP2A])
    Reac2110.kcst = 0.8
    Reac2111 = smodel.Reac('Reac2111', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4p, PP2A])
    Reac2111.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP2A-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4 + PP2A        #dephosphorylation at Thr305
    Reac2112 = smodel.Reac('Reac2112', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP2A])
    Reac2112.kcst = 0.2e6
    Reac2113 = smodel.Reac('Reac2113', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP2A])
    Reac2113.kcst = 0.8
    Reac2114 = smodel.Reac('Reac2114', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4, PP2A])
    Reac2114.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4p-> CaMKII_s1CaM3Ca_s2pp_s3pp_s4p + PP2A        #dephosphorylation at T286/CaM
    Reac2115 = smodel.Reac('Reac2115', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4p])
    Reac2115.kcst = 0.2e6
    Reac2116 = smodel.Reac('Reac2116', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP2A])
    Reac2116.kcst = 0.8
    Reac2117 = smodel.Reac('Reac2117', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4p], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pp_s4p, PP2A])
    Reac2117.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4p-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + PP2A        #dephosphorylation at T286/CaM
    Reac2118 = smodel.Reac('Reac2118', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4p])
    Reac2118.kcst = 0.2e6
    Reac2119 = smodel.Reac('Reac2119', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP2A])
    Reac2119.kcst = 0.8
    Reac2120 = smodel.Reac('Reac2120', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, PP2A])
    Reac2120.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4p-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + PP2A        #dephosphorylation at T286/CaM
    Reac2121 = smodel.Reac('Reac2121', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4p])
    Reac2121.kcst = 0.2e6
    Reac2122 = smodel.Reac('Reac2122', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP2A])
    Reac2122.kcst = 0.8
    Reac2123 = smodel.Reac('Reac2123', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, PP2A])
    Reac2123.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP2A-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4 + PP2A        #dephosphorylation at Thr305
    Reac2124 = smodel.Reac('Reac2124', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP2A])
    Reac2124.kcst = 0.2e6
    Reac2125 = smodel.Reac('Reac2125', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, PP2A])
    Reac2125.kcst = 0.8
    Reac2126 = smodel.Reac('Reac2126', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4, PP2A])
    Reac2126.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3p_s4p + PP2A <-> CaMKII_s1pPP2A_s2pp_s3p_s4p-> CaMKII_s1_s2pp_s3p_s4p + PP2A        #dephosphorylation at Thr305
    Reac2127 = smodel.Reac('Reac2127', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1pPP2A_s2pp_s3p_s4p])
    Reac2127.kcst = 0.2e6
    Reac2128 = smodel.Reac('Reac2128', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3p_s4p], rhs =[CaMKII_s1p_s2pp_s3p_s4p, PP2A])
    Reac2128.kcst = 0.8
    Reac2129 = smodel.Reac('Reac2129', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3p_s4p], rhs = [CaMKII_s1_s2pp_s3p_s4p, PP2A])
    Reac2129.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3p_s4p + PP2A <-> CaMKII_s1p_s2ppPP2A_s3p_s4p-> CaMKII_s1p_s2p_s3p_s4p + PP2A        #dephosphorylation at T286/CaM
    Reac2130 = smodel.Reac('Reac2130', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1p_s2ppPP2A_s3p_s4p])
    Reac2130.kcst = 0.2e6
    Reac2131 = smodel.Reac('Reac2131', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3p_s4p], rhs =[CaMKII_s1p_s2pp_s3p_s4p, PP2A])
    Reac2131.kcst = 0.8
    Reac2132 = smodel.Reac('Reac2132', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3p_s4p], rhs = [CaMKII_s1p_s2p_s3p_s4p, PP2A])
    Reac2132.kcst = 0.2

    #CaMKII_s1p_s2pp_s3p_s4p + PP2A <-> CaMKII_s1p_s2pp_s3pPP2A_s4p-> CaMKII_s1p_s2pp_s3_s4p + PP2A        #dephosphorylation at Thr305
    Reac2133 = smodel.Reac('Reac2133', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1p_s2pp_s3pPP2A_s4p])
    Reac2133.kcst = 0.2e6
    Reac2134 = smodel.Reac('Reac2134', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP2A_s4p], rhs =[CaMKII_s1p_s2pp_s3p_s4p, PP2A])
    Reac2134.kcst = 0.8
    Reac2135 = smodel.Reac('Reac2135', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP2A_s4p], rhs = [CaMKII_s1p_s2pp_s3_s4p, PP2A])
    Reac2135.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3p_s4p + PP2A <-> CaMKII_s1p_s2pp_s3p_s4pPP2A-> CaMKII_s1p_s2pp_s3p_s4 + PP2A        #dephosphorylation by PP2A
    Reac2136 = smodel.Reac('Reac2136', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1p_s2pp_s3p_s4pPP2A])
    Reac2136.kcst = 0.2e6
    Reac2137 = smodel.Reac('Reac2137', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pPP2A], rhs =[CaMKII_s1p_s2pp_s3p_s4p, PP2A])
    Reac2137.kcst = 0.8
    Reac2138 = smodel.Reac('Reac2138', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pPP2A], rhs = [CaMKII_s1p_s2pp_s3p_s4, PP2A])
    Reac2138.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3p_s4p + PP2A <-> CaMKII_s1ppPP2A_s2pp_s3p_s4p-> CaMKII_s1p_s2pp_s3p_s4p + PP2A        #dephosphorylation by PP2A
    Reac2139 = smodel.Reac('Reac2139', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1ppPP2A_s2pp_s3p_s4p])
    Reac2139.kcst = 0.2e6
    Reac2140 = smodel.Reac('Reac2140', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3p_s4p], rhs =[CaMKII_s1pp_s2pp_s3p_s4p, PP2A])
    Reac2140.kcst = 0.8
    Reac2141 = smodel.Reac('Reac2141', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3p_s4p], rhs = [CaMKII_s1p_s2pp_s3p_s4p, PP2A])
    Reac2141.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3p_s4p + PP2A <-> CaMKII_s1pp_s2ppPP2A_s3p_s4p-> CaMKII_s1pp_s2p_s3p_s4p + PP2A        #dephosphorylation by PP2A
    Reac2142 = smodel.Reac('Reac2142', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1pp_s2ppPP2A_s3p_s4p])
    Reac2142.kcst = 0.2e6
    Reac2143 = smodel.Reac('Reac2143', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3p_s4p], rhs =[CaMKII_s1pp_s2pp_s3p_s4p, PP2A])
    Reac2143.kcst = 0.8
    Reac2144 = smodel.Reac('Reac2144', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3p_s4p], rhs = [CaMKII_s1pp_s2p_s3p_s4p, PP2A])
    Reac2144.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3p_s4p + PP2A <-> CaMKII_s1pp_s2pp_s3pPP2A_s4p-> CaMKII_s1pp_s2pp_s3_s4p + PP2A        #dephosphorylation by PP2A
    Reac2145 = smodel.Reac('Reac2145', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pPP2A_s4p])
    Reac2145.kcst = 0.2e6
    Reac2146 = smodel.Reac('Reac2146', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP2A_s4p], rhs =[CaMKII_s1pp_s2pp_s3p_s4p, PP2A])
    Reac2146.kcst = 0.8
    Reac2147 = smodel.Reac('Reac2147', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP2A_s4p], rhs = [CaMKII_s1pp_s2pp_s3_s4p, PP2A])
    Reac2147.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3p_s4p + PP2A <-> CaMKII_s1pp_s2pp_s3p_s4pPP2A-> CaMKII_s1pp_s2pp_s3p_s4 + PP2A        #dephosphorylation by PP2A
    Reac2148 = smodel.Reac('Reac2148', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1pp_s2pp_s3p_s4pPP2A])
    Reac2148.kcst = 0.2e6
    Reac2149 = smodel.Reac('Reac2149', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pPP2A], rhs =[CaMKII_s1pp_s2pp_s3p_s4p, PP2A])
    Reac2149.kcst = 0.8
    Reac2150 = smodel.Reac('Reac2150', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pPP2A], rhs = [CaMKII_s1pp_s2pp_s3p_s4, PP2A])
    Reac2150.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3p_s4p + PP2A <-> CaMKII_s1pPP2A_s2p_s3p_s4p-> CaMKII_s1_s2p_s3p_s4p + PP2A        #dephosphorylation by PP2A
    Reac2151 = smodel.Reac('Reac2151', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1pPP2A_s2p_s3p_s4p])
    Reac2151.kcst = 0.2e6
    Reac2152 = smodel.Reac('Reac2152', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3p_s4p], rhs =[CaMKII_s1p_s2p_s3p_s4p, PP2A])
    Reac2152.kcst = 0.8
    Reac2154 = smodel.Reac('Reac2154', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3p_s4p], rhs = [CaMKII_s1_s2p_s3p_s4p, PP2A])
    Reac2154.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3p_s4p + PP2A <-> CaMKII_s1p_s2pPP2A_s3p_s4p-> CaMKII_s1p_s2_s3p_s4p + PP2A        #dephosphorylation by PP2A
    Reac2155 = smodel.Reac('Reac2155', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1p_s2pPP2A_s3p_s4p])
    Reac2155.kcst = 0.2e6
    Reac2156 = smodel.Reac('Reac2156', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3p_s4p], rhs =[CaMKII_s1p_s2p_s3p_s4p, PP2A])
    Reac2156.kcst = 0.8
    Reac2157 = smodel.Reac('Reac2157', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3p_s4p], rhs = [CaMKII_s1p_s2_s3p_s4p, PP2A])
    Reac2157.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3p_s4p + PP2A <-> CaMKII_s1p_s2p_s3pPP2A_s4p-> CaMKII_s1p_s2p_s3_s4p + PP2A        #dephosphorylation by PP2A
    Reac2158 = smodel.Reac('Reac2158', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1p_s2p_s3pPP2A_s4p])
    Reac2158.kcst = 0.2e6
    Reac2159 = smodel.Reac('Reac2159', vsys, lhs = [CaMKII_s1p_s2p_s3pPP2A_s4p], rhs =[CaMKII_s1p_s2p_s3p_s4p, PP2A])
    Reac2159.kcst = 0.8
    Reac2160 = smodel.Reac('Reac2160', vsys, lhs = [CaMKII_s1p_s2p_s3pPP2A_s4p], rhs = [CaMKII_s1p_s2p_s3_s4p, PP2A])
    Reac2160.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3p_s4p + PP2A <-> CaMKII_s1p_s2p_s3p_s4pPP2A-> CaMKII_s1p_s2p_s3p_s4 + PP2A        #dephosphorylation by PP2A
    Reac2161 = smodel.Reac('Reac2161', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1p_s2p_s3p_s4pPP2A])
    Reac2161.kcst = 0.2e6
    Reac2162 = smodel.Reac('Reac2162', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pPP2A], rhs =[CaMKII_s1p_s2p_s3p_s4p, PP2A])
    Reac2162.kcst = 0.8
    Reac2163 = smodel.Reac('Reac2163', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pPP2A], rhs = [CaMKII_s1p_s2p_s3p_s4, PP2A])
    Reac2163.kcst = 0.2

    #CaMKII_s1pp_s2p_s3p_s4p + PP2A <-> CaMKII_s1ppPP2A_s2p_s3p_s4p-> CaMKII_s1p_s2p_s3p_s4p + PP2A        #dephosphorylation by PP2A
    Reac2164 = smodel.Reac('Reac2164', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1ppPP2A_s2p_s3p_s4p])
    Reac2164.kcst = 0.2e6
    Reac2165 = smodel.Reac('Reac2165', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3p_s4p], rhs =[CaMKII_s1pp_s2p_s3p_s4p, PP2A])
    Reac2165.kcst = 0.8
    Reac2166 = smodel.Reac('Reac2166', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3p_s4p], rhs = [CaMKII_s1p_s2p_s3p_s4p, PP2A])
    Reac2166.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3p_s4p + PP2A <-> CaMKII_s1pp_s2pPP2A_s3p_s4p-> CaMKII_s1pp_s2_s3p_s4p + PP2A        #dephosphorylation by PP2A
    Reac2167 = smodel.Reac('Reac2167', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1pp_s2pPP2A_s3p_s4p])
    Reac2167.kcst = 0.2e6
    Reac2168 = smodel.Reac('Reac2168', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3p_s4p], rhs =[CaMKII_s1pp_s2p_s3p_s4p, PP2A])
    Reac2168.kcst = 0.8
    Reac2169 = smodel.Reac('Reac2169', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3p_s4p], rhs = [CaMKII_s1pp_s2_s3p_s4p, PP2A])
    Reac2169.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3p_s4p + PP2A <-> CaMKII_s1pp_s2p_s3pPP2A_s4p-> CaMKII_s1pp_s2p_s3_s4p + PP2A        #dephosphorylation by PP2A
    Reac2170 = smodel.Reac('Reac2170', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1pp_s2p_s3pPP2A_s4p])
    Reac2170.kcst = 0.2e6
    Reac2171 = smodel.Reac('Reac2171', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP2A_s4p], rhs =[CaMKII_s1pp_s2p_s3p_s4p, PP2A])
    Reac2171.kcst = 0.8
    Reac2172 = smodel.Reac('Reac2172', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP2A_s4p], rhs = [CaMKII_s1pp_s2p_s3_s4p, PP2A])
    Reac2172.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3p_s4p + PP2A <-> CaMKII_s1pp_s2p_s3p_s4pPP2A-> CaMKII_s1pp_s2p_s3p_s4 + PP2A        #dephosphorylation by PP2A
    Reac2173 = smodel.Reac('Reac2173', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1pp_s2p_s3p_s4pPP2A])
    Reac2173.kcst = 0.2e6
    Reac2174 = smodel.Reac('Reac2174', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pPP2A], rhs =[CaMKII_s1pp_s2p_s3p_s4p, PP2A])
    Reac2174.kcst = 0.8
    Reac2175 = smodel.Reac('Reac2175', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pPP2A], rhs = [CaMKII_s1pp_s2p_s3p_s4, PP2A])
    Reac2175.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4p-> CaMKII_s1_s2pCaM3Ca_s3p_s4p + PP2A        #dephosphorylation by PP2A
    Reac2176 = smodel.Reac('Reac2176', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4p])
    Reac2176.kcst = 0.2e6
    Reac2177 = smodel.Reac('Reac2177', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac2177.kcst = 0.8
    Reac2178 = smodel.Reac('Reac2178', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac2178.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4p-> CaMKII_s1p_s2CaM3Ca_s3p_s4p + PP2A        #dephosphorylation by PP2A
    Reac2179 = smodel.Reac('Reac2179', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4p])
    Reac2179.kcst = 0.2e6
    Reac2180 = smodel.Reac('Reac2180', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac2180.kcst = 0.8
    Reac2181 = smodel.Reac('Reac2181', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4p], rhs = [CaMKII_s1p_s2CaM3Ca_s3p_s4p, PP2A])
    Reac2181.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4p-> CaMKII_s1p_s2pCaM3Ca_s3_s4p + PP2A        #dephosphorylation by PP2A
    Reac2182 = smodel.Reac('Reac2182', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4p])
    Reac2182.kcst = 0.2e6
    Reac2183 = smodel.Reac('Reac2183', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac2183.kcst = 0.8
    Reac2184 = smodel.Reac('Reac2184', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4p, PP2A])
    Reac2184.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP2A-> CaMKII_s1p_s2pCaM3Ca_s3p_s4 + PP2A        #dephosphorylation by PP2A
    Reac2185 = smodel.Reac('Reac2185', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP2A])
    Reac2185.kcst = 0.2e6
    Reac2186 = smodel.Reac('Reac2186', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP2A], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac2186.kcst = 0.8
    Reac2187 = smodel.Reac('Reac2187', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pPP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4, PP2A])
    Reac2187.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4p-> CaMKII_s1p_s2pCaM3Ca_s3p_s4p + PP2A        #dephosphorylation by PP2A
    Reac2188 = smodel.Reac('Reac2188', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4p])
    Reac2188.kcst = 0.2e6
    Reac2189 = smodel.Reac('Reac2189', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac2189.kcst = 0.8
    Reac2190 = smodel.Reac('Reac2190', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac2190.kcst = 0.2
    
    #CaMKIIs1pp_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4p-> CaMKII_s1pp_s2CaM3Ca_s3p_s4p + PP2A        #dephosphorylation by PP2A
    Reac2191 = smodel.Reac('Reac2191', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4p])
    Reac2191.kcst = 0.2e6
    Reac2192 = smodel.Reac('Reac2192', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac2192.kcst = 0.8
    Reac2193 = smodel.Reac('Reac2193', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4p], rhs = [CaMKII_s1pp_s2CaM3Ca_s3p_s4p, PP2A])
    Reac2193.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4p-> CaMKII_s1pp_s2pCaM3Ca_s3_s4p + PP2A        #dephosphorylation by PP2A
    Reac2194 = smodel.Reac('Reac2194', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4p])
    Reac2194.kcst = 0.2e6
    Reac2195 = smodel.Reac('Reac2195', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac2195.kcst = 0.8
    Reac2196 = smodel.Reac('Reac2196', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4p, PP2A])
    Reac2196.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP2A-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4 + PP2A        #dephosphorylation by PP2A
    Reac2197 = smodel.Reac('Reac2197', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP2A])
    Reac2197.kcst = 0.2e6
    Reac2198 = smodel.Reac('Reac2198', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP2A], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac2198.kcst = 0.8
    Reac2199 = smodel.Reac('Reac2199', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pPP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4, PP2A])
    Reac2199.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4p-> CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2200 = smodel.Reac('Reac2200', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4p])
    Reac2200.kcst = 0.2e6
    Reac2201 = smodel.Reac('Reac2201', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2201.kcst = 0.8
    Reac2202 = smodel.Reac('Reac2202', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2202.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4p-> CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2203 = smodel.Reac('Reac2203', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4p])
    Reac2203.kcst = 0.2e6
    Reac2204 = smodel.Reac('Reac2204', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2204.kcst = 0.8
    Reac2205 = smodel.Reac('Reac2205', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4p, PP2A])
    Reac2205.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4p-> CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2206 = smodel.Reac('Reac2206', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4p])
    Reac2206.kcst = 0.2e6
    Reac2207 = smodel.Reac('Reac2207', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2207.kcst = 0.8
    Reac2208 = smodel.Reac('Reac2208', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4p, PP2A])
    Reac2208.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP2A-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4 + PP2A        #dephosphorylation by PP2A
    Reac2209 = smodel.Reac('Reac2209', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP2A])
    Reac2209.kcst = 0.2e6
    Reac2210 = smodel.Reac('Reac2210', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2210.kcst = 0.8
    Reac2211 = smodel.Reac('Reac2211', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4, PP2A])
    Reac2211.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4p-> CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2212 = smodel.Reac('Reac2212', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4p])
    Reac2212.kcst = 0.2e6
    Reac2213 = smodel.Reac('Reac2213', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2213.kcst = 0.8
    Reac2214 = smodel.Reac('Reac2214', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2214.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4p-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2215 = smodel.Reac('Reac2215', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4p])
    Reac2215.kcst = 0.2e6
    Reac2216 = smodel.Reac('Reac2216', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2216.kcst = 0.8
    Reac2217 = smodel.Reac('Reac2217', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2217.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4p-> CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2218 = smodel.Reac('Reac2218', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4p])
    Reac2218.kcst = 0.2e6
    Reac2219 = smodel.Reac('Reac2219', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4p, PP2A])
    Reac2219.kcst = 0.8
    Reac2220 = smodel.Reac('Reac2220', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4p, PP2A])
    Reac2220.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP2A-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4 + PP2A        #dephosphorylation by PP2A
    Reac2221 = smodel.Reac('Reac2221', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP2A])
    Reac2221.kcst = 0.2e6
    Reac2222 = smodel.Reac('Reac2222', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2222.kcst = 0.8
    Reac2223 = smodel.Reac('Reac2223', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4, PP2A])
    Reac2223.kcst = 0.2

    #CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4p-> CaMKII_s1_s2p_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2224 = smodel.Reac('Reac2224', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4p])
    Reac2224.kcst = 0.2e6
    Reac2225 = smodel.Reac('Reac2225', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2225.kcst = 0.8
    Reac2226 = smodel.Reac('Reac2226', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2226.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4p-> CaMKII_s1p_s2_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2227 = smodel.Reac('Reac2227', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4p])
    Reac2227.kcst = 0.2e6
    Reac2228 = smodel.Reac('Reac2228', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2228.kcst = 0.8
    Reac2229 = smodel.Reac('Reac2229', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2_s3pCaM3Ca_s4p, PP2A])
    Reac2229.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4p-> CaMKII_s1p_s2p_s3CaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2230 = smodel.Reac('Reac2230', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4p])
    Reac2230.kcst = 0.2e6
    Reac2231 = smodel.Reac('Reac2231', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2231.kcst = 0.8
    Reac2232 = smodel.Reac('Reac2232', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1p_s2p_s3CaM3Ca_s4p, PP2A])
    Reac2232.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP2A-> CaMKII_s1p_s2p_s3pCaM3Ca_s4 + PP2A        #dephosphorylation by PP2A
    Reac2233 = smodel.Reac('Reac2233', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP2A])
    Reac2233.kcst = 0.2e6
    Reac2234 = smodel.Reac('Reac2234', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2234.kcst = 0.8
    Reac2235 = smodel.Reac('Reac2235', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4, PP2A])
    Reac2235.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4p-> CaMKII_s1_s2pp_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2236 = smodel.Reac('Reac2236', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4p])
    Reac2236.kcst = 0.2e6
    Reac2237 = smodel.Reac('Reac2237', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2237.kcst = 0.8
    Reac2238 = smodel.Reac('Reac2238', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2238.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4p-> CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2239 = smodel.Reac('Reac2239', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4p])
    Reac2239.kcst = 0.2e6
    Reac2240 = smodel.Reac('Reac2240', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2240.kcst = 0.8
    Reac2241 = smodel.Reac('Reac2241', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2241.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4p-> CaMKII_s1p_s2pp_s3CaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2242 = smodel.Reac('Reac2242', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4p])
    Reac2242.kcst = 0.2e6
    Reac2243 = smodel.Reac('Reac2243', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2243.kcst = 0.8
    Reac2244 = smodel.Reac('Reac2244', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1p_s2pp_s3CaM3Ca_s4p, PP2A])
    Reac2244.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP2A-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4 + PP2A        #dephosphorylation by PP2A
    Reac2245 = smodel.Reac('Reac2245', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP2A])
    Reac2245.kcst = 0.2e6
    Reac2246 = smodel.Reac('Reac2246', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2246.kcst = 0.8
    Reac2247 = smodel.Reac('Reac2247', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4, PP2A])
    Reac2247.kcst = 0.2

    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4p-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2248 = smodel.Reac('Reac2248', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4p])
    Reac2248.kcst = 0.2e6
    Reac2249 = smodel.Reac('Reac2249', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2249.kcst = 0.8
    Reac2250 = smodel.Reac('Reac2250', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2250.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4p-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2251 = smodel.Reac('Reac2251', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4p])
    Reac2251.kcst = 0.2e6
    Reac2252 = smodel.Reac('Reac2252', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2252.kcst = 0.8
    Reac2253 = smodel.Reac('Reac2253', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2253.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4p-> CaMKII_s1pp_s2pp_s3CaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2254 = smodel.Reac('Reac2254', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4p])
    Reac2254.kcst = 0.2e6
    Reac2255 = smodel.Reac('Reac2255', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2255.kcst = 0.8
    Reac2256 = smodel.Reac('Reac2256', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1pp_s2pp_s3CaM3Ca_s4p, PP2A])
    Reac2256.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP2A-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4 + PP2A        #dephosphorylation by PP2A
    Reac2257 = smodel.Reac('Reac2257', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP2A])
    Reac2257.kcst = 0.2e6
    Reac2258 = smodel.Reac('Reac2258', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac2258.kcst = 0.8
    Reac2259 = smodel.Reac('Reac2259', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4, PP2A])
    Reac2259.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p-> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2260 = smodel.Reac('Reac2260', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac2260.kcst = 0.2e6
    Reac2261 = smodel.Reac('Reac2261', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2261.kcst = 0.8
    Reac2262 = smodel.Reac('Reac2262', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2262.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4p-> CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2263 = smodel.Reac('Reac2263', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4p])
    Reac2263.kcst = 0.2e6
    Reac2264 = smodel.Reac('Reac2264', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2264.kcst = 0.8
    Reac2265 = smodel.Reac('Reac2265', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2265.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4p-> CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2266 = smodel.Reac('Reac2266', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4p])
    Reac2266.kcst = 0.2e6
    Reac2267 = smodel.Reac('Reac2267', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2267.kcst = 0.8
    Reac2268 = smodel.Reac('Reac2268', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4p, PP2A])
    Reac2268.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4 + PP2A        #dephosphorylation by PP2A
    Reac2269 = smodel.Reac('Reac2269', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A])
    Reac2269.kcst = 0.2e6
    Reac2270 = smodel.Reac('Reac2270', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2270.kcst = 0.8
    Reac2271 = smodel.Reac('Reac2271', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4, PP2A])
    Reac2271.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4p-> CaMKII_s1p_s2p_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2272 = smodel.Reac('Reac2272', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4p])
    Reac2272.kcst = 0.2e6
    Reac2273 = smodel.Reac('Reac2273', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2273.kcst = 0.8
    Reac2274 = smodel.Reac('Reac2274', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2274.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4p-> CaMKII_s1pp_s2_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2275 = smodel.Reac('Reac2275', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4p])
    Reac2275.kcst = 0.2e6
    Reac2276 = smodel.Reac('Reac2276', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2276.kcst = 0.8
    Reac2277 = smodel.Reac('Reac2277', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2_s3pCaM3Ca_s4p, PP2A])
    Reac2277.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4p-> CaMKII_s1pp_s2p_s3CaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2278 = smodel.Reac('Reac2278', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4p])
    Reac2278.kcst = 0.2e6
    Reac2279 = smodel.Reac('Reac2279', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2279.kcst = 0.8
    Reac2280 = smodel.Reac('Reac2280', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1pp_s2p_s3CaM3Ca_s4p, PP2A])
    Reac2280.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP2A-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4 + PP2A        #dephosphorylation by PP2A
    Reac2281 = smodel.Reac('Reac2281', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP2A])
    Reac2281.kcst = 0.2e6
    Reac2282 = smodel.Reac('Reac2282', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac2282.kcst = 0.8
    Reac2283 = smodel.Reac('Reac2283', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4, PP2A])
    Reac2283.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2284 = smodel.Reac('Reac2284', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac2284.kcst = 0.2e6
    Reac2285 = smodel.Reac('Reac2285', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2285.kcst = 0.8
    Reac2286 = smodel.Reac('Reac2286', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2286.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4p-> CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2287 = smodel.Reac('Reac2287', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4p])
    Reac2287.kcst = 0.2e6
    Reac2288 = smodel.Reac('Reac2288', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2288.kcst = 0.8
    Reac2289 = smodel.Reac('Reac2289', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4p], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2289.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4p-> CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4p + PP2A        #dephosphorylation by PP2A
    Reac2290 = smodel.Reac('Reac2290', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4p])
    Reac2290.kcst = 0.2e6
    Reac2291 = smodel.Reac('Reac2291', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2291.kcst = 0.8
    Reac2292 = smodel.Reac('Reac2292', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4p, PP2A])
    Reac2292.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4 + PP2A        #dephosphorylation by PP2A
    Reac2293 = smodel.Reac('Reac2293', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A])
    Reac2293.kcst = 0.2e6
    Reac2294 = smodel.Reac('Reac2294', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac2294.kcst = 0.8
    Reac2295 = smodel.Reac('Reac2295', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4, PP2A])
    Reac2295.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2296 = smodel.Reac('Reac2296', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac2296.kcst = kon_cam_t286
    Reac2297 = smodel.Reac('Reac2297', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2297.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca #autophosphorylation at Thr305
    Reac2298 = smodel.Reac('Reac2298', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2298.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2299 = smodel.Reac('Reac2299', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2299.kcst = kon_cam_t286
    Reac2300 = smodel.Reac('Reac2300', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p, CaM3Ca])
    Reac2300.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2301 = smodel.Reac('Reac2301', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2301.kcst = kon_cam_t286
    Reac2302 = smodel.Reac('Reac2302', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, CaM3Ca])
    Reac2302.kcst = koff_cam_t286
    
    
    # CaMKII_s1pCaM3Ca_s2p_s3pp_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2303 = smodel.Reac('Reac2303', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca])
    Reac2303.kcst = kon_cam_t286
    Reac2304 = smodel.Reac('Reac2304', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4p, CaM3Ca])
    Reac2304.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca #autophosphorylation at Thr305
    Reac2305 = smodel.Reac('Reac2305', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca])
    Reac2305.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2306 = smodel.Reac('Reac2306', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca])
    Reac2306.kcst = kon_cam_t286
    Reac2307 = smodel.Reac('Reac2307', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p, CaM3Ca])
    Reac2307.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2308 = smodel.Reac('Reac2308', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca])
    Reac2308.kcst = kon_cam_t286
    Reac2309 = smodel.Reac('Reac2309', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, CaM3Ca])
    Reac2309.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3pp_s4p + CaM3Ca <->  CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2310 = smodel.Reac('Reac2310', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca])
    Reac2310.kcst = kon_cam_t286
    Reac2311 = smodel.Reac('Reac2311', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pp_s4p, CaM3Ca])
    Reac2311.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca -> CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca #autophosphorylation at Thr305
    Reac2312 = smodel.Reac('Reac2312', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca])
    Reac2312.kcst = k_t350
    
    # CaMKII_s1pp_s2pp_s3pp_s4p + CaM3Ca <->  CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2313 = smodel.Reac('Reac2313', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca])
    Reac2313.kcst = kon_cam_t286
    Reac2314 = smodel.Reac('Reac2314', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pp_s4p, CaM3Ca])
    Reac2314.kcst = koff_cam_t286

    # CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2315 = smodel.Reac('Reac2315', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca])
    Reac2315.kcst = kon_cam_t286
    Reac2316 = smodel.Reac('Reac2316', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, CaM3Ca])
    Reac2316.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pp_s4p + CaM3Ca <->  CaMKII_s1p_s2p_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2317 = smodel.Reac('Reac2317', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca])
    Reac2317.kcst = kon_cam_t286
    Reac2318 = smodel.Reac('Reac2318', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pp_s4p, CaM3Ca])
    Reac2318.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pp_s4p -> CaMKII_s1p_s2p_s3pp_s4pp  #autophosphorylation at Thr305
    Reac2319 = smodel.Reac('Reac2319', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p], rhs = [CaMKII_s1p_s2p_s3pp_s4pp])
    Reac2319.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3pp_s4p -> CaMKII_s1p_s2pp_s3pp_s4p  #autophosphorylation at Thr305                                                                       
    Reac2320 = smodel.Reac('Reac2320', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4p], rhs = [CaMKII_s1p_s2pp_s3pp_s4p])
    Reac2320.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3pp_s4pCaM3Ca -> CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2321 = smodel.Reac('Reac2321', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca])
    Reac2321.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3pp_s4pCaM3Ca -> CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2322 = smodel.Reac('Reac2322', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca])
    Reac2322.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3pp_s4p + CaM3Ca <->  CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2323 = smodel.Reac('Reac2323', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca])
    Reac2323.kcst = kon_cam_t286
    Reac2324 = smodel.Reac('Reac2324', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pp_s4p, CaM3Ca])
    Reac2324.kcst = koff_cam_t286
    
    # CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca -> CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2325 = smodel.Reac('Reac2325', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca])
    Reac2325.kcst = k_t350
    
    # CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2326 = smodel.Reac('Reac2326', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2326.kcst = kon_cam_t286
    Reac2327 = smodel.Reac('Reac2327', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, CaM3Ca])
    Reac2327.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3pp_s4p + CaM3Ca <->  CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2328 = smodel.Reac('Reac2328', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2328.kcst = kon_cam_t286
    Reac2329 = smodel.Reac('Reac2329', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4p, CaM3Ca])
    Reac2329.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2330 = smodel.Reac('Reac2330', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2330.kcst = kon_cam_t286
    Reac2331 = smodel.Reac('Reac2331', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, CaM3Ca])
    Reac2331.kcst = koff_cam_t286
    
    # CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca -> CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2332 = smodel.Reac('Reac2332', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca])
    Reac2332.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2333 = smodel.Reac('Reac2333', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2333.kcst = kon_cam_t286
    Reac2334 = smodel.Reac('Reac2334', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2334.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2335 = smodel.Reac('Reac2335', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca])
    Reac2335.kcst = kon_cam_t286
    Reac2336 = smodel.Reac('Reac2336', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4p, CaM3Ca])
    Reac2336.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2337 = smodel.Reac('Reac2337', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca])
    Reac2337.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2338 = smodel.Reac('Reac2338', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca])
    Reac2338.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pp_s3p_s4p + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2339 = smodel.Reac('Reac2339', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca])
    Reac2339.kcst = kon_cam_t286
    Reac2340 = smodel.Reac('Reac2340', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4p, CaM3Ca])
    Reac2340.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2341 = smodel.Reac('Reac2341', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca])
    Reac2341.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2342 = smodel.Reac('Reac2342', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca])
    Reac2342.kcst = kon_cam_t286
    Reac2343 = smodel.Reac('Reac2343', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2343.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3p_s4p + CaM3Ca <->  CaMKII_s1p_s2pp_s3p_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac2344 = smodel.Reac('Reac2344', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca])
    Reac2344.kcst = kon_cam_t286
    Reac2345 = smodel.Reac('Reac2345', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3p_s4p, CaM3Ca])
    Reac2345.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3p_s4pCaM3Ca -> CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2346 = smodel.Reac('Reac2346', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca])
    Reac2346.kcst = k_t350
    
    # CaMKII_s1p_s2pp_s3p_s4pCaM3Ca -> CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2347 = smodel.Reac('Reac2347', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca])
    Reac2347.kcst = k_t350
    
    # CaMKII_s1pp_s2pp_s3p_s4p + CaM3Ca <-> CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2348 = smodel.Reac('Reac2348', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca])
    Reac2348.kcst = kon_cam_t286
    Reac2349 = smodel.Reac('Reac2349', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3p_s4p, CaM3Ca])
    Reac2349.kcst = koff_cam_t286
    
    # CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca -> CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2350 = smodel.Reac('Reac2350', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca])
    Reac2350.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4pCaM3Ca + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2351 = smodel.Reac('Reac2351', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca])
    Reac2351.kcst = kon_cam_t286
    Reac2352 = smodel.Reac('Reac2352', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2352.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3p_s4p + CaM3Ca <-> CaMKII_s1p_s2p_s3p_s4pCaM3Ca
    Reac2353 = smodel.Reac('Reac2353', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca])
    Reac2353.kcst = kon_cam_t286
    Reac2354 = smodel.Reac('Reac2354', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4p, CaM3Ca])
    Reac2354.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2355 = smodel.Reac('Reac2355', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2355.kcst = kon_cam_t286
    Reac2356 = smodel.Reac('Reac2356', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2356.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3p_s4p + CaM3Ca <-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2357 = smodel.Reac('Reac2357', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2357.kcst = kon_cam_t286
    Reac2358 = smodel.Reac('Reac2358', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4p, CaM3Ca])
    Reac2358.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca -> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2359 = smodel.Reac('Reac2359', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2359.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4pCaM3Ca + CaM3Ca <-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2360 = smodel.Reac('Reac2360', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2360.kcst = kon_cam_t286
    Reac2361 = smodel.Reac('Reac2361', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2361.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3p_s4p + CaM3Ca <-> CaMKII_s1p_s2p_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2362 = smodel.Reac('Reac2362', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca])
    Reac2362.kcst = kon_cam_t286
    Reac2363 = smodel.Reac('Reac2363', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4p, CaM3Ca])
    Reac2363.kcst = koff_cam_t286

    # CaMKII_s1p_s2p_s3p_s4pCaM3Ca -> CaMKII_s1p_s2p_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2364 = smodel.Reac('Reac2364', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca])
    Reac2364.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4pCaM3Ca -> CaMKII_s1p_s2pp_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2365 = smodel.Reac('Reac2365', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca])
    Reac2365.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3p_s4pCaM3Ca -> CaMKII_s1pp_s2p_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2366 = smodel.Reac('Reac2366', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca])
    Reac2366.kcst = k_t350
    
    # CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca -> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2367 = smodel.Reac('Reac2367', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2367.kcst = k_t350
    
    # CaMKII_s1pp_s2pCaM3Ca_s3p_s4p + CaM3Ca <-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2368 = smodel.Reac('Reac2368', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2368.kcst = kon_cam_t286
    Reac2369 = smodel.Reac('Reac2369', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4p, CaM3Ca])
    Reac2369.kcst = koff_cam_t286
    
    # CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca -> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2370 = smodel.Reac('Reac2370', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2370.kcst = k_t350
    
    # CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p  + CaM3Ca <-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2371 = smodel.Reac('Reac2371', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2371.kcst = kon_cam_t286
    Reac2372 = smodel.Reac('Reac2372', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p, CaM3Ca])
    Reac2372.kcst = koff_cam_t286
    
    # CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca -> CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2373 = smodel.Reac('Reac2373', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca])
    Reac2373.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca  + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2374 = smodel.Reac('Reac2374', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac2374.kcst = kon_cam_t286
    Reac2375 = smodel.Reac('Reac2375', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca])
    Reac2375.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2376 = smodel.Reac('Reac2376', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2376.kcst = k_t350
    
    # CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p  + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2377 = smodel.Reac('Reac2377', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2377.kcst = kon_cam_t286
    Reac2378 = smodel.Reac('Reac2378', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p, CaM3Ca])
    Reac2378.kcst = koff_cam_t286
    
    # CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca  + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2379 = smodel.Reac('Reac2379', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2379.kcst = kon_cam_t286
    Reac2380 = smodel.Reac('Reac2380', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2380.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca  + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2381 = smodel.Reac('Reac2381', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2381.kcst = kon_cam_t286
    Reac2382 = smodel.Reac('Reac2382', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca])
    Reac2382.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3pCaM3Ca_s4p  + CaM3Ca <-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2383 = smodel.Reac('Reac2383', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2383.kcst = kon_cam_t286
    Reac2384 = smodel.Reac('Reac2384', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4p, CaM3Ca])
    Reac2384.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3p_s4pCaM3Ca  + CaM3Ca <-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2385 = smodel.Reac('Reac2385', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2385.kcst = kon_cam_t286
    Reac2386 = smodel.Reac('Reac2386', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2386.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2387 = smodel.Reac('Reac2387', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2387.kcst = k_t350
    
    # CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p  + CaM3Ca <-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2388 = smodel.Reac('Reac2388', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2388.kcst = kon_cam_t286
    Reac2389 = smodel.Reac('Reac2389', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p, CaM3Ca])
    Reac2389.kcst = koff_cam_t286
    
    # CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca  + CaM3Ca <-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2390 = smodel.Reac('Reac2390', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2390.kcst = kon_cam_t286
    Reac2391 = smodel.Reac('Reac2391', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2391.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca  + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2392 = smodel.Reac('Reac2392', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2392.kcst = kon_cam_t286
    Reac2393 = smodel.Reac('Reac2393', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca])
    Reac2393.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3pCaM3Ca_s4p  + CaM3Ca <-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2394 = smodel.Reac('Reac2394', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2394.kcst = kon_cam_t286
    Reac2395 = smodel.Reac('Reac2395', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4p, CaM3Ca])
    Reac2395.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2p_s3p_s4pCaM3Ca  + CaM3Ca <-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2396 = smodel.Reac('Reac2396', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2396.kcst = kon_cam_t286
    Reac2397 = smodel.Reac('Reac2397', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2397.kcst = koff_cam_t286

    # CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2398 = smodel.Reac('Reac2398', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2398.kcst = k_t350
    
    # CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2399 = smodel.Reac('Reac2399', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2399.kcst = k_t350
    
    # CaMKII_s1pp_s2p_s3pCaM3Ca_s4p  + CaM3Ca <-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2400 = smodel.Reac('Reac2400', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2400.kcst = kon_cam_t286
    Reac2401 = smodel.Reac('Reac2401', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4p, CaM3Ca])
    Reac2401.kcst = koff_cam_t286
    
    # CaMKII_s1pp_s2p_s3p_s4pCaM3Ca  + CaM3Ca <-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2402 = smodel.Reac('Reac2402', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2402.kcst = kon_cam_t286
    Reac2403 = smodel.Reac('Reac2403', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2403.kcst = koff_cam_t286

    # CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2404 = smodel.Reac('Reac2404', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2404.kcst = k_t350
    
    # CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca  + CaM3Ca <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2405 = smodel.Reac('Reac2405', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac2405.kcst = kon_cam_t286
    Reac2406 = smodel.Reac('Reac2406', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca])
    Reac2406.kcst = koff_cam_t286
    
    # CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2407 = smodel.Reac('Reac2407', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac2407.kcst = k_t350
    
    # CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p  + CaM3Ca <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2408 = smodel.Reac('Reac2408', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac2408.kcst = kon_cam_t286
    Reac2409 = smodel.Reac('Reac2409', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p, CaM3Ca])
    Reac2409.kcst = koff_cam_t286
    
    # CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca  + CaM3Ca <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2410 = smodel.Reac('Reac2410', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac2410.kcst = kon_cam_t286
    Reac2411 = smodel.Reac('Reac2411', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, CaM3Ca])
    Reac2411.kcst = koff_cam_t286
    
    # CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca  + CaM3Ca <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca  #autophosphorylation at Thr305
    Reac2412 = smodel.Reac('Reac2412', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac2412.kcst = kon_cam_t286
    Reac2413 = smodel.Reac('Reac2413', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca])
    Reac2413.kcst = koff_cam_t286

    ####dephosphorylation by PP1
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2414 = smodel.Reac('Reac2414', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2414.kcst = 3.3333e6
    Reac2415 = smodel.Reac('Reac2415', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2415.kcst = 8
    Reac2416 = smodel.Reac('Reac2416', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2416.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2417 = smodel.Reac('Reac2417', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pCaM3Ca])
    Reac2417.kcst = 3.3333e6
    Reac2418 = smodel.Reac('Reac2418', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2418.kcst = 8
    Reac2419 = smodel.Reac('Reac2419', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2419.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2420 = smodel.Reac('Reac2420', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca])
    Reac2420.kcst = 3.3333e6
    Reac2421 = smodel.Reac('Reac2421', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2421.kcst = 8
    Reac2422 = smodel.Reac('Reac2422', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2422.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP1-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2423 = smodel.Reac('Reac2423', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP1])
    Reac2423.kcst = 3.3333e6
    Reac2424 = smodel.Reac('Reac2424', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP1], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2424.kcst = 8
    Reac2425 = smodel.Reac('Reac2425', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4CaM3Ca, PP1])
    Reac2425.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2p_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2426 = smodel.Reac('Reac2426', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pCaM3Ca])
    Reac2426.kcst = 3.3333e6
    Reac2427 = smodel.Reac('Reac2427', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2427.kcst = 8
    Reac2428 = smodel.Reac('Reac2428', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2428.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2429 = smodel.Reac('Reac2429', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pCaM3Ca])
    Reac2429.kcst = 3.3333e6
    Reac2430 = smodel.Reac('Reac2430', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2430.kcst = 8
    Reac2431 = smodel.Reac('Reac2431', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3pp_s4pCaM3Ca, PP1])
    Reac2431.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2432 = smodel.Reac('Reac2432', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4pCaM3Ca])
    Reac2432.kcst = 3.3333e6
    Reac2433 = smodel.Reac('Reac2433', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2433.kcst = 8
    Reac2434 = smodel.Reac('Reac2434', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP1_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2434.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP1-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2435 = smodel.Reac('Reac2435', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP1])
    Reac2435.kcst = 3.3333e6
    Reac2436 = smodel.Reac('Reac2436', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP1], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2436.kcst = 8
    Reac2437 = smodel.Reac('Reac2437', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4CaM3Ca, PP1])
    Reac2437.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pp_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2438 = smodel.Reac('Reac2438', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pCaM3Ca])
    Reac2438.kcst = 3.3333e6
    Reac2439 = smodel.Reac('Reac2439', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2439.kcst = 8
    Reac2440 = smodel.Reac('Reac2440', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2440.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2441 = smodel.Reac('Reac2441', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pCaM3Ca])
    Reac2441.kcst = 3.3333e6
    Reac2442 = smodel.Reac('Reac2442', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2442.kcst = 8
    Reac2443 = smodel.Reac('Reac2443', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2443.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2444 = smodel.Reac('Reac2444', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pCaM3Ca])
    Reac2444.kcst = 3.3333e6
    Reac2445 = smodel.Reac('Reac2445', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2445.kcst = 8
    Reac2446 = smodel.Reac('Reac2446', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP1_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2446.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP1-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2447 = smodel.Reac('Reac2447', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP1])
    Reac2447.kcst = 3.3333e6
    Reac2448 = smodel.Reac('Reac2448', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP1], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2448.kcst = 8
    Reac2449 = smodel.Reac('Reac2449', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4CaM3Ca, PP1])
    Reac2449.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pPP1_s2pp_s3pp_s4pCaM3Ca-> CaMKII_s1_s2pp_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2450 = smodel.Reac('Reac2450', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pPP1_s2pp_s3pp_s4pCaM3Ca])
    Reac2450.kcst = 3.3333e6
    Reac2451 = smodel.Reac('Reac2451', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2451.kcst = 8
    Reac2452 = smodel.Reac('Reac2452', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2452.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2ppPP1_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2453 = smodel.Reac('Reac2453', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2ppPP1_s3pp_s4pCaM3Ca])
    Reac2453.kcst = 3.3333e6
    Reac2454 = smodel.Reac('Reac2454', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2454.kcst = 8
    Reac2455 = smodel.Reac('Reac2455', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2455.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pp_s3ppPP1_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2456= smodel.Reac('Reac2456', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pp_s3ppPP1_s4pCaM3Ca])
    Reac2456.kcst = 3.3333e6
    Reac2457 = smodel.Reac('Reac2457', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP1_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2457.kcst = 8
    Reac2458 = smodel.Reac('Reac2458', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP1_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2458.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP1-> CaMKII_s1p_s2pp_s3pp_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2459 = smodel.Reac('Reac2459', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP1])
    Reac2459.kcst = 3.3333e6
    Reac2460 = smodel.Reac('Reac2460', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP1], rhs =[CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2460.kcst = 8
    Reac2461 = smodel.Reac('Reac2461', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP1], rhs = [CaMKII_s1p_s2pp_s3pp_s4CaM3Ca, PP1])
    Reac2461.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1ppPP1_s2pp_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2462 = smodel.Reac('Reac2462', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1ppPP1_s2pp_s3pp_s4pCaM3Ca])
    Reac2462.kcst = 3.3333e6
    Reac2463 = smodel.Reac('Reac2463', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2463.kcst = 8
    Reac2464 = smodel.Reac('Reac2464', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2464.kcst = 2

    #CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2ppPP1_s3pp_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2465 = smodel.Reac('Reac2465', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2ppPP1_s3pp_s4pCaM3Ca])
    Reac2465.kcst = 3.3333e6
    Reac2466 = smodel.Reac('Reac2466', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2466.kcst = 8
    Reac2467 = smodel.Reac('Reac2467', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2467.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pp_s3ppPP1_s4pCaM3Ca-> CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2468 = smodel.Reac('Reac2468', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pp_s3ppPP1_s4pCaM3Ca])
    Reac2468.kcst = 3.3333e6
    Reac2469 = smodel.Reac('Reac2469', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP1_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2469.kcst = 8
    Reac2470 = smodel.Reac('Reac2470', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP1_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2470.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP1-> CaMKII_s1pp_s2pp_s3pp_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2471 = smodel.Reac('Reac2471', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP1])
    Reac2471.kcst = 3.3333e6
    Reac2472 = smodel.Reac('Reac2472', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP1], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP1])
    Reac2472.kcst = 8
    Reac2473 = smodel.Reac('Reac2473', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP1], rhs = [CaMKII_s1pp_s2pp_s3pp_s4CaM3Ca, PP1])
    Reac2473.kcst = 2
    
    #CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pPP1_s2p_s3pp_s4pCaM3Ca-> CaMKII_s1_s2p_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2474 = smodel.Reac('Reac2474', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pPP1_s2p_s3pp_s4pCaM3Ca])
    Reac2474.kcst = 3.3333e6
    Reac2475 = smodel.Reac('Reac2475', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2475.kcst = 8
    Reac2476 = smodel.Reac('Reac2476', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2476.kcst = 2
    
    #CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pPP1_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2477 = smodel.Reac('Reac2477', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pPP1_s3pp_s4pCaM3Ca])
    Reac2477.kcst = 3.3333e6
    Reac2478 = smodel.Reac('Reac2478', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2478.kcst = 8
    Reac2479 = smodel.Reac('Reac2479', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2_s3pp_s4pCaM3Ca, PP1])
    Reac2479.kcst = 2
    
    #CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2p_s3ppPP1_s4pCaM3Ca-> CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2480 = smodel.Reac('Reac2480', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2p_s3ppPP1_s4pCaM3Ca])
    Reac2480.kcst = 3.3333e6
    Reac2481 = smodel.Reac('Reac2481', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP1_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2481.kcst = 8
    Reac2482 = smodel.Reac('Reac2482', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP1_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2482.kcst = 2

    #CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP1-> CaMKII_s1p_s2p_s3pp_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2483 = smodel.Reac('Reac2483', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP1])
    Reac2483.kcst = 3.3333e6
    Reac2484 = smodel.Reac('Reac2484', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP1], rhs =[CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2484.kcst = 8
    Reac2485 = smodel.Reac('Reac2485', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP1], rhs = [CaMKII_s1p_s2p_s3pp_s4CaM3Ca, PP1])
    Reac2485.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca-> CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2486 = smodel.Reac('Reac2486', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2486.kcst = 3.3333e6
    Reac2487 = smodel.Reac('Reac2487', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2487.kcst = 8
    Reac2488 = smodel.Reac('Reac2488', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2488.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2CaM3Ca_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2489 = smodel.Reac('Reac2489', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pCaM3Ca])
    Reac2489.kcst = 3.3333e6
    Reac2490 = smodel.Reac('Reac2490', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2490.kcst = 8
    Reac2491 = smodel.Reac('Reac2491', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2CaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2491.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2492 = smodel.Reac('Reac2492', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca])
    Reac2492.kcst = 3.3333e6
    Reac2493 = smodel.Reac('Reac2493', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2493.kcst = 8
    Reac2494 = smodel.Reac('Reac2494', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2494.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP1-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2495 = smodel.Reac('Reac2495', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP1])
    Reac2495.kcst = 3.3333e6
    Reac2496 = smodel.Reac('Reac2496', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP1], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2496.kcst = 8
    Reac2497 = smodel.Reac('Reac2497', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4CaM3Ca, PP1])
    Reac2497.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2p_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2498 = smodel.Reac('Reac2498', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pCaM3Ca])
    Reac2498.kcst = 3.3333e6
    Reac2499 = smodel.Reac('Reac2499', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2499.kcst = 8
    Reac2500 = smodel.Reac('Reac2500', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2500.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2501 = smodel.Reac('Reac2501', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pCaM3Ca])
    Reac2501.kcst = 3.3333e6
    Reac2502 = smodel.Reac('Reac2502', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2502.kcst = 8
    Reac2503 = smodel.Reac('Reac2503', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3p_s4pCaM3Ca, PP1])
    Reac2503.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2504 = smodel.Reac('Reac2504', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pCaM3Ca])
    Reac2504.kcst = 3.3333e6
    Reac2505 = smodel.Reac('Reac2505', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2505.kcst = 8
    Reac2506 = smodel.Reac('Reac2506', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP1_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4pCaM3Ca, PP1])
    Reac2506.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP1-> CaMKII_s1pCaM3Ca_s2p_s3p_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2507 = smodel.Reac('Reac2507', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP1])
    Reac2507.kcst = 3.3333e6
    Reac2508 = smodel.Reac('Reac2508', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP1], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2508.kcst = 8
    Reac2509 = smodel.Reac('Reac2509', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4CaM3Ca, PP1])
    Reac2509.kcst = 2
    
    #CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pPP1_s2pp_s3p_s4pCaM3Ca-> CaMKII_s1_s2pp_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2510 = smodel.Reac('Reac2510', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pPP1_s2pp_s3p_s4pCaM3Ca])
    Reac2510.kcst = 3.3333e6
    Reac2511 = smodel.Reac('Reac2511', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2511.kcst = 8
    Reac2512 = smodel.Reac('Reac2512', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2512.kcst = 2
    
    #CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2ppPP1_s3p_s4pCaM3Ca-> CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2513 = smodel.Reac('Reac2513', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2ppPP1_s3p_s4pCaM3Ca])
    Reac2513.kcst = 3.3333e6
    Reac2514 = smodel.Reac('Reac2514', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2514.kcst = 8
    Reac2515 = smodel.Reac('Reac2515', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2515.kcst = 2
    
    #CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pp_s3pPP1_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2516 = smodel.Reac('Reac2516', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pp_s3pPP1_s4pCaM3Ca])
    Reac2516.kcst = 3.3333e6
    Reac2517 = smodel.Reac('Reac2517', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP1_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2517.kcst = 8
    Reac2518 = smodel.Reac('Reac2518', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP1_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3_s4pCaM3Ca, PP1])
    Reac2518.kcst = 2
    
    #CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP1-> CaMKII_s1p_s2pp_s3p_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2519 = smodel.Reac('Reac2519', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP1])
    Reac2519.kcst = 3.3333e6
    Reac2520 = smodel.Reac('Reac2520', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP1], rhs =[CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2520.kcst = 8
    Reac2521 = smodel.Reac('Reac2521', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP1], rhs = [CaMKII_s1p_s2pp_s3p_s4CaM3Ca, PP1])
    Reac2521.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1ppPP1_s2pp_s3p_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2522 = smodel.Reac('Reac2522', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1ppPP1_s2pp_s3p_s4pCaM3Ca])
    Reac2522.kcst = 3.3333e6
    Reac2523 = smodel.Reac('Reac2523', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2523.kcst = 8
    Reac2524 = smodel.Reac('Reac2524', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2524.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2ppPP1_s3p_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2525 = smodel.Reac('Reac2525', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2ppPP1_s3p_s4pCaM3Ca])
    Reac2525.kcst = 3.3333e6
    Reac2526 = smodel.Reac('Reac2526', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2526.kcst = 8
    Reac2527 = smodel.Reac('Reac2527', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2527.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pp_s3pPP1_s4pCaM3Ca-> CaMKII_s1pp_s2pp_s3_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2528 = smodel.Reac('Reac2528', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pp_s3pPP1_s4pCaM3Ca])
    Reac2528.kcst = 3.3333e6
    Reac2529 = smodel.Reac('Reac2529', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP1_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2529.kcst = 8
    Reac2530 = smodel.Reac('Reac2530', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP1_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3_s4pCaM3Ca, PP1])
    Reac2530.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP1-> CaMKII_s1pp_s2pp_s3p_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2531 = smodel.Reac('Reac2531', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP1])
    Reac2531.kcst = 3.3333e6
    Reac2532 = smodel.Reac('Reac2532', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP1], rhs =[CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2532.kcst = 8
    Reac2533 = smodel.Reac('Reac2533', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP1], rhs = [CaMKII_s1pp_s2pp_s3p_s4CaM3Ca, PP1])
    Reac2533.kcst = 2
    
    #CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pPP1_s2p_s3p_s4pCaM3Ca-> CaMKII_s1_s2p_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2534 = smodel.Reac('Reac2534', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pPP1_s2p_s3p_s4pCaM3Ca])
    Reac2534.kcst = 3.3333e6
    Reac2535 = smodel.Reac('Reac2535', vsys, lhs = [CaMKII_s1pPP1_s2p_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2535.kcst = 8
    Reac2536 = smodel.Reac('Reac2536', vsys, lhs = [CaMKII_s1pPP1_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2536.kcst = 2
    
    #CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pPP1_s3p_s4pCaM3Ca-> CaMKII_s1p_s2_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2537 = smodel.Reac('Reac2537', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pPP1_s3p_s4pCaM3Ca])
    Reac2537.kcst = 3.3333e6
    Reac2538 = smodel.Reac('Reac2538', vsys, lhs = [CaMKII_s1p_s2pPP1_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2538.kcst = 8
    Reac2539 = smodel.Reac('Reac2539', vsys, lhs = [CaMKII_s1p_s2pPP1_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2_s3p_s4pCaM3Ca, PP1])
    Reac2539.kcst = 2
    
    #CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2p_s3pPP1_s4pCaM3Ca-> CaMKII_s1p_s2p_s3_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2540 = smodel.Reac('Reac2540', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2p_s3pPP1_s4pCaM3Ca])
    Reac2540.kcst = 3.3333e6
    Reac2541 = smodel.Reac('Reac2541', vsys, lhs = [CaMKII_s1p_s2p_s3pPP1_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2541.kcst = 8
    Reac2542 = smodel.Reac('Reac2542', vsys, lhs = [CaMKII_s1p_s2p_s3pPP1_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3_s4pCaM3Ca, PP1])
    Reac2542.kcst = 2

    #CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2p_s3p_s4pCaM3CaPP1-> CaMKII_s1p_s2p_s3p_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2543 = smodel.Reac('Reac2543', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3CaPP1])
    Reac2543.kcst = 3.3333e6
    Reac2544 = smodel.Reac('Reac2544', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3CaPP1], rhs =[CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2544.kcst = 8
    Reac2545 = smodel.Reac('Reac2545', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3CaPP1], rhs = [CaMKII_s1p_s2p_s3p_s4CaM3Ca, PP1])
    Reac2545.kcst = 2

    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pCaM3Ca-> CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2546 = smodel.Reac('Reac2546', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2546.kcst = 3.3333e6
    Reac2547 = smodel.Reac('Reac2547', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2547.kcst = 8
    Reac2548 = smodel.Reac('Reac2548', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2548.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pCaM3Ca-> CaMKII_s1p_s2CaM3Ca_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2549 = smodel.Reac('Reac2549', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pCaM3Ca])
    Reac2549.kcst = 3.3333e6
    Reac2550 = smodel.Reac('Reac2550', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2550.kcst = 8
    Reac2551 = smodel.Reac('Reac2551', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2CaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2551.kcst = 2

    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2552 = smodel.Reac('Reac2552', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pCaM3Ca])
    Reac2552.kcst = 3.3333e6
    Reac2553 = smodel.Reac('Reac2553', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2553.kcst = 8
    Reac2554 = smodel.Reac('Reac2554', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP1_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4pCaM3Ca, PP1])
    Reac2554.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP1-> CaMKII_s1p_s2pCaM3Ca_s3p_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2555 = smodel.Reac('Reac2555', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP1])
    Reac2555.kcst = 3.3333e6
    Reac2556 = smodel.Reac('Reac2556', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP1], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2556.kcst = 8
    Reac2557 = smodel.Reac('Reac2557', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4CaM3Ca, PP1])
    Reac2557.kcst = 2
    
    #CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1ppPP1_s2p_s3p_s4pCaM3Ca-> CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2558 = smodel.Reac('Reac2558', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1ppPP1_s2p_s3p_s4pCaM3Ca])
    Reac2558.kcst = 3.3333e6
    Reac2559 = smodel.Reac('Reac2559', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2559.kcst = 8
    Reac2560 = smodel.Reac('Reac2560', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2560.kcst = 2
    
    #CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pPP1_s3p_s4pCaM3Ca-> CaMKII_s1pp_s2_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2561 = smodel.Reac('Reac2561', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pPP1_s3p_s4pCaM3Ca])
    Reac2561.kcst = 3.3333e6
    Reac2562 = smodel.Reac('Reac2562', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2562.kcst = 8
    Reac2563 = smodel.Reac('Reac2563', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2_s3p_s4pCaM3Ca, PP1])
    Reac2563.kcst = 2
    
    #CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2p_s3pPP1_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2564 = smodel.Reac('Reac2564', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2p_s3pPP1_s4pCaM3Ca])
    Reac2564.kcst = 3.3333e6
    Reac2565 = smodel.Reac('Reac2565', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP1_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2565.kcst = 8
    Reac2566 = smodel.Reac('Reac2566', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP1_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3_s4pCaM3Ca, PP1])
    Reac2566.kcst = 2
    
    #CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP1-> CaMKII_s1pp_s2p_s3p_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2567 = smodel.Reac('Reac2567', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP1])
    Reac2567.kcst = 3.3333e6
    Reac2568 = smodel.Reac('Reac2568', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP1], rhs =[CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2568.kcst = 8
    Reac2569 = smodel.Reac('Reac2569', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP1], rhs = [CaMKII_s1pp_s2p_s3p_s4CaM3Ca, PP1])
    Reac2569.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2570 = smodel.Reac('Reac2570', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2570.kcst = 3.3333e6
    Reac2571 = smodel.Reac('Reac2571', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2571.kcst = 8
    Reac2572 = smodel.Reac('Reac2572', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2572.kcst = 2

    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pCaM3Ca-> CaMKII_s1pp_s2CaM3Ca_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2573 = smodel.Reac('Reac2573', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pCaM3Ca])
    Reac2573.kcst = 3.3333e6
    Reac2574 = smodel.Reac('Reac2574', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2574.kcst = 8
    Reac2575 = smodel.Reac('Reac2575', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2CaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2575.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pCaM3Ca-> CaMKII_s1pp_s2pCaM3Ca_s3_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2576 = smodel.Reac('Reac2576', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pCaM3Ca])
    Reac2576.kcst = 3.3333e6
    Reac2577 = smodel.Reac('Reac2577', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2577.kcst = 8
    Reac2578 = smodel.Reac('Reac2578', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP1_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4pCaM3Ca, PP1])
    Reac2578.kcst = 2

    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP1-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2579 = smodel.Reac('Reac2579', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP1])
    Reac2579.kcst = 3.3333e6
    Reac2580 = smodel.Reac('Reac2580', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP1], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2580.kcst = 8
    Reac2581 = smodel.Reac('Reac2581', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4CaM3Ca, PP1])
    Reac2581.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2582 = smodel.Reac('Reac2582', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2582.kcst = 3.3333e6
    Reac2583 = smodel.Reac('Reac2583', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2583.kcst = 8
    Reac2584 = smodel.Reac('Reac2584', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2584.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pCaM3Ca-> CaMKII_s1pp_s2CaM3Ca_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2585 = smodel.Reac('Reac2585', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pCaM3Ca])
    Reac2585.kcst = 3.3333e6
    Reac2586 = smodel.Reac('Reac2586', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2586.kcst = 8
    Reac2587 = smodel.Reac('Reac2587', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2587.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2588 = smodel.Reac('Reac2588', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca])
    Reac2588.kcst = 3.3333e6
    Reac2589 = smodel.Reac('Reac2589', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2589.kcst = 8
    Reac2590 = smodel.Reac('Reac2590', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2590.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP1-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2591 = smodel.Reac('Reac2591', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP1])
    Reac2591.kcst = 3.3333e6
    Reac2592 = smodel.Reac('Reac2592', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP1], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac2592.kcst = 8
    Reac2593 = smodel.Reac('Reac2593', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4CaM3Ca, PP1])
    Reac2593.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2594 = smodel.Reac('Reac2594', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2594.kcst = 3.3333e6
    Reac2595 = smodel.Reac('Reac2595', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2595.kcst = 8
    Reac2596 = smodel.Reac('Reac2596', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2596.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2597 = smodel.Reac('Reac2597', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac2597.kcst = 3.3333e6
    Reac2598 = smodel.Reac('Reac2598', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2598.kcst = 8
    Reac2599 = smodel.Reac('Reac2599', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2599.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2600 = smodel.Reac('Reac2600', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac2600.kcst = 3.3333e6
    Reac2601 = smodel.Reac('Reac2601', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2601.kcst = 8
    Reac2602 = smodel.Reac('Reac2602', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac2602.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP1-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2603 = smodel.Reac('Reac2603', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac2603.kcst = 3.3333e6
    Reac2604 = smodel.Reac('Reac2604', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2604.kcst = 8
    Reac2605 = smodel.Reac('Reac2605', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac2605.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2606 = smodel.Reac('Reac2606', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2606.kcst = 3.3333e6
    Reac2607 = smodel.Reac('Reac2607', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2607.kcst = 8
    Reac2608 = smodel.Reac('Reac2608', vsys, lhs = [CaMKII_s1pPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2608.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2609 = smodel.Reac('Reac2609', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac2609.kcst = 3.3333e6
    Reac2610 = smodel.Reac('Reac2610', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2610.kcst = 8
    Reac2611 = smodel.Reac('Reac2611', vsys, lhs = [CaMKII_s1p_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2611.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3CaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2612 = smodel.Reac('Reac2612', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac2612.kcst = 3.3333e6
    Reac2613 = smodel.Reac('Reac2613', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2613.kcst = 8
    Reac2614 = smodel.Reac('Reac2614', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac2614.kcst = 2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP1-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2615 = smodel.Reac('Reac2615', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac2615.kcst = 3.3333e6
    Reac2616 = smodel.Reac('Reac2616', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2616.kcst = 8
    Reac2617 = smodel.Reac('Reac2617', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac2617.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2618 = smodel.Reac('Reac2618', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2618.kcst = 3.3333e6
    Reac2619 = smodel.Reac('Reac2619', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2619.kcst = 8
    Reac2620 = smodel.Reac('Reac2620', vsys, lhs = [CaMKII_s1ppPP1_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2620.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2621 = smodel.Reac('Reac2621', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac2621.kcst = 3.3333e6
    Reac2622 = smodel.Reac('Reac2622', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2622.kcst = 8
    Reac2623 = smodel.Reac('Reac2623', vsys, lhs = [CaMKII_s1pp_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2623.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pCaM3Ca-> CaMKII_s1pp_s2pp_s3CaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2624 = smodel.Reac('Reac2624', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac2624.kcst = 3.3333e6
    Reac2625 = smodel.Reac('Reac2625', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2625. kcst = 8
    Reac2626 = smodel.Reac('Reac2626', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac2626.kcst = 2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP1-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2627 = smodel.Reac('Reac2627', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac2627.kcst = 3.3333e6
    Reac2628 = smodel.Reac('Reac2628', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2628.kcst = 8
    Reac2629 = smodel.Reac('Reac2629', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac2629.kcst = 2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2630 = smodel.Reac('Reac2630', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2630.kcst = 3.3333e6
    Reac2631 = smodel.Reac('Reac2631', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2631.kcst = 8
    Reac2632 = smodel.Reac('Reac2632', vsys, lhs = [CaMKII_s1pPP1_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2632.kcst = 2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2633 = smodel.Reac('Reac2633', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac2633.kcst = 3.3333e6
    Reac2634 = smodel.Reac('Reac2634', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2634.kcst = 8
    Reac2635 = smodel.Reac('Reac2635', vsys, lhs = [CaMKII_s1p_s2pPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2635.kcst = 2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pCaM3Ca-> CaMKII_s1p_s2p_s3CaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2636 = smodel.Reac('Reac2636', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac2636.kcst = 3.3333e6
    Reac2637 = smodel.Reac('Reac2637', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2637.kcst = 8
    Reac2638 = smodel.Reac('Reac2638', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac2638.kcst = 2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP1-> CaMKII_s1p_s2p_s3pCaM3Ca_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2639 = smodel.Reac('Reac2639', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac2639.kcst = 3.3333e6
    Reac2640 = smodel.Reac('Reac2640', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2640.kcst = 8
    Reac2641 = smodel.Reac('Reac2641', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac2641.kcst = 2

    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2642 = smodel.Reac('Reac2642', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2642.kcst = 3.3333e6
    Reac2643 = smodel.Reac('Reac2643', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2643.kcst = 8
    Reac2644 = smodel.Reac('Reac2644', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2644.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pp_s2_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2645 = smodel.Reac('Reac2645', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac2645.kcst = 3.3333e6
    Reac2646 = smodel.Reac('Reac2646', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2646.kcst = 8
    Reac2647 = smodel.Reac('Reac2647', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2647.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3CaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2648 = smodel.Reac('Reac2648', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac2648.kcst = 3.3333e6
    Reac2649 = smodel.Reac('Reac2649', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2649.kcst = 8
    Reac2650 = smodel.Reac('Reac2650', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac2650.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP1-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2651 = smodel.Reac('Reac2651', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac2651.kcst = 3.3333e6
    Reac2652 = smodel.Reac('Reac2652', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2652.kcst = 8
    Reac2653 = smodel.Reac('Reac2653', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac2653.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2654 = smodel.Reac('Reac2654', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac2654.kcst = 3.3333e6
    Reac2655 = smodel.Reac('Reac2655', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2655.kcst = 8
    Reac2656 = smodel.Reac('Reac2656', vsys, lhs = [CaMKII_s1ppPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2656.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2657 = smodel.Reac('Reac2657', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac2657.kcst = 3.3333e6
    Reac2658 = smodel.Reac('Reac2658', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2658.kcst = 8
    Reac2659 = smodel.Reac('Reac2659', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2659.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca-> CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2660 = smodel.Reac('Reac2660', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac2660.kcst = 3.3333e6
    Reac2661 = smodel.Reac('Reac2661', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2661.kcst = 8
    Reac2662 = smodel.Reac('Reac2662', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac2662.kcst = 2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2663 = smodel.Reac('Reac2663', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac2663.kcst = 3.3333e6
    Reac2664 = smodel.Reac('Reac2664', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2664.kcst = 8
    Reac2665 = smodel.Reac('Reac2665', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac2665.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2666 = smodel.Reac('Reac2666', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2666.kcst = 3.3333e6
    Reac2667 = smodel.Reac('Reac2667', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2667.kcst = 8
    Reac2668 = smodel.Reac('Reac2668', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2668.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2669 = smodel.Reac('Reac2669', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pCaM3Ca])
    Reac2669.kcst = 3.3333e6
    Reac2670 = smodel.Reac('Reac2670', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2670.kcst = 8
    Reac2671 = smodel.Reac('Reac2671', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP1_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2671.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2672 = smodel.Reac('Reac2672', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pCaM3Ca])
    Reac2672.kcst = 3.3333e6
    Reac2673 = smodel.Reac('Reac2673', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2673.kcst = 8
    Reac2674 = smodel.Reac('Reac2674', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP1_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pCaM3Ca, PP1])
    Reac2674.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP1-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2675 = smodel.Reac('Reac2675', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP1])
    Reac2675.kcst = 3.3333e6
    Reac2676 = smodel.Reac('Reac2676', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP1], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac2676.kcst = 8
    Reac2677 = smodel.Reac('Reac2677', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP1], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4CaM3Ca, PP1])
    Reac2677.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1ppPP1_s2p_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2678 = smodel.Reac('Reac2678', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1ppPP1_s2p_s3pp_s4pCaM3Ca])
    Reac2678.kcst = 3.3333e6
    Reac2679 = smodel.Reac('Reac2679', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2679.kcst = 8
    Reac2680 = smodel.Reac('Reac2680', vsys, lhs = [CaMKII_s1ppPP1_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2680.kcst = 2
    
    #CaMKII_s1pp_s2pPP1_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2pPP1_s3pp_s4pCaM3Ca-> CaMKII_s1pp_s2_s3pp_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2681 = smodel.Reac('Reac2681', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2pPP1_s3pp_s4pCaM3Ca])
    Reac2681.kcst = 3.3333e6
    Reac2682 = smodel.Reac('Reac2682', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pPP1_s3pp_s4pCaM3Ca, PP1])
    Reac2682.kcst = 8
    Reac2683 = smodel.Reac('Reac2683', vsys, lhs = [CaMKII_s1pp_s2pPP1_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2_s3pp_s4pCaM3Ca, PP1])
    Reac2683.kcst = 2

    #CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2p_s3ppPP1_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2684 = smodel.Reac('Reac2684', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2p_s3ppPP1_s4pCaM3Ca])
    Reac2684.kcst = 3.3333e6
    Reac2685 = smodel.Reac('Reac2685', vsys, lhs = [CaMKII_s1pp_s2p_s3ppPP1_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2685.kcst = 8
    Reac2686 = smodel.Reac('Reac2686', vsys, lhs = [CaMKII_s1pp_s2p_s3ppPP1_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2686.kcst = 2
    
    #CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca + PP1 <-> CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP1-> CaMKII_s1pp_s2p_s3pp_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2687 = smodel.Reac('Reac2687', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP1])
    Reac2687.kcst = 3.3333e6
    Reac2688 = smodel.Reac('Reac2688', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP1], rhs =[CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac2688.kcst = 8
    Reac2689 = smodel.Reac('Reac2689', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP1], rhs = [CaMKII_s1pp_s2p_s3pp_s4CaM3Ca, PP1])
    Reac2689.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pp_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2690 = smodel.Reac('Reac2690', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pCaM3Ca])
    Reac2690.kcst = 3.3333e6
    Reac2691 = smodel.Reac('Reac2691', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2691.kcst = 8
    Reac2692 = smodel.Reac('Reac2692', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2692.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2693 = smodel.Reac('Reac2693', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pCaM3Ca])
    Reac2693.kcst = 3.3333e6
    Reac2694 = smodel.Reac('Reac2694', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2694.kcst = 8
    Reac2695 = smodel.Reac('Reac2695', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP1_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP1])
    Reac2695.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pp_s3_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2696 = smodel.Reac('Reac2696', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pCaM3Ca])
    Reac2696.kcst = 3.3333e6
    Reac2697 = smodel.Reac('Reac2697', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2697.kcst = 8
    Reac2698 = smodel.Reac('Reac2698', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP1_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4pCaM3Ca, PP1])
    Reac2698.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP1-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2699 = smodel.Reac('Reac2699', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP1])
    Reac2699.kcst = 3.3333e6
    Reac2700 = smodel.Reac('Reac2700', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP1], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac2700.kcst = 8
    Reac2701 = smodel.Reac('Reac2701', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP1], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4CaM3Ca, PP1])
    Reac2701.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2702 = smodel.Reac('Reac2702', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2702.kcst = 3.3333e6
    Reac2703 = smodel.Reac('Reac2703', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2703.kcst = 8
    Reac2704 = smodel.Reac('Reac2704', vsys, lhs = [CaMKII_s1pCaM3CaPP1_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2704.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2705 = smodel.Reac('Reac2705', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac2705.kcst = 3.3333e6
    Reac2706 = smodel.Reac('Reac2706', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2706.kcst = 8
    Reac2707 = smodel.Reac('Reac2707', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2707.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2708 = smodel.Reac('Reac2708', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac2708.kcst = 3.3333e6
    Reac2709 = smodel.Reac('Reac2709', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2709.kcst = 8
    Reac2710 = smodel.Reac('Reac2710', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac2710.kcst = 2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP1-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2711 = smodel.Reac('Reac2711', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac2711.kcst = 3.3333e6
    Reac2712 = smodel.Reac('Reac2712', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2712.kcst = 8
    Reac2713 = smodel.Reac('Reac2713', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac2713.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2714 = smodel.Reac('Reac2714', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac2714.kcst = 3.3333e6
    Reac2715 = smodel.Reac('Reac2715', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2715.kcst = 8
    Reac2716 = smodel.Reac('Reac2716', vsys, lhs = [CaMKII_s1pPP1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2716.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2717 = smodel.Reac('Reac2717', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac2717.kcst = 3.3333e6
    Reac2718 = smodel.Reac('Reac2718', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2718.kcst = 8
    Reac2719 = smodel.Reac('Reac2719', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2719.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP1        #dephosphorylation by PP1
    Reac2720 = smodel.Reac('Reac2720', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac2720.kcst = 3.3333e6
    Reac2721 = smodel.Reac('Reac2721', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2721.kcst = 8
    Reac2722 = smodel.Reac('Reac2722', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac2722.kcst = 2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP1        #dephosphorylation by PP1
    Reac2723 = smodel.Reac('Reac2723', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac2723.kcst = 3.3333e6
    Reac2724 = smodel.Reac('Reac2724', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac2724.kcst = 8
    Reac2725 = smodel.Reac('Reac2725', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac2725.kcst = 2
    
    #dephosphorylation by PP2A
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2726 = smodel.Reac('Reac2726', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2726.kcst = 0.2e6
    Reac2727 = smodel.Reac('Reac2727', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2727.kcst = 0.8
    Reac2728 = smodel.Reac('Reac2728', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2728.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2729 = smodel.Reac('Reac2729', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca])
    Reac2729.kcst = 0.2e6
    Reac2730 = smodel.Reac('Reac2730', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2730.kcst = 0.8
    Reac2731 = smodel.Reac('Reac2731', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2731.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2732 = smodel.Reac('Reac2732', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca])
    Reac2732.kcst = 0.2e6
    Reac2733 = smodel.Reac('Reac2733', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2733.kcst = 0.8
    Reac2734 = smodel.Reac('Reac2734', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2734.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2735 = smodel.Reac('Reac2735', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A])
    Reac2735.kcst = 0.2e6
    Reac2736 = smodel.Reac('Reac2736', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2736.kcst = 0.8
    Reac2737 = smodel.Reac('Reac2737', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4CaM3Ca, PP2A])
    Reac2737.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2p_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2738 = smodel.Reac('Reac2738', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pCaM3Ca])
    Reac2738.kcst = 0.2e6
    Reac2739 = smodel.Reac('Reac2739', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2739.kcst = 0.8
    Reac2740 = smodel.Reac('Reac2740', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2740.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2741 = smodel.Reac('Reac2741', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pCaM3Ca])
    Reac2741.kcst = 0.2e6
    Reac2742 = smodel.Reac('Reac2742', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2742.kcst = 0.8
    Reac2743 = smodel.Reac('Reac2743', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3pp_s4pCaM3Ca, PP2A])
    Reac2743.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2744 = smodel.Reac('Reac2744', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4pCaM3Ca])
    Reac2744.kcst = 0.2e6
    Reac2745 = smodel.Reac('Reac2745', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2745.kcst = 0.8
    Reac2746 = smodel.Reac('Reac2746', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3ppPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2746.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP2A-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2747 = smodel.Reac('Reac2747', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP2A])
    Reac2747.kcst = 0.2e6
    Reac2748 = smodel.Reac('Reac2748', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP2A], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2748.kcst = 0.8
    Reac2749 = smodel.Reac('Reac2749', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3CaPP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4CaM3Ca, PP2A])
    Reac2740.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pp_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2750 = smodel.Reac('Reac2750', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pCaM3Ca])
    Reac2750.kcst = 0.2e6
    Reac2751 = smodel.Reac('Reac2751', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2751.kcst = 0.8
    Reac2752 = smodel.Reac('Reac2752', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2752.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2753 = smodel.Reac('Reac2753', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pCaM3Ca])
    Reac2753.kcst = 0.2e6
    Reac2754 = smodel.Reac('Reac2754', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2754.kcst = 0.8
    Reac2755 = smodel.Reac('Reac2755', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2755.kcst = 0.2

    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2756 = smodel.Reac('Reac2756', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pCaM3Ca])
    Reac2756.kcst = 0.2e6
    Reac2757 = smodel.Reac('Reac2757', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2757.kcst = 0.8
    Reac2758 = smodel.Reac('Reac2758', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3ppPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2758.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP2A-> CaMKII_s1pCaM3Ca_s2pp_s3pp_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2759 = smodel.Reac('Reac2759', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP2A])
    Reac2759.kcst = 0.2e6
    Reac2760 = smodel.Reac('Reac2760', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2760.kcst = 0.8
    Reac2761 = smodel.Reac('Reac2761', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3CaPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pp_s4CaM3Ca, PP2A])
    Reac2761.kcst = 0.2

    #CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pPP2A_s2pp_s3pp_s4pCaM3Ca-> CaMKII_s1_s2pp_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2762 = smodel.Reac('Reac2762', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pPP2A_s2pp_s3pp_s4pCaM3Ca])
    Reac2762.kcst = 0.2e6
    Reac2763 = smodel.Reac('Reac2763', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2763.kcst = 0.8
    Reac2764 = smodel.Reac('Reac2764', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2764.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2ppPP2A_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2765 = smodel.Reac('Reac2765', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2ppPP2A_s3pp_s4pCaM3Ca])
    Reac2765.kcst = 0.2e6
    Reac2766 = smodel.Reac('Reac2766', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2766.kcst = 0.8
    Reac2767 = smodel.Reac('Reac2767', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2767.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pp_s3ppPP2A_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2768 = smodel.Reac('Reac2768', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pp_s3ppPP2A_s4pCaM3Ca])
    Reac2768.kcst = 0.2e6
    Reac2769 = smodel.Reac('Reac2769', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP2A_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2769.kcst = 0.8
    Reac2770 = smodel.Reac('Reac2770', vsys, lhs = [CaMKII_s1p_s2pp_s3ppPP2A_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2770.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP2A-> CaMKII_s1p_s2pp_s3pp_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2771 = smodel.Reac('Reac2771', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP2A])
    Reac2771.kcst = 0.2e6
    Reac2772 = smodel.Reac('Reac2772', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP2A], rhs =[CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2772.kcst = 0.8
    Reac2773 = smodel.Reac('Reac2773', vsys, lhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3CaPP2A], rhs = [CaMKII_s1p_s2pp_s3pp_s4CaM3Ca, PP2A])
    Reac2773.kcst = 0.2

    #CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1ppPP2A_s2pp_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2774 = smodel.Reac('Reac2774', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1ppPP2A_s2pp_s3pp_s4pCaM3Ca])
    Reac2774.kcst = 0.2e6
    Reac2775 = smodel.Reac('Reac2775', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2775.kcst = 0.8
    Reac2776 = smodel.Reac('Reac2776', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2776.kcst = 0.2

    #CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2ppPP2A_s3pp_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2777 = smodel.Reac('Reac2777', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2ppPP2A_s3pp_s4pCaM3Ca])
    Reac2777.kcst = 0.2e6
    Reac2778 = smodel.Reac('Reac2778', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2778.kcst = 0.8
    Reac2779 = smodel.Reac('Reac2779', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2779.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pp_s3ppPP2A_s4pCaM3Ca-> CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2780 = smodel.Reac('Reac2780', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pp_s3ppPP2A_s4pCaM3Ca])
    Reac2780.kcst = 0.2e6
    Reac2781 = smodel.Reac('Reac2781', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2781.kcst = 0.8
    Reac2782 = smodel.Reac('Reac2782', vsys, lhs = [CaMKII_s1pp_s2pp_s3ppPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2782.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP2A-> CaMKII_s1pp_s2pp_s3pp_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2783 = smodel.Reac('Reac2783', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP2A])
    Reac2783.kcst = 0.2e6
    Reac2784 = smodel.Reac('Reac2784', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP2A], rhs =[CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca, PP2A])
    Reac2784.kcst = 0.8
    Reac2785 = smodel.Reac('Reac2785', vsys, lhs = [CaMKII_s1pp_s2pp_s3pp_s4pCaM3CaPP2A], rhs = [CaMKII_s1pp_s2pp_s3pp_s4CaM3Ca, PP2A])
    Reac2785.kcst = 0.2

    #CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pPP2A_s2p_s3pp_s4pCaM3Ca-> CaMKII_s1_s2p_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2786 = smodel.Reac('Reac2786', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pPP2A_s2p_s3pp_s4pCaM3Ca])
    Reac2786.kcst = 0.2e6
    Reac2787 = smodel.Reac('Reac2787', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2787.kcst = 0.8
    Reac2788 = smodel.Reac('Reac2788', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2788.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pPP2A_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2789 = smodel.Reac('Reac2789', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pPP2A_s3pp_s4pCaM3Ca])
    Reac2789.kcst = 0.2e6
    Reac2790 = smodel.Reac('Reac2790', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2790.kcst = 0.8
    Reac2791 = smodel.Reac('Reac2791', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2_s3pp_s4pCaM3Ca, PP2A])
    Reac2791.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2p_s3ppPP2A_s4pCaM3Ca-> CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2792 = smodel.Reac('Reac2792', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2p_s3ppPP2A_s4pCaM3Ca])
    Reac2792.kcst = 0.2e6
    Reac2793 = smodel.Reac('Reac2793', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP2A_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2793.kcst = 0.8
    Reac2794 = smodel.Reac('Reac2794', vsys, lhs = [CaMKII_s1p_s2p_s3ppPP2A_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2794.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP2A-> CaMKII_s1p_s2p_s3pp_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2795 = smodel.Reac('Reac2795', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP2A])
    Reac2795.kcst = 0.2e6
    Reac2796 = smodel.Reac('Reac2796', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP2A], rhs =[CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2796.kcst = 0.8
    Reac2797 = smodel.Reac('Reac2797', vsys, lhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3CaPP2A], rhs = [CaMKII_s1p_s2p_s3pp_s4CaM3Ca, PP2A])
    Reac2797.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca-> CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2798 = smodel.Reac('Reac2798', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2798.kcst = 0.2e6
    Reac2799 = smodel.Reac('Reac2799', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2799.kcst = 0.8
    Reac2800 = smodel.Reac('Reac2800', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2800.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2CaM3Ca_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2801 = smodel.Reac('Reac2801', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca])
    Reac2801.kcst = 0.2e6
    Reac2802 = smodel.Reac('Reac2802', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2802.kcst = 0.8
    Reac2803 = smodel.Reac('Reac2803', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2CaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2803.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2804 = smodel.Reac('Reac2804', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca])
    Reac2804.kcst = 0.2e6
    Reac2805 = smodel.Reac('Reac2805', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2805.kcst = 0.8
    Reac2806 = smodel.Reac('Reac2806', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2806.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2807 = smodel.Reac('Reac2807', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A])
    Reac2807.kcst = 0.2e6
    Reac2808 = smodel.Reac('Reac2808', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2808.kcst = 0.8
    Reac2809 = smodel.Reac('Reac2809', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4CaM3Ca, PP2A])
    Reac2809.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2p_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2810 = smodel.Reac('Reac2810', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pCaM3Ca])
    Reac2810.kcst = 0.2e6
    Reac2811 = smodel.Reac('Reac2811', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2811.kcst = 0.8
    Reac2812 = smodel.Reac('Reac2812', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2812.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2813 = smodel.Reac('Reac2813', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pCaM3Ca])
    Reac2813.kcst = 0.2e6
    Reac2814 = smodel.Reac('Reac2814', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2814.kcst = 0.8
    Reac2815 = smodel.Reac('Reac2815', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3p_s4pCaM3Ca, PP2A])
    Reac2815.kcst = 0.2

    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2816 = smodel.Reac('Reac2816', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pCaM3Ca])
    Reac2816.kcst = 0.2e6
    Reac2817 = smodel.Reac('Reac2817', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2817.kcst = 0.8
    Reac2818 = smodel.Reac('Reac2818', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3_s4pCaM3Ca, PP2A])
    Reac2818.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP2A-> CaMKII_s1pCaM3Ca_s2p_s3p_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2819 = smodel.Reac('Reac2819', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP2A])
    Reac2819.kcst = 0.2e6
    Reac2820 = smodel.Reac('Reac2820', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP2A], rhs =[CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2820.kcst = 0.8
    Reac2821 = smodel.Reac('Reac2821', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3CaPP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4CaM3Ca, PP2A])
    Reac2821.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pPP2A_s2pp_s3p_s4pCaM3Ca-> CaMKII_s1_s2pp_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2822 = smodel.Reac('Reac2822', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pPP2A_s2pp_s3p_s4pCaM3Ca])
    Reac2822.kcst = 0.2e6
    Reac2823 = smodel.Reac('Reac2823', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2823.kcst = 0.8
    Reac2824 = smodel.Reac('Reac2824', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2824.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2ppPP2A_s3p_s4pCaM3Ca-> CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2825 = smodel.Reac('Reac2825', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2ppPP2A_s3p_s4pCaM3Ca])
    Reac2825.kcst = 0.2e6
    Reac2826 = smodel.Reac('Reac2826', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2826.kcst = 0.8
    Reac2827 = smodel.Reac('Reac2827', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2827.kcst = 0.2

    #CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pp_s3pPP2A_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2828 = smodel.Reac('Reac2828', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pp_s3pPP2A_s4pCaM3Ca])
    Reac2828.kcst = 0.2e6
    Reac2829 = smodel.Reac('Reac2829', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP2A_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2829.kcst = 0.8
    Reac2830 = smodel.Reac('Reac2830', vsys, lhs = [CaMKII_s1p_s2pp_s3pPP2A_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3_s4pCaM3Ca, PP2A])
    Reac2830.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP2A-> CaMKII_s1p_s2pp_s3p_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2831 = smodel.Reac('Reac2831', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP2A])
    Reac2831.kcst = 0.2e6
    Reac2832 = smodel.Reac('Reac2832', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP2A], rhs =[CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2832.kcst = 0.8
    Reac2833 = smodel.Reac('Reac2833', vsys, lhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3CaPP2A], rhs = [CaMKII_s1p_s2pp_s3p_s4CaM3Ca, PP2A])
    Reac2833.kcst = 0.2

    #CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1ppPP2A_s2pp_s3p_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2834 = smodel.Reac('Reac2834', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1ppPP2A_s2pp_s3p_s4pCaM3Ca])
    Reac2834.kcst = 0.2e6
    Reac2835 = smodel.Reac('Reac2835', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2835.kcst = 0.8
    Reac2836 = smodel.Reac('Reac2836', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2836.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2ppPP2A_s3p_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2837 = smodel.Reac('Reac2837', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2ppPP2A_s3p_s4pCaM3Ca])
    Reac2837.kcst = 0.2e6
    Reac2838 = smodel.Reac('Reac2838', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2838.kcst = 0.8
    Reac2839 = smodel.Reac('Reac2839', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2839.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pp_s3pPP2A_s4pCaM3Ca-> CaMKII_s1pp_s2pp_s3_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2840 = smodel.Reac('Reac2840', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pPP2A_s4pCaM3Ca])
    Reac2840.kcst = 0.2e6
    Reac2841 = smodel.Reac('Reac2841', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2841.kcst = 0.8
    Reac2842 = smodel.Reac('Reac2842', vsys, lhs = [CaMKII_s1pp_s2pp_s3pPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3_s4pCaM3Ca, PP2A])
    Reac2842.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP2A-> CaMKII_s1pp_s2pp_s3p_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2843 = smodel.Reac('Reac2843', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP2A])
    Reac2843.kcst = 0.2e6
    Reac2844 = smodel.Reac('Reac2844', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP2A], rhs =[CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac2844.kcst = 0.8
    Reac2845 = smodel.Reac('Reac2845', vsys, lhs = [CaMKII_s1pp_s2pp_s3p_s4pCaM3CaPP2A], rhs = [CaMKII_s1pp_s2pp_s3p_s4CaM3Ca, PP2A])
    Reac2845.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pPP2A_s2p_s3p_s4pCaM3Ca-> CaMKII_s1_s2p_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2846 = smodel.Reac('Reac2846', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pPP2A_s2p_s3p_s4pCaM3Ca])
    Reac2846.kcst = 0.2e6
    Reac2847 = smodel.Reac('Reac2847', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2847.kcst = 0.8
    Reac2848 = smodel.Reac('Reac2848', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2848.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pPP2A_s3p_s4pCaM3Ca-> CaMKII_s1p_s2_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2849 = smodel.Reac('Reac2849', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pPP2A_s3p_s4pCaM3Ca])
    Reac2849.kcst = 0.2e6
    Reac2850 = smodel.Reac('Reac2850', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2850.kcst = 0.8
    Reac2851 = smodel.Reac('Reac2851', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2_s3p_s4pCaM3Ca, PP2A])
    Reac2851.kcst = 0.2

    #CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2p_s3pPP2A_s4pCaM3Ca-> CaMKII_s1p_s2p_s3_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2852 = smodel.Reac('Reac2852', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2p_s3pPP2A_s4pCaM3Ca])
    Reac2852.kcst = 0.2e6
    Reac2853 = smodel.Reac('Reac2853', vsys, lhs = [CaMKII_s1p_s2p_s3pPP2A_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2853.kcst = 0.8
    Reac2854 = smodel.Reac('Reac2854', vsys, lhs = [CaMKII_s1p_s2p_s3pPP2A_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3_s4pCaM3Ca, PP2A])
    Reac2854.kcst = 0.2

    #CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2p_s3p_s4pCaM3CaPP2A-> CaMKII_s1p_s2p_s3p_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2855 = smodel.Reac('Reac2855', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3CaPP2A])
    Reac2855.kcst = 0.2e6
    Reac2856 = smodel.Reac('Reac2856', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3CaPP2A], rhs =[CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2856.kcst = 0.8
    Reac2857 = smodel.Reac('Reac2857', vsys, lhs = [CaMKII_s1p_s2p_s3p_s4pCaM3CaPP2A], rhs = [CaMKII_s1p_s2p_s3p_s4CaM3Ca, PP2A])
    Reac2857.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca-> CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2858 = smodel.Reac('Reac2858', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2858.kcst = 0.2e6
    Reac2859 = smodel.Reac('Reac2859', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2859.kcst = 0.8
    Reac2860 = smodel.Reac('Reac2860', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2860.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pCaM3Ca-> CaMKII_s1p_s2CaM3Ca_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2861 = smodel.Reac('Reac2861', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pCaM3Ca])
    Reac2861.kcst = 0.2e6
    Reac2862 = smodel.Reac('Reac2862', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2862.kcst = 0.8
    Reac2863 = smodel.Reac('Reac2863', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2CaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2863.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2864 = smodel.Reac('Reac2864', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca])
    Reac2864.kcst = 0.2e6
    Reac2865 = smodel.Reac('Reac2865', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2865.kcst = 0.8
    Reac2866 = smodel.Reac('Reac2866', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3_s4pCaM3Ca, PP2A])
    Reac2866.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP2A-> CaMKII_s1p_s2pCaM3Ca_s3p_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2867 = smodel.Reac('Reac2867', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP2A])
    Reac2867.kcst = 0.2e6
    Reac2868 = smodel.Reac('Reac2868', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP2A], rhs =[CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2868.kcst = 0.8
    Reac2869 = smodel.Reac('Reac2869', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3CaPP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4CaM3Ca, PP2A])
    Reac2869.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1ppPP2A_s2p_s3p_s4pCaM3Ca-> CaMKII_s1p_s2p_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2870 = smodel.Reac('Reac2870', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1ppPP2A_s2p_s3p_s4pCaM3Ca])
    Reac2870.kcst = 0.2e6
    Reac2871 = smodel.Reac('Reac2871', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2871.kcst = 0.8
    Reac2872 = smodel.Reac('Reac2872', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2872.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pPP2A_s3p_s4pCaM3Ca-> CaMKII_s1pp_s2_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2873 = smodel.Reac('Reac2873', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pPP2A_s3p_s4pCaM3Ca])
    Reac2873.kcst = 0.2e6
    Reac2874 = smodel.Reac('Reac2874', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2874.kcst = 0.8
    Reac2875 = smodel.Reac('Reac2875', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2_s3p_s4pCaM3Ca, PP2A])
    Reac2875.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2p_s3pPP2A_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2876= smodel.Reac('Reac2876', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2p_s3pPP2A_s4pCaM3Ca])
    Reac2876.kcst = 0.2e6
    Reac2877 = smodel.Reac('Reac2877', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2877.kcst = 0.8
    Reac2878 = smodel.Reac('Reac2878', vsys, lhs = [CaMKII_s1pp_s2p_s3pPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3_s4pCaM3Ca, PP2A])
    Reac2878.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP2A-> CaMKII_s1pp_s2p_s3p_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2879 = smodel.Reac('Reac2879', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP2A])
    Reac2879.kcst = 0.2e6
    Reac2880 = smodel.Reac('Reac2880', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP2A], rhs =[CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2880.kcst = 0.8
    Reac2881 = smodel.Reac('Reac2881', vsys, lhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3CaPP2A], rhs = [CaMKII_s1pp_s2p_s3p_s4CaM3Ca, PP2A])
    Reac2881.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2882 = smodel.Reac('Reac2882', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2882.kcst = 0.2e6
    Reac2883 = smodel.Reac('Reac2883', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2883.kcst = 0.8
    Reac2884 = smodel.Reac('Reac2884', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2884.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pCaM3Ca-> CaMKII_s1pp_s2CaM3Ca_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2885 = smodel.Reac('Reac2885', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pCaM3Ca])
    Reac2885.kcst = 0.2e6
    Reac2886 = smodel.Reac('Reac2886', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2886.kcst = 0.8
    Reac2887 = smodel.Reac('Reac2887', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2CaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2887.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca-> CaMKII_s1pp_s2pCaM3Ca_s3_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2888 = smodel.Reac('Reac2888', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca])
    Reac2888.kcst = 0.2e6
    Reac2889 = smodel.Reac('Reac2889', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2889.kcst = 0.8
    Reac2890 = smodel.Reac('Reac2890', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3_s4pCaM3Ca, PP2A])
    Reac2890.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP2A-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2891 = smodel.Reac('Reac2891', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP2A])
    Reac2891.kcst = 0.2e6
    Reac2892 = smodel.Reac('Reac2892', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP2A], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2892.kcst = 0.8
    Reac2893 = smodel.Reac('Reac2893', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3CaPP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4CaM3Ca, PP2A])
    Reac2893.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2894 = smodel.Reac('Reac2894', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac2894.kcst = 0.2e6
    Reac2895 = smodel.Reac('Reac2895', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2895.kcst = 0.8
    Reac2896 = smodel.Reac('Reac2896', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2896.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca-> CaMKII_s1pp_s2CaM3Ca_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2897 = smodel.Reac('Reac2897', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca])
    Reac2897.kcst = 0.2e6
    Reac2898 = smodel.Reac('Reac2898', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2898.kcst = 0.8
    Reac2899 = smodel.Reac('Reac2899', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2899.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca-> CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2900 = smodel.Reac('Reac2900', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca])
    Reac2900.kcst = 0.2e6
    Reac2901 = smodel.Reac('Reac2901', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2901.kcst = 0.8
    Reac2902 = smodel.Reac('Reac2902', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2902.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A-> CaMKII_s1pp_s2pCaM3Ca_s3pp_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2903 = smodel.Reac('Reac2903', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A])
    Reac2903.kcst = 0.2e6
    Reac2904 = smodel.Reac('Reac2904', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac2904.kcst = 0.8
    Reac2905 = smodel.Reac('Reac2905', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pp_s4CaM3Ca, PP2A])
    Reac2905.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2906 = smodel.Reac('Reac2906', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2906.kcst = 0.2e6
    Reac2907 = smodel.Reac('Reac2907', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2907.kcst = 0.8
    Reac2908 = smodel.Reac('Reac2908', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2908.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2909 = smodel.Reac('Reac2909', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac2909.kcst = 0.2e6
    Reac2910 = smodel.Reac('Reac2910', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2910.kcst = 0.8
    Reac2911 = smodel.Reac('Reac2911', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2911.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2912 = smodel.Reac('Reac2912', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac2912.kcst = 0.2e6
    Reac2913 = smodel.Reac('Reac2913', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2913.kcst = 0.8
    Reac2914 = smodel.Reac('Reac2914', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac2914.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2915 = smodel.Reac('Reac2915', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac2915.kcst = 0.2e6
    Reac2916 = smodel.Reac('Reac2916', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2916.kcst = 0.8
    Reac2917 = smodel.Reac('Reac2917', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac2917.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2918 = smodel.Reac('Reac2918', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2918.kcst = 0.2e6
    Reac2919 = smodel.Reac('Reac2919', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2919.kcst = 0.8
    Reac2920 = smodel.Reac('Reac2920', vsys, lhs = [CaMKII_s1pPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2920.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2921 = smodel.Reac('Reac2921', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac2921.kcst = 0.2e6
    Reac2922 = smodel.Reac('Reac2922', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2922.kcst = 0.8
    Reac2923 = smodel.Reac('Reac2923', vsys, lhs = [CaMKII_s1p_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2923.kcst = 0.2

    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3CaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2924 = smodel.Reac('Reac2924', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac2924.kcst = 0.2e6
    Reac2925 = smodel.Reac('Reac2925', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2925.kcst = 0.8
    Reac2926 = smodel.Reac('Reac2926', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac2926.kcst = 0.2
    
    #CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2927 = smodel.Reac('Reac2927', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac2927.kcst = 0.2e6
    Reac2928 = smodel.Reac('Reac2928', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2928.kcst = 0.8
    Reac2929 = smodel.Reac('Reac2929', vsys, lhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac2929.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2930 = smodel.Reac('Reac2930', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac2930.kcst = 0.2e6
    Reac2931 = smodel.Reac('Reac2931', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2931.kcst = 0.8
    Reac2932 = smodel.Reac('Reac2932', vsys, lhs = [CaMKII_s1ppPP2A_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2932.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2933 = smodel.Reac('Reac2933', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac2933.kcst = 0.2e6
    Reac2934 = smodel.Reac('Reac2934', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2934.kcst = 0.8
    Reac2935 = smodel.Reac('Reac2935', vsys, lhs = [CaMKII_s1pp_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2935.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca-> CaMKII_s1pp_s2pp_s3CaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2936 = smodel.Reac('Reac2936', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac2936.kcst = 0.2e6
    Reac2937 = smodel.Reac('Reac2937', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2937. kcst = 0.8
    Reac2938 = smodel.Reac('Reac2938', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pp_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac2938.kcst = 0.2
    
    #CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1pp_s2pp_s3pCaM3Ca_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2939 = smodel.Reac('Reac2939', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac2939.kcst = 0.2e6
    Reac2940 = smodel.Reac('Reac2940', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2940.kcst = 0.8
    Reac2941 = smodel.Reac('Reac2941', vsys, lhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1pp_s2pp_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac2941.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2942 = smodel.Reac('Reac2942', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2942.kcst = 0.2e6
    Reac2943 = smodel.Reac('Reac2943', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2943.kcst = 0.8
    Reac2944 = smodel.Reac('Reac2944', vsys, lhs = [CaMKII_s1pPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2944.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2945 = smodel.Reac('Reac2945', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac2945.kcst = 0.2e6
    Reac2946 = smodel.Reac('Reac2946', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2946.kcst = 0.8
    Reac2947 = smodel.Reac('Reac2947', vsys, lhs = [CaMKII_s1p_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2947.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pCaM3Ca-> CaMKII_s1p_s2p_s3CaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2948 = smodel.Reac('Reac2948', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac2948.kcst = 0.2e6
    Reac2949 = smodel.Reac('Reac2949', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2949.kcst = 0.8
    Reac2950 = smodel.Reac('Reac2950', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac2950.kcst = 0.2
    
    #CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1p_s2p_s3pCaM3Ca_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2951 = smodel.Reac('Reac2951', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac2951.kcst = 0.2e6
    Reac2952 = smodel.Reac('Reac2952', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2952.kcst = 0.8
    Reac2953 = smodel.Reac('Reac2953', vsys, lhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac2953.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2954 = smodel.Reac('Reac2954', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac2954.kcst = 0.2e6
    Reac2955 = smodel.Reac('Reac2955', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2955.kcst = 0.8
    Reac2956 = smodel.Reac('Reac2956', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2956.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pp_s2_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2957 = smodel.Reac('Reac2957', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac2957.kcst = 0.2e6
    Reac2958 = smodel.Reac('Reac2958', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2958.kcst = 0.8
    Reac2959 = smodel.Reac('Reac2959', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2959.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3CaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2960 = smodel.Reac('Reac2960', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac2960.kcst = 0.2e6
    Reac2961 = smodel.Reac('Reac2961', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2961.kcst = 0.8
    Reac2962 = smodel.Reac('Reac2962', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac2962.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1pp_s2p_s3pCaM3Ca_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2963 = smodel.Reac('Reac2963', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac2963.kcst = 0.2e6
    Reac2964 = smodel.Reac('Reac2964', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2964.kcst = 0.8
    Reac2965 = smodel.Reac('Reac2965', vsys, lhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1pp_s2p_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac2965.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2966 = smodel.Reac('Reac2966', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac2966.kcst = 0.2e6
    Reac2967 = smodel.Reac('Reac2967', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2967.kcst = 0.8
    Reac2968 = smodel.Reac('Reac2968', vsys, lhs = [CaMKII_s1ppPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2968.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2969 = smodel.Reac('Reac2969', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac2969.kcst = 0.2e6
    Reac2970 = smodel.Reac('Reac2970', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2970.kcst = 0.8
    Reac2971 = smodel.Reac('Reac2971', vsys, lhs = [CaMKII_s1pp_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2971.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca-> CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2972 = smodel.Reac('Reac2972', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac2972.kcst = 0.2e6
    Reac2973 = smodel.Reac('Reac2973', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2973.kcst = 0.8
    Reac2974 = smodel.Reac('Reac2974', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac2974.kcst = 0.2
    
    #CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2975 = smodel.Reac('Reac2975', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac2975.kcst = 0.2e6
    Reac2976 = smodel.Reac('Reac2976', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac2976.kcst = 0.8
    Reac2977 = smodel.Reac('Reac2977', vsys, lhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac2977.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2978 = smodel.Reac('Reac2978', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac2978.kcst = 0.2e6
    Reac2979 = smodel.Reac('Reac2979', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2979.kcst = 0.8
    Reac2980 = smodel.Reac('Reac2980', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2980.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2981 = smodel.Reac('Reac2981', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pCaM3Ca])
    Reac2981.kcst = 0.2e6
    Reac2982 = smodel.Reac('Reac2982', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2982.kcst = 0.8
    Reac2983 = smodel.Reac('Reac2983', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3CaPP2A_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2983.kcst = 0.2

    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2984 = smodel.Reac('Reac2984', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca])
    Reac2984.kcst = 0.2e6
    Reac2985 = smodel.Reac('Reac2985', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2985.kcst = 0.8
    Reac2986 = smodel.Reac('Reac2986', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pCaM3Ca, PP2A])
    Reac2986.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP2A-> CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2987= smodel.Reac('Reac2987', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP2A])
    Reac2987.kcst = 0.2e6
    Reac2988 = smodel.Reac('Reac2988', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac2988.kcst = 0.8
    Reac2989 = smodel.Reac('Reac2989', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3CaPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4CaM3Ca, PP2A])
    Reac2989.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1ppPP2A_s2p_s3pp_s4pCaM3Ca-> CaMKII_s1p_s2p_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2990 = smodel.Reac('Reac2990', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1ppPP2A_s2p_s3pp_s4pCaM3Ca])
    Reac2990.kcst = 0.2e6
    Reac2991 = smodel.Reac('Reac2991', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2991.kcst = 0.8
    Reac2992 = smodel.Reac('Reac2992', vsys, lhs = [CaMKII_s1ppPP2A_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1p_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2992.kcst = 0.2

    #CaMKII_s1pp_s2pPP2A_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2pPP2A_s3pp_s4pCaM3Ca-> CaMKII_s1pp_s2_s3pp_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2993 = smodel.Reac('Reac2993', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2pPP2A_s3pp_s4pCaM3Ca])
    Reac2993.kcst = 0.2e6
    Reac2994 = smodel.Reac('Reac2994', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2pPP2A_s3pp_s4pCaM3Ca, PP2A])
    Reac2994.kcst = 0.8
    Reac2995 = smodel.Reac('Reac2995', vsys, lhs = [CaMKII_s1pp_s2pPP2A_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2_s3pp_s4pCaM3Ca, PP2A])
    Reac2995.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2p_s3ppPP2A_s4pCaM3Ca-> CaMKII_s1pp_s2p_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2996 = smodel.Reac('Reac2996', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2p_s3ppPP2A_s4pCaM3Ca])
    Reac2996.kcst = 0.2e6
    Reac2997 = smodel.Reac('Reac2997', vsys, lhs = [CaMKII_s1pp_s2p_s3ppPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac2997.kcst = 0.8
    Reac2998 = smodel.Reac('Reac2998', vsys, lhs = [CaMKII_s1pp_s2p_s3ppPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pp_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac2998.kcst = 0.2
    
    #CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca + PP2A <-> CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP2A-> CaMKII_s1pp_s2p_s3pp_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac2999 = smodel.Reac('Reac2999', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP2A])
    Reac2999.kcst = 0.2e6
    Reac3000 = smodel.Reac('Reac3000', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP2A], rhs =[CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac3000.kcst = 0.8
    Reac3001 = smodel.Reac('Reac3001', vsys, lhs = [CaMKII_s1pp_s2p_s3pp_s4pCaM3CaPP2A], rhs = [CaMKII_s1pp_s2p_s3pp_s4CaM3Ca, PP2A])
    Reac3001.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2pp_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3002 = smodel.Reac('Reac3002', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pCaM3Ca])
    Reac3002.kcst = 0.2e6
    Reac3003 = smodel.Reac('Reac3003', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac3002.kcst = 0.8
    Reac3004 = smodel.Reac('Reac3004', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac3004.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3005 = smodel.Reac('Reac3005', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pCaM3Ca])
    Reac3005.kcst = 0.2e6
    Reac3006 = smodel.Reac('Reac3006', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac3006.kcst = 0.8
    Reac3007 = smodel.Reac('Reac3007', vsys, lhs = [CaMKII_s1pCaM3Ca_s2ppPP2A_s3p_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac3007.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2pp_s3_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3008 = smodel.Reac('Reac3008', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pCaM3Ca])
    Reac3008.kcst = 0.2e6
    Reac3009 = smodel.Reac('Reac3009', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac3009.kcst = 0.8
    Reac3010 = smodel.Reac('Reac3010', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3pPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3_s4pCaM3Ca, PP2A])
    Reac3010.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP2A-> CaMKII_s1pCaM3Ca_s2pp_s3p_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3011 = smodel.Reac('Reac3011', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP2A])
    Reac3011.kcst = 0.2e6
    Reac3012 = smodel.Reac('Reac3012', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP2A], rhs =[CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac3012.kcst = 0.8
    Reac3013 = smodel.Reac('Reac3013', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3CaPP2A], rhs = [CaMKII_s1pCaM3Ca_s2pp_s3p_s4CaM3Ca, PP2A])
    Reac3013.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3014 = smodel.Reac('Reac3014', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac3014.kcst = 0.2e6
    Reac3015 = smodel.Reac('Reac3015', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3015.kcst = 0.8
    Reac3016 = smodel.Reac('Reac3016', vsys, lhs = [CaMKII_s1pCaM3CaPP2A_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3016.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3017 = smodel.Reac('Reac3017', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac3017.kcst = 0.2e6
    Reac3018 = smodel.Reac('Reac3018', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3018.kcst = 0.8
    Reac3019 = smodel.Reac('Reac3019', vsys, lhs = [CaMKII_s1pCaM3Ca_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3019.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pCaM3Ca-> CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3020 = smodel.Reac('Reac3020', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac3020.kcst = 0.2e6
    Reac3021 = smodel.Reac('Reac3021', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3021.kcst = 0.8
    Reac3022 = smodel.Reac('Reac3022', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac3022.kcst = 0.2
    
    #CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3023 = smodel.Reac('Reac3023', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac3023.kcst = 0.2e6
    Reac3024 = smodel.Reac('Reac3024', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3024.kcst = 0.8
    Reac3025 = smodel.Reac('Reac3025', vsys, lhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac3025.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3026 = smodel.Reac('Reac3026', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac3026.kcst = 0.2e6
    Reac3027 = smodel.Reac('Reac3027', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3027.kcst = 0.8
    Reac3028 = smodel.Reac('Reac3028', vsys, lhs = [CaMKII_s1pPP2A_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3028.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca-> CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3029 = smodel.Reac('Reac3029', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac3029.kcst = 0.2e6
    Reac3030 = smodel.Reac('Reac3030', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3030.kcst = 0.8
    Reac3031 = smodel.Reac('Reac3031', vsys, lhs = [CaMKII_s1p_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3031.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca-> CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3032 = smodel.Reac('Reac3032', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac3032.kcst = 0.2e6
    Reac3033 = smodel.Reac('Reac3033', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3033.kcst = 0.8
    Reac3034 = smodel.Reac('Reac3034', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac3034.kcst = 0.2
    
    #CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A-> CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP2A        #dephosphorylation by PP2A
    Reac3035 = smodel.Reac('Reac3035', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac3035.kcst = 0.2e6
    Reac3036 = smodel.Reac('Reac3036', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3036.kcst = 0.8
    Reac3037 = smodel.Reac('Reac3037', vsys, lhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac3037.kcst = 0.2
    
    ###CaMKII activation for 3 subunits
    ###phosphorylation at Thr305
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3038 = smodel.Reac('Reac3038', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac3038.kcst = kon_cam_t286
    Reac3039 = smodel.Reac('Reac3039', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, CaM3Ca])
    Reac3039.kcst = koff_cam_t286
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac3040 = smodel.Reac('Reac3040', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac3040.kcst = k_t350
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4pp + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp #dissociation of CaM, autophosphorylation withouth CaM
    Reac3041 = smodel.Reac('Reac3041', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac3041.kcst = kon_cam_t286
    Reac3042 = smodel.Reac('Reac3042', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp, CaM3Ca])
    Reac3042.kcst = koff_cam_t286

    # CaMKII_s1_s2pCaM3Ca_s3p_s4pp -> CaMKII_s1_s2pCaM3Ca_s3pp_s4pp #autophosphorylation at Thr305
    Reac3043 = smodel.Reac('Reac3043', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp])
    Reac3043.kcst = k_t350
    
    # CaMKII_s1_s2p_s3pp_s4pp + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3pp_s4pp #dissociation of CaM, autophosphorylation withouth CaM
    Reac3044 = smodel.Reac('Reac3044', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp])
    Reac3044.kcst = kon_cam_t286
    Reac3045 = smodel.Reac('Reac3045', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp], rhs = [CaMKII_s1_s2p_s3pp_s4pp, CaM3Ca])
    Reac3045.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3pp_s4pp -> CaMKII_s1_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac3046 = smodel.Reac('Reac3046', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp], rhs = [CaMKII_s1_s2pp_s3pp_s4pp])
    Reac3046.kcst = k_t350
    
    # CaMKII_s1_s2p_s3p_s4pp + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3p_s4pp #dissociation of CaM, autophosphorylation withouth CaM
    Reac3047 = smodel.Reac('Reac3047', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp])
    Reac3047.kcst = kon_cam_t286
    Reac3048 = smodel.Reac('Reac3048', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1_s2p_s3p_s4pp, CaM3Ca])
    Reac3048.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3p_s4pp -> CaMKII_s1_s2p_s3pp_s4pp #autophosphorylation at Thr305
    Reac3049 = smodel.Reac('Reac3049', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp], rhs = [CaMKII_s1_s2pp_s3pp_s4pp])
    Reac3049.kcst = k_t350
    
    # CaMKII_s1_s2p_s3p_s4pp -> CaMKII_s1_s2pp_s3p_s4pp #autophosphorylation at Thr305
    Reac3050 = smodel.Reac('Reac3050', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp], rhs = [CaMKII_s1_s2pp_s3pp_s4pp])
    Reac3050.kcst = k_t350
    
    # CaMKII_s1_s2pp_s3p_s4pp -> CaMKII_s1_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac3051 = smodel.Reac('Reac3051', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp], rhs = [CaMKII_s1_s2pp_s3pp_s4pp])
    Reac3051.kcst = k_t350
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pp + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp #dissociation of CaM, autophosphorylation withouth CaM
    Reac3052 = smodel.Reac('Reac3052', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp])
    Reac3052.kcst = kon_cam_t286
    Reac3053 = smodel.Reac('Reac3053', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp, CaM3Ca])
    Reac3053.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3p_s4pp + CaM3Ca <->  CaMKII_s1_s2p_s3pCaM3Ca_s4pp #dissociation of CaM, autophosphorylation withouth CaM
    Reac3054 = smodel.Reac('Reac3054', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp])
    Reac3054.kcst = kon_cam_t286
    Reac3055 = smodel.Reac('Reac3055', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2p_s3p_s4pp, CaM3Ca])
    Reac3055.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pp -> CaMKII_s1_s2pp_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac3056 = smodel.Reac('Reac3056', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp], rhs = [CaMKII_s1_s2pp_s3pp_s4pp])
    Reac3056.kcst = k_t350
    
    # CaMKII_s1_s2pp_s3p_s4pp + CaM3Ca <->  CaMKII_s1_s2pp_s3pCaM3Ca_s4pp #dissociation of CaM, autophosphorylation withouth CaM
    Reac3057 = smodel.Reac('Reac3057', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp])
    Reac3057.kcst = kon_cam_t286
    Reac3058 = smodel.Reac('Reac3058', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2pp_s3p_s4pp, CaM3Ca])
    Reac3058.kcst = koff_cam_t286
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4p + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac3059 = smodel.Reac('Reac3059', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac3059.kcst = kon_cam_t286
    Reac3060 = smodel.Reac('Reac3060', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, CaM3Ca])
    Reac3060.kcst = koff_cam_t286
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4p -> CaMKII_s1_s2pCaM3Ca_s3p_s4pp #autophosphorylation at Thr305
    Reac3061 = smodel.Reac('Reac3061', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp])
    Reac3061.kcst = k_t350
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4pp -> CaMKII_s1_s2pCaM3Ca_s3pp_s4pp #autophosphorylation at Thr305
    Reac3062 = smodel.Reac('Reac3062', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp])
    Reac3062.kcst = k_t350
    
    # CaMKII_s1_s2p_s3p_s4pp + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3p_s4pp #dissociation of CaM, autophosphorylation withouth CaM
    Reac3063 = smodel.Reac('Reac3063', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pp, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp])
    Reac3063.kcst = kon_cam_t286
    Reac3064 = smodel.Reac('Reac3064', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp], rhs = [CaMKII_s1_s2p_s3p_s4pp, CaM3Ca])
    Reac3064.kcst = koff_cam_t286
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4p -> CaMKII_s1_s2pCaM3Ca_s3pp_s4p #autophosphorylation at Thr305
    Reac3065 = smodel.Reac('Reac3065', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p])
    Reac3065.kcst = k_t350
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4p -> CaMKII_s1_s2pCaM3Ca_s3pp_s4pp #autophosphorylation at Thr305
    Reac3066 = smodel.Reac('Reac3066', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp])
    Reac3066.kcst = k_t350
    
    # CaMKII_s1_s2p_s3pp_s4p + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3pp_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac3067 = smodel.Reac('Reac3067', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p])
    Reac3067.kcst = kon_cam_t286
    Reac3068 = smodel.Reac('Reac3068', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p], rhs = [CaMKII_s1_s2p_s3pp_s4p, CaM3Ca])
    Reac3068.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3pp_s4p -> CaMKII_s1_s2p_s3pp_s4pp #autophosphorylation at Thr305
    Reac3069 = smodel.Reac('Reac3069', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4p], rhs = [CaMKII_s1_s2p_s3pp_s4pp])
    Reac3069.kcst = k_t350
    
    # CaMKII_s1_s2p_s3p_s4p + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3p_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac3070 = smodel.Reac('Reac3070', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p])
    Reac3070.kcst = kon_cam_t286
    Reac3071 = smodel.Reac('Reac3071', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p], rhs = [CaMKII_s1_s2p_s3p_s4p, CaM3Ca])
    Reac3071.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3p_s4p -> CaMKII_s1_s2p_s3p_s4pp #autophosphorylation at Thr305
    Reac3072 = smodel.Reac('Reac3072', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p], rhs = [CaMKII_s1_s2p_s3p_s4pp])
    Reac3072.kcst = k_t350
    
    # CaMKII_s1_s2p_s3p_s4p -> CaMKII_s1_s2p_s3pp_s4p #autophosphorylation at Thr305
    Reac3073 = smodel.Reac('Reac3073', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p], rhs = [CaMKII_s1_s2p_s3pp_s4p])
    Reac3073.kcst = k_t350
    
    # CaMKII_s1_s2p_s3p_s4p -> CaMKII_s1_s2pp_s3p_s4p #autophosphorylation at Thr305
    Reac3074 = smodel.Reac('Reac3074', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p], rhs = [CaMKII_s1_s2pp_s3p_s4p])
    Reac3074.kcst = k_t350
    
    
    # CaMKII_s1_s2pp_s3p_s4p -> CaMKII_s1_s2pp_s3p_s4pp #autophosphorylation at Thr305
    Reac3075 = smodel.Reac('Reac3075', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4p], rhs = [CaMKII_s1_s2pp_s3p_s4pp])
    Reac3075.kcst = k_t350
    
    # CaMKII_s1_s2pp_s3p_s4p -> CaMKII_s1_s2pp_s3pp_s4p #autophosphorylation at Thr305
    Reac3076 = smodel.Reac('Reac3076', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4p], rhs = [CaMKII_s1_s2pp_s3pp_s4p])
    Reac3076.kcst = k_t350
    
    # CaMKII_s1_s2pp_s3pp_s4p -> CaMKII_s1_s2pp_s3pp_s4pp #autophosphorylation at Thr305
    Reac3077 = smodel.Reac('Reac3077', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4p], rhs = [CaMKII_s1_s2pp_s3pp_s4pp])
    Reac3077.kcst = k_t350
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4p + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac3078 = smodel.Reac('Reac3078', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p])
    Reac3078.kcst = kon_cam_t286
    Reac3079 = smodel.Reac('Reac3079', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, CaM3Ca])
    Reac3079.kcst = koff_cam_t286
    
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4p -> CaMKII_s1_s2p_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac3080 = smodel.Reac('Reac3080', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp])
    Reac3080.kcst = k_t350
    
    
    # CaMKII_s1_s2p_s3p_s4p + CaM3Ca <->  CaMKII_s1_s2p_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac3081 = smodel.Reac('Reac3081', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p])
    Reac3081.kcst = kon_cam_t286
    Reac3082 = smodel.Reac('Reac3082', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2p_s3p_s4p, CaM3Ca])
    Reac3082.kcst = koff_cam_t286
    
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4p -> CaMKII_s1_s2pp_s3pCaM3Ca_s4p #autophosphorylation at Thr305
    Reac3083 = smodel.Reac('Reac3083', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p])
    Reac3083.kcst = k_t350
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4p -> CaMKII_s1_s2p_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac3084 = smodel.Reac('Reac3084', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp])
    Reac3084.kcst = k_t350
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4p -> CaMKII_s1_s2pp_s3pCaM3Ca_s4pp #autophosphorylation at Thr305
    Reac3085 = smodel.Reac('Reac3085', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp])
    Reac3085.kcst = k_t350
    
    # CaMKII_s1_s2pp_s3p_s4p + CaM3Ca <->  CaMKII_s1_s2pp_s3pCaM3Ca_s4p #dissociation of CaM, autophosphorylation withouth CaM
    Reac3086 = smodel.Reac('Reac3086', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p])
    Reac3086.kcst = kon_cam_t286
    Reac3087 = smodel.Reac('Reac3087', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2pp_s3p_s4p, CaM3Ca])
    Reac3087.kcst = koff_cam_t286
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3088 = smodel.Reac('Reac3088', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac3088.kcst = kon_cam_t286
    Reac3089 = smodel.Reac('Reac3089', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, CaM3Ca])
    Reac3089.kcst = koff_cam_t286
    
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4p + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3090 = smodel.Reac('Reac3090', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac3090.kcst = kon_cam_t286
    Reac3091 = smodel.Reac('Reac3091', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, CaM3Ca])
    Reac3091.kcst = koff_cam_t286
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca -> CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca #autophosphorylation at Thr305
    Reac3092 = smodel.Reac('Reac3092', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac3092.kcst = k_t350
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4p + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3093 = smodel.Reac('Reac3093', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac3093.kcst = kon_cam_t286
    Reac3094 = smodel.Reac('Reac3094', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, CaM3Ca])
    Reac3094.kcst = koff_cam_t286

    # CaMKII_s1_s2p_s3pp_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3095 = smodel.Reac('Reac3095', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca])
    Reac3095.kcst = kon_cam_t286
    Reac3096 = smodel.Reac('Reac3096', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca, CaM3Ca])
    Reac3096.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3pp_s4p + CaM3Ca <->  CaMKII_s1_s2p_s3pp_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3097 = smodel.Reac('Reac3097', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4p, CaM3Ca], rhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca])
    Reac3097.kcst = kon_cam_t286
    Reac3098 = smodel.Reac('Reac3098', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3pp_s4p, CaM3Ca])
    Reac3098.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3p_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3099 = smodel.Reac('Reac3099', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca])
    Reac3099.kcst = kon_cam_t286
    Reac3100 = smodel.Reac('Reac3100', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca, CaM3Ca])
    Reac3100.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3p_s4p + CaM3Ca <->  CaMKII_s1_s2p_s3p_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3101 = smodel.Reac('Reac3101', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca])
    Reac3101.kcst = kon_cam_t286
    Reac3102 = smodel.Reac('Reac3102', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3p_s4p, CaM3Ca])
    Reac3102.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3p_s4pCaM3Ca -> CaMKII_s1_s2p_s3pp_s4pCaM3Ca #autophosphorylation at Thr305
    Reac3103 = smodel.Reac('Reac3103', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca])
    Reac3103.kcst = k_t350
    
    # CaMKII_s1_s2p_s3p_s4pCaM3Ca -> CaMKII_s1_s2pp_s3p_s4pCaM3Ca #autophosphorylation at Thr305
    Reac3104 = smodel.Reac('Reac3104', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca])
    Reac3104.kcst = k_t350
    
    # CaMKII_s1_s2pp_s3p_s4p + CaM3Ca <->  CaMKII_s1_s2pp_s3p_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3105 = smodel.Reac('Reac3105', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4p, CaM3Ca], rhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca])
    Reac3105.kcst = kon_cam_t286
    Reac3106 = smodel.Reac('Reac3106', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3p_s4p, CaM3Ca])
    Reac3106.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3107 = smodel.Reac('Reac3107', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac3107.kcst = kon_cam_t286
    Reac3108 = smodel.Reac('Reac3108', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, CaM3Ca])
    Reac3108.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4p + CaM3Ca <->  CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3109 = smodel.Reac('Reac3109', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac3109.kcst = kon_cam_t286
    Reac3110 = smodel.Reac('Reac3110', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, CaM3Ca])
    Reac3110.kcst = koff_cam_t286
    
    # CaMKII_s1_s2p_s3p_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3111 = smodel.Reac('Reac3111', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca])
    Reac3111.kcst = kon_cam_t286
    Reac3112 = smodel.Reac('Reac3112', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca, CaM3Ca])
    Reac3112.kcst = koff_cam_t286

    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca #autophosphorylation at Thr305
    Reac3113 = smodel.Reac('Reac3113', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac3113.kcst = k_t350
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4p + CaM3Ca <->  CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3114 = smodel.Reac('Reac3114', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, CaM3Ca], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac3114.kcst = kon_cam_t286
    Reac3115 = smodel.Reac('Reac3115', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, CaM3Ca])
    Reac3115.kcst = koff_cam_t286
    
    # CaMKII_s1_s2pp_s3p_s4pCaM3Ca + CaM3Ca <->  CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca #dissociation of CaM, autophosphorylation withouth CaM
    Reac3116 = smodel.Reac('Reac3116', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca, CaM3Ca], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca])
    Reac3116.kcst = kon_cam_t286
    Reac3117 = smodel.Reac('Reac3117', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca, CaM3Ca])
    Reac3117.kcst = koff_cam_t286
    
    #3 subunits dephosphorylation  by PP1
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1  -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP1
    Reac3118 = smodel.Reac('Reac3118', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac3118.kcst = 3.3333e6
    Reac3119 = smodel.Reac('Reac3119', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3119.kcst = 8
    Reac3120 = smodel.Reac('Reac3120', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac3120.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca  -> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP1
    Reac3121 = smodel.Reac('Reac3121', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac3121.kcst = 3.3333e6
    Reac3122 = smodel.Reac('Reac3122', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3122.kcst = 8
    Reac3123 = smodel.Reac('Reac3123', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac3123.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca  -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP1
    Reac3124 = smodel.Reac('Reac3124', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac3124.kcst = 3.3333e6
    Reac3125 = smodel.Reac('Reac3125', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3125.kcst = 8
    Reac3126 = smodel.Reac('Reac3126', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3126.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP1  -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4 + PP1
    Reac3127 = smodel.Reac('Reac3127', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP1])
    Reac3127.kcst = 3.3333e6
    Reac3128 = smodel.Reac('Reac3128', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac3128.kcst = 8
    Reac3129 = smodel.Reac('Reac3129', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, PP1])
    Reac3129.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4p  -> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4p + PP1
    Reac3130 = smodel.Reac('Reac3130', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4p])
    Reac3130.kcst = 3.3333e6
    Reac3131 = smodel.Reac('Reac3131', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac3131.kcst = 8
    Reac3132 = smodel.Reac('Reac3132', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4p, PP1])
    Reac3132.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1 <->   CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4p  -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4p + PP1
    Reac3133 = smodel.Reac('Reac3133', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4p])
    Reac3133.kcst = 3.3333e6
    Reac3134 = smodel.Reac('Reac3134', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac3134.kcst = 8
    Reac3135 = smodel.Reac('Reac3135', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac3135.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1  -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p + PP1
    Reac3136 = smodel.Reac('Reac3136', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1])
    Reac3136.kcst = 3.3333e6
    Reac3137 = smodel.Reac('Reac3137', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac3137.kcst = 8
    Reac3138 = smodel.Reac('Reac3138', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac3138.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pp  -> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp + PP1   3b
    Reac3139 = smodel.Reac('Reac3139', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pp])
    Reac3139.kcst = 3.3333e6
    Reac3140 = smodel.Reac('Reac3140', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac3140.kcst = 8
    Reac3141 = smodel.Reac('Reac3141', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp, PP1])
    Reac3141.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pp  -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp + PP1   3c
    Reac3142 = smodel.Reac('Reac3142', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pp])
    Reac3142.kcst = 3.3333e6
    Reac3143 = smodel.Reac('Reac3143', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac3143.kcst = 8
    Reac3144 = smodel.Reac('Reac3144', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac3144.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1  -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p  + PP1
    Reac3145 = smodel.Reac('Reac3145', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1])
    Reac3145.kcst = 3.3333e6
    Reac3146 = smodel.Reac('Reac3146', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac3146.kcst = 8
    Reac3147 = smodel.Reac('Reac3147', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP1])
    Reac3147.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pp  -> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp  + PP1
    Reac3148 = smodel.Reac('Reac3148', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pp])
    Reac3148.kcst = 3.3333e6
    Reac3149 = smodel.Reac('Reac3149', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac3149.kcst = 8
    Reac3150 = smodel.Reac('Reac3150', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp, PP1])
    Reac3150.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pp  -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp  + PP1
    Reac3151 = smodel.Reac('Reac3151', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pp])
    Reac3151.kcst = 3.3333e6
    Reac3152 = smodel.Reac('Reac3152', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac3152.kcst = 8
    Reac3153 = smodel.Reac('Reac3153', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp, PP1])
    Reac3153.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pp + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP1  -> CaMKII_s1_s2pCaM3Ca_s3pp_s4p  + PP1
    Reac3154 = smodel.Reac('Reac3154', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP1])
    Reac3154.kcst = 3.3333e6
    Reac3155 = smodel.Reac('Reac3155', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP1], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac3155.kcst = 8
    Reac3156 = smodel.Reac('Reac3156', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac3156.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pp + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pp  -> CaMKII_s1_s2pCaM3Ca_s3p_s4pp  + PP1
    Reac3157 = smodel.Reac('Reac3157', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pp])
    Reac3157.kcst = 3.3333e6
    Reac3158 = smodel.Reac('Reac3158', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac3158.kcst = 8
    Reac3159 = smodel.Reac('Reac3159', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp, PP1])
    Reac3159.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pp + PP1 <->   CaMKII_s1_s2pCaM3CaPP1_s3p_s4pp  -> CaMKII_s1_s2CaM3Ca_s3p_s4pp  + PP1
    Reac3160 = smodel.Reac('Reac3160', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3pp_s4pp])
    Reac3160.kcst = 3.3333e6
    Reac3161 = smodel.Reac('Reac3161', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pp_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP1])
    Reac3161.kcst = 8
    Reac3162 = smodel.Reac('Reac3162', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pp_s4pp], rhs = [CaMKII_s1_s2CaM3Ca_s3pp_s4pp, PP1])
    Reac3162.kcst = 2
    
    # CaMKII_s1_s2p_s3pp_s4pp + PP1 <->   CaMKII_s1_s2p_s3pp_s4ppPP1  -> CaMKII_s1_s2p_s3pp_s4p  + PP1
    Reac3163 = smodel.Reac('Reac3163', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp, PP1], rhs = [CaMKII_s1_s2p_s3pp_s4ppPP1])
    Reac3163.kcst = 3.3333e6
    Reac3164 = smodel.Reac('Reac3164', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4ppPP1], rhs =[CaMKII_s1_s2p_s3pp_s4pp, PP1])
    Reac3164.kcst = 8
    Reac3165 = smodel.Reac('Reac3165', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4ppPP1], rhs = [CaMKII_s1_s2p_s3pp_s4p, PP1])
    Reac3165.kcst = 2
    
    # CaMKII_s1_s2p_s3pp_s4pp + PP1 <->   CaMKII_s1_s2p_s3ppPP1_s4pp  -> CaMKII_s1_s2p_s3p_s4pp  + PP1
    Reac3166 = smodel.Reac('Reac3166', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp, PP1], rhs = [CaMKII_s1_s2p_s3ppPP1_s4pp])
    Reac3166.kcst = 3.3333e6
    Reac3167 = smodel.Reac('Reac3167', vsys, lhs = [CaMKII_s1_s2p_s3ppPP1_s4pp], rhs =[CaMKII_s1_s2p_s3pp_s4pp, PP1])
    Reac3167.kcst = 8
    Reac3168 = smodel.Reac('Reac3168', vsys, lhs = [CaMKII_s1_s2p_s3ppPP1_s4pp], rhs = [CaMKII_s1_s2p_s3p_s4pp, PP1])
    Reac3168.kcst = 2
    
    # CaMKII_s1_s2p_s3pp_s4pp + PP1 <->   CaMKII_s1_s2pPP1_s3pp_s4pp  -> CaMKII_s1_s2_s3pp_s4pp  + PP1
    Reac3169 = smodel.Reac('Reac3169', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp, PP1], rhs = [CaMKII_s1_s2pPP1_s3pp_s4pp])
    Reac3169.kcst = 3.3333e6
    Reac3170 = smodel.Reac('Reac3170', vsys, lhs = [CaMKII_s1_s2pPP1_s3pp_s4pp], rhs =[CaMKII_s1_s2p_s3pp_s4pp, PP1])
    Reac3170.kcst = 8
    Reac3171 = smodel.Reac('Reac3171', vsys, lhs = [CaMKII_s1_s2pPP1_s3pp_s4pp], rhs = [CaMKII_s1_s2_s3pp_s4pp, PP1])
    Reac3171.kcst = 2
    
    
    # CaMKII_s1_s2pp_s3pp_s4pp + PP1 <->   CaMKII_s1_s2pp_s3pp_s4ppPP1  -> CaMKII_s1_s2pp_s3pp_s4p  + PP1
    Reac3172 = smodel.Reac('Reac3172', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1_s2pp_s3pp_s4ppPP1])
    Reac3172.kcst = 3.3333e6
    Reac3173 = smodel.Reac('Reac3173', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4ppPP1], rhs =[CaMKII_s1_s2pp_s3pp_s4pp, PP1])
    Reac3173.kcst = 8
    Reac3174 = smodel.Reac('Reac3174', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4ppPP1], rhs = [CaMKII_s1_s2pp_s3pp_s4p, PP1])
    Reac3174.kcst = 2
    
    # CaMKII_s1_s2pp_s3pp_s4pp + PP1 <->   CaMKII_s1_s2pp_s3ppPP1_s4pp  -> CaMKII_s1_s2pp_s3p_s4pp  + PP1
    Reac3175 = smodel.Reac('Reac3175', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1_s2pp_s3ppPP1_s4pp])
    Reac3175.kcst = 3.3333e6
    Reac3176 = smodel.Reac('Reac3176', vsys, lhs = [CaMKII_s1_s2pp_s3ppPP1_s4pp], rhs =[CaMKII_s1_s2pp_s3pp_s4pp, PP1])
    Reac3176.kcst = 8
    Reac3177 = smodel.Reac('Reac3177', vsys, lhs = [CaMKII_s1_s2pp_s3ppPP1_s4pp], rhs = [CaMKII_s1_s2pp_s3p_s4pp, PP1])
    Reac3177.kcst = 2
    
    # CaMKII_s1_s2pp_s3pp_s4pp + PP1 <->   CaMKII_s1_s2ppPP1_s3pp_s4pp  -> CaMKII_s1_s2p_s3pp_s4pp  + PP1
    Reac3178 = smodel.Reac('Reac3178', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4pp, PP1], rhs = [CaMKII_s1_s2ppPP1_s3pp_s4pp])
    Reac3178.kcst = 3.3333e6
    Reac3179 = smodel.Reac('Reac3179', vsys, lhs = [CaMKII_s1_s2ppPP1_s3pp_s4pp], rhs =[CaMKII_s1_s2pp_s3pp_s4pp, PP1])
    Reac3179.kcst = 8
    Reac3180 = smodel.Reac('Reac3180', vsys, lhs = [CaMKII_s1_s2ppPP1_s3pp_s4pp], rhs = [CaMKII_s1_s2p_s3pp_s4pp, PP1])
    Reac3180.kcst = 2
   
    # CaMKII_s1_s2p_s3p_s4pp + PP1 <->   CaMKII_s1_s2p_s3p_s4ppPP1  -> CaMKII_s1_s2p_s3p_s4p  + PP1
    Reac3181 = smodel.Reac('Reac3181', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1_s2p_s3p_s4ppPP1])
    Reac3181.kcst = 3.3333e6
    Reac3182 = smodel.Reac('Reac3182', vsys, lhs = [CaMKII_s1_s2p_s3p_s4ppPP1], rhs =[CaMKII_s1_s2p_s3p_s4pp, PP1])
    Reac3182.kcst = 8
    Reac3183 = smodel.Reac('Reac3183', vsys, lhs = [CaMKII_s1_s2p_s3p_s4ppPP1], rhs = [CaMKII_s1_s2p_s3p_s4p, PP1])
    Reac3183.kcst = 2
    
    # CaMKII_s1_s2p_s3p_s4pp + PP1 <->   CaMKII_s1_s2p_s3pPP1_s4pp  -> CaMKII_s1_s2p_s3_s4pp  + PP1
    Reac3184 = smodel.Reac('Reac3184', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1_s2p_s3pPP1_s4pp])
    Reac3184.kcst = 3.3333e6
    Reac3185 = smodel.Reac('Reac3185', vsys, lhs = [CaMKII_s1_s2p_s3pPP1_s4pp], rhs =[CaMKII_s1_s2p_s3p_s4pp, PP1])
    Reac3185.kcst = 8
    Reac3186 = smodel.Reac('Reac3186', vsys, lhs = [CaMKII_s1_s2p_s3pPP1_s4pp], rhs = [CaMKII_s1_s2p_s3_s4pp, PP1])
    Reac3186.kcst = 2
    
    # CaMKII_s1_s2p_s3p_s4pp + PP1 <->   CaMKII_s1_s2pPP1_s3p_s4pp  -> CaMKII_s1_s2_s3p_s4pp  + PP1
    Reac3187 = smodel.Reac('Reac3187', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pp, PP1], rhs = [CaMKII_s1_s2pPP1_s3p_s4pp])
    Reac3187.kcst = 3.3333e6
    Reac3188 = smodel.Reac('Reac3188', vsys, lhs = [CaMKII_s1_s2pPP1_s3p_s4pp], rhs =[CaMKII_s1_s2p_s3p_s4pp, PP1])
    Reac3188.kcst = 8
    Reac3189 = smodel.Reac('Reac3189', vsys, lhs = [CaMKII_s1_s2pPP1_s3p_s4pp], rhs = [CaMKII_s1_s2_s3p_s4pp, PP1])
    Reac3189.kcst = 2
    
    
    # CaMKII_s1_s2pp_s3p_s4pp + PP1 <->   CaMKII_s1_s2pp_s3p_s4ppPP1  -> CaMKII_s1_s2pp_s3p_s4p  + PP1
    Reac3190 = smodel.Reac('Reac3190', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1_s2pp_s3p_s4ppPP1])
    Reac3190.kcst = 3.3333e6
    Reac3191 = smodel.Reac('Reac3191', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4ppPP1], rhs =[CaMKII_s1_s2pp_s3p_s4pp, PP1])
    Reac3191.kcst = 8
    Reac3192 = smodel.Reac('Reac3192', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4ppPP1], rhs = [CaMKII_s1_s2pp_s3p_s4p, PP1])
    Reac3192.kcst = 2
    
    # CaMKII_s1_s2pp_s3p_s4pp + PP1 <->   CaMKII_s1_s2pp_s3pPP1_s4pp  -> CaMKII_s1_s2pp_s3_s4pp  + PP1
    Reac3193 = smodel.Reac('Reac3193', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1_s2pp_s3pPP1_s4pp])
    Reac3193.kcst = 3.3333e6
    Reac3194 = smodel.Reac('Reac3194', vsys, lhs = [CaMKII_s1_s2pp_s3pPP1_s4pp], rhs =[CaMKII_s1_s2pp_s3p_s4pp, PP1])
    Reac3194.kcst = 8
    Reac3195 = smodel.Reac('Reac3195', vsys, lhs = [CaMKII_s1_s2pp_s3pPP1_s4pp], rhs = [CaMKII_s1_s2pp_s3_s4pp, PP1])
    Reac3195.kcst = 2
    
    # CaMKII_s1_s2pp_s3p_s4pp + PP1 <->   CaMKII_s1_s2ppPP1_s3p_s4pp  -> CaMKII_s1_s2p_s3p_s4pp  + PP1
    Reac3196 = smodel.Reac('Reac3196', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pp, PP1], rhs = [CaMKII_s1_s2ppPP1_s3p_s4pp])
    Reac3196.kcst = 3.3333e6
    Reac3197 = smodel.Reac('Reac3197', vsys, lhs = [CaMKII_s1_s2ppPP1_s3p_s4pp], rhs =[CaMKII_s1_s2pp_s3p_s4pp, PP1])
    Reac3197.kcst = 8
    Reac3198 = smodel.Reac('Reac3198', vsys, lhs = [CaMKII_s1_s2ppPP1_s3p_s4pp], rhs = [CaMKII_s1_s2p_s3p_s4pp, PP1])
    Reac3198.kcst = 2
    
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP1  -> CaMKII_s1_s2p_s3pCaM3Ca_s4p  + PP1
    Reac3199 = smodel.Reac('Reac3199', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP1])
    Reac3199.kcst = 3.3333e6
    Reac3200 = smodel.Reac('Reac3200', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac3200.kcst = 8
    Reac3201 = smodel.Reac('Reac3201', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP1])
    Reac3201.kcst = 2
    
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2p_s3pCaM3CaPP1_s4pp  -> CaMKII_s1_s2p_s3CaM3Ca_s4pp  + PP1
    Reac3202 = smodel.Reac('Reac3202', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP1_s4pp, PP1], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp])
    Reac3202.kcst = 3.3333e6
    Reac3203 = smodel.Reac('Reac3203', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1_s2p_s3pCaM3CaPP1_s4pp, PP1])
    Reac3203.kcst = 8
    Reac3204 = smodel.Reac('Reac3204', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2p_s3CaM3Ca_s4pp, PP1])
    Reac3204.kcst = 2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pp  -> CaMKII_s1_s2_s3pCaM3Ca_s4pp  + PP1
    Reac3205 = smodel.Reac('Reac3205', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pp])
    Reac3205.kcst = 3.3333e6
    Reac3206 = smodel.Reac('Reac3206', vsys, lhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac3206.kcst = 8
    Reac3207 = smodel.Reac('Reac3207', vsys, lhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pp, PP1])
    Reac3207.kcst = 2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP1  -> CaMKII_s1_s2pp_s3pCaM3Ca_s4p  + PP1
    Reac3208 = smodel.Reac('Reac3208', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP1])
    Reac3208.kcst = 3.3333e6
    Reac3209 = smodel.Reac('Reac3209', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP1], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac3209.kcst = 8
    Reac3210 = smodel.Reac('Reac3210', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP1], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac3210.kcst = 2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pp  -> CaMKII_s1_s2pp_s3CaM3Ca_s4pp  + PP1
    Reac3211 = smodel.Reac('Reac3211', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pp])
    Reac3211.kcst = 3.3333e6
    Reac3212 = smodel.Reac('Reac3212', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pp], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac3212.kcst = 8
    Reac3213 = smodel.Reac('Reac3213', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pp], rhs = [CaMKII_s1_s2pp_s3CaM3Ca_s4pp, PP1])
    Reac3213.kcst = 2
   
     # CaMKII_s1_s2pp_s3pCaM3Ca_s4pp + PP1 <->   CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pp  -> CaMKII_s1_s2p_s3pCaM3Ca_s4pp  + PP1
    Reac3214 = smodel.Reac('Reac3214', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP1], rhs = [CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pp])
    Reac3214.kcst = 3.3333e6
    Reac3215 = smodel.Reac('Reac3215', vsys, lhs = [CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP1])
    Reac3215.kcst = 8
    Reac3216 = smodel.Reac('Reac3216', vsys, lhs = [CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP1])
    Reac3216.kcst = 2
    
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4p + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3p_s4pPP1  -> CaMKII_s1_s2pCaM3Ca_s3p_s4  + PP1
    Reac3217 = smodel.Reac('Reac3217', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pPP1])
    Reac3217.kcst = 3.3333e6
    Reac3218 = smodel.Reac('Reac3218', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pPP1], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP1])
    Reac3218.kcst = 8
    Reac3219 = smodel.Reac('Reac3219', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pPP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4, PP1])
    Reac3219.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4p + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pPP1_s4p  -> CaMKII_s1_s2pCaM3Ca_s3_s4p  + PP1
    Reac3220 = smodel.Reac('Reac3220', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pPP1_s4p])
    Reac3220.kcst = 3.3333e6
    Reac3221 = smodel.Reac('Reac3221', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pPP1_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP1])
    Reac3221.kcst = 8
    Reac3222 = smodel.Reac('Reac3222', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pPP1_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3_s4p, PP1])
    Reac3222.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4p + PP1 <->   CaMKII_s1_s2pCaM3CaPP1_s3p_s4p  -> CaMKII_s1_s2CaM3Ca_s3p_s4p  + PP1
    Reac3223 = smodel.Reac('Reac3223', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3p_s4p])
    Reac3223.kcst = 3.3333e6
    Reac3224 = smodel.Reac('Reac3224', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3p_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP1])
    Reac3224.kcst = 8
    Reac3225 = smodel.Reac('Reac3225', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3p_s4p], rhs = [CaMKII_s1_s2CaM3Ca_s3p_s4p, PP1])
    Reac3225.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4p + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP1  -> CaMKII_s1_s2pCaM3Ca_s3pp_s4  + PP1
    Reac3226 = smodel.Reac('Reac3226', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP1])
    Reac3226.kcst = 3.3333e6
    Reac3227 = smodel.Reac('Reac3227', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP1], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac3227.kcst = 8
    Reac3228 = smodel.Reac('Reac3228', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4, PP1])
    Reac3228.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4p + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4p  -> CaMKII_s1_s2pCaM3Ca_s3p_s4p  + PP1
    Reac3229 = smodel.Reac('Reac3229', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4p])
    Reac3229.kcst = 3.3333e6
    Reac3230 = smodel.Reac('Reac3230', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac3230.kcst = 8
    Reac3231 = smodel.Reac('Reac3231', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP1])
    Reac3231.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4p + PP1 <->   CaMKII_s1_s2pCaM3CaPP1_s3pp_s4p  -> CaMKII_s1_s2CaM3Ca_s3pp_s4p  + PP1
    Reac3232 = smodel.Reac('Reac3232', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3pp_s4p])
    Reac3232.kcst = 3.3333e6
    Reac3233 = smodel.Reac('Reac3233', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pp_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP1])
    Reac3233.kcst = 8
    Reac3234 = smodel.Reac('Reac3234', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pp_s4p], rhs = [CaMKII_s1_s2CaM3Ca_s3pp_s4p, PP1])
    Reac3234.kcst = 2
    
    # CaMKII_s1_s2p_s3pp_s4p + PP1 <->   CaMKII_s1_s2p_s3pp_s4pPP1  -> CaMKII_s1_s2p_s3pp_s4  + PP1
    Reac3235 = smodel.Reac('Reac3235', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1_s2p_s3pp_s4pPP1])
    Reac3235.kcst = 3.3333e6
    Reac3236 = smodel.Reac('Reac3236', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pPP1], rhs =[CaMKII_s1_s2p_s3pp_s4p, PP1])
    Reac3236.kcst = 8
    Reac3237 = smodel.Reac('Reac3237', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pPP1], rhs = [CaMKII_s1_s2p_s3pp_s4, PP1])
    Reac3237.kcst = 2
    
    # CaMKII_s1_s2p_s3pp_s4p + PP1 <->   CaMKII_s1_s2p_s3ppPP1_s4p  -> CaMKII_s1_s2p_s3p_s4p  + PP1
    Reac3238 = smodel.Reac('Reac3238', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1_s2p_s3ppPP1_s4p])
    Reac3238.kcst = 3.3333e6
    Reac3239 = smodel.Reac('Reac3239', vsys, lhs = [CaMKII_s1_s2p_s3ppPP1_s4p], rhs =[CaMKII_s1_s2p_s3pp_s4p, PP1])
    Reac3239.kcst = 8
    Reac3240 = smodel.Reac('Reac3240', vsys, lhs = [CaMKII_s1_s2p_s3ppPP1_s4p], rhs = [CaMKII_s1_s2p_s3p_s4p, PP1])
    Reac3240.kcst = 2
    
    # CaMKII_s1_s2p_s3pp_s4p + PP1 <->   CaMKII_s1_s2pPP1_s3pp_s4p  -> CaMKII_s1_s2_s3pp_s4p  + PP1
    Reac3241 = smodel.Reac('Reac3241', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4p, PP1], rhs = [CaMKII_s1_s2pPP1_s3pp_s4p])
    Reac3241.kcst = 3.3333e6
    Reac3242 = smodel.Reac('Reac3242', vsys, lhs = [CaMKII_s1_s2pPP1_s3pp_s4p], rhs =[CaMKII_s1_s2p_s3pp_s4p, PP1])
    Reac3242.kcst = 8
    Reac3243 = smodel.Reac('Reac3243', vsys, lhs = [CaMKII_s1_s2pPP1_s3pp_s4p], rhs = [CaMKII_s1_s2_s3pp_s4p, PP1])
    Reac3243.kcst = 2
    
    # CaMKII_s1_s2p_s3p_s4p + PP1 <->   CaMKII_s1_s2p_s3p_s4pPP1  -> CaMKII_s1_s2p_s3p_s4  + PP1
    Reac3244 = smodel.Reac('Reac3244', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1_s2p_s3p_s4pPP1])
    Reac3244.kcst = 3.3333e6
    Reac3245 = smodel.Reac('Reac3245', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pPP1], rhs =[CaMKII_s1_s2p_s3p_s4p, PP1])
    Reac3245.kcst = 8
    Reac3246 = smodel.Reac('Reac3246', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pPP1], rhs = [CaMKII_s1_s2p_s3p_s4, PP1])
    Reac3246.kcst = 2

    # CaMKII_s1_s2p_s3p_s4p + PP1 <->   CaMKII_s1_s2p_s3pPP1_s4p  -> CaMKII_s1_s2p_s3_s4p  + PP1
    Reac3247 = smodel.Reac('Reac3247', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1_s2p_s3pPP1_s4p])
    Reac3247.kcst = 3.3333e6
    Reac3248 = smodel.Reac('Reac3248', vsys, lhs = [CaMKII_s1_s2p_s3pPP1_s4p], rhs =[CaMKII_s1_s2p_s3p_s4p, PP1])
    Reac3248.kcst = 8
    Reac3249 = smodel.Reac('Reac3249', vsys, lhs = [CaMKII_s1_s2p_s3pPP1_s4p], rhs = [CaMKII_s1_s2p_s3_s4p, PP1])
    Reac3249.kcst = 2
    
    # CaMKII_s1_s2p_s3p_s4p + PP1 <->   CaMKII_s1_s2pPP1_s3p_s4p  -> CaMKII_s1_s2_s3p_s4p  + PP1
    Reac3250 = smodel.Reac('Reac3250', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p, PP1], rhs = [CaMKII_s1_s2pPP1_s3p_s4p])
    Reac3250.kcst = 3.3333e6
    Reac3251 = smodel.Reac('Reac3251', vsys, lhs = [CaMKII_s1_s2pPP1_s3p_s4p], rhs =[CaMKII_s1_s2p_s3p_s4p, PP1])
    Reac3251.kcst = 8
    Reac3252 = smodel.Reac('Reac3252', vsys, lhs = [CaMKII_s1_s2pPP1_s3p_s4p], rhs = [CaMKII_s1_s2_s3p_s4p, PP1])
    Reac3252.kcst = 2
   
    # CaMKII_s1_s2pp_s3p_s4p + PP1 <->   CaMKII_s1_s2pp_s3p_s4pPP1  -> CaMKII_s1_s2pp_s3p_s4  + PP1
    Reac3253 = smodel.Reac('Reac3253', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1_s2pp_s3p_s4pPP1])
    Reac3253.kcst = 3.3333e6
    Reac3254 = smodel.Reac('Reac3254', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pPP1], rhs =[CaMKII_s1_s2pp_s3p_s4p, PP1])
    Reac3254.kcst = 8
    Reac3255 = smodel.Reac('Reac3255', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pPP1], rhs = [CaMKII_s1_s2pp_s3p_s4, PP1])
    Reac3255.kcst = 2
    
    # CaMKII_s1_s2pp_s3p_s4p + PP1 <->   CaMKII_s1_s2pp_s3pPP1_s4p  -> CaMKII_s1_s2pp_s3_s4p  + PP1
    Reac3256 = smodel.Reac('Reac3256', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1_s2pp_s3pPP1_s4p])
    Reac3256.kcst = 3.3333e6
    Reac3257 = smodel.Reac('Reac3257', vsys, lhs = [CaMKII_s1_s2pp_s3pPP1_s4p], rhs =[CaMKII_s1_s2pp_s3p_s4p, PP1])
    Reac3257.kcst = 8
    Reac3258 = smodel.Reac('Reac3258', vsys, lhs = [CaMKII_s1_s2pp_s3pPP1_s4p], rhs = [CaMKII_s1_s2pp_s3_s4p, PP1])
    Reac3258.kcst = 2
    
    # CaMKII_s1_s2pp_s3p_s4p + PP1 <->   CaMKII_s1_s2ppPP1_s3p_s4p  -> CaMKII_s1_s2p_s3p_s4p  + PP1
    Reac3259 = smodel.Reac('Reac3259', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4p, PP1], rhs = [CaMKII_s1_s2ppPP1_s3p_s4p])
    Reac3259.kcst = 3.3333e6
    Reac3260 = smodel.Reac('Reac3260', vsys, lhs = [CaMKII_s1_s2ppPP1_s3p_s4p], rhs =[CaMKII_s1_s2pp_s3p_s4p, PP1])
    Reac3260.kcst = 8
    Reac3261 = smodel.Reac('Reac3261', vsys, lhs = [CaMKII_s1_s2ppPP1_s3p_s4p], rhs = [CaMKII_s1_s2p_s3p_s4p, PP1])
    Reac3261.kcst = 2
    
    # CaMKII_s1_s2pp_s3pp_s4p + PP1 <->   CaMKII_s1_s2pp_s3pp_s4pPP1  -> CaMKII_s1_s2pp_s3pp_s4  + PP1
    Reac3262 = smodel.Reac('Reac3262', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1_s2pp_s3pp_s4pPP1])
    Reac3262.kcst = 3.3333e6
    Reac3263 = smodel.Reac('Reac3263', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4pPP1], rhs =[CaMKII_s1_s2pp_s3pp_s4p, PP1])
    Reac3263.kcst = 8
    Reac3264 = smodel.Reac('Reac3264', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4pPP1], rhs = [CaMKII_s1_s2pp_s3pp_s4, PP1])
    Reac3264.kcst = 2
    
    # CaMKII_s1_s2pp_s3pp_s4p + PP1 <->   CaMKII_s1_s2pp_s3ppPP1_s4p  -> CaMKII_s1_s2pp_s3p_s4p  + PP1
    Reac3265 = smodel.Reac('Reac3265', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1_s2pp_s3ppPP1_s4p])
    Reac3265.kcst = 3.3333e6
    Reac3266 = smodel.Reac('Reac3266', vsys, lhs = [CaMKII_s1_s2pp_s3ppPP1_s4p], rhs =[CaMKII_s1_s2pp_s3pp_s4p, PP1])
    Reac3266.kcst = 8
    Reac3267 = smodel.Reac('Reac3267', vsys, lhs = [CaMKII_s1_s2pp_s3ppPP1_s4p], rhs = [CaMKII_s1_s2pp_s3p_s4p, PP1])
    Reac3267.kcst = 2

    # CaMKII_s1_s2pp_s3pp_s4p + PP1 <->   CaMKII_s1_s2ppPP1_s3pp_s4p  -> CaMKII_s1_s2p_s3pp_s4p  + PP1
    Reac3268 = smodel.Reac('Reac3268', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4p, PP1], rhs = [CaMKII_s1_s2ppPP1_s3pp_s4p])
    Reac3268.kcst = 3.3333e6
    Reac3269 = smodel.Reac('Reac3269', vsys, lhs = [CaMKII_s1_s2ppPP1_s3pp_s4p], rhs =[CaMKII_s1_s2pp_s3pp_s4p, PP1])
    Reac3269.kcst = 8
    Reac3270 = smodel.Reac('Reac3270', vsys, lhs = [CaMKII_s1_s2ppPP1_s3pp_s4p], rhs = [CaMKII_s1_s2p_s3pp_s4p, PP1])
    Reac3270.kcst = 2
   
    # CaMKII_s1_s2p_s3pCaM3Ca_s4p + PP1 <->   CaMKII_s1_s2p_s3pCaM3Ca_s4pPP1  -> CaMKII_s1_s2p_s3pCaM3Ca_s4  + PP1
    Reac3271 = smodel.Reac('Reac3271', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pPP1])
    Reac3271.kcst = 3.3333e6
    Reac3272 = smodel.Reac('Reac3272', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP1])
    Reac3272.kcst = 8
    Reac3273 = smodel.Reac('Reac3273', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4, PP1])
    Reac3273.kcst = 2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4p + PP1 <->   CaMKII_s1_s2p_s3pCaM3CaPP1_s4p  -> CaMKII_s1_s2p_s3CaM3Ca_s4p  + PP1
    Reac3274 = smodel.Reac('Reac3274', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1_s2p_s3pCaM3CaPP1_s4p])
    Reac3274.kcst = 3.3333e6
    Reac3275 = smodel.Reac('Reac3275', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP1])
    Reac3275.kcst = 8
    Reac3276 = smodel.Reac('Reac3276', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1_s2p_s3CaM3Ca_s4p, PP1])
    Reac3276.kcst = 2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4p + PP1 <->   CaMKII_s1_s2pPP1_s3pCaM3Ca_s4p  -> CaMKII_s1_s2_s3pCaM3Ca_s4p  + PP1
    Reac3277 = smodel.Reac('Reac3277', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4p])
    Reac3277.kcst = 3.3333e6
    Reac3278 = smodel.Reac('Reac3278', vsys, lhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4p], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP1])
    Reac3278.kcst = 8
    Reac3279 = smodel.Reac('Reac3279', vsys, lhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4p, PP1])
    Reac3279.kcst = 2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4p + PP1 <->   CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP1  -> CaMKII_s1_s2pp_s3pCaM3Ca_s4  + PP1
    Reac3280 = smodel.Reac('Reac3280', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP1])
    Reac3280.kcst = 3.3333e6
    Reac3281 = smodel.Reac('Reac3281', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP1], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac3281.kcst = 8
    Reac3282 = smodel.Reac('Reac3282', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP1], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4, PP1])
    Reac3282.kcst = 2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4p + PP1 <->   CaMKII_s1_s2pp_s3pCaM3CaPP1_s4p  -> CaMKII_s1_s2pp_s3CaM3Ca_s4p  + PP1
    Reac3283 = smodel.Reac('Reac3283', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1_s2pp_s3pCaM3CaPP1_s4p])
    Reac3283.kcst = 3.3333e6
    Reac3284 = smodel.Reac('Reac3284', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP1_s4p], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac3284.kcst = 8
    Reac3285 = smodel.Reac('Reac3285', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP1_s4p], rhs = [CaMKII_s1_s2pp_s3CaM3Ca_s4p, PP1])
    Reac3285.kcst = 2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4p + PP1 <->   CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4p  -> CaMKII_s1_s2p_s3pCaM3Ca_s4p  + PP1
    Reac3286 = smodel.Reac('Reac3286', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP1], rhs = [CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4p])
    Reac3286.kcst = 3.3333e6
    Reac3287 = smodel.Reac('Reac3287', vsys, lhs = [CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4p], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP1])
    Reac3287.kcst = 8
    Reac3288 = smodel.Reac('Reac3288', vsys, lhs = [CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP1])
    Reac3288.kcst = 2
   
    # CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP1  -> CaMKII_s1_s2pCaM3Ca_s3p_s4CaM3Ca + PP1
    Reac3289 = smodel.Reac('Reac3289', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP1])
    Reac3289.kcst = 3.3333e6
    Reac3290 = smodel.Reac('Reac3290', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP1], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac3290.kcst = 8
    Reac3291 = smodel.Reac('Reac3291', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4CaM3Ca, PP1])
    Reac3291.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pPP1_s4pCaM3Ca  -> CaMKII_s1_s2pCaM3Ca_s3_s4pCaM3Ca  + PP1
    Reac3292 = smodel.Reac('Reac3292', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pPP1_s4pCaM3Ca])
    Reac3292.kcst = 3.3333e6
    Reac3293 = smodel.Reac('Reac3293', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pPP1_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac3293.kcst = 8
    Reac3294 = smodel.Reac('Reac3294', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pPP1_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3_s4pCaM3Ca, PP1])
    Reac3294.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pCaM3CaPP1_s3p_s4pCaM3Ca  -> CaMKII_s1_s2CaM3Ca_s3p_s4pCaM3Ca  + PP1
    Reac3295 = smodel.Reac('Reac3295', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3p_s4pCaM3Ca])
    Reac3295.kcst = 3.3333e6
    Reac3296 = smodel.Reac('Reac3296', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3p_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac3296.kcst = 8
    Reac3297 = smodel.Reac('Reac3297', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac3297.kcst = 2
    
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP1  -> CaMKII_s1_s2pCaM3Ca_s3pp_s4CaM3Ca + PP1
    Reac3298 = smodel.Reac('Reac3298', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP1])
    Reac3298.kcst = 3.3333e6
    Reac3299 = smodel.Reac('Reac3299', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP1], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac3299.kcst = 8
    Reac3300 = smodel.Reac('Reac3300', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4CaM3Ca, PP1])
    Reac3300.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca  -> CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca  + PP1
    Reac3301 = smodel.Reac('Reac3301', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca])
    Reac3301.kcst = 3.3333e6
    Reac3302 = smodel.Reac('Reac3302', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac3302.kcst = 8
    Reac3303 = smodel.Reac('Reac3303', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP1_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP1])
    Reac3303.kcst = 2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pCaM3CaPP1_s3pp_s4pCaM3Ca  -> CaMKII_s1_s2CaM3Ca_s3pp_s4pCaM3Ca  + PP1
    Reac3304 = smodel.Reac('Reac3304', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pCaM3CaPP1_s3pp_s4pCaM3Ca])
    Reac3304.kcst = 3.3333e6
    Reac3305 = smodel.Reac('Reac3305', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac3305.kcst = 8
    Reac3306 = smodel.Reac('Reac3306', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP1_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3pp_s4pCaM3Ca, PP1])
    Reac3306.kcst = 2
    
    
    # CaMKII_s1_s2p_s3pp_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2p_s3pp_s4pCaM3CaPP1  -> CaMKII_s1_s2p_s3pp_s4CaM3Ca  + PP1
    Reac3307 = smodel.Reac('Reac3307', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2p_s3pp_s4pCaM3CaPP1])
    Reac3307.kcst = 3.3333e6
    Reac3308 = smodel.Reac('Reac3308', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3CaPP1], rhs =[CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac3308.kcst = 8
    Reac3309 = smodel.Reac('Reac3309', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3CaPP1], rhs = [CaMKII_s1_s2p_s3pp_s4CaM3Ca, PP1])
    Reac3309.kcst = 2
    
    # CaMKII_s1_s2p_s3pp_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2p_s3ppPP1_s4pCaM3Ca  -> CaMKII_s1_s2p_s3p_s4pCaM3Ca  + PP1
    Reac3310 = smodel.Reac('Reac3310', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2p_s3ppPP1_s4pCaM3Ca])
    Reac3310.kcst = 3.3333e6
    Reac3311 = smodel.Reac('Reac3311', vsys, lhs = [CaMKII_s1_s2p_s3ppPP1_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac3311.kcst = 8
    Reac3312 = smodel.Reac('Reac3312', vsys, lhs = [CaMKII_s1_s2p_s3ppPP1_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca, PP1])
    Reac3312.kcst = 2
    
    # CaMKII_s1_s2p_s3pp_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pPP1_s3pp_s4pCaM3Ca  -> CaMKII_s1_s2_s3pp_s4pCaM3Ca  + PP1
    Reac3313 = smodel.Reac('Reac3313', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pPP1_s3pp_s4pCaM3Ca])
    Reac3313.kcst = 3.3333e6
    Reac3314 = smodel.Reac('Reac3314', vsys, lhs = [CaMKII_s1_s2pPP1_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP1])
    Reac3314.kcst = 8
    Reac3315 = smodel.Reac('Reac3315', vsys, lhs = [CaMKII_s1_s2pPP1_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2_s3pp_s4pCaM3Ca, PP1])
    Reac3315.kcst = 2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP1  -> CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca  + PP1
    Reac3316 = smodel.Reac('Reac3316', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac3316.kcst = 3.3333e6
    Reac3317 = smodel.Reac('Reac3317', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3317.kcst = 8
    Reac3318 = smodel.Reac('Reac3318', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac3318.kcst = 2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2p_s3pCaM3CaPP1_s4pCaM3Ca  -> CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca  + PP1
    Reac3319 = smodel.Reac('Reac3319', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2p_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac3319.kcst = 3.3333e6
    Reac3320 = smodel.Reac('Reac3320', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3320.kcst = 8
    Reac3321 = smodel.Reac('Reac3321', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac3321.kcst = 2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pCaM3Ca  -> CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca  + PP1
    Reac3322 = smodel.Reac('Reac3322', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac3322.kcst = 3.3333e6
    Reac3323 = smodel.Reac('Reac3323', vsys, lhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3323.kcst = 8
    Reac3324 = smodel.Reac('Reac3324', vsys, lhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3324.kcst = 2
    
    # CaMKII_s1_s2pp_s3p_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pp_s3p_s4pCaM3CaPP1  -> CaMKII_s1_s2pp_s3p_s4CaM3Ca  + PP1
    Reac3325 = smodel.Reac('Reac3325', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pp_s3p_s4pCaM3CaPP1])
    Reac3325.kcst = 3.3333e6
    Reac3326 = smodel.Reac('Reac3326', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3CaPP1], rhs =[CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac3326.kcst = 8
    Reac3327 = smodel.Reac('Reac3327', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3CaPP1], rhs = [CaMKII_s1_s2pp_s3p_s4CaM3Ca, PP1])
    Reac3327.kcst = 2

    # CaMKII_s1_s2pp_s3p_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pp_s3pPP1_s4pCaM3Ca  -> CaMKII_s1_s2pp_s3_s4pCaM3Ca  + PP1
    Reac3328 = smodel.Reac('Reac3328', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pp_s3pPP1_s4pCaM3Ca])
    Reac3328.kcst = 3.3333e6
    Reac3329 = smodel.Reac('Reac3329', vsys, lhs = [CaMKII_s1_s2pp_s3pPP1_s4pCaM3Ca], rhs =[CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac3329.kcst = 8
    Reac3330 = smodel.Reac('Reac3330', vsys, lhs = [CaMKII_s1_s2pp_s3pPP1_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3_s4pCaM3Ca, PP1])
    Reac3330.kcst = 2
    
    # CaMKII_s1_s2pp_s3p_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2ppPP1_s3p_s4pCaM3Ca  -> CaMKII_s1_s2p_s3p_s4pCaM3Ca  + PP1
    Reac3331 = smodel.Reac('Reac3331', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2ppPP1_s3p_s4pCaM3Ca])
    Reac3331.kcst = 3.3333e6
    Reac3332 = smodel.Reac('Reac3332', vsys, lhs = [CaMKII_s1_s2ppPP1_s3p_s4pCaM3Ca], rhs =[CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP1])
    Reac3332.kcst = 8
    Reac3333= smodel.Reac('Reac3333', vsys, lhs = [CaMKII_s1_s2ppPP1_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca, PP1])
    Reac3333.kcst = 2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP1  -> CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca  + PP1
    Reac3334 = smodel.Reac('Reac3334', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac3334.kcst = 3.3333e6
    Reac3335 = smodel.Reac('Reac3335', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3335.kcst = 8
    Reac3336 = smodel.Reac('Reac3336', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac3336.kcst = 2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2p_s3pCaM3CaPP1_s4pCaM3Ca  -> CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca  + PP1
    Reac3337 = smodel.Reac('Reac3337', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2p_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac3337.kcst = 3.3333e6
    Reac3338 = smodel.Reac('Reac3338', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3338.kcst = 8
    Reac3339 = smodel.Reac('Reac3339', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac3339.kcst = 2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pCaM3Ca  -> CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca  + PP1
    Reac3340 = smodel.Reac('Reac3340', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac3340.kcst = 3.3333e6
    Reac3341 = smodel.Reac('Reac3341', vsys, lhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3341.kcst = 8
    Reac3342 = smodel.Reac('Reac3342', vsys, lhs = [CaMKII_s1_s2pPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3342.kcst = 2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP1  -> CaMKII_s1_s2pp_s3pCaM3Ca_s4CaM3Ca  + PP1
    Reac3343 = smodel.Reac('Reac3343', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP1])
    Reac3343.kcst = 3.3333e6
    Reac3344 = smodel.Reac('Reac3344', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP1], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3344.kcst = 8
    Reac3345 = smodel.Reac('Reac3345', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP1], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4CaM3Ca, PP1])
    Reac3345.kcst = 2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pCaM3Ca  -> CaMKII_s1_s2pp_s3CaM3Ca_s4pCaM3Ca  + PP1
    Reac3346 = smodel.Reac('Reac3346', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pCaM3Ca])
    Reac3346.kcst = 3.3333e6
    Reac3347 = smodel.Reac('Reac3347', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pCaM3Ca], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3347.kcst = 8
    Reac3348 = smodel.Reac('Reac3348', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP1_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3CaM3Ca_s4pCaM3Ca, PP1])
    Reac3348.kcst = 2

    # CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP1 <->   CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca  -> CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca  + PP1
    Reac3349 = smodel.Reac('Reac3349', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1], rhs = [CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca])
    Reac3349.kcst = 3.3333e6
    Reac3350 = smodel.Reac('Reac3350', vsys, lhs = [CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3350.kcst = 8
    Reac3351 = smodel.Reac('Reac3351', vsys, lhs = [CaMKII_s1_s2ppPP1_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP1])
    Reac3351.kcst = 2
    
    ####dephosphorylation by PP2A
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A  -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca + PP2A
    Reac3352 = smodel.Reac('Reac3352', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac3352.kcst = 0.2e6
    Reac3353 = smodel.Reac('Reac3353', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3353.kcst = 0.8
    Reac3354 = smodel.Reac('Reac3354', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac3354.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca  -> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca + PP2A
    Reac3355 = smodel.Reac('Reac3355', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac3355.kcst = 0.2e6
    Reac3356 = smodel.Reac('Reac3356', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3356.kcst = 0.8
    Reac3357 = smodel.Reac('Reac3357', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac3357.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca  -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca + PP2A
    Reac3358 = smodel.Reac('Reac3358', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac3358.kcst = 0.2e6
    Reac3359 = smodel.Reac('Reac3359', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3359.kcst = 0.8
    Reac3360 = smodel.Reac('Reac3360', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3360.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A  -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4 + PP2A
    Reac3361 = smodel.Reac('Reac3361', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A])
    Reac3361.kcst = 0.2e6
    Reac3362 = smodel.Reac('Reac3362', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac3362.kcst = 0.8
    Reac3363 = smodel.Reac('Reac3363', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4, PP2A])
    Reac3363.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4p  -> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4p + PP2A
    Reac3364 = smodel.Reac('Reac3364', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4p])
    Reac3364.kcst = 0.2e6
    Reac3365 = smodel.Reac('Reac3365', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac3365.kcst = 0.8
    Reac3366 = smodel.Reac('Reac3366', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4p, PP2A])
    Reac3366.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A <->   CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4p  -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4p + PP2A
    Reac3367 = smodel.Reac('Reac3367', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4p])
    Reac3367.kcst = 0.2e6
    Reac3368 = smodel.Reac('Reac3368', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac3368.kcst = 0.8
    Reac3369 = smodel.Reac('Reac3369', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac3369.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A  -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p + PP2A
    Reac3370 = smodel.Reac('Reac3370', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A])
    Reac3370.kcst = 0.2e6
    Reac3371 = smodel.Reac('Reac3371', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac3371.kcst = 0.8
    Reac3372 = smodel.Reac('Reac3372', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac3372.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp  -> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp + PP2A
    Reac3373 = smodel.Reac('Reac3373', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp])
    Reac3373.kcst = 0.2e6
    Reac3374 = smodel.Reac('Reac3374', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac3374.kcst = 0.8
    Reac3375 = smodel.Reac('Reac3375', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp, PP2A])
    Reac3375.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <->   CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp  -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp + PP2A
    Reac3376 = smodel.Reac('Reac3376', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp])
    Reac3376.kcst = 0.2e6
    Reac3377 = smodel.Reac('Reac3377', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac3377.kcst = 0.8
    Reac3378 = smodel.Reac('Reac3378', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac3378.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A  -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p  + PP2A
    Reac3379 = smodel.Reac('Reac3379', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A])
    Reac3379.kcst = 0.2e6
    Reac3380 = smodel.Reac('Reac3380', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac3380.kcst = 0.8
    Reac3381 = smodel.Reac('Reac3381', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p, PP2A])
    Reac3381.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp  -> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp  + PP2A
    Reac3382 = smodel.Reac('Reac3382', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp])
    Reac3382.kcst = 0.2e6
    Reac3383 = smodel.Reac('Reac3383', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac3383.kcst = 0.8
    Reac3384 = smodel.Reac('Reac3384', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp, PP2A])
    Reac3384.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp + PP2A <->   CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp  -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp  + PP2A
    Reac3385 = smodel.Reac('Reac3385', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp])
    Reac3385.kcst = 0.2e6
    Reac3386 = smodel.Reac('Reac3386', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac3386.kcst = 0.8
    Reac3387 = smodel.Reac('Reac3387', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp, PP2A])
    Reac3387.kcst = 0.2
   
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pp + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP2A  -> CaMKII_s1_s2pCaM3Ca_s3pp_s4p  + PP2A
    Reac3388 = smodel.Reac('Reac3388', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP2A])
    Reac3388.kcst = 0.2e6
    Reac3389 = smodel.Reac('Reac3389', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP2A], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac3389.kcst = 0.8
    Reac3390 = smodel.Reac('Reac3390', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4ppPP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac3390.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pp + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pp  -> CaMKII_s1_s2pCaM3Ca_s3p_s4pp  + PP2A
    Reac3391 = smodel.Reac('Reac3391', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pp])
    Reac3391.kcst = 0.2e6
    Reac3392 = smodel.Reac('Reac3392', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac3392.kcst = 0.8
    Reac3393 = smodel.Reac('Reac3393', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pp], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pp, PP2A])
    Reac3393.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pp + PP2A <->   CaMKII_s1_s2pCaM3CaPP2A_s3p_s4pp  -> CaMKII_s1_s2CaM3Ca_s3p_s4pp  + PP2A
    Reac3394 = smodel.Reac('Reac3394', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4pp])
    Reac3394.kcst = 0.2e6
    Reac3395 = smodel.Reac('Reac3395', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4pp], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pp, PP2A])
    Reac3395.kcst = 0.8
    Reac3396 = smodel.Reac('Reac3396', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4pp], rhs = [CaMKII_s1_s2CaM3Ca_s3pp_s4pp, PP2A])
    Reac3396.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pp_s4pp + PP2A <->   CaMKII_s1_s2p_s3pp_s4ppPP2A  -> CaMKII_s1_s2p_s3pp_s4p  + PP2A
    Reac3397 = smodel.Reac('Reac3397', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp, PP2A], rhs = [CaMKII_s1_s2p_s3pp_s4ppPP2A])
    Reac3397.kcst = 0.2e6
    Reac3398 = smodel.Reac('Reac3398', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4ppPP2A], rhs =[CaMKII_s1_s2p_s3pp_s4pp, PP2A])
    Reac3398.kcst = 0.8
    Reac3399 = smodel.Reac('Reac3399', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4ppPP2A], rhs = [CaMKII_s1_s2p_s3pp_s4p, PP2A])
    Reac3399.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pp_s4pp + PP2A <->   CaMKII_s1_s2p_s3ppPP2A_s4pp  -> CaMKII_s1_s2p_s3p_s4pp  + PP2A
    Reac3400 = smodel.Reac('Reac3400', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp, PP2A], rhs = [CaMKII_s1_s2p_s3ppPP2A_s4pp])
    Reac3400.kcst = 0.2e6
    Reac3401 = smodel.Reac('Reac3401', vsys, lhs = [CaMKII_s1_s2p_s3ppPP2A_s4pp], rhs =[CaMKII_s1_s2p_s3pp_s4pp, PP2A])
    Reac3401.kcst = 0.8
    Reac3402 = smodel.Reac('Reac3402', vsys, lhs = [CaMKII_s1_s2p_s3ppPP2A_s4pp], rhs = [CaMKII_s1_s2p_s3p_s4pp, PP2A])
    Reac3402.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pp_s4pp + PP2A <->   CaMKII_s1_s2pPP2A_s3pp_s4pp  -> CaMKII_s1_s2_s3pp_s4pp  + PP2A
    Reac3403 = smodel.Reac('Reac3403', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pp, PP2A], rhs = [CaMKII_s1_s2pPP2A_s3pp_s4pp])
    Reac3403.kcst = 0.2e6
    Reac3404 = smodel.Reac('Reac3404', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pp_s4pp], rhs =[CaMKII_s1_s2p_s3pp_s4pp, PP2A])
    Reac3404.kcst = 0.8
    Reac3405 = smodel.Reac('Reac3405', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pp_s4pp], rhs = [CaMKII_s1_s2_s3pp_s4pp, PP2A])
    Reac3405.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pp_s4pp + PP2A <->   CaMKII_s1_s2pp_s3pp_s4ppPP2A  -> CaMKII_s1_s2pp_s3pp_s4p  + PP2A
    Reac3406 = smodel.Reac('Reac3406', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1_s2pp_s3pp_s4ppPP2A])
    Reac3406.kcst = 0.2e6
    Reac3407 = smodel.Reac('Reac3407', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4ppPP2A], rhs =[CaMKII_s1_s2pp_s3pp_s4pp, PP2A])
    Reac3407.kcst = 0.8
    Reac3408 = smodel.Reac('Reac3408', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4ppPP2A], rhs = [CaMKII_s1_s2pp_s3pp_s4p, PP2A])
    Reac3408.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pp_s4pp + PP2A <->   CaMKII_s1_s2pp_s3ppPP2A_s4pp  -> CaMKII_s1_s2pp_s3p_s4pp  + PP2A
    Reac3409 = smodel.Reac('Reac3409', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1_s2pp_s3ppPP2A_s4pp])
    Reac3409.kcst = 0.2e6
    Reac3410 = smodel.Reac('Reac3410', vsys, lhs = [CaMKII_s1_s2pp_s3ppPP2A_s4pp], rhs =[CaMKII_s1_s2pp_s3pp_s4pp, PP2A])
    Reac3410.kcst = 0.8
    Reac3411 = smodel.Reac('Reac3411', vsys, lhs = [CaMKII_s1_s2pp_s3ppPP2A_s4pp], rhs = [CaMKII_s1_s2pp_s3p_s4pp, PP2A])
    Reac3411.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pp_s4pp + PP2A <->   CaMKII_s1_s2ppPP2A_s3pp_s4pp  -> CaMKII_s1_s2p_s3pp_s4pp  + PP2A
    Reac3412 = smodel.Reac('Reac3412', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4pp, PP2A], rhs = [CaMKII_s1_s2ppPP2A_s3pp_s4pp])
    Reac3412.kcst = 0.2e6
    Reac3413 = smodel.Reac('Reac3413', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3pp_s4pp], rhs =[CaMKII_s1_s2pp_s3pp_s4pp, PP2A])
    Reac3413.kcst = 0.8
    Reac3414 = smodel.Reac('Reac3414', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3pp_s4pp], rhs = [CaMKII_s1_s2p_s3pp_s4pp, PP2A])
    Reac3414.kcst = 0.2
   
    # CaMKII_s1_s2p_s3p_s4pp + PP2A <->   CaMKII_s1_s2p_s3p_s4ppPP2A  -> CaMKII_s1_s2p_s3p_s4p  + PP2A
    Reac3415 = smodel.Reac('Reac3415', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1_s2p_s3p_s4ppPP2A])
    Reac3415.kcst = 0.2e6
    Reac3416 = smodel.Reac('Reac3416', vsys, lhs = [CaMKII_s1_s2p_s3p_s4ppPP2A], rhs =[CaMKII_s1_s2p_s3p_s4pp, PP2A])
    Reac3416.kcst = 0.8
    Reac3417 = smodel.Reac('Reac3417', vsys, lhs = [CaMKII_s1_s2p_s3p_s4ppPP2A], rhs = [CaMKII_s1_s2p_s3p_s4p, PP2A])
    Reac3417.kcst = 0.2
    
    # CaMKII_s1_s2p_s3p_s4pp + PP2A <->   CaMKII_s1_s2p_s3pPP2A_s4pp  -> CaMKII_s1_s2p_s3_s4pp  + PP2A
    Reac3418 = smodel.Reac('Reac3418', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1_s2p_s3pPP2A_s4pp])
    Reac3418.kcst = 0.2e6
    Reac3419 = smodel.Reac('Reac3419', vsys, lhs = [CaMKII_s1_s2p_s3pPP2A_s4pp], rhs =[CaMKII_s1_s2p_s3p_s4pp, PP2A])
    Reac3419.kcst = 0.8
    Reac3420 = smodel.Reac('Reac3420', vsys, lhs = [CaMKII_s1_s2p_s3pPP2A_s4pp], rhs = [CaMKII_s1_s2p_s3_s4pp, PP2A])
    Reac3420.kcst = 0.2
    
    # CaMKII_s1_s2p_s3p_s4pp + PP2A <->   CaMKII_s1_s2pPP2A_s3p_s4pp  -> CaMKII_s1_s2_s3p_s4pp  + PP2A
    Reac3421 = smodel.Reac('Reac3421', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pp, PP2A], rhs = [CaMKII_s1_s2pPP2A_s3p_s4pp])
    Reac3421.kcst = 0.2e6
    Reac3422 = smodel.Reac('Reac3422', vsys, lhs = [CaMKII_s1_s2pPP2A_s3p_s4pp], rhs =[CaMKII_s1_s2p_s3p_s4pp, PP2A])
    Reac3422.kcst = 0.8
    Reac3423 = smodel.Reac('Reac3423', vsys, lhs = [CaMKII_s1_s2pPP2A_s3p_s4pp], rhs = [CaMKII_s1_s2_s3p_s4pp, PP2A])
    Reac3423.kcst = 0.2
    
    
    # CaMKII_s1_s2pp_s3p_s4pp + PP2A <->   CaMKII_s1_s2pp_s3p_s4ppPP2A  -> CaMKII_s1_s2pp_s3p_s4p  + PP2A
    Reac3424 = smodel.Reac('Reac3424', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1_s2pp_s3p_s4ppPP2A])
    Reac3424.kcst = 0.2e6
    Reac3425 = smodel.Reac('Reac3425', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4ppPP2A], rhs =[CaMKII_s1_s2pp_s3p_s4pp, PP2A])
    Reac3425.kcst = 0.8
    Reac3426 = smodel.Reac('Reac3426', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4ppPP2A], rhs = [CaMKII_s1_s2pp_s3p_s4p, PP2A])
    Reac3426.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3p_s4pp + PP2A <->   CaMKII_s1_s2pp_s3pPP2A_s4pp  -> CaMKII_s1_s2pp_s3_s4pp  + PP2A
    Reac3427 = smodel.Reac('Reac3427', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1_s2pp_s3pPP2A_s4pp])
    Reac3427.kcst = 0.2e6
    Reac3428 = smodel.Reac('Reac3428', vsys, lhs = [CaMKII_s1_s2pp_s3pPP2A_s4pp], rhs =[CaMKII_s1_s2pp_s3p_s4pp, PP2A])
    Reac3428.kcst = 0.8
    Reac3429 = smodel.Reac('Reac3429', vsys, lhs = [CaMKII_s1_s2pp_s3pPP2A_s4pp], rhs = [CaMKII_s1_s2pp_s3_s4pp, PP2A])
    Reac3429.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3p_s4pp + PP2A <->   CaMKII_s1_s2ppPP2A_s3p_s4pp  -> CaMKII_s1_s2p_s3p_s4pp  + PP2A
    Reac3430 = smodel.Reac('Reac3430', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pp, PP2A], rhs = [CaMKII_s1_s2ppPP2A_s3p_s4pp])
    Reac3430.kcst = 0.2e6
    Reac3431 = smodel.Reac('Reac3431', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3p_s4pp], rhs =[CaMKII_s1_s2pp_s3p_s4pp, PP2A])
    Reac3431.kcst = 0.8
    Reac3432 = smodel.Reac('Reac3432', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3p_s4pp], rhs = [CaMKII_s1_s2p_s3p_s4pp, PP2A])
    Reac3432.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pp + PP2A <->   CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP2A  -> CaMKII_s1_s2p_s3pCaM3Ca_s4p  + PP2A
    Reac3433 = smodel.Reac('Reac3433', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP2A])
    Reac3433.kcst = 0.2e6
    Reac3434 = smodel.Reac('Reac3434', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac3434.kcst = 0.8
    Reac3435 = smodel.Reac('Reac3435', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac3435.kcst = 0.2
    
    
    # CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pp + PP2A <->   CaMKII_s1_s2p_s3pCaM3Ca_s4pp  -> CaMKII_s1_s2p_s3CaM3Ca_s4pp  + PP2A
    Reac3436 = smodel.Reac('Reac3436', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pp, PP2A], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp])
    Reac3436.kcst = 0.2e6
    Reac3437 = smodel.Reac('Reac3437', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pp, PP2A])
    Reac3437.kcst = 0.8
    Reac3438 = smodel.Reac('Reac3438', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2p_s3CaM3Ca_s4pp, PP2A])
    Reac3438.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pp + PP2A <->   CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pp  -> CaMKII_s1_s2_s3pCaM3Ca_s4pp  + PP2A
    Reac3439 = smodel.Reac('Reac3439', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pp])
    Reac3439.kcst = 0.2e6
    Reac3440 = smodel.Reac('Reac3440', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac3440.kcst = 0.8
    Reac3441 = smodel.Reac('Reac3441', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pp, PP2A])
    Reac3441.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4pp + PP2A <->   CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP2A  -> CaMKII_s1_s2pp_s3pCaM3Ca_s4p  + PP2A
    Reac3442 = smodel.Reac('Reac3442', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP2A])
    Reac3442.kcst = 0.2e6
    Reac3443 = smodel.Reac('Reac3443', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP2A], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac3443.kcst = 0.8
    Reac3444 = smodel.Reac('Reac3444', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4ppPP2A], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac3444.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4pp + PP2A <->   CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pp  -> CaMKII_s1_s2p_s3CaM3Ca_s4pp  + PP2A
    Reac3445 = smodel.Reac('Reac3445', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4pp])
    Reac3445.kcst = 0.2e6
    Reac3446 = smodel.Reac('Reac3446', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4pp], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac3446.kcst = 0.8
    Reac3447 = smodel.Reac('Reac3447', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4pp], rhs = [CaMKII_s1_s2pp_s3CaM3Ca_s4pp, PP2A])
    Reac3447.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4pp + PP2A <->   CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pp  -> CaMKII_s1_s2p_s3pCaM3Ca_s4pp  + PP2A
    Reac3448 = smodel.Reac('Reac3448', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP2A], rhs = [CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pp])
    Reac3448.kcst = 0.2e6
    Reac3449 = smodel.Reac('Reac3449', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pp], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pp, PP2A])
    Reac3449.kcst = 0.8
    Reac3450 = smodel.Reac('Reac3450', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pp], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pp, PP2A])
    Reac3450.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4p + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3p_s4pPP2A  -> CaMKII_s1_s2pCaM3Ca_s3p_s4  + PP2A
    Reac3451 = smodel.Reac('Reac3451', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pPP2A])
    Reac3451.kcst = 0.2e6
    Reac3452 = smodel.Reac('Reac3452', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pPP2A], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac3452.kcst = 0.8
    Reac3453 = smodel.Reac('Reac3453', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pPP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4, PP2A])
    Reac3453.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4p + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4p  -> CaMKII_s1_s2pCaM3Ca_s3_s4p  + PP2A
    Reac3454 = smodel.Reac('Reac3454', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4p])
    Reac3454.kcst = 0.2e6
    Reac3455 = smodel.Reac('Reac3455', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac3455.kcst = 0.8
    Reac3456 = smodel.Reac('Reac3456', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3_s4p, PP2A])
    Reac3456.kcst = 0.2

    # CaMKII_s1_s2pCaM3Ca_s3p_s4p + PP2A <->   CaMKII_s1_s2pCaM3CaPP2A_s3p_s4p  -> CaMKII_s1_s2CaM3Ca_s3p_s4p  + PP2A
    Reac3457 = smodel.Reac('Reac3457', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3p_s4p])
    Reac3457.kcst = 0.2e6
    Reac3458 = smodel.Reac('Reac3458', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3p_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac3458.kcst = 0.8
    Reac3459 = smodel.Reac('Reac3459', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3p_s4p], rhs = [CaMKII_s1_s2CaM3Ca_s3p_s4p, PP2A])
    Reac3459.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4p + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP2A  -> CaMKII_s1_s2pCaM3Ca_s3pp_s4  + PP2A
    Reac3460 = smodel.Reac('Reac3460', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP2A])
    Reac3460.kcst = 0.2e6
    Reac3461 = smodel.Reac('Reac3461', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP2A], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac3461.kcst = 0.8
    Reac3462 = smodel.Reac('Reac3462', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pPP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4, PP2A])
    Reac3462.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4p + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4p  -> CaMKII_s1_s2pCaM3Ca_s3p_s4p  + PP2A
    Reac3463 = smodel.Reac('Reac3463', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4p])
    Reac3463.kcst = 0.2e6
    Reac3464 = smodel.Reac('Reac3464', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac3464.kcst = 0.8
    Reac3465 = smodel.Reac('Reac3465', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4p], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4p, PP2A])
    Reac3465.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4p + PP2A <->   CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4p  -> CaMKII_s1_s2CaM3Ca_s3pp_s4p  + PP2A
    Reac3466 = smodel.Reac('Reac3466', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4p])
    Reac3466.kcst = 0.2e6
    Reac3467 = smodel.Reac('Reac3467', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4p], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4p, PP2A])
    Reac3467.kcst = 0.8
    Reac3468 = smodel.Reac('Reac3468', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4p], rhs = [CaMKII_s1_s2CaM3Ca_s3pp_s4p, PP2A])
    Reac3468.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pp_s4p + PP2A <->   CaMKII_s1_s2p_s3pp_s4pPP2A  -> CaMKII_s1_s2p_s3pp_s4  + PP2A
    Reac3469 = smodel.Reac('Reac3469', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1_s2p_s3pp_s4pPP2A])
    Reac3469.kcst = 0.2e6
    Reac3470 = smodel.Reac('Reac3470', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pPP2A], rhs =[CaMKII_s1_s2p_s3pp_s4p, PP2A])
    Reac3470.kcst = 0.8
    Reac3471 = smodel.Reac('Reac3471', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pPP2A], rhs = [CaMKII_s1_s2p_s3pp_s4, PP2A])
    Reac3471.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pp_s4p + PP2A <->   CaMKII_s1_s2p_s3ppPP2A_s4p  -> CaMKII_s1_s2p_s3p_s4p  + PP2A
    Reac3472 = smodel.Reac('Reac3472', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1_s2p_s3ppPP2A_s4p])
    Reac3472.kcst = 0.2e6
    Reac3473 = smodel.Reac('Reac3473', vsys, lhs = [CaMKII_s1_s2p_s3ppPP2A_s4p], rhs =[CaMKII_s1_s2p_s3pp_s4p, PP2A])
    Reac3473.kcst = 0.8
    Reac3474 = smodel.Reac('Reac3474', vsys, lhs = [CaMKII_s1_s2p_s3ppPP2A_s4p], rhs = [CaMKII_s1_s2p_s3p_s4p, PP2A])
    Reac3474.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pp_s4p + PP2A <->   CaMKII_s1_s2pPP2A_s3pp_s4p  -> CaMKII_s1_s2_s3pp_s4p  + PP2A
    Reac3475 = smodel.Reac('Reac3475', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4p, PP2A], rhs = [CaMKII_s1_s2pPP2A_s3pp_s4p])
    Reac3475.kcst = 0.2e6
    Reac3476 = smodel.Reac('Reac3476', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pp_s4p], rhs =[CaMKII_s1_s2p_s3pp_s4p, PP2A])
    Reac3476.kcst = 0.8
    Reac3477 = smodel.Reac('Reac3477', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pp_s4p], rhs = [CaMKII_s1_s2_s3pp_s4p, PP2A])
    Reac3477.kcst = 0.2
    
    # CaMKII_s1_s2p_s3p_s4p + PP2A <->   CaMKII_s1_s2p_s3p_s4pPP2A  -> CaMKII_s1_s2p_s3p_s4  + PP2A
    Reac3478 = smodel.Reac('Reac3478', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1_s2p_s3p_s4pPP2A])
    Reac3478.kcst = 0.2e6
    Reac3479 = smodel.Reac('Reac3479', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pPP2A], rhs =[CaMKII_s1_s2p_s3p_s4p, PP2A])
    Reac3479.kcst = 0.8
    Reac3480 = smodel.Reac('Reac3480', vsys, lhs = [CaMKII_s1_s2p_s3p_s4pPP2A], rhs = [CaMKII_s1_s2p_s3p_s4, PP2A])
    Reac3480.kcst = 0.2
    
    # CaMKII_s1_s2p_s3p_s4p + PP2A <->   CaMKII_s1_s2p_s3pPP2A_s4p  -> CaMKII_s1_s2p_s3_s4p  + PP2A
    Reac3481 = smodel.Reac('Reac3481', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1_s2p_s3pPP2A_s4p])
    Reac3481.kcst = 0.2e6
    Reac3482= smodel.Reac('Reac3482', vsys, lhs = [CaMKII_s1_s2p_s3pPP2A_s4p], rhs =[CaMKII_s1_s2p_s3p_s4p, PP2A])
    Reac3482.kcst = 0.8
    Reac3483 = smodel.Reac('Reac3483', vsys, lhs = [CaMKII_s1_s2p_s3pPP2A_s4p], rhs = [CaMKII_s1_s2p_s3_s4p, PP2A])
    Reac3483.kcst = 0.2

    # CaMKII_s1_s2p_s3p_s4p + PP2A <->   CaMKII_s1_s2pPP2A_s3p_s4p  -> CaMKII_s1_s2_s3p_s4p  + PP2A
    Reac3484 = smodel.Reac('Reac3484', vsys, lhs = [CaMKII_s1_s2p_s3p_s4p, PP2A], rhs = [CaMKII_s1_s2pPP2A_s3p_s4p])
    Reac3484.kcst = 0.2e6
    Reac3485 = smodel.Reac('Reac3485', vsys, lhs = [CaMKII_s1_s2pPP2A_s3p_s4p], rhs =[CaMKII_s1_s2p_s3p_s4p, PP2A])
    Reac3485.kcst = 0.8
    Reac3486 = smodel.Reac('Reac3486', vsys, lhs = [CaMKII_s1_s2pPP2A_s3p_s4p], rhs = [CaMKII_s1_s2_s3p_s4p, PP2A])
    Reac3486.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3p_s4p + PP2A <->   CaMKII_s1_s2pp_s3p_s4pPP2A  -> CaMKII_s1_s2pp_s3p_s4  + PP2A
    Reac3487 = smodel.Reac('Reac3487', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1_s2pp_s3p_s4pPP2A])
    Reac3487.kcst = 0.2e6
    Reac3488 = smodel.Reac('Reac3488', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pPP2A], rhs =[CaMKII_s1_s2pp_s3p_s4p, PP2A])
    Reac3488.kcst = 0.8
    Reac3489 = smodel.Reac('Reac3489', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pPP2A], rhs = [CaMKII_s1_s2pp_s3p_s4, PP2A])
    Reac3489.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3p_s4p + PP2A <->   CaMKII_s1_s2pp_s3pPP2A_s4p  -> CaMKII_s1_s2pp_s3_s4p  + PP2A
    Reac3490 = smodel.Reac('Reac3490', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1_s2pp_s3pPP2A_s4p])
    Reac3490.kcst = 0.2e6
    Reac3491 = smodel.Reac('Reac3491', vsys, lhs = [CaMKII_s1_s2pp_s3pPP2A_s4p], rhs =[CaMKII_s1_s2pp_s3p_s4p, PP2A])
    Reac3491.kcst = 0.8
    Reac3492 = smodel.Reac('Reac3492', vsys, lhs = [CaMKII_s1_s2pp_s3pPP2A_s4p], rhs = [CaMKII_s1_s2pp_s3_s4p, PP2A])
    Reac3492.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3p_s4p + PP2A <->   CaMKII_s1_s2ppPP2A_s3p_s4p  -> CaMKII_s1_s2p_s3p_s4p  + PP2A
    Reac3493 = smodel.Reac('Reac3493', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4p, PP2A], rhs = [CaMKII_s1_s2ppPP2A_s3p_s4p])
    Reac3493.kcst = 0.2e6
    Reac3494 = smodel.Reac('Reac3494', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3p_s4p], rhs =[CaMKII_s1_s2pp_s3p_s4p, PP2A])
    Reac3494.kcst = 0.8
    Reac3495 = smodel.Reac('Reac3495', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3p_s4p], rhs = [CaMKII_s1_s2p_s3p_s4p, PP2A])
    Reac3495.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pp_s4p + PP2A <->   CaMKII_s1_s2pp_s3pp_s4pPP2A  -> CaMKII_s1_s2pp_s3pp_s4  + PP2A
    Reac3496 = smodel.Reac('Reac3496', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1_s2pp_s3pp_s4pPP2A])
    Reac3496.kcst = 0.2e6
    Reac3497 = smodel.Reac('Reac3497', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4pPP2A], rhs =[CaMKII_s1_s2pp_s3pp_s4p, PP2A])
    Reac3497.kcst = 0.8
    Reac3498 = smodel.Reac('Reac3498', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4pPP2A], rhs = [CaMKII_s1_s2pp_s3pp_s4, PP2A])
    Reac3498.kcst = 0.2
    
    # CaMKI_s1_s2pp_s3pp_s4p + PP2A <->   CaMKII_s1_s2pp_s3ppPP2A_s4p  -> CaMKII_s1_s2pp_s3p_s4p  + PP2A
    Reac3499 = smodel.Reac('Reac3499', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1_s2pp_s3ppPP2A_s4p])
    Reac3499.kcst = 0.2e6
    Reac3500 = smodel.Reac('Reac3500', vsys, lhs = [CaMKII_s1_s2pp_s3ppPP2A_s4p], rhs =[CaMKII_s1_s2pp_s3pp_s4p, PP2A])
    Reac3500.kcst = 0.8
    Reac3501 = smodel.Reac('Reac3501', vsys, lhs = [CaMKII_s1_s2pp_s3ppPP2A_s4p], rhs = [CaMKII_s1_s2pp_s3p_s4p, PP2A])
    Reac3501.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pp_s4p + PP2A <->   CaMKII_s1_s2ppPP2A_s3pp_s4p  -> CaMKII_s1_s2p_s3pp_s4p  + PP2A
    Reac3502 = smodel.Reac('Reac3502', vsys, lhs = [CaMKII_s1_s2pp_s3pp_s4p, PP2A], rhs = [CaMKII_s1_s2ppPP2A_s3pp_s4p])
    Reac3502.kcst = 0.2e6
    Reac3503 = smodel.Reac('Reac3503', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3pp_s4p], rhs =[CaMKII_s1_s2pp_s3pp_s4p, PP2A])
    Reac3503.kcst = 0.8
    Reac3504 = smodel.Reac('Reac3504', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3pp_s4p], rhs = [CaMKII_s1_s2p_s3pp_s4p, PP2A])
    Reac3504.kcst = 0.2

    # CaMKII_s1_s2p_s3pCaM3Ca_s4p + PP2A <->   CaMKII_s1_s2p_s3pCaM3Ca_s4pPP2A  -> CaMKII_s1_s2p_s3pCaM3Ca_s4  + PP2A
    Reac3505 = smodel.Reac('Reac3505', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pPP2A])
    Reac3505.kcst = 0.2e6
    Reac3506 = smodel.Reac('Reac3506', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac3506.kcst = 0.8
    Reac3507 = smodel.Reac('Reac3507', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4, PP2A])
    Reac3507.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4p + PP2A <->   CaMKII_s1_s2p_s3pCaM3CaPP2A_s4p  -> CaMKII_s1_s2p_s3CaM3Ca_s4p  + PP2A
    Reac3508 = smodel.Reac('Reac3508', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1_s2p_s3pCaM3CaPP2A_s4p])
    Reac3508.kcst = 0.2e6
    Reac3509 = smodel.Reac('Reac3509', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac3509.kcst = 0.8
    Reac3510 = smodel.Reac('Reac3510', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1_s2p_s3CaM3Ca_s4p, PP2A])
    Reac3510.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4p + PP2A <->   CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4p  -> CaMKII_s1_s2_s3pCaM3Ca_s4p  + PP2A
    Reac3511 = smodel.Reac('Reac3511', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4p])
    Reac3511.kcst = 0.2e6
    Reac3512 = smodel.Reac('Reac3512', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4p], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac3512.kcst = 0.8
    Reac3513 = smodel.Reac('Reac3513', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4p, PP2A])
    Reac3513.kcst = 0.2
  
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4p + PP2A <->   CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP2A  -> CaMKII_s1_s2pp_s3pCaM3Ca_s4  + PP2A
    Reac3514 = smodel.Reac('Reac3514', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP2A])
    Reac3514.kcst = 0.2e6
    Reac3515 = smodel.Reac('Reac3515', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP2A], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac3515.kcst = 0.8
    Reac3516 = smodel.Reac('Reac3516', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pPP2A], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4, PP2A])
    Reac3516.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4p + PP2A <->   CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4p  -> CaMKII_s1_s2pp_s3CaM3Ca_s4p  + PP2A
    Reac3517 = smodel.Reac('Reac3517', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4p])
    Reac3517.kcst = 0.2e6
    Reac3518 = smodel.Reac('Reac3518', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4p], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac3518.kcst = 0.8
    Reac3519 = smodel.Reac('Reac3519', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4p], rhs = [CaMKII_s1_s2pp_s3CaM3Ca_s4p, PP2A])
    Reac3519.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4p + PP2A <->   CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4p  -> CaMKII_s1_s2p_s3pCaM3Ca_s4p  + PP2A
    Reac3520 = smodel.Reac('Reac3520', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP2A], rhs = [CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4p])
    Reac3520.kcst = 0.2e6
    Reac3521 = smodel.Reac('Reac3521', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4p], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4p, PP2A])
    Reac3521.kcst = 0.8
    Reac3522 = smodel.Reac('Reac3522', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4p], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4p, PP2A])
    Reac3522.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP2A  -> CaMKII_s1_s2pCaM3Ca_s3p_s4CaM3Ca + PP2A
    Reac3523 = smodel.Reac('Reac3523', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP2A])
    Reac3523.kcst = 0.2e6
    Reac3524 = smodel.Reac('Reac3524', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP2A], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac3524.kcst = 0.8
    Reac3525 = smodel.Reac('Reac3525', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3CaPP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4CaM3Ca, PP2A])
    Reac3525.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca  -> CaMKII_s1_s2pCaM3Ca_s3_s4pCaM3Ca  + PP2A
    Reac3526 = smodel.Reac('Reac3526', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca])
    Reac3526.kcst = 0.2e6
    Reac3527 = smodel.Reac('Reac3527', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac3527.kcst = 0.8
    Reac3528 = smodel.Reac('Reac3528', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pPP2A_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3_s4pCaM3Ca, PP2A])
    Reac3528.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pCaM3CaPP2A_s3p_s4pCaM3Ca  -> CaMKII_s1_s2CaM3Ca_s3p_s4pCaM3Ca  + PP2A
    Reac3529 = smodel.Reac('Reac3529', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3p_s4pCaM3Ca])
    Reac3529.kcst = 0.2e6
    Reac3530 = smodel.Reac('Reac3530', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3p_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac3530.kcst = 0.8
    Reac3531 = smodel.Reac('Reac3531', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac3531.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A  -> CaMKII_s1_s2pCaM3Ca_s3pp_s4CaM3Ca + PP2A
    Reac3532 = smodel.Reac('Reac3532', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A])
    Reac3532.kcst = 0.2e6
    Reac3533 = smodel.Reac('Reac3533', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac3533.kcst = 0.8
    Reac3534 = smodel.Reac('Reac3534', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3CaPP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4CaM3Ca, PP2A])
    Reac3534.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca  -> CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca  + PP2A
    Reac3535 = smodel.Reac('Reac3535', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca])
    Reac3535.kcst = 0.2e6
    Reac3536 = smodel.Reac('Reac3536', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac3536.kcst = 0.8
    Reac3537 = smodel.Reac('Reac3537', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3ppPP2A_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca, PP2A])
    Reac3537.kcst = 0.2
    
    # CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca  -> CaMKII_s1_s2CaM3Ca_s3pp_s4pCaM3Ca  + PP2A
    Reac3538 = smodel.Reac('Reac3538', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca])
    Reac3538.kcst = 0.2e6
    Reac3539 = smodel.Reac('Reac3539', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac3539.kcst = 0.8
    Reac3540 = smodel.Reac('Reac3540', vsys, lhs = [CaMKII_s1_s2pCaM3CaPP2A_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3pp_s4pCaM3Ca, PP2A])
    Reac3540.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pp_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2p_s3pp_s4pCaM3CaPP2A  -> CaMKII_s1_s2p_s3pp_s4CaM3Ca  + PP2A
    Reac3541 = smodel.Reac('Reac3541', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2p_s3pp_s4pCaM3CaPP2A])
    Reac3541.kcst = 0.2e6
    Reac3542 = smodel.Reac('Reac3542', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3CaPP2A], rhs =[CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac3542.kcst = 0.8
    Reac3543 = smodel.Reac('Reac3543', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3CaPP2A], rhs = [CaMKII_s1_s2p_s3pp_s4CaM3Ca, PP2A])
    Reac3543.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pp_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2p_s3ppPP2A_s4pCaM3Ca  -> CaMKII_s1_s2p_s3p_s4pCaM3Ca  + PP2A
    Reac3544 = smodel.Reac('Reac3544', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2p_s3ppPP2A_s4pCaM3Ca])
    Reac3544.kcst = 0.2e6
    Reac3545 = smodel.Reac('Reac3545', vsys, lhs = [CaMKII_s1_s2p_s3ppPP2A_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac3545.kcst = 0.8
    Reac3546 = smodel.Reac('Reac3546', vsys, lhs = [CaMKII_s1_s2p_s3ppPP2A_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac3546.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pp_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pPP2A_s3pp_s4pCaM3Ca  -> CaMKII_s1_s2_s3pp_s4pCaM3Ca  + PP2A
    Reac3547 = smodel.Reac('Reac3547', vsys, lhs = [CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pPP2A_s3pp_s4pCaM3Ca])
    Reac3547.kcst = 0.2e6
    Reac3548 = smodel.Reac('Reac3548', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pp_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pp_s4pCaM3Ca, PP2A])
    Reac3548.kcst = 0.8
    Reac3549 = smodel.Reac('Reac3549', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pp_s4pCaM3Ca], rhs = [CaMKII_s1_s2_s3pp_s4pCaM3Ca, PP2A])
    Reac3549.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP2A  -> CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca  + PP2A
    Reac3550 = smodel.Reac('Reac3550', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac3550.kcst = 0.2e6
    Reac3551 = smodel.Reac('Reac3551', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3551.kcst = 0.8
    Reac3552 = smodel.Reac('Reac3552', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac3552.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pCaM3Ca  -> CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca  + PP2A
    Reac3553 = smodel.Reac('Reac3553', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac3553.kcst = 0.2e6
    Reac3554 = smodel.Reac('Reac3554', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3554.kcst = 0.8
    Reac3555 = smodel.Reac('Reac3555', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac3555.kcst = 0.2

    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca  -> CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca  + PP2A
    Reac3556 = smodel.Reac('Reac3556', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac3556.kcst = 0.2e6
    Reac3557 = smodel.Reac('Reac3557', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3557.kcst = 0.8
    Reac3558 = smodel.Reac('Reac3558', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3558.kcst = 0.2
    
    
    # CaMKII_s1_s2pp_s3p_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pp_s3p_s4pCaM3CaPP2A  -> CaMKII_s1_s2pp_s3p_s4CaM3Ca  + PP2A
    Reac3559 = smodel.Reac('Reac3559', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pp_s3p_s4pCaM3CaPP2A])
    Reac3559.kcst = 0.2e6
    Reac3560 = smodel.Reac('Reac3560', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3CaPP2A], rhs =[CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac3560.kcst = 0.8
    Reac3561 = smodel.Reac('Reac3561', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3CaPP2A], rhs = [CaMKII_s1_s2pp_s3p_s4CaM3Ca, PP2A])
    Reac3561.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3p_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pp_s3pPP2A_s4pCaM3Ca  -> CaMKII_s1_s2pp_s3_s4pCaM3Ca  + PP2A
    Reac3562 = smodel.Reac('Reac3562', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pp_s3pPP2A_s4pCaM3Ca])
    Reac3562.kcst = 0.2e6
    Reac3563 = smodel.Reac('Reac3563', vsys, lhs = [CaMKII_s1_s2pp_s3pPP2A_s4pCaM3Ca], rhs =[CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac3563.kcst = 0.8
    Reac3564 = smodel.Reac('Reac3564', vsys, lhs = [CaMKII_s1_s2pp_s3pPP2A_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3_s4pCaM3Ca, PP2A])
    Reac3564.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3p_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2ppPP2A_s3p_s4pCaM3Ca  -> CaMKII_s1_s2p_s3p_s4pCaM3Ca  + PP2A
    Reac3565 = smodel.Reac('Reac3565', vsys, lhs = [CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2ppPP2A_s3p_s4pCaM3Ca])
    Reac3565.kcst = 0.2e6
    Reac3566 = smodel.Reac('Reac3566', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3p_s4pCaM3Ca], rhs =[CaMKII_s1_s2pp_s3p_s4pCaM3Ca, PP2A])
    Reac3566.kcst = 0.8
    Reac3567 = smodel.Reac('Reac3567', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3p_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3p_s4pCaM3Ca, PP2A])
    Reac3567.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP2A  -> CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca  + PP2A
    Reac3568 = smodel.Reac('Reac3568', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac3568.kcst = 0.2e6
    Reac3569 = smodel.Reac('Reac3569', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3569.kcst = 0.8
    Reac3570 = smodel.Reac('Reac3570', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac3570.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pCaM3Ca  -> CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca  + PP2A
    Reac3571 = smodel.Reac('Reac3760', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac3571.kcst = 0.2e6
    Reac3572 = smodel.Reac('Reac3572', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3572.kcst = 0.8
    Reac3573 = smodel.Reac('Reac3573', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac3573.kcst = 0.2
    
    # CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca  -> CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca  + PP2A
    Reac3574 = smodel.Reac('Reac3574', vsys, lhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac3574.kcst = 0.2e6
    Reac3575 = smodel.Reac('Reac3575', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3575.kcst = 0.8
    Reac3576 = smodel.Reac('Reac3576', vsys, lhs = [CaMKII_s1_s2pPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3576.kcst = 0.2
    
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A  -> CaMKII_s1_s2pp_s3pCaM3Ca_s4CaM3Ca  + PP2A
    Reac3577 = smodel.Reac('Reac3577', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A])
    Reac3577.kcst = 0.2e6
    Reac3578 = smodel.Reac('Reac3578', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3578.kcst = 0.8
    Reac3579 = smodel.Reac('Reac3579', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3CaPP2A], rhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4CaM3Ca, PP2A])
    Reac3579.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca  -> CaMKII_s1_s2pp_s3CaM3Ca_s4pCaM3Ca  + PP2A
    Reac3580 = smodel.Reac('Reac3580', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca])
    Reac3580.kcst = 0.2e6
    Reac3581 = smodel.Reac('Reac3581', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3581.kcst = 0.8
    Reac3582 = smodel.Reac('Reac3582', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3CaPP2A_s4pCaM3Ca], rhs = [CaMKII_s1_s2pp_s3CaM3Ca_s4pCaM3Ca, PP2A])
    Reac3582.kcst = 0.2
    
    # CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca + PP2A <->   CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca  -> CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca  + PP2A
    Reac3583 = smodel.Reac('Reac3583', vsys, lhs = [CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A], rhs = [CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca])
    Reac3583.kcst = 0.2e6
    Reac3584 = smodel.Reac('Reac3584', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs =[CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3584.kcst = 0.8
    Reac3585 = smodel.Reac('Reac3585', vsys, lhs = [CaMKII_s1_s2ppPP2A_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca, PP2A])
    Reac3585.kcst = 0.2
    
    # CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca -> CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca #autophosphorylation at Thr286
    Reac3586 = smodel.Reac('Reac3586', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca])
    Reac3586.kcst = k_t286
    
    # CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca #autophosphorylation at Thr286
    Reac3587 = smodel.Reac('Reac3587', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac3587.kcst = k_t286
    
    # CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca #autophosphorylation at Thr286
    Reac3588 = smodel.Reac('Reac3588', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac3588.kcst = k_t286
    
    # CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4CaM3Ca #autophosphorylation at Thr286
    Reac3589 = smodel.Reac('Reac3589', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4CaM3Ca])
    Reac3589.kcst = k_t286
    
    # CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4CaM3Ca -> CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca #autophosphorylation at Thr286
    Reac3590 = smodel.Reac('Reac3590', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca])
    Reac3590.kcst = k_t286
    
    # CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4CaM3Ca -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca #autophosphorylation at Thr286
    Reac3591 = smodel.Reac('Reac3591', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca])
    Reac3591.kcst = k_t286
    
    # CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca -> CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca #autophosphorylation at Thr286
    Reac3592 = smodel.Reac('Reac3592', vsys, lhs = [CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca])
    Reac3592.kcst = k_t286
    
    # CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca -> CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca #autophosphorylation at Thr286
    Reac3593 = smodel.Reac('Reac3593', vsys, lhs = [CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca], rhs = [CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca])
    Reac3593.kcst = k_t286
    
    
    return mdl

########################################################################

# Geometric properties of the model: To change the size of the model, 
# all volumetric compartments must be altered by the same ratio
# and all the areas must be scaled considering a spherical shape.
# Alterations in the size of the compartments will change automatically the population
# of species given in concentration (initial condition), but the species 
# given in number of molecules must be altered manually by the same ratio
# to keep the balance among all the components of the model. 

def gen_geom():    
    g = swm.Geom()
    c = swm.Comp('vsys', g)
    c.addVolsys('vsys')
    c.setVol( 0.08e-18)
    
    extra = swm.Comp('extra', g)
    extra.addVolsys('extra')
    extra.setVol(0.08e-22)
    
    s = swm.Patch('memb', g, icomp = c, ocomp = extra)
    s.addSurfsys('memb')
    s.area = 1.02e-12
    
    cytER = swm.Comp('cytER', g)
    cytER.addVolsys('cytER')
    cytER.setVol(0.017e-18)
    
    ERs = swm.Patch('ERmemb', g, icomp = cytER, ocomp = c)
    ERs.addSurfsys('ERmemb')
    ERs.area = 0.32e-12
    
    return g

######################################################################

def run_gauss_mean():
    rng=srng.create('mt19937',512)
    m=gen_model() 
    g=gen_geom() 
    tpnts=np.arange(0.0,INT,DT)
    ntpnts=tpnts.shape[0]
    
    # initialize arrays for storage at each time point and at each run.
    Ca = numpy.zeros((NITER, ntpnts))
    PMCA = numpy.zeros((NITER, ntpnts))
    Ca1PMCA = numpy.zeros((NITER, ntpnts))
    NCX = numpy.zeros((NITER, ntpnts))
    Ca1NCX = numpy.zeros((NITER, ntpnts))
    Ca2NCX = numpy.zeros((NITER, ntpnts))
    SERCA = numpy.zeros((NITER, ntpnts))
    Ca1SERCA = numpy.zeros((NITER, ntpnts))
    Ca2SERCA = numpy.zeros((NITER, ntpnts))
    CBf = numpy.zeros((NITER, ntpnts))
    CaCBf = numpy.zeros((NITER, ntpnts))
    Ca2CBf = numpy.zeros((NITER, ntpnts))
    CBs = numpy.zeros((NITER, ntpnts))
    CaCBs = numpy.zeros((NITER, ntpnts))
    Ca2CBs = numpy.zeros((NITER, ntpnts))
    PV = numpy.zeros((NITER, ntpnts))
    CaPV = numpy.zeros((NITER, ntpnts))
    MgPV = numpy.zeros((NITER, ntpnts))
    Ca2PV = numpy.zeros((NITER, ntpnts))
    Mg2PV = numpy.zeros((NITER, ntpnts))
    PP2A = numpy.zeros((NITER, ntpnts))
    PKC = numpy.zeros((NITER, ntpnts))
    Ca1PKC = numpy.zeros((NITER, ntpnts))
    Ca3PKC = numpy.zeros((NITER, ntpnts))
    AAPKC = numpy.zeros((NITER, ntpnts))
    AACa1PKC = numpy.zeros((NITER, ntpnts))
    AACa3PKC = numpy.zeros((NITER, ntpnts))
    PKCstar = numpy.zeros((NITER, ntpnts))
    PKCstar2 = numpy.zeros((NITER, ntpnts))
    PKCstar4 = numpy.zeros((NITER, ntpnts))
    PKCstar3 = numpy.zeros((NITER, ntpnts))
    RKIPstarRP = numpy.zeros((NITER, ntpnts))
    RafRKIPPKCstar = numpy.zeros((NITER, ntpnts))
    RafRKIPPKCstar2 = numpy.zeros((NITER, ntpnts))
    RafRKIPPKCstar3 = numpy.zeros((NITER, ntpnts))
    RafRKIPPKCstar4 = numpy.zeros((NITER, ntpnts))
    RafRKIP = numpy.zeros((NITER, ntpnts))
    MEKRKIPPKCstar = numpy.zeros((NITER, ntpnts))
    MEKRKIPPKCstar2 = numpy.zeros((NITER, ntpnts))
    MEKRKIPPKCstar3 = numpy.zeros((NITER, ntpnts))
    MEKRKIPPKCstar4 = numpy.zeros((NITER, ntpnts))
    MEKRKIP = numpy.zeros((NITER, ntpnts))
    Raf = numpy.zeros((NITER, ntpnts))
    RKIPstar = numpy.zeros((NITER, ntpnts))
    Rafstar = numpy.zeros((NITER, ntpnts))
    PP5Rafstar = numpy.zeros((NITER, ntpnts))
    PP5 = numpy.zeros((NITER, ntpnts))
    MEK = numpy.zeros((NITER, ntpnts))
    RafstarMEK = numpy.zeros((NITER, ntpnts))
    MEKp = numpy.zeros((NITER, ntpnts))
    PP2AMEKp = numpy.zeros((NITER, ntpnts))
    RafstarMEKp = numpy.zeros((NITER, ntpnts))
    MEKstar = numpy.zeros((NITER, ntpnts))
    PP2AMEKstar = numpy.zeros((NITER, ntpnts))
    ERK = numpy.zeros((NITER, ntpnts))
    MEKstarERK = numpy.zeros((NITER, ntpnts))
    ERKp = numpy.zeros((NITER, ntpnts))
    MKP = numpy.zeros((NITER, ntpnts))
    MKPERKp = numpy.zeros((NITER, ntpnts))
    MEKstarERKp = numpy.zeros((NITER, ntpnts))
    ERKstar = numpy.zeros((NITER, ntpnts))
    MKPERKstar = numpy.zeros((NITER, ntpnts))
    Ca1PLA2 = numpy.zeros((NITER, ntpnts))
    Ca2PLA2 = numpy.zeros((NITER, ntpnts))
    PLA2 = numpy.zeros((NITER, ntpnts))
    PLA2memb = numpy.zeros((NITER, ntpnts))
    Ca1PLA2memb = numpy.zeros((NITER, ntpnts))
    PLA2star1 = numpy.zeros((NITER, ntpnts))
    ERKstarPLA2 = numpy.zeros((NITER, ntpnts))
    PLA2star2 = numpy.zeros((NITER, ntpnts))
    AA = numpy.zeros((NITER, ntpnts))
    Ca1PLA2star2 = numpy.zeros((NITER, ntpnts))
    Ca2PLA2star2 = numpy.zeros((NITER, ntpnts))
    PLA2star2memb = numpy.zeros((NITER, ntpnts))
    Ca1PLA2star2memb = numpy.zeros((NITER, ntpnts))
    Ca2PLA2star2memb = numpy.zeros((NITER, ntpnts))
    PLA2star1APC = numpy.zeros((NITER, ntpnts))
    ERKstarCa1PLA2 = numpy.zeros((NITER, ntpnts))
    ERKstarCa2PLA2 = numpy.zeros((NITER, ntpnts))
    PP2ACa1PLA2star2 = numpy.zeros((NITER, ntpnts))
    PP2ACa2PLA2star2 = numpy.zeros((NITER, ntpnts))
    PP1Ca1PLA2star2 = numpy.zeros((NITER, ntpnts))
    PP1Ca2PLA2star2 = numpy.zeros((NITER, ntpnts))
    PLA2star2membAPC = numpy.zeros((NITER, ntpnts))
    Ca1PLA2star2membAPC = numpy.zeros((NITER, ntpnts))
    Ca2PLA2star2membAPC = numpy.zeros((NITER, ntpnts))
    PP1PLA2star2 = numpy.zeros((NITER, ntpnts))
    PP1 = numpy.zeros((NITER, ntpnts)) 
    PP2APLA2star2 = numpy.zeros((NITER, ntpnts))
    PKCstarAMPAR = numpy.zeros((NITER, ntpnts))
    PKCstar2AMPAR = numpy.zeros((NITER, ntpnts))
    PKCstar4AMPAR = numpy.zeros((NITER, ntpnts))
    PKCstar3AMPAR = numpy.zeros((NITER, ntpnts))
    PKCstarGRIPAMPAR = numpy.zeros((NITER, ntpnts))
    PKCstar2GRIPAMPAR = numpy.zeros((NITER, ntpnts))
    PKCstar4GRIPAMPAR = numpy.zeros((NITER, ntpnts))
    PKCstar3GRIPAMPAR = numpy.zeros((NITER, ntpnts))
    PP2AGRIPAMPAR_P = numpy.zeros((NITER, ntpnts))
    AMPAR = numpy.zeros((NITER, ntpnts))
    AMPAR_P = numpy.zeros((NITER, ntpnts))
    PP2AAMPAR_P = numpy.zeros((NITER, ntpnts))
    AMPARextra = numpy.zeros((NITER, ntpnts))
    AMPARextra_P = numpy.zeros((NITER, ntpnts))
    PP2AAMPARextra_P = numpy.zeros((NITER, ntpnts))
    GRIP = numpy.zeros((NITER, ntpnts))
    GRIPAMPAR_P = numpy.zeros((NITER, ntpnts))
    GRIPAMPAR = numpy.zeros((NITER, ntpnts))
    AMPARdend = numpy.zeros((NITER, ntpnts))
    AMPARdend_P = numpy.zeros((NITER, ntpnts))
    PP2AAMPARdend_P = numpy.zeros((NITER, ntpnts))
    AMPARcyt = numpy.zeros((NITER, ntpnts))
    AMPARcyt_P = numpy.zeros((NITER, ntpnts))
    PP2AAMPARcyt_P = numpy.zeros((NITER, ntpnts))
    GC = numpy.zeros((NITER, ntpnts))
    NO = numpy.zeros((NITER, ntpnts))
    GC_NO = numpy.zeros((NITER, ntpnts))
    GTP = numpy.zeros((NITER, ntpnts))
    GTP_GC_NO = numpy.zeros((NITER, ntpnts))
    cGMP = numpy.zeros((NITER, ntpnts))
    GMP = numpy.zeros((NITER,ntpnts))
    PDE1 = numpy.zeros((NITER, ntpnts))
    pPDE1 = numpy.zeros((NITER, ntpnts))
    PDE5 = numpy.zeros((NITER, ntpnts))
    PDE5_cGMP = numpy.zeros((NITER, ntpnts))
    PKG = numpy.zeros((NITER, ntpnts))
    PKG_cGMP = numpy.zeros((NITER, ntpnts))
    CaM3Ca_PDE1 = numpy.zeros((NITER, ntpnts))
    CaM3Ca_pPDE1 = numpy.zeros((NITER, ntpnts))
    GMP = numpy.zeros((NITER, ntpnts))
    PP2A_pGsub = numpy.zeros((NITER, ntpnts))
    pG = numpy.zeros((NITER, ntpnts))
    G_sub = numpy.zeros((NITER, ntpnts))
    cGMP_CaM3Ca_pPDE1 = numpy.zeros((NITER, ntpnts))
    cGMP_CaM3Ca_PDE1 = numpy.zeros((NITER, ntpnts))
    cGMP_PDE1 = numpy.zeros((NITER, ntpnts))
    cGMP_pPDE1 = numpy.zeros((NITER, ntpnts))
    PDE1_CaMKII = numpy.zeros((NITER, ntpnts))
    pPDE1_CaN = numpy.zeros((NITER, ntpnts))    
    CaM3Ca_PDE1_CaMKII = numpy.zeros((NITER, ntpnts))
    CaM3Ca_pPDE1_CaN = numpy.zeros((NITER, ntpnts))
    pG_PP2A = numpy.zeros((NITER, ntpnts))
    pG_CaN = numpy.zeros((NITER, ntpnts))
    G_sub_PKG = numpy.zeros((NITER, ntpnts))
    pDARPP32_PP2A = numpy.zeros((NITER, ntpnts))
    PP1_pDARPP32 = numpy.zeros((NITER, ntpnts))
    PP1_DARPP32 = numpy.zeros((NITER, ntpnts))
    DARPP32 = numpy.zeros((NITER, ntpnts))
    pDARPP32 = numpy.zeros((NITER, ntpnts))
    R2C2_PKA = numpy.zeros((NITER, ntpnts))
    cAMP_R2C2 = numpy.zeros((NITER, ntpnts))
    cAMP2_bb_R2C2 = numpy.zeros((NITER, ntpnts))
    cAMP2_ab_R2C2 = numpy.zeros((NITER, ntpnts))
    cAMP2_ab_R2C = numpy.zeros((NITER, ntpnts))
    cAMP3_R2C2 = numpy.zeros((NITER, ntpnts))
    cAMP3_R2C = numpy.zeros((NITER, ntpnts))
    cAMP4_R2C2 = numpy.zeros((NITER, ntpnts))
    cAMP4_R2C = numpy.zeros((NITER, ntpnts))
    cAMP4_R2 = numpy.zeros((NITER, ntpnts))
    C_actPKA = numpy.zeros((NITER, ntpnts))
    cAMP = numpy.zeros((NITER, ntpnts))
    AMP = numpy.zeros((NITER, ntpnts))
    PDE4 = numpy.zeros((NITER, ntpnts))
    cAMP_PDE4 = numpy.zeros((NITER, ntpnts)) 
    cAMP_PDE1 = numpy.zeros((NITER, ntpnts))
    cAMP_pPDE1 = numpy.zeros((NITER, ntpnts))
    cAMP_CaM3Ca_PDE1 = numpy.zeros((NITER, ntpnts))
    cAMP_CaM3Ca_pPDE1  = numpy.zeros((NITER, ntpnts))
    PP1_pDARPP32_PP2A  = numpy.zeros((NITER, ntpnts))
    CaM3CaCaN = numpy.zeros((NITER, ntpnts))
    pG_CaM3CaCaN = numpy.zeros((NITER, ntpnts))
    GMP = numpy.zeros((NITER, ntpnts))
    pPDE1 = numpy.zeros((NITER, ntpnts))
    act_PDE5 = numpy.zeros((NITER, ntpnts))
    CaM = numpy.zeros((NITER, ntpnts))
    CaM1Ca = numpy.zeros((NITER, ntpnts))
    CaM2Ca = numpy.zeros((NITER, ntpnts))
    CaM3Ca = numpy.zeros((NITER, ntpnts))
    CaN = numpy.zeros((NITER, ntpnts))
    CaM3CaCaN = numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2CaM3Ca_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2p_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2CaM3Ca_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pp_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3CaM3Ca_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4= numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3pp_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3pp_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3pp_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3pp_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3p_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3p_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3p_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3p_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3p_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3p_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3pCaM3Ca_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3pp_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3pp_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3pp_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3pp_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3p_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3pp_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3p_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3p_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3p_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca= numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2p_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pp_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2CaM3Ca_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2CaM3Ca_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2p_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pp_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2CaM3Ca_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2CaM3Ca_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2p_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2CaM3Ca_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2CaM3Ca_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2p_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pp_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pp_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2CaM3Ca_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2CaM3Ca_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3pCaM3Ca_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2p_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3pp_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pp_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3pp_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3pp_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3pp_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3pp_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2CaM3Ca_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3pp_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2p_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3p_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3p_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3p_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3p_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2CaM3Ca_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3p_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3p_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2CaM3Ca_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3p_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2CaM3Ca_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3pp_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pp_s3pCaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pp_s3pCaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2_s3pCaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2p_s3pCaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2_s3pCaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3pCaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pp_s2p_s3pp_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2pp_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2pp_s3p_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3CaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3CaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3p_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3p_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3pp_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3pp_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3p_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3pCaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3pp_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3p_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3pCaM3Ca_s4pp=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pCaM3Ca_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3pp_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3p_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3p_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3pp_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2p_s3pCaM3Ca_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3pCaM3Ca_s4p=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2pp_s3pCaM3Ca_s4=numpy.zeros((NITER, ntpnts))
    CaMKII_s1_s2_s3pp_s4pCaM3Ca=numpy.zeros((NITER, ntpnts))
    
    sim = swmdirect.Wmrssa(m, g, rng)
    
    
    for j in range(NITER):
        print ("Run number {0}".format(j))
        rng.initialize(datetime.datetime.now().microsecond)
        sim.reset()
        
        # initial conditions
        ##PP2A input
        pp2a_conc = 2.1
        ##NO input
        no_input = 5
        # Raf number
        raf_number = 7
        # PLA2 concentration (uM)
        pla2_conc = 0.4
        # PKC number
        pkc_number = 50
        
        sim.setCompConc('vsys', 'Ca', 0.045e-6)
        sim.setCompConc('vsys', 'CBf', 37.775e-6)
        sim.setCompConc('vsys', 'CaCBf', 2.1e-6)
        sim.setCompConc('vsys', 'Ca2CBf', 0.125e-6)
        sim.setCompConc('vsys', 'CBs', 36.25e-6)
        sim.setCompConc('vsys', 'CaCBs', 3.4e-6)
        sim.setCompConc('vsys', 'Ca2CBs', 0.125e-6)
        sim.setCompConc('vsys', 'PV', 1.15e-6)
        sim.setCompConc('vsys', 'CaPV', 8.4e-6)
        sim.setCompConc('vsys', 'MgPV', 30.45e-6)
        sim.setCompCount('vsys', 'PKC', int(pkc_number))
        sim.setCompCount('vsys', 'Raf',int(raf_number))
        sim.setCompConc('vsys', 'RKIP', 1.0e-6)
        sim.setCompConc('vsys', 'MEK',1.5e-6)
        sim.setCompConc('vsys', 'RP' ,3e-6)
        sim.setCompConc('vsys', 'ERK',1.0e-6)
        sim.setCompConc('vsys', 'MKP',0.26e-6)
        sim.setCompConc('vsys', 'PP5', 1.0e-6)
        sim.setCompConc('vsys', 'PP2A', float(pp2a_conc)*1.0e-6)
        sim.setCompConc('vsys', 'PLA2',float(pla2_conc)*1.0e-6)
        sim.setCompCount('vsys', 'PP1', 30)
        sim.setPatchCount('memb', 'PMCA',10)
        sim.setPatchCount('memb', 'NCX',3)
        sim.setPatchCount('ERmemb', 'SERCA', 100)
        sim.setCompConc('cytER', 'Ca', 150e-6)
        sim.setCompClamped('cytER', 'Ca', True) # clamped means the conc won't change as simulation runs.
        sim.setPatchCount('memb', 'AMPAR', 3) 
        sim.setPatchCount('memb', 'AMPARextra', 16) 
        sim.setPatchCount('memb', 'GRIP', 22) 
        sim.setPatchCount('memb', 'GRIPAMPAR', 100)
        sim.setPatchCount('memb', 'AMPARdend', 1600)
        sim.setCompConc('vsys','NO',float(no_input)*1e-8)
        sim.setCompClamped('vsys','NO',True)
        sim.setCompConc('vsys','CaMKII_s1_s2_s3_s4',float(Kin)*1e-6)
        sim.setCompConc('vsys','CaM',60e-6)
        sim.setCompConc('vsys','CaN',10e-6)
        sim.setCompConc('vsys','DARPP32',0.7e-6)
        sim.setCompConc('vsys','R2C2_PKA',0.25e-6)
        sim.setCompConc('vsys','PDE5',0.6e-6)
        sim.setCompConc('vsys','PDE1',0.6e-6)
        sim.setCompConc('vsys','PDE4',0.6e-6)
        sim.setCompConc('vsys','GC',0.04e-6)
        sim.setCompConc('vsys','PKG',0.1e-6)
        sim.setCompConc('vsys','G_sub',0.7e-6)
        sim.setCompConc('vsys','cAMP', 0.15e-6)
        sim.setCompConc('vsys','AMP',100e-6)
        sim.setCompClamped('vsys','AMP',True)
        sim.setCompConc('vsys','GTP',100e-6)
        sim.setCompClamped('vsys','GTP',True)
        sim.setCompConc('vsys','GMP', 0.1e-6)
        sim.setCompClamped('vsys','GMP',True)
        sim.setCompConc('vsys','cGMP', 0.02e-6)
       
        
        for i in range(ntpnts):


            actCaMK=sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2_s3_s4') + sim.getCompConc('vsys','CaMKII_s1_s2CaM3Ca_s3_s4') +  sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4') +  sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4') + sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4') + sim.getCompConc('vsys','CaMKII_s1p_s2CaM3Ca_s3_s4') +\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2p_s3_s4') +  sim.getCompConc('vsys','CaMKII_s1p_s2_s3_s4') +  sim.getCompConc('vsys','CaMKII_s1_s2p_s3_s4')  +  sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4')  + sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3_s4') +  sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3_s4') + sim.getCompConc('vsys','CaMKII_s1p_s2p_s3_s4') +\
                sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3_s4') + sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3_s4') + sim.getCompConc('vsys','CaMKII_s1pp_s2_s3_s4') +  sim.getCompConc('vsys','CaMKII_s1_s2pp_s3_s4') +  sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3_s4') + sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3_s4') + sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3_s4') +\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3_s4') +  sim.getCompConc('vsys','CaMKII_s1pp_s2CaM3Ca_s3_s4') +  sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pp_s3_s4') + sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3_s4')+\
                sim.getCompConc('vsys','CaMKII_s1_s2_s3CaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1_s2_s3_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4')+\
                sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4')+\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3pp_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3p_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2p_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3pp_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3pp_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3p_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3pCaM3Ca_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2p_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2p_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pp')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2p_s3pp_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pp_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1_s2p_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2_s3pp_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1_s2pp_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2CaM3Ca_s3pp_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2CaM3Ca_s3pp_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2p_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3_s4pp')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pp_s3p_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3_s4pp')+sim.getCompConc('vsys','CaMKII_s1_s2pp_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1_s2p_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2_s3p_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3_s4pp')+sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2CaM3Ca_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2CaM3Ca_s3p_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3_s4pp')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1_s2pp_s3pCaM3Ca_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3CaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1_s2p_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3CaM3Ca_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3CaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3CaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pp')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pp')+\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4')+\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2p_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3pp_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3pp_s4')+sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2CaM3Ca_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3pp_s4')+\
                sim.getCompConc('vsys','CaMKII_s1_s2p_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3pp_s4')+sim.getCompConc('vsys','CaMKII_s1pp_s2CaM3Ca_s3pp_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3pp_s4')+sim.getCompConc('vsys','CaMKII_s1_s2pp_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3pp_s4')+sim.getCompConc('vsys','CaMKII_s1pp_s2_s3pp_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3pp_s4')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3pp_s4')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2p_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3p_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3p_s4')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pp_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3p_s4')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pp_s3pp_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3pp_s4')+sim.getCompConc('vsys','CaMKII_s1_s2pp_s3p_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3p_s4')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3p_s4')+\
                sim.getCompConc('vsys','CaMKII_s1_s2p_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3p_s4')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3p_s4')+sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3p_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2CaM3Ca_s3p_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3p_s4')+sim.getCompConc('vsys','CaMKII_s1pp_s2CaM3Ca_s3p_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3p_s4')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1_s2p_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3CaM3Ca_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2p_s3pCaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1_s2pp_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3CaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3pCaM3Ca_s4')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3CaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3pCaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1pp_s2_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3CaM3Ca_s4p')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3pCaM3Ca_s4')+sim.getCompConc('vsys','CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4p')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4')+\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4CaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2p_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3pp_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pp_s3pp_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3pp_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2pp_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3pp_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3pp_s4CaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1_s2p_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3pp_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2CaM3Ca_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3pp_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2p_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3p_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3p_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2pp_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3p_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3p_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2p_s3p_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3p_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2CaM3Ca_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3p_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2_s3p_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3p_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2CaM3Ca_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3p_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2CaM3Ca_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3pp_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3CaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2pp_s3pCaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3CaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pp_s3pCaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3CaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2p_s3pCaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2_s3pCaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3CaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3pCaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2_s3pp_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pp_s2p_s3pp_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2pp_s3p_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2pp_s3p_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4CaM3Ca')+sim.getCompConc('vsys','CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca')+\
                sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca')+sim.getCompConc('vsys','CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca');
            
            
            sim.run(tpnts[i]) 
    
            print ("percent done",(tpnts[i]/INT*100))
            Ca[j,i] = sim.getCompConc('vsys', 'Ca')
            CBf[j,i] = sim.getCompConc('vsys', 'CBf')
            CaCBf[j,i] = sim.getCompConc('vsys', 'CaCBf')
            Ca2CBf[j,i] = sim.getCompConc('vsys', 'Ca2CBf')
            CaCBs[j,i] = sim.getCompConc('vsys', 'CaCBs')
            Ca2CBs[j,i] = sim.getCompConc('vsys', 'Ca2CBs')
            PV[j,i] = sim.getCompConc('vsys', 'PV')
            CaPV[j,i] = sim.getCompConc('vsys', 'CaPV')
            MgPV[j,i] = sim.getCompConc('vsys', 'MgPV')
            Ca2PV[j,i] = sim.getCompConc('vsys', 'Ca2PV')
            Mg2PV[j,i] = sim.getCompConc('vsys', 'Mg2PV')
            PP2A[j,i] = sim.getCompCount('vsys', 'PP2A')
            PP5[j,i] = sim.getCompCount('vsys', 'PP5')
            PKC[j,i] = sim.getCompCount('vsys', 'PKC')
            Ca3PKC[j,i] = sim.getCompCount('vsys', 'Ca3PKC')
            Ca1PKC[j,i] = sim.getCompCount('vsys', 'Ca1PKC')
            AAPKC[j,i] = sim.getCompCount('vsys', 'AAPKC')
            AACa1PKC[j,i] = sim.getCompCount('vsys', 'AACa1PKC')
            AACa3PKC[j,i] = sim.getCompCount('vsys', 'AACa3PKC')
            PKCstar[j,i] = sim.getPatchCount('memb', 'PKCstar')
            PKCstar2[j,i] = sim.getPatchCount('memb', 'PKCstar2')
            PKCstar3[j,i] = sim.getPatchCount('memb', 'PKCstar3')
            PKCstar4[j,i] = sim.getPatchCount('memb', 'PKCstar4')
            RafRKIP[j,i] = sim.getCompConc('vsys', 'RafRKIP')
            RafRKIPPKCstar[j,i] = sim.getPatchCount('memb', 'RafRKIPPKCstar')
            RafRKIPPKCstar2[j,i] = sim.getPatchCount('memb', 'RafRKIPPKCstar2')
            RafRKIPPKCstar3[j,i] = sim.getPatchCount('memb', 'RafRKIPPKCstar3')
            RafRKIPPKCstar4[j,i] = sim.getPatchCount('memb', 'RafRKIPPKCstar4')
            MEKRKIP[j,i] = sim.getCompConc('vsys', 'MEKRKIP')
            MEKRKIPPKCstar[j,i] = sim.getPatchCount('memb', 'MEKRKIPPKCstar')
            MEKRKIPPKCstar2[j,i] = sim.getPatchCount('memb', 'MEKRKIPPKCstar2')
            MEKRKIPPKCstar3[j,i] = sim.getPatchCount('memb', 'MEKRKIPPKCstar3')
            MEKRKIPPKCstar4[j,i] = sim.getPatchCount('memb', 'MEKRKIPPKCstar4')
            RKIPstar[j,i] = sim.getCompCount('vsys', 'RKIPstar')
            RKIPstarRP[j,i] = sim.getCompCount('vsys', 'RKIPstarRP')
            Raf[j,i] = sim.getCompCount('vsys', 'Raf')
            Rafstar[j,i] = sim.getCompCount('vsys', 'Rafstar')
            PP5Rafstar[j,i] = sim.getCompCount('vsys', 'PP5Rafstar')
            MEK[j,i] = sim.getCompCount('vsys', 'MEK')
            RafstarMEK[j,i] = sim.getCompCount('vsys', 'RafstarMEK')
            MEKp[j,i] = sim.getCompCount('vsys', 'MEKp')
            PP2AMEKp[j,i] = sim.getCompCount('vsys', 'PP2AMEKp')
            RafstarMEKp[j,i] = sim.getCompCount('vsys', 'RafstarMEKp')
            MEKstar[j,i] = sim.getCompCount('vsys', 'MEKstar')
            ERK[j,i] = sim.getCompCount('vsys', 'ERK')
            MEKstarERK[j,i] = sim.getCompCount('vsys', 'MEKstarERK')
            ERKp[j,i] = sim.getCompCount('vsys', 'ERKp')
            MKP[j,i] = sim.getCompCount('vsys', 'MKP')
            MKPERKp[j,i] = sim.getCompCount('vsys', 'MKPERKp')
            MEKstarERKp[j,i] = sim.getCompCount('vsys', 'MEKstarERKp')
            ERKstar[j,i] = sim.getCompCount('vsys', 'ERKstar')
            MKPERKstar[j,i] = sim.getCompCount('vsys', 'MKPERKstar')
            PP2A[j,i] = sim.getCompConc('vsys', 'PP2A')
            PLA2[j,i] = sim.getCompCount('vsys', 'PLA2')
            Ca1PLA2[j,i] = sim.getCompCount('vsys', 'Ca1PLA2')
            Ca2PLA2[j,i] = sim.getCompCount('vsys', 'Ca2PLA2')
            PLA2memb[j,i] = sim.getPatchCount('memb', 'PLA2memb')
            Ca1PLA2memb[j,i] = sim.getPatchCount('memb', 'Ca1PLA2memb')
            PLA2star1[j,i] = sim.getPatchCount('memb', 'PLA2star1')
            ERKstarPLA2[j,i] = sim.getCompCount('vsys', 'ERKstarPLA2')
            PLA2star2[j,i] = sim.getCompCount('vsys', 'PLA2star2')
            Ca1PLA2star2[j,i] = sim.getCompCount('vsys', 'Ca1PLA2star2')
            Ca2PLA2star2[j,i] = sim.getCompCount('vsys', 'Ca2PLA2star2')
            PLA2star2memb[j,i] = sim.getPatchCount('memb', 'PLA2star2memb')
            Ca1PLA2star2memb[j,i] = sim.getPatchCount('memb', 'Ca1PLA2star2memb')
            Ca2PLA2star2memb[j,i] = sim.getPatchCount('memb', 'Ca2PLA2star2memb')  
            AA[j,i] = sim.getCompConc('vsys', 'AA')
            PP2APLA2star2[j,i] = sim.getCompCount('vsys', 'PP2APLA2star2')
            PP1[j,i] = sim.getCompConc('vsys','PP1')
            PP1PLA2star2[j,i] = sim.getCompCount('vsys', 'PP1PLA2star2')
            PLA2star1APC[j,i] = sim.getPatchCount('memb', 'PLA2star1APC')
            ERKstarCa1PLA2[j,i] = sim.getCompConc('vsys', 'ERKstarCa1PLA2')
            ERKstarCa2PLA2[j,i] = sim.getCompConc('vsys', 'ERKstarCa2PLA2')             
            PP2ACa1PLA2star2[j,i] = sim.getCompConc('vsys', 'PP2ACa1PLA2star2')
            PP2ACa2PLA2star2[j,i] = sim.getCompConc('vsys', 'PP2ACa2PLA2star2')
            PP1Ca1PLA2star2[j,i] = sim.getCompConc('vsys', 'PP1Ca1PLA2star2')
            PP1Ca2PLA2star2[j,i] = sim.getCompConc('vsys', 'PP1Ca2PLA2star2')
            PLA2star2membAPC[j,i] = sim.getPatchCount('memb', 'PLA2star2membAPC')
            Ca1PLA2star2membAPC[j,i] = sim.getPatchCount('memb', 'Ca1PLA2star2membAPC')
            Ca2PLA2star2membAPC[j,i] = sim.getPatchCount('memb', 'Ca2PLA2star2membAPC')
            Ca1PMCA[j,i] = sim.getPatchCount('memb', 'Ca1PMCA')
            PMCA[j,i] = sim.getPatchCount('memb', 'PMCA')
            NCX[j,i] = sim.getPatchCount('memb', 'NCX')
            Ca1NCX[j,i] = sim.getPatchCount('memb', 'Ca1NCX')
            Ca2NCX[j,i] = sim.getPatchCount('memb', 'Ca2NCX')
            SERCA[j,i] = sim.getPatchCount('ERmemb', 'SERCA')
            Ca1SERCA[j,i] = sim.getPatchCount('ERmemb', 'Ca1SERCA')
            Ca2SERCA[j,i] = sim.getPatchCount('ERmemb', 'Ca2SERCA')
            PP1PLA2star2[j,i] = sim.getCompConc('vsys', 'PP1PLA2star2')
            AMPAR[j,i] = sim.getPatchCount('memb', 'AMPAR')  
            AMPAR_P[j,i] = sim.getPatchCount('memb', 'AMPAR_P') 
            PP2AAMPAR_P[j,i] = sim.getPatchCount('memb', 'PP2AAMPAR_P')
            AMPARextra[j,i] = sim.getPatchCount('memb', 'AMPARextra')
            AMPARextra_P[j,i] = sim.getPatchCount('memb', 'AMPARextra_P')
            PP2AAMPARextra_P[j,i] = sim.getPatchCount('memb', 'PP2AAMPARextra_P')
            GRIP[j,i] = sim.getPatchCount('memb', 'GRIP')
            GRIPAMPAR[j,i] = sim.getPatchCount('memb', 'GRIPAMPAR')
            GRIPAMPAR_P[j,i] = sim.getPatchCount('memb', 'GRIPAMPAR_P')
            PKCstarAMPAR[j,i] = sim.getPatchCount('memb', 'PKCstarAMPAR')  
            PKCstar2AMPAR[j,i] = sim.getPatchCount('memb', 'PKCstar2AMPAR') 
            PKCstar3AMPAR[j,i] = sim.getPatchCount('memb', 'PKCstar3AMPAR') 
            PKCstar4AMPAR[j,i] = sim.getPatchCount('memb', 'PKCstar4AMPAR')   
            AMPARdend[j,i] = sim.getPatchCount('memb', 'AMPARdend')
            AMPARdend_P[j,i] = sim.getPatchCount('memb', 'AMPARdend_P')
            PP2AAMPARdend_P[j,i] = sim.getPatchCount('memb', 'PP2AAMPARdend_P')
            AMPARcyt[j,i] = sim.getCompCount('vsys','AMPARcyt')
            AMPARcyt_P[j,i] = sim.getCompCount('vsys', 'AMPARcyt_P')
            PP2AAMPARcyt_P[j,i] = sim.getCompCount('vsys', 'PP2AAMPARcyt_P')
            PKCstarGRIPAMPAR[j,i] =  sim.getPatchCount('memb', 'PKCstarGRIPAMPAR')
            PKCstar2GRIPAMPAR[j,i] =  sim.getPatchCount('memb', 'PKCstar2GRIPAMPAR')
            PKCstar4GRIPAMPAR[j,i]  = sim.getPatchCount('memb', 'PKCstar4GRIPAMPAR')
            PKCstar3GRIPAMPAR[j,i] = sim.getPatchCount('memb', 'PKCstar3GRIPAMPAR')
            PP2AGRIPAMPAR_P[j,i] = sim.getPatchCount('memb', 'PP2AGRIPAMPAR_P')
            cAMP_PDE1[j,i] = sim.getCompCount('vsys','cAMP_PDE1')
            PDE1[j,i] = sim.getCompCount('vsys','PDE1')
            cGMP[j,i] = sim.getCompCount('vsys','cGMP')
            CaM3Ca_PDE1[j,i] = sim.getCompCount('vsys','CaM3Ca_PDE1')
            C_actPKA[j,i] = sim.getCompCount('vsys','C_actPKA')
            cAMP[j,i] = sim.getCompCount('vsys','cAMP')
            PKG[j,i] = sim.getCompCount('vsys','PKG')
            PP1_DARPP32[j,i] = sim.getCompCount('vsys','PP1_DARPP32')
            PP1[j,i]= sim.getCompConc('vsys', 'PP1')
            PP2A[j,i]= sim.getCompConc('vsys', 'PP2A')
            CaMKII_s1_s2_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3_s4')
            CaMKII_s1CaM3Ca_s2_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2_s3_s4')
            CaMKII_s1_s2CaM3Ca_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3_s4')
            CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4')
            CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4')
            CaMKII_s1p_s2CaM3Ca_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2CaM3Ca_s3_s4')
            CaMKII_s1CaM3Ca_s2p_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2p_s3_s4')
            CaMKII_s1p_s2_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2_s3_s4')
            CaMKII_s1_s2p_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3_s4')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4')
            CaMKII_s1p_s2pCaM3Ca_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3_s4')
            CaMKII_s1pCaM3Ca_s2p_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3_s4')
            CaMKII_s1p_s2p_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3_s4')
            CaMKII_s1_s2pCaM3Ca_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3_s4')
            CaMKII_s1pCaM3Ca_s2_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3_s4')
            CaMKII_s1pp_s2_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2_s3_s4')
            CaMKII_s1_s2pp_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3_s4')
            CaMKII_s1pp_s2p_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3_s4')
            CaMKII_s1p_s2pp_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3_s4')
            CaMKII_s1pp_s2pCaM3Ca_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3_s4')
            CaMKII_s1pCaM3Ca_s2pp_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3_s4')
            CaMKII_s1pp_s2CaM3Ca_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2CaM3Ca_s3_s4')
            CaMKII_s1CaM3Ca_s2pp_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pp_s3_s4')
            CaMKII_s1pp_s2pp_s3_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3_s4')
            CaMKII_s1_s2_s3CaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3CaM3Ca_s4')
            CaMKII_s1_s2_s3_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3_s4CaM3Ca')
            CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca')
            CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4')
            CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4')
            CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4')
            CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4')
            CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca')
            CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca')
            CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4')
            CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca')
            CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4')
            CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp')
            CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp')
            CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp')
            CaMKII_s1p_s2p_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3pp_s4pp')
            CaMKII_s1p_s2pp_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3pp_s4pp')
            CaMKII_s1pp_s2pp_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3pp_s4pp')
            CaMKII_s1pp_s2p_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3pp_s4pp')
            CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3pp_s4pp')
            CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp')
            CaMKII_s1pCaM3Ca_s2p_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3p_s4pp')
            CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp')
            CaMKII_s1p_s2pp_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3p_s4pp')
            CaMKII_s1pp_s2pp_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3p_s4pp')
            CaMKII_s1p_s2p_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3p_s4pp')
            CaMKII_s1pp_s2p_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3p_s4pp')
            CaMKII_s1p_s2pCaM3Ca_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3p_s4pp')
            CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp')
            CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp')
            CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp')
            CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp')
            CaMKII_s1p_s2p_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3pCaM3Ca_s4pp')
            CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp')
            CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp')
            CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp')
            CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p')
            CaMKII_s1pCaM3Ca_s2p_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3pp_s4p')
            CaMKII_s1p_s2pCaM3Ca_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3pp_s4p')
            CaMKII_s1p_s2p_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3pp_s4p')
            CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p')
            CaMKII_s1p_s2pp_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3pp_s4p')
            CaMKII_s1pp_s2p_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3pp_s4p')
            CaMKII_s1pp_s2pp_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3pp_s4p')
            CaMKII_s1pCaM3Ca_s2p_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3p_s4p')
            CaMKII_s1pCaM3Ca_s2pp_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3p_s4p')
            CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p')
            CaMKII_s1p_s2pp_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3p_s4p')
            CaMKII_s1pp_s2pp_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3p_s4p')
            CaMKII_s1p_s2p_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3p_s4p')
            CaMKII_s1pp_s2p_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3p_s4p')
            CaMKII_s1p_s2pCaM3Ca_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3p_s4p')
            CaMKII_s1pp_s2pCaM3Ca_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3p_s4p')
            CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p')
            CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p')
            CaMKII_s1p_s2p_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3pCaM3Ca_s4p')
            CaMKII_s1p_s2pp_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3pCaM3Ca_s4p')
            CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p')
            CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p')
            CaMKII_s1pp_s2p_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3pCaM3Ca_s4p')
            CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca')
            CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca')
            CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca')
            CaMKII_s1p_s2p_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3pp_s4pCaM3Ca')
            CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca')
            CaMKII_s1p_s2pp_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3p_s4pCaM3Ca')
            CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca')
            CaMKII_s1p_s2p_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3p_s4pCaM3Ca')
            CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca')
            CaMKII_s1pp_s2p_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3p_s4pCaM3Ca')
            CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca')
            CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca')
            CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4p')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp')
            CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pp')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pp')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pp')
            CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pp')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pp')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pp')
            CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pp')
            CaMKII_s1CaM3Ca_s2p_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2p_s3pp_s4pp')
            CaMKII_s1pCaM3Ca_s2_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3pp_s4pp')
            CaMKII_s1CaM3Ca_s2pp_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pp_s3pp_s4pp')
            CaMKII_s1_s2p_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3pp_s4pp')
            CaMKII_s1p_s2_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2_s3pp_s4pp')
            CaMKII_s1_s2pp_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3pp_s4pp')
            CaMKII_s1_s2pCaM3Ca_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3pp_s4pp')
            CaMKII_s1p_s2CaM3Ca_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2CaM3Ca_s3pp_s4pp')
            CaMKII_s1pp_s2CaM3Ca_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2CaM3Ca_s3pp_s4pp')
            CaMKII_s1CaM3Ca_s2p_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2p_s3p_s4pp')
            CaMKII_s1pCaM3Ca_s2_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3p_s4pp')
            CaMKII_s1pCaM3Ca_s2p_s3_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3_s4pp')
            CaMKII_s1CaM3Ca_s2pp_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pp_s3p_s4pp')
            CaMKII_s1pCaM3Ca_s2pp_s3_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3_s4pp')
            CaMKII_s1_s2pp_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3p_s4pp')
            CaMKII_s1p_s2pp_s3_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3_s4pp')
            CaMKII_s1pp_s2pp_s3_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3_s4pp')
            CaMKII_s1_s2p_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3p_s4pp')
            CaMKII_s1p_s2_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2_s3p_s4pp')
            CaMKII_s1p_s2p_s3_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3_s4pp')
            CaMKII_s1pp_s2_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2_s3p_s4pp')
            CaMKII_s1pp_s2p_s3_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3_s4pp')
            CaMKII_s1_s2pCaM3Ca_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3p_s4pp')
            CaMKII_s1p_s2CaM3Ca_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2CaM3Ca_s3p_s4pp')
            CaMKII_s1p_s2pCaM3Ca_s3_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3_s4pp')
            CaMKII_s1pp_s2CaM3Ca_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2CaM3Ca_s3p_s4pp')
            CaMKII_s1pp_s2pCaM3Ca_s3_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3_s4pp')
            CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pp')
            CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pp')
            CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pp')
            CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pp')
            CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pp')
            CaMKII_s1_s2pp_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3pCaM3Ca_s4pp')
            CaMKII_s1p_s2pp_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3CaM3Ca_s4pp')
            CaMKII_s1_s2p_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3pCaM3Ca_s4pp')
            CaMKII_s1p_s2_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2_s3pCaM3Ca_s4pp')
            CaMKII_s1p_s2p_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3CaM3Ca_s4pp')
            CaMKII_s1pp_s2_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2_s3pCaM3Ca_s4pp')
            CaMKII_s1pp_s2p_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3CaM3Ca_s4pp')
            CaMKII_s1pp_s2pp_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3CaM3Ca_s4pp')
            CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp')
            CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pp')
            CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pp')
            CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pp')
            CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pp')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4p')
            CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4p')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4p')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4p')
            CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4p')
            CaMKII_s1CaM3Ca_s2p_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2p_s3pp_s4p')
            CaMKII_s1pCaM3Ca_s2_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3pp_s4p')
            CaMKII_s1pCaM3Ca_s2p_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3pp_s4')
            CaMKII_s1_s2pCaM3Ca_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3pp_s4p')
            CaMKII_s1p_s2CaM3Ca_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2CaM3Ca_s3pp_s4p')
            CaMKII_s1p_s2pCaM3Ca_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3pp_s4')
            CaMKII_s1_s2p_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3pp_s4p')
            CaMKII_s1p_s2_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2_s3pp_s4p')
            CaMKII_s1p_s2p_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3pp_s4')
            CaMKII_s1pp_s2CaM3Ca_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2CaM3Ca_s3pp_s4p')
            CaMKII_s1pp_s2pCaM3Ca_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3pp_s4')
            CaMKII_s1_s2pp_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3pp_s4p')
            CaMKII_s1p_s2pp_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3pp_s4')
            CaMKII_s1pp_s2_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2_s3pp_s4p')
            CaMKII_s1pp_s2p_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3pp_s4')
            CaMKII_s1pp_s2pp_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3pp_s4')
            CaMKII_s1CaM3Ca_s2p_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2p_s3p_s4p')
            CaMKII_s1pCaM3Ca_s2_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3p_s4p')
            CaMKII_s1pCaM3Ca_s2p_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3_s4p')
            CaMKII_s1pCaM3Ca_s2p_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3p_s4')
            CaMKII_s1CaM3Ca_s2pp_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pp_s3p_s4p')
            CaMKII_s1pCaM3Ca_s2pp_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3_s4p')
            CaMKII_s1pCaM3Ca_s2pp_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3p_s4')
            CaMKII_s1CaM3Ca_s2pp_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pp_s3pp_s4p')
            CaMKII_s1pCaM3Ca_s2pp_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3pp_s4')
            CaMKII_s1_s2pp_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3p_s4p')
            CaMKII_s1p_s2pp_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3_s4p')
            CaMKII_s1p_s2pp_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3p_s4')
            CaMKII_s1pp_s2pp_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3_s4p')
            CaMKII_s1pp_s2pp_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3p_s4')
            CaMKII_s1_s2p_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3p_s4p')
            CaMKII_s1p_s2_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2_s3p_s4p')
            CaMKII_s1p_s2p_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3_s4p')
            CaMKII_s1p_s2p_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3p_s4')
            CaMKII_s1pp_s2_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2_s3p_s4p')
            CaMKII_s1pp_s2p_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3_s4p')
            CaMKII_s1pp_s2p_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3p_s4')
            CaMKII_s1_s2pCaM3Ca_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3p_s4p')
            CaMKII_s1p_s2CaM3Ca_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2CaM3Ca_s3p_s4p')
            CaMKII_s1p_s2pCaM3Ca_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3_s4p')
            CaMKII_s1p_s2pCaM3Ca_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3p_s4')
            CaMKII_s1pp_s2CaM3Ca_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2CaM3Ca_s3p_s4p')
            CaMKII_s1pp_s2pCaM3Ca_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3_s4p')
            CaMKII_s1pp_s2pCaM3Ca_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3p_s4')
            CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4p')
            CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4p')
            CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4p')
            CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4')
            CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4p')
            CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4p')
            CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4')
            CaMKII_s1_s2p_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3pCaM3Ca_s4p')
            CaMKII_s1p_s2_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2_s3pCaM3Ca_s4p')
            CaMKII_s1p_s2p_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3CaM3Ca_s4p')
            CaMKII_s1p_s2p_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3pCaM3Ca_s4')
            CaMKII_s1_s2pp_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3pCaM3Ca_s4p')
            CaMKII_s1p_s2pp_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3CaM3Ca_s4p')
            CaMKII_s1p_s2pp_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3pCaM3Ca_s4')
            CaMKII_s1pp_s2pp_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3CaM3Ca_s4p')
            CaMKII_s1pp_s2pp_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3pCaM3Ca_s4')
            CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4p')
            CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4p')
            CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4p')
            CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4')
            CaMKII_s1pp_s2_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2_s3pCaM3Ca_s4p')
            CaMKII_s1pp_s2p_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3CaM3Ca_s4p')
            CaMKII_s1pp_s2p_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3pCaM3Ca_s4')
            CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4p')
            CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4p')
            CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2p_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2p_s3pp_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3pp_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2p_s3pp_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3pp_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2pp_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pp_s3pp_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pp_s3pp_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3pp_s4CaM3Ca')
            CaMKII_s1_s2pp_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3pp_s4pCaM3Ca')
            CaMKII_s1p_s2pp_s3pp_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3pp_s4CaM3Ca')
            CaMKII_s1pp_s2pp_s3pp_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3pp_s4CaM3Ca')
            CaMKII_s1_s2p_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3pp_s4pCaM3Ca')
            CaMKII_s1p_s2_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2_s3pp_s4pCaM3Ca')
            CaMKII_s1p_s2p_s3pp_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3pp_s4CaM3Ca')
            CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3pp_s4pCaM3Ca')
            CaMKII_s1p_s2CaM3Ca_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2CaM3Ca_s3pp_s4pCaM3Ca')
            CaMKII_s1p_s2pCaM3Ca_s3pp_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3pp_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2p_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2p_s3p_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3p_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2p_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2p_s3p_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3p_s4CaM3Ca')
            CaMKII_s1_s2pp_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3p_s4pCaM3Ca')
            CaMKII_s1p_s2pp_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3_s4pCaM3Ca')
            CaMKII_s1p_s2pp_s3p_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3p_s4CaM3Ca')
            CaMKII_s1pp_s2pp_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3_s4pCaM3Ca')
            CaMKII_s1pp_s2pp_s3p_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3p_s4CaM3Ca')
            CaMKII_s1_s2p_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3p_s4pCaM3Ca')
            CaMKII_s1p_s2_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2_s3p_s4pCaM3Ca')
            CaMKII_s1p_s2p_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3_s4pCaM3Ca')
            CaMKII_s1p_s2p_s3p_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3p_s4CaM3Ca')
            CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3p_s4pCaM3Ca')
            CaMKII_s1p_s2CaM3Ca_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2CaM3Ca_s3p_s4pCaM3Ca')
            CaMKII_s1p_s2pCaM3Ca_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3_s4pCaM3Ca')
            CaMKII_s1p_s2pCaM3Ca_s3p_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3p_s4CaM3Ca')
            CaMKII_s1pp_s2_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2_s3p_s4pCaM3Ca')
            CaMKII_s1pp_s2p_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3_s4pCaM3Ca')
            CaMKII_s1pp_s2p_s3p_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3p_s4CaM3Ca')
            CaMKII_s1pp_s2CaM3Ca_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2CaM3Ca_s3p_s4pCaM3Ca')
            CaMKII_s1pp_s2pCaM3Ca_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3_s4pCaM3Ca')
            CaMKII_s1pp_s2pCaM3Ca_s3p_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3p_s4CaM3Ca')
            CaMKII_s1pp_s2CaM3Ca_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2CaM3Ca_s3pp_s4pCaM3Ca')
            CaMKII_s1pp_s2pCaM3Ca_s3pp_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3pp_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1p_s2pp_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1p_s2pp_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pp_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1pp_s2pp_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1pp_s2pp_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pp_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1p_s2_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1p_s2p_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1p_s2p_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2p_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1pp_s2_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pp_s2p_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1pp_s2p_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4CaM3Ca')
            CaMKII_s1pp_s2_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2_s3pp_s4pCaM3Ca')
            CaMKII_s1pp_s2p_s3pp_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pp_s2p_s3pp_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2pp_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2pp_s3p_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pp_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2pp_s3p_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2pp_s3p_s4CaM3Ca')
            CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca')
            CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4p')
            CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4p')
            CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4pp')
            CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pp')
            CaMKII_s1_s2CaM3Ca_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3pp_s4pp')
            CaMKII_s1_s2p_s3_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3_s4pp')
            CaMKII_s1_s2pp_s3_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3_s4pp')
            CaMKII_s1_s2p_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3CaM3Ca_s4pp')
            CaMKII_s1_s2pp_s3CaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3CaM3Ca_s4pp')
            CaMKII_s1_s2pCaM3Ca_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3_s4p')
            CaMKII_s1_s2CaM3Ca_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3p_s4p')
            CaMKII_s1_s2CaM3Ca_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3pp_s4p')
            CaMKII_s1_s2p_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3_s4p')
            CaMKII_s1_s2pp_s3_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3_s4p')
            CaMKII_s1_s2p_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3CaM3Ca_s4p')
            CaMKII_s1_s2pp_s3CaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3CaM3Ca_s4p')
            CaMKII_s1_s2pCaM3Ca_s3p_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3p_s4CaM3Ca')
            CaMKII_s1_s2pCaM3Ca_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3_s4pCaM3Ca')
            CaMKII_s1_s2CaM3Ca_s3p_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3p_s4pCaM3Ca')
            CaMKII_s1_s2pCaM3Ca_s3pp_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3pp_s4CaM3Ca')
            CaMKII_s1_s2CaM3Ca_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3pp_s4pCaM3Ca')
            CaMKII_s1_s2p_s3pp_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3pp_s4CaM3Ca')
            CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1_s2pp_s3p_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3p_s4CaM3Ca')
            CaMKII_s1_s2pp_s3_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3_s4pCaM3Ca')
            CaMKII_s1_s2pp_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1_s2pp_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca')
            CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4CaM3Ca')
            CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca')
            CaMKII_s1_s2_s3pp_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3pp_s4pp')
            CaMKII_s1_s2_s3p_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3p_s4pp')
            CaMKII_s1_s2_s3pCaM3Ca_s4pp[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3pCaM3Ca_s4pp')
            CaMKII_s1_s2pCaM3Ca_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3p_s4')
            CaMKII_s1_s2pCaM3Ca_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3pp_s4')
            CaMKII_s1_s2pCaM3Ca_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pCaM3Ca_s3pp_s4')
            CaMKII_s1_s2p_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3pp_s4')
            CaMKII_s1_s2_s3pp_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3pp_s4p')
            CaMKII_s1_s2p_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3p_s4')
            CaMKII_s1_s2_s3p_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3p_s4p')
            CaMKII_s1_s2pp_s3p_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3p_s4')
            CaMKII_s1_s2pp_s3pp_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3pp_s4')
            CaMKII_s1_s2p_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2p_s3pCaM3Ca_s4')
            CaMKII_s1_s2_s3pCaM3Ca_s4p[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3pCaM3Ca_s4p')
            CaMKII_s1_s2pp_s3pCaM3Ca_s4[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2pp_s3pCaM3Ca_s4')
            CaMKII_s1_s2_s3pp_s4pCaM3Ca[j,i]= sim.getCompConc('vsys', 'CaMKII_s1_s2_s3pp_s4pCaM3Ca')
            
            sim.setCompReacK('vsys', 'Cainflux', square_pulse_ica(tpnts[i])) # changes reaction constant to be ...
    
#############################################################################
    #Save data
    #Calcium input
    Ca_mean=mean(Ca,axis=0)
    np.savetxt('Ca_mean.txt',Ca_mean)
    
    #AMPA receptors
    AMPAR_mean = mean(AMPAR, axis=0)
    AMPAR_P_mean = mean(AMPAR_P, axis=0)
    PP2AAMPAR_P_mean = mean(PP2AAMPAR_P, axis=0)
    GRIPAMPAR_mean = mean(GRIPAMPAR, axis=0)
    GRIPAMPAR_P_mean = mean(GRIPAMPAR_P, axis=0)
    PKCstarAMPAR_mean = mean(PKCstarAMPAR, axis=0)
    PKCstar2AMPAR_mean = mean(PKCstar2AMPAR, axis=0)
    PKCstar3AMPAR_mean = mean(PKCstar3AMPAR, axis=0)
    PKCstar4AMPAR_mean = mean(PKCstar4AMPAR, axis=0)
    PKCstarGRIPAMPAR_mean = mean(PKCstarGRIPAMPAR, axis=0)
    PKCstar2GRIPAMPAR_mean = mean(PKCstar2GRIPAMPAR, axis=0)
    PKCstar3GRIPAMPAR_mean = mean(PKCstar3GRIPAMPAR, axis=0)
    PKCstar4GRIPAMPAR_mean = mean(PKCstar4GRIPAMPAR, axis=0)
    PP2AGRIPAMPAR_P_mean = mean(PP2AGRIPAMPAR_P, axis=0)

    AMPAR_syn_mean = AMPAR_mean + AMPAR_P_mean + PP2AAMPAR_P_mean + \
                    GRIPAMPAR_mean + GRIPAMPAR_P_mean + PKCstarAMPAR_mean + \
                    PKCstar2AMPAR_mean + PKCstar3AMPAR_mean + PKCstar4AMPAR_mean +\
                    PKCstarGRIPAMPAR_mean + PKCstar2GRIPAMPAR_mean + PKCstar3GRIPAMPAR_mean +\
                    PKCstar4GRIPAMPAR_mean + PP2AGRIPAMPAR_P_mean;

    np.savetxt('AMPAR_mean.txt',AMPAR_syn_mean)


    #PKC activity
    PKCstar_mean = mean(PKCstar, axis=0)
    PKCstar2_mean = mean(PKCstar2, axis=0)
    PKCstar3_mean = mean(PKCstar3, axis=0)
    PKCstar4_mean = mean(PKCstar4, axis=0)
    RafRKIPPKCstar_mean = mean(RafRKIPPKCstar, axis=0)
    RafRKIPPKCstar2_mean = mean(RafRKIPPKCstar2, axis=0)
    RafRKIPPKCstar3_mean = mean(RafRKIPPKCstar3, axis=0)
    RafRKIPPKCstar4_mean = mean(RafRKIPPKCstar4, axis=0)
    PKCstarAMPAR_mean = mean(PKCstarAMPAR, axis=0)
    PKCstar2AMPAR_mean = mean(PKCstar2AMPAR, axis=0)
    PKCstar3AMPAR_mean = mean(PKCstar3AMPAR, axis=0)
    PKCstar4AMPAR_mean = mean(PKCstar4AMPAR, axis=0)

    MEKRKIPPKCstar_mean = mean(MEKRKIPPKCstar, axis=0)
    MEKRKIPPKCstar2_mean = mean(MEKRKIPPKCstar2, axis=0)
    MEKRKIPPKCstar3_mean = mean(MEKRKIPPKCstar3, axis=0)
    MEKRKIPPKCstar4_mean = mean(MEKRKIPPKCstar4, axis=0)
        
    PKC_mean = PKCstar_mean + PKCstar2_mean + PKCstar3_mean + PKCstar4_mean + \
            RafRKIPPKCstar_mean + RafRKIPPKCstar2_mean + RafRKIPPKCstar3_mean + \
                RafRKIPPKCstar4_mean + PKCstarAMPAR_mean + PKCstar2AMPAR_mean + \
                    PKCstar3AMPAR_mean + PKCstar4AMPAR_mean + \
                        MEKRKIPPKCstar_mean + MEKRKIPPKCstar2_mean + MEKRKIPPKCstar3_mean + MEKRKIPPKCstar4_mean;

    np.savetxt('PKC_mean.txt',PKC_mean)


    #ERK activity
    ERKstar_mean = mean(ERKstar, axis=0)
    MKPERKstar_mean = mean(MKPERKstar, axis=0)
    ERKstarPLA2_mean = mean(ERKstarPLA2, axis=0)
    ERKstarCa1PLA2_mean = mean(ERKstarCa1PLA2, axis=0)
    ERKstarCa2PLA2_mean = mean(ERKstarCa2PLA2, axis=0)
    ERKp_mean = mean(ERKp, axis=0)
    MKPERKp_mean = mean(MKPERKp, axis=0)
    MEKstarERKp_mean = mean(MEKstarERKp, axis=0)
    ERK_total_m = ERKstar_mean + MKPERKstar_mean + ERKstarPLA2_mean + ERKstarCa1PLA2_mean + ERKstarCa2PLA2_mean + \
    ERKp_mean + MKPERKp_mean + MEKstarERKp_mean;
    
    np.savetxt('ERK_mean.txt',ERK_total_m)

    #MEK activity
    MEKp_mean= mean(MEKp, axis=0)
    PP2AMEKp_mean= mean(PP2AMEKp, axis=0)
    RafstarMEKp_mean= mean(RafstarMEKp, axis=0)
    MEKstar_mean= mean(MEKstar, axis=0)
    MEKstarERK_mean= mean(MEKstarERK, axis=0)
    MEKstarERKp_mean= mean(MEKstarERKp, axis=0)
    PP2AMEKstar_mean = mean(PP2AMEKstar, axis=0)
    MEK_total_m = MEKp_mean + PP2AMEKp_mean + RafstarMEKp_mean + \
    MEKstar_mean + MEKstarERK_mean + MEKstarERKp_mean + PP2AMEKstar_mean
    MEKstar_total_m = MEKstar_mean + MEKstarERK_mean + MEKstarERKp_mean + PP2AMEKstar_mean
    MEKp_total_m = MEKp_mean + PP2AMEKp_mean + RafstarMEKp_mean
    
    np.savetxt('MEK_mean.txt',MEKp_total_m)

    #PLA2 activity
    PLA2star1_mean = mean(PLA2star1, axis=0)
    PLA2star1APC_mean = mean(PLA2star1APC, axis=0)
    PLA2star2_mean = mean(PLA2star2, axis=0)
    PLA2star2memb_mean = mean(PLA2star2memb, axis=0)
    PLA2star2membAPC_mean = mean(PLA2star2membAPC, axis=0)
    Ca1PLA2star2_mean = mean(Ca1PLA2star2, axis=0)
    Ca2PLA2star2_mean = mean(Ca2PLA2star2, axis=0)
    Ca1PLA2star2memb_mean = mean(Ca1PLA2star2memb, axis=0)
    Ca2PLA2star2memb_mean = mean(Ca2PLA2star2memb, axis=0)
    Ca1PLA2star2membAPC_mean = mean(Ca1PLA2star2membAPC, axis=0)
    Ca2PLA2star2membAPC_mean = mean(Ca2PLA2star2membAPC, axis=0)
    PP1PLA2star2_mean = mean(PP1PLA2star2, axis=0)
    PP1Ca1PLA2star2_mean = mean(PP1Ca1PLA2star2, axis=0)
    PP1Ca2PLA2star2_mean = mean(PP1Ca2PLA2star2, axis=0)
    PP2APLA2star2_mean = mean(PP1PLA2star2, axis=0)
    PP2ACa1PLA2star2_mean = mean(PP2ACa1PLA2star2, axis=0)
    PP2ACa2PLA2star2_mean = mean(PP2ACa2PLA2star2, axis=0)
    
    PLA2_mean = PLA2star1_mean + PLA2star1APC_mean + PLA2star2_mean + \
                PLA2star2memb_mean + PLA2star2membAPC_mean + \
                Ca1PLA2star2_mean + Ca2PLA2star2_mean + Ca1PLA2star2memb_mean + \
                Ca2PLA2star2memb_mean + Ca1PLA2star2membAPC_mean + Ca2PLA2star2membAPC_mean + \
                PP1PLA2star2_mean + PP1Ca1PLA2star2_mean + PP1Ca2PLA2star2_mean + \
                PP2APLA2star2_mean + PP2ACa1PLA2star2_mean + PP2ACa2PLA2star2_mean

    np.savetxt('PLA2_mean.txt', PLA2_mean)

    ##CaMKII activity
    CaMKII_mean= CaMKII_s1CaM3Ca_s2_s3CaM3Ca_s4CaM3Ca+CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4CaM3Ca+CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca+CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4+CaMKII_s1CaM3Ca_s2CaM3Ca_s3CaM3Ca_s4CaM3Ca+\
                    CaMKII_s1CaM3Ca_s2_s3_s4 + CaMKII_s1_s2CaM3Ca_s3_s4 +  CaMKII_s1CaM3Ca_s2CaM3Ca_s3_s4 +  CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4 + CaMKII_s1CaM3Ca_s2pCaM3Ca_s3_s4 + CaMKII_s1p_s2CaM3Ca_s3_s4 +\
                    CaMKII_s1CaM3Ca_s2p_s3_s4 +  CaMKII_s1p_s2_s3_s4 +  CaMKII_s1_s2p_s3_s4  +  CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4  + CaMKII_s1p_s2pCaM3Ca_s3_s4 +  CaMKII_s1pCaM3Ca_s2p_s3_s4 + CaMKII_s1p_s2p_s3_s4 +\
                    CaMKII_s1_s2pCaM3Ca_s3_s4 + CaMKII_s1pCaM3Ca_s2_s3_s4 + CaMKII_s1pp_s2_s3_s4 +  CaMKII_s1_s2pp_s3_s4 +  CaMKII_s1pp_s2p_s3_s4 +  CaMKII_s1p_s2pp_s3_s4  +  CaMKII_s1pp_s2pCaM3Ca_s3_s4 +\
                    CaMKII_s1pCaM3Ca_s2pp_s3_s4 +  CaMKII_s1pp_s2CaM3Ca_s3_s4 +  CaMKII_s1CaM3Ca_s2pp_s3_s4 + CaMKII_s1pp_s2pp_s3_s4+\
                    CaMKII_s1_s2_s3CaM3Ca_s4+CaMKII_s1_s2_s3_s4CaM3Ca+CaMKII_s1_s2_s3CaM3Ca_s4CaM3Ca+CaMKII_s1_s2_s3pCaM3Ca_s4CaM3Ca+CaMKII_s1_s2_s3CaM3Ca_s4pCaM3Ca+CaMKII_s1_s2_s3pCaM3Ca_s4pCaM3Ca+\
                    CaMKII_s1_s2CaM3Ca_s3CaM3Ca_s4+CaMKII_s1_s2pCaM3Ca_s3CaM3Ca_s4+CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4+CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4+\
                    CaMKII_s1CaM3Ca_s2_s3_s4CaM3Ca+CaMKII_s1pCaM3Ca_s2_s3_s4CaM3Ca+CaMKII_s1CaM3Ca_s2_s3_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2_s3_s4pCaM3Ca+\
                    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4CaM3Ca+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4CaM3Ca+\
                    CaMKII_s1CaM3Ca_s2_s3pCaM3Ca_s4pCaM3Ca+CaMKII_s1_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca+CaMKII_s1CaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca+\
                    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4+CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca+CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca+\
                    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2_s3CaM3Ca_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2CaM3Ca_s3CaM3Ca_s4pCaM3Ca+\
                    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4CaM3Ca+\
                    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca+\
                    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pp+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pp+\
                    CaMKII_s1pCaM3Ca_s2p_s3pp_s4pp+CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pp+CaMKII_s1p_s2p_s3pp_s4pp+CaMKII_s1p_s2pp_s3pp_s4pp+CaMKII_s1pp_s2pp_s3pp_s4pp+CaMKII_s1pp_s2p_s3pp_s4pp+\
                    CaMKII_s1p_s2pCaM3Ca_s3pp_s4pp+CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pp+CaMKII_s1pCaM3Ca_s2p_s3p_s4pp+CaMKII_s1pCaM3Ca_s2pp_s3p_s4pp+CaMKII_s1p_s2pp_s3p_s4pp+CaMKII_s1pp_s2pp_s3p_s4pp+\
                    CaMKII_s1p_s2p_s3p_s4pp+CaMKII_s1pp_s2p_s3p_s4pp+CaMKII_s1p_s2pCaM3Ca_s3p_s4pp+CaMKII_s1pp_s2pCaM3Ca_s3p_s4pp+\
                    CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pp+CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pp+CaMKII_s1p_s2pp_s3pCaM3Ca_s4pp+CaMKII_s1p_s2p_s3pCaM3Ca_s4pp+CaMKII_s1pp_s2p_s3pCaM3Ca_s4pp+CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pp+\
                    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pp+CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pp+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4p+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4p+CaMKII_s1pCaM3Ca_s2p_s3pp_s4p+\
                    CaMKII_s1p_s2pCaM3Ca_s3pp_s4p+CaMKII_s1p_s2p_s3pp_s4p+CaMKII_s1pp_s2pCaM3Ca_s3pp_s4p+CaMKII_s1p_s2pp_s3pp_s4p+CaMKII_s1pp_s2p_s3pp_s4p+CaMKII_s1pp_s2pp_s3pp_s4p+\
                    CaMKII_s1pCaM3Ca_s2p_s3p_s4p+CaMKII_s1pCaM3Ca_s2pp_s3p_s4p+CaMKII_s1pCaM3Ca_s2pp_s3pp_s4p+CaMKII_s1p_s2pp_s3p_s4p+CaMKII_s1pp_s2pp_s3p_s4p+CaMKII_s1p_s2p_s3p_s4p+\
                    CaMKII_s1pp_s2p_s3p_s4p+CaMKII_s1p_s2pCaM3Ca_s3p_s4p+CaMKII_s1pp_s2pCaM3Ca_s3p_s4p+CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4p+CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4p+CaMKII_s1p_s2p_s3pCaM3Ca_s4p+\
                    CaMKII_s1p_s2pp_s3pCaM3Ca_s4p+CaMKII_s1pp_s2pp_s3pCaM3Ca_s4p+CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4p+CaMKII_s1pp_s2p_s3pCaM3Ca_s4p+CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4p+\
                    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pp_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2p_s3pp_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2pp_s3pp_s4pCaM3Ca+CaMKII_s1p_s2pp_s3pp_s4pCaM3Ca+CaMKII_s1pp_s2pp_s3pp_s4pCaM3Ca+\
                    CaMKII_s1p_s2p_s3pp_s4pCaM3Ca+CaMKII_s1p_s2pCaM3Ca_s3pp_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2p_s3p_s4pCaM3Ca+CaMKII_s1p_s2pp_s3p_s4pCaM3Ca+CaMKII_s1pp_s2pp_s3p_s4pCaM3Ca+\
                    CaMKII_s1p_s2p_s3p_s4pCaM3Ca+CaMKII_s1p_s2pCaM3Ca_s3p_s4pCaM3Ca+CaMKII_s1pp_s2p_s3p_s4pCaM3Ca+CaMKII_s1pp_s2pCaM3Ca_s3p_s4pCaM3Ca+CaMKII_s1pp_s2pCaM3Ca_s3pp_s4pCaM3Ca+\
                    CaMKII_s1pCaM3Ca_s2pp_s3pCaM3Ca_s4pCaM3Ca+CaMKII_s1p_s2pp_s3pCaM3Ca_s4pCaM3Ca+CaMKII_s1pp_s2pp_s3pCaM3Ca_s4pCaM3Ca+CaMKII_s1p_s2p_s3pCaM3Ca_s4pCaM3Ca+CaMKII_s1pp_s2p_s3pCaM3Ca_s4pCaM3Ca+\
                    CaMKII_s1pp_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3p_s4pCaM3Ca+CaMKII_s1pp_s2p_s3pp_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2pp_s3p_s4pCaM3Ca+CaMKII_s1pCaM3Ca_s2p_s3pCaM3Ca_s4pCaM3Ca+\
                    CaMKII_s1p_s2pCaM3Ca_s3pCaM3Ca_s4pCaM3Ca+\
                    CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4p+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4p+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4+CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pCaM3Ca_s4pp+CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pCaM3Ca_s4pp+\
                    CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3CaM3Ca_s4pp+CaMKII_s1CaM3Ca_s2pCaM3Ca_s3p_s4pp+CaMKII_s1pCaM3Ca_s2CaM3Ca_s3p_s4pp+CaMKII_s1pCaM3Ca_s2pCaM3Ca_s3_s4pp+CaMKII_s1CaM3Ca_s2pCaM3Ca_s3pp_s4pp+\
                    CaMKII_s1pCaM3Ca_s2CaM3Ca_s3pp_s4pp+CaMKII_s1CaM3Ca_s2p_s3pp_s4pp+CaMKII_s1pCaM3Ca_s2_s3pp_s4pp+CaMKII_s1CaM3Ca_s2pp_s3pp_s4pp+CaMKII_s1_s2p_s3pp_s4pp+CaMKII_s1p_s2_s3pp_s4pp+CaMKII_s1_s2pp_s3pp_s4pp+\
                    CaMKII_s1_s2pCaM3Ca_s3pp_s4pp+CaMKII_s1p_s2CaM3Ca_s3pp_s4pp+CaMKII_s1pp_s2CaM3Ca_s3pp_s4pp+CaMKII_s1CaM3Ca_s2p_s3p_s4pp+CaMKII_s1pCaM3Ca_s2_s3p_s4pp+CaMKII_s1pCaM3Ca_s2p_s3_s4pp+CaMKII_s1CaM3Ca_s2pp_s3p_s4pp+\
                    CaMKII_s1pCaM3Ca_s2pp_s3_s4pp+CaMKII_s1_s2pp_s3p_s4pp+CaMKII_s1p_s2pp_s3_s4pp+CaMKII_s1pp_s2pp_s3_s4pp+CaMKII_s1_s2p_s3p_s4pp+CaMKII_s1p_s2_s3p_s4pp+CaMKII_s1p_s2p_s3_s4pp+CaMKII_s1pp_s2_s3p_s4pp+\
                    CaMKII_s1pp_s2p_s3_s4pp+CaMKII_s1_s2pCaM3Ca_s3p_s4pp+CaMKII_s1p_s2CaM3Ca_s3p_s4pp+CaMKII_s1p_s2pCaM3Ca_s3_s4pp+CaMKII_s1pp_s2CaM3Ca_s3p_s4pp+CaMKII_s1pp_s2pCaM3Ca_s3_s4pp+CaMKII_s1CaM3Ca_s2p_s3pCaM3Ca_s4pp+\
                    CaMKII_s1pCaM3Ca_s2_s3pCaM3Ca_s4pp+CaMKII_s1pCaM3Ca_s2p_s3CaM3Ca_s4pp+CaMKII_s1CaM3Ca_s2pp_s3pCaM3Ca_s4pp+CaMKII_s1pCaM3Ca_s2pp_s3CaM3Ca_s4pp+CaMKII_s1_s2pp_s3pCaM3Ca_s4pp+CaMKII_s1p_s2pp_s3CaM3Ca_s4pp+\
                    CaMKII_s1_s2p_s3pCaM3Ca_s4pp+CaMKII_s1p_s2_s3pCaM3Ca_s4pp+CaMKII_s1p_s2p_s3CaM3Ca_s4pp+CaMKII_s1pp_s2_s3pCaM3Ca_s4pp+CaMKII_s1pp_s2p_s3CaM3Ca_s4pp+CaMKII_s1pp_s2pp_s3CaM3Ca_s4pp+CaMKII_s1_s2pCaM3Ca_s3pCaM3Ca_s4pp+\
                    CaMKII_s1p_s2CaM3Ca_s3pCaM3