/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdf5lib;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDF5GroupInfo;
import ncsa.hdf.hdf5lib.HDFArray;
import ncsa.hdf.hdf5lib.callbacks.H5D_iterate_cb;
import ncsa.hdf.hdf5lib.callbacks.H5D_iterate_t;
import ncsa.hdf.hdf5lib.callbacks.H5L_iterate_cb;
import ncsa.hdf.hdf5lib.callbacks.H5L_iterate_t;
import ncsa.hdf.hdf5lib.callbacks.H5O_iterate_cb;
import ncsa.hdf.hdf5lib.callbacks.H5O_iterate_t;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.structs.H5AC_cache_config_t;
import ncsa.hdf.hdf5lib.structs.H5A_info_t;
import ncsa.hdf.hdf5lib.structs.H5G_info_t;
import ncsa.hdf.hdf5lib.structs.H5L_info_t;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;

public class H5
implements Serializable {
    private static final long serialVersionUID = 6129888282117053288L;
    public static final int[] LIB_VERSION = new int[]{1, 8, 8};
    public static final String H5PATH_PROPERTY_KEY = "ncsa.hdf.hdf5lib.H5.hdf5lib";
    public static final String H5_LIBRARY_NAME_PROPERTY_KEY = "ncsa.hdf.hdf5lib.H5.loadLibraryName";
    public static int LOGGING_LEVEL = 2;
    private static Logger s_logger;
    private static String s_libraryName;
    private static boolean isLibraryLoaded;
    private static final boolean IS_CRITICAL_PINNING = true;
    private static final Vector<Integer> OPEN_IDS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadH5Lib() {
        String filename;
        if (isLibraryLoaded) {
            return;
        }
        s_logger = Logger.getLogger("ncsa.hdf.hdf5lib");
        if (LOGGING_LEVEL == 2) {
            s_logger.setLevel(Level.SEVERE);
        } else if (LOGGING_LEVEL == 1) {
            s_logger.setLevel(Level.WARNING);
        } else {
            s_logger.setLevel(Level.INFO);
        }
        s_libraryName = System.getProperty(H5_LIBRARY_NAME_PROPERTY_KEY, null);
        String mappedName = null;
        if (s_libraryName != null && s_libraryName.length() > 0) {
            try {
                mappedName = System.mapLibraryName(s_libraryName);
                System.loadLibrary(s_libraryName);
                isLibraryLoaded = true;
                s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + mappedName + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
            }
            catch (Throwable err) {
                try {
                    err.printStackTrace();
                    isLibraryLoaded = false;
                    s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + mappedName + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                }
                catch (Throwable throwable) {
                    s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + mappedName + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                    throw throwable;
                }
            }
        }
        if (!isLibraryLoaded && (filename = System.getProperty(H5PATH_PROPERTY_KEY, null)) != null && filename.length() > 0) {
            File h5dll = new File(filename);
            if (h5dll.exists() && h5dll.canRead() && h5dll.isFile()) {
                try {
                    System.load(filename);
                    isLibraryLoaded = true;
                    s_logger.log(Level.INFO, "HDF5 library: " + filename + (isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                }
                catch (Throwable err) {
                    try {
                        err.printStackTrace();
                        isLibraryLoaded = false;
                        s_logger.log(Level.INFO, "HDF5 library: " + filename + (isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                    }
                    catch (Throwable throwable) {
                        s_logger.log(Level.INFO, "HDF5 library: " + filename + (isLibraryLoaded ? "" : " NOT") + " successfully loaded.");
                        throw throwable;
                    }
                }
            } else {
                isLibraryLoaded = false;
                throw new UnsatisfiedLinkError("Invalid HDF5 library, " + filename);
            }
        }
        if (!isLibraryLoaded) {
            try {
                s_libraryName = "jhdf5";
                mappedName = System.mapLibraryName(s_libraryName);
                System.loadLibrary("jhdf5");
                isLibraryLoaded = true;
                s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + mappedName + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
            }
            catch (Throwable err) {
                try {
                    err.printStackTrace();
                    isLibraryLoaded = false;
                    s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + mappedName + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                }
                catch (Throwable throwable) {
                    s_logger.log(Level.INFO, "HDF5 library: " + s_libraryName + " resolved to: " + mappedName + "; " + (isLibraryLoaded ? "" : " NOT") + " successfully loaded from java.library.path");
                    throw throwable;
                }
            }
        }
        try {
            H5.H5dont_atexit();
        }
        catch (HDF5LibraryException e) {
            System.exit(1);
        }
        H5.H5error_off();
        Integer majnum = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5maj", null);
        Integer minnum = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5min", null);
        Integer relnum = Integer.getInteger("ncsa.hdf.hdf5lib.H5.hdf5rel", null);
        if (majnum != null && minnum != null && relnum != null) {
            H5.H5check_version(majnum, minnum, relnum);
        }
    }

    public static final int getOpenIDCount() {
        return OPEN_IDS.size();
    }

    public static final int getOpenID(int index) {
        int id = -1;
        if (index >= 0 && index < OPEN_IDS.size()) {
            id = OPEN_IDS.elementAt(index);
        }
        return id;
    }

    public static synchronized native int H5check_version(int var0, int var1, int var2);

    public static synchronized native int H5close() throws HDF5LibraryException;

    public static synchronized native int H5open() throws HDF5LibraryException;

    private static synchronized native int H5dont_atexit() throws HDF5LibraryException;

    public static synchronized native int H5error_off();

    public static synchronized native int H5garbage_collect() throws HDF5LibraryException;

    public static synchronized native int H5get_libversion(int[] var0) throws HDF5LibraryException;

    public static synchronized native int H5set_free_list_limits(int var0, int var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException;

    public static int H5Aclose(int attr_id) throws HDF5LibraryException {
        if (attr_id < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(attr_id);
        return H5._H5Aclose(attr_id);
    }

    private static synchronized native int _H5Aclose(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Acopy(int var0, int var1) throws HDF5LibraryException;

    @Deprecated
    public static int H5Acreate(int loc_id, String name, int type_id, int space_id, int create_plist) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Acreate(loc_id, name, type_id, space_id, create_plist);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Acreate(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static int H5Acreate(int loc_id, String attr_name, int type_id, int space_id, int acpl_id, int aapl_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Acreate2(loc_id, attr_name, type_id, space_id, acpl_id, aapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Acreate2(int var0, String var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static int H5Acreate_by_name(int loc_id, String obj_name, String attr_name, int type_id, int space_id, int acpl_id, int aapl_id, int lapl_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Acreate_by_name(loc_id, obj_name, attr_name, type_id, space_id, acpl_id, aapl_id, lapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Acreate_by_name(int var0, String var1, String var2, int var3, int var4, int var5, int var6, int var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Adelete(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Adelete_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Adelete_by_name(int var0, String var1, String var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Aexists(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Aexists_by_name(int var0, String var1, String var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5A_info_t H5Aget_info(int var0) throws HDF5LibraryException;

    public static synchronized native H5A_info_t H5Aget_info_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5A_info_t H5Aget_info_by_name(int var0, String var1, String var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Aget_name(int var0, long var1, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static long H5Aget_name(int attr_id, String[] name) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException {
        long len = H5.H5Aget_name(attr_id, 0L, null);
        return H5.H5Aget_name(attr_id, len + 1L, name);
    }

    public static synchronized native String H5Aget_name_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Aget_num_attrs(int var0) throws HDF5LibraryException;

    public static int H5Aget_space(int attr_id) throws HDF5LibraryException {
        int id = H5._H5Aget_space(attr_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Aget_space(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Aget_storage_size(int var0) throws HDF5LibraryException;

    public static int H5Aget_type(int attr_id) throws HDF5LibraryException {
        int id = H5._H5Aget_type(attr_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Aget_type(int var0) throws HDF5LibraryException;

    public static int H5Aopen(int obj_id, String attr_name, int aapl_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Aopen(obj_id, attr_name, aapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Aopen(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Aopen_by_idx(int loc_id, String obj_name, int idx_type, int order, long n, int aapl_id, int lapl_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Aopen_by_idx(loc_id, obj_name, idx_type, order, n, aapl_id, lapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Aopen_by_idx(int var0, String var1, int var2, int var3, long var4, int var6, int var7) throws HDF5LibraryException, NullPointerException;

    public static int H5Aopen_by_name(int loc_id, String obj_name, String attr_name, int aapl_id, int lapl_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Aopen_by_name(loc_id, obj_name, attr_name, aapl_id, lapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    @Deprecated
    public static int H5Aopen_idx(int loc_id, int idx) throws HDF5LibraryException {
        int id = H5._H5Aopen_idx(loc_id, idx);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Aopen_idx(int var0, int var1) throws HDF5LibraryException;

    @Deprecated
    public static int H5Aopen_name(int loc_id, String name) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Aopen_name(loc_id, name);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Aopen_name(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Aread(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Aread(int attr_id, int mem_type_id, Object obj) throws HDF5Exception, NullPointerException {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.emptyBytes();
        int status = H5.H5Aread(attr_id, mem_type_id, buf);
        if (status >= 0) {
            obj = theArray.arrayify(buf);
        }
        return status;
    }

    public static synchronized native int H5AreadVL(int var0, int var1, String[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Arename(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Arename_by_name(int var0, String var1, String var2, String var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Awrite(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Awrite(int attr_id, int mem_type_id, Object obj) throws HDF5Exception, NullPointerException {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.byteify();
        int retVal = H5.H5Awrite(attr_id, mem_type_id, buf);
        buf = null;
        theArray = null;
        return retVal;
    }

    public static synchronized native int H5Dchdir_ext(String var0) throws HDF5LibraryException, NullPointerException;

    public static int H5Dclose(int dataset_id) throws HDF5LibraryException {
        if (dataset_id < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(dataset_id);
        return H5._H5Dclose(dataset_id);
    }

    private static synchronized native int _H5Dclose(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Dcopy(int var0, int var1) throws HDF5LibraryException;

    @Deprecated
    public static int H5Dcreate(int loc_id, String name, int type_id, int space_id, int create_plist_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Dcreate(loc_id, name, type_id, space_id, create_plist_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Dcreate(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static int H5Dcreate(int loc_id, String name, int type_id, int space_id, int lcpl_id, int dcpl_id, int dapl_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Dcreate2(loc_id, name, type_id, space_id, lcpl_id, dcpl_id, dapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Dcreate2(int var0, String var1, int var2, int var3, int var4, int var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static int H5Dcreate_anon(int loc_id, int type_id, int space_id, int dcpl_id, int dapl_id) throws HDF5LibraryException {
        int id = H5._H5Dcreate_anon(loc_id, type_id, space_id, dcpl_id, dapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Dcreate_anon(int var0, int var1, int var2, int var3, int var4) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native int H5Dextend(int var0, byte[] var1) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized int H5Dextend(int dataset_id, long[] size) throws HDF5Exception, NullPointerException {
        int rval = -1;
        HDFArray theArray = new HDFArray(size);
        byte[] buf = theArray.byteify();
        rval = H5.H5Dextend(dataset_id, buf);
        buf = null;
        theArray = null;
        return rval;
    }

    public static synchronized native void H5Dfill(byte[] var0, int var1, byte[] var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dget_access_plist(int var0) throws HDF5LibraryException;

    public static int H5Dget_create_plist(int dataset_id) throws HDF5LibraryException {
        int id = H5._H5Dget_create_plist(dataset_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Dget_create_plist(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Dget_offset(int var0) throws HDF5LibraryException;

    public static int H5Dget_space(int dataset_id) throws HDF5LibraryException {
        int id = H5._H5Dget_space(dataset_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Dget_space(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Dget_space_status(int var0) throws HDF5LibraryException;

    public static int H5Dget_space_status(int dset_id, int[] status) throws HDF5LibraryException, NullPointerException {
        return H5._H5Dget_space_status(dset_id, status);
    }

    private static synchronized native int _H5Dget_space_status(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Dget_storage_size(int var0) throws HDF5LibraryException, IllegalArgumentException;

    public static int H5Dget_type(int dataset_id) throws HDF5LibraryException {
        int id = H5._H5Dget_type(dataset_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Dget_type(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Dgetdir_ext(String[] var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Diterate(byte[] var0, int var1, int var2, H5D_iterate_cb var3, H5D_iterate_t var4) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static int H5Dopen(int loc_id, String name) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Dopen(loc_id, name);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Dopen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Dopen(int loc_id, String name, int dapl_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Dopen2(loc_id, name, dapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Dopen2(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread(int var0, int var1, int var2, int var3, int var4, byte[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, byte[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized int H5Dread(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, Object obj) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Dread(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, obj, true);
    }

    public static synchronized int H5Dread(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, Object obj, boolean isCriticalPinning) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int status = -1;
        boolean is1D = false;
        Class<?> dataClass = obj.getClass();
        if (!dataClass.isArray()) {
            throw new HDF5JavaException("H5Dread: data is not an array");
        }
        String cname = dataClass.getName();
        is1D = cname.lastIndexOf(91) == cname.indexOf(91);
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        if (is1D && dname == 'B') {
            status = H5.H5Dread(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (byte[])obj, isCriticalPinning);
        } else if (is1D && dname == 'S') {
            status = H5.H5Dread_short(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (short[])obj, isCriticalPinning);
        } else if (is1D && dname == 'I') {
            status = H5.H5Dread_int(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (int[])obj, isCriticalPinning);
        } else if (is1D && dname == 'J') {
            status = H5.H5Dread_long(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (long[])obj);
        } else if (is1D && dname == 'F') {
            status = H5.H5Dread_float(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (float[])obj, isCriticalPinning);
        } else if (is1D && dname == 'D') {
            status = H5.H5Dread_double(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (double[])obj, isCriticalPinning);
        } else if (H5.H5Tequal(mem_type_id, HDF5Constants.H5T_STD_REF_DSETREG)) {
            status = H5.H5Dread_reg_ref(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (String[])obj);
        } else if (is1D && dataClass.getComponentType() == String.class) {
            status = H5.H5Tis_variable_str(mem_type_id) ? H5.H5DreadVL(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (Object[])obj) : H5.H5Dread_string(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (String[])obj);
        } else {
            HDFArray theArray = new HDFArray(obj);
            byte[] buf = theArray.emptyBytes();
            status = H5.H5Dread(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, isCriticalPinning);
            if (status >= 0) {
                obj = theArray.arrayify(buf);
            }
            buf = null;
            theArray = null;
        }
        return status;
    }

    public static synchronized native int H5Dread_double(int var0, int var1, int var2, int var3, int var4, double[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_double(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, double[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_double(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dread_float(int var0, int var1, int var2, int var3, int var4, float[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_float(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, float[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_float(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dread_int(int var0, int var1, int var2, int var3, int var4, int[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_int(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, int[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_int(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dread_long(int var0, int var1, int var2, int var3, int var4, long[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_long(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, long[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_long(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dread_reg_ref(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dread_short(int var0, int var1, int var2, int var3, int var4, short[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dread_short(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, short[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dread_short(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dread_string(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5DreadVL(int var0, int var1, int var2, int var3, int var4, Object[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Dset_extent(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    private static synchronized native int _H5Aopen_by_name(int var0, String var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dvlen_get_buf_size(int var0, int var1, int var2, int[] var3) throws HDF5LibraryException;

    public static synchronized native long H5Dvlen_get_buf_size_long(int var0, int var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Dvlen_reclaim(int var0, int var1, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Dwrite(int var0, int var1, int var2, int var3, int var4, byte[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, byte[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized int H5Dwrite(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, Object obj) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, obj, true);
    }

    public static synchronized int H5Dwrite(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, Object obj, boolean isCriticalPinning) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        int status = -1;
        boolean is1D = false;
        Class<?> dataClass = obj.getClass();
        if (!dataClass.isArray()) {
            throw new HDF5JavaException("H5Dread: data is not an array");
        }
        String cname = dataClass.getName();
        is1D = cname.lastIndexOf(91) == cname.indexOf(91);
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        if (is1D && dname == 'B') {
            status = H5.H5Dwrite(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (byte[])obj, isCriticalPinning);
        } else if (is1D && dname == 'S') {
            status = H5.H5Dwrite_short(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (short[])obj, isCriticalPinning);
        } else if (is1D && dname == 'I') {
            status = H5.H5Dwrite_int(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (int[])obj, isCriticalPinning);
        } else if (is1D && dname == 'J') {
            status = H5.H5Dwrite_long(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (long[])obj, isCriticalPinning);
        } else if (is1D && dname == 'F') {
            status = H5.H5Dwrite_float(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (float[])obj, isCriticalPinning);
        } else if (is1D && dname == 'D') {
            status = H5.H5Dwrite_double(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (double[])obj, isCriticalPinning);
        } else if (H5.H5Tget_class(mem_type_id) == HDF5Constants.H5T_STRING && H5.H5Tis_variable_str(mem_type_id) && dataClass.isArray() && dataClass.getComponentType() == String.class && is1D) {
            status = H5.H5DwriteString(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, (String[])obj);
        } else {
            HDFArray theArray = new HDFArray(obj);
            byte[] buf = theArray.byteify();
            status = H5.H5Dwrite(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, isCriticalPinning);
            buf = null;
            theArray = null;
        }
        return status;
    }

    public static synchronized native int H5Dwrite_double(int var0, int var1, int var2, int var3, int var4, double[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_double(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, double[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_double(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dwrite_float(int var0, int var1, int var2, int var3, int var4, float[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_float(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, float[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_float(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dwrite_int(int var0, int var1, int var2, int var3, int var4, int[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_int(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, int[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_int(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dwrite_long(int var0, int var1, int var2, int var3, int var4, long[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_long(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, long[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_long(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5Dwrite_short(int var0, int var1, int var2, int var3, int var4, short[] var5, boolean var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Dwrite_short(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, short[] buf) throws HDF5LibraryException, NullPointerException {
        return H5.H5Dwrite_short(dataset_id, mem_type_id, mem_space_id, file_space_id, xfer_plist_id, buf, true);
    }

    public static synchronized native int H5DwriteString(int var0, int var1, int var2, int var3, int var4, String[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Eauto_is_v2(int var0) throws HDF5LibraryException;

    public static int H5Eclear() throws HDF5LibraryException {
        H5.H5Eclear2(HDF5Constants.H5E_DEFAULT);
        return 0;
    }

    public static void H5Eclear(int err_stack) throws HDF5LibraryException {
        H5.H5Eclear2(err_stack);
    }

    public static synchronized native void H5Eclear2(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Eclose_msg(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Eclose_stack(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Ecreate_msg(int var0, int var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Ecreate_stack() throws HDF5LibraryException;

    public static synchronized native String H5Eget_class_name(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Eget_current_stack() throws HDF5LibraryException;

    public static synchronized native void H5Eset_current_stack(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Eget_msg(int var0, int[] var1) throws HDF5LibraryException;

    public static synchronized native long H5Eget_num(int var0) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native void H5Eprint1(Object var0) throws HDF5LibraryException;

    public static synchronized native void H5Eprint2(int var0, Object var1) throws HDF5LibraryException;

    public static synchronized native void H5Epop(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Eregister_class(String var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Eunregister_class(int var0) throws HDF5LibraryException;

    public static int H5Fclose(int file_id) throws HDF5LibraryException {
        if (file_id < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(file_id);
        return H5._H5Fclose(file_id);
    }

    private static synchronized native int _H5Fclose(int var0) throws HDF5LibraryException;

    public static int H5Fopen(String name, int flags, int access_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Fopen(name, flags, access_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Fopen(String var0, int var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Freopen(int file_id) throws HDF5LibraryException {
        int id = H5._H5Freopen(file_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Freopen(int var0) throws HDF5LibraryException;

    public static int H5Fcreate(String name, int flags, int create_id, int access_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Fcreate(name, flags, create_id, access_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Fcreate(String var0, int var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fflush(int var0, int var1) throws HDF5LibraryException;

    public static int H5Fget_access_plist(int file_id) throws HDF5LibraryException {
        int id = H5._H5Fget_access_plist(file_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Fget_access_plist(int var0) throws HDF5LibraryException;

    public static int H5Fget_create_plist(int file_id) throws HDF5LibraryException {
        int id = H5._H5Fget_create_plist(file_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Fget_create_plist(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Fget_filesize(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Fget_freespace(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Fget_intent(int var0) throws HDF5LibraryException;

    public static synchronized native double H5Fget_mdc_hit_rate(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Fget_mdc_size(int var0, long[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native String H5Fget_name(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Fget_name(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Fget_obj_count(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native long H5Fget_obj_count_long(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Fget_obj_ids(int var0, int var1, int var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Fget_obj_ids_long(int var0, int var1, long var2, int[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Fis_hdf5(String var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Fmount(int var0, String var1, int var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Funmount(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Freset_mdc_hit_rate_stats(int var0) throws HDF5LibraryException;

    public static int H5Gclose(int group_id) throws HDF5LibraryException {
        if (group_id < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(group_id);
        return H5._H5Gclose(group_id);
    }

    private static synchronized native int _H5Gclose(int var0) throws HDF5LibraryException;

    @Deprecated
    public static int H5Gcreate(int loc_id, String name, long size_hint) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Gcreate(loc_id, name, size_hint);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Gcreate(int var0, String var1, long var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Gcreate(int loc_id, String name, int lcpl_id, int gcpl_id, int gapl_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Gcreate2(loc_id, name, lcpl_id, gcpl_id, gapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Gcreate2(int var0, String var1, int var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static int H5Gcreate_anon(int loc_id, int gcpl_id, int gapl_id) throws HDF5LibraryException {
        int id = H5._H5Gcreate_anon(loc_id, gcpl_id, gapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Gcreate_anon(int var0, int var1, int var2) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native int H5Gget_comment(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    @Deprecated
    public static synchronized native int H5Gset_comment(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Gget_create_plist(int var0) throws HDF5LibraryException;

    public static synchronized native H5G_info_t H5Gget_info(int var0) throws HDF5LibraryException;

    public static synchronized native H5G_info_t H5Gget_info_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5G_info_t H5Gget_info_by_name(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gget_linkval(int var0, String var1, int var2, String[] var3) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    @Deprecated
    public static synchronized native int H5Gget_num_objs(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Gget_obj_info_all(int loc_id, String name, String[] oname, int[] otype, long[] ref) throws HDF5LibraryException, NullPointerException {
        if (oname == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): name array is null");
        }
        return H5.H5Gget_obj_info_all(loc_id, name, oname, otype, null, null, ref, HDF5Constants.H5_INDEX_NAME);
    }

    public static synchronized int H5Gget_obj_info_all(int loc_id, String name, String[] oname, int[] otype, int[] ltype, long[] ref, int indx_type) throws HDF5LibraryException, NullPointerException {
        return H5.H5Gget_obj_info_all(loc_id, name, oname, otype, ltype, null, ref, indx_type);
    }

    public static synchronized int H5Gget_obj_info_all(int loc_id, String name, String[] oname, int[] otype, int[] ltype, long[] fno, long[] ref, int indx_type) throws HDF5LibraryException, NullPointerException {
        if (oname == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): name array is null");
        }
        if (otype == null) {
            throw new NullPointerException("H5Gget_obj_info_all(): object type array is null");
        }
        if (oname.length == 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_all(): array size is zero");
        }
        if (oname.length != otype.length) {
            throw new HDF5LibraryException("H5Gget_obj_info_all(): name and type array sizes are different");
        }
        if (ltype == null) {
            ltype = new int[otype.length];
        }
        if (fno == null) {
            fno = new long[ref.length];
        }
        if (indx_type < 0) {
            indx_type = HDF5Constants.H5_INDEX_NAME;
        }
        return H5.H5Gget_obj_info_all(loc_id, name, oname, otype, ltype, fno, ref, oname.length, indx_type);
    }

    private static synchronized native int H5Gget_obj_info_all(int var0, String var1, String[] var2, int[] var3, int[] var4, long[] var5, long[] var6, int var7, int var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Gget_obj_info_idx(int loc_id, String name, int idx, String[] oname, int[] type) throws HDF5LibraryException, NullPointerException {
        long default_buf_size = 4096L;
        String[] n = new String[]{new String("")};
        int grp_id = H5.H5Gopen(loc_id, name);
        long val = H5.H5Gget_objname_by_idx(grp_id, idx, n, default_buf_size);
        int type_code = H5.H5Gget_objtype_by_idx(grp_id, idx);
        oname[0] = new String(n[0]);
        type[0] = type_code;
        int ret = new Long(val).intValue();
        return ret;
    }

    public static synchronized int H5Gget_obj_info_max(int loc_id, String[] objNames, int[] objTypes, int[] lnkTypes, long[] ref, int objMax) throws HDF5LibraryException, NullPointerException {
        if (objNames == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): name array is null");
        }
        if (objTypes == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): object type array is null");
        }
        if (lnkTypes == null) {
            throw new NullPointerException("H5Gget_obj_info_max(): link type array is null");
        }
        if (objNames.length <= 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): array size is zero");
        }
        if (objMax <= 0) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): maximum array size is zero");
        }
        if (objNames.length != objTypes.length) {
            throw new HDF5LibraryException("H5Gget_obj_info_max(): name and type array sizes are different");
        }
        return H5.H5Gget_obj_info_max(loc_id, objNames, objTypes, lnkTypes, ref, objMax, objNames.length);
    }

    private static synchronized native int H5Gget_obj_info_max(int var0, String[] var1, int[] var2, int[] var3, long[] var4, int var5, int var6) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gget_objinfo(int var0, String var1, boolean var2, long[] var3, long[] var4, int[] var5, long[] var6) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    @Deprecated
    public static synchronized int H5Gget_objinfo(int loc_id, String name, boolean follow_link, HDF5GroupInfo info) throws HDF5LibraryException, NullPointerException {
        int status = -1;
        long[] fileno = new long[2];
        long[] objno = new long[2];
        int[] link_info = new int[3];
        long[] mtime = new long[1];
        status = H5.H5Gget_objinfo(loc_id, name, follow_link, fileno, objno, link_info, mtime);
        if (status >= 0) {
            info.setGroupInfo(fileno, objno, link_info[0], link_info[1], mtime[0], link_info[2]);
        }
        return status;
    }

    @Deprecated
    public static synchronized native long H5Gget_objname_by_idx(int var0, long var1, String[] var3, long var4) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gget_objtype_by_idx(int var0, long var1) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Glink(int var0, int var1, String var2, String var3) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Glink2(int var0, String var1, int var2, int var3, String var4) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gunlink(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static synchronized native int H5Gmove(int var0, String var1, String var2) throws HDF5LibraryException, NullPointerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long H5Gn_members_long(int loc_id, String name) throws HDF5LibraryException, NullPointerException {
        int grp_id = H5.H5Gopen(loc_id, name);
        long n = -1L;
        try {
            H5G_info_t info = H5.H5Gget_info(grp_id);
            n = info.nlinks;
        }
        finally {
            H5.H5Gclose(grp_id);
        }
        return n;
    }

    public static synchronized int H5Gn_members(int loc_id, String name) throws HDF5LibraryException, NullPointerException {
        return (int)H5.H5Gn_members_long(loc_id, name);
    }

    @Deprecated
    public static int H5Gopen(int loc_id, String name) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Gopen(loc_id, name);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Gopen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Gopen(int loc_id, String name, int gapl_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Gopen2(loc_id, name, gapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Gopen2(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iget_file_id(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Iget_name(int var0, String[] var1, long var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iget_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Idec_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iinc_ref(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Iget_type(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Iget_type_ref(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Inmembers(int var0) throws HDF5LibraryException;

    public static synchronized native int H5INcreate(String var0, int var1, int var2, int var3, String var4, String var5, long var6);

    public static synchronized native int H5INquery(int var0, String[] var1, Object var2, Object var3, int var4);

    public static synchronized native void H5Lcopy(int var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_external(String var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_hard(int var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lcreate_soft(String var0, int var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Ldelete(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Ldelete_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Lexists(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5L_info_t H5Lget_info(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5L_info_t H5Lget_info_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Lget_name_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lget_val(int var0, String var1, String[] var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lget_val_by_idx(int var0, String var1, int var2, int var3, long var4, String[] var6, int var7) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Literate(int var0, int var1, int var2, long var3, H5L_iterate_cb var5, H5L_iterate_t var6) throws HDF5LibraryException;

    public static synchronized native int H5Literate_by_name(int var0, String var1, int var2, int var3, long var4, H5L_iterate_cb var6, H5L_iterate_t var7, int var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Lmove(int var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Lvisit(int var0, int var1, int var2, H5L_iterate_cb var3, H5L_iterate_t var4) throws HDF5LibraryException;

    public static synchronized native int H5Lvisit_by_name(int var0, String var1, int var2, int var3, H5L_iterate_cb var4, H5L_iterate_t var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static int H5Oclose(int object_id) throws HDF5LibraryException {
        if (object_id < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(object_id);
        return H5._H5Oclose(object_id);
    }

    private static synchronized native int _H5Oclose(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Ocopy(int var0, String var1, int var2, String var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Oget_comment(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Oset_comment(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native String H5Oget_comment_by_name(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Oset_comment_by_name(int var0, String var1, String var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5O_info_t H5Oget_info(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5O_info_t H5Oget_info_by_idx(int var0, String var1, int var2, int var3, long var4, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native H5O_info_t H5Oget_info_by_name(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Olink(int var0, int var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static int H5Oopen(int loc_id, String name, int lapl_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Oopen(loc_id, name, lapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Oopen(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Ovisit(int var0, int var1, int var2, H5O_iterate_cb var3, H5O_iterate_t var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Ovisit_by_name(int var0, String var1, int var2, int var3, H5O_iterate_cb var4, H5O_iterate_t var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Pall_filters_avail(int var0) throws HDF5LibraryException, NullPointerException;

    public static int H5Pclose(int plist) throws HDF5LibraryException {
        if (plist < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(plist);
        return H5._H5Pclose(plist);
    }

    private static synchronized native int _H5Pclose(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pclose_class(int var0) throws HDF5LibraryException;

    public static int H5Pcopy(int plist) throws HDF5LibraryException {
        int id = H5._H5Pcopy(plist);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Pcopy(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pcopy_prop(int var0, int var1, String var2) throws HDF5LibraryException;

    public static int H5Pcreate(int type) throws HDF5LibraryException {
        int id = H5._H5Pcreate(type);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Pcreate(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pequal(int var0, int var1) throws HDF5LibraryException;

    public static boolean H5P_equal(int plid1, int plid2) throws HDF5LibraryException {
        return H5.H5Pequal(plid1, plid2) == 1;
    }

    public static synchronized native int H5Pexist(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Pfill_value_defined(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Pset(int var0, String var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_alignment(int var0, long[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_alignment(int var0, long var1, long var3) throws HDF5LibraryException;

    public static synchronized native int H5Pget_alloc_time(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_alloc_time(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_attr_creation_order(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_attr_creation_order(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_attr_phase_change(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_btree_ratios(int var0, double[] var1, double[] var2, double[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_btree_ratios(int var0, double var1, double var3, double var5) throws HDF5LibraryException;

    public static synchronized native int H5Pget_buffer(int var0, byte[] var1, byte[] var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_buffer_size(int var0) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native void H5Pset_buffer_size(int var0, long var1) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_cache(int var0, int[] var1, long[] var2, long[] var3, double[] var4) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static int H5Pget_cache(int plist, int[] mdc_nelmts, int[] rdcc_nelmts, int[] rdcc_nbytes, double[] rdcc_w0) throws HDF5LibraryException, NullPointerException {
        long[] rdcc_nelmts_l = new long[]{rdcc_nelmts[0]};
        long[] rdcc_nbytes_l = new long[]{rdcc_nbytes[0]};
        int retval = H5.H5Pget_cache(plist, mdc_nelmts, rdcc_nelmts_l, rdcc_nbytes_l, rdcc_w0);
        rdcc_nelmts[0] = (int)rdcc_nelmts_l[0];
        rdcc_nbytes[0] = (int)rdcc_nbytes_l[0];
        return retval;
    }

    public static synchronized native int H5Pset_cache(int var0, int var1, long var2, long var4, double var6) throws HDF5LibraryException;

    public static synchronized native int H5Pget_char_encoding(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_char_encoding(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_chunk(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_chunk(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized int H5Pset_chunk(int plist, int ndims, long[] dim) throws HDF5Exception, NullPointerException, IllegalArgumentException {
        if (dim == null) {
            return -1;
        }
        HDFArray theArray = new HDFArray(dim);
        byte[] thedims = theArray.byteify();
        int retVal = H5.H5Pset_chunk(plist, ndims, thedims);
        thedims = null;
        theArray = null;
        return retVal;
    }

    public static synchronized native void H5Pget_chunk_cache(int var0, long[] var1, long[] var2, double[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_chunk_cache(int var0, long var1, long var3, double var5) throws HDF5LibraryException;

    public static synchronized native int H5Pget_class(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Pget_class_name(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget_class_parent(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pget_copy_object(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_copy_object(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native boolean H5Pget_create_intermediate_group(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_create_intermediate_group(int var0, boolean var1) throws HDF5LibraryException;

    public static synchronized native long H5Pget_data_transform(int var0, String[] var1, long var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pset_data_transform(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_driver(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Pget_dxpl_multi(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_dxpl_multi(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_edc_check(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_edc_check(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_elink_acc_flags(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_elink_acc_flags(int var0, int var1) throws HDF5LibraryException, IllegalArgumentException;

    public static int H5Pget_elink_fapl(int lapl_id) throws HDF5LibraryException {
        int id = H5._H5Pget_elink_fapl(lapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Pget_elink_fapl(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_elink_fapl(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_elink_file_cache_size(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_elink_file_cache_size(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native long H5Pget_elink_prefix(int var0, String[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_elink_prefix(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_est_link_info(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_est_link_info(int var0, int var1, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_external(int var0, int var1, long var2, String[] var4, long[] var5) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_external(int var0, String var1, long var2, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_external_count(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Pget_family_offset(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_family_offset(int var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pget_fapl_core(int var0, long[] var1, boolean[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_core(int var0, long var1, boolean var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fapl_direct(int var0, long[] var1) throws HDF5LibraryException;

    public static synchronized native int H5Pset_fapl_direct(int var0, long var1, long var3, long var5) throws HDF5LibraryException;

    public static synchronized native int H5Pget_fapl_family(int var0, long[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_family(int var0, long var1, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Pget_fapl_multi(int var0, int[] var1, int[] var2, String[] var3, long[] var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_fapl_multi(int var0, int[] var1, int[] var2, String[] var3, long[] var4, boolean var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fclose_degree(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fclose_degree(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fill_time(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fill_time(int var0, int var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static synchronized int H5Pget_fill_value(int plist_id, int type_id, Object obj) throws HDF5Exception {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.emptyBytes();
        int status = H5.H5Pget_fill_value(plist_id, type_id, buf);
        if (status >= 0) {
            obj = theArray.arrayify(buf);
        }
        return status;
    }

    public static synchronized native int H5Pset_fill_value(int var0, int var1, byte[] var2) throws HDF5Exception;

    public static synchronized int H5Pset_fill_value(int plist_id, int type_id, Object obj) throws HDF5Exception {
        HDFArray theArray = new HDFArray(obj);
        byte[] buf = theArray.byteify();
        int retVal = H5.H5Pset_fill_value(plist_id, type_id, buf);
        buf = null;
        theArray = null;
        return retVal;
    }

    @Deprecated
    public static synchronized native int H5Pget_filter(int var0, int var1, int[] var2, int[] var3, int[] var4, int var5, String[] var6) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static int H5Pget_filter(int plist, int filter_number, int[] flags, long[] cd_nelmts, int[] cd_values, long namelen, String[] name, int[] filter_config) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException {
        return H5.H5Pget_filter2(plist, filter_number, flags, cd_nelmts, cd_values, namelen, name, filter_config);
    }

    private static synchronized native int H5Pget_filter2(int var0, int var1, int[] var2, long[] var3, int[] var4, long var5, String[] var7, int[] var8) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_filter(int var0, int var1, int var2, long var3, int[] var5) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native int H5Pget_filter_by_id(int var0, int var1, int[] var2, long[] var3, int[] var4, long var5, String[] var7) throws HDF5LibraryException, NullPointerException;

    public static int H5Pget_filter_by_id(int plist_id, int filter_id, int[] flags, long[] cd_nelmts, int[] cd_values, long namelen, String[] name, int[] filter_config) throws ArrayIndexOutOfBoundsException, ArrayStoreException, HDF5LibraryException, NullPointerException {
        return H5.H5Pget_filter_by_id2(plist_id, filter_id, flags, cd_nelmts, cd_values, namelen, name, filter_config);
    }

    public static synchronized native int H5Pget_filter_by_id2(int var0, int var1, int[] var2, long[] var3, int[] var4, long var5, String[] var7, int[] var8) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_gc_references(int var0, boolean[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Pget_gcreferences(int var0) throws HDF5LibraryException;

    public static synchronized int H5Pget_gc_reference(int fapl_id, boolean[] gc_ref) throws HDF5LibraryException, NullPointerException {
        return H5.H5Pget_gc_references(fapl_id, gc_ref);
    }

    public static synchronized native int H5Pset_gc_references(int var0, boolean var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_hyper_vector_size(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_hyper_vector_size(int var0, long var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pget_istore_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_istore_k(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_layout(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_layout(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_libver_bounds(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_libver_bounds(int var0, int var1, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_link_creation_order(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_link_creation_order(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_link_phase_change(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_link_phase_change(int var0, int var1, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_local_heap_size_hint(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_local_heap_size_hint(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native H5AC_cache_config_t H5Pget_mdc_config(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_mdc_config(int var0, H5AC_cache_config_t var1) throws HDF5LibraryException;

    public static synchronized native long H5Pget_meta_block_size(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_meta_block_size(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_nfilters(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Pget_nlinks(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_nlinks(int var0, long var1) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_nprops(int var0) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native int H5Pget_preserve(int var0) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native int H5Pset_preserve(int var0, boolean var1) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native boolean H5Pget_obj_track_times(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_obj_track_times(int var0, boolean var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_shared_mesg_index(int var0, int var1, int[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_shared_mesg_index(int var0, int var1, int var2, int var3) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_shared_mesg_nindexes(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_shared_mesg_nindexes(int var0, int var1) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pget_shared_mesg_phase_change(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_shared_mesg_phase_change(int var0, int var1, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native long H5Pget_sieve_buf_size(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Pset_sieve_buf_size(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native long H5Pget_size(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_sizes(int var0, long[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_sizes(int var0, int var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_small_data_block_size(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Pget_small_data_block_size_long(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_small_data_block_size(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_sym_k(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pset_sym_k(int var0, int var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Pget_userblock(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_userblock(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Pget_version(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Pisa_class(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pmodify_filter(int var0, int var1, int var2, long var3, int[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Punregister(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Premove(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Premove_filter(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Pset_deflate(int var0, int var1) throws HDF5LibraryException;

    @Deprecated
    public static int H5Pset_fapl_log(int fapl_id, String logfile, int flags, int buf_size) throws HDF5LibraryException, NullPointerException {
        H5.H5Pset_fapl_log(fapl_id, logfile, (long)flags, (long)buf_size);
        return 1;
    }

    public static synchronized native void H5Pset_fapl_log(int var0, String var1, long var2, long var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_sec2(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Pset_fapl_split(int var0, String var1, int var2, String var3, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_stdio(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fapl_windows(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_fletcher32(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_nbit(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Pset_scaleoffset(int var0, int var1, int var2) throws HDF5LibraryException, IllegalArgumentException;

    public static synchronized native int H5Pset_shuffle(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Pset_szip(int var0, int var1, int var2) throws HDF5LibraryException, NullPointerException;

    private static synchronized native int H5Rcreate(byte[] var0, int var1, String var2, int var3, int var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized byte[] H5Rcreate(int loc_id, String name, int ref_type, int space_id) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int ref_size = 8;
        if (ref_type == HDF5Constants.H5R_DATASET_REGION) {
            ref_size = 12;
        }
        byte[] rbuf = new byte[ref_size];
        H5.H5Rcreate(rbuf, loc_id, name, ref_type, space_id);
        return rbuf;
    }

    public static int H5Rdereference(int dataset, int ref_type, byte[] ref) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int id = H5._H5Rdereference(dataset, ref_type, ref);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Rdereference(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native long H5Rget_name(int var0, int var1, byte[] var2, String[] var3, long var4) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    @Deprecated
    public static synchronized native int H5Rget_obj_type(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Rget_obj_type(int loc_id, int ref_type, byte[] ref, int[] obj_type) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        return H5.H5Rget_obj_type2(loc_id, ref_type, ref, obj_type);
    }

    private static synchronized native int H5Rget_obj_type2(int var0, int var1, byte[] var2, int[] var3) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Rget_region(int loc_id, int ref_type, byte[] ref) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        int id = H5._H5Rget_region(loc_id, ref_type, ref);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Rget_region(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Sclose(int space_id) throws HDF5LibraryException {
        if (space_id < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(space_id);
        return H5._H5Sclose(space_id);
    }

    private static synchronized native int _H5Sclose(int var0) throws HDF5LibraryException;

    public static int H5Scopy(int space_id) throws HDF5LibraryException {
        int id = H5._H5Scopy(space_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Scopy(int var0) throws HDF5LibraryException;

    public static int H5Screate(int type) throws HDF5LibraryException {
        int id = H5._H5Screate(type);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Screate(int var0) throws HDF5LibraryException;

    public static int H5Screate_simple(int rank, long[] dims, long[] maxdims) throws HDF5Exception, NullPointerException {
        int id = H5._H5Screate_simple(rank, dims, maxdims);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Screate_simple(int var0, long[] var1, long[] var2) throws HDF5Exception, NullPointerException;

    @Deprecated
    public static int H5Screate_simple(int rank, byte[] dims, byte[] maxdims) throws HDF5Exception, NullPointerException {
        ByteBuffer maxdimsbb;
        long[] lamaxdims;
        ByteBuffer dimsbb = ByteBuffer.wrap(dims);
        long[] ladims = dimsbb.asLongBuffer().array();
        int id = H5._H5Screate_simple(rank, ladims, lamaxdims = (maxdimsbb = ByteBuffer.wrap(maxdims)).asLongBuffer().array());
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    public static synchronized native int H5Sdecode(byte[] var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native byte[] H5Sencode(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sextent_copy(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native boolean H5Sextent_equal(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Sget_select_bounds(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Sget_select_elem_npoints(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_select_elem_pointlist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sget_select_hyper_blocklist(int var0, long var1, long var3, long[] var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native long H5Sget_select_hyper_nblocks(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_select_npoints(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_select_type(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_dims(int var0, long[] var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Sget_simple_extent_ndims(int var0) throws HDF5LibraryException;

    public static synchronized native long H5Sget_simple_extent_npoints(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sget_simple_extent_type(int var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Sis_simple(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Soffset_simple(int var0, byte[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Soffset_simple(int space_id, long[] offset) throws HDF5Exception, NullPointerException {
        if (offset == null) {
            return -1;
        }
        HDFArray theArray = new HDFArray(offset);
        byte[] theArr = theArray.byteify();
        int retVal = H5.H5Soffset_simple(space_id, theArr);
        theArr = null;
        theArray = null;
        return retVal;
    }

    public static synchronized native int H5Sselect_all(int var0) throws HDF5LibraryException;

    private static synchronized native int H5Sselect_elements(int var0, int var1, int var2, byte[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Sselect_elements(int space_id, int op, int num_elements, long[][] coord2D) throws HDF5Exception, HDF5LibraryException, NullPointerException {
        if (coord2D == null) {
            return -1;
        }
        HDFArray theArray = new HDFArray(coord2D);
        byte[] coord = theArray.byteify();
        int retVal = H5.H5Sselect_elements(space_id, op, num_elements, coord);
        coord = null;
        theArray = null;
        return retVal;
    }

    public static synchronized int H5Sselect_hyperslab(int space_id, int op, byte[] start, byte[] stride, byte[] count, byte[] block) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        ByteBuffer startbb = ByteBuffer.wrap(start);
        long[] lastart = startbb.asLongBuffer().array();
        ByteBuffer stridebb = ByteBuffer.wrap(stride);
        long[] lastride = stridebb.asLongBuffer().array();
        ByteBuffer countbb = ByteBuffer.wrap(count);
        long[] lacount = countbb.asLongBuffer().array();
        ByteBuffer blockbb = ByteBuffer.wrap(block);
        long[] lablock = blockbb.asLongBuffer().array();
        return H5.H5Sselect_hyperslab(space_id, op, lastart, lastride, lacount, lablock);
    }

    public static synchronized native int H5Sselect_hyperslab(int var0, int var1, long[] var2, long[] var3, long[] var4, long[] var5) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native int H5Sselect_none(int var0) throws HDF5LibraryException;

    public static synchronized native boolean H5Sselect_valid(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sset_extent_none(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Sset_extent_simple(int var0, int var1, long[] var2, long[] var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Sset_extent_simple(int space_id, int rank, byte[] current_size, byte[] maximum_size) throws HDF5LibraryException, NullPointerException {
        ByteBuffer csbb = ByteBuffer.wrap(current_size);
        long[] lacs = csbb.asLongBuffer().array();
        ByteBuffer maxsbb = ByteBuffer.wrap(maximum_size);
        long[] lamaxs = maxsbb.asLongBuffer().array();
        return H5.H5Sset_extent_simple(space_id, rank, lacs, lamaxs);
    }

    @Deprecated
    public static int H5Tarray_create(int base, int rank, int[] dims, int[] perms) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Tarray_create(base, rank, dims, perms);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Tarray_create(int var0, int var1, int[] var2, int[] var3) throws HDF5LibraryException, NullPointerException;

    public static int H5Tarray_create(int base_id, int ndims, long[] dim) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Tarray_create2(base_id, ndims, dim);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Tarray_create2(int var0, int var1, long[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Tclose(int type_id) throws HDF5LibraryException {
        if (type_id < 0) {
            throw new HDF5LibraryException("Negative ID");
        }
        OPEN_IDS.removeElement(type_id);
        return H5._H5Tclose(type_id);
    }

    private static synchronized native int _H5Tclose(int var0) throws HDF5LibraryException;

    @Deprecated
    public static int H5Tcommit(int loc_id, String name, int type) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tcommit1(loc_id, name, type);
    }

    public static synchronized native int H5Tcommit1(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Tcommit(int var0, String var1, int var2, int var3, int var4, int var5) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Tcommit_anon(int var0, int var1, int var2, int var3) throws HDF5LibraryException;

    public static synchronized native boolean H5Tcommitted(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Tcompiler_conv(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native void H5Tconvert(int var0, int var1, long var2, byte[] var4, byte[] var5, int var6) throws HDF5LibraryException, NullPointerException;

    public static int H5Tcopy(int type_id) throws HDF5LibraryException {
        int id = H5._H5Tcopy(type_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Tcopy(int var0) throws HDF5LibraryException;

    public static int H5Tcreate(int dclass, int size) throws HDF5LibraryException {
        return H5.H5Tcreate(dclass, (long)size);
    }

    public static int H5Tcreate(int type, long size) throws HDF5LibraryException {
        int id = H5._H5Tcreate(type, size);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Tcreate(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Tdecode(byte[] var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tdetect_class(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tencode(int var0, byte[] var1, long var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_create(int base_id) throws HDF5LibraryException {
        int id = H5._H5Tenum_create(base_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Tenum_create(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Tenum_insert(int var0, String var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_insert(int type, String name, int[] value) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_insert_int(type, name, value);
    }

    public static int H5Tenum_insert(int type, String name, int value) throws HDF5LibraryException, NullPointerException {
        int[] val = new int[]{value};
        return H5.H5Tenum_insert_int(type, name, val);
    }

    private static synchronized native int H5Tenum_insert_int(int var0, String var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native String H5Tenum_nameof(int var0, byte[] var1, long var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_nameof(int type, int[] value, String[] name, int size) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_nameof_int(type, value, name, size);
    }

    private static synchronized native int H5Tenum_nameof_int(int var0, int[] var1, String[] var2, int var3) throws HDF5LibraryException, NullPointerException;

    public static synchronized native void H5Tenum_valueof(int var0, String var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Tenum_valueof(int type, String name, int[] value) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tenum_valueof_int(type, name, value);
    }

    private static synchronized native int H5Tenum_valueof_int(int var0, String var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tequal(int var0, int var1) throws HDF5LibraryException;

    @Deprecated
    public static synchronized native int H5Tget_array_dims(int var0, int[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    @Deprecated
    public static int H5Tget_array_dims(int type_id, long[] dims, int[] perm) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_array_dims1(type_id, dims, perm);
    }

    @Deprecated
    private static synchronized native int H5Tget_array_dims1(int var0, long[] var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Tget_array_dims(int type_id, long[] dims) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_array_dims2(type_id, dims);
    }

    public static synchronized native int H5Tget_array_dims2(int var0, long[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tget_array_ndims(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_class(int var0) throws HDF5LibraryException;

    public static String H5Tget_class_name(int class_id) {
        String retValue = null;
        retValue = HDF5Constants.H5T_INTEGER == class_id ? "H5T_INTEGER" : (HDF5Constants.H5T_FLOAT == class_id ? "H5T_FLOAT" : (HDF5Constants.H5T_TIME == class_id ? "H5T_TIME" : (HDF5Constants.H5T_STRING == class_id ? "H5T_STRING" : (HDF5Constants.H5T_BITFIELD == class_id ? "H5T_BITFIELD" : (HDF5Constants.H5T_OPAQUE == class_id ? "H5T_OPAQUE" : (HDF5Constants.H5T_COMPOUND == class_id ? "H5T_COMPOUND" : (HDF5Constants.H5T_REFERENCE == class_id ? "H5T_REFERENCE" : (HDF5Constants.H5T_ENUM == class_id ? "H5T_ENUM" : (HDF5Constants.H5T_VLEN == class_id ? "H5T_VLEN" : (HDF5Constants.H5T_ARRAY == class_id ? "H5T_ARRAY" : "H5T_NO_CLASS"))))))))));
        return retValue;
    }

    public static synchronized native int H5Tget_create_plist(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_cset(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_cset(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_ebias(int var0) throws HDF5LibraryException;

    public static int H5Tset_ebias(int type_id, int ebias) throws HDF5LibraryException {
        H5.H5Tset_ebias(type_id, (long)ebias);
        return 0;
    }

    public static synchronized native long H5Tget_ebias_long(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Tset_ebias(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native void H5Tget_fields(int var0, long[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static int H5Tget_fields(int type_id, int[] fields) throws HDF5LibraryException, NullPointerException, IllegalArgumentException {
        return H5.H5Tget_fields_int(type_id, fields);
    }

    private static synchronized native int H5Tget_fields_int(int var0, int[] var1) throws HDF5LibraryException, NullPointerException, IllegalArgumentException;

    public static synchronized native void H5Tset_fields(int var0, long var1, long var3, long var5, long var7, long var9) throws HDF5LibraryException;

    public static int H5Tset_fields(int type_id, int spos, int epos, int esize, int mpos, int msize) throws HDF5LibraryException {
        H5.H5Tset_fields(type_id, (long)spos, (long)epos, (long)esize, (long)mpos, (long)msize);
        return 0;
    }

    public static synchronized native int H5Tget_inpad(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_inpad(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_member_class(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_member_index(int var0, String var1);

    public static synchronized native String H5Tget_member_name(int var0, int var1);

    public static synchronized native long H5Tget_member_offset(int var0, int var1) throws HDF5LibraryException;

    public static int H5Tget_member_type(int type_id, int field_idx) throws HDF5LibraryException {
        int id = H5._H5Tget_member_type(type_id, field_idx);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Tget_member_type(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native void H5Tget_member_value(int var0, int var1, byte[] var2) throws HDF5LibraryException, NullPointerException;

    public static int H5Tget_member_value(int type_id, int membno, int[] value) throws HDF5LibraryException, NullPointerException {
        return H5.H5Tget_member_value_int(type_id, membno, value);
    }

    private static synchronized native int H5Tget_member_value_int(int var0, int var1, int[] var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized int H5Tget_native_type(int tid) throws HDF5LibraryException {
        return H5.H5Tget_native_type(tid, HDF5Constants.H5T_DIR_ASCEND);
    }

    public static int H5Tget_native_type(int tid, int direction) throws HDF5LibraryException {
        int id = H5._H5Tget_native_type(tid, direction);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Tget_native_type(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_nmembers(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tget_norm(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_norm(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_offset(int var0) throws HDF5LibraryException;

    public static int H5Tset_offset(int type_id, int offset) throws HDF5LibraryException {
        H5.H5Tset_offset(type_id, (long)offset);
        return 0;
    }

    public static synchronized native void H5Tset_offset(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_order(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_order(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_pad(int var0, int[] var1) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tset_pad(int var0, int var1, int var2) throws HDF5LibraryException;

    public static synchronized native int H5Tget_precision(int var0) throws HDF5LibraryException;

    public static int H5Tset_precision(int type_id, int precision) throws HDF5LibraryException {
        H5.H5Tset_precision(type_id, (long)precision);
        return 0;
    }

    public static synchronized native long H5Tget_precision_long(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Tset_precision(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_sign(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_sign(int var0, int var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_size(int var0) throws HDF5LibraryException;

    public static int H5Tset_size(int type_id, int size) throws HDF5LibraryException {
        H5.H5Tset_size(type_id, (long)size);
        return 0;
    }

    public static synchronized native long H5Tget_size_long(int var0) throws HDF5LibraryException;

    public static synchronized native void H5Tset_size(int var0, long var1) throws HDF5LibraryException;

    public static synchronized native int H5Tget_strpad(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_strpad(int var0, int var1) throws HDF5LibraryException;

    public static int H5Tget_super(int type) throws HDF5LibraryException {
        int id = H5._H5Tget_super(type);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Tget_super(int var0) throws HDF5LibraryException;

    public static synchronized native String H5Tget_tag(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tset_tag(int var0, String var1) throws HDF5LibraryException;

    public static synchronized native int H5Tinsert(int var0, String var1, long var2, int var4) throws HDF5LibraryException, NullPointerException;

    public static synchronized native boolean H5Tis_variable_str(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Tlock(int var0) throws HDF5LibraryException;

    @Deprecated
    public static int H5Topen(int loc_id, String name) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Topen(loc_id, name);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Topen(int var0, String var1) throws HDF5LibraryException, NullPointerException;

    public static int H5Topen(int loc_id, String name, int tapl_id) throws HDF5LibraryException, NullPointerException {
        int id = H5._H5Topen2(loc_id, name, tapl_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Topen2(int var0, String var1, int var2) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Tpack(int var0) throws HDF5LibraryException;

    public static int H5Tvlen_create(int base_id) throws HDF5LibraryException {
        int id = H5._H5Tvlen_create(base_id);
        if (id > 0) {
            OPEN_IDS.addElement(id);
        }
        return id;
    }

    private static synchronized native int _H5Tvlen_create(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Zfilter_avail(int var0) throws HDF5LibraryException, NullPointerException;

    public static synchronized native int H5Zget_filter_info(int var0) throws HDF5LibraryException;

    public static synchronized native int H5Zunregister(int var0) throws HDF5LibraryException, NullPointerException;

    static {
        isLibraryLoaded = false;
        OPEN_IDS = new Vector();
        H5.loadH5Lib();
    }
}

