/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h4;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.h4.H4Datatype;

public class H4Vdata
extends CompoundDS {
    private static final long serialVersionUID = -5978700886955419959L;
    private List attributeList;
    private int numberOfRecords = 0;
    private int[] memberTIDs;
    private int nAttributes = -1;

    public H4Vdata(FileFormat theFile, String name, String path) {
        this(theFile, name, path, null);
    }

    public H4Vdata(FileFormat theFile, String name, String path, long[] oid) {
        super(theFile, name, path, oid);
        this.numberOfMembers = 0;
        this.memberOrders = null;
    }

    @Override
    public boolean hasAttribute() {
        if (this.nAttributes < 0) {
            int id = this.open();
            try {
                this.nAttributes = HDFLibrary.VSnattrs(id);
            }
            catch (Exception ex) {
                this.nAttributes = 0;
            }
            this.close(id);
        }
        return this.nAttributes > 0;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H4Datatype(-1);
        }
        return this.datatype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws HDFException {
        byte[] theData = null;
        if (this.rank <= 0) {
            this.init();
        }
        if (this.numberOfMembers <= 0) {
            return null;
        }
        int id = this.open();
        if (id < 0) {
            return null;
        }
        String allNames = this.memberNames[0];
        for (int i = 0; i < this.numberOfMembers; ++i) {
            allNames = allNames + "," + this.memberNames[i];
        }
        try {
            HDFLibrary.VSseek(id, (int)this.startDims[0]);
            HDFLibrary.VSsetfields(id, allNames);
            int[] recordSize = new int[]{0};
            HDFLibrary.VSQueryvsize(id, recordSize);
            int size = recordSize[0] * (int)this.selectedDims[0];
            theData = new byte[size];
            int read_num = HDFLibrary.VSread(id, theData, (int)this.selectedDims[0], 0);
        }
        finally {
            this.close(id);
        }
        return theData;
    }

    @Override
    public Object read() throws HDFException {
        Vector<String[]> list = null;
        if (this.rank <= 0) {
            this.init();
        }
        if (this.numberOfMembers <= 0) {
            return null;
        }
        int id = this.open();
        if (id < 0) {
            return null;
        }
        list = new Vector<String[]>();
        HDFLibrary.HXsetdir(this.getFileFormat().getParent());
        Object member_data = null;
        for (int i = 0; i < this.numberOfMembers; ++i) {
            block12: {
                if (!this.isMemberSelected[i]) continue;
                try {
                    HDFLibrary.VSseek(id, (int)this.startDims[0]);
                    HDFLibrary.VSsetfields(id, this.memberNames[i]);
                }
                catch (HDFException ex) {
                    this.isMemberSelected[i] = false;
                    continue;
                }
                int n = this.memberOrders[i] * (int)this.selectedDims[0];
                member_data = H4Datatype.allocateArray(this.memberTIDs[i], n);
                if (member_data == null) {
                    String[] nullValues = new String[n];
                    for (int j = 0; j < n; ++j) {
                        nullValues[j] = "*error*";
                    }
                    list.add(nullValues);
                    continue;
                }
                try {
                    int read_num = HDFLibrary.VSread(id, member_data, (int)this.selectedDims[0], 0);
                    if (this.memberTIDs[i] == 4 || this.memberTIDs[i] == 3) {
                        member_data = Dataset.byteToString((byte[])member_data, this.memberOrders[i]);
                        this.memberTypes[i] = new H4Datatype(3, this.memberOrders[i], -1, -1);
                        this.memberOrders[i] = 1;
                        break block12;
                    }
                    if (!H4Datatype.isUnsigned(this.memberTIDs[i])) break block12;
                    member_data = Dataset.convertFromUnsignedC(member_data);
                }
                catch (HDFException ex) {
                    String[] nullValues = new String[n];
                    for (int j = 0; j < n; ++j) {
                        nullValues[j] = "*error*";
                    }
                    list.add(nullValues);
                    continue;
                }
            }
            list.add((String[])member_data);
        }
        this.close(id);
        return list;
    }

    @Override
    public void write(Object buf) throws HDFException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getMetadata() throws HDFException {
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int id = this.open();
        if (id < 0) {
            return this.attributeList;
        }
        int n = 0;
        try {
            n = HDFLibrary.VSnattrs(id);
            if (n <= 0) {
                List list = this.attributeList;
                return list;
            }
            this.attributeList = new Vector(n, 5);
            boolean b = false;
            String[] attrName = new String[1];
            int[] attrInfo = new int[3];
            for (int i = 0; i < n; ++i) {
                attrName[0] = "";
                try {
                    b = HDFLibrary.VSattrinfo(id, -1, i, attrName, attrInfo);
                    attrInfo[0] = attrInfo[0] & 0xFFFFBFFF;
                }
                catch (HDFException ex) {
                    b = false;
                }
                if (!b) continue;
                long[] attrDims = new long[]{attrInfo[1]};
                Attribute attr = new Attribute(attrName[0], new H4Datatype(attrInfo[0]), attrDims);
                this.attributeList.add(attr);
                String[] buf = H4Datatype.allocateArray(attrInfo[0], attrInfo[1]);
                try {
                    HDFLibrary.VSgetattr(id, -1, i, buf);
                }
                catch (HDFException ex) {
                    buf = null;
                }
                if (buf == null) continue;
                if (attrInfo[0] == 4 || attrInfo[0] == 3) {
                    buf = Dataset.byteToString((byte[])buf, attrInfo[1]);
                }
                attr.setValue(buf);
            }
        }
        finally {
            this.close(id);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object info) throws Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        this.getFileFormat().writeAttribute(this, (Attribute)info, true);
        if (this.attributeList == null) {
            this.attributeList = new Vector();
        }
        this.attributeList.add(info);
    }

    @Override
    public void removeMetadata(Object info) throws HDFException {
    }

    @Override
    public int open() {
        int vsid = -1;
        try {
            vsid = HDFLibrary.VSattach(this.getFID(), (int)this.oid[1], "w");
        }
        catch (HDFException ex) {
            vsid = -1;
        }
        if (vsid < 0) {
            try {
                vsid = HDFLibrary.VSattach(this.getFID(), (int)this.oid[1], "r");
            }
            catch (HDFException ex) {
                vsid = -1;
            }
        }
        return vsid;
    }

    @Override
    public void close(int vsid) {
        try {
            HDFLibrary.VSdetach(vsid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void init() {
        if (this.rank > 0) {
            return;
        }
        int id = this.open();
        if (id < 0) {
            return;
        }
        try {
            this.numberOfMembers = HDFLibrary.VFnfields(id);
            this.numberOfRecords = HDFLibrary.VSelts(id);
        }
        catch (HDFException ex) {
            this.numberOfMembers = 0;
            this.numberOfRecords = 0;
        }
        this.rank = 1;
        this.dims = new long[1];
        this.dims[0] = this.numberOfRecords;
        this.selectedDims = new long[1];
        this.selectedDims[0] = this.numberOfRecords;
        this.selectedIndex[0] = 0;
        this.startDims = new long[1];
        this.startDims[0] = 0L;
        this.memberNames = new String[this.numberOfMembers];
        this.memberTIDs = new int[this.numberOfMembers];
        this.memberTypes = new Datatype[this.numberOfMembers];
        this.memberOrders = new int[this.numberOfMembers];
        this.isMemberSelected = new boolean[this.numberOfMembers];
        for (int i = 0; i < this.numberOfMembers; ++i) {
            this.isMemberSelected[i] = true;
            try {
                this.memberNames[i] = HDFLibrary.VFfieldname(id, i);
                this.memberTIDs[i] = HDFLibrary.VFfieldtype(id, i);
                this.memberTypes[i] = new H4Datatype(this.memberTIDs[i]);
                this.memberTIDs[i] = this.memberTIDs[i] & 0xFFFFBFFF;
                this.memberOrders[i] = HDFLibrary.VFfieldorder(id, i);
                continue;
            }
            catch (HDFException ex) {
                // empty catch block
            }
        }
        this.close(id);
    }

    public int getRecordCount() {
        return this.numberOfRecords;
    }

    public int getFieldCount() {
        return this.numberOfMembers;
    }

    public int[] getFieldOrders() {
        return this.memberOrders;
    }

    public List getMetadata(int ... attrPropList) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

