/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;

public class H5CompoundDS
extends CompoundDS {
    private static final long serialVersionUID = -5968625125574032736L;
    private List attributeList;
    private int nAttributes = -1;
    private H5O_info_t obj_info = new H5O_info_t(-1L, -1L, 0, 0, -1L, 0L, 0L, 0L, 0L, null, null, null);
    private List flatNameList;
    private List flatTypeList;
    private boolean isExternal = false;

    public H5CompoundDS(FileFormat theFile, String name, String path) {
        this(theFile, name, path, null);
    }

    @Deprecated
    public H5CompoundDS(FileFormat theFile, String name, String path, long[] oid) {
        super(theFile, name, path, oid);
        if (oid == null && theFile != null) {
            try {
                byte[] ref_buf = H5.H5Rcreate(theFile.getFID(), this.getFullName(), HDF5Constants.H5R_OBJECT, -1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong(ref_buf, 0);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasAttribute() {
        this.obj_info.num_attrs = this.nAttributes;
        if (this.obj_info.num_attrs < 0L) {
            int did = -1;
            try {
                did = H5.H5Dopen(this.getFID(), this.getPath() + this.getName(), HDF5Constants.H5P_DEFAULT);
                this.obj_info = H5.H5Oget_info(did);
                this.nAttributes = (int)this.obj_info.num_attrs;
            }
            catch (Exception ex) {
                this.obj_info.num_attrs = 0L;
            }
            this.close(did);
        }
        return this.obj_info.num_attrs > 0L;
    }

    @Override
    public Datatype getDatatype() {
        if (this.datatype == null) {
            this.datatype = new H5Datatype(6, -1, -1, -1);
        }
        return this.datatype;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws HDF5Exception {
        byte[] theData = null;
        if (this.rank <= 0) {
            this.init();
        }
        int did = this.open();
        int fspace = -1;
        int mspace = -1;
        int tid = -1;
        try {
            long[] lsize = new long[]{1L};
            for (int j = 0; j < this.selectedDims.length; ++j) {
                lsize[0] = lsize[0] * this.selectedDims[j];
            }
            fspace = H5.H5Dget_space(did);
            mspace = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            if ((long)this.rank * this.dims[0] > 1L) {
                H5.H5Sselect_hyperslab(fspace, HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
            }
            tid = H5.H5Dget_type(did);
            int size = H5.H5Tget_size(tid) * (int)lsize[0];
            theData = new byte[size];
            H5.H5Dread(did, tid, mspace, fspace, HDF5Constants.H5P_DEFAULT, theData);
        }
        finally {
            try {
                H5.H5Sclose(fspace);
            }
            catch (Exception ex2) {}
            try {
                H5.H5Sclose(mspace);
            }
            catch (Exception ex2) {}
            try {
                H5.H5Tclose(tid);
            }
            catch (HDF5Exception ex2) {}
            this.close(did);
        }
        return theData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read() throws HDF5Exception {
        Vector<Object> list = null;
        String[] member_data = null;
        String member_name = null;
        int tid = -1;
        int atom_tid = -1;
        int member_class = -1;
        int member_size = 0;
        int[] spaceIDs = new int[]{-1, -1};
        if (this.rank <= 0) {
            this.init();
        }
        if (this.numberOfMembers <= 0) {
            return null;
        }
        if (this.isExternal) {
            String pdir = this.getFileFormat().getAbsoluteFile().getParent();
            if (pdir == null) {
                pdir = ".";
            }
            H5.H5Dchdir_ext(pdir);
        }
        int did = this.open();
        list = new Vector<Object>(this.flatNameList.size());
        Vector atomicList = new Vector();
        try {
            long[] lsize = new long[]{1L};
            lsize[0] = this.selectHyperslab(did, spaceIDs);
            int n = this.flatNameList.size();
            tid = H5.H5Dget_type(did);
            int tclass = H5.H5Tget_class(tid);
            if (tclass == HDF5Constants.H5T_ARRAY) {
                int tmptid = tid;
                tid = H5.H5Tget_super(tmptid);
                try {
                    H5.H5Tclose(tmptid);
                }
                catch (HDF5Exception ex) {
                    // empty catch block
                }
            }
            this.extractCompoundInfo(tid, null, null, atomicList);
            for (int i = 0; i < n; ++i) {
                boolean isVL = false;
                if (!this.isMemberSelected[i]) continue;
                member_name = new String(this.memberNames[i]);
                atom_tid = (Integer)atomicList.get(i);
                try {
                    member_class = H5.H5Tget_class(atom_tid);
                    member_size = H5.H5Tget_size(atom_tid);
                    member_data = H5Datatype.allocateArray(atom_tid, (int)lsize[0]);
                }
                catch (Exception ex) {
                    member_data = null;
                }
                if (member_data == null || H5.H5Tequal(atom_tid, HDF5Constants.H5T_STD_REF_DSETREG)) {
                    String[] nullValues = new String[(int)lsize[0]];
                    String errorStr = "*unsupported*";
                    int j = 0;
                    while ((long)j < lsize[0]) {
                        nullValues[j] = errorStr;
                        ++j;
                    }
                    list.add(nullValues);
                    continue;
                }
                if (member_class == HDF5Constants.H5T_ARRAY) {
                    int tmptid = H5.H5Tget_super(atom_tid);
                    isVL = H5.H5Tis_variable_str(tmptid);
                    member_class = H5.H5Tget_class(tmptid);
                    try {
                        H5.H5Tclose(tmptid);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                int comp_tid = -1;
                int[] compInfo = new int[]{member_class, member_size, 0};
                try {
                    comp_tid = this.createCompoundFieldType(atom_tid, member_name, compInfo);
                    try {
                        isVL = isVL || H5.H5Tis_variable_str(atom_tid);
                        isVL = isVL || H5.H5Tdetect_class(atom_tid, HDF5Constants.H5T_VLEN);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (isVL) {
                        H5.H5DreadVL(did, comp_tid, spaceIDs[0], spaceIDs[1], HDF5Constants.H5P_DEFAULT, member_data);
                    } else {
                        H5.H5Dread(did, comp_tid, spaceIDs[0], spaceIDs[1], HDF5Constants.H5P_DEFAULT, member_data);
                    }
                }
                catch (HDF5Exception ex2) {
                    String[] nullValues = new String[(int)lsize[0]];
                    int j = 0;
                    while ((long)j < lsize[0]) {
                        nullValues[j] = "";
                        ++j;
                    }
                    list.add(nullValues);
                    continue;
                }
                finally {
                    try {
                        H5.H5Tclose(comp_tid);
                    }
                    catch (Exception ex2) {}
                }
                if (!isVL) {
                    String cname = member_data.getClass().getName();
                    char dname = cname.charAt(cname.lastIndexOf("[") + 1);
                    if (member_class == HDF5Constants.H5T_STRING && this.convertByteToString) {
                        if (dname == 'B') {
                            member_data = H5CompoundDS.byteToString((byte[])member_data, member_size / this.memberOrders[i]);
                        }
                    } else if (member_class == HDF5Constants.H5T_REFERENCE) {
                        if (dname == 'B') {
                            member_data = (String[])HDFNativeData.byteToLong((byte[])member_data);
                        }
                    } else if (compInfo[2] != 0) {
                        member_data = Dataset.convertFromUnsignedC(member_data, null);
                    } else if (member_class == HDF5Constants.H5T_ENUM && this.enumConverted) {
                        try {
                            String[] strs = H5Datatype.convertEnumValueToName(atom_tid, member_data, null);
                            if (strs != null) {
                                member_data = strs;
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                list.add(member_data);
            }
        }
        finally {
            try {
                H5.H5Sclose(spaceIDs[0]);
            }
            catch (Exception ex2) {}
            try {
                H5.H5Sclose(spaceIDs[1]);
            }
            catch (Exception ex2) {}
            try {
                H5.H5Tclose(tid);
            }
            catch (Exception ex2) {}
            int ntypes = atomicList.size();
            for (int i = 0; i < ntypes; ++i) {
                atom_tid = (Integer)atomicList.get(i);
                try {
                    H5.H5Tclose(atom_tid);
                    continue;
                }
                catch (Exception ex2) {}
            }
            this.close(did);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object buf) throws HDF5Exception {
        if (buf == null || this.numberOfMembers <= 0 || !(buf instanceof List)) {
            return;
        }
        List list = (List)buf;
        Object member_data = null;
        String member_name = null;
        int tid = -1;
        int atom_tid = -1;
        int member_class = -1;
        int member_size = 0;
        int[] spaceIDs = new int[]{-1, -1};
        int did = this.open();
        Vector atomicList = new Vector();
        try {
            long[] lsize = new long[]{1L};
            lsize[0] = this.selectHyperslab(did, spaceIDs);
            int idx = 0;
            int n = this.flatNameList.size();
            boolean isEnum = false;
            tid = H5.H5Dget_type(did);
            this.extractCompoundInfo(tid, null, null, atomicList);
            for (int i = 0; i < n; ++i) {
                if (!this.isMemberSelected[i]) continue;
                member_name = new String(this.memberNames[i]);
                atom_tid = (Integer)atomicList.get(i);
                if ((member_data = (Object)list.get(idx++)) == null) continue;
                boolean isVL = false;
                try {
                    isVL = H5.H5Tdetect_class(atom_tid, HDF5Constants.H5T_VLEN);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (isVL) continue;
                try {
                    member_class = H5.H5Tget_class(atom_tid);
                    member_size = H5.H5Tget_size(atom_tid);
                    isEnum = member_class == HDF5Constants.H5T_ENUM;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                Object tmpData = member_data;
                int comp_tid = -1;
                int[] compInfo = new int[]{member_class, member_size, 0};
                try {
                    comp_tid = this.createCompoundFieldType(atom_tid, member_name, compInfo);
                    if (compInfo[2] != 0) {
                        tmpData = H5CompoundDS.convertToUnsignedC(member_data, null);
                    } else if (member_class == HDF5Constants.H5T_STRING && Array.get(member_data, 0) instanceof String) {
                        tmpData = H5CompoundDS.stringToByte((String[])member_data, member_size);
                    } else if (isEnum && Array.get(member_data, 0) instanceof String) {
                        tmpData = H5Datatype.convertEnumNameToValue(atom_tid, (String[])member_data, null);
                    }
                    if (tmpData == null) continue;
                    H5.H5Dwrite(did, comp_tid, spaceIDs[0], spaceIDs[1], HDF5Constants.H5P_DEFAULT, tmpData);
                    continue;
                }
                finally {
                    try {
                        H5.H5Tclose(comp_tid);
                    }
                    catch (Exception ex2) {}
                }
            }
        }
        finally {
            try {
                H5.H5Sclose(spaceIDs[0]);
            }
            catch (Exception ex2) {}
            try {
                H5.H5Sclose(spaceIDs[1]);
            }
            catch (Exception ex2) {}
            try {
                H5.H5Tclose(tid);
            }
            catch (Exception ex2) {}
            int ntypes = atomicList.size();
            for (int i = 0; i < ntypes; ++i) {
                atom_tid = (Integer)atomicList.get(i);
                try {
                    H5.H5Tclose(atom_tid);
                    continue;
                }
                catch (Exception ex2) {}
            }
        }
        this.close(did);
    }

    private long selectHyperslab(int did, int[] spaceIDs) throws HDF5Exception {
        long lsize = 1L;
        boolean isAllSelected = true;
        for (int i = 0; i < this.rank; ++i) {
            lsize *= this.selectedDims[i];
            if (this.selectedDims[i] >= this.dims[i]) continue;
            isAllSelected = false;
        }
        if (isAllSelected) {
            spaceIDs[0] = HDF5Constants.H5S_ALL;
            spaceIDs[1] = HDF5Constants.H5S_ALL;
        } else {
            spaceIDs[1] = H5.H5Dget_space(did);
            spaceIDs[0] = H5.H5Screate_simple(this.rank, this.selectedDims, null);
            H5.H5Sselect_hyperslab(spaceIDs[1], HDF5Constants.H5S_SELECT_SET, this.startDims, this.selectedStride, this.selectedDims, null);
        }
        return lsize;
    }

    @Override
    public List getMetadata() throws HDF5Exception {
        return this.getMetadata(HDF5Constants.H5_INDEX_NAME, HDF5Constants.H5_ITER_INC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata(int ... attrPropList) throws HDF5Exception {
        if (this.rank <= 0) {
            this.init();
        }
        try {
            this.linkTargetObjName = H5File.getLinkTargetName(this);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int did = -1;
        int pid = -1;
        int indxType = HDF5Constants.H5_INDEX_NAME;
        int order = HDF5Constants.H5_ITER_INC;
        if (attrPropList.length > 0) {
            indxType = attrPropList[0];
            if (attrPropList.length > 1) {
                order = attrPropList[1];
            }
        }
        try {
            did = this.open();
            this.attributeList = H5File.getAttribute(did, indxType, order);
            pid = H5.H5Dget_create_plist(did);
            if (H5.H5Pget_layout(pid) == HDF5Constants.H5D_CHUNKED) {
                this.chunkSize = new long[this.rank];
                H5.H5Pget_chunk(pid, this.rank, this.chunkSize);
            } else {
                this.chunkSize = null;
            }
            int[] flags = new int[]{0, 0};
            long[] cd_nelmts = new long[]{2L};
            int[] cd_values = new int[]{0, 0};
            String[] cd_name = new String[]{"", ""};
            int nfilt = H5.H5Pget_nfilters(pid);
            int filter = -1;
            int[] filter_config = new int[]{1};
            this.compression = "";
            for (int i = 0; i < nfilt; ++i) {
                if (i > 0) {
                    this.compression = this.compression + ", ";
                }
                try {
                    filter = H5.H5Pget_filter(pid, i, flags, cd_nelmts, cd_values, 120L, cd_name, filter_config);
                }
                catch (Throwable err) {
                    this.compression = this.compression + "ERROR";
                    continue;
                }
                if (filter == HDF5Constants.H5Z_FILTER_DEFLATE) {
                    this.compression = this.compression + "GZIP: level = " + cd_values[0];
                    continue;
                }
                if (filter == HDF5Constants.H5Z_FILTER_FLETCHER32) {
                    this.compression = this.compression + "Error detection filter";
                    continue;
                }
                if (filter == HDF5Constants.H5Z_FILTER_SHUFFLE) {
                    this.compression = this.compression + "SHUFFLE: Nbytes = " + cd_values[0];
                    continue;
                }
                if (filter != HDF5Constants.H5Z_FILTER_SZIP) continue;
                this.compression = this.compression + "SZIP: Pixels per block = " + cd_values[1];
                int flag = -1;
                try {
                    flag = H5.H5Zget_filter_info(filter);
                }
                catch (Exception ex) {
                    flag = -1;
                }
                if (flag == HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                    this.compression = this.compression + ": H5Z_FILTER_CONFIG_DECODE_ENABLED";
                    continue;
                }
                if (flag != HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED && flag < HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED + HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) continue;
                this.compression = this.compression + ": H5Z_FILTER_CONFIG_ENCODE_ENABLED";
            }
            if (this.compression.length() == 0) {
                this.compression = "NONE";
            }
            try {
                int[] at = new int[]{0};
                H5.H5Pget_alloc_time(pid, at);
                this.compression = this.compression + ",         Storage allocation time: ";
                if (at[0] == HDF5Constants.H5D_ALLOC_TIME_EARLY) {
                    this.compression = this.compression + "Early";
                } else if (at[0] == HDF5Constants.H5D_ALLOC_TIME_INCR) {
                    this.compression = this.compression + "Incremental";
                } else if (at[0] == HDF5Constants.H5D_ALLOC_TIME_LATE) {
                    this.compression = this.compression + "Late";
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        finally {
            try {
                H5.H5Pclose(pid);
            }
            catch (Exception ex) {}
            this.close(did);
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object info) throws Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        boolean attrExisted = false;
        Attribute attr = (Attribute)info;
        String name = attr.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        }
        if (this.attributeList != null) {
            attrExisted = this.attributeList.contains(attr);
        }
        this.getFileFormat().writeAttribute(this, attr, attrExisted);
        if (!attrExisted) {
            this.attributeList.add(attr);
            this.nAttributes = this.attributeList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetadata(Object info) throws HDF5Exception {
        if (!(info instanceof Attribute)) {
            return;
        }
        Attribute attr = (Attribute)info;
        int did = this.open();
        try {
            H5.H5Adelete(did, attr.getName());
            List attrList = this.getMetadata();
            attrList.remove(attr);
            this.nAttributes = attrList.size();
        }
        finally {
            this.close(did);
        }
    }

    @Override
    public int open() {
        int did = -1;
        try {
            did = H5.H5Dopen(this.getFID(), this.getPath() + this.getName(), HDF5Constants.H5P_DEFAULT);
        }
        catch (HDF5Exception ex) {
            did = -1;
        }
        return did;
    }

    @Override
    public void close(int did) {
        try {
            H5.H5Fflush(did, HDF5Constants.H5F_SCOPE_LOCAL);
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            H5.H5Dclose(did);
        }
        catch (HDF5Exception hDF5Exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        int did;
        block48: {
            if (this.rank > 0) {
                this.resetSelection();
                return;
            }
            did = -1;
            int sid = -1;
            int tid = -1;
            int tclass = -1;
            String fullName = this.getPath() + this.getName();
            this.flatNameList = new Vector();
            this.flatTypeList = new Vector();
            int[] memberTIDs = null;
            did = this.open();
            int pid = -1;
            try {
                pid = H5.H5Dget_create_plist(did);
                int nfiles = H5.H5Pget_external_count(pid);
                this.isExternal = nfiles > 0;
            }
            catch (Exception ex) {
            }
            finally {
                try {
                    H5.H5Pclose(pid);
                }
                catch (Exception ex) {}
            }
            try {
                sid = H5.H5Dget_space(did);
                this.rank = H5.H5Sget_simple_extent_ndims(sid);
                if (this.rank == 0) {
                    this.rank = 1;
                    this.dims = new long[1];
                    this.dims[0] = 1L;
                } else {
                    this.dims = new long[this.rank];
                    this.maxDims = new long[this.rank];
                    H5.H5Sget_simple_extent_dims(sid, this.dims, this.maxDims);
                }
                this.startDims = new long[this.rank];
                this.selectedDims = new long[this.rank];
                tid = H5.H5Dget_type(did);
                tclass = H5.H5Tget_class(tid);
                int tmptid = 0;
                if (tclass == HDF5Constants.H5T_ARRAY) {
                    tmptid = tid;
                    tid = H5.H5Tget_super(tmptid);
                    try {
                        H5.H5Tclose(tmptid);
                    }
                    catch (HDF5Exception ex) {
                        // empty catch block
                    }
                }
                this.extractCompoundInfo(tid, "", this.flatNameList, this.flatTypeList);
                this.numberOfMembers = this.flatNameList.size();
                this.memberNames = new String[this.numberOfMembers];
                memberTIDs = new int[this.numberOfMembers];
                this.memberTypes = new Datatype[this.numberOfMembers];
                this.memberOrders = new int[this.numberOfMembers];
                this.isMemberSelected = new boolean[this.numberOfMembers];
                this.memberDims = new Object[this.numberOfMembers];
                for (int i = 0; i < this.numberOfMembers; ++i) {
                    this.isMemberSelected[i] = true;
                    memberTIDs[i] = (Integer)this.flatTypeList.get(i);
                    this.memberTypes[i] = new H5Datatype(memberTIDs[i]);
                    this.memberNames[i] = (String)this.flatNameList.get(i);
                    this.memberOrders[i] = 1;
                    this.memberDims[i] = null;
                    try {
                        tclass = H5.H5Tget_class(memberTIDs[i]);
                    }
                    catch (HDF5Exception ex) {
                        // empty catch block
                    }
                    if (tclass != HDF5Constants.H5T_ARRAY) continue;
                    int n = H5.H5Tget_array_ndims(memberTIDs[i]);
                    long[] mdim = new long[n];
                    H5.H5Tget_array_dims(memberTIDs[i], mdim);
                    int[] idim = new int[n];
                    for (int j = 0; j < n; ++j) {
                        idim[j] = (int)mdim[j];
                    }
                    this.memberDims[i] = idim;
                    tmptid = H5.H5Tget_super(memberTIDs[i]);
                    this.memberOrders[i] = H5.H5Tget_size(memberTIDs[i]) / H5.H5Tget_size(tmptid);
                    try {
                        H5.H5Tclose(tmptid);
                        continue;
                    }
                    catch (HDF5Exception ex) {
                        // empty catch block
                    }
                }
            }
            catch (HDF5Exception ex) {
                this.numberOfMembers = 0;
                this.memberNames = null;
                this.memberTypes = null;
                this.memberOrders = null;
            }
            finally {
                try {
                    H5.H5Tclose(tid);
                }
                catch (HDF5Exception ex2) {}
                try {
                    H5.H5Sclose(sid);
                }
                catch (HDF5Exception ex2) {}
                if (memberTIDs == null) break block48;
                for (int i = 0; i < memberTIDs.length; ++i) {
                    try {
                        H5.H5Tclose((int)memberTIDs[i]);
                        continue;
                    }
                    catch (Exception ex) {}
                }
            }
        }
        this.close(did);
        this.resetSelection();
    }

    @Override
    public void setName(String newName) throws Exception {
        H5File.renameObject(this, newName);
        super.setName(newName);
    }

    private void resetSelection() {
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
            if (this.selectedStride == null) continue;
            this.selectedStride[i] = 1L;
        }
        if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            this.selectedIndex[0] = this.rank - 2;
            this.selectedIndex[1] = this.rank - 1;
            this.selectedIndex[2] = this.rank - 3;
            this.selectedDims[this.rank - 1] = this.dims[this.rank - 1];
            this.selectedDims[this.rank - 2] = this.dims[this.rank - 2];
        }
        this.isDataLoaded = false;
        this.setMemberSelection(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractCompoundInfo(int tid, String name, List names, List types) {
        int nMembers = 0;
        int mclass = -1;
        int mtype = -1;
        String mname = null;
        try {
            nMembers = H5.H5Tget_nmembers(tid);
        }
        catch (Exception ex) {
            nMembers = 0;
        }
        if (nMembers <= 0) {
            return;
        }
        int tmptid = -1;
        for (int i = 0; i < nMembers; ++i) {
            try {
                mtype = H5.H5Tget_member_type(tid, i);
            }
            catch (Exception ex) {
                continue;
            }
            try {
                tmptid = mtype;
                mtype = H5.H5Tget_native_type(tmptid);
            }
            catch (HDF5Exception ex) {
                continue;
            }
            finally {
                try {
                    H5.H5Tclose(tmptid);
                }
                catch (HDF5Exception ex) {}
            }
            try {
                mclass = H5.H5Tget_class(mtype);
            }
            catch (HDF5Exception ex) {
                continue;
            }
            if (names != null) {
                mname = name + H5.H5Tget_member_name(tid, i);
            }
            if (mclass == HDF5Constants.H5T_COMPOUND) {
                this.extractCompoundInfo(mtype, mname + "\u0095", names, types);
                continue;
            }
            if (mclass == HDF5Constants.H5T_ARRAY) {
                try {
                    tmptid = H5.H5Tget_super(mtype);
                    int tmpclass = H5.H5Tget_class(tmptid);
                    if (tmpclass == HDF5Constants.H5T_COMPOUND || tmpclass == HDF5Constants.H5T_ARRAY) {
                        continue;
                    }
                }
                catch (Exception ex) {
                    continue;
                }
                finally {
                    try {
                        H5.H5Tclose(tmptid);
                    }
                    catch (Exception ex) {}
                }
            }
            if (names != null) {
                names.add(mname);
            }
            types.add(new Integer(mtype));
        }
    }

    @Deprecated
    public static Dataset create(String name, Group pgroup, long[] dims, String[] memberNames, Datatype[] memberDatatypes, int[] memberSizes, Object data) throws Exception {
        if (pgroup == null || name == null || dims == null || memberNames == null || memberDatatypes == null || memberSizes == null) {
            return null;
        }
        int nMembers = memberNames.length;
        int[] memberRanks = new int[nMembers];
        long[][] memberDims = new long[nMembers][1];
        for (int i = 0; i < nMembers; ++i) {
            memberRanks[i] = 1;
            memberDims[i][0] = memberSizes[i];
        }
        return H5CompoundDS.create(name, pgroup, dims, memberNames, memberDatatypes, memberRanks, memberDims, data);
    }

    @Deprecated
    public static Dataset create(String name, Group pgroup, long[] dims, String[] memberNames, Datatype[] memberDatatypes, int[] memberRanks, long[][] memberDims, Object data) throws Exception {
        return H5CompoundDS.create(name, pgroup, dims, null, null, -1, memberNames, memberDatatypes, memberRanks, memberDims, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset create(String name, Group pgroup, long[] dims, long[] maxdims, long[] chunks, int gzip, String[] memberNames, Datatype[] memberDatatypes, int[] memberRanks, long[][] memberDims, Object data) throws Exception {
        H5CompoundDS dataset = null;
        String fullPath = null;
        int did = -1;
        int sid = -1;
        int tid = -1;
        int plist = -1;
        if (pgroup == null || name == null || dims == null || memberNames == null || memberDatatypes == null || memberRanks == null || memberDims == null) {
            return null;
        }
        H5File file = (H5File)pgroup.getFileFormat();
        if (file == null) {
            return null;
        }
        String path = "/";
        if (!pgroup.isRoot()) {
            int idx;
            path = pgroup.getPath() + pgroup.getName() + "/";
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            if ((idx = name.lastIndexOf("/")) >= 0) {
                name = name.substring(idx + 1);
            }
        }
        fullPath = path + name;
        int typeSize = 0;
        int nMembers = memberNames.length;
        int[] mTypes = new int[nMembers];
        int memberSize = 1;
        int rank = dims.length;
        for (int i = 0; i < nMembers; ++i) {
            memberSize = 1;
            for (int j = 0; j < memberRanks[i]; ++j) {
                memberSize = (int)((long)memberSize * memberDims[i][j]);
            }
            if (memberSize > 1 && memberDatatypes[i].getDatatypeClass() != 3) {
                int tmptid = -1;
                try {
                    tmptid = memberDatatypes[i].toNative();
                    mTypes[i] = H5.H5Tarray_create(tmptid, memberRanks[i], memberDims[i]);
                }
                finally {
                    try {
                        H5.H5Tclose(tmptid);
                    }
                    catch (Exception ex) {}
                }
            }
            mTypes[i] = memberDatatypes[i].toNative();
            typeSize += H5.H5Tget_size(mTypes[i]);
        }
        try {
            tid = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, typeSize);
            int offset = 0;
            for (int i = 0; i < nMembers; ++i) {
                H5.H5Tinsert(tid, memberNames[i], offset, mTypes[i]);
                offset += H5.H5Tget_size(mTypes[i]);
            }
            sid = H5.H5Screate_simple(rank, dims, maxdims);
            boolean isExtentable = false;
            if (maxdims != null) {
                for (int i = 0; i < maxdims.length; ++i) {
                    if (maxdims[i] == 0L) {
                        maxdims[i] = dims[i];
                    } else if (maxdims[i] < 0L) {
                        maxdims[i] = HDF5Constants.H5S_UNLIMITED;
                    }
                    if (maxdims[i] == dims[i]) continue;
                    isExtentable = true;
                }
            }
            if (chunks == null && isExtentable) {
                chunks = dims;
            }
            plist = HDF5Constants.H5P_DEFAULT;
            if (chunks != null) {
                plist = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
                H5.H5Pset_layout(plist, HDF5Constants.H5D_CHUNKED);
                H5.H5Pset_chunk(plist, rank, chunks);
                if (gzip > 0) {
                    H5.H5Pset_deflate(plist, gzip);
                }
            }
            int fid = file.getFID();
            did = H5.H5Dcreate(fid, fullPath, tid, sid, HDF5Constants.H5P_DEFAULT, plist, HDF5Constants.H5P_DEFAULT);
        }
        finally {
            try {
                H5.H5Pclose(plist);
            }
            catch (HDF5Exception ex) {}
            try {
                H5.H5Sclose(sid);
            }
            catch (HDF5Exception ex) {}
            try {
                H5.H5Tclose(tid);
            }
            catch (HDF5Exception ex) {}
            try {
                H5.H5Dclose(did);
            }
            catch (HDF5Exception ex) {}
            for (int i = 0; i < nMembers; ++i) {
                try {
                    H5.H5Tclose(mTypes[i]);
                    continue;
                }
                catch (HDF5Exception ex) {}
            }
        }
        dataset = new H5CompoundDS(file, name, path);
        if (dataset != null) {
            pgroup.addToMemberList(dataset);
            if (data != null) {
                dataset.init();
                long[] selected = dataset.getSelectedDims();
                for (int i = 0; i < rank; ++i) {
                    selected[i] = dims[i];
                }
                dataset.write(data);
            }
        }
        return dataset;
    }

    @Override
    public boolean isString(int tid) {
        boolean b = false;
        try {
            b = HDF5Constants.H5T_STRING == H5.H5Tget_class(tid);
        }
        catch (Exception ex) {
            b = false;
        }
        return b;
    }

    @Override
    public int getSize(int tid) {
        int tsize = -1;
        try {
            tsize = H5.H5Tget_size(tid);
        }
        catch (Exception ex) {
            tsize = -1;
        }
        return tsize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int createCompoundFieldType(int member_tid, String member_name, int[] compInfo) throws HDF5Exception {
        int arrayType;
        int nested_tid = -1;
        int baseType = arrayType = member_tid;
        int tmp_tid1 = -1;
        int tmp_tid2 = -1;
        int tmp_tid3 = -1;
        int tmp_tid4 = -1;
        try {
            int member_class = compInfo[0];
            int member_size = compInfo[1];
            if (member_class == HDF5Constants.H5T_ARRAY) {
                int mn = H5.H5Tget_array_ndims(member_tid);
                long[] marray = new long[mn];
                H5.H5Tget_array_dims(member_tid, marray);
                tmp_tid2 = baseType = H5.H5Tget_super(member_tid);
                tmp_tid4 = H5.H5Tget_native_type(baseType);
                tmp_tid3 = arrayType = H5.H5Tarray_create(tmp_tid4, mn, marray);
            }
            try {
                if (H5Datatype.isUnsigned(baseType)) {
                    compInfo[2] = 1;
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            member_size = H5.H5Tget_size(member_tid);
            String theName = member_name;
            tmp_tid1 = H5.H5Tcopy(arrayType);
            int sep = member_name.lastIndexOf("\u0095");
            while (sep > 0) {
                theName = member_name.substring(sep + 1);
                nested_tid = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, member_size);
                H5.H5Tinsert(nested_tid, theName, 0L, tmp_tid1);
                try {
                    H5.H5Tclose(tmp_tid1);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                tmp_tid1 = nested_tid;
                member_name = member_name.substring(0, sep);
                sep = member_name.lastIndexOf("\u0095");
            }
            nested_tid = H5.H5Tcreate(HDF5Constants.H5T_COMPOUND, member_size);
            H5.H5Tinsert(nested_tid, member_name, 0L, tmp_tid1);
        }
        finally {
            try {
                H5.H5Tclose(tmp_tid1);
            }
            catch (HDF5Exception ex3) {}
            try {
                H5.H5Tclose(tmp_tid2);
            }
            catch (HDF5Exception ex3) {}
            try {
                H5.H5Tclose(tmp_tid3);
            }
            catch (HDF5Exception ex3) {}
            try {
                H5.H5Tclose(tmp_tid4);
            }
            catch (HDF5Exception ex3) {}
        }
        return nested_tid;
    }
}

