/*
 * Decompiled with CFR 0.152.
 */
package neurord.disc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import neurord.disc.CurvedVolumeSlice;
import neurord.disc.Resolution;
import neurord.disc.TreeUtil;
import neurord.numeric.morph.TreePoint;
import neurord.numeric.morph.VolumeGrid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DiscSplitter {
    static final Logger log = LogManager.getLogger();
    TreePoint[] srcPoints;
    ArrayList<CurvedVolumeSlice> gridAL;
    HashSet<TreePoint> wkpHS;
    Resolution resolution;
    double[] surfaceLayers = new double[0];
    double maxAR = 3.0;

    public DiscSplitter(TreePoint[] pts, double d, HashMap<String, Double> resHM, double[] sl, double mar) {
        this.srcPoints = pts;
        this.resolution = new Resolution(d, resHM);
        if (sl != null && sl.length > 0) {
            this.surfaceLayers = sl;
        }
        if (mar > 0.5) {
            this.maxAR = mar;
            log.info("set max aspect ratio {}", this.maxAR);
        }
    }

    public VolumeGrid buildGrid() {
        TreePoint firstpt = null;
        this.wkpHS = new HashSet();
        for (TreePoint tp : this.srcPoints) {
            this.wkpHS.add(tp);
            if (firstpt != null || !tp.isEndPoint()) continue;
            firstpt = tp;
        }
        TreeUtil.parentizeFrom(firstpt, this.srcPoints);
        this.gridAL = new ArrayList();
        CurvedVolumeSlice vg0 = null;
        this.wkpHS.remove(firstpt);
        this.recAdd(vg0, firstpt);
        VolumeGrid vgr = new VolumeGrid();
        vgr.importSmoothSlices(this.gridAL);
        return vgr;
    }

    private void recAdd(CurvedVolumeSlice pGrid, TreePoint tp) {
        String lbl = tp.getLabel();
        tp.partBranchOffset = 0.0;
        for (TreePoint tpn : tp.getNeighbors()) {
            if (!this.wkpHS.contains(tpn)) continue;
            this.wkpHS.remove(tpn);
            if (lbl == null && tpn.nnbr == 1 && tpn.getLabel() != null) {
                lbl = tpn.getLabel();
            }
            CurvedVolumeSlice vg = null;
            if (tpn.subAreaPeer != tp) {
                if (tp.subAreaPeer != null && tp.subAreaPeer == tp.parent) {
                    TreePoint par = tp.parent;
                    log.info("starting a sub-branch at {} - {} {}", tp, tpn, pGrid);
                    vg = this.baseGrid(tp, tpn, lbl);
                    pGrid.subPlaneConnect(tp, tpn, vg, par.partBranchOffset);
                    par.partBranchOffset += 2.0 * tpn.getRadius();
                } else if (pGrid == null) {
                    vg = this.baseGrid(tp, tpn, lbl);
                } else {
                    vg = this.baseGrid(tp, tpn, lbl);
                    pGrid.planeConnect(vg);
                }
            }
            lbl = null;
            if (vg != null) {
                this.gridAL.add(vg);
                this.recAdd(vg, tpn);
                continue;
            }
            this.recAdd(pGrid, tpn);
        }
    }

    public CurvedVolumeSlice baseGrid(TreePoint tpa, TreePoint tpb, String lbl) {
        String rgn = tpa.regionClassWith(tpb);
        double delta = this.resolution.getLocalDelta(tpa, tpb);
        CurvedVolumeSlice ret = new CurvedVolumeSlice(delta, tpa.getRadius(), tpb.getRadius());
        ret.discFill(tpa, tpb, lbl, rgn, this.surfaceLayers, this.maxAR);
        return ret;
    }
}

