/*
 * Decompiled with CFR 0.152.
 */
package neurord.disc;

import java.util.ArrayList;
import neurord.numeric.morph.TreePoint;

public class SegmentMerger {
    private TreePoint[] merge(TreePoint[] pt, double maxdr, double maxlen, double tol) {
        for (int i = 0; i < pt.length; ++i) {
            pt[i].setWork(2);
        }
        TreePoint p0 = pt[0];
        this.recMerge(p0, maxdr, maxlen, tol);
        int nl = 0;
        for (int i = 0; i < pt.length; ++i) {
            if (pt[i].getWork() <= 0) continue;
            ++nl;
        }
        TreePoint[] pr = new TreePoint[nl];
        nl = 0;
        for (int i = 0; i < pt.length; ++i) {
            if (pt[i].getWork() <= 0) continue;
            pr[nl++] = pt[i];
        }
        return pr;
    }

    private void recMerge(TreePoint cp, double maxdr, double maxlen, double tol) {
        cp.setWork(1);
        for (int j = 0; j < cp.nnbr; ++j) {
            TreePoint cq = cp.nbr[j];
            if (cq.getWork() == 2 && cq.nnbr == 2 && Math.abs((cq.getRadius() - cp.getRadius()) / (cq.getRadius() + cp.getRadius())) < 0.5 * maxdr && cp.distanceTo(cq) < maxlen) {
                boolean cor;
                double dl;
                TreePoint cprev = cp;
                ArrayList<TreePoint> vpt = new ArrayList<TreePoint>();
                double ltot = 0.0;
                double ldtot = 0.0;
                while (cq.nnbr == 2 && cprev.distanceTo(cq) < maxlen && Math.abs((cq.getRadius() - cp.getRadius()) / (cq.getRadius() + cp.getRadius())) < 0.5 * maxdr) {
                    vpt.add(cq);
                    dl = cprev.distanceTo(cq);
                    ltot += dl;
                    ldtot += dl * (cprev.getRadius() + cq.getRadius());
                    TreePoint cnxt = cq.nbr[0] == cprev ? cq.nbr[1] : cq.nbr[0];
                    cprev = cq;
                    cq = cnxt;
                }
                dl = cprev.distanceTo(cq);
                ldtot += dl * (cprev.getRadius() + cq.getRadius());
                double lab = cp.distanceTo(cq);
                double ldab = lab * (cp.getRadius() + cq.getRadius());
                int nadd = (int)((ltot += dl) / maxlen);
                if (nadd > vpt.size()) {
                    nadd = vpt.size();
                }
                boolean bl = cor = Math.abs((lab - ltot) / (lab + ltot)) > 0.5 * tol || Math.abs((ldab - ldtot) / (ldab + ldtot)) > 0.5 * tol;
                if (cor && nadd == 0) {
                    nadd = 1;
                }
                if (nadd == 0) {
                    cp.replaceNeighbor((TreePoint)vpt.get(0), cq);
                    cq.replaceNeighbor((TreePoint)vpt.get(vpt.size() - 1), cp);
                } else {
                    for (int i = 0; i < nadd; ++i) {
                        TreePoint cm = (TreePoint)vpt.get(i);
                        cm.setWork(1);
                        cm.locateBetween(cp, cq, (1.0 + (double)i) / (1.0 + (double)nadd));
                        if (i != nadd - 1 || nadd >= vpt.size()) continue;
                        cm.replaceNeighbor((TreePoint)vpt.get(nadd), cq);
                        cq.replaceNeighbor((TreePoint)vpt.get(vpt.size() - 1), cm);
                    }
                }
                for (int jd = nadd; jd < vpt.size(); ++jd) {
                    TreePoint cd = (TreePoint)vpt.get(jd);
                    cd.nnbr = 0;
                    cd.setWork(0);
                }
                if (cor) {
                    double dpar = lab / (double)(nadd + 1);
                    double fl = ltot / lab;
                    double dperp = Math.sqrt((fl * fl - 1.0) * dpar * dpar);
                    double fr = ldtot / (fl * ldab);
                    for (int i = 0; i < nadd; ++i) {
                        TreePoint cm = (TreePoint)vpt.get(i);
                        cm.setRadius(cm.getRadius() * fr);
                        if (i % 2 != 0) continue;
                        cm.movePerp(cp, cq, i / 2 % 2 == 0 ? dperp : -dperp);
                    }
                }
            }
            if (cq.getWork() != 2) continue;
            this.recMerge(cq, maxdr, maxlen, tol);
        }
    }
}

