/*
 * Decompiled with CFR 0.152.
 */
package neurord.inter;

import java.io.File;
import java.util.StringTokenizer;
import neurord.inter.SDState;
import neurord.util.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StateReader {
    static final Logger log = LogManager.getLogger();

    public static SDState readState(String fnm) {
        String s = FileUtil.readStringFromFile(new File(fnm));
        return StateReader.readStateString(s);
    }

    public static SDState readStateString(String sdata) {
        String[] bits;
        SDState ret = new SDState();
        boolean readok = true;
        StringTokenizer st = new StringTokenizer(sdata, "\n");
        if (st.hasMoreTokens()) {
            bits = st.nextToken().split(" ");
            ret.nel = Integer.parseInt(bits[1]);
            ret.nspec = Integer.parseInt(bits[2]);
        } else {
            readok = false;
        }
        if (readok) {
            if (st.hasMoreTokens()) {
                bits = st.nextToken().split(" ");
                if (bits.length != ret.nspec) {
                    log.warn("wrong length for specie list {}, {}", bits.length, ret.nspec);
                    readok = false;
                } else {
                    ret.specids = bits;
                }
            } else {
                readok = false;
            }
        }
        double[][] conc = new double[ret.nel][ret.nspec];
        if (readok) {
            for (int iel = 0; iel < ret.nel; ++iel) {
                if (st.hasMoreTokens()) {
                    String[] bits2 = st.nextToken().split(" ");
                    if (bits2.length != ret.nspec) continue;
                    for (int j = 0; j < ret.nspec; ++j) {
                        conc[iel][j] = Double.parseDouble(bits2[j]);
                    }
                    continue;
                }
                readok = false;
                break;
            }
        }
        ret.conc = conc;
        if (!readok) {
            log.warn("ignoring initial conditions file");
            ret = null;
        }
        return ret;
    }
}

