/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import neurord.model.MaxElementSide;
import neurord.util.ArrayUtil;
import neurord.xml.DoubleListAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Discretization {
    static final Logger log = LogManager.getLogger();
    Double spineDeltaX;
    private Double defaultMaxElementSide;
    private String elementShape;
    private Double maxAspectRatio;
    @XmlJavaTypeAdapter(value=DoubleListAdapter.class)
    List<Double> surfaceLayers;
    private List<MaxElementSide> maxElementSide;
    private transient HashMap<String, Double> maxSideHM;
    public static final Discretization SINGLE_VOXEL = new Discretization();

    public synchronized HashMap<String, Double> getResolutionHM() {
        if (this.maxSideHM == null) {
            this.maxSideHM = new HashMap();
            if (this.maxElementSide != null) {
                for (MaxElementSide side : this.maxElementSide) {
                    Double old = this.maxSideHM.put(side.region, side.value);
                    if (old == null) continue;
                    log.error("Duplicate maxElementSide for region '{}'", side.region);
                    throw new RuntimeException("Duplicate maxElementSide");
                }
            }
        }
        return this.maxSideHM;
    }

    public boolean curvedElements() {
        return "Curved".equals(this.elementShape);
    }

    public double getMaxAspectRatio() {
        if (this.maxAspectRatio == null) {
            return 0.0;
        }
        return this.maxAspectRatio;
    }

    public double[] getSurfaceLayers() {
        return ArrayUtil.toDoubleArray(this.surfaceLayers);
    }

    public double getDefaultMaxElementSide() {
        if (this.defaultMaxElementSide == null) {
            return 1.0;
        }
        return this.defaultMaxElementSide;
    }

    static {
        Discretization.SINGLE_VOXEL.defaultMaxElementSide = Double.POSITIVE_INFINITY;
    }
}

