/*
 * Decompiled with CFR 0.152.
 */
package neurord.model;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import neurord.disc.SpineLocator;
import neurord.disc.TreeBoxDiscretizer;
import neurord.disc.TreeCurvedElementDiscretizer;
import neurord.model.Discretization;
import neurord.model.IOutputSet;
import neurord.model.InitialConditions;
import neurord.model.InjectionStim;
import neurord.model.Morphology;
import neurord.model.OutputScheme;
import neurord.model.OutputSet;
import neurord.model.ReactionScheme;
import neurord.model.Statistics;
import neurord.model.StimulationSet;
import neurord.numeric.BaseCalc;
import neurord.numeric.chem.ReactionTable;
import neurord.numeric.chem.StimulationTable;
import neurord.numeric.grid.ResultWriterHDF5;
import neurord.numeric.morph.TreePoint;
import neurord.numeric.morph.VolumeGrid;
import neurord.util.ArrayUtil;
import neurord.xml.ModelReader;
import neurord.xml.StringListAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="SDRun")
public class SDRun
implements IOutputSet {
    static final Logger log = LogManager.getLogger();
    @XmlElement(name="ReactionScheme")
    private ReactionScheme reactionScheme;
    @XmlElement(name="StimulationSet")
    private StimulationSet stimulationSet;
    @XmlElement(name="Morphology")
    private Morphology morphology;
    @XmlElement(name="InitialConditions")
    private InitialConditions initialConditions;
    @XmlElement(name="OutputScheme")
    public OutputScheme outputScheme;
    private Discretization discretization;
    public String action;
    private String geometry;
    public double depth2D = 0.5;
    private Double runtime;
    private Double starttime;
    private Double endtime;
    public String output;
    public int spineSeed;
    public long simulationSeed;
    private Double fixedStepDt;
    private double outputInterval;
    @XmlJavaTypeAdapter(value=StringListAdapter.class)
    private List<String> outputSpecies;
    public String outputQuantity = "NUMBER";
    public double tolerance = 0.001;
    public double leap_min_jump = 2.0;
    public String calculation;
    public Statistics statistics;
    public String distribution;
    public String algorithm;
    private transient VolumeGrid volumeGrid;
    private transient ReactionTable reactionTable;
    private transient StimulationTable stimulationTable;
    private transient InitialConditions _empty_initalConditions;
    private transient boolean _initialConditions_checked = false;
    private transient int[][] population;

    public BaseCalc.algorithm_t getAlgorithm() {
        if (this.algorithm == null) {
            return BaseCalc.algorithm_t.INDEPENDENT;
        }
        return BaseCalc.algorithm_t.valueOf(this.algorithm);
    }

    public VolumeGrid.geometry_t getGeometry() {
        if (this.geometry == null) {
            return VolumeGrid.geometry_t.GEOM_2D;
        }
        return VolumeGrid.geometry_t.fromString(this.geometry);
    }

    @Override
    public String getRegion() {
        return null;
    }

    @Override
    public String getIdentifier() {
        return "out";
    }

    @Override
    public double getOutputInterval(double fallback) {
        return this.outputInterval;
    }

    public double getOutputInterval() {
        return this.outputInterval;
    }

    public void overrideRuntime(double runtime) {
        if (runtime < 0.0) {
            throw new RuntimeException("Runtime must be non-negative: " + runtime);
        }
        log.debug("Overriding runtime: {} \u2192 {}", this.runtime, runtime);
        this.runtime = runtime;
    }

    public void overrideStatistics(String statistics, Double interval) {
        if (statistics != null) {
            switch (statistics) {
                case "none": 
                case "injections": 
                case "by-channel": 
                case "by-event": {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown statistics value: " + statistics);
                }
            }
            log.debug("Overriding statistics gathering: {} \u2192 {}", this.getStatistics(), statistics);
            if (this.statistics == null) {
                this.statistics = new Statistics();
            }
            this.statistics.value = statistics;
        }
        if (interval != null) {
            if (!(interval >= 0.0)) {
                throw new RuntimeException("Bad statistics interval: " + interval);
            }
            log.debug("Overriding statistics interval: {} \u2192 {}", this.getStatisticsInterval(), interval);
            if (this.statistics == null) {
                this.statistics = new Statistics();
            }
            this.statistics.interval = interval;
        }
    }

    public String getStatistics() {
        if (this.statistics != null && this.statistics.value != null) {
            return this.statistics.value;
        }
        return "injections";
    }

    public double getStatisticsInterval() {
        if (this.statistics != null && this.statistics.interval != null) {
            assert (this.statistics.interval >= 0.0);
            return this.statistics.interval;
        }
        return 0.0;
    }

    public double getFixedStepDt() {
        if (this.fixedStepDt != null) {
            return this.fixedStepDt;
        }
        return Double.POSITIVE_INFINITY;
    }

    public List<? extends IOutputSet> getOutputSets() {
        if (this.outputScheme != null) {
            return this.outputScheme.outputSets;
        }
        return null;
    }

    public boolean writeDependencies() {
        if (this.outputScheme == null || this.outputScheme.dependencies == null) {
            return false;
        }
        return this.outputScheme.dependencies;
    }

    private ReactionScheme getReactionScheme() {
        if (this.reactionScheme == null) {
            log.error("<ReactionScheme> element is required");
            throw new RuntimeException("<ReactionScheme> element is required");
        }
        return this.reactionScheme;
    }

    public synchronized ReactionTable getReactionTable() {
        if (this.reactionTable == null) {
            this.reactionTable = this.getReactionScheme().makeReactionTable();
        }
        return this.reactionTable;
    }

    public synchronized StimulationTable getStimulationTable() {
        if (this.stimulationTable == null) {
            List<InjectionStim> stimulations = null;
            if (this.stimulationSet != null) {
                stimulations = this.stimulationSet.stimulations;
            }
            this.stimulationTable = new StimulationTable(stimulations, this.getReactionTable());
        }
        return this.stimulationTable;
    }

    public Morphology getMorphology() {
        if (this.morphology == null) {
            log.error("<Morphology> element is required");
            throw new RuntimeException("<Morphology> element is required");
        }
        this.morphology.resolve(this.depth2D);
        return this.morphology;
    }

    public String[] getSpecies() {
        return this.getReactionScheme().getSpecies();
    }

    @Override
    public List<String> getNamesOfOutputSpecies() {
        return this.outputSpecies;
    }

    @Override
    public int[] getIndicesOfOutputSpecies(String[] species) {
        return OutputSet.outputSpecieIndices("outputSpecies", this.outputSpecies, species);
    }

    public Discretization getDiscretization() {
        if (this.discretization != null) {
            return this.discretization;
        }
        return Discretization.SINGLE_VOXEL;
    }

    public synchronized InitialConditions getInitialConditions() {
        InitialConditions c;
        if (this.initialConditions != null) {
            c = this.initialConditions;
        } else {
            if (this._empty_initalConditions == null) {
                this._empty_initalConditions = new InitialConditions();
            }
            c = this._empty_initalConditions;
        }
        if (!this._initialConditions_checked) {
            c.verify(this.getVolumeGrid().getRegionLabels(), this.getSpecies());
            this._initialConditions_checked = true;
        }
        return c;
    }

    public double getStartTime() {
        if (this.starttime != null) {
            return this.starttime;
        }
        return 0.0;
    }

    public double getEndTime() {
        if (this.endtime != null) {
            return this.endtime;
        }
        if (this.runtime != null) {
            return this.runtime + this.getStartTime();
        }
        log.error("Either runtime or endtime must be specified in the model file");
        throw new RuntimeException("Either runtime or endtime must be specified in the model file");
    }

    public synchronized VolumeGrid getVolumeGrid() {
        if (this.volumeGrid == null) {
            Morphology morph = this.getMorphology();
            TreePoint[] tpa = morph.getTreePoints();
            Discretization disc = this.getDiscretization();
            double d = disc.getDefaultMaxElementSide();
            double deltaX = disc.spineDeltaX != null ? disc.spineDeltaX : d;
            double[] diameters = new double[tpa.length];
            double[] candidate_grid_sizes = new double[tpa.length];
            for (int i = 0; i < tpa.length; ++i) {
                double diameter;
                diameters[i] = diameter = tpa[i].getRadius() * 2.0;
                double denominator = 1.0;
                while (diameter / denominator > d) {
                    denominator += 2.0;
                }
                candidate_grid_sizes[i] = diameter / denominator;
            }
            d = Math.min(d, ArrayUtil.min(candidate_grid_sizes));
            log.info("Subvolume grid size is: {} (from radii {}, candidates {}, default {})", d, diameters, candidate_grid_sizes, disc.getDefaultMaxElementSide());
            if (disc.curvedElements()) {
                TreeCurvedElementDiscretizer tced = new TreeCurvedElementDiscretizer(tpa);
                this.volumeGrid = tced.buildGrid(d, disc.getResolutionHM(), disc.getSurfaceLayers(), disc.getMaxAspectRatio());
            } else {
                this.volumeGrid = TreeBoxDiscretizer.buildGrid(tpa, d, disc.getResolutionHM(), disc.getSurfaceLayers(), this.getGeometry(), this.depth2D);
            }
            SpineLocator.locate(this.spineSeed, morph.getSpineDistribution(), deltaX, this.volumeGrid);
            this.volumeGrid.fix();
            log.info("{} subvolumes", this.volumeGrid.size());
        }
        return this.volumeGrid;
    }

    public synchronized int[][] getStimulationTargets() {
        VolumeGrid grid = this.getVolumeGrid();
        String[] targets = this.getStimulationTable().getTargetIDs();
        return grid.getAreaIndexes(targets);
    }

    public double[] getRegionConcentration(String region) {
        return this.getInitialConditions().getRegionConcentration(region, this.getSpecies());
    }

    public double[][] getRegionConcentrations() {
        String[] regions = this.getVolumeGrid().getRegionLabels();
        return this.getInitialConditions().makeRegionConcentrations(regions, this.getSpecies());
    }

    public double[] getRegionSurfaceDensity(String region) {
        return this.getInitialConditions().getRegionSurfaceDensity(region, this.getSpecies());
    }

    public double[][] getRegionSurfaceDensities() {
        String[] regions = this.getVolumeGrid().getRegionLabels();
        return this.getInitialConditions().makeRegionSurfaceDensities(regions, this.getSpecies());
    }

    public String serialize() {
        try {
            ModelReader<SDRun> loader = new ModelReader<SDRun>(SDRun.class);
            return loader.marshall(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static SDRun deserialize(String xml, Long seed) {
        ModelReader<SDRun> loader = new ModelReader<SDRun>(SDRun.class);
        HashMap<String, String> overrides = null;
        if (seed != null) {
            overrides = new HashMap<String, String>();
            overrides.put("SDRun.simulationSeed", "" + seed);
        }
        log.info("Loading model from xml with seed {}", seed);
        try {
            return loader.unmarshall(xml, overrides);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static SDRun deserialize(File filename, Long seed) {
        ModelReader<SDRun> loader = new ModelReader<SDRun>(SDRun.class);
        HashMap<String, String> overrides = null;
        if (seed != null) {
            overrides = new HashMap<String, String>();
            overrides.put("SDRun.simulationSeed", "" + seed);
        }
        log.info("Loading model from \"{}\" with seed {}", filename, seed);
        try {
            return loader.unmarshall(filename, overrides);
        }
        catch (ModelReader.XMLUnmarshallingFailure e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int[][] getPopulation() {
        return this.population;
    }

    public static boolean speciesMatch(String[] a, String[] b) {
        if (a.length != b.length) {
            log.error("Different number of species: {} vs {}", a.length, b.length);
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            log.error("Species {}mismatch: {} vs {}", i, a[i], b[i]);
            return false;
        }
        return true;
    }

    public static SDRun loadFromFile(File model_file, File ic_file, int trial, double population_from_time) {
        SDRun sdrun;
        boolean have_time;
        boolean h5 = model_file.toString().endsWith(".h5");
        if (Double.isNaN(population_from_time) && ic_file != null) {
            population_from_time = 0.0;
        }
        boolean bl = have_time = !Double.isNaN(population_from_time);
        if (!h5 && ic_file == null && have_time) {
            throw new RuntimeException("Cannot load population from .xml file (--ic-time option)");
        }
        ResultWriterHDF5.LoadModelResult ic = null;
        if (ic_file != null) {
            ic = ResultWriterHDF5.loadModel(ic_file, trial, population_from_time);
        }
        ResultWriterHDF5.LoadModelResult model = null;
        if (h5) {
            model = ResultWriterHDF5.loadModel(model_file, trial, ic_file == null ? population_from_time : Double.NaN);
            sdrun = SDRun.deserialize(model.xml, (Long)(ic != null ? ic.seed : model.seed));
        } else {
            sdrun = SDRun.deserialize(model_file, ic != null ? Long.valueOf(ic.seed) : null);
        }
        if (have_time) {
            String[] species;
            String[] stringArray = species = ic == null ? model.species : ic.species;
            if (!SDRun.speciesMatch(sdrun.getSpecies(), species)) {
                throw new RuntimeException("Species list mismatch");
            }
            sdrun.population = ic == null ? model.population : ic.population;
        }
        return sdrun;
    }

    public double stepSize() {
        return Math.min(Math.min(this.getFixedStepDt(), this.getOutputInterval()), this.getEndTime() - this.getStartTime());
    }
}

