/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.grid;

import java.util.Collection;
import neurord.model.SDRun;
import neurord.numeric.grid.GridCalc;
import neurord.numeric.grid.IGridCalc;
import neurord.numeric.math.Column;
import neurord.numeric.math.Matrix;
import neurord.numeric.morph.VolumeGrid;
import neurord.util.ArrayUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeterministicGridCalc
extends GridCalc {
    static final Logger log = LogManager.getLogger();
    int[][] eltstims;
    double[][] eltstimshare;
    double[][] wkA;
    double[][] wktm1;
    double[][] wkC;
    long event_count = 0L;
    final double[][] couplingConstants;

    @Override
    public boolean preferConcs() {
        return true;
    }

    public DeterministicGridCalc(int trial, SDRun sdrun) {
        super(trial, sdrun);
        VolumeGrid grid = sdrun.getVolumeGrid();
        this.couplingConstants = grid.getPerElementCouplingConstants();
    }

    @Override
    public final void init() {
        int i;
        super.init();
        int numStim = this.sdRun.getStimulationTable().getStimulations().size();
        this.eltstims = new int[numStim][this.nel];
        this.eltstimshare = new double[numStim][this.nel];
        for (int stimnum = 0; stimnum < numStim; ++stimnum) {
            for (i = 0; i < this.eltstims[stimnum].length; ++i) {
                this.eltstims[stimnum][i] = -1;
            }
        }
        int[][] stimtargets = this.sdRun.getStimulationTargets();
        for (i = 0; i < stimtargets.length; ++i) {
            int k;
            int[] asti = stimtargets[i];
            double vtot = 0.0;
            for (k = 0; k < asti.length; ++k) {
                vtot += this.volumes[asti[k]];
            }
            for (k = 0; k < asti.length; ++k) {
                this.eltstims[i][asti[k]] = i;
                this.eltstimshare[i][asti[k]] = this.volumes[asti[k]] / vtot;
            }
        }
        this.wkA = new double[this.nel][this.nspec];
        this.wktm1 = new double[this.nel][this.nspec];
        this.wkC = new double[this.nel][this.nspec];
        VolumeGrid grid = this.sdRun.getVolumeGrid();
        for (int i2 = 0; i2 < this.nel; ++i2) {
            double[] rcs = this.sdRun.getRegionConcentration(grid.getElementRegion(i2));
            for (int j = 0; j < this.nspec; ++j) {
                this.wkA[i2][j] = rcs[j];
                this.wktm1[i2][j] = rcs[j];
                this.wkC[i2][j] = rcs[j];
            }
            double a = this.surfaceAreas[i2];
            if (!(a > 0.0)) continue;
            double[] scs = this.sdRun.getRegionSurfaceDensity(grid.getElementRegion(i2));
            double concfac = a / this.volumes[i2];
            for (int j = 0; j < this.nspec; ++j) {
                if (Double.isNaN(scs[j])) continue;
                this.wkA[i2][j] = concfac * scs[j];
                this.wktm1[i2][j] = concfac * scs[j];
                this.wkC[i2][j] = concfac * scs[j];
            }
        }
    }

    @Override
    public double advance(double tnow, double tend) {
        double dt = tend - tnow;
        ArrayUtil.fill(this.wkC, 0.0);
        double[] zl = new double[this.nspec];
        double[] zr = new double[this.nspec];
        for (int iel = 0; iel < this.nel; ++iel) {
            double vol = this.volumes[iel];
            double fvol = 2.0 * dt / vol;
            for (int k = 0; k < this.nspec; ++k) {
                zr[k] = this.wkC[iel][k] / vol;
                zl[k] = 1.0;
            }
            int[] inbr = this.neighbors[iel];
            double[] gnbr = this.couplingConstants[iel];
            int nnbr = inbr.length;
            for (int k = 0; k < this.nspec; ++k) {
                if (this.fdiff[k] > 0.0) {
                    for (int j = 0; j < nnbr; ++j) {
                        double ff = fvol * this.fdiff[k] * gnbr[j];
                        int n = k;
                        zr[n] = zr[n] + ff * (this.wkA[inbr[j]][k] - 0.5 * this.wktm1[iel][k]);
                        int n2 = k;
                        zl[n2] = zl[n2] + 0.5 * ff;
                    }
                }
                this.wkC[iel][k] = (this.wkA[iel][k] + zr[k]) / zl[k];
            }
        }
        this.event_count += (long)(this.nel * this.nspec);
        double[][] stims = this.sdRun.getStimulationTable().getStimsForInterval(tnow, dt);
        for (int iel = 0; iel < this.nel; ++iel) {
            double[] concinc = null;
            boolean concnull = true;
            double fconc = 1.660538783162726 / this.volumes[iel];
            for (int stimnum = 0; stimnum < stims.length; ++stimnum) {
                if (this.eltstims[stimnum][iel] < 0) continue;
                if (concinc == null) {
                    concinc = new double[this.nspec];
                }
                double[] pinj = stims[stimnum];
                for (int i = 0; i < pinj.length; ++i) {
                    int n = i;
                    concinc[n] = concinc[n] + pinj[i] * fconc * this.eltstimshare[stimnum][iel];
                    if (concinc[i] < 0.0) {
                        log.error("negative concentration: {}", new Object[]{concinc});
                    }
                    ++this.event_count;
                }
            }
            this.reacStep(this.wkC[iel], dt, concnull ? null : concinc);
            this.event_count += (long)this.wkC[iel].length;
        }
        double[][] wkT = this.wktm1;
        this.wktm1 = this.wkA;
        this.wkA = this.wkC;
        this.wkC = wkT;
        return dt;
    }

    @Override
    protected long eventCount() {
        return this.event_count;
    }

    private void reacStep(double[] concs, double deltat, double[] concinc) {
        Column col = new Column(concs);
        Matrix m = this.rtab.getIncrementRateMatrix(col);
        Column cp = this.rtab.getProductionColumn(col);
        Column cpdt = cp.times(deltat);
        m.multiplyBy(this.dt);
        m.subtractIdentity();
        m.negate();
        if (concinc != null) {
            cpdt.incrementBy(concinc);
        }
        Column dc = m.LUSolve(cpdt);
        col.incrementBy(dc);
        col.writeTo(concs);
    }

    @Override
    public double getGridPartConc(int i, int j) {
        return this.wkA[i][j];
    }

    @Override
    public int getGridPartNumb(int i, int j) {
        double val = this.getGridPartConc(i, j);
        return (int)Math.round(val * this.volumes[i] * 0.602214179);
    }

    @Override
    public int[][] getEventStatistics() {
        return null;
    }

    @Override
    protected void resetEventStatistics() {
    }

    @Override
    public Collection<IGridCalc.Event> getEvents() {
        return null;
    }

    @Override
    public Collection<IGridCalc.Happening> getHappenings() {
        return null;
    }
}

