/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.math;

import neurord.numeric.math.MersenneTwister;

public class RandomMath {
    private static double[] cof = new double[]{76.18009173, -86.50532033, 24.01409822, -1.231739516, 0.00120858003, -5.36382E-6};

    public static final int poissonInt(double d, MersenneTwister gen) {
        return (int)RandomMath.poidev(d, gen);
    }

    public static final double gammln(double xx) {
        double x = xx - 1.0;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.0;
        for (int j = 0; j <= 5; ++j) {
            ser += cof[j] / (x += 1.0);
        }
        return -tmp + Math.log(2.50662827465 * ser);
    }

    public static final double poidev(double xm, MersenneTwister gen) {
        double em = -1.0;
        if (xm < 12.0) {
            double g = Math.exp(-xm);
            double t = 1.0;
            do {
                em += 1.0;
            } while ((t *= (double)gen.random()) > g);
        } else {
            double sq = Math.sqrt(2.0 * xm);
            double alxm = Math.log(xm);
            double g = xm * alxm - RandomMath.gammln(xm + 1.0);
            double y = 0.0;
            double t = -1.0;
            while (true) {
                if ((em = sq * (y = Math.tan(Math.PI * (double)gen.random())) + xm) < 0.0) {
                    continue;
                }
                em = Math.floor(em);
                t = 0.9 * (1.0 + y * y) * Math.exp(em * alxm - RandomMath.gammln(em + 1.0) - g);
                if (!((double)gen.random() > t)) break;
            }
        }
        return em;
    }
}

