/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.morph;

import java.io.File;
import neurord.numeric.morph.TreePoint;
import neurord.util.FileUtil;

public class TreeWriter {
    TreePoint[] points;
    int pointCount;

    public TreeWriter(TreePoint[] tpa) {
        this.points = tpa;
    }

    public void writeSWC(File fout) {
        String s = this.serializeSWC();
        FileUtil.writeStringToFile(s, fout);
    }

    public String serializeSWC() {
        int np = this.points.length;
        for (int i = 0; i < np; ++i) {
            this.points[i].setWork(-1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("cctswc00\n");
        this.pointCount = 0;
        for (int i = 0; i < np; ++i) {
            if (this.points[i].getWork() >= 0) continue;
            TreePoint p = this.points[i];
            this.recAppend(sb, p, -1);
        }
        return sb.toString();
    }

    private void recAppend(StringBuffer sb, TreePoint p, int ipar) {
        p.setWork(this.pointCount);
        ++this.pointCount;
        String s = String.format("%6d %10.5g %10.5g %10.5g %10.5g %6d ", p.getWork(), p.getX(), p.getY(), p.getZ(), p.getRadius(), ipar);
        sb.append(s);
        sb.append("\n");
        for (int i = 0; i < p.nnbr; ++i) {
            TreePoint pc = p.nbr[i];
            if (pc.getWork() >= 0) continue;
            this.recAppend(sb, pc, p.getWork());
        }
    }
}

