/*
 * Decompiled with CFR 0.152.
 */
package neurord.numeric.pool;

import neurord.model.SDRun;
import neurord.numeric.math.Column;
import neurord.numeric.pool.DeterministicPoolCalc;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForwardEulerPoolCalc
extends DeterministicPoolCalc {
    static final Logger log = LogManager.getLogger();

    public ForwardEulerPoolCalc(int trial, SDRun sdm) {
        super(trial, sdm);
    }

    @Override
    public double advance() {
        Column rates = this.rtab.getRateColumn(this.mconc);
        Column prod = this.rtab.getProductionMatrix().times(rates);
        this.mconc.incrementBy(prod.times(this.dt));
        this.mconc.positivize();
        log.info("advanced fepc {}", this.time);
        this.mconc.print();
        return this.dt;
    }

    @Override
    public long getParticleCount() {
        return 0L;
    }
}

