/*
 * Decompiled with CFR 0.152.
 */
package neurord.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;
import neurord.SDCalc;
import neurord.model.InjectionStim;
import neurord.model.Reaction;
import neurord.model.Specie;
import neurord.numeric.grid.AdaptiveGridCalc;
import neurord.numeric.grid.GridCalc;
import neurord.numeric.grid.NextEventQueue;
import neurord.numeric.grid.ResultWriterHDF5;
import neurord.numeric.grid.StochasticGridCalc;
import neurord.util.CustomFileAppender;
import neurord.xml.ModelReader;
import org.apache.commons.cli.CommandLine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Settings {
    static final Logger log = LogManager.getLogger();
    final String name;
    final String description;
    final Object fallback;
    public static ArrayList<Settings> all_settings = new ArrayList();
    public static final String FALLBACK = "java -jar neurord.jar";
    private static Properties properties = null;

    private Settings(String name, String description, Object fallback) {
        this.name = name;
        this.description = description;
        this.fallback = fallback;
        all_settings.add(this);
    }

    public static String getProperty(String name) {
        return Settings.getProperties().getProperty(name);
    }

    public static int getProperty(String name, String description, int fallback) {
        new Settings(name, description, fallback);
        String val = Settings.getProperty(name);
        if (val != null) {
            int ret = Integer.valueOf(val);
            log.debug("Overriding {} with \"{}\": {} \u2192 {}", name, val, fallback, ret);
            return ret;
        }
        return fallback;
    }

    public static boolean getProperty(String name, String description, boolean fallback) {
        new Settings(name, description, fallback);
        String val = Settings.getProperty(name);
        if (val != null) {
            boolean ret = Settings.parseBool(val);
            log.debug("Overriding {} with \"{}\": {} \u2192 {}", name, val, fallback, ret);
            return ret;
        }
        return fallback;
    }

    public static double getProperty(String name, String description, double fallback) {
        new Settings(name, description, fallback);
        String val = Settings.getProperty(name);
        if (val != null) {
            double ret = Double.valueOf(val);
            log.debug("Overriding {} with \"{}\": {} \u2192 {}", name, val, fallback, ret);
            return ret;
        }
        return fallback;
    }

    public static String getProperty(String name, String description, String fallback) {
        new Settings(name, description, fallback);
        String val = Settings.getProperty(name);
        if (val != null) {
            log.debug("Overriding {}: {} \u2192 {}", name, fallback, val);
            return val;
        }
        return fallback;
    }

    public static String[] getPropertyList(String name, String description, String ... fallback) {
        new Settings(name, description, fallback);
        String val = Settings.getProperty(name);
        if (val == null) {
            return fallback;
        }
        String[] ret = val.split(",");
        if (ret.length == 1 && ret[0].equals("")) {
            ret = new String[]{};
        }
        log.debug("Overriding {}: {} \u2192 {}", name, fallback, ret);
        return ret;
    }

    static void forceLoading() {
        Logger log = SDCalc.log;
        log = AdaptiveGridCalc.log;
        log = GridCalc.log;
        log = NextEventQueue.log;
        log = ResultWriterHDF5.log;
        log = StochasticGridCalc.log;
        log = ModelReader.log;
        log = Specie.log;
        log = Reaction.log;
        log = InjectionStim.log;
        Integer dummy = CustomFileAppender.dummy;
    }

    public static String stringify(Object x) {
        if (x instanceof String[]) {
            return Arrays.toString((String[])x);
        }
        return x.toString();
    }

    static String repeat(String s, int n) {
        String ans = "";
        while (n-- > 0) {
            ans = ans + s;
        }
        return ans;
    }

    public static void printAvailableSettings(PrintStream out) {
        String lhs;
        Settings.forceLoading();
        int n = 0;
        for (Settings s : all_settings) {
            lhs = String.format("%s (default: %s)", s.name, Settings.stringify(s.fallback));
            n = Math.max(n, lhs.length());
        }
        out.println("Recognized properties (use as -D<property>=<value>):");
        for (Settings s : all_settings) {
            lhs = String.format("%s (default: %s)", s.name, Settings.stringify(s.fallback));
            out.println(String.format("%s%s %s", lhs, Settings.repeat(" ", n - lhs.length()), s.description));
        }
        out.println();
        out.println("Manifest main attributes:");
        try {
            Manifest manifest = Settings.getManifest();
            for (Object key : manifest.getMainAttributes().keySet()) {
                out.println("" + key + " = " + manifest.getMainAttributes().get(key));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Manifest getManifest() throws IOException {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
        return new Manifest(stream);
    }

    public static String getProgramVersion() {
        String value = null;
        try {
            Manifest manifest = Settings.getManifest();
            value = manifest.getMainAttributes().getValue("git-version");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "NeuroRD " + (value != null ? value : "(unknown version)");
    }

    public static int getEnvironmentVariable(String name, int fallback) {
        String val = System.getenv(name);
        if (val != null) {
            int ret = Integer.valueOf(val);
            return ret;
        }
        return fallback;
    }

    public static int getOption(CommandLine cmd, String name, int fallback) {
        String val = cmd.getOptionValue(name);
        if (val != null) {
            int ret = Integer.valueOf(val);
            return ret;
        }
        return fallback;
    }

    public static boolean getOption(CommandLine cmd, String name, boolean fallback) {
        String val = cmd.getOptionValue(name);
        if (val != null) {
            boolean ret = Boolean.valueOf(val);
            return ret;
        }
        return fallback;
    }

    public static double getOption(CommandLine cmd, String name, double fallback) {
        String val = cmd.getOptionValue(name);
        if (val != null) {
            double ret = Double.valueOf(val);
            return ret;
        }
        return fallback;
    }

    public static File getOption(CommandLine cmd, String name, File fallback) {
        String val = cmd.getOptionValue(name);
        if (val != null) {
            return new File(val);
        }
        return fallback;
    }

    public static int optionCount(CommandLine cmd, String[] argv, String longopt, String shortopt) {
        int count = 0;
        if (cmd.hasOption(longopt)) {
            for (String arg : argv) {
                if (!arg.equals("--" + longopt) && !arg.equals("-" + shortopt)) continue;
                ++count;
            }
            assert (count > 0) : count;
        }
        return count;
    }

    public static String javaExecutable(Class cls) {
        String path = System.getProperty("neurord.executable_name");
        if (path != null) {
            return path;
        }
        try {
            path = cls.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException e) {
            return FALLBACK;
        }
        if (path == null) {
            return FALLBACK;
        }
        if (path.endsWith(".jar")) {
            return "java -jar " + path;
        }
        return "java " + cls.getName();
    }

    public static void augmentProperties(Properties overrides) {
        properties = (Properties)System.getProperties().clone();
        properties.putAll((Map<?, ?>)overrides);
    }

    public static Properties getProperties() {
        if (properties == null) {
            return System.getProperties();
        }
        return properties;
    }

    private static boolean parseBool(String value) {
        switch (value.toLowerCase()) {
            case "1": 
            case "yes": 
            case "true": {
                return true;
            }
            case "0": 
            case "no": 
            case "false": {
                return false;
            }
        }
        throw new RuntimeException("Cannot parse boolean \"" + value + "\"");
    }
}

