/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.MemoryMappedFileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Integers;

@Plugin(name="MemoryMappedFile", category="Core", elementType="appender", printObject=true)
public final class MemoryMappedFileAppender
extends AbstractOutputStreamAppender<MemoryMappedFileManager> {
    private static final long serialVersionUID = 1L;
    private static final int BIT_POSITION_1GB = 30;
    private static final int MAX_REGION_LENGTH = 0x40000000;
    private static final int MIN_REGION_LENGTH = 256;
    private final String fileName;
    private Object advertisement;
    private final Advertiser advertiser;

    private MemoryMappedFileAppender(String name, Layout<? extends Serializable> layout, Filter filter, MemoryMappedFileManager manager, String filename, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.putAll(manager.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        }
        this.fileName = filename;
        this.advertiser = advertiser;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
    }

    @Override
    public void append(LogEvent event) {
        ((MemoryMappedFileManager)this.getManager()).setEndOfBatch(event.isEndOfBatch());
        super.append(event);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getRegionLength() {
        return ((MemoryMappedFileManager)this.getManager()).getRegionLength();
    }

    @PluginFactory
    public static MemoryMappedFileAppender createAppender(@PluginAttribute(value="fileName") String fileName, @PluginAttribute(value="append") String append, @PluginAttribute(value="name") String name, @PluginAttribute(value="immediateFlush") String immediateFlush, @PluginAttribute(value="regionLength") String regionLengthStr, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="advertise") String advertise, @PluginAttribute(value="advertiseURI") String advertiseURI, @PluginConfiguration Configuration config) {
        MemoryMappedFileManager manager;
        boolean isAppend = Booleans.parseBoolean(append, true);
        boolean isForce = Booleans.parseBoolean(immediateFlush, false);
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        boolean isAdvertise = Boolean.parseBoolean(advertise);
        int regionLength = Integers.parseInt(regionLengthStr, 0x2000000);
        int actualRegionLength = MemoryMappedFileAppender.determineValidRegionLength(name, regionLength);
        if (name == null) {
            LOGGER.error("No name provided for MemoryMappedFileAppender");
            return null;
        }
        if (fileName == null) {
            LOGGER.error("No filename provided for MemoryMappedFileAppender with name " + name);
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if ((manager = MemoryMappedFileManager.getFileManager(fileName, isAppend, isForce, actualRegionLength, advertiseURI, layout)) == null) {
            return null;
        }
        return new MemoryMappedFileAppender(name, layout, filter, manager, fileName, ignoreExceptions, isForce, isAdvertise ? config.getAdvertiser() : null);
    }

    private static int determineValidRegionLength(String name, int regionLength) {
        if (regionLength > 0x40000000) {
            LOGGER.info("MemoryMappedAppender[{}] Reduced region length from {} to max length: {}", name, regionLength, 0x40000000);
            return 0x40000000;
        }
        if (regionLength < 256) {
            LOGGER.info("MemoryMappedAppender[{}] Expanded region length from {} to min length: {}", name, regionLength, 256);
            return 256;
        }
        int result = Integers.ceilingNextPowerOfTwo(regionLength);
        if (regionLength != result) {
            LOGGER.info("MemoryMappedAppender[{}] Rounded up region length from {} to next power of two: {}", name, regionLength, result);
        }
        return result;
    }
}

