/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortLongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.ImmutableShortLongMap;
import org.eclipse.collections.api.map.primitive.MutableShortLongMap;
import org.eclipse.collections.api.map.primitive.ShortLongMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortLongPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedShortLongProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.ShortLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableShortLongHashMap
implements ImmutableShortLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableShortLongMap delegate;

    ImmutableShortLongHashMap(ShortLongMap delegate) {
        this.delegate = new ShortLongHashMap(delegate);
    }

    @Override
    public long get(short key) {
        return this.delegate.get(key);
    }

    @Override
    public long getIfAbsent(short key, long ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public long getOrThrow(short key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(short key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(long value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(LongProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(ShortProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ShortLongProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyShortIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<ShortLongPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableShortLongMap select(ShortLongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableShortLongMap reject(ShortLongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableShortLongMap toImmutable() {
        return this;
    }

    @Override
    public LongIterator longIterator() {
        return new UnmodifiableLongIterator(this.delegate.longIterator());
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(LongPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableLongCollection select(LongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableLongCollection reject(LongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public long max() {
        return this.delegate.max();
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public long min() {
        return this.delegate.min();
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableLongList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public long[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(long value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(long ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(LongIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableLongList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableLongSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableLongBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyLongIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableShortLongMap newWithKeyValue(short key, long value) {
        ShortLongHashMap map2 = new ShortLongHashMap(this.size() + 1);
        map2.putAll(this);
        map2.put(key, value);
        return map2.toImmutable();
    }

    @Override
    public ImmutableShortLongMap newWithoutKey(short key) {
        ShortLongHashMap map2 = new ShortLongHashMap(this.size());
        map2.putAll(this);
        map2.removeKey(key);
        return map2.toImmutable();
    }

    @Override
    public ImmutableShortLongMap newWithoutAllKeys(ShortIterable keys) {
        ShortLongHashMap map2 = new ShortLongHashMap(this.size());
        map2.putAll(this);
        ShortIterator iterator2 = keys.shortIterator();
        while (iterator2.hasNext()) {
            map2.removeKey(iterator2.next());
        }
        return map2.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableShortSet keySet() {
        return UnmodifiableShortSet.of(this.delegate.keySet());
    }

    @Override
    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableShortLongMapSerializationProxy(this);
    }

    protected static class ImmutableShortLongMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ShortLongMap map;

        public ImmutableShortLongMapSerializationProxy() {
        }

        protected ImmutableShortLongMapSerializationProxy(ShortLongMap map2) {
            this.map = map2;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedShortLongProcedure(){

                    public void safeValue(short key, long value) throws IOException {
                        out.writeShort(key);
                        out.writeLong(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size2 = in.readInt();
            ShortLongHashMap deserializedMap = new ShortLongHashMap();
            for (int i = 0; i < size2; ++i) {
                deserializedMap.put(in.readShort(), in.readLong());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

