/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plotObjects;

import java.awt.Color;
import java.awt.Font;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.render.AbstractDrawer;

public class Label
implements Plotable {
    protected double[] coord;
    protected double[] base_offset;
    protected String label;
    protected Color color;
    protected double cornerN = 0.5;
    protected double cornerE = 0.5;
    boolean visible = true;
    public double angle = 0.0;
    public Font font = AbstractDrawer.DEFAULT_FONT;

    public Label(String l, Color col, double ... c) {
        this.label = l;
        this.coord = c;
        this.color = col;
    }

    public Label(String l, double ... c) {
        this(l, AbstractDrawer.DEFAULT_COLOR, c);
    }

    public Label(double ... c) {
        this(Label.coordToString(c), AbstractDrawer.DEFAULT_COLOR, c);
    }

    public void setText(String _t) {
        this.label = _t;
    }

    public String getText() {
        return this.label;
    }

    public void setCoord(double ... _c) {
        this.coord = _c;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void setCorner(double north_south, double east_west) {
        this.cornerN = north_south;
        this.cornerE = east_west;
    }

    @Override
    public void setVisible(boolean v) {
        this.visible = v;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public void plot(AbstractDrawer draw) {
        if (!this.visible) {
            return;
        }
        draw.setColor(this.color);
        draw.setFont(this.font);
        draw.setBaseOffset(this.base_offset);
        draw.setTextOffset(this.cornerE, this.cornerN);
        draw.setTextAngle(this.angle);
        draw.drawText(this.label, this.coord);
        draw.setBaseOffset(null);
    }

    public void rotate(double _angle) {
        this.angle = _angle;
    }

    public void setFont(Font _font) {
        this.font = _font;
    }

    public static double approx(double val, int decimal) {
        if (decimal < 0) {
            return Math.rint(val / Math.pow(10.0, -decimal)) * Math.pow(10.0, -decimal);
        }
        return Math.rint(val * Math.pow(10.0, decimal)) / Math.pow(10.0, decimal);
    }

    public static String coordToString(double ... c) {
        StringBuffer sb = new StringBuffer("(");
        for (int i = 0; i < c.length; ++i) {
            sb.append(Label.approx(c[i], 2)).append(",");
        }
        sb.setLength(sb.length() - 1);
        if (sb.length() > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public Font getFont() {
        return this.font;
    }
}

