/*----------------------------------------------------------------
$Header$
hugtcc.asc  translated Thu Jan 21 10:12:05 1993 by ntscable 2.0
source file syntax: Eutectic
output file syntax: NEURON
soma: diameter = 21.7456 um  length = 42.6901 um  area = 2916.41 um2
      13 three-D points; 14 outline points numbered 347-360
      outline diameter = 24.4073 um
11 primary neurites
108 branches totaling 7094.47 um in length, 33581 um2 in area
1224 tree points translated to 206 segments (1 requested)
Neurites divided into segments of equal dx between adjacent digitized
branch points.
Segment length constrained to be < 7094.47 um.
No. points   1238
No. trees      12

Rat VB neuron (thalamocortical cell), given by J. Huguenard, stained with
biocytin and traced by A. Destexhe, December 1992.  The neuron is described
in: J.R. Huguenard & D.A. Prince, A novel T-type current undelies prolonged
calcium-dependent burst firing in GABAergic neurons of rat thalamic reticular
nucleus.  J. Neurosci. 12: 3804-3817, 1992.

A Destexhe, 07 Mar 96, neuron structure edited: changed 3d points of dendrites
and soma to make them stick appropriately (with no change in electrotonic
structure).  dend1 moved, soma moved to stick to dend1, dendrites 6,8,9,4,11
moved in that order (nonoverlapping).  The diameters at the tip of dendrites
was erroneous due to the presence of membrane artifacts (biocytin bubbles). 
They were rescaled down to match morphological data of other cells.

=> New membrane area:
   - 24527.179 um2 including 3171.4274 um2 for the soma (area procedure)
   - 23980.547 um2 including 2624.7773 um2 for the soma (PI*diam*L)

The morphology, passive cable properties and modeling of this neuron are
described in: 
  Destexhe A, Neubig M, Ulrich D and Huguenard JR.  
  Dendritic low-threshold calcium currents in thalamic relay cells.  
  Journal of Neuroscience 18: 3574-3588, 1998.
  http://cns.fmed.ulaval.ca

This geometry can be used by anyone interested, under the only condition that
the two above papers are cited.  Please also send us a copy of publications
that use that cell as courtesy.

Alain Destexhe, Laval University, 1997

----------------------------------------------------------------*/

					/* make geometry explicit */
primary_branches_cell = 11
branches_cell = 108
max_dx_cell = 7094.47
points_cell = 1224
nseg_cell = 206
double sections_cell[11]
sections_cell[0] = 1
sections_cell[1] = 3
sections_cell[2] = 13
sections_cell[3] = 21
sections_cell[4] = 1
sections_cell[5] = 31
sections_cell[6] = 9
sections_cell[7] = 33
sections_cell[8] = 47
sections_cell[9] = 27
sections_cell[10] = 19
nsec_cell = 206

strdef name_soma, name_section
name_soma = "soma"
name_section = "dend"
use_axon = 0					/* create sections */
create    soma,\
          dend1[1],\
          dend2[3],\
          dend3[13],\
          dend4[21],\
          dend5[1],\
          dend6[31],\
          dend7[9],\
          dend8[33],\
          dend9[47],\
          dend10[27],\
          dend11[19]



/*----------------------------------------------------------------*/
proc geometry() { local i, j

						/* soma geometry */
    soma {
        nseg = 1
        pt3dclear()
        for j = 1, fscan() {
            pt3dadd(fscan(),fscan(),fscan(),fscan())
        }
    }

					/* connect primary neurites */
    soma connect dend1[0] (0), 0.5
    soma connect dend2[0] (0), 0.5
    soma connect dend3[0] (0), 0.5
    soma connect dend4[0] (0), 0.5
    soma connect dend5[0] (0), 0.5
    soma connect dend6[0] (0), 0.5
    soma connect dend7[0] (0), 0.5
    soma connect dend8[0] (0), 0.5
    soma connect dend9[0] (0), 0.5
    soma connect dend10[0] (0), 0.5
    soma connect dend11[0] (0), 0.5


					/* neurite geometry*/
    for i = 0,0 {
        dend1[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,2 {
        dend2[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,12 {
        dend3[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,20 {
        dend4[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,0 {
        dend5[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,30 {
        dend6[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,8 {
        dend7[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,32 {
        dend8[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,46 {
        dend9[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,26 {
        dend10[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }

    for i = 0,18 {
        dend11[i] {
            nseg = fscan()
            pt3dclear()
            for j = 1, fscan() {
                pt3dadd(fscan(),fscan(),fscan(),fscan())
            }
        }
    }



					/* branching topology*/
    for i = 1,0 {
        dend1[fscan()] connect dend1[i] (0), fscan()
    }

    for i = 1,2 {
        dend2[fscan()] connect dend2[i] (0), fscan()
    }

    for i = 1,12 {
        dend3[fscan()] connect dend3[i] (0), fscan()
    }

    for i = 1,20 {
        dend4[fscan()] connect dend4[i] (0), fscan()
    }

    for i = 1,0 {
        dend5[fscan()] connect dend5[i] (0), fscan()
    }

    for i = 1,30 {
        dend6[fscan()] connect dend6[i] (0), fscan()
    }

    for i = 1,8 {
        dend7[fscan()] connect dend7[i] (0), fscan()
    }

    for i = 1,32 {
        dend8[fscan()] connect dend8[i] (0), fscan()
    }

    for i = 1,46 {
        dend9[fscan()] connect dend9[i] (0), fscan()
    }

    for i = 1,26 {
        dend10[fscan()] connect dend10[i] (0), fscan()
    }

    for i = 1,18 {
        dend11[fscan()] connect dend11[i] (0), fscan()
    }

}

geometry()


SOMA COORDINATES AND DIAMETERS:

        13
        -23.25  -7.35   -34.2   0
        -21.9   -6.18   -31.05  14.959
        -21     -5.8875 -30.4875        21.439
        -20.1   -5.03862        -28.6974        24.974
        -16.95  -4.48638        -27.5526        25.363
        -16.05  -4.26426        -26.5824        26.719
        -13.8   -3.05889        -24.0111        28.865
        -9.75   -1.51125        -21.6675        28.311
        -4.8    1.0875  -17.5662        25.297
        -3.45   0.795   -15.435 23.776
        -0.75   1.875   -11.4192        15.383
        0.15    1.56    -10.53  10.826
        1.5     3       -9      0


NEURITE COORDINATES AND DIAMETERS:

	1 17
	1.5	3	-9	 0.91
	1.5	5.5	0	 0.91
	3.5	8.5	5.5	 0.91
	6	10	9	 0.91
	9	9.5	13	 0.91
	12.5	9	17	 0.91
	15	9.5	22	 0.91
	17	11.5	25	 0.91
	18.5	13.5	29	 0.91
	21.5	14.5	35.5	 0.91
	24	16	41.5	 0.91
	26.5	16	49.5	 0.91
	29.5	17	55	 0.91
	33	18	58.5	 0.91
	37.5	18.5	61.5	 0.91
	42	18.5	63.5	 0.91
	47	18.5	66.5	 0.91

	1 12
	0	13.5	-5	 0.91
	2	14	-2.5	 0.91
	4.5	14.5	0.5	 0.91
	6.5	16	4	 0.91
	8.5	17	7.5	 0.91
	10	18.5	11	 0.91
	12	18.5	12.5	 0.91
	14	19	15	 0.91
	16	19	16.5	 0.91
	18	20	18.5	 0.91
	21	21	21	 0.91
	24.5	22.5	26.5	 0.91

	1 15
	24.5	22.5	26.5	 0.93
	28	24	31.5	 0.93
	31	26	34.5	 0.93
	33.5	29	36	 0.93
	35.5	32	36.5	 0.93
	38	34.5	39.5	 0.93
	41.5	34.5	42	 0.93
	45	33.5	48.5	 0.93
	48	33.5	52.5	 0.93
	50	34.5	56.5	 0.93
	52.5	35.5	58	 0.93
	55.5	34.5	59.5	 0.93
	58.5	34.5	61.5	 0.93
	60	35	64	 0.93
	59.5	36.5	68	 0.93

	1 14
	24.5	22.5	26.5	 0.86
	24.5	25	34	 0.86
	25.5	28	42	 0.86
	26.5	30.5	47	 0.86
	28.5	33	50.5	 0.86
	31	35	51	 0.86
	33.5	37.5	52	 0.86
	36	41.5	54.5	 0.86
	38	45.5	57	 0.86
	39.5	49.5	59	 0.86
	41	52.5	60	 0.86
	42	55.5	63	 0.86
	42.5	58.5	63	 0.86
	42.5	62.5	61	 0.86

	1 4
	7	-3	-5	  2.8
	7.5	-4	2.5	  2.8
	9	-6	7.5	  2.8
	11	-8	10.5	  2.8

	1 6
	11	-8	10.5	  1.3
	14	-8	11	  1.3
	17	-7.5	12.5	  1.3
	20.5	-6.5	14	  1.3
	23.5	-4.5	13.5	  1.3
	27	-2.5	13	  1.3

	1 2
	27	-2.5	13	  2.2
	27.1	-2.5	13	  2.2

	1 10
	27.1	-2.5	13	 0.96
	29.5	-4	15	 0.96
	33	-5.5	18	 0.96
	36.5	-8	21.5	 0.96
	40	-9.5	23	 0.96
	43	-9.5	24	 0.96
	46.5	-7.5	24	 0.96
	49.5	-6	24	 0.96
	53	-4.5	24	 0.96
	56.5	-4	25	 0.96

	1 19
	27.1	-2.5	13	 0.93
	28	0	14.5	 0.93
	29.5	2	15.5	 0.93
	31.5	4.5	15.5	 0.93
	33.5	7	19	 0.93
	35	9.5	23	 0.93
	37	11	29.5	 0.93
	39	12.5	33.5	 0.93
	41.5	13.5	39	 0.93
	44.5	15	45	 0.93
	47	15.5	51.5	 0.93
	50	16.5	55	 0.93
	53	18	56	 0.93
	55.5	19	56	 0.93
	57.5	20.5	56	 0.93
	59	22	56	 0.93
	60.5	22	57	 0.93
	63.5	21	60.5	 0.93
	67	20	66.5	 0.93

	1 16
	27	-2.5	13	 0.94
	29	-0.5	11	 0.94
	31.5	1	10.5	 0.94
	34	4	10.5	 0.94
	37	6.5	12	 0.94
	39.5	8.5	15.5	 0.94
	42.5	10	18.5	 0.94
	45	11	21.5	 0.94
	47.5	11.5	23.5	 0.94
	50	11.5	27	 0.94
	53	12.5	30.5	 0.94
	57	14	33	 0.94
	61	15.5	35	 0.94
	65.5	17	38.5	 0.94
	69	17.5	42	 0.94
	72	17.5	45	 0.94

	1 8
	72	17.5	45	  0.8
	75.5	17	47	  0.8
	79.5	17	49	  0.8
	83	16.5	50.5	  0.8
	87	16.5	50.5	  0.8
	91.5	16	50.5	  0.8
	96	17	53.5	  0.8
	100	19	60	  0.8

	1 5
	72	17.5	45	  0.8
	74.5	18.5	38	  0.8
	77	20	34.5	  0.8
	81	21.5	34.5	  0.8
	86.5	24.5	34.5	  0.8

	1 7
	11	-8	10.5	  1.2
	12	-10	10.5	  1.2
	15	-11	14	  1.2
	17.5	-12	19.5	  1.2
	18.5	-14	23.5	  1.2
	18	-16.5	26.5	  1.2
	17	-19	30.5	  1.2

	1 6
	17	-19	30.5	 0.93
	14	-20	31.5	 0.93
	12	-22	35	 0.93
	11.5	-24.5	40.5	 0.93
	12.5	-27.5	42.5	 0.93
	15	-29.5	41	 0.93

	1 8
	17	-19	30.5	 0.92
	18	-21	28	 0.92
	19.5	-23.5	26.5	 0.92
	21	-24.5	23.5	 0.92
	23	-24	22	 0.92
	25.5	-22.5	22	 0.92
	27.5	-21.5	27	 0.92
	30	-21.5	34.5	 0.92

	1 9
	30	-21.5	34.5	 0.91
	31.5	-20	39.5	 0.91
	33	-19.5	45	 0.91
	34.5	-20	50.5	 0.91
	35	-19	58	 0.91
	36.5	-18	63	 0.91
	37.5	-15	66.5	 0.91
	40	-13	68	 0.91
	42.5	-10.5	72	 0.91

	1 3
	30	-21.5	34.5	 0.91
	32.5	-22	36	 0.91
	35	-23	37	 0.91

	1 3
	0.15	1.56	-10.53	  4.3
	3.15	-1.44	-0.0300007	  4.3
	7.15	-4.94	7.97	  4.3

	1 4
	7.15	-4.94	7.97	  1.7
	4.65	-7.44	11.47	  1.7
	3.15	-9.94	13.97	  1.7
	3.15	-13.44	15.97	  1.7

	1 19
	3.15	-13.44	15.97	  1.2
	4.15	-16.44	18.47	  1.2
	4.15	-19.94	21.97	  1.2
	3.15	-23.94	24.97	  1.2
	2.15	-27.94	27.47	  1.2
	1.65	-32.44	27.97	  1.2
	2.15	-36.94	27.97	  1.2
	2.15	-40.94	30.97	  1.2
	2.15	-43.94	33.97	  1.2
	3.15	-46.44	36.47	  1.2
	4.15	-49.44	35.47	  1.2
	4.65	-52.44	34.47	  1.2
	4.15	-55.94	38.97	  1.2
	4.15	-59.44	43.47	  1.2
	5.65	-62.44	47.97	  1.2
	7.15	-66.44	47.97	  1.2
	6.65	-69.94	47.97	  1.2
	6.65	-72.44	48.97	  1.2
	8.65	-74.94	51.97	  1.2

	1 45
	3.15	-13.44	15.97	  1.2
	4.65	-13.94	20.97	  1.2
	5.65	-14.44	26.97	  1.2
	5.15	-15.44	30.97	  1.2
	3.65	-16.94	33.47	  1.2
	1.65	-18.94	33.47	  1.2
	-0.35	-21.44	35.47	  1.2
	-1.35	-24.44	39.47	  1.2
	-1.85	-26.94	43.97	  1.2
	-1.85	-27.44	48.47	  1.2
	-2.85	-27.44	50.47	  1.2
	-4.35	-27.44	52.47	  1.2
	-5.85	-27.44	56.47	  1.2
	-7.85	-25.94	61.97	  1.2
	-9.35	-22.94	64.97	  1.2
	-9.85	-20.44	64.97	  1.2
	-8.35	-17.44	63.97	  1.2
	-7.35	-14.94	63.47	  1.2
	-6.85	-11.94	63.47	  1.2
	-5.35	-9.94	63.47	  1.2
	-2.35	-7.94	64.47	  1.2
	-0.85	-6.44	64.47	  1.2
	-1.85	-3.44	64.97	  1.2
	-1.35	-0.94	64.97	  1.2
	-0.35	2.56	65.47	  1.2
	-0.85	4.06	64.97	  1.2
	-3.85	6.06	64.47	  1.2
	-6.35	7.06	58.97	  1.2
	-7.85	10.06	53.97	  1.2
	-8.85	14.06	49.97	  1.2
	-9.85	17.56	50.97	  1.2
	-11.35	21.06	50.47	  1.2
	-13.85	22.56	47.97	  1.2
	-16.85	24.56	46.97	  1.2
	-18.85	27.06	45.47	  1.2
	-20.35	30.06	39.97	  1.2
	-21.85	33.56	32.47	  1.2
	-23.35	36.06	29.47	  1.2
	-26.35	39.06	31.47	  1.2
	-28.35	43.06	35.97	  1.2
	-32.35	46.06	39.97	  1.2
	-35.85	48.56	45.47	  1.2
	-40.35	50.06	49.97	  1.2
	-45.35	51.56	52.47	  1.2
	-52.35	53.06	54.47	  1.2

	1 4
	7.15	-4.94	7.97	  2.3
	10.15	-6.94	12.97	  2.3
	13.15	-9.44	16.47	  2.3
	16.15	-11.44	18.47	  2.3

	1 2
	16.15	-11.44	18.47	  1.9
	16.25	-11.44	18.47	  1.9

	1 13
	16.25	-11.44	18.47	  0.8
	19.15	-13.44	16.47	  0.8
	22.65	-14.94	15.97	  0.8
	25.65	-16.44	15.97	  0.8
	28.15	-17.94	15.97	  0.8
	31.15	-20.44	16.47	  0.8
	33.65	-22.94	16.97	  0.8
	37.15	-25.94	16.47	  0.8
	40.65	-27.94	14.47	  0.8
	44.65	-29.44	13.47	  0.8
	48.65	-31.94	13.47	  0.8
	52.15	-35.44	13.97	  0.8
	55.15	-40.44	15.97	  0.8

	1 3
	16.25	-11.44	18.47	  1.7
	18.65	-9.94	18.47	  1.7
	22.15	-8.94	18.47	  1.7

	1 2
	22.15	-8.94	18.47	  1.7
	22.25	-8.94	18.47	  1.7

	1 10
	22.25	-8.94	18.47	  0.8
	24.15	-6.44	24.47	  0.8
	26.65	-4.94	29.47	  0.8
	29.65	-3.44	31.47	  0.8
	33.65	-2.44	33.47	  0.8
	37.65	-0.44	34.47	  0.8
	41.65	1.06	37.47	  0.8
	45.15	2.56	41.47	  0.8
	50.15	2.56	44.97	  0.8
	56.15	1.06	47.97	  0.8

	1 3
	22.25	-8.94	18.47	 0.89
	25.15	-8.44	23.47	 0.89
	29.15	-8.94	33.47	 0.89

	1 13
	29.15	-8.94	33.47	  0.8
	33.15	-6.94	30.47	  0.8
	37.15	-5.44	29.97	  0.8
	42.15	-3.94	30.97	  0.8
	47.15	-3.44	31.97	  0.8
	51.65	-3.44	31.97	  0.8
	54.65	-3.44	30.97	  0.8
	57.65	-3.44	29.97	  0.8
	60.65	-3.44	30.97	  0.8
	63.65	-2.94	34.97	  0.8
	66.15	-1.44	41.47	  0.8
	68.65	-0.94	44.97	  0.8
	72.65	-0.94	43.97	  0.8

	1 10
	29.15	-8.94	33.47	  0.8
	30.15	-10.44	34.97	  0.8
	31.65	-12.44	37.47	  0.8
	34.15	-13.94	40.47	  0.8
	36.65	-15.44	42.47	  0.8
	39.65	-16.44	43.47	  0.8
	42.15	-17.94	45.47	  0.8
	44.15	-20.44	47.47	  0.8
	46.15	-23.94	49.47	  0.8
	49.15	-27.94	49.47	  0.8

	1 17
	22.15	-8.94	18.47	  0.8
	25.15	-9.94	20.97	  0.8
	27.65	-10.94	25.97	  0.8
	29.15	-12.44	31.47	  0.8
	30.65	-13.94	33.97	  0.8
	33.15	-15.44	35.47	  0.8
	38.15	-15.94	38.97	  0.8
	43.15	-16.94	41.97	  0.8
	47.65	-18.44	46.47	  0.8
	50.65	-21.44	51.97	  0.8
	53.65	-23.44	57.97	  0.8
	56.65	-22.94	61.97	  0.8
	60.15	-20.94	65.47	  0.8
	63.15	-21.44	66.47	  0.8
	66.15	-22.94	66.97	  0.8
	66.65	-26.44	65.47	  0.8
	66.65	-30.44	65.47	  0.8

	1 3
	16.15	-11.44	18.47	  1.9
	15.15	-12.44	18.47	  1.9
	15.15	-14.44	18.47	  1.9

	1 2
	15.15	-14.44	18.47	  1.9
	15.25	-14.44	18.47	  1.9

	1 4
	15.25	-14.44	18.47	  0.8
	17.15	-16.44	17.97	  0.8
	18.15	-18.44	18.97	  0.8
	19.15	-21.44	21.47	  0.8

	1 8
	19.15	-21.44	21.47	  0.8
	24.15	-21.94	27.47	  0.8
	26.65	-22.44	33.97	  0.8
	26.65	-23.94	42.47	  0.8
	28.65	-26.44	49.47	  0.8
	28.65	-28.44	53.47	  0.8
	28.65	-30.44	56.47	  0.8
	27.15	-33.94	62.47	  0.8

	1 6
	19.15	-21.44	21.47	  0.8
	18.65	-25.94	23.47	  0.8
	19.15	-30.44	25.47	  0.8
	19.65	-34.94	27.47	  0.8
	21.15	-39.44	29.97	  0.8
	23.15	-44.44	34.47	  0.8

	1 12
	15.25	-14.44	18.47	  0.8
	15.15	-15.44	18.47	  0.8
	16.15	-16.94	19.47	  0.8
	16.15	-18.94	20.47	  0.8
	16.15	-20.94	23.47	  0.8
	15.15	-22.94	25.97	  0.8
	16.15	-24.44	29.97	  0.8
	16.65	-26.44	32.47	  0.8
	17.65	-27.94	34.97	  0.8
	17.65	-29.94	40.47	  0.8
	18.15	-32.94	45.47	  0.8
	17.65	-37.94	49.47	  0.8

	1 3
	15.15	-14.44	18.47	 0.84
	12.15	-23.44	32.47	 0.84
	10.65	-38.44	49.47	 0.84

	1 34
	-1.5	3	-5	 0.96
	-1	2.5	16	 0.96
	-1	1.5	38	 0.96
	-1	0	52.5	 0.96
	-2	-2	63.5	 0.96
	-3	-3.5	65	 0.96
	-5	-5	65	 0.96
	-7.5	-4.5	65	 0.96
	-9.5	-3	63	 0.96
	-10	0	56.5	 0.96
	-9	2.5	50	 0.96
	-7	4.5	45	 0.96
	-5	5.5	42	 0.96
	-4.5	7	39	 0.96
	-6.5	7.5	36	 0.96
	-9	8.5	36	 0.96
	-10	10	36	 0.96
	-9.5	12	36	 0.96
	-8	13	36	 0.96
	-6	13.5	40	 0.96
	-4.5	14	44.5	 0.96
	-4.5	15	48	 0.96
	-5	16	47	 0.96
	-7	17	46	 0.96
	-7.5	18	47.5	 0.96
	-7.5	19	49.5	 0.96
	-7	20.5	53.5	 0.96
	-6.5	22	55	 0.96
	-6.5	23.5	57.5	 0.96
	-6.5	25	59.5	 0.96
	-7	27	67.5	 0.96
	-9	27.5	71	 0.96
	-10	29.5	75.5	 0.96
	-10	32	77	 0.96

	1 3
	-23.25	-7.35	-34.2	  4.4
	-25.25	-7.35	-34.2	  4.4
	-26.75	-7.35	-34.2	  4.4

	1 4
	-26.75	-7.35	-34.2	  3.6
	-38.75	-8.85	-30.7	  3.6
	-47.25	-9.35	-26.7	  3.6
	-51.75	-8.85	-22.2	  3.6

	1 2
	-51.75	-8.85	-22.2	  3.8
	-51.85	-8.85	-22.2	  3.8

	1 4
	-51.85	-8.85	-22.2	  2.3
	-58.75	-14.35	-22.2	  2.3
	-63.75	-18.35	-22.2	  2.3
	-66.25	-20.35	-22.2	  2.3

	1 10
	-66.25	-20.35	-22.2	  0.8
	-70.25	-26.85	-18.2	  0.8
	-74.25	-31.85	-16.2	  0.8
	-77.75	-37.35	-15.7	  0.8
	-79.25	-41.85	-14.2	  0.8
	-80.75	-47.35	-12.7	  0.8
	-84.25	-51.35	-11.7	  0.8
	-92.25	-56.35	-11.7	  0.8
	-104.25	-62.35	-11.7	  0.8
	-119.75	-68.85	-11.7	  0.8

	1 7
	-66.25	-20.35	-22.2	  0.8
	-72.75	-24.85	-21.2	  0.8
	-77.75	-27.85	-21.2	  0.8
	-80.75	-27.85	-21.2	  0.8
	-86.25	-28.35	-23.7	  0.8
	-90.25	-28.35	-26.2	  0.8
	-93.75	-29.35	-29.2	  0.8

	1 5
	-93.75	-29.35	-29.2	  0.8
	-103.25	-31.85	-29.2	  0.8
	-113.25	-35.35	-29.2	  0.8
	-124.75	-38.85	-31.7	  0.8
	-138.25	-42.85	-37.2	  0.8

	1 6
	-93.75	-29.35	-29.2	  0.8
	-102.25	-31.85	-38.7	  0.8
	-110.75	-36.85	-44.2	  0.8
	-117.75	-42.85	-49.2	  0.8
	-121.75	-46.35	-52.2	  0.8
	-125.25	-49.35	-55.7	  0.8

	1 4
	-51.85	-8.85	-22.2	  1.8
	-60.25	-11.35	-15.7	  1.8
	-65.25	-12.35	-11.7	  1.8
	-66.75	-12.35	-10.2	  1.8

	1 11
	-66.75	-12.35	-10.2	  0.8
	-71.75	-18.85	-8.2	  0.8
	-80.25	-23.85	-3.2	  0.8
	-86.25	-27.85	4.3	  0.8
	-91.75	-31.35	10.8	  0.8
	-97.75	-31.85	13.8	  0.8
	-105.75	-30.85	16.3	  0.8
	-113.25	-26.85	19.3	  0.8
	-118.25	-23.85	23.8	  0.8
	-122.75	-21.35	26.8	  0.8
	-126.75	-20.35	29.3	  0.8

	1 4
	-66.75	-12.35	-10.2	  0.8
	-73.25	-10.35	-5.7	  0.8
	-77.75	-9.35	-3.7	  0.8
	-80.25	-9.85	-3.7	  0.8

	1 8
	-80.25	-9.85	-3.7	  0.8
	-85.75	-11.85	2.3	  0.8
	-93.25	-13.35	4.8	  0.8
	-101.25	-14.35	6.8	  0.8
	-111.25	-15.35	8.3	  0.8
	-121.75	-15.85	11.3	  0.8
	-132.25	-16.35	11.8	  0.8
	-139.75	-16.35	12.3	  0.8

	1 7
	-80.25	-9.85	-3.7	  0.8
	-89.25	-5.35	0.299999	  0.8
	-98.25	-0.85	3.8	  0.8
	-105.25	1.65	4.8	  0.8
	-114.75	0.65	4.8	  0.8
	-120.75	-2.35	4.3	  0.8
	-124.75	-5.85	4.3	  0.8

	1 3
	-51.75	-8.85	-22.2	  3.2
	-52.75	-7.35	-22.2	  3.2
	-53.25	-6.85	-22.2	  3.2

	1 6
	-53.25	-6.85	-22.2	  1.5
	-65.25	-8.85	-17.7	  1.5
	-74.75	-8.85	-17.2	  1.5
	-83.25	-7.35	-22.2	  1.5
	-89.75	-5.35	-26.2	  1.5
	-93.75	-4.85	-29.2	  1.5

	1 8
	-93.75	-4.85	-29.2	  0.8
	-101.25	-8.35	-28.2	  0.8
	-109.25	-11.35	-27.2	  0.8
	-115.75	-11.35	-27.2	  0.8
	-125.75	-12.85	-26.2	  0.8
	-135.75	-13.35	-26.2	  0.8
	-146.75	-15.85	-23.7	  0.8
	-154.75	-18.35	-19.7	  0.8

	1 3
	-93.75	-4.85	-29.2	  0.8
	-100.25	-2.35	-29.7	  0.8
	-106.75	-1.35	-30.2	  0.8

	1 4
	-106.75	-1.35	-30.2	  0.8
	-111.75	-3.85	-27.2	  0.8
	-117.25	-5.85	-29.2	  0.8
	-123.25	-7.85	-35.7	  0.8

	1 5
	-106.75	-1.35	-30.2	  0.8
	-112.75	2.65	-31.2	  0.8
	-119.75	8.15	-33.2	  0.8
	-128.25	14.15	-36.2	  0.8
	-138.25	19.65	-39.7	  0.8

	1 12
	-53.25	-6.85	-22.2	  0.8
	-54.25	-1.85	-18.7	  0.8
	-56.75	2.15	-16.7	  0.8
	-60.25	7.15	-16.2	  0.8
	-66.75	12.65	-17.2	  0.8
	-74.25	18.65	-21.7	  0.8
	-82.75	23.65	-26.7	  0.8
	-89.25	25.15	-31.2	  0.8
	-94.25	26.65	-36.2	  0.8
	-100.25	26.65	-42.2	  0.8
	-107.75	27.15	-51.7	  0.8
	-118.25	28.15	-62.2	  0.8

	1 5
	-26.75	-7.35	-34.2	  1.6
	-28.75	-3.35	-31.7	  1.6
	-34.25	2.15	-27.2	  1.6
	-39.75	7.65	-22.2	  1.6
	-43.25	10.15	-21.2	  1.6

	1 2
	-43.25	10.15	-21.2	  1.2
	-43.35	10.15	-21.2	  1.2

	1 2
	-43.35	10.15	-21.2	 0.83
	-43.45	11.15	-21.2	 0.83

	1 11
	-43.45	11.15	-21.2	  0.8
	-56.75	12.65	-18.7	  0.8
	-68.25	13.15	-15.7	  0.8
	-77.75	12.15	-12.2	  0.8
	-83.75	9.65	-11.7	  0.8
	-89.75	6.65	-11.7	  0.8
	-97.25	3.65	-11.7	  0.8
	-105.25	0.65	-11.7	  0.8
	-113.25	0.15	-11.7	  0.8
	-118.25	1.15	-11.7	  0.8
	-120.75	2.65	-11.7	  0.8

	1 11
	-43.45	11.15	-21.2	  0.8
	-45.75	12.15	-15.7	  0.8
	-51.75	13.65	-13.7	  0.8
	-59.75	15.65	-14.7	  0.8
	-67.75	16.15	-13.7	  0.8
	-74.75	16.15	-12.2	  0.8
	-81.75	13.15	-11.7	  0.8
	-88.25	10.65	-11.7	  0.8
	-95.25	7.65	-11.7	  0.8
	-99.75	5.65	-11.7	  0.8
	-102.25	5.15	-11.7	  0.8

	1 5
	-43.35	10.15	-21.2	  0.8
	-45.75	14.15	-17.2	  0.8
	-51.25	19.65	-15.7	  0.8
	-55.75	23.65	-15.7	  0.8
	-59.75	26.65	-15.7	  0.8

	1 8
	-59.75	26.65	-15.7	  0.8
	-71.75	32.65	-15.7	  0.8
	-78.75	36.15	-15.7	  0.8
	-81.75	37.65	-15.7	  0.8
	-85.75	41.15	-15.7	  0.8
	-91.75	45.15	-15.7	  0.8
	-100.75	51.15	-20.7	  0.8
	-111.75	58.15	-31.7	  0.8

	1 5
	-59.75	26.65	-15.7	  0.8
	-62.25	33.15	-23.2	  0.8
	-67.25	41.15	-31.7	  0.8
	-72.75	50.65	-39.2	  0.8
	-78.75	59.65	-41.2	  0.8

	1 2
	-78.75	59.65	-41.2	  0.8
	-81.75	68.65	-53.2	  0.8

	1 3
	-78.75	59.65	-41.2	  0.8
	-84.25	61.65	-48.7	  0.8
	-90.75	67.65	-50.2	  0.8

	1 9
	-43.25	10.15	-21.2	  0.8
	-46.25	22.65	-17.2	  0.8
	-50.25	32.15	-17.7	  0.8
	-54.25	39.65	-19.2	  0.8
	-57.25	45.15	-22.2	  0.8
	-61.25	52.15	-24.7	  0.8
	-64.75	59.65	-28.7	  0.8
	-66.75	65.15	-32.2	  0.8
	-66.75	68.15	-35.7	  0.8

	1 2
	-13.5	0	-38.5	  1.4
	-22.5	0.5	-33.5	  1.4

	1 9
	-22.5	0.5	-33.5	  0.8
	-30	-1.5	-33.5	  0.8
	-36.5	-2	-33.5	  0.8
	-41	-2	-33.5	  0.8
	-47	-2	-28	  0.8
	-53	-1	-21	  0.8
	-60.5	1.5	-14.5	  0.8
	-66.5	2.5	-13	  0.8
	-72.5	1	-13.5	  0.8

	1 8
	-72.5	1	-13.5	  0.8
	-78.5	1.5	-13.5	  0.8
	-85.5	2	-12.5	  0.8
	-92.5	2	-11	  0.8
	-99.5	3	-9.5	  0.8
	-106	3.5	-8.5	  0.8
	-111	5	-7.5	  0.8
	-113.5	6.5	-7	  0.8

	1 17
	-72.5	1	-13.5	  0.8
	-70	-1	-16	  0.8
	-69	-3	-17.5	  0.8
	-70	-5.5	-20.5	  0.8
	-72.5	-8	-22	  0.8
	-77.5	-10.5	-24	  0.8
	-83.5	-12	-25.5	  0.8
	-89	-14	-25.5	  0.8
	-95	-14.5	-25.5	  0.8
	-100	-15	-25.5	  0.8
	-105	-15	-25.5	  0.8
	-109.5	-15.5	-25.5	  0.8
	-114	-16	-21	  0.8
	-120	-16	-17.5	  0.8
	-125.5	-16.5	-14	  0.8
	-131	-16	-12.5	  0.8
	-135.5	-16	-8.5	  0.8

	1 2
	-22.5	0.5	-33.5	  1.1
	-26	2.5	-36	  1.1

	1 6
	-26	2.5	-36	  0.8
	-31.5	2	-35.5	  0.8
	-38.5	2.5	-34.5	  0.8
	-45.5	4	-29	  0.8
	-53.5	5	-24.5	  0.8
	-61.5	5.5	-20	  0.8

	1 11
	-61.5	5.5	-20	  0.8
	-67	9	-21.5	  0.8
	-72.5	11.5	-22.5	  0.8
	-78.5	14	-22.5	  0.8
	-84	14	-22.5	  0.8
	-90	12	-22.5	  0.8
	-95	9	-22.5	  0.8
	-101	7	-20.5	  0.8
	-107	4	-19	  0.8
	-114	0	-20	  0.8
	-121	-5.5	-25.5	  0.8

	1 10
	-61.5	5.5	-20	  0.8
	-61	9	-21	  0.8
	-63.5	13	-17.5	  0.8
	-69.5	16.5	-11.5	  0.8
	-75.5	20.5	-10	  0.8
	-79	22.5	-10	  0.8
	-79	25	-9	  0.8
	-78	26.5	-4.5	  0.8
	-77	28	0	  0.8
	-76.5	29.5	3.5	  0.8

	1 8
	-26	2.5	-36	  0.8
	-32	8.5	-29	  0.8
	-38	15	-24.5	  0.8
	-45.5	22	-22.5	  0.8
	-52	27.5	-20	  0.8
	-58.5	33.5	-17	  0.8
	-63	40	-15	  0.8
	-68.5	47.5	-13.5	  0.8

	1 2
	-16.95	-4.48638	-27.5526	  3.4
	-20.45	-2.98638	-27.5526	  3.4

	1 5
	-20.45	-2.98638	-27.5526	  1.6
	-26.45	-3.48638	-27.5526	  1.6
	-32.45	-3.48638	-27.0526	  1.6
	-38.95	-1.48638	-26.5526	  1.6
	-44.95	1.51362	-26.0526	  1.6

	1 2
	-44.95	1.51362	-26.0526	  2.7
	-45.05	1.51362	-26.0526	  2.7

	1 2
	-45.05	1.51362	-26.0526	  2.7
	-45.15	1.51362	-26.0526	  2.7

	1 5
	-45.15	1.51362	-26.0526	  0.8
	-52.45	2.51362	-27.0526	  0.8
	-60.45	4.01362	-27.5526	  0.8
	-66.95	5.51362	-27.5526	  0.8
	-71.45	6.51362	-27.5526	  0.8

	1 10
	-71.45	6.51362	-27.5526	  0.8
	-76.95	3.01362	-27.5526	  0.8
	-82.95	0.0136199	-27.5526	  0.8
	-89.45	-2.98638	-27.5526	  0.8
	-95.45	-5.48638	-27.5526	  0.8
	-101.45	-8.48638	-27.5526	  0.8
	-109.45	-10.9864	-27.5526	  0.8
	-117.45	-12.4864	-27.5526	  0.8
	-122.95	-13.4864	-27.5526	  0.8
	-124.95	-13.4864	-27.5526	  0.8

	1 13
	-71.45	6.51362	-27.5526	  0.8
	-73.45	9.01362	-27.5526	  0.8
	-75.95	12.0136	-27.5526	  0.8
	-80.45	14.5136	-27.5526	  0.8
	-83.45	16.5136	-27.5526	  0.8
	-87.95	17.5136	-27.5526	  0.8
	-91.45	18.5136	-32.5526	  0.8
	-95.45	18.5136	-39.5526	  0.8
	-99.45	18.0136	-46.5526	  0.8
	-102.95	18.5136	-48.5526	  0.8
	-107.45	18.5136	-50.5526	  0.8
	-111.95	19.0136	-52.0526	  0.8
	-116.45	19.5136	-54.0526	  0.8

	1 4
	-45.15	1.51362	-26.0526	 0.99
	-48.45	7.01362	-26.0526	 0.99
	-53.45	12.5136	-27.5526	 0.99
	-59.45	17.5136	-31.5526	 0.99

	1 11
	-59.45	17.5136	-31.5526	  0.8
	-67.45	21.0136	-28.5526	  0.8
	-74.45	23.5136	-27.5526	  0.8
	-78.45	26.0136	-26.0526	  0.8
	-82.45	28.5136	-27.0526	  0.8
	-85.95	31.5136	-26.5526	  0.8
	-89.45	34.0136	-26.0526	  0.8
	-92.95	36.5136	-26.0526	  0.8
	-97.95	40.5136	-27.0526	  0.8
	-104.45	45.0136	-29.0526	  0.8
	-110.95	49.0136	-33.0526	  0.8

	1 12
	-59.45	17.5136	-31.5526	  0.8
	-59.95	20.0136	-33.5526	  0.8
	-61.45	23.0136	-36.5526	  0.8
	-63.45	27.0136	-39.0526	  0.8
	-64.95	31.5136	-42.0526	  0.8
	-66.95	34.5136	-44.0526	  0.8
	-68.45	36.0136	-47.5526	  0.8
	-71.45	38.0136	-49.5526	  0.8
	-73.95	41.0136	-51.5526	  0.8
	-76.95	45.5136	-56.5526	  0.8
	-78.45	51.0136	-60.0526	  0.8
	-80.45	57.0136	-65.0526	  0.8

	1 10
	-45.05	1.51362	-26.0526	  0.8
	-44.45	6.51362	-27.5526	  0.8
	-45.95	12.5136	-28.5526	  0.8
	-48.95	20.0136	-28.5526	  0.8
	-53.45	25.5136	-28.0526	  0.8
	-56.45	31.0136	-31.0526	  0.8
	-58.95	35.5136	-35.5526	  0.8
	-61.95	42.0136	-41.0526	  0.8
	-65.45	50.0136	-45.5526	  0.8
	-68.45	60.0136	-51.5526	  0.8

	1 5
	-44.95	1.51362	-26.0526	  0.8
	-48.45	3.01362	-27.0526	  0.8
	-55.95	5.01362	-27.5526	  0.8
	-63.95	6.51362	-27.5526	  0.8
	-71.45	7.51362	-27.5526	  0.8

	1 5
	-71.45	7.51362	-27.5526	  0.8
	-78.95	4.51362	-27.5526	  0.8
	-86.95	1.01362	-27.5526	  0.8
	-95.45	-2.98638	-27.5526	  0.8
	-102.45	-6.48638	-27.5526	  0.8

	1 9
	-71.45	7.51362	-27.5526	  0.8
	-74.95	11.0136	-30.0526	  0.8
	-77.95	15.0136	-28.0526	  0.8
	-79.45	19.0136	-18.0526	  0.8
	-80.45	25.5136	-8.5526	  0.8
	-82.95	30.5136	-3.0526	  0.8
	-86.45	34.5136	-1.5526	  0.8
	-90.45	36.5136	-2.0526	  0.8
	-93.95	39.0136	-1.0526	  0.8

	1 4
	-20.45	-2.98638	-27.5526	  2.3
	-23.45	0.0136199	-30.0526	  2.3
	-27.95	5.01362	-31.5526	  2.3
	-33.95	11.5136	-31.5526	  2.3

	1 8
	-33.95	11.5136	-31.5526	  1.4
	-35.45	16.0136	-31.5526	  1.4
	-38.45	21.5136	-33.0526	  1.4
	-41.45	27.0136	-35.0526	  1.4
	-44.95	33.0136	-37.0526	  1.4
	-47.95	38.0136	-39.5526	  1.4
	-50.45	43.5136	-39.5526	  1.4
	-52.45	48.5136	-38.0526	  1.4

	1 2
	-52.45	48.5136	-38.0526	  1.4
	-52.55	48.5136	-38.0526	  1.4

	1 2
	-52.55	48.5136	-38.0526	  1.4
	-57.45	56.0136	-42.0526	  1.4

	1 5
	-57.45	56.0136	-42.0526	  0.8
	-58.45	62.0136	-44.5526	  0.8
	-57.95	68.5136	-45.0526	  0.8
	-57.45	75.5136	-48.0526	  0.8
	-56.95	82.5136	-51.5526	  0.8

	1 6
	-57.45	56.0136	-42.0526	  0.8
	-62.45	59.0136	-43.0526	  0.8
	-67.45	63.0136	-44.5526	  0.8
	-71.45	67.0136	-45.5526	  0.8
	-76.45	71.0136	-48.0526	  0.8
	-81.95	74.0136	-51.5526	  0.8

	1 9
	-52.55	48.5136	-38.0526	  0.8
	-55.95	50.0136	-35.0526	  0.8
	-58.45	52.0136	-31.5526	  0.8
	-59.95	55.5136	-29.5526	  0.8
	-60.95	58.5136	-27.5526	  0.8
	-62.95	63.0136	-27.5526	  0.8
	-66.95	67.0136	-25.5526	  0.8
	-70.45	75.5136	-23.5526	  0.8
	-72.95	86.0136	-22.0526	  0.8

	1 4
	-52.45	48.5136	-38.0526	  0.8
	-53.45	53.0136	-55.0526	  0.8
	-54.95	57.0136	-64.5526	  0.8
	-56.95	61.5136	-67.5526	  0.8

	1 2
	-56.95	61.5136	-67.5526	  0.8
	-61.45	64.0136	-67.5526	  0.8

	1 2
	-56.95	61.5136	-67.5526	  0.8
	-54.95	65.0136	-54.0526	  0.8

	1 3
	-33.95	11.5136	-31.5526	  1.9
	-36.95	15.5136	-36.0526	  1.9
	-40.95	21.0136	-46.0526	  1.9

	1 2
	-40.95	21.0136	-46.0526	  1.9
	-41.05	21.0136	-46.0526	  1.9

	1 4
	-41.05	21.0136	-46.0526	 0.83
	-45.45	17.0136	-47.0526	 0.83
	-50.45	16.5136	-56.0526	 0.83
	-56.45	19.0136	-74.0526	 0.83

	1 3
	-41.05	21.0136	-46.0526	 0.98
	-44.45	25.0136	-46.0526	 0.98
	-47.95	29.5136	-46.0526	 0.98

	1 7
	-47.95	29.5136	-46.0526	  0.8
	-51.95	30.5136	-48.0526	  0.8
	-56.45	32.5136	-54.0526	  0.8
	-59.45	35.5136	-59.0526	  0.8
	-62.95	37.0136	-63.5526	  0.8
	-66.95	40.5136	-65.0526	  0.8
	-73.45	45.5136	-69.0526	  0.8

	1 6
	-47.95	29.5136	-46.0526	  0.8
	-49.45	34.0136	-49.5526	  0.8
	-50.95	40.0136	-46.5526	  0.8
	-54.45	45.5136	-42.5526	  0.8
	-58.45	50.0136	-33.5526	  0.8
	-62.45	53.0136	-27.5526	  0.8

	1 4
	-40.95	21.0136	-46.0526	  1.6
	-37.95	27.5136	-46.0526	  1.6
	-34.95	34.5136	-47.5526	  1.6
	-32.45	42.5136	-51.5526	  1.6

	1 5
	-32.45	42.5136	-51.5526	  0.8
	-33.95	48.0136	-60.5526	  0.8
	-35.95	54.0136	-64.0526	  0.8
	-38.95	59.5136	-65.5526	  0.8
	-41.45	64.5136	-67.5526	  0.8

	1 6
	-32.45	42.5136	-51.5526	  0.8
	-29.45	47.0136	-52.5526	  0.8
	-28.45	51.5136	-53.0526	  0.8
	-29.95	56.5136	-55.0526	  0.8
	-32.95	60.5136	-58.5526	  0.8
	-35.95	64.5136	-63.5526	  0.8

	1 2
	-4.8	1.0875	-17.5662	  5.1
	-2.8	10.5875	-8.0662	  5.1

	1 2
	-2.8	10.5875	-8.0662	  5.1
	-2.7	10.5875	-8.0662	  5.1

	1 2
	-2.7	10.5875	-8.0662	  5.1
	-2.6	10.5875	-8.0662	  5.1

	1 2
	-2.6	10.5875	-8.0662	  5.1
	-2.5	10.5875	-8.0662	  5.1

	1 2
	-2.5	10.5875	-8.0662	  5.1
	-2.4	10.5875	-8.0662	  5.1

	1 2
	-2.4	10.5875	-8.0662	  5.1
	-2.3	10.5875	-8.0662	  5.1

	1 16
	-2.3	10.5875	-8.0662	  0.9
	-5.8	11.5875	1.9338	  0.9
	-8.3	14.5875	8.9338	  0.9
	-9.3	19.0875	12.9338	  0.9
	-9.8	25.5875	15.9338	  0.9
	-12.8	30.5875	19.4338	  0.9
	-15.8	35.0875	22.4338	  0.9
	-18.8	37.0875	25.9338	  0.9
	-19.3	38.5875	28.9338	  0.9
	-18.8	40.5875	32.4338	  0.9
	-15.8	43.5875	37.4338	  0.9
	-12.3	46.0875	40.9338	  0.9
	-9.8	49.5875	43.9338	  0.9
	-10.3	54.5875	47.9338	  0.9
	-11.8	62.0875	51.4338	  0.9
	-13.8	70.0875	53.9338	  0.9

	1 4
	-2.3	10.5875	-8.0662	  2.8
	-6.3	14.5875	-7.0662	  2.8
	-10.3	19.0875	-7.0662	  2.8
	-14.8	24.5875	-7.0662	  2.8

	1 2
	-14.8	24.5875	-7.0662	    2
	-19.3	26.0875	-8.0662	    2

	1 7
	-19.3	26.0875	-8.0662	 0.86
	-25.3	29.0875	-9.0662	 0.86
	-35.8	33.0875	-10.0662	 0.86
	-47.8	37.0875	-11.0662	 0.86
	-59.8	40.0875	-12.5662	 0.86
	-68.8	40.5875	-14.5662	 0.86
	-78.3	38.5875	-17.5662	 0.86

	1 10
	-19.3	26.0875	-8.0662	 0.84
	-17.8	28.0875	-9.0662	 0.84
	-17.3	32.0875	-5.5662	 0.84
	-17.8	38.0875	0.4338	 0.84
	-19.3	45.5875	6.9338	 0.84
	-23.3	55.0875	8.9338	 0.84
	-28.8	66.0875	8.4338	 0.84
	-36.8	77.5875	10.4338	 0.84
	-42.3	90.0875	13.4338	 0.84
	-46.3	103.588	17.9338	 0.84

	1 4
	-14.8	24.5875	-7.0662	  1.1
	-13.3	28.5875	-18.0662	  1.1
	-14.3	35.0875	-26.5662	  1.1
	-18.8	44.0875	-32.0662	  1.1

	1 2
	-18.8	44.0875	-32.0662	  0.8
	-22.8	46.0875	-43.0662	  0.8

	1 5
	-22.8	46.0875	-43.0662	  0.8
	-29.3	50.0875	-48.0662	  0.8
	-34.8	55.5875	-54.0662	  0.8
	-38.8	62.5875	-58.0662	  0.8
	-42.3	70.5875	-60.0662	  0.8

	1 5
	-22.8	46.0875	-43.0662	  0.8
	-25.3	51.5875	-44.0662	  0.8
	-27.8	57.0875	-47.5662	  0.8
	-29.8	61.5875	-56.0662	  0.8
	-33.3	65.0875	-67.0662	  0.8

	1 10
	-18.8	44.0875	-32.0662	  0.8
	-17.8	48.0875	-31.5662	  0.8
	-16.3	53.5875	-29.0662	  0.8
	-16.3	59.5875	-29.0662	  0.8
	-15.8	65.0875	-27.5662	  0.8
	-15.3	70.0875	-29.0662	  0.8
	-12.8	75.0875	-27.0662	  0.8
	-11.3	80.0875	-28.5662	  0.8
	-9.3	85.0875	-29.5662	  0.8
	-8.3	91.0875	-31.0662	  0.8

	1 17
	-2.4	10.5875	-8.0662	  0.8
	-4.3	15.5875	-6.0662	  0.8
	-5.8	20.5875	-3.0662	  0.8
	-7.3	25.0875	0.9338	  0.8
	-7.3	29.5875	4.4338	  0.8
	-6.8	34.0875	8.9338	  0.8
	-5.3	37.5875	12.4338	  0.8
	-3.8	42.0875	13.4338	  0.8
	0.2	47.5875	15.4338	  0.8
	4.7	52.5875	17.9338	  0.8
	9.2	55.0875	22.4338	  0.8
	12.2	55.5875	27.4338	  0.8
	14.7	56.5875	31.9338	  0.8
	15.7	59.0875	36.4338	  0.8
	16.2	62.0875	39.4338	  0.8
	17.7	65.5875	41.4338	  0.8
	21.7	69.0875	43.4338	  0.8

	1 5
	-2.5	10.5875	-8.0662	    1
	-3.8	16.0875	-10.5662	    1
	-4.3	21.0875	-12.0662	    1
	-4.3	26.0875	-12.5662	    1
	-3.8	31.0875	-13.5662	    1

	1 4
	-2.6	10.5875	-8.0662	 0.94
	-1.8	15.5875	-7.0662	 0.94
	1.2	21.0875	-9.0662	 0.94
	5.2	27.5875	-13.5662	 0.94

	1 6
	5.2	27.5875	-13.5662	  0.8
	4.2	34.0875	-14.0662	  0.8
	4.2	41.0875	-15.5662	  0.8
	4.2	47.0875	-17.0662	  0.8
	3.7	51.5875	-16.0662	  0.8
	1.7	54.0875	-13.5662	  0.8

	1 10
	5.2	27.5875	-13.5662	  0.8
	9.7	31.5875	-16.0662	  0.8
	14.2	35.5875	-17.5662	  0.8
	20.2	39.0875	-17.5662	  0.8
	25.2	40.5875	-17.5662	  0.8
	30.2	42.0875	-17.5662	  0.8
	34.2	42.5875	-14.0662	  0.8
	38.7	43.0875	-10.5662	  0.8
	43.7	45.0875	-6.5662	  0.8
	48.7	49.5875	-5.5662	  0.8

	1 9
	-2.7	10.5875	-8.0662	  0.8
	1.7	10.5875	-6.0662	  0.8
	6.7	12.0875	-4.0662	  0.8
	11.7	14.5875	-5.5662	  0.8
	16.7	17.5875	-8.0662	  0.8
	21.2	20.0875	-11.5662	  0.8
	26.2	22.5875	-10.5662	  0.8
	30.7	26.0875	-14.5662	  0.8
	35.7	30.0875	-23.0662	  0.8

	1 4
	-2.8	10.5875	-8.0662	  2.6
	0.7	13.0875	-7.0662	  2.6
	3.2	17.0875	-7.0662	  2.6
	4.7	21.5875	-7.0662	  2.6

	1 2
	4.7	21.5875	-7.0662	  2.1
	4.8	21.5875	-7.0662	  2.1

	1 9
	4.8	21.5875	-7.0662	  0.8
	2.7	24.0875	-5.0662	  0.8
	0.7	28.0875	-3.5662	  0.8
	-3.3	32.5875	-4.5662	  0.8
	-7.8	37.5875	-5.0662	  0.8
	-13.3	41.5875	-8.5662	  0.8
	-19.3	45.5875	-12.0662	  0.8
	-26.3	48.0875	-13.5662	  0.8
	-33.8	50.0875	-12.0662	  0.8

	1 10
	4.8	21.5875	-7.0662	  0.8
	9.2	23.0875	-7.0662	  0.8
	15.2	25.5875	-6.5662	  0.8
	21.7	28.0875	-6.5662	  0.8
	28.2	31.0875	-6.5662	  0.8
	36.2	33.0875	-6.5662	  0.8
	42.7	35.5875	-8.0662	  0.8
	49.2	38.5875	-10.0662	  0.8
	54.2	43.0875	-14.0662	  0.8
	59.7	49.5875	-17.5662	  0.8

	1 2
	4.7	21.5875	-7.0662	    2
	8.7	28.0875	4.9338	    2

	1 2
	8.7	28.0875	4.9338	  1.9
	8.8	28.0875	4.9338	  1.9

	1 2
	8.8	28.0875	4.9338	  1.9
	8.9	28.0875	4.9338	  1.9

	1 2
	8.9	28.0875	4.9338	  1.9
	9	28.0875	4.9338	  1.9

	1 2
	9	28.0875	4.9338	  1.9
	9.1	28.0875	4.9338	  1.9

	1 3
	9.1	28.0875	4.9338	  0.8
	7.2	30.0875	19.4338	  0.8
	6.7	32.0875	27.4338	  0.8

	1 11
	9.1	28.0875	4.9338	  0.8
	5.7	29.5875	7.9338	  0.8
	1.7	32.5875	8.9338	  0.8
	-1.3	36.0875	10.4338	  0.8
	-3.3	41.0875	12.9338	  0.8
	-2.3	47.5875	17.4338	  0.8
	-0.3	52.0875	22.4338	  0.8
	2.2	55.5875	27.4338	  0.8
	4.2	56.5875	30.9338	  0.8
	5.7	58.0875	33.9338	  0.8
	6.7	59.5875	36.9338	  0.8

	1 12
	9	28.0875	4.9338	  0.8
	8.2	31.5875	7.9338	  0.8
	10.2	35.0875	11.9338	  0.8
	14.7	39.0875	13.9338	  0.8
	21.7	41.5875	14.9338	  0.8
	27.2	45.5875	14.4338	  0.8
	31.7	49.5875	14.4338	  0.8
	35.2	52.5875	14.9338	  0.8
	38.7	54.5875	15.4338	  0.8
	42.2	56.0875	17.9338	  0.8
	46.2	58.5875	20.9338	  0.8
	50.7	62.0875	25.9338	  0.8

	1 8
	8.9	28.0875	4.9338	  0.8
	9.7	32.0875	7.4338	  0.8
	13.2	35.5875	9.9338	  0.8
	18.7	39.0875	12.9338	  0.8
	24.7	43.0875	15.9338	  0.8
	31.2	48.0875	16.9338	  0.8
	38.2	52.5875	16.9338	  0.8
	45.7	56.0875	17.9338	  0.8

	1 3
	8.8	28.0875	4.9338	    1
	12.2	28.0875	8.9338	    1
	17.7	28.0875	12.9338	    1

	1 2
	17.7	28.0875	12.9338	 0.83
	22.2	27.0875	4.9338	 0.83

	1 8
	22.2	27.0875	4.9338	  0.8
	25.2	23.5875	1.9338	  0.8
	31.2	21.5875	-0.5662	  0.8
	37.7	21.5875	1.4338	  0.8
	43.7	23.5875	2.4338	  0.8
	50.2	24.0875	5.9338	  0.8
	57.2	24.0875	7.4338	  0.8
	64.7	22.5875	10.4338	  0.8

	1 7
	22.2	27.0875	4.9338	  0.8
	26.7	29.0875	7.9338	  0.8
	33.7	31.5875	7.4338	  0.8
	41.2	34.0875	2.9338	  0.8
	49.7	36.5875	2.4338	  0.8
	55.2	39.5875	-0.0662003	  0.8
	59.7	42.5875	-3.0662	  0.8

	1 4
	17.7	28.0875	12.9338	 0.83
	19.7	30.0875	11.9338	 0.83
	22.7	32.5875	10.4338	 0.83
	26.7	35.0875	8.9338	 0.83

	1 2
	26.7	35.0875	8.9338	 0.83
	26.8	35.0875	8.9338	 0.83

	1 13
	26.8	35.0875	8.9338	  0.8
	31.2	36.0875	8.9338	  0.8
	35.7	38.0875	10.4338	  0.8
	40.2	41.5875	10.4338	  0.8
	43.7	45.0875	8.9338	  0.8
	46.2	49.5875	6.4338	  0.8
	48.2	55.0875	6.4338	  0.8
	51.2	62.0875	10.4338	  0.8
	52.7	69.0875	11.4338	  0.8
	55.2	76.0875	15.4338	  0.8
	57.2	81.0875	16.9338	  0.8
	61.7	85.5875	22.4338	  0.8
	66.2	88.5875	23.4338	  0.8

	1 10
	26.8	35.0875	8.9338	  0.8
	30.7	37.5875	13.4338	  0.8
	34.7	40.0875	14.9338	  0.8
	39.2	42.5875	15.4338	  0.8
	45.7	44.0875	15.4338	  0.8
	52.7	45.0875	15.9338	  0.8
	58.7	45.0875	15.4338	  0.8
	63.7	44.5875	15.4338	  0.8
	69.2	46.0875	14.4338	  0.8
	75.7	50.0875	12.9338	  0.8

	1 14
	26.7	35.0875	8.9338	  0.8
	28.2	38.5875	10.4338	  0.8
	30.7	42.5875	11.9338	  0.8
	34.7	46.5875	12.9338	  0.8
	38.2	51.0875	13.9338	  0.8
	41.7	55.5875	15.9338	  0.8
	44.2	62.5875	18.9338	  0.8
	47.2	67.5875	22.4338	  0.8
	50.2	72.0875	26.9338	  0.8
	53.2	74.5875	30.9338	  0.8
	56.2	77.5875	33.9338	  0.8
	59.2	81.0875	34.9338	  0.8
	62.7	84.5875	34.9338	  0.8
	66.2	89.0875	33.9338	  0.8

	1 2
	8.7	28.0875	4.9338	  1.4
	9.7	29.0875	-3.0662	  1.4

	1 8
	9.7	29.0875	-3.0662	  0.8
	15.2	31.5875	-3.5662	  0.8
	21.7	34.0875	-5.0662	  0.8
	29.7	37.5875	-6.5662	  0.8
	35.7	41.0875	-7.0662	  0.8
	40.7	45.0875	-7.0662	  0.8
	42.7	49.0875	-7.0662	  0.8
	42.7	52.5875	-7.0662	  0.8

	1 5
	9.7	29.0875	-3.0662	  0.8
	12.7	35.0875	-7.0662	  0.8
	16.2	41.0875	-13.5662	  0.8
	17.2	44.5875	-24.0662	  0.8
	15.7	45.5875	-33.5662	  0.8

	1 2
	5.5	9.5	-13	    4
	12	16.5	-18.5	    4

	1 13
	12	16.5	-18.5	  0.8
	14.5	14	-19	  0.8
	18.5	12	-19.5	  0.8
	23	10.5	-19	  0.8
	28	9	-16	  0.8
	32	8	-13	  0.8
	36.5	6	-10	  0.8
	41	5	-13	  0.8
	44.5	3	-16	  0.8
	47.5	1.5	-20	  0.8
	50.5	2	-20	  0.8
	54	3.5	-25.5	  0.8
	57.5	6	-36	  0.8

	1 2
	12	16.5	-18.5	  3.3
	11.5	17.5	0	  3.3

	1 6
	11.5	17.5	0	 0.82
	9	18.5	0	 0.82
	6.5	21.5	0	 0.82
	3.5	26	0.5	 0.82
	1	32.5	3.5	 0.82
	-2	40.5	9	 0.82

	1 8
	-2	40.5	9	  0.8
	-0.5	46	8.5	  0.8
	0.5	51	9	  0.8
	4	56	9	  0.8
	7.5	61	9.5	  0.8
	11	64	9	  0.8
	13.5	64	9.5	  0.8
	15.5	63.5	10.5	  0.8

	1 13
	-2	40.5	9	 0.82
	-4	42.5	8.5	 0.82
	-7	44.5	7	 0.82
	-9.5	47.5	7.5	 0.82
	-13	50.5	9.5	 0.82
	-15.5	52.5	13	 0.82
	-17	54	16.5	 0.82
	-16.5	55	22	 0.82
	-15	56	26	 0.82
	-13	56.5	30.5	 0.82
	-10.5	56	32.5	 0.82
	-8	56	34.5	 0.82
	-6	57.5	34.5	 0.82

	1 2
	11.5	17.5	0	  2.7
	13.5	19	0	  2.7

	1 2
	13.5	19	0	  2.7
	13.6	19	0	  2.7

	1 3
	13.6	19	0	  1.5
	14	21.5	1.5	  1.5
	15	24	2.5	  1.5

	1 26
	15	24	2.5	  0.8
	12.5	25	2.5	  0.8
	11.5	27	2.5	  0.8
	11.5	30	3	  0.8
	13.5	35	3.5	  0.8
	15.5	40	4	  0.8
	18	44	4	  0.8
	21	47.5	4	  0.8
	25	50.5	4	  0.8
	29	55	4	  0.8
	33	59.5	4	  0.8
	36.5	63.5	4	  0.8
	40	68	7	  0.8
	43	72.5	11	  0.8
	46	76.5	16	  0.8
	47.5	80	18.5	  0.8
	48.5	84.5	21	  0.8
	50.5	88.5	22.5	  0.8
	52.5	92	24	  0.8
	55	94	26	  0.8
	56	97	27.5	  0.8
	57.5	100.5	29	  0.8
	58.5	105	29	  0.8
	59.5	110	29	  0.8
	60	115.5	29	  0.8
	61	121	29	  0.8

	1 18
	15	24	2.5	  0.8
	15	26.5	0.5	  0.8
	17	29.5	4.5	  0.8
	19	34	9	  0.8
	22.5	38.5	13.5	  0.8
	24.5	42.5	15.5	  0.8
	27.5	44.5	19.5	  0.8
	31.5	45	23.5	  0.8
	37.5	44.5	26.5	  0.8
	44	44.5	28.5	  0.8
	50	45	30.5	  0.8
	57.5	45.5	30.5	  0.8
	65	45.5	32	  0.8
	72.5	45	34	  0.8
	78.5	43.5	36	  0.8
	84	41.5	36	  0.8
	89	39	35.5	  0.8
	94.5	37.5	34.5	  0.8

	1 4
	13.6	19	0	  1.6
	17	24.5	-2.5	  1.6
	19	29	-3	  1.6
	20	32.5	-2.5	  1.6

	1 5
	20	32.5	-2.5	  0.8
	21	35	-2.5	  0.8
	24	38	-2.5	  0.8
	27.5	41	0	  0.8
	32.5	44	5	  0.8

	1 5
	32.5	44	5	  0.8
	36.5	45.5	4.5	  0.8
	42	48.5	4	  0.8
	47	52	4	  0.8
	51	55	4	  0.8

	1 4
	32.5	44	5	  0.8
	37	45	10	  0.8
	40	46	-1.5	  0.8
	42	47	-30.5	  0.8

	1 9
	20	32.5	-2.5	  0.8
	25	35	-1.5	  0.8
	30	38	-1.5	  0.8
	35.5	40.5	-2.5	  0.8
	41	42	-2.5	  0.8
	48	43.5	-2.5	  0.8
	54.5	45	-3	  0.8
	60.5	48	-3.5	  0.8
	65.5	52.5	-5	  0.8

	1 3
	13.5	19	0	    2
	15.5	19	0	    2
	18.5	20	0	    2

	1 2
	18.5	20	0	  1.6
	24.5	19	0	  1.6

	1 2
	24.5	19	0	  1.4
	24.6	19	0	  1.4

	1 22
	24.6	19	0	  0.8
	25.5	14.5	3	  0.8
	27	10	6	  0.8
	28	6.5	7.5	  0.8
	30.5	3.5	9	  0.8
	31.5	1	9	  0.8
	33	-0.5	9	  0.8
	34.5	-2	9	  0.8
	39	-2.5	10	  0.8
	45.5	-3	11.5	  0.8
	52.5	-3	13.5	  0.8
	58	-3	14	  0.8
	64	-4.5	15.5	  0.8
	69.5	-6	17	  0.8
	75.5	-9.5	15.5	  0.8
	80	-12.5	13	  0.8
	83.5	-16.5	10.5	  0.8
	87.5	-19.5	11	  0.8
	92	-23	12.5	  0.8
	96.5	-26	15.5	  0.8
	99	-29	15.5	  0.8
	99	-32.5	13	  0.8

	1 19
	24.6	19	0	  0.8
	28.5	19	1.5	  0.8
	32	19	2.5	  0.8
	35.5	19	2.5	  0.8
	38	18	6	  0.8
	41	18	6.5	  0.8
	43.5	19	7.5	  0.8
	47	21	5	  0.8
	50.5	23	5	  0.8
	56.5	23.5	6.5	  0.8
	63.5	25	8	  0.8
	70	26.5	9.5	  0.8
	75.5	28.5	7.5	  0.8
	80.5	30.5	7	  0.8
	86	33	7	  0.8
	91.5	33.5	10.5	  0.8
	96	34.5	12	  0.8
	100.5	35	14	  0.8
	105	36.5	13	  0.8

	1 16
	24.5	19	0	  0.8
	28	21	-1	  0.8
	33.5	22.5	-1	  0.8
	39	24	0	  0.8
	44	25	0	  0.8
	47.5	26.5	0	  0.8
	50.5	26.5	0	  0.8
	55.5	28	0	  0.8
	63	28.5	0	  0.8
	70	30.5	1	  0.8
	77	32.5	2.5	  0.8
	81.5	35.5	7	  0.8
	86.5	39	10	  0.8
	90.5	42.5	14	  0.8
	92.5	46	14	  0.8
	93	50	13	  0.8

	1 2
	18.5	20	0	  1.1
	19	22.5	0	  1.1

	1 11
	19	22.5	0	  0.8
	23	22.5	0	  0.8
	26	23.5	-0.5	  0.8
	28.5	25.5	-1.5	  0.8
	31.5	27	-2.5	  0.8
	35	28.5	-1.5	  0.8
	38.5	31	-0.5	  0.8
	40.5	34	-1	  0.8
	40	36.5	-8	  0.8
	39	38.5	-23	  0.8
	38	39	-44	  0.8

	1 4
	19	22.5	0	  0.8
	22.5	25	1.5	  0.8
	26.5	27.5	2.5	  0.8
	30.5	30.5	2.5	  0.8

	1 10
	30.5	30.5	2.5	  0.8
	33.5	32.5	3.5	  0.8
	36.5	35.5	4	  0.8
	39.5	39.5	4	  0.8
	43.5	44.5	7	  0.8
	49	47.5	10	  0.8
	54	51	13	  0.8
	60.5	53	13	  0.8
	64	57.5	12	  0.8
	67	63.5	10.5	  0.8

	1 25
	30.5	30.5	2.5	  0.8
	29	31	0.5	  0.8
	28.5	33	1.5	  0.8
	29.5	36	3	  0.8
	32.5	38.5	5	  0.8
	37	42.5	5	  0.8
	41	45.5	5	  0.8
	45	49	5	  0.8
	48	51.5	6	  0.8
	51.5	53	7	  0.8
	55.5	54.5	8	  0.8
	59.5	55.5	9.5	  0.8
	63.5	56.5	11	  0.8
	67	58.5	13	  0.8
	70.5	60.5	14	  0.8
	73.5	62.5	15	  0.8
	77.5	65	16	  0.8
	82.5	67	16.5	  0.8
	87	68.5	17.5	  0.8
	89.5	70	19	  0.8
	91.5	71.5	21.5	  0.8
	93	73.5	23.5	  0.8
	95.5	75	25	  0.8
	98.5	76.5	27	  0.8
	101.5	79.5	32	  0.8

	1 3
	1.5	3	-9	  3.7
	6	3.5	-9	  3.7
	7.5	4.5	-10	  3.7

	1 4
	7.5	4.5	-10	  1.6
	9.5	5	-10	  1.6
	13.5	8.5	-10	  1.6
	15.5	10	-9.5	  1.6

	1 2
	15.5	10	-9.5	  1.5
	15.6	10	-9.5	  1.5

	1 5
	15.6	10	-9.5	  0.8
	14	12	-9.5	  0.8
	15.5	14	-9.5	  0.8
	15.5	16	-9.5	  0.8
	13	18	-9	  0.8

	1 5
	13	18	-9	  0.8
	12	18.5	-9	  0.8
	10.5	19.5	-9	  0.8
	8.5	21.5	-9	  0.8
	7	23.5	-10	  0.8

	1 5
	13	18	-9	  0.8
	14.5	18	-8.5	  0.8
	14	19	-8.5	  0.8
	13	20.5	-8.5	  0.8
	11.5	20.5	-8.5	  0.8

	1 3
	15.6	10	-9.5	  0.8
	17.5	10	-7.5	  0.8
	20	10	-10.5	  0.8

	1 11
	20	10	-10.5	  0.8
	23.5	8.5	-10	  0.8
	30	7.5	-10	  0.8
	32	7	-10	  0.8
	32.5	5.5	-9	  0.8
	35	5.5	-9	  0.8
	37.5	4.5	-10.5	  0.8
	40.5	2.5	-10	  0.8
	43	1.5	-10	  0.8
	46	4.5	-10.5	  0.8
	50	6	-14.5	  0.8

	1 6
	20	10	-10.5	  0.8
	18	11.5	-10.5	  0.8
	12	12	-10	  0.8
	8.5	13	-10	  0.8
	6	16	-10	  0.8
	6	18	-11.5	  0.8

	1 20
	15.5	10	-9.5	  0.8
	18	9.5	-8	  0.8
	21	9	-8	  0.8
	24	8	-8	  0.8
	21.5	10	-8	  0.8
	20.5	11	-8	  0.8
	25.5	9.5	-8	  0.8
	30	8.5	-8	  0.8
	33.5	9	-8	  0.8
	38.5	8.5	-8	  0.8
	44.5	7.5	-8	  0.8
	51	7.5	-8	  0.8
	56	5.5	-8	  0.8
	63.5	6	-8	  0.8
	69	5.5	-7.5	  0.8
	75	7	-7	  0.8
	79.5	8.5	-7	  0.8
	85.5	6.5	-7	  0.8
	88	4	-7	  0.8
	89	0.5	-7	  0.8

	1 2
	7.5	4.5	-10	  4.7
	7.5	9.5	-3.5	  4.7

	1 2
	7.5	9.5	-3.5	  5.6
	7.6	9.5	-3.5	  5.6

	1 2
	7.6	9.5	-3.5	  5.6
	7.7	9.5	-3.5	  5.6

	1 2
	7.7	9.5	-3.5	  5.6
	7.8	9.5	-3.5	  5.6

	1 3
	7.8	9.5	-3.5	  1.6
	4	9.5	-3.5	  1.6
	1.5	8	-1.5	  1.6

	1 3
	7.8	9.5	-3.5	  1.8
	3.5	11.5	-3.5	  1.8
	2	13.5	-1.5	  1.8

	1 2
	7.7	9.5	-3.5	  3.1
	7.5	14.5	-1	  3.1

	1 11
	7.6	9.5	-3.5	 0.94
	11.5	9	-2.5	 0.94
	15	9	-2.5	 0.94
	19.5	8	-2.5	 0.94
	23	8	-2.5	 0.94
	25.5	9.5	-2.5	 0.94
	30.5	11.5	-2.5	 0.94
	35	13	-2.5	 0.94
	40.5	18.5	-2.5	 0.94
	45	21.5	-2.5	 0.94
	53.5	23	-2.5	 0.94

	1 3
	7.5	9.5	-3.5	  1.7
	12	11	-3.5	  1.7
	12.5	15.5	-1.5	  1.7


CONNECTIONS:


        0    1
        0    1

        0    1
        1    1
        2    1
        2    1
        1    1
        5    1
        5    1
        0    1
        8    1
        8    1
       10    1
       10    1

        0    1
        1    1
        1    1
        0    1
        4    1
        5    1
        5    1
        7    1
        8    1
        8    1
       10    1
       10    1
        7    1
        4    1
       14    1
       15    1
       16    1
       16    1
       15    1
       14    1


        0    1
        1    1
        2    1
        3    1
        3    1
        5    1
        5    1
        2    1
        8    1
        8    1
       10    1
       10    1
        1    1
       13    1
       14    1
       14    1
       16    1
       16    1
       13    1
        0    1
       20    1
       21    1
       22    1
       22    1
       21    1
       25    1
       25    1
       27    1
       27    1
       20    1

        0    1
        1    1
        1    1
        0    1
        4    1
        5    1
        5    1
        4    1

        0    1
        1    1
        2    1
        3    1
        4    1
        4    1
        3    1
        7    1
        7    1
        2    1
        1    1
       11    1
       11    1
        0    1
       14    1
       15    1
       16    1
       17    1
       17    1
       16    1
       15    1
       21    1
       21    1
       14    1
       24    1
       25    1
       25    1
       27    1
       27    1
       24    1
       30    1
       30    1

        0    1
        1    1
        2    1
        3    1
        4    1
        5    1
        5    1
        7    1
        8    1
        8    1
        7    1
       11    1
       12    1
       12    1
       11    1
        4    1
        3    1
        2    1
       18    1
       18    1
        1    1
        0    1
       22    1
       23    1
       23    1
       22    1
       26    1
       27    1
       28    1
       29    1
       30    1
       30    1
       29    1
       28    1
       27    1
       35    1
       36    1
       36    1
       35    1
       39    1
       40    1
       40    1
       39    1
       26    1
       44    1
       44    1

        0    1
        0    1
        2    1
        3    1
        3    1
        2    1
        6    1
        7    1
        8    1
        8    1
        7    1
       11    1
       12    1
       12    1
       11    1
        6    1
       16    1
       17    1
       18    1
       18    1
       17    1
       16    1
       22    1
       22    1
       24    1
       24    1

        0    1
        1    1
        2    1
        3    1
        3    1
        2    1
        6    1
        6    1
        1    1
        0    1
       10    1
       11    1
       12    1
       13    1
       13    1
       12    1
       11    1
       10    1


/*----------------------------------------------------------------*/
proc geometry() { 

	/* NULL geometry procedure: keeps the user from
	calling the geometry procedure in isolation. */

    printf("\nYou must re-read the entire geometry\n")
    printf("file to execute geometry().\n\n")
}
