#include <cstdlib>
#include <iostream>

using namespace std;

#include <cstdlib>
#include <iostream>
#include "math.h"
#include "function.h"

using namespace std;

#define MAXDOTS 5000


int main(int argc, char *argv[])
{
    int i,j,k,n;
    double f[10][MAXDOTS];
    double g[10][MAXDOTS];
    double h[10][MAXDOTS];
    double t[MAXDOTS];
    
    double x;
    int N=5;
    FILE *F;    
    char buff[10000];
    int flag;
    
   
    // This script is used to construct spike time difference maps


    // Read the content of "strc_OO.out" into a 2-dimensional array "f"
    F = fopen("strc_OO.out","r");
    k=0;
    while(!feof(F)) {
        fgets(buff,1000,F);
        if(buff[0]==0) break;
        sscanf(buff,"%lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf",&t[k],
		&f[0][k],&f[1][k],&f[2][k],&f[3][k],&f[4][k],&f[5][k],&f[6][k],&f[7][k],&f[8][k],&f[9][k]);
        k++;
    }
    fclose(F);    

    
    // Transform the PRC into a psi-function (see text)
    for(n=0;n<10;n++)  {
        for(i=0;i<k;i++) {
            f[n][i] = 1 + f[n][i] - t[i];
        }
    }
    

    // Superimpose psi-functions to get STDM
    for(n=0;n<10;n++)  {
        superimpose(k,t,f[n],f[n],g[n]);
    }
    
    // Subtract delta to get the F_OO function (see text)
    for(n=0;n<10;n++)  {
        for(i=0;i<k;i++) {
            g[n][i] = g[n][i] - t[i];
        }
    }

    // Save the result in the "stdm_OO.out" file
    F = fopen("stdm_OO.out","w");
    for(i=0;i<k;i++) {
        fprintf(F,"%2.4lf\t",t[i]);
        for(n=0;n<10;n++)  {
            fprintf(F,"%2.4lf\t",g[n][i]);
        }
        fprintf(F,"\n");
    }
    fclose(F);
 
    // Similarly, this piece computes F_OI and F_IO STDMs
    F = fopen("strc_IO.out","r");
    k=0;
    while(!feof(F)) {
        fgets(buff,1000,F);
        if(buff[0]==0) break;
        sscanf(buff,"%lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf",
			&t[k],&f[0][k],&f[1][k],&f[2][k],&f[3][k],&f[4][k],&f[5][k],&f[6][k],&f[7][k],&f[8][k],&f[9][k]);
        k++;
    }
    fclose(F);    

    F = fopen("strc_OI.out","r");
    k=0;
    while(!feof(F)) {
        fgets(buff,1000,F);
        sscanf(buff,"%lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf",
			&t[k],&g[0][k],&g[1][k],&g[2][k],&g[3][k],&g[4][k],&g[5][k],&g[6][k],&g[7][k],&g[8][k],&g[9][k]);
        if(buff[0]==0) break;
        k++;
    }
    fclose(F);    

      
    for(n=0;n<10;n++)  {
        for(i=0;i<k;i++) {
            f[n][i] = 1 + f[n][i] - t[i];
            g[n][i] = 1 + g[n][i] - t[i];
        }
    }

    superimpose(k,t,f[0],g[2],h[0]);
    superimpose(k,t,f[5],g[2],h[1]);
    superimpose(k,t,f[9],g[2],h[2]);

    
    for(n=0;n<3;n++)  {
        for(i=0;i<k;i++) {
            h[n][i] = h[n][i] - t[i];
        }
    }


    F = fopen("stdm_IO.out","w");
    for(i=0;i<k;i++) {
        fprintf(F,"%2.4lf\t",t[i]);
        for(n=0;n<3;n++)  {
            fprintf(F,"%2.4lf\t",h[n][i]);
        }
        fprintf(F,"\n");
    }
    fclose(F);

    //Similarly, this piece computes PING-to-O STDMs
    F = fopen("strc_EIO.out","r");
    k=0;
    while(!feof(F)) {
        fgets(buff,1000,F);
        if(buff[0]==0) break;
        sscanf(buff,"%lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf",
		&t[k],&f[0][k],&f[1][k],&f[2][k],&f[3][k],&f[4][k],&f[5][k],&f[6][k],&f[7][k],&f[8][k],&f[9][k]);
        k++;
    }
    fclose(F);   
    
    
    F = fopen("strc_OE.out","r");
    k=0;
    while(!feof(F)) {
        fgets(buff,1000,F);
        sscanf(buff,"%lf %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf",
		&t[k],&g[0][k],&g[1][k],&g[2][k],&g[3][k],&g[4][k],&g[5][k],&g[6][k],&g[7][k],&g[8][k],&g[9][k]);
        if(buff[0]==0) break;
        k++;
    }
    fclose(F);     

    for(n=0;n<10;n++)  {
        for(i=0;i<k;i++) {
            f[n][i] = 1 + f[n][i] - t[i];
            g[n][i] = 1 + g[n][i] - t[i];
        }
    }


    for(n=0;n<10;n++)  {
        superimpose(k,t,f[n],g[2],h[n]);
    }
    
    for(n=0;n<10;n++)  {
        for(i=0;i<k;i++) {
            h[n][i] = h[n][i] - t[i];
        }
    }

    F = fopen("stdm_EIO.out","w");
    for(i=0;i<k;i++) {
        fprintf(F,"%2.4lf\t",t[i]);
        for(n=0;n<10;n++)  {
            fprintf(F,"%2.4lf\t",h[n][i]);
        }
        fprintf(F,"\n");
    }
    fclose(F);

}
