#include "models.h"

double HodgkinHuxley::mnh(double x[], double y[]) {
  double J_Na, J_K, J_L;
  double aln, ben, alm, bem, alh, beh;
    
  aln =  0.032*5*THETA((V(x)+52)/5);
  ben =  0.5*EXP(-(V(x)+57)/40);
  alm =  0.32*4*THETA((V(x)+54)/4);
  bem =  0.28*5*THETA(-(V(x)+27)/5);
  alh = .128*EXP(-(V(x)+50)/18);
  beh = 4/(EXP(-(V(x)+27)/5)+1);
    
  M(y) = alm*(1-M(x))-bem*M(x);
  N(y) = aln*(1-N(x))-ben*N(x);
  H(y) = alh*(1-H(x))-beh*H(x);
  
  J_Na = gNa*M(x)*M(x)*M(x)*H(x)*(V(x) - VNa );
  J_K  = gK*N(x)*N(x)*N(x)*N(x)*(V(x) - VK);
  J_L  = gL*(V(x) - VL);
  return(J_Na + J_K + J_L);
}

double OlufsenEcell::mnh(double x[], double y[]) {
    double J_Na, J_K, J_L;                

    double tauh,hinf,taum,minf,taun,ninf;

    tauh=1/(0.128*EXP(-(V(x)+50)/18)+4/(1+EXP(-(V(x)+27)/5)));
    hinf=0.128*EXP(-(V(x)+50)/18)*tauh;

    taum=1/(0.32*(54+V(x))/(1-EXP(-(V(x)+54)/4))+0.28*(V(x)+27)/(EXP((V(x)+27)/5)-1));
    minf=0.32*(54+V(x))/(1-EXP(-(V(x)+54)/4))*taum;

    taun=1/(0.032*(V(x)+52)/(1-EXP(-(V(x)+52)/5))+0.5*EXP(-(57+V(x))/40));
    ninf=0.032*(V(x)+52)/(1-EXP(-(V(x)+52)/5))*taun;

    M(y) = (minf-M(x))/taum;
    N(y) = (ninf-N(x))/taun;
    H(y) = (hinf-H(x))/tauh;
    
    J_Na = gNa*M(x)*M(x)*M(x)*H(x)*(V(x) - VNa );
    J_K  = gK*N(x)*N(x)*N(x)*N(x)*(V(x) - VK);
    J_L  = gL*(V(x) - VL);
    return(J_Na + J_K + J_L);
}

double WangBuzsakiBasket::mnh(double x[], double y[]) {
    double J_Na, J_K, J_L;   
    double phi=5;             

    double alh,beh,alm,bem,aln,ben;

    alh= 0.07*EXP(-(V(x)+58)/20);
    beh= 1/(EXP(-0.1*(V(x)+28))+1);
    
    alm = -0.1*(V(x)+35)/(EXP(-0.1*(V(x)+35))-1);
    bem = 4*exp(-(V(x)+60)/18);
    
    aln = -0.01*(V(x)+34)/(EXP(-0.1*(V(x)+34))-1);
    ben = 0.125*EXP(-(V(x)+44)/80);


 //  M(y) = alm*(1-M(x)) - bem*M(x);
    N(y) = phi*(aln*(1-N(x)) - ben*N(x));
    H(y) = phi*(alh*(1-H(x)) - beh*H(x));
    
    
    J_Na = gNa*M(x)*M(x)*M(x)*H(x)*(V(x) - VNa );
    J_K  = gK*N(x)*N(x)*N(x)*N(x)*(V(x) - VK);
    J_L  = gL*(V(x) - VL);
    
    M(x) = alm/(alm + bem); // Reduction: m-variable is infinitely fast
    M(y) = 0;               //
    return(J_Na + J_K + J_L);
}


double SaragaOLM::mnh(double x[], double y[]) {
  double J_Na, J_K, J_L;
  double aln, ben, alm, bem, alh, beh;

  alm =  -0.1*(V(x)+38)/(EXP(-0.1*(V(x)+38))-1);
  bem = 4*EXP(-(V(x)+65)/18);
  aln= 0.018*(V(x)-25)/(1-EXP(-(V(x)-25)/25));
  ben= 0.0036*(V(x)-35)/(EXP((V(x)-35)/12)-1);
  alh=0.07*EXP(-(V(x)+63)/20);
  beh=1/(1+EXP(-0.1*(V(x)+33)));

  M(y) = alm*(1-M(x))-bem*M(x);
  N(y) = aln*(1-N(x))-ben*N(x);
  H(y) = alh*(1-H(x))-beh*H(x);

  J_Na = gNa*M(x)*M(x)*M(x)*H(x)*(V(x) - VNa );
  J_K  = gK*N(x)*N(x)*N(x)*N(x)*(V(x) - VK);
  J_L  = gL*(V(x) - VL);
  return(J_Na + J_K + J_L);

}

double SaragaOLM::other(double x[], double y[]) {
  double ainf,taua,binf,taub,rinf,taur;
  double J_h,J_A;

  ainf=1/(1+EXP(-(V(x)+14)/16.6));
  taua=5;
  binf=1/(1+EXP((V(x)+71)/7.3));
  taub=1/(0.000009/EXP((V(x)-26)/18.5)+0.014/(0.2+EXP(-(V(x)+70)/11)));
  rinf=1/(1+EXP((V(x)+84)/10.2));
  taur=1/(EXP(-14.59-0.086*V(x))+EXP(-1.87+0.0701*V(x)));

  J_h=gh*SR(x)*(V(x)-Vh);
  J_A=ga*SA(x)*SB(x)*(V(x)-VA);

  SR(y) = (rinf-SR(x))/taur;
  SA(y) = (ainf-SA(x))/taua;
  SB(y) = (binf-SB(x))/taub;
  x[8] = J_A+J_h; y[8]=0;
  return(J_h + J_A);
}

