#include "neuron.h"


class HodgkinHuxley : public Neuron {
 public:
  double VL, gL, VK, gK, VNa, gNa;
  HodgkinHuxley(int n) : Neuron(n) {
    VL   = -67;
    gL   =  0.1;
    VK   = -100;
    gK   =  80;
    VNa  =  50;
    gNa  =  100;
    I_app =  1;
    C    =  1;
    als  =  50;
    bes  =  0.33;
    setHeterogeneity(0);
  }
  double mnh(double x[], double y[]);		// these are standard m, n, and h gates
  double mnhCorey(double x[], double y[]);	// I don't know why i put it here but let it be
  void f(double x[], double y[]) {
    I_ion = HodgkinHuxley::mnh(x,y); 			// We first calculate ionic curr (synaptic currects have been calculated)
    Neuron::f(x,y);				// and calculate the right hand side
  }
};

class OlufsenEcell : public Neuron {
 public:
  double VL, gL, VK, gK, VNa, gNa;
  OlufsenEcell(int n) : Neuron(n) {
             
    C = 1;               // muF/cm^2
    VNa  = 50;           // Na Nernst potential, mV
    VK   = -100;         // K Nernst potential, mV
    VL   = -67;          // Leak reversal potential, mV

    gNa  = 100;          // max Na conductance, mS/cm^2
    gK   = 80;          // max K conductance, mS/cm^2
    gL   = 0.1;          // FIXED leak conductance, mS/cm^2
             
             

    I_app =  1;

    E_rev = 0;          // reversal potential for the inhibition, mV
    als=1/0.1;
    bes=1/3.1;
  }
  double mnh(double x[], double y[]);		    // these are standard m, n, and h gates
  void f(double x[], double y[]) {
    I_ion = OlufsenEcell::mnh(x,y); 		// We first calculate ionic curr (synaptic currects have been calculated)
    Neuron::f(x,y);			                           	// and calculate the right hand side
  }
};


class WangBuzsakiBasket: public Neuron {
 public:
  double VL, gL, VK, gK, VNa, gNa;
  WangBuzsakiBasket(int n) : Neuron(n) {
             
    C = 1;               // muF/cm^2
    VNa  = 55;           // Na Nernst potential, mV
    VK   = -90;         // K Nernst potential, mV
    VL   = -65;          // Leak reversal potential, mV

    gNa  = 35;          // max Na conductance, mS/cm^2
    gK   = 9;          // max K conductance, mS/cm^2
    gL   = 0.1;          // FIXED leak conductance, mS/cm^2
             
             

    I_app =  1;

    E_rev = -80;          // reversal potential for the inhibition, mV
    als=1/0.25;
    bes=1/9.0;
  }
  double mnh(double x[], double y[]);		    // these are standard m, n, and h gates
  void f(double x[], double y[]) {
    I_ion = WangBuzsakiBasket::mnh(x,y); 		// We first calculate ionic curr (synaptic currects have been calculated)
    Neuron::f(x,y);			                           	// and calculate the right hand side
  }
};




class SaragaOLM : public Neuron {
 public:
   double VL, gL, VK, gK, VNa, gNa;
   double Vh, gh, VA,ga;

   SaragaOLM(int n) : Neuron(n) {
     C=1.3;
     I_app = 0;
     VL   = -70; gL   =  0.05;
     VK   = -100; gK   =  23;
     VNa  =  90; gNa  =  30;
     Vh   = -32.9; gh   =  12;
     VA   =  -90; ga = 16;

     als = 1/0.2;
     bes = 1/19.9;
     E_rev = -80;
     
  
   };
   double mnh(double x[], double y[]);
   double other(double x[], double y[]);
   void f(double x[], double y[]) {
     I_ion = SaragaOLM::mnh(x,y) + SaragaOLM::other(x,y);
     Neuron::f(x,y);
   }
};
